// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

/// An arrival to denote some external event.
#[derive(Debug, PartialEq, PartialOrd, Clone)]
pub struct Arrival<T> {

    /// The data received with the event.
    pub val: T,

    /// The simulation time at which the event has arrived.
    pub time: f64,

    /// The delay time which has passed from the time of
    /// arriving the previous event.
    pub delay: Option<f64>
}
