// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//! This crate is a part of discrete event simulation framework DVCompute Simulator (registration
//! number 2021660590 of Rospatent). The crate implements the network interface, which is meant
//! to be built on top of some MPI implementation that you are going to use within distributed
//! simulation. But you are not obliged to use MPI, though.
//!
//! In general, there are the following main crates: `dvcompute` (for sequential simulation),
//! `dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
//! `dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
//! `dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
//! very close. They are based on the same method.
//!
//! It is expected that the `dvcompute_mpi` dynamic (shared) library can be found by the operating
//! system, when launching the executable file of the simulation model. You can build the `dvcompute_mpi`
//! library yourself from <https://github.com/dsorokin/dvcompute/tree/main/src/dvcompute_mpi_cdylib> sources
//! that require CMake, C++ compiler and some MPI implementation that you are going to use.
//! Because of specific MPI implementation, this library cannot be unified. The library obeys
//! the predefined binary interface that you can implement yourself in theory, which means that
//! MPI is not actually obligatory.

extern crate libc;

/// The network utilities.
pub mod network;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
    }
}
