// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//! This crate is a part of discrete event simulation framework DVCompute Simulator (registration
//! number 2021660590 of Rospatent). The `dvcompute_gpss_dist` crate defines a GPSS-like DSL for
//! optimistic distributed simulation, but the same code base is shared by the `dvcompute_gpss_branch`
//! crate destined for nested simulation.
//!
//! The DSL language implements analogs of the following blocks: PREEMT, RETURN, ASSEMBLE, GATHER,
//! SPLIT, TRANSFER and others. The SELECT block is naturally expressed as a composition of computations.
//! There are analogs of the facility and storage entities.
//!
//! In general, there are the following main crates: `dvcompute` (for sequential simulation),
//! `dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
//! `dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
//! `dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
//! very close. They are based on the same method.
//!
//! In the case of optimistic distributed simulation, you must satisfy the requirements that
//! the `dvcompute_core_dist` crate imposes regarding the dynamic (shared) libraries.
//!
//! You can find examples in the author's repository: <https://github.com/dsorokin/dvcompute/samples>.
//!
//! The simulation method is described in the author's article:
//! Sorokin David. DVCompute Simulator for discrete event simulation.
//! Prikladnaya informatika=Journal of Applied Informatics, 2021, vol.16, no.3, pp.93-108 (in Russian).
//! DOI: 10.37791/2687-0649-2021-16-3-93-108

extern crate dvcompute_utils;
extern crate dvcompute_dist;

/// The main simulation module.
pub mod simulation;

/// The prelude module.
pub mod prelude;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
    }
}
