# dvcompute_gpss

This crate is a part of discrete event simulation framework DVCompute Simulator (registration
number 2021660590 of Rospatent). The `dvcompute_gpss` crate defines a GPSS-like DSL for
sequential simulation, but the same code base is shared by the `dvcompute_gpss_cons` crate
destined for conservative distributed simulation.

The DSL language implements analogs of the following blocks: PREEMT, RETURN, ASSEMBLE, GATHER,
SPLIT, TRANSFER and others. The SELECT block is naturally expressed as a composition of computations.
There are analogs of the facility and storage entities.

In general, there are the following main crates: `dvcompute` (for sequential simulation),
`dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
`dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
`dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
very close. They are based on the same method.

## Examples

You can find examples in the author's [repository](https://github.com/dsorokin/dvcompute).

## Documentation

* [API docs](https://docs.rs/dvcompute_gpss/)

## Bibliography

* Sorokin David. DVCompute Simulator for discrete event simulation.
  Prikladnaya informatika=Journal of Applied Informatics, 2021, vol.16, no.3, pp.93-108 (in Russian).
  DOI: 10.37791/2687-0649-2021-16-3-93-108

## Licence

Copyright 2020-2022 David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia

This software is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at <http://mozilla.org/MPL/2.0/>.
