// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use std::path::*;
use std::result;

use dvcompute_dist::simulation;

/// Resolve the file path.
pub fn resolve_file_path(path: &Path) -> simulation::Result<Box<Path>> {
    let buf0 = path.to_path_buf();
    if buf0.exists() {
        match buf0.file_name().and_then(|x| { x.to_str() }) {
            None => {
                let msg = String::from("The experiment file path is illegal");
                result::Result::Err(simulation::error::Error::panic(msg))
            },
            Some(file_name0) => {
                let mut i = 1;
                loop {
                    let file_name = format!("{} ({})", file_name0, i);
                    let buf = buf0.with_file_name(file_name);
                    if buf.exists() {
                        i = i + 1;
                    } else {
                        return result::Result::Ok(buf.into_boxed_path())
                    }
                }
            }
        }
    } else {
        result::Result::Ok(buf0.into_boxed_path())
    }
}
