// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//! This crate is a part of discrete event simulation framework DVCompute Simulator (registration
//! number 2021660590 of Rospatent). The `dvcompute_experiment_dist` crate defines simulation
//! experiments for optimistic distributed simulation, but the same code base is shared by
//! the `dvcompute_experiment_branch` crate destined for nested simulation.
//!
//! There are the following main crates: `dvcompute` (for sequential simulation),
//! `dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
//! `dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
//! `dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
//! very close. They are based on the same method.
//!
//! You can find examples in the author's repository: <https://github.com/dsorokin/dvcompute>.

#[cfg(feature="dist_mode")]
extern crate log;

extern crate urlencoding;

#[cfg(feature="branch_mode")]
extern crate rayon;

extern crate dvcompute_dist;
extern crate dvcompute_results_dist;

#[cfg(feature="dist_mode")]
extern crate dvcompute_network;

/// The main simulation module.
pub mod simulation;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
    }
}
