// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use std::io;
use std::result;

use dvcompute::simulation;

/// Convert the result value.
pub fn convert_result<T>(x: io::Result<T>) -> simulation::Result<T> {
    match x {
        result::Result::Ok(a) => result::Result::Ok(a),
        result::Result::Err(e) => result::Result::Err(simulation::error::Error::io(e))
    }
}
