// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use libc::*;

use crate::simulation::event::*;
use crate::simulation::observable::observer::*;

/// Represents the input message queue.
pub type InputMessageQueue = c_void;

#[cfg_attr(windows, link(name = "dvcompute_core_dist.dll"))]
#[cfg_attr(not(windows), link(name = "dvcompute_core_dist"))]
extern {

    /// Create a new input message queue.
    #[doc(hidden)]
    pub fn create_extern_input_message_queue() -> *mut InputMessageQueue;

    /// Delete the input message queue.
    #[doc(hidden)]
    pub fn delete_extern_input_message_queue(queue: *mut InputMessageQueue);

    /// Subscribe to input messages.
    #[doc(hidden)]
    pub fn subscribe_to_extern_input_messages(queue: *mut InputMessageQueue, observer: ObserverRepr) -> DisposableEventRepr;
}
