// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use std::fmt;
use std::fmt::Display;

use libc::*;

/// The network rank.
pub type Rank = c_int;

/// The logical process identifier.
#[derive(PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Serialize, Deserialize, Debug)]
pub struct LogicalProcessId {

    /// The rank of the logical process.
    rank: Rank
}

impl LogicalProcessId {

    /// Create a new logical process identifier.
    pub fn new(rank: Rank) -> Self {
        LogicalProcessId { rank: rank }
    }

    /// Get the rank of the logical process.
    pub fn rank(&self) -> Rank {
        self.rank
    }
}

impl Display for LogicalProcessId {

    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "LP{}", self.rank)
    }
}
