# dvcompute_dist

This crate is a part of discrete event simulation framework DVCompute Simulator (registration
number 2021660590 of Rospatent). The `dvcompute_dist` crate is destined for optimistic
distributed simulation, but the same code base is shared by the `dvcompute_branch` crate destined for nested simulation.

There are the following main crates: `dvcompute` (for sequential simulation),
`dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
`dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
`dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
very close. They are based on the same method.

## Requirements

In the case of optimistic distributed simulation, it is expected that the `dvcompute_mpi`
and `dvcompute_core_dist` dynamic (shared) libraries can be found by the operating system, when
launching the executable file of the simulation model. You can build the `dvcompute_mpi`
library yourself from the [sources](https://github.com/dsorokin/dvcompute/tree/main/src/dvcompute_mpi_cdylib)
that require CMake, C++ compiler and some MPI implementation that you are going to use.
Because of specific MPI implementation, this library cannot be unified. But
the `dvcompute_core_dist` dynamic library must satisfy the predefined binary
interface (it must implement the event queue). You can download the trial version that
implements this interface from the author's website <https://aivikasoft.com>.
This prebuilt version is a part of "Redistributable Code" portions of DVCompute Simulator.

## Examples

You can find examples in the author's [repository](https://github.com/dsorokin/dvcompute).

## Documentation

* [API docs](https://docs.rs/dvcompute_dist/)

## Tutorial

Also you can read the PDF document [DVCompute Simulator Tutorial](https://github.com/dsorokin/dvcompute/raw/main/doc/dvcompute-tutorial.pdf).

## Bibliography

* Sorokin David. DVCompute Simulator for discrete event simulation.
  Prikladnaya informatika=Journal of Applied Informatics, 2021, vol.16, no.3, pp.93-108 (in Russian).
  DOI: 10.37791/2687-0649-2021-16-3-93-108

## Tools

Also you can use the author's tool DVCompute Modeler for fast prototyping of your future models.
The tool is available on the <https://aivikasoft.com> web site. It allows creating
discrete event models and queue network models with help of the Python programming language.
The tool is available for Windows, Linux and macOS from the author's web site. Then such
models can be directly translated into Rust with help of DVCompute Simulator.

## Licence

Copyright 2020-2022 David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia

This software is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at <http://mozilla.org/MPL/2.0/>.
