// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use libc::*;

/// Represents the transient message queue.
pub type TransientMessageQueue = c_void;

#[cfg_attr(windows, link(name = "dvcompute_core_dist.dll"))]
#[cfg_attr(not(windows), link(name = "dvcompute_core_dist"))]
extern {

    /// Create a new transient message queue.
    #[doc(hidden)]
    pub fn create_extern_transient_message_queue() -> *mut TransientMessageQueue;

    /// Delete the transient message queue.
    #[doc(hidden)]
    pub fn delete_extern_transient_message_queue(queue: *mut TransientMessageQueue);
}
