// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use libc::*;

use crate::simulation::Point;
use crate::simulation::utils::byte_vec::ByteVecRepr;

/// Represents the output message queue.
pub type OutputMessageQueue = c_void;

#[cfg_attr(windows, link(name = "dvcompute_core_cons.dll"))]
#[cfg_attr(not(windows), link(name = "dvcompute_core_cons"))]
extern {

    /// Create a new output message queue.
    #[doc(hidden)]
    pub fn create_extern_output_message_queue() -> *mut OutputMessageQueue;

    /// Delete the output message queue.
    #[doc(hidden)]
    pub fn delete_extern_output_message_queue(queue: *mut OutputMessageQueue);

    /// Send the specified message within the simulation run.
    #[doc(hidden)]
    pub fn extern_send(receiver_id: c_int, receive_time: f64, vec: ByteVecRepr, p: *const Point);
}
