// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

mod point;
pub use self::point::Point;

mod specs;
pub use self::specs::Specs;

mod run;
pub use self::run::Run;

mod result;
pub use self::result::Result;

/// The type of errors that may arise during simulation.
pub mod error;

/// The random number generator.
pub mod generator;

/// A mutable reference computation.
pub mod ref_comp;

/// The `Parameter` computation to define external parameters.
pub mod parameter;

/// The `Simulation` computation as a function of run.
pub mod simulation;

/// The `Event` computation synchronized with the event queue.
pub mod event;

/// The `Observable` computation that allows notifying about events.
pub mod observable;

/// The `Process` computation to represent discontinuous processes.
pub mod process;

/// The `Composite` trait to create disposable computations.
pub mod composite;

/// The `Stream` type to represent infinite streams.
pub mod stream;

/// The queue strategies.
pub mod strategy;

/// The resources.
pub mod resource;

/// A communication part of the logical process.
#[cfg(feature="dist_mode")]
pub mod comm;

/// The queues.
pub mod queue;

/// Definitions related to nested simulation.
#[cfg(any(feature="branch_mode", feature="branch_wasm_mode"))]
pub mod branch;

/// The utilities used in the simulation library.
#[doc(hidden)]
pub mod utils;

/// The internal details of implementation.
#[doc(hidden)]
pub mod internal;
