// Copyright (c) 2020-2022  David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

use crate::simulation::generator::GeneratorType;

/// It represents the simulation specs.
#[derive(Clone)]
pub struct Specs {

    /// The start simulation time.
    pub start_time: f64,

    /// The final simulation time.
    pub stop_time: f64,

    /// The integration time step.
    pub dt: f64,

    /// The type of random number generator.
    pub generator_type: GeneratorType
}

/// It represents the simulation specs representation.
#[repr(C)]
#[derive(Clone)]
pub struct SpecsRepr {

    /// The start simulation time.
    pub start_time: f64,

    /// The final simulation time.
    pub stop_time: f64,

    /// The integration time step.
    pub dt: f64
}

impl From<Specs> for SpecsRepr {

    fn from(specs: Specs) -> Self {
        SpecsRepr {
            start_time: specs.start_time,
            stop_time: specs.stop_time,
            dt: specs.dt
        }
    }
}
