# dvcompute_branch

This crate is a part of discrete event simulation framework DVCompute Simulator (registration
number 2021660590 of Rospatent). The `dvcompute_branch` crate is destined for nested simulation,
but the same code base is shared by the `dvcompute_dist` crate destined for optimistic
distributed simulation.

There are the following main crates: `dvcompute` (for sequential simulation),
`dvcompute_dist` (for optimistic distributed simulation - from multicore computers till supercomputers),
`dvcompute_cons` (for conservative distributed simulation - from multicore computers till supercomputers) and
`dvcompute_branch` (for nested simulation - theory of games, estimation of the optimal strategy). All four crates are
very close. They are based on the same method.

## Examples

You can find examples in the author's [repository](https://github.com/dsorokin/dvcompute/samples).

## Documentation

* [API docs](https://docs.rs/dvcompute_branch/)

## Tutorial

Also you can read the PDF document [DVCompute Simulator Tutorial](https://github.com/dsorokin/dvcompute/doc/dvcompute-tutorial.pdf).

## Bibliography

* Sorokin David. DVCompute Simulator for discrete event simulation.
  Prikladnaya informatika=Journal of Applied Informatics, 2021, vol.16, no.3, pp.93-108 (in Russian).
  DOI: 10.37791/2687-0649-2021-16-3-93-108

## Tools

Also you can use the author's tool DVCompute Modeler for fast prototyping of your future models.
The tool is available on the <https://aivikasoft.com> web site. It allows creating
discrete event models and queue network models with help of the Python programming language.
The tool is available for Windows, Linux and macOS from the author's web site. Then such
models can be directly translated into Rust with help of DVCompute Simulator.

## Licence

Copyright 2020-2022 David Sorokin <david.sorokin@gmail.com>, based in Yoshkar-Ola, Russia

This software is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at <http://mozilla.org/MPL/2.0/>.
