# Contributing to Dusk-Poseidon

All of the code under this repository is licensed under the
Mozilla Public License Version 2.0.

If you have questions or comments, please feel free to email the
authors listed [here](https://github.com/dusk-network/Poseidon252/blob/master/Cargo.toml#L4). 

For feature requests, suggestions, and bug reports, please open an issue on
[our Github](https://github.com/dusk-network/Poseidon252).  (Or, send us
an email if you're opposed to using Github for whatever reason.)

Patches are welcomed as pull requests on
[our Github](https://github.com/dusk-network/Poseidon252), as well as by
email (preferably sent to all of the authors listed in `Cargo.toml`).

If you want to work on an issue, please let us know in the comments of it and
we will assign it to you.

If you're new to this repository and you want to contribute, you can
look for the issues tagged the with `good first issue` label. We try to add this tag
to the issues we belive are easy for newcomers.

If you need any help regarding an issue feel free to ask the authors in the `Draft pull request`
or the issue (or by email if you prefer it by any reason.)

# Pull Requests

- Keep your pull requests as `Draft` until they are ready to be reviewed.

- Be descriptive in the titles of your PRs and also provide good descriptions about
which things are being added, changed, fixed or removed also addressing the corresponding
issue that it is addressing to. 
See [How to Write a Git Commit Message]( https://chris.beams.io/posts/git-commit/) for more info.

- Any pull request that it's not passing our CI tests & builds will not be merged. 
This implies incorrect formatting errors, compilation errors, clippy lints, or any
other kind of inconsistency with your code.

- Do not open PRs that are not linked or related to a previously opened issue. 

- Update the `Unreleased` section of the [CHANGELOG](https://github.com/dusk-network/Poseidon252/blob/master/CHANGELOG.md)
if your PR includes anything that it's worth to be noticed in there. Avoid adding things
like doc-nitpicks and similar changes which do not affect directly any added,
fixed, removed or changed feature.

# Code of Conduct

We follow the [Rust Code of Conduct](http://www.rust-lang.org/conduct.html):

* We are committed to providing a friendly, safe and welcoming environment for all, regardless 
of level of experience, gender identity and expression, sexual orientation, disability, personal 
appearance, body size, race, ethnicity, age, religion, nationality, or other similar characteristic.

* Please avoid using overtly sexual aliases or other nicknames that might detract from a friendly, 
safe and welcoming environment for all.

* Please be kind and courteous. There’s no need to be mean or rude.

* Respect that people have differences of opinion and that every design or implementation choice carries 
a trade-off and numerous costs. There is seldom a right answer.

* Please keep unstructured critique to a minimum. If you have solid ideas you want to experiment with, make a fork and see how it works.

* We will exclude you from interaction if you insult, demean or harass anyone. That is not welcome behavior. We interpret the term “harassment” as including the definition in the Citizen Code of Conduct; if you have any lack of clarity about what might be included in that concept, please read their definition. In particular, we don’t tolerate behavior that excludes people in socially marginalized groups.

* Private harassment is also unacceptable. No matter who you are, if you feel you have been or are being harassed or made uncomfortable by a community member, please contact one of the channel ops or any of the Rust moderation team immediately. Whether you’re a regular contributor or a newcomer, we care about making this community a safe place for you and we’ve got your back.

* Likewise any spamming, trolling, flaming, baiting or other attention-stealing behavior is not welcome.

