use regex::Regex;

pub fn does_not_match_any(checking: &str, regexes: &[Regex]) -> bool {
    for regex in regexes {
        if regex.is_match(checking) {
            return false;
        }
    }

    true
}

pub fn get_regexes(regexes: Vec<String>) -> Vec<Regex> {
    regexes.iter().map(|regex| get_regex(regex)).collect()
}

fn get_regex(regex: &str) -> Regex {
    match Regex::new(regex) {
        Ok(regex) => regex,
        Err(error) => {
            error!("{:?}", error);
            std::process::exit(crate::ERROR_EXIT_CODE);
        }
    }
}
