use serde::{Serialize, Serializer};

use super::super::*;

pub fn ordered_line_number_to_line<S>(
    value: &LineNumberToLine,
    serializer: S,
) -> Result<S::Ok, S::Error>
where
    S: Serializer,
{
    let ordered: std::collections::BTreeMap<_, _> = value.iter().collect();
    ordered.serialize(serializer)
}
