use serde::{Serialize, Serializer};

use super::super::*;

pub fn ordered_hash_to_line_numbers<S>(
    value: &HashToLineNumbers,
    serializer: S,
) -> Result<S::Ok, S::Error>
where
    S: Serializer,
{
    let ordered: std::collections::BTreeMap<String, Vec<&usize>> = value
        .iter()
        .map(|(k, v)| {
            let mut vector = v.iter().collect::<Vec<_>>();
            vector.sort();
            (k.to_hex().to_string(), vector)
        })
        .collect();
    ordered.serialize(serializer)
}

pub fn ordered_line_number_to_hash<S>(
    value: &LineNumberToHash,
    serializer: S,
) -> Result<S::Ok, S::Error>
where
    S: Serializer,
{
    let ordered: std::collections::BTreeMap<&usize, String> = value
        .iter()
        .map(|(k, v)| (k, v.to_hex().to_string()))
        .collect();
    ordered.serialize(serializer)
}
