macro_rules! assert_hashed_files {
    ($snapshot_name:expr, $raw_files:expr) => {
        assert_hashed_files_with_ignore_line_regex!($snapshot_name, vec![], $raw_files);
    };
}

macro_rules! assert_hashed_files_with_ignore_line_regex {
    ($snapshot_name:expr, $ignore_line_regex:expr, $raw_files:expr) => {
        let indexed_files =
            crate::model::indexed_file::to_indexed_files($ignore_line_regex, $raw_files);
        let hashed_files = crate::model::hashed_file::to_hashed_files(&indexed_files);

        // Then
        insta::assert_json_snapshot!($snapshot_name, hashed_files);
    };
}
