#[macro_use]
extern crate log;
extern crate pretty_env_logger;

use structopt::StructOpt;

mod cli;
mod duplicate_detection;
mod hashing_utilities;
mod model;
mod regex_utilities;
mod reporter;

const ERROR_EXIT_CODE: i32 = 1;

fn main() {
    pretty_env_logger::init();
    let arguments = cli::Arguments::from_args();
    debug!("The command line arguments provided are {:?}.", arguments);

    let raw_files = crate::model::raw_file::get_raw_files(arguments.ignore_file_regex);
    let indexed_files =
        crate::model::indexed_file::to_indexed_files(arguments.ignore_line_regex, raw_files);
    let hashed_files = crate::model::hashed_file::to_hashed_files(&indexed_files);
    let duplicates = crate::duplicate_detection::get_all_duplicates(
        arguments.minimum_successive_lines,
        hashed_files,
    );

    if arguments.json {
        crate::reporter::json_print_duplicates(duplicates);
    } else {
        crate::reporter::pretty_print_duplicates(indexed_files, duplicates);
    }
}
