macro_rules! assert_duplicates {
    ($snapshot_name:expr, $raw_files:expr) => {
        assert_duplicates_with_ignore_line_regex!($snapshot_name, vec![], $raw_files);
    };
}

macro_rules! assert_duplicates_with_ignore_line_regex {
    ($snapshot_name:expr, $ignore_line_regex:expr, $raw_files:expr) => {
        let indexed_files =
            crate::model::indexed_file::to_indexed_files($ignore_line_regex, $raw_files);
        let hashed_files = crate::model::hashed_file::to_hashed_files(&indexed_files);
        let duplicates = crate::duplicate_detection::get_all_duplicates(3, hashed_files);

        // Then
        insta::assert_json_snapshot!($snapshot_name, duplicates);
    };
}
