use structopt::StructOpt;

#[derive(Debug, StructOpt)]
#[structopt(
    name = "duplicate_code",
    about = "A tool for parsing directories scanning all the files within to find duplicate segments of code across files."
)]
pub struct Arguments {
    #[structopt(
        long,
        help = "Ignore every line that matches any of these provided regexes. For example, to ignore the imports and package declarations in Java code  `--ignore-line-regex '^import ' '^package '`."
    )]
    pub ignore_line_regex: Vec<String>,

    #[structopt(
        long,
        help = "Ignore every file that matches any of these provided regexes. For example, to all XML and CSV files  `--ignore-file-regex '[.]xml$' '[.]csv$'`."
    )]
    pub ignore_file_regex: Vec<String>,

    #[structopt(
        long,
        help = "The minimum number of successive lines that must match to be considered a duplicate.",
        default_value = "3"
    )]
    pub minimum_successive_lines: usize,

    #[structopt(
        long,
        help = "Output all the duplicates information as single line JSON. So it can easily be stored, ingested and processed by other programs."
    )]
    pub json: bool,
}
