# DUP Crypto

[![crates.io](https://img.shields.io/crates/v/dup-crypto.svg)](https://crates.io/crates/dup-crypto)
[![docs](https://docs.rs/dup-crypto/badge.svg)](https://docs.rs/dup-crypto)
[![Minimum rustc version](https://img.shields.io/badge/rustc-1.47.0+-yellow.svg)](https://github.com/rust-lang/rust/blob/master/RELEASES.md)

Manage cryptographic operations for DUniter Protocols and the Duniter eco-system most broadly.

`DUP` means DUniter Protocols.

(1): DUniter Blockchain Protocol  
(2): DUniter Network Protocol

## Features

* Rust traits to implement to any entity that can be signed.
* Base 16/58/64 encoding/decoding
* Sha256 hash function
* Secure random byte generation
* Scrypt to generate seed from credentials.
* Ed25519 functions to create and use ed25519 keypair.
* [DEWIF](https://git.duniter.org/documents/rfcs/blob/dewif/rfc/0013_Duniter_Encrypted_Wallet_Import_Format.md) format read/write
* [Dubp-Mnemonic](https://git.duniter.org/documents/rfcs/blob/dubp-mnemonic/rfc/0014_Dubp_Mnemonic.md) implementation.

## Documentation

Generated documentation : [https://docs.rs/dup-crypto](https://docs.rs/dup-crypto)

This documentation contains examples of code whose validity is assured (all code in the documentation is compiled on continuous integration).

## Support

If this library serves you well, you can make a donation on my Ğ1 public key `D9D2zaJoWYWveii1JRYLVK3J4Z7ZH3QczoKrnQeiM6mx`.
