/* SPDX-License-Identifier: MIT */

mod config;
mod dump;
mod fetch;
mod server;

use crate::dump::DumpArgs;
use clap::Parser;
use tracing::error;

#[derive(Parser, Debug)]
#[clap(max_term_width = 80)]
struct Args {
    #[clap(subcommand)]
    subcommands: Commands,
}

#[derive(clap::Parser, Debug)]
enum Commands {
    Export(DumpArgs),
    Server,
    Config(crate::config::ConfigCommand),
}

fn main() {
    let args = Args::parse();
    if let Err(err) = match args.subcommands {
        Commands::Export(sub_args) => dump::main(sub_args),
        Commands::Server => server::start_server(),
        Commands::Config(args) => crate::config::config_main(args),
    } {
        error!("command failed: {:?}", err);
    }
}
