// allow std in tests
#![cfg_attr(not(test), no_std)]

pub mod decoder;
pub mod enums;

#[cfg(test)]
mod tests {
	use crate::decoder::Decoder;
	use crate::enums::{State, Tone};
	use std::fs::File;

	// 12398754932387ABCD*#
	#[test]
	fn decoder_works() {
		let expected = vec![
			(Tone::One, State::On),
			(Tone::One, State::Off),
			(Tone::Two, State::On),
			(Tone::Two, State::Off),
			(Tone::Three, State::On),
			(Tone::Three, State::Off),
			(Tone::Nine, State::On),
			(Tone::Nine, State::Off),
			(Tone::Eight, State::On),
			(Tone::Eight, State::Off),
			(Tone::Seven, State::On),
			(Tone::Seven, State::Off),
			(Tone::Five, State::On),
			(Tone::Five, State::Off),
			(Tone::Four, State::On),
			(Tone::Four, State::Off),
			(Tone::Nine, State::On),
			(Tone::Nine, State::Off),
			(Tone::Three, State::On),
			(Tone::Three, State::Off),
			(Tone::Two, State::On),
			(Tone::Two, State::Off),
			(Tone::Three, State::On),
			(Tone::Three, State::Off),
			(Tone::Eight, State::On),
			(Tone::Eight, State::Off),
			(Tone::Seven, State::On),
			(Tone::Seven, State::Off),
			(Tone::A, State::On),
			(Tone::A, State::Off),
			(Tone::B, State::On),
			(Tone::B, State::Off),
			(Tone::C, State::On),
			(Tone::C, State::Off),
			(Tone::D, State::On),
			(Tone::D, State::Off),
			(Tone::Asterisk, State::On),
			(Tone::Asterisk, State::Off),
			(Tone::Pound, State::On),
		];

		let mut sample_file = File::open("data/dtmf_test.wav").unwrap();
		let (header, data) = wav::read(&mut sample_file).unwrap();
		let data = data.try_into_sixteen().unwrap();

		// first extreme - very few samples
		{
			let mut actual = vec![];
			let mut decoder = Decoder::new(header.sampling_rate, |tone, state| {
				actual.push((tone, state));
			});

			for s in data.chunks(1) {
				let s: Vec<_> = s.iter().map(|x| *x as f32 / 32767.0).collect();
				decoder.process(&s);
			}

			assert_eq!(expected, actual);
		}

		// second extreme - many samples
		{
			let mut actual = vec![];
			let mut decoder = Decoder::new(header.sampling_rate, |tone, state| {
				actual.push((tone, state));
			});

			for s in data.chunks(40000) {
				let s: Vec<_> = s.iter().map(|x| *x as f32 / 32767.0).collect();
				decoder.process(&s);
			}

			assert_eq!(expected, actual);
		}
	}
}
