use num_enum::IntoPrimitive;

#[derive(Debug, Copy, Clone, IntoPrimitive, PartialEq, Eq)]
#[repr(u8)]
pub enum Tone {
	Zero,
	One,
	Two,
	Three,
	Four,
	Five,
	Six,
	Seven,
	Eight,
	Nine,
	A,
	B,
	C,
	D,
	Asterisk,
	Pound,
}

impl Tone {
	pub fn as_char(&self) -> char {
		use Tone::*;

		match self {
			Zero => '0',
			One => '1',
			Two => '2',
			Three => '3',
			Four => '4',
			Five => '5',
			Six => '6',
			Seven => '7',
			Eight => '8',
			Nine => '9',
			A => 'A',
			B => 'B',
			C => 'C',
			D => 'D',
			Asterisk => '*',
			Pound => '#',
		}
	}
}

#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub enum State {
	On,
	Off,
}
