use dtmf::decoder::Decoder;
use std::fs::File;

fn main() {
	// Load in our audio samples
	// This can also be done in real time from the sound card
	let mut sample_file = File::open("data/dtmf_test.wav").unwrap();
	let (header, data) = wav::read(&mut sample_file).unwrap();
	let data: Vec<_> = data
		.try_into_sixteen()
		.unwrap()
		.iter()
		.map(|x| *x as f32 / 32767.0)
		.collect();

	// set up our decoder
	let mut decoder = Decoder::new(header.sampling_rate, |tone, state| {
		println!("{:?}: {:?}", tone, state);
	});

	// can process all samples at once, or in smaller batches
	decoder.process(&data);
}
