/// Templates: Base strings, into which nouns can be inserted.
pub const TEMPLATES: &[&str] = &[
    "\x1F ahead",
    "\x1F required ahead",
    "be wary of \x1F",
    "try \x1F",
    "weakness: \x1F",
    "visions of \x1F...",
    "\x1F",
    "\x1F!",
    "\x1F?",
    "\x1F...",
    "hurrah for \x1F!",
];

/// Conjunctions: Phrases which can be used to combine two Templates.
#[cfg(not(feature = "newline"))]
pub const CONJUNCTIONS: &[&str] = &[
    " and then ",
    " but ",
    " therefore ",
    " in short ",
    " or ",
    " by the way ",
    " , ",
];

/// Conjunctions: Phrases which can be used to combine two Templates, onto
///     multiple lines.
#[cfg(feature = "newline")]
pub const CONJUNCTIONS: &[&str] = &[
    "\nand then ",
    "\nbut ",
    "\ntherefore ",
    "\nin short ",
    "\nor ",
    "\nby the way ",
    " ,\n",
];

lazy_static! {
    /// Words: The same as Words/Musings, but with the Musings omitted; Only a
    ///     select few Templates are allowed to contain Musings.
    pub static ref WORDS: &'static [&'static str] = &WORDS_MUSINGS[..220];
}

/// Words/Musings: Nouns, tactics, concepts, and anything else which can be
///     inserted into a Template to form a Message.
pub static WORDS_MUSINGS: &[&str] = &[
    //  Creatures
    "enemy",
    "monster",
    "lesser foe",
    "tough enemy",
    "boss",
    "Hollow",
    "skeleton",
    "ghost",
    "bug",
    "Gyrm",
    "beast",
    "giant",
    "dwarf",
    "sniper",
    "caster",
    "duo",
    "trio",
    "saint",
    "wretch",
    "charmer",
    "poor soul",
    "oddball",
    "nimble one",
    "laggard",
    "moneybags",
    "beggar",
    "miscreant",
    "liar",
    "fatty",
    "beanpole",
    "merchant",
    "artisan",
    "master",
    "friend",
    "ally",
    "Dark Spirit",
    "Phantom",
    "Shade",
    //  Objects
    "bonfire",
    "fog wall",
    "lever",
    "switch",
    "key",
    "trap",
    "torch",
    "door",
    "treasure",
    "chest",
    "something",
    "quite something",
    "weapon",
    "shield",
    "projectile",
    "armor",
    "item",
    "ring",
    "scroll",
    "ore",
    "message",
    "bloodstain",
    "illusion",
    //  Techniques
    "close-ranged battle",
    "ranged battle",
    "eliminating one at a time",
    "luring it out",
    "beating to a pulp",
    "ambush",
    "pincer attack",
    "hitting them in one swoop",
    "dual-wielding",
    "stealth",
    "mimicry",
    "fleeing",
    "charging",
    "jumping off",
    "dashing through",
    "circling around",
    "trapping inside",
    "rescue",
    "sorcery",
    "pyromancy",
    "miracles",
    "hexes",
    "pure luck",
    "prudence",
    "brief respite",
    "play dead",
    //  Actions
    "jog",
    "dash",
    "rolling",
    "backstepping",
    "jumping",
    "attacking",
    "jump attack",
    "dash attack",
    "counter attack",
    "stabbing in the back",
    "guard stun & stab",
    "parry stun & stab",
    "plunging attack",
    "sweeping attack",
    "shield breaking",
    "blocking",
    "parrying",
    "spell parry",
    "locking-on",
    "no lock-on",
    "two-handing",
    "gesture",
    "control",
    "destroy",
    //  Geography
    "boulder",
    "lava",
    "poison gas",
    "enemy horde",
    "forest",
    "cave",
    "arena",
    "hidden path",
    "detour",
    "shortcut",
    "dead end",
    "labyrinth",
    "hole",
    "bright spot",
    "dark spot",
    "open area",
    "tight spot",
    "safe zone",
    "danger zone",
    "sniper spot",
    "hiding place",
    "illusory wall",
    "ladder",
    "lift",
    "exchange",
    "gorgeous view",
    "looking away",
    "overconfidence",
    "slip-up",
    "oversight",
    "fatigue",
    "bad luck",
    "inattention",
    "loss of stamina",
    //  Orientation
    "front",
    "back",
    "left",
    "right",
    "up",
    "down",
    "below",
    "above",
    "behind",
    //  Body parts
    "head",
    "neck",
    "stomach",
    "back",
    "arm",
    "leg",
    "rear",
    "tail",
    "wings",
    "anywhere",
    "tongue",
    "right arm",
    "left arm",
    "right leg",
    "left leg",
    "right side",
    "left side",
    "pincer",
    "wheel",
    "core",
    "horse",
    //  Attribute
    "strike",
    "thrust",
    "slash",
    "magic",
    "sorcery",
    "fire",
    "lightning",
    "critical hits",
    "bleeding",
    "poison",
    "toxic",
    "curse",
    "equipment breakage",
    //  Concepts
    "chance",
    "quagmire",
    "hint",
    "secret",
    "happiness",
    "misfortune",
    "life",
    "death",
    "joy",
    "sadness",
    "tears",
    "hope",
    "despair",
    "victory",
    "defeat",
    "light",
    "dark",
    "bravery",
    "confidence",
    "vigor",
    "revenge",
    "resignation",
    "overwhelming",
    "regret",
    "pointless",
    "man",
    "woman",
    "recklessness",
    "composure",
    "guts",
    "comfort",
    "silence",
    //  Musings
    "good luck",
    "fine work",
    "I did it!",
    "I've failed...",
    "here!",
    "not here!",
    "I can't take this...",
    "don't you dare!",
    "do it!",
    "look carefully",
    "listen carefully",
    "think carefully",
    "this place again?",
    "now the real fight begins",
    "keep moving",
    "pull back",
    "give it up",
    "don't give up",
    "help me...",
    "impossible...",
    "bloody expensive...",
    "nice job",
    "let me out of here...",
    "stay calm",
    "like a dream...",
    "are you ready?",
    "praise the Sun!",
];
