/// Templates: Base strings, into which nouns can be inserted.
pub const TEMPLATES: &[&str] = &[
    "\x1F",
    "\x1F...",
    "might be \x1F",
    "hm. so it's a \x1F",
    "which means...\x1F",
    "\x1F you say...",
    "\x1F...!",
    "ought to be \x1F...",
    "surely not \x1F...",
    "what is a \x1F...?",
    "\x1F...?",
    "it's not a \x1F",
    "\x1F... I'll think about it",
    "\x1F? I see...",
    "in case of \x1F...",
    "perform \x1F",
    "should try \x1F",
    "confront \x1F",
    "while \x1F",
    "avoid \x1F",
    "no need for \x1F",
    "the pinnacle of \x1F",
    "offer to \x1F",
    "for the sake of \x1F...",
    "\x1F is precious...",
    "surely, not \x1F",
    "code of \x1F",
];

/// Conjunctions: Phrases which can be used to combine two Templates.
#[cfg(not(feature = "newline"))]
pub const CONJUNCTIONS: &[&str] = &[
    " and ",
    " because ",
    " all the more ",
    " therefore ",
    " but ",
    " is ",
    " in short ",
    " that is to say ",
    " or ",
    " also ",
    " however ",
    " if ",
    " then ",
    " by the way ",
    " as it were ",
    ", ",
];

/// Conjunctions: Phrases which can be used to combine two Templates, onto
///     multiple lines.
#[cfg(feature = "newline")]
pub const CONJUNCTIONS: &[&str] = &[
    "\nand ",
    "\nbecause ",
    "\nall the more ",
    "\ntherefore ",
    "\nbut ",
    "\nis ",
    "\nin short ",
    "\nthat is to say ",
    "\nor ",
    "\nalso ",
    "\nhowever ",
    "\nif ",
    "\nthen ",
    "\nby the way ",
    "\nas it were ",
    ",\n"
];

/// Words: Nouns, tactics, concepts, and anything else which can be inserted
///     into a Template to form a Message.
pub const WORDS: &[&str] = &[
    //  People
    "divine child",
    "divine heir",
    "Kuro",
    "Lord Kuro",
    "sculptor",
    "physician",
    "memorial mob",
    "peddler",
    "Wolf",
    "Sekiro",
    "I",
    "me",
    "oneself",
    "you",
    "equal",
    "superior",
    "comrade",
    "pious one",
    "villain",
    "forlorn",
    "misfit",
    "graceful one",
    "swift one",
    "straggler",
    "brute",
    "mule",
    "horror",
    "moneybags",
    "vagabond",
    "deserter",
    "cheat",
    "fiend",
    "youth",
    "man",
    "woman",
    "elder",
    "geezer",
    "hag",
    "master",
    "friend",
    "ally",
    "lord",
    "parent",
    "foster father",
    "child",
    //  Enemies/Beasts/Monsters
    "enemy",
    "foe",
    "worthy opponent",
    "extraordinary foe",
    "shinobi",
    "bandit",
    "villager",
    "Ashina clan",
    "sniper",
    "fencer",
    "warrior",
    "seeker",
    "beast",
    "hound",
    "monkey",
    "serpent",
    "insect",
    "parasite",
    "gamefowl",
    "monster",
    "spirit",
    "apparition",
    "infested",
    "undying",
    "demon",
    "shura",
    //  Objects
    "sculptor's idol",
    "offering box",
    "treasure",
    "chest",
    "mechanism",
    "tatami mat",
    "under the floor",
    "door",
    "key",
    "trap",
    "sen",
    "katana",
    "shinobi prosthetic",
    "prosthetic tool",
    "item",
    "valuable item",
    "material",
    "gourd",
    "sugar",
    "balloon",
    "spirit emblem",
    "document",
    "blood",
    "rice",
    "sake",
    "prayer bead",
    "prayer necklace",
    "memory",
    "remnant",
    //  Tactics
    "swordplay",
    "projectile",
    "mid-air battle",
    "stealth",
    "reconnaisance",
    "taking them one by one",
    "luring out",
    "ambushing",
    "pincer attack",
    "taking them all at once",
    "fleeing",
    "charging",
    "jumping off",
    "sprinting through",
    "flanking",
    "leaving to fate",
    "caution",
    "distracting",
    "controlling",
    "stripping away",
    "feigning death",
    //  Techniques
    "movement",
    "sprinting",
    "grappling hook",
    "jumping",
    "crouching",
    "jump kick",
    "attacking",
    "sweep attack",
    "grab attack",
    "thrust attack",
    "counter-slash attack",
    "shinobi deathblow",
    "backstab deathblow",
    "plunging deathblow",
    "guard",
    "deflecting",
    "consecutive deflects",
    "mikiri counter",
    "evasion",
    "ledge hang",
    "wall hug",
    "peeking",
    "swimming",
    "eavesdropping",
    //  Locations
    "castle keep",
    "outskirts",
    "village",
    "rooftop",
    "hallway",
    "stairs",
    "temple",
    "valley",
    "cliff",
    "abyss",
    "mountain path",
    "forest",
    "treetop",
    "swamp",
    "cave",
    "tall grass",
    "underwater",
    "water surface",
    "mid-air",
    "shortcut",
    "detour",
    "hidden path",
    "escape route",
    "dead end",
    "bright place",
    "dark place",
    "open place",
    "cramped place",
    "safe area",
    "dangerous area",
    "ladder",
    "stunning view",
    "oversight",
    "misfortune",
    "carelessness",
    "encounter",
    "enemy group",
    "lone enemy",
    "enemy patrol",
    "training",
    //  Orientations
    "front",
    "back",
    "left",
    "right",
    "up",
    "down",
    "below",
    "above",
    "behind",
    "ahead",
    //  Attributes
    "poison",
    "burn",
    "terror",
    "shock",
    "enfeeblement",
    "forbidden",
    "sinister burden",
    "slash attacks",
    "blunt attacks",
    "thrust attacks",
    "ranged attacks",
    "flame",
    "apparition",
    "posture",
    //  Concepts
    "fighting chance",
    "escape",
    "perilous pass",
    "certain death",
    "secret",
    "gibberish",
    "bliss",
    "misery",
    "life",
    "death",
    "wrath",
    "pain",
    "sadness",
    "loyalty",
    "betrayal",
    "cowardice",
    "hope",
    "fear",
    "victory",
    "defeat",
    "sacrifice",
    "risk one's life",
    "relief",
    "vigor",
    "resignation",
    "critical moment",
    "regret",
    "futility",
    "friendship",
    "love",
    "abandon",
    "composure",
    "persistence",
    "solace",
    "quiet",
    "depth",
    "stagnation",
    "strength",
    "speed",
    "toughness",
    "skill",
    "hatred",
    "revenge",
    "repayment",
    "auspicious",
    "foreboding",
    "panic",
    "hesitation",
    "comfort",
    "blink",
    "short",
    "long",
    "beautiful",
    "hideous",
    //  Musings
    "well done",
    "I've done it",
    "regretful...",
    "here...",
    "not here...",
    "no turning back...",
    "enough",
    "look carefully",
    "listen carefully",
    "think carefully",
    "this place again...",
    "this is it",
    "is this a trick...?",
    "go",
    "go back",
    "give up",
    "stay strong",
    "impossible...",
    "so high up...",
    "so deep...",
    "keep calm...",
    "an illusion...",
    "nostalgic...",
    "prepare yourself...",
    "you'll know it when you see it",
    "as you command",
    "face me",
    "I don't mind",
    "yes",
    "no",
    "what...?",
    "alright",
    "I cannot",
    "I cannot say",
    "forgive me",
    "I don't think",
    "you have my gratitude",
    "farewell",
    "do what must be done",
    "I will lose",
    "........",
];
