use clap::Parser;
use dsktp::{Args, Context, Executable, SideEffect};
use std::env;
use std::process::Command;

fn main() -> Result<(), &'static str> {
    let args = Args::parse();

    // You can check for the existence of subcommands, and if found use their
    // matches just as you would the top level cmd

    let xdg_data_dirs = env::var("XDG_DATA_DIRS").expect("expects $XDG_DATA_DIRS to be set");

    let context = Context{
        xdg_data_dirs: xdg_data_dirs,
    };

    let side_effects = args.command.execute(context)?;

    for side_effect in side_effects {
        match side_effect {
            SideEffect::Exec(exec) => {
                Command::new(exec)
                    .output()
                    .expect("failed to execute command");
            },
            SideEffect::Print(output) => {
                println!("{}", output);
            }
        };
    }

    Ok(())
}
