{
  description = "A utility for listing and interacting with .desktop files on unix systems";

  outputs = inputs@{ self, nixpkgs, flake-utils, ... }:
    flake-utils.lib.eachDefaultSystem (system:
      let
        pkgs =
          import nixpkgs {
            inherit system;

            allowUnfree = false;
            overlays = [
              (import ./overlay.nix)
            ];
          };
      in
      {
        packages = {
          inherit (pkgs) dsktp;
        };

        overlay = import ./overlay.nix;

        devShell = pkgs.mkShell {
          buildInputs = with pkgs; [
            # rust
            cargo
            rustc
            rustfmt
            rust-analyzer

            # misc
            go-task
          ];
        };
      }
    );
}
