{ lib, rustPlatform }:

let
  cargoConf =
    builtins.readFile ./Cargo.toml;

  lines =
    builtins.split "\n" cargoConf;

  filteredLines =
    lib.lists.filter (line: ! (lib.lists.isList line)) lines;

  versionRegex =
    ''^version = "([0-9.]+)"$'';

  versionLine =
    lib.lists.findFirst (line: (builtins.match versionRegex line) != null) null filteredLines;

  version =
    lib.lists.head (builtins.match versionRegex versionLine);

in
rustPlatform.buildRustPackage {
  pname = "dsktp";
  version = version;

  src = ./.;

  cargoSha256 = "sha256-52fqPjYamcTCBOitpIJXYhuDavIeyql0616Ro65OEFw=";

  meta = with lib; {
    description = "A cli tool for working with .desktop files";
    homepage = "https://sr.ht/~parasrah/dsktp";
    license = licenses.gpl3Plus;
    maintainers = [ maintainers.parasrah ];
  };
}
