# dsktp

A CLI tool to interact with files
adhering to the [freedesktop desktop entry
specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/).

## Examples

Together with [`fzf`](https://github.com/junegunn/fzf), this tool
can be used as an application launcher:

```sh
#!/usr/bin/env sh

dsktp app ls | fzf --multi --prompt='(x)' |

while read app; do
    dsktp app exec "$app"
done
```

Or for an environment like sway:

```sh
#!/usr/bin/env sh

swaymsg "[tiling]" -t command opacity 0.7

dsktp app ls | fzf --multi --prompt='(x)' |

while read app; do
    swaymsg -t command exec "$(dsktp app how "$app")"
done

swaymsg "[tiling]" -t command opacity 1
```
