#[macro_use]
extern crate lazy_static;

#[cfg(test)]
mod tests {
    use std::collections::HashMap;
    lazy_static! {
        static ref HASHMAP: HashMap<u32, &'static str> = {
            let mut m = HashMap::new();
            m.insert(0, "foo");
            m.insert(1, "bar");
            m.insert(2, "baz");
            m
        };
        static ref COUNT: usize = HASHMAP.len();
        static ref NUMBER: u32 = times_two(21);
    }

    fn times_two(n: u32) -> u32 { n * 2 }

    #[test]
    fn test() {
        println!("The map has {} entries.", *COUNT);
        println!("The entry for `0` is \"{}\".", HASHMAP.get(&0).unwrap());
        println!("A expensive calculation on a static results in: {}.", *NUMBER);
    }
}
