// ------------------------------------------------------------------------------
// Copyright 2021Uwe Arzt, mail@uwe-arzt.de
// SPDX-License-Identifier: Apache-2.0
// ------------------------------------------------------------------------------

//! Driver for TI DRV8303 BLDC motor controller

use embedded_hal::blocking::spi::Transfer;
use embedded_hal::digital::v2::OutputPin;

pub struct DRV8308<SPI, CS> {
    spi: SPI,
    cs: CS,
}

impl<SPI, CS, E> DRV8308<SPI, CS>
where
    SPI: Transfer<u8, Error = E>,
    CS: OutputPin,
{
    pub fn new(spi: SPI, cs: CS) -> Result<Self, E> {
        let drv8308 = DRV8308 { spi: spi, cs: cs };

        Ok(drv8308)
    }
}
