//! Provides paths for material design icons, that can be used to draw in piet.
//!
//! Eventually this crate will depend on druid, but for now we just output kurbo
//! paths because kurbo is a lot more stable.

use kurbo::{PathEl, Point, Rect, Shape, Size};

/// Contains the paths for a given icon, and its size.
#[derive(Debug, Copy, Clone)]
pub struct IconPaths {
    /// The paths that should be drawn
    pub paths: &'static [IconPath],
    /// The icon size
    pub size: Size,
}

/// The kurbo path that should be drawn, along with an opacity.
///
/// Some icons use multiple opacity to create multiple tones.
#[derive(Debug, Copy, Clone)]
pub struct IconPath {
    /// The path elements that make up the path
    pub els: &'static [PathEl],
    /// The opacity that this path should be filled with
    pub opacity: f64,
}

impl Shape for IconPath {
    type PathElementsIter = std::iter::Copied<std::slice::Iter<'static, PathEl>>;
    fn path_elements(&self, _tolerance: f64) -> Self::PathElementsIter {
        self.els.iter().copied()
    }

    fn area(&self) -> f64 {
        self.els.area()
    }

    fn perimeter(&self, accuracy: f64) -> f64 {
        self.els.perimeter(accuracy)
    }

    fn winding(&self, pt: Point) -> i32 {
        self.els.winding(pt)
    }
    fn bounding_box(&self) -> Rect {
        self.els.bounding_box()
    }

    fn as_path_slice(&self) -> Option<&[PathEl]> {
        Some(self.els)
    }
}

include!("./icons.rs.in");
