//! Binary to get disk usage.

use async_std::task;

use dru::{Config, Dru};

/// The real main function for the program.
async fn async_main() -> anyhow::Result<()> {
    let mut dru = Dru::new(Config::from_args()).await?;
    dru.generate_reports().await?;
    println!("{}", dru);
    Ok(())
}

/// This main only exists to call the async main.
fn main() -> anyhow::Result<()> {
    task::block_on(async_main())
}
