// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

//! This namespace contains endpoints and data types for managing docs and folders in Dropbox Paper.
//! New Paper users will see docs they create in their filesystem as '.paper' files alongside their
//! other Dropbox content. The /paper endpoints are being deprecated and you'll need to use /files
//! and /sharing endpoints to interact with their Paper content. Read more in the [Paper Migration
//! Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).

pub type PaperDocId = String;

/// Marks the given Paper doc as archived. This action can be performed or undone by anyone with
/// edit permissions to the doc. Note that this endpoint will continue to work for content created
/// by users on the older version of Paper. To check which version of Paper a user is on, use
/// /users/features/get_values. If the paper_as_files feature is enabled, then the user is running
/// the new version of Paper. This endpoint will be retired in September 2020. Refer to the [Paper
/// Migration Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for more
/// information.
#[deprecated]
pub fn docs_archive(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RefPaperDoc,
) -> crate::Result<Result<(), DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/archive",
        arg,
        None)
}

/// Creates a new Paper doc with the provided content. Note that this endpoint will continue to work
/// for content created by users on the older version of Paper. To check which version of Paper a
/// user is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the
/// user is running the new version of Paper. This endpoint will be retired in September 2020. Refer
/// to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for more
/// information.
#[deprecated]
pub fn docs_create(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperDocCreateArgs,
    body: &[u8],
) -> crate::Result<Result<PaperDocCreateUpdateResult, PaperDocCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Upload,
        "paper/docs/create",
        arg,
        Some(body))
}

/// Exports and downloads Paper doc either as HTML or markdown. Note that this endpoint will
/// continue to work for content created by users on the older version of Paper. To check which
/// version of Paper a user is on, use /users/features/get_values. If the paper_as_files feature is
/// enabled, then the user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_download(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperDocExport,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<PaperDocExportResult>, DocLookupError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Download,
        "paper/docs/download",
        arg,
        None,
        range_start,
        range_end)
}

/// Lists the users who are explicitly invited to the Paper folder in which the Paper doc is
/// contained. For private folders all users (including owner) shared on the folder are listed and
/// for team folders all non-team users shared on the folder are returned. Note that this endpoint
/// will continue to work for content created by users on the older version of Paper. To check which
/// version of Paper a user is on, use /users/features/get_values. If the paper_as_files feature is
/// enabled, then the user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_folder_users_list(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListUsersOnFolderArgs,
) -> crate::Result<Result<ListUsersOnFolderResponse, DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/folder_users/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`docs_folder_users_list()`](docs_folder_users_list), use
/// this to paginate through all users on the Paper folder. Note that this endpoint will continue to
/// work for content created by users on the older version of Paper. To check which version of Paper
/// a user is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the
/// user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_folder_users_list_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListUsersOnFolderContinueArgs,
) -> crate::Result<Result<ListUsersOnFolderResponse, ListUsersCursorError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/folder_users/list/continue",
        arg,
        None)
}

/// Retrieves folder information for the given Paper doc. This includes:   - folder sharing policy;
/// permissions for subfolders are set by the top-level folder.   - full 'filepath', i.e. the list
/// of folders (both folderId and folderName) from     the root folder to the folder directly
/// containing the Paper doc.
///
/// If the Paper doc is not in any folder (aka unfiled) the response will be empty. Note that this
/// endpoint will continue to work for content created by users on the older version of Paper. To
/// check which version of Paper a user is on, use /users/features/get_values. If the paper_as_files
/// feature is enabled, then the user is running the new version of Paper. Refer to the [Paper
/// Migration Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for
/// migration information.
#[deprecated]
pub fn docs_get_folder_info(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RefPaperDoc,
) -> crate::Result<Result<FoldersContainingPaperDoc, DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/get_folder_info",
        arg,
        None)
}

/// Return the list of all Paper docs according to the argument specifications. To iterate over
/// through the full pagination, pass the cursor to [`docs_list_continue()`](docs_list_continue).
/// Note that this endpoint will continue to work for content created by users on the older version
/// of Paper. To check which version of Paper a user is on, use /users/features/get_values. If the
/// paper_as_files feature is enabled, then the user is running the new version of Paper. Refer to
/// the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_list(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListPaperDocsArgs,
) -> crate::Result<Result<ListPaperDocsResponse, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`docs_list()`](docs_list), use this to paginate through
/// all Paper doc. Note that this endpoint will continue to work for content created by users on the
/// older version of Paper. To check which version of Paper a user is on, use
/// /users/features/get_values. If the paper_as_files feature is enabled, then the user is running
/// the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_list_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListPaperDocsContinueArgs,
) -> crate::Result<Result<ListPaperDocsResponse, ListDocsCursorError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/list/continue",
        arg,
        None)
}

/// Permanently deletes the given Paper doc. This operation is final as the doc cannot be recovered.
/// This action can be performed only by the doc owner. Note that this endpoint will continue to
/// work for content created by users on the older version of Paper. To check which version of Paper
/// a user is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the
/// user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_permanently_delete(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RefPaperDoc,
) -> crate::Result<Result<(), DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/permanently_delete",
        arg,
        None)
}

/// Gets the default sharing policy for the given Paper doc. Note that this endpoint will continue
/// to work for content created by users on the older version of Paper. To check which version of
/// Paper a user is on, use /users/features/get_values. If the paper_as_files feature is enabled,
/// then the user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_sharing_policy_get(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RefPaperDoc,
) -> crate::Result<Result<SharingPolicy, DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/sharing_policy/get",
        arg,
        None)
}

/// Sets the default sharing policy for the given Paper doc. The default 'team_sharing_policy' can
/// be changed only by teams, omit this field for personal accounts. The 'public_sharing_policy'
/// policy can't be set to the value 'disabled' because this setting can be changed only via the
/// team admin console. Note that this endpoint will continue to work for content created by users
/// on the older version of Paper. To check which version of Paper a user is on, use
/// /users/features/get_values. If the paper_as_files feature is enabled, then the user is running
/// the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_sharing_policy_set(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperDocSharingPolicy,
) -> crate::Result<Result<(), DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/sharing_policy/set",
        arg,
        None)
}

/// Updates an existing Paper doc with the provided content. Note that this endpoint will continue
/// to work for content created by users on the older version of Paper. To check which version of
/// Paper a user is on, use /users/features/get_values. If the paper_as_files feature is enabled,
/// then the user is running the new version of Paper. This endpoint will be retired in September
/// 2020. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for more
/// information.
#[deprecated]
pub fn docs_update(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperDocUpdateArgs,
    body: &[u8],
) -> crate::Result<Result<PaperDocCreateUpdateResult, PaperDocUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Upload,
        "paper/docs/update",
        arg,
        Some(body))
}

/// Allows an owner or editor to add users to a Paper doc or change their permissions using their
/// email address or Dropbox account ID. The doc owner's permissions cannot be changed. Note that
/// this endpoint will continue to work for content created by users on the older version of Paper.
/// To check which version of Paper a user is on, use /users/features/get_values. If the
/// paper_as_files feature is enabled, then the user is running the new version of Paper. Refer to
/// the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_users_add(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &AddPaperDocUser,
) -> crate::Result<Result<Vec<AddPaperDocUserMemberResult>, DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/users/add",
        arg,
        None)
}

/// Lists all users who visited the Paper doc or users with explicit access. This call excludes
/// users who have been removed. The list is sorted by the date of the visit or the share date. The
/// list will include both users, the explicitly shared ones as well as those who came in using the
/// Paper url link. Note that this endpoint will continue to work for content created by users on
/// the older version of Paper. To check which version of Paper a user is on, use
/// /users/features/get_values. If the paper_as_files feature is enabled, then the user is running
/// the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_users_list(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListUsersOnPaperDocArgs,
) -> crate::Result<Result<ListUsersOnPaperDocResponse, DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/users/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`docs_users_list()`](docs_users_list), use this to
/// paginate through all users on the Paper doc. Note that this endpoint will continue to work for
/// content created by users on the older version of Paper. To check which version of Paper a user
/// is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the user
/// is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_users_list_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListUsersOnPaperDocContinueArgs,
) -> crate::Result<Result<ListUsersOnPaperDocResponse, ListUsersCursorError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/users/list/continue",
        arg,
        None)
}

/// Allows an owner or editor to remove users from a Paper doc using their email address or Dropbox
/// account ID. The doc owner cannot be removed. Note that this endpoint will continue to work for
/// content created by users on the older version of Paper. To check which version of Paper a user
/// is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the user
/// is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn docs_users_remove(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RemovePaperDocUser,
) -> crate::Result<Result<(), DocLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/docs/users/remove",
        arg,
        None)
}

/// Create a new Paper folder with the provided info. Note that this endpoint will continue to work
/// for content created by users on the older version of Paper. To check which version of Paper a
/// user is on, use /users/features/get_values. If the paper_as_files feature is enabled, then the
/// user is running the new version of Paper. Refer to the [Paper Migration
/// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide) for migration
/// information.
#[deprecated]
pub fn folders_create(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperFolderCreateArg,
) -> crate::Result<Result<PaperFolderCreateResult, PaperFolderCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "paper/folders/create",
        arg,
        None)
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddMember {
    /// User which should be added to the Paper doc. Specify only email address or Dropbox account
    /// ID.
    pub member: super::sharing::MemberSelector,
    /// Permission for the user.
    pub permission_level: PaperDocPermissionLevel,
}

impl AddMember {
    pub fn new(member: super::sharing::MemberSelector) -> Self {
        AddMember {
            member,
            permission_level: PaperDocPermissionLevel::Edit,
        }
    }

    pub fn with_permission_level(mut self, value: PaperDocPermissionLevel) -> Self {
        self.permission_level = value;
        self
    }
}

const ADD_MEMBER_FIELDS: &[&str] = &["member",
                                     "permission_level"];
impl AddMember {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddMember, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddMember>, V::Error> {
        let mut field_member = None;
        let mut field_permission_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "permission_level" => {
                    if field_permission_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permission_level"));
                    }
                    field_permission_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddMember {
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            permission_level: field_permission_level.unwrap_or(PaperDocPermissionLevel::Edit),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("permission_level", &self.permission_level)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddMember {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddMember;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddMember struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddMember::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddMember", ADD_MEMBER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddMember {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddMember", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddPaperDocUser {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// User which should be added to the Paper doc. Specify only email address or Dropbox account
    /// ID.
    pub members: Vec<AddMember>,
    /// A personal message that will be emailed to each successfully added member.
    pub custom_message: Option<String>,
    /// Clients should set this to true if no email message shall be sent to added users.
    pub quiet: bool,
}

impl AddPaperDocUser {
    pub fn new(doc_id: PaperDocId, members: Vec<AddMember>) -> Self {
        AddPaperDocUser {
            doc_id,
            members,
            custom_message: None,
            quiet: false,
        }
    }

    pub fn with_custom_message(mut self, value: String) -> Self {
        self.custom_message = Some(value);
        self
    }

    pub fn with_quiet(mut self, value: bool) -> Self {
        self.quiet = value;
        self
    }
}

const ADD_PAPER_DOC_USER_FIELDS: &[&str] = &["doc_id",
                                             "members",
                                             "custom_message",
                                             "quiet"];
impl AddPaperDocUser {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddPaperDocUser, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddPaperDocUser>, V::Error> {
        let mut field_doc_id = None;
        let mut field_members = None;
        let mut field_custom_message = None;
        let mut field_quiet = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "custom_message" => {
                    if field_custom_message.is_some() {
                        return Err(::serde::de::Error::duplicate_field("custom_message"));
                    }
                    field_custom_message = Some(map.next_value()?);
                }
                "quiet" => {
                    if field_quiet.is_some() {
                        return Err(::serde::de::Error::duplicate_field("quiet"));
                    }
                    field_quiet = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddPaperDocUser {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            custom_message: field_custom_message,
            quiet: field_quiet.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("members", &self.members)?;
        if let Some(val) = &self.custom_message {
            s.serialize_field("custom_message", val)?;
        }
        s.serialize_field("quiet", &self.quiet)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddPaperDocUser {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddPaperDocUser;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddPaperDocUser struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddPaperDocUser::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddPaperDocUser", ADD_PAPER_DOC_USER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddPaperDocUser {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddPaperDocUser", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Per-member result for [`docs_users_add()`](docs_users_add).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddPaperDocUserMemberResult {
    /// One of specified input members.
    pub member: super::sharing::MemberSelector,
    /// The outcome of the action on this member.
    pub result: AddPaperDocUserResult,
}

impl AddPaperDocUserMemberResult {
    pub fn new(member: super::sharing::MemberSelector, result: AddPaperDocUserResult) -> Self {
        AddPaperDocUserMemberResult {
            member,
            result,
        }
    }
}

const ADD_PAPER_DOC_USER_MEMBER_RESULT_FIELDS: &[&str] = &["member",
                                                           "result"];
impl AddPaperDocUserMemberResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddPaperDocUserMemberResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddPaperDocUserMemberResult>, V::Error> {
        let mut field_member = None;
        let mut field_result = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "result" => {
                    if field_result.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result"));
                    }
                    field_result = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddPaperDocUserMemberResult {
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            result: field_result.ok_or_else(|| ::serde::de::Error::missing_field("result"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("result", &self.result)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddPaperDocUserMemberResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddPaperDocUserMemberResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddPaperDocUserMemberResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddPaperDocUserMemberResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddPaperDocUserMemberResult", ADD_PAPER_DOC_USER_MEMBER_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddPaperDocUserMemberResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddPaperDocUserMemberResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddPaperDocUserResult {
    /// User was successfully added to the Paper doc.
    Success,
    /// Something unexpected happened when trying to add the user to the Paper doc.
    UnknownError,
    /// The Paper doc can be shared only with team members.
    SharingOutsideTeamDisabled,
    /// The daily limit of how many users can be added to the Paper doc was reached.
    DailyLimitReached,
    /// Owner's permissions cannot be changed.
    UserIsOwner,
    /// User data could not be retrieved. Clients should retry.
    FailedUserDataRetrieval,
    /// This user already has the correct permission to the Paper doc.
    PermissionAlreadyGranted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddPaperDocUserResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddPaperDocUserResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddPaperDocUserResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => AddPaperDocUserResult::Success,
                    "unknown_error" => AddPaperDocUserResult::UnknownError,
                    "sharing_outside_team_disabled" => AddPaperDocUserResult::SharingOutsideTeamDisabled,
                    "daily_limit_reached" => AddPaperDocUserResult::DailyLimitReached,
                    "user_is_owner" => AddPaperDocUserResult::UserIsOwner,
                    "failed_user_data_retrieval" => AddPaperDocUserResult::FailedUserDataRetrieval,
                    "permission_already_granted" => AddPaperDocUserResult::PermissionAlreadyGranted,
                    _ => AddPaperDocUserResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "unknown_error",
                                    "sharing_outside_team_disabled",
                                    "daily_limit_reached",
                                    "user_is_owner",
                                    "failed_user_data_retrieval",
                                    "permission_already_granted",
                                    "other"];
        deserializer.deserialize_struct("AddPaperDocUserResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddPaperDocUserResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddPaperDocUserResult::Success => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "success")?;
                s.end()
            }
            AddPaperDocUserResult::UnknownError => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "unknown_error")?;
                s.end()
            }
            AddPaperDocUserResult::SharingOutsideTeamDisabled => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "sharing_outside_team_disabled")?;
                s.end()
            }
            AddPaperDocUserResult::DailyLimitReached => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "daily_limit_reached")?;
                s.end()
            }
            AddPaperDocUserResult::UserIsOwner => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "user_is_owner")?;
                s.end()
            }
            AddPaperDocUserResult::FailedUserDataRetrieval => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "failed_user_data_retrieval")?;
                s.end()
            }
            AddPaperDocUserResult::PermissionAlreadyGranted => {
                // unit
                let mut s = serializer.serialize_struct("AddPaperDocUserResult", 1)?;
                s.serialize_field(".tag", "permission_already_granted")?;
                s.end()
            }
            AddPaperDocUserResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Cursor {
    /// The actual cursor value.
    pub value: String,
    /// Expiration time of `value`. Some cursors might have expiration time assigned. This is a UTC
    /// value after which the cursor is no longer valid and the API starts returning an error. If
    /// cursor expires a new one needs to be obtained and pagination needs to be restarted. Some
    /// cursors might be short-lived some cursors might be long-lived. This really depends on the
    /// sorting type and order, e.g.: 1. on one hand, listing docs created by the user, sorted by
    /// the created time ascending will have undefinite expiration because the results cannot change
    /// while the iteration is happening. This cursor would be suitable for long term polling. 2. on
    /// the other hand, listing docs sorted by the last modified time will have a very short
    /// expiration as docs do get modified very often and the modified time can be changed while the
    /// iteration is happening thus altering the results.
    pub expiration: Option<super::common::DropboxTimestamp>,
}

impl Cursor {
    pub fn new(value: String) -> Self {
        Cursor {
            value,
            expiration: None,
        }
    }

    pub fn with_expiration(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expiration = Some(value);
        self
    }
}

const CURSOR_FIELDS: &[&str] = &["value",
                                 "expiration"];
impl Cursor {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Cursor, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Cursor>, V::Error> {
        let mut field_value = None;
        let mut field_expiration = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "value" => {
                    if field_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("value"));
                    }
                    field_value = Some(map.next_value()?);
                }
                "expiration" => {
                    if field_expiration.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiration"));
                    }
                    field_expiration = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Cursor {
            value: field_value.ok_or_else(|| ::serde::de::Error::missing_field("value"))?,
            expiration: field_expiration,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("value", &self.value)?;
        if let Some(val) = &self.expiration {
            s.serialize_field("expiration", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Cursor {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Cursor;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Cursor struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Cursor::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Cursor", CURSOR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Cursor {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Cursor", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DocLookupError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// The required doc was not found.
    DocNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DocLookupError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DocLookupError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DocLookupError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => DocLookupError::InsufficientPermissions,
                    "doc_not_found" => DocLookupError::DocNotFound,
                    _ => DocLookupError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other",
                                    "doc_not_found"];
        deserializer.deserialize_struct("DocLookupError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DocLookupError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DocLookupError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("DocLookupError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            DocLookupError::DocNotFound => {
                // unit
                let mut s = serializer.serialize_struct("DocLookupError", 1)?;
                s.serialize_field(".tag", "doc_not_found")?;
                s.end()
            }
            DocLookupError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DocLookupError {
}

impl ::std::fmt::Display for DocLookupError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DocLookupError::DocNotFound => f.write_str("The required doc was not found."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// The subscription level of a Paper doc.
#[derive(Debug, Clone, PartialEq)]
pub enum DocSubscriptionLevel {
    /// No change email messages unless you're the creator.
    Default,
    /// Ignored: Not shown in pad lists or activity and no email message is sent.
    Ignore,
    /// Subscribed: Shown in pad lists and activity and change email messages are sent.
    Every,
    /// Unsubscribed: Shown in pad lists, but not in activity and no change email messages are sent.
    NoEmail,
}

impl<'de> ::serde::de::Deserialize<'de> for DocSubscriptionLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DocSubscriptionLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DocSubscriptionLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default" => DocSubscriptionLevel::Default,
                    "ignore" => DocSubscriptionLevel::Ignore,
                    "every" => DocSubscriptionLevel::Every,
                    "no_email" => DocSubscriptionLevel::NoEmail,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default",
                                    "ignore",
                                    "every",
                                    "no_email"];
        deserializer.deserialize_struct("DocSubscriptionLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DocSubscriptionLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DocSubscriptionLevel::Default => {
                // unit
                let mut s = serializer.serialize_struct("DocSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            DocSubscriptionLevel::Ignore => {
                // unit
                let mut s = serializer.serialize_struct("DocSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "ignore")?;
                s.end()
            }
            DocSubscriptionLevel::Every => {
                // unit
                let mut s = serializer.serialize_struct("DocSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "every")?;
                s.end()
            }
            DocSubscriptionLevel::NoEmail => {
                // unit
                let mut s = serializer.serialize_struct("DocSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "no_email")?;
                s.end()
            }
        }
    }
}

/// The desired export format of the Paper doc.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExportFormat {
    /// The HTML export format.
    Html,
    /// The markdown export format.
    Markdown,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExportFormat {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExportFormat;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportFormat structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "html" => ExportFormat::Html,
                    "markdown" => ExportFormat::Markdown,
                    _ => ExportFormat::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["html",
                                    "markdown",
                                    "other"];
        deserializer.deserialize_struct("ExportFormat", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExportFormat {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExportFormat::Html => {
                // unit
                let mut s = serializer.serialize_struct("ExportFormat", 1)?;
                s.serialize_field(".tag", "html")?;
                s.end()
            }
            ExportFormat::Markdown => {
                // unit
                let mut s = serializer.serialize_struct("ExportFormat", 1)?;
                s.serialize_field(".tag", "markdown")?;
                s.end()
            }
            ExportFormat::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Data structure representing a Paper folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Folder {
    /// Paper folder ID. This ID uniquely identifies the folder.
    pub id: String,
    /// Paper folder name.
    pub name: String,
}

impl Folder {
    pub fn new(id: String, name: String) -> Self {
        Folder {
            id,
            name,
        }
    }
}

const FOLDER_FIELDS: &[&str] = &["id",
                                 "name"];
impl Folder {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Folder, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Folder>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Folder {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("name", &self.name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Folder {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Folder;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Folder struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Folder::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Folder", FOLDER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Folder {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Folder", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The sharing policy of a Paper folder. The sharing policy of subfolders is inherited from the
/// root folder.
#[derive(Debug, Clone, PartialEq)]
pub enum FolderSharingPolicyType {
    /// Everyone in your team and anyone directly invited can access this folder.
    Team,
    /// Only people directly invited can access this folder.
    InviteOnly,
}

impl<'de> ::serde::de::Deserialize<'de> for FolderSharingPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FolderSharingPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderSharingPolicyType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team" => FolderSharingPolicyType::Team,
                    "invite_only" => FolderSharingPolicyType::InviteOnly,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team",
                                    "invite_only"];
        deserializer.deserialize_struct("FolderSharingPolicyType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FolderSharingPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FolderSharingPolicyType::Team => {
                // unit
                let mut s = serializer.serialize_struct("FolderSharingPolicyType", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            FolderSharingPolicyType::InviteOnly => {
                // unit
                let mut s = serializer.serialize_struct("FolderSharingPolicyType", 1)?;
                s.serialize_field(".tag", "invite_only")?;
                s.end()
            }
        }
    }
}

/// The subscription level of a Paper folder.
#[derive(Debug, Clone, PartialEq)]
pub enum FolderSubscriptionLevel {
    /// Not shown in activity, no email messages.
    None,
    /// Shown in activity, no email messages.
    ActivityOnly,
    /// Shown in activity, daily email messages.
    DailyEmails,
    /// Shown in activity, weekly email messages.
    WeeklyEmails,
}

impl<'de> ::serde::de::Deserialize<'de> for FolderSubscriptionLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FolderSubscriptionLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderSubscriptionLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "none" => FolderSubscriptionLevel::None,
                    "activity_only" => FolderSubscriptionLevel::ActivityOnly,
                    "daily_emails" => FolderSubscriptionLevel::DailyEmails,
                    "weekly_emails" => FolderSubscriptionLevel::WeeklyEmails,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["none",
                                    "activity_only",
                                    "daily_emails",
                                    "weekly_emails"];
        deserializer.deserialize_struct("FolderSubscriptionLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FolderSubscriptionLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FolderSubscriptionLevel::None => {
                // unit
                let mut s = serializer.serialize_struct("FolderSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "none")?;
                s.end()
            }
            FolderSubscriptionLevel::ActivityOnly => {
                // unit
                let mut s = serializer.serialize_struct("FolderSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "activity_only")?;
                s.end()
            }
            FolderSubscriptionLevel::DailyEmails => {
                // unit
                let mut s = serializer.serialize_struct("FolderSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "daily_emails")?;
                s.end()
            }
            FolderSubscriptionLevel::WeeklyEmails => {
                // unit
                let mut s = serializer.serialize_struct("FolderSubscriptionLevel", 1)?;
                s.serialize_field(".tag", "weekly_emails")?;
                s.end()
            }
        }
    }
}

/// Metadata about Paper folders containing the specififed Paper doc.
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FoldersContainingPaperDoc {
    /// The sharing policy of the folder containing the Paper doc.
    pub folder_sharing_policy_type: Option<FolderSharingPolicyType>,
    /// The folder path. If present the first folder is the root folder.
    pub folders: Option<Vec<Folder>>,
}

impl FoldersContainingPaperDoc {
    pub fn with_folder_sharing_policy_type(mut self, value: FolderSharingPolicyType) -> Self {
        self.folder_sharing_policy_type = Some(value);
        self
    }

    pub fn with_folders(mut self, value: Vec<Folder>) -> Self {
        self.folders = Some(value);
        self
    }
}

const FOLDERS_CONTAINING_PAPER_DOC_FIELDS: &[&str] = &["folder_sharing_policy_type",
                                                       "folders"];
impl FoldersContainingPaperDoc {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<FoldersContainingPaperDoc, V::Error> {
        let mut field_folder_sharing_policy_type = None;
        let mut field_folders = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "folder_sharing_policy_type" => {
                    if field_folder_sharing_policy_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("folder_sharing_policy_type"));
                    }
                    field_folder_sharing_policy_type = Some(map.next_value()?);
                }
                "folders" => {
                    if field_folders.is_some() {
                        return Err(::serde::de::Error::duplicate_field("folders"));
                    }
                    field_folders = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = FoldersContainingPaperDoc {
            folder_sharing_policy_type: field_folder_sharing_policy_type,
            folders: field_folders,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.folder_sharing_policy_type {
            s.serialize_field("folder_sharing_policy_type", val)?;
        }
        if let Some(val) = &self.folders {
            s.serialize_field("folders", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FoldersContainingPaperDoc {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FoldersContainingPaperDoc;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FoldersContainingPaperDoc struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FoldersContainingPaperDoc::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FoldersContainingPaperDoc", FOLDERS_CONTAINING_PAPER_DOC_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FoldersContainingPaperDoc {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FoldersContainingPaperDoc", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The import format of the incoming data.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ImportFormat {
    /// The provided data is interpreted as standard HTML.
    Html,
    /// The provided data is interpreted as markdown. The first line of the provided document will
    /// be used as the doc title.
    Markdown,
    /// The provided data is interpreted as plain text. The first line of the provided document will
    /// be used as the doc title.
    PlainText,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ImportFormat {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ImportFormat;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ImportFormat structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "html" => ImportFormat::Html,
                    "markdown" => ImportFormat::Markdown,
                    "plain_text" => ImportFormat::PlainText,
                    _ => ImportFormat::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["html",
                                    "markdown",
                                    "plain_text",
                                    "other"];
        deserializer.deserialize_struct("ImportFormat", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ImportFormat {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ImportFormat::Html => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "html")?;
                s.end()
            }
            ImportFormat::Markdown => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "markdown")?;
                s.end()
            }
            ImportFormat::PlainText => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "plain_text")?;
                s.end()
            }
            ImportFormat::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct InviteeInfoWithPermissionLevel {
    /// Email address invited to the Paper doc.
    pub invitee: super::sharing::InviteeInfo,
    /// Permission level for the invitee.
    pub permission_level: PaperDocPermissionLevel,
}

impl InviteeInfoWithPermissionLevel {
    pub fn new(
        invitee: super::sharing::InviteeInfo,
        permission_level: PaperDocPermissionLevel,
    ) -> Self {
        InviteeInfoWithPermissionLevel {
            invitee,
            permission_level,
        }
    }
}

const INVITEE_INFO_WITH_PERMISSION_LEVEL_FIELDS: &[&str] = &["invitee",
                                                             "permission_level"];
impl InviteeInfoWithPermissionLevel {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<InviteeInfoWithPermissionLevel, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<InviteeInfoWithPermissionLevel>, V::Error> {
        let mut field_invitee = None;
        let mut field_permission_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "invitee" => {
                    if field_invitee.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitee"));
                    }
                    field_invitee = Some(map.next_value()?);
                }
                "permission_level" => {
                    if field_permission_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permission_level"));
                    }
                    field_permission_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = InviteeInfoWithPermissionLevel {
            invitee: field_invitee.ok_or_else(|| ::serde::de::Error::missing_field("invitee"))?,
            permission_level: field_permission_level.ok_or_else(|| ::serde::de::Error::missing_field("permission_level"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("invitee", &self.invitee)?;
        s.serialize_field("permission_level", &self.permission_level)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for InviteeInfoWithPermissionLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = InviteeInfoWithPermissionLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a InviteeInfoWithPermissionLevel struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                InviteeInfoWithPermissionLevel::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("InviteeInfoWithPermissionLevel", INVITEE_INFO_WITH_PERMISSION_LEVEL_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for InviteeInfoWithPermissionLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("InviteeInfoWithPermissionLevel", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListDocsCursorError {
    CursorError(PaperApiCursorError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListDocsCursorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListDocsCursorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListDocsCursorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "cursor_error" => {
                        match map.next_key()? {
                            Some("cursor_error") => ListDocsCursorError::CursorError(map.next_value()?),
                            None => return Err(de::Error::missing_field("cursor_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListDocsCursorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["cursor_error",
                                    "other"];
        deserializer.deserialize_struct("ListDocsCursorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListDocsCursorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListDocsCursorError::CursorError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListDocsCursorError", 2)?;
                s.serialize_field(".tag", "cursor_error")?;
                s.serialize_field("cursor_error", x)?;
                s.end()
            }
            ListDocsCursorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListDocsCursorError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListDocsCursorError::CursorError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListDocsCursorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListDocsCursorError::CursorError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListPaperDocsArgs {
    /// Allows user to specify how the Paper docs should be filtered.
    pub filter_by: ListPaperDocsFilterBy,
    /// Allows user to specify how the Paper docs should be sorted.
    pub sort_by: ListPaperDocsSortBy,
    /// Allows user to specify the sort order of the result.
    pub sort_order: ListPaperDocsSortOrder,
    /// Size limit per batch. The maximum number of docs that can be retrieved per batch is 1000.
    /// Higher value results in invalid arguments error.
    pub limit: i32,
}

impl Default for ListPaperDocsArgs {
    fn default() -> Self {
        ListPaperDocsArgs {
            filter_by: ListPaperDocsFilterBy::DocsAccessed,
            sort_by: ListPaperDocsSortBy::Accessed,
            sort_order: ListPaperDocsSortOrder::Ascending,
            limit: 1000,
        }
    }
}

impl ListPaperDocsArgs {
    pub fn with_filter_by(mut self, value: ListPaperDocsFilterBy) -> Self {
        self.filter_by = value;
        self
    }

    pub fn with_sort_by(mut self, value: ListPaperDocsSortBy) -> Self {
        self.sort_by = value;
        self
    }

    pub fn with_sort_order(mut self, value: ListPaperDocsSortOrder) -> Self {
        self.sort_order = value;
        self
    }

    pub fn with_limit(mut self, value: i32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_PAPER_DOCS_ARGS_FIELDS: &[&str] = &["filter_by",
                                               "sort_by",
                                               "sort_order",
                                               "limit"];
impl ListPaperDocsArgs {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListPaperDocsArgs, V::Error> {
        let mut field_filter_by = None;
        let mut field_sort_by = None;
        let mut field_sort_order = None;
        let mut field_limit = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "filter_by" => {
                    if field_filter_by.is_some() {
                        return Err(::serde::de::Error::duplicate_field("filter_by"));
                    }
                    field_filter_by = Some(map.next_value()?);
                }
                "sort_by" => {
                    if field_sort_by.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sort_by"));
                    }
                    field_sort_by = Some(map.next_value()?);
                }
                "sort_order" => {
                    if field_sort_order.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sort_order"));
                    }
                    field_sort_order = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListPaperDocsArgs {
            filter_by: field_filter_by.unwrap_or(ListPaperDocsFilterBy::DocsAccessed),
            sort_by: field_sort_by.unwrap_or(ListPaperDocsSortBy::Accessed),
            sort_order: field_sort_order.unwrap_or(ListPaperDocsSortOrder::Ascending),
            limit: field_limit.unwrap_or(1000),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("filter_by", &self.filter_by)?;
        s.serialize_field("sort_by", &self.sort_by)?;
        s.serialize_field("sort_order", &self.sort_order)?;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListPaperDocsArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListPaperDocsArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListPaperDocsArgs", LIST_PAPER_DOCS_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListPaperDocsArgs", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListPaperDocsContinueArgs {
    /// The cursor obtained from [`docs_list()`](docs_list) or
    /// [`docs_list_continue()`](docs_list_continue). Allows for pagination.
    pub cursor: String,
}

impl ListPaperDocsContinueArgs {
    pub fn new(cursor: String) -> Self {
        ListPaperDocsContinueArgs {
            cursor,
        }
    }
}

const LIST_PAPER_DOCS_CONTINUE_ARGS_FIELDS: &[&str] = &["cursor"];
impl ListPaperDocsContinueArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListPaperDocsContinueArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListPaperDocsContinueArgs>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListPaperDocsContinueArgs {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsContinueArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListPaperDocsContinueArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsContinueArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListPaperDocsContinueArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListPaperDocsContinueArgs", LIST_PAPER_DOCS_CONTINUE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsContinueArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListPaperDocsContinueArgs", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListPaperDocsFilterBy {
    /// Fetches all Paper doc IDs that the user has ever accessed.
    DocsAccessed,
    /// Fetches only the Paper doc IDs that the user has created.
    DocsCreated,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsFilterBy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListPaperDocsFilterBy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsFilterBy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "docs_accessed" => ListPaperDocsFilterBy::DocsAccessed,
                    "docs_created" => ListPaperDocsFilterBy::DocsCreated,
                    _ => ListPaperDocsFilterBy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["docs_accessed",
                                    "docs_created",
                                    "other"];
        deserializer.deserialize_struct("ListPaperDocsFilterBy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsFilterBy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListPaperDocsFilterBy::DocsAccessed => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsFilterBy", 1)?;
                s.serialize_field(".tag", "docs_accessed")?;
                s.end()
            }
            ListPaperDocsFilterBy::DocsCreated => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsFilterBy", 1)?;
                s.serialize_field(".tag", "docs_created")?;
                s.end()
            }
            ListPaperDocsFilterBy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListPaperDocsResponse {
    /// The list of Paper doc IDs that can be used to access the given Paper docs or supplied to
    /// other API methods. The list is sorted in the order specified by the initial call to
    /// [`docs_list()`](docs_list).
    pub doc_ids: Vec<PaperDocId>,
    /// Pass the cursor into [`docs_list_continue()`](docs_list_continue) to paginate through all
    /// files. The cursor preserves all properties as specified in the original call to
    /// [`docs_list()`](docs_list).
    pub cursor: Cursor,
    /// Will be set to True if a subsequent call with the provided cursor to
    /// [`docs_list_continue()`](docs_list_continue) returns immediately with some results. If set
    /// to False please allow some delay before making another call to
    /// [`docs_list_continue()`](docs_list_continue).
    pub has_more: bool,
}

impl ListPaperDocsResponse {
    pub fn new(doc_ids: Vec<PaperDocId>, cursor: Cursor, has_more: bool) -> Self {
        ListPaperDocsResponse {
            doc_ids,
            cursor,
            has_more,
        }
    }
}

const LIST_PAPER_DOCS_RESPONSE_FIELDS: &[&str] = &["doc_ids",
                                                   "cursor",
                                                   "has_more"];
impl ListPaperDocsResponse {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListPaperDocsResponse, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListPaperDocsResponse>, V::Error> {
        let mut field_doc_ids = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_ids" => {
                    if field_doc_ids.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_ids"));
                    }
                    field_doc_ids = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListPaperDocsResponse {
            doc_ids: field_doc_ids.ok_or_else(|| ::serde::de::Error::missing_field("doc_ids"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_ids", &self.doc_ids)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsResponse {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListPaperDocsResponse;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsResponse struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListPaperDocsResponse::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListPaperDocsResponse", LIST_PAPER_DOCS_RESPONSE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsResponse {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListPaperDocsResponse", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListPaperDocsSortBy {
    /// Sorts the Paper docs by the time they were last accessed.
    Accessed,
    /// Sorts the Paper docs by the time they were last modified.
    Modified,
    /// Sorts the Paper docs by the creation time.
    Created,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsSortBy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListPaperDocsSortBy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsSortBy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "accessed" => ListPaperDocsSortBy::Accessed,
                    "modified" => ListPaperDocsSortBy::Modified,
                    "created" => ListPaperDocsSortBy::Created,
                    _ => ListPaperDocsSortBy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["accessed",
                                    "modified",
                                    "created",
                                    "other"];
        deserializer.deserialize_struct("ListPaperDocsSortBy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsSortBy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListPaperDocsSortBy::Accessed => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsSortBy", 1)?;
                s.serialize_field(".tag", "accessed")?;
                s.end()
            }
            ListPaperDocsSortBy::Modified => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsSortBy", 1)?;
                s.serialize_field(".tag", "modified")?;
                s.end()
            }
            ListPaperDocsSortBy::Created => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsSortBy", 1)?;
                s.serialize_field(".tag", "created")?;
                s.end()
            }
            ListPaperDocsSortBy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListPaperDocsSortOrder {
    /// Sorts the search result in ascending order.
    Ascending,
    /// Sorts the search result in descending order.
    Descending,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListPaperDocsSortOrder {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListPaperDocsSortOrder;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListPaperDocsSortOrder structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "ascending" => ListPaperDocsSortOrder::Ascending,
                    "descending" => ListPaperDocsSortOrder::Descending,
                    _ => ListPaperDocsSortOrder::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["ascending",
                                    "descending",
                                    "other"];
        deserializer.deserialize_struct("ListPaperDocsSortOrder", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListPaperDocsSortOrder {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListPaperDocsSortOrder::Ascending => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsSortOrder", 1)?;
                s.serialize_field(".tag", "ascending")?;
                s.end()
            }
            ListPaperDocsSortOrder::Descending => {
                // unit
                let mut s = serializer.serialize_struct("ListPaperDocsSortOrder", 1)?;
                s.serialize_field(".tag", "descending")?;
                s.end()
            }
            ListPaperDocsSortOrder::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListUsersCursorError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// The required doc was not found.
    DocNotFound,
    CursorError(PaperApiCursorError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersCursorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListUsersCursorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersCursorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => ListUsersCursorError::InsufficientPermissions,
                    "doc_not_found" => ListUsersCursorError::DocNotFound,
                    "cursor_error" => {
                        match map.next_key()? {
                            Some("cursor_error") => ListUsersCursorError::CursorError(map.next_value()?),
                            None => return Err(de::Error::missing_field("cursor_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListUsersCursorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other",
                                    "doc_not_found",
                                    "cursor_error"];
        deserializer.deserialize_struct("ListUsersCursorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersCursorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListUsersCursorError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("ListUsersCursorError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            ListUsersCursorError::DocNotFound => {
                // unit
                let mut s = serializer.serialize_struct("ListUsersCursorError", 1)?;
                s.serialize_field(".tag", "doc_not_found")?;
                s.end()
            }
            ListUsersCursorError::CursorError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListUsersCursorError", 2)?;
                s.serialize_field(".tag", "cursor_error")?;
                s.serialize_field("cursor_error", x)?;
                s.end()
            }
            ListUsersCursorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListUsersCursorError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListUsersCursorError::CursorError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListUsersCursorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListUsersCursorError::DocNotFound => f.write_str("The required doc was not found."),
            ListUsersCursorError::CursorError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnFolderArgs {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// Size limit per batch. The maximum number of users that can be retrieved per batch is 1000.
    /// Higher value results in invalid arguments error.
    pub limit: i32,
}

impl ListUsersOnFolderArgs {
    pub fn new(doc_id: PaperDocId) -> Self {
        ListUsersOnFolderArgs {
            doc_id,
            limit: 1000,
        }
    }

    pub fn with_limit(mut self, value: i32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_USERS_ON_FOLDER_ARGS_FIELDS: &[&str] = &["doc_id",
                                                    "limit"];
impl ListUsersOnFolderArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnFolderArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnFolderArgs>, V::Error> {
        let mut field_doc_id = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnFolderArgs {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            limit: field_limit.unwrap_or(1000),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnFolderArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnFolderArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnFolderArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnFolderArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnFolderArgs", LIST_USERS_ON_FOLDER_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnFolderArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnFolderArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnFolderContinueArgs {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// The cursor obtained from [`docs_folder_users_list()`](docs_folder_users_list) or
    /// [`docs_folder_users_list_continue()`](docs_folder_users_list_continue). Allows for
    /// pagination.
    pub cursor: String,
}

impl ListUsersOnFolderContinueArgs {
    pub fn new(doc_id: PaperDocId, cursor: String) -> Self {
        ListUsersOnFolderContinueArgs {
            doc_id,
            cursor,
        }
    }
}

const LIST_USERS_ON_FOLDER_CONTINUE_ARGS_FIELDS: &[&str] = &["doc_id",
                                                             "cursor"];
impl ListUsersOnFolderContinueArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnFolderContinueArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnFolderContinueArgs>, V::Error> {
        let mut field_doc_id = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnFolderContinueArgs {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnFolderContinueArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnFolderContinueArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnFolderContinueArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnFolderContinueArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnFolderContinueArgs", LIST_USERS_ON_FOLDER_CONTINUE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnFolderContinueArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnFolderContinueArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnFolderResponse {
    /// List of email addresses that are invited on the Paper folder.
    pub invitees: Vec<super::sharing::InviteeInfo>,
    /// List of users that are invited on the Paper folder.
    pub users: Vec<super::sharing::UserInfo>,
    /// Pass the cursor into [`docs_folder_users_list_continue()`](docs_folder_users_list_continue)
    /// to paginate through all users. The cursor preserves all properties as specified in the
    /// original call to [`docs_folder_users_list()`](docs_folder_users_list).
    pub cursor: Cursor,
    /// Will be set to True if a subsequent call with the provided cursor to
    /// [`docs_folder_users_list_continue()`](docs_folder_users_list_continue) returns immediately
    /// with some results. If set to False please allow some delay before making another call to
    /// [`docs_folder_users_list_continue()`](docs_folder_users_list_continue).
    pub has_more: bool,
}

impl ListUsersOnFolderResponse {
    pub fn new(
        invitees: Vec<super::sharing::InviteeInfo>,
        users: Vec<super::sharing::UserInfo>,
        cursor: Cursor,
        has_more: bool,
    ) -> Self {
        ListUsersOnFolderResponse {
            invitees,
            users,
            cursor,
            has_more,
        }
    }
}

const LIST_USERS_ON_FOLDER_RESPONSE_FIELDS: &[&str] = &["invitees",
                                                        "users",
                                                        "cursor",
                                                        "has_more"];
impl ListUsersOnFolderResponse {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnFolderResponse, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnFolderResponse>, V::Error> {
        let mut field_invitees = None;
        let mut field_users = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "invitees" => {
                    if field_invitees.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitees"));
                    }
                    field_invitees = Some(map.next_value()?);
                }
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnFolderResponse {
            invitees: field_invitees.ok_or_else(|| ::serde::de::Error::missing_field("invitees"))?,
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("invitees", &self.invitees)?;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnFolderResponse {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnFolderResponse;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnFolderResponse struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnFolderResponse::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnFolderResponse", LIST_USERS_ON_FOLDER_RESPONSE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnFolderResponse {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnFolderResponse", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnPaperDocArgs {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// Size limit per batch. The maximum number of users that can be retrieved per batch is 1000.
    /// Higher value results in invalid arguments error.
    pub limit: i32,
    /// Specify this attribute if you want to obtain users that have already accessed the Paper doc.
    pub filter_by: UserOnPaperDocFilter,
}

impl ListUsersOnPaperDocArgs {
    pub fn new(doc_id: PaperDocId) -> Self {
        ListUsersOnPaperDocArgs {
            doc_id,
            limit: 1000,
            filter_by: UserOnPaperDocFilter::Shared,
        }
    }

    pub fn with_limit(mut self, value: i32) -> Self {
        self.limit = value;
        self
    }

    pub fn with_filter_by(mut self, value: UserOnPaperDocFilter) -> Self {
        self.filter_by = value;
        self
    }
}

const LIST_USERS_ON_PAPER_DOC_ARGS_FIELDS: &[&str] = &["doc_id",
                                                       "limit",
                                                       "filter_by"];
impl ListUsersOnPaperDocArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnPaperDocArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnPaperDocArgs>, V::Error> {
        let mut field_doc_id = None;
        let mut field_limit = None;
        let mut field_filter_by = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                "filter_by" => {
                    if field_filter_by.is_some() {
                        return Err(::serde::de::Error::duplicate_field("filter_by"));
                    }
                    field_filter_by = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnPaperDocArgs {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            limit: field_limit.unwrap_or(1000),
            filter_by: field_filter_by.unwrap_or(UserOnPaperDocFilter::Shared),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("limit", &self.limit)?;
        s.serialize_field("filter_by", &self.filter_by)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnPaperDocArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnPaperDocArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnPaperDocArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnPaperDocArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnPaperDocArgs", LIST_USERS_ON_PAPER_DOC_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnPaperDocArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnPaperDocArgs", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnPaperDocContinueArgs {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// The cursor obtained from [`docs_users_list()`](docs_users_list) or
    /// [`docs_users_list_continue()`](docs_users_list_continue). Allows for pagination.
    pub cursor: String,
}

impl ListUsersOnPaperDocContinueArgs {
    pub fn new(doc_id: PaperDocId, cursor: String) -> Self {
        ListUsersOnPaperDocContinueArgs {
            doc_id,
            cursor,
        }
    }
}

const LIST_USERS_ON_PAPER_DOC_CONTINUE_ARGS_FIELDS: &[&str] = &["doc_id",
                                                                "cursor"];
impl ListUsersOnPaperDocContinueArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnPaperDocContinueArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnPaperDocContinueArgs>, V::Error> {
        let mut field_doc_id = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnPaperDocContinueArgs {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnPaperDocContinueArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnPaperDocContinueArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnPaperDocContinueArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnPaperDocContinueArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnPaperDocContinueArgs", LIST_USERS_ON_PAPER_DOC_CONTINUE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnPaperDocContinueArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnPaperDocContinueArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListUsersOnPaperDocResponse {
    /// List of email addresses with their respective permission levels that are invited on the
    /// Paper doc.
    pub invitees: Vec<InviteeInfoWithPermissionLevel>,
    /// List of users with their respective permission levels that are invited on the Paper folder.
    pub users: Vec<UserInfoWithPermissionLevel>,
    /// The Paper doc owner. This field is populated on every single response.
    pub doc_owner: super::sharing::UserInfo,
    /// Pass the cursor into [`docs_users_list_continue()`](docs_users_list_continue) to paginate
    /// through all users. The cursor preserves all properties as specified in the original call to
    /// [`docs_users_list()`](docs_users_list).
    pub cursor: Cursor,
    /// Will be set to True if a subsequent call with the provided cursor to
    /// [`docs_users_list_continue()`](docs_users_list_continue) returns immediately with some
    /// results. If set to False please allow some delay before making another call to
    /// [`docs_users_list_continue()`](docs_users_list_continue).
    pub has_more: bool,
}

impl ListUsersOnPaperDocResponse {
    pub fn new(
        invitees: Vec<InviteeInfoWithPermissionLevel>,
        users: Vec<UserInfoWithPermissionLevel>,
        doc_owner: super::sharing::UserInfo,
        cursor: Cursor,
        has_more: bool,
    ) -> Self {
        ListUsersOnPaperDocResponse {
            invitees,
            users,
            doc_owner,
            cursor,
            has_more,
        }
    }
}

const LIST_USERS_ON_PAPER_DOC_RESPONSE_FIELDS: &[&str] = &["invitees",
                                                           "users",
                                                           "doc_owner",
                                                           "cursor",
                                                           "has_more"];
impl ListUsersOnPaperDocResponse {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListUsersOnPaperDocResponse, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListUsersOnPaperDocResponse>, V::Error> {
        let mut field_invitees = None;
        let mut field_users = None;
        let mut field_doc_owner = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "invitees" => {
                    if field_invitees.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitees"));
                    }
                    field_invitees = Some(map.next_value()?);
                }
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "doc_owner" => {
                    if field_doc_owner.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_owner"));
                    }
                    field_doc_owner = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListUsersOnPaperDocResponse {
            invitees: field_invitees.ok_or_else(|| ::serde::de::Error::missing_field("invitees"))?,
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            doc_owner: field_doc_owner.ok_or_else(|| ::serde::de::Error::missing_field("doc_owner"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("invitees", &self.invitees)?;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("doc_owner", &self.doc_owner)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListUsersOnPaperDocResponse {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListUsersOnPaperDocResponse;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListUsersOnPaperDocResponse struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListUsersOnPaperDocResponse::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListUsersOnPaperDocResponse", LIST_USERS_ON_PAPER_DOC_RESPONSE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListUsersOnPaperDocResponse {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListUsersOnPaperDocResponse", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperApiBaseError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperApiBaseError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperApiBaseError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperApiBaseError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperApiBaseError::InsufficientPermissions,
                    _ => PaperApiBaseError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other"];
        deserializer.deserialize_struct("PaperApiBaseError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperApiBaseError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperApiBaseError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperApiBaseError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperApiBaseError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperApiBaseError {
}

impl ::std::fmt::Display for PaperApiBaseError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperApiCursorError {
    /// The provided cursor is expired.
    ExpiredCursor,
    /// The provided cursor is invalid.
    InvalidCursor,
    /// The provided cursor contains invalid user.
    WrongUserInCursor,
    /// Indicates that the cursor has been invalidated. Call the corresponding non-continue endpoint
    /// to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperApiCursorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperApiCursorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperApiCursorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "expired_cursor" => PaperApiCursorError::ExpiredCursor,
                    "invalid_cursor" => PaperApiCursorError::InvalidCursor,
                    "wrong_user_in_cursor" => PaperApiCursorError::WrongUserInCursor,
                    "reset" => PaperApiCursorError::Reset,
                    _ => PaperApiCursorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["expired_cursor",
                                    "invalid_cursor",
                                    "wrong_user_in_cursor",
                                    "reset",
                                    "other"];
        deserializer.deserialize_struct("PaperApiCursorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperApiCursorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperApiCursorError::ExpiredCursor => {
                // unit
                let mut s = serializer.serialize_struct("PaperApiCursorError", 1)?;
                s.serialize_field(".tag", "expired_cursor")?;
                s.end()
            }
            PaperApiCursorError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("PaperApiCursorError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            PaperApiCursorError::WrongUserInCursor => {
                // unit
                let mut s = serializer.serialize_struct("PaperApiCursorError", 1)?;
                s.serialize_field(".tag", "wrong_user_in_cursor")?;
                s.end()
            }
            PaperApiCursorError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("PaperApiCursorError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            PaperApiCursorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperApiCursorError {
}

impl ::std::fmt::Display for PaperApiCursorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperApiCursorError::ExpiredCursor => f.write_str("The provided cursor is expired."),
            PaperApiCursorError::InvalidCursor => f.write_str("The provided cursor is invalid."),
            PaperApiCursorError::WrongUserInCursor => f.write_str("The provided cursor contains invalid user."),
            PaperApiCursorError::Reset => f.write_str("Indicates that the cursor has been invalidated. Call the corresponding non-continue endpoint to obtain a new cursor."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocCreateArgs {
    /// The format of provided data.
    pub import_format: ImportFormat,
    /// The Paper folder ID where the Paper document should be created. The API user has to have
    /// write access to this folder or error is thrown.
    pub parent_folder_id: Option<String>,
}

impl PaperDocCreateArgs {
    pub fn new(import_format: ImportFormat) -> Self {
        PaperDocCreateArgs {
            import_format,
            parent_folder_id: None,
        }
    }

    pub fn with_parent_folder_id(mut self, value: String) -> Self {
        self.parent_folder_id = Some(value);
        self
    }
}

const PAPER_DOC_CREATE_ARGS_FIELDS: &[&str] = &["import_format",
                                                "parent_folder_id"];
impl PaperDocCreateArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocCreateArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocCreateArgs>, V::Error> {
        let mut field_import_format = None;
        let mut field_parent_folder_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "import_format" => {
                    if field_import_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("import_format"));
                    }
                    field_import_format = Some(map.next_value()?);
                }
                "parent_folder_id" => {
                    if field_parent_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_folder_id"));
                    }
                    field_parent_folder_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocCreateArgs {
            import_format: field_import_format.ok_or_else(|| ::serde::de::Error::missing_field("import_format"))?,
            parent_folder_id: field_parent_folder_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("import_format", &self.import_format)?;
        if let Some(val) = &self.parent_folder_id {
            s.serialize_field("parent_folder_id", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocCreateArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocCreateArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocCreateArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocCreateArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocCreateArgs", PAPER_DOC_CREATE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocCreateArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocCreateArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDocCreateError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// The provided content was malformed and cannot be imported to Paper.
    ContentMalformed,
    /// The specified Paper folder is cannot be found.
    FolderNotFound,
    /// The newly created Paper doc would be too large. Please split the content into multiple docs.
    DocLengthExceeded,
    /// The imported document contains an image that is too large. The current limit is 1MB. This
    /// only applies to HTML with data URI.
    ImageSizeExceeded,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocCreateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDocCreateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocCreateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperDocCreateError::InsufficientPermissions,
                    "content_malformed" => PaperDocCreateError::ContentMalformed,
                    "folder_not_found" => PaperDocCreateError::FolderNotFound,
                    "doc_length_exceeded" => PaperDocCreateError::DocLengthExceeded,
                    "image_size_exceeded" => PaperDocCreateError::ImageSizeExceeded,
                    _ => PaperDocCreateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other",
                                    "content_malformed",
                                    "folder_not_found",
                                    "doc_length_exceeded",
                                    "image_size_exceeded"];
        deserializer.deserialize_struct("PaperDocCreateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocCreateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDocCreateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocCreateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperDocCreateError::ContentMalformed => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocCreateError", 1)?;
                s.serialize_field(".tag", "content_malformed")?;
                s.end()
            }
            PaperDocCreateError::FolderNotFound => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocCreateError", 1)?;
                s.serialize_field(".tag", "folder_not_found")?;
                s.end()
            }
            PaperDocCreateError::DocLengthExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocCreateError", 1)?;
                s.serialize_field(".tag", "doc_length_exceeded")?;
                s.end()
            }
            PaperDocCreateError::ImageSizeExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocCreateError", 1)?;
                s.serialize_field(".tag", "image_size_exceeded")?;
                s.end()
            }
            PaperDocCreateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperDocCreateError {
}

impl ::std::fmt::Display for PaperDocCreateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperDocCreateError::ContentMalformed => f.write_str("The provided content was malformed and cannot be imported to Paper."),
            PaperDocCreateError::FolderNotFound => f.write_str("The specified Paper folder is cannot be found."),
            PaperDocCreateError::DocLengthExceeded => f.write_str("The newly created Paper doc would be too large. Please split the content into multiple docs."),
            PaperDocCreateError::ImageSizeExceeded => f.write_str("The imported document contains an image that is too large. The current limit is 1MB. This only applies to HTML with data URI."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocCreateUpdateResult {
    /// Doc ID of the newly created doc.
    pub doc_id: String,
    /// The Paper doc revision. Simply an ever increasing number.
    pub revision: i64,
    /// The Paper doc title.
    pub title: String,
}

impl PaperDocCreateUpdateResult {
    pub fn new(doc_id: String, revision: i64, title: String) -> Self {
        PaperDocCreateUpdateResult {
            doc_id,
            revision,
            title,
        }
    }
}

const PAPER_DOC_CREATE_UPDATE_RESULT_FIELDS: &[&str] = &["doc_id",
                                                         "revision",
                                                         "title"];
impl PaperDocCreateUpdateResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocCreateUpdateResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocCreateUpdateResult>, V::Error> {
        let mut field_doc_id = None;
        let mut field_revision = None;
        let mut field_title = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "revision" => {
                    if field_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revision"));
                    }
                    field_revision = Some(map.next_value()?);
                }
                "title" => {
                    if field_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("title"));
                    }
                    field_title = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocCreateUpdateResult {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            revision: field_revision.ok_or_else(|| ::serde::de::Error::missing_field("revision"))?,
            title: field_title.ok_or_else(|| ::serde::de::Error::missing_field("title"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("revision", &self.revision)?;
        s.serialize_field("title", &self.title)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocCreateUpdateResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocCreateUpdateResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocCreateUpdateResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocCreateUpdateResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocCreateUpdateResult", PAPER_DOC_CREATE_UPDATE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocCreateUpdateResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocCreateUpdateResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocExport {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    pub export_format: ExportFormat,
}

impl PaperDocExport {
    pub fn new(doc_id: PaperDocId, export_format: ExportFormat) -> Self {
        PaperDocExport {
            doc_id,
            export_format,
        }
    }
}

const PAPER_DOC_EXPORT_FIELDS: &[&str] = &["doc_id",
                                           "export_format"];
impl PaperDocExport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocExport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocExport>, V::Error> {
        let mut field_doc_id = None;
        let mut field_export_format = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "export_format" => {
                    if field_export_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_format"));
                    }
                    field_export_format = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocExport {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            export_format: field_export_format.ok_or_else(|| ::serde::de::Error::missing_field("export_format"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("export_format", &self.export_format)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocExport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocExport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocExport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocExport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocExport", PAPER_DOC_EXPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocExport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocExport", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocExportResult {
    /// The Paper doc owner's email address.
    pub owner: String,
    /// The Paper doc title.
    pub title: String,
    /// The Paper doc revision. Simply an ever increasing number.
    pub revision: i64,
    /// MIME type of the export. This corresponds to [`ExportFormat`](ExportFormat) specified in the
    /// request.
    pub mime_type: String,
}

impl PaperDocExportResult {
    pub fn new(owner: String, title: String, revision: i64, mime_type: String) -> Self {
        PaperDocExportResult {
            owner,
            title,
            revision,
            mime_type,
        }
    }
}

const PAPER_DOC_EXPORT_RESULT_FIELDS: &[&str] = &["owner",
                                                  "title",
                                                  "revision",
                                                  "mime_type"];
impl PaperDocExportResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocExportResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocExportResult>, V::Error> {
        let mut field_owner = None;
        let mut field_title = None;
        let mut field_revision = None;
        let mut field_mime_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "owner" => {
                    if field_owner.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner"));
                    }
                    field_owner = Some(map.next_value()?);
                }
                "title" => {
                    if field_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("title"));
                    }
                    field_title = Some(map.next_value()?);
                }
                "revision" => {
                    if field_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revision"));
                    }
                    field_revision = Some(map.next_value()?);
                }
                "mime_type" => {
                    if field_mime_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mime_type"));
                    }
                    field_mime_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocExportResult {
            owner: field_owner.ok_or_else(|| ::serde::de::Error::missing_field("owner"))?,
            title: field_title.ok_or_else(|| ::serde::de::Error::missing_field("title"))?,
            revision: field_revision.ok_or_else(|| ::serde::de::Error::missing_field("revision"))?,
            mime_type: field_mime_type.ok_or_else(|| ::serde::de::Error::missing_field("mime_type"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("owner", &self.owner)?;
        s.serialize_field("title", &self.title)?;
        s.serialize_field("revision", &self.revision)?;
        s.serialize_field("mime_type", &self.mime_type)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocExportResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocExportResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocExportResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocExportResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocExportResult", PAPER_DOC_EXPORT_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocExportResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocExportResult", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDocPermissionLevel {
    /// User will be granted edit permissions.
    Edit,
    /// User will be granted view and comment permissions.
    ViewAndComment,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocPermissionLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDocPermissionLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocPermissionLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "edit" => PaperDocPermissionLevel::Edit,
                    "view_and_comment" => PaperDocPermissionLevel::ViewAndComment,
                    _ => PaperDocPermissionLevel::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["edit",
                                    "view_and_comment",
                                    "other"];
        deserializer.deserialize_struct("PaperDocPermissionLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocPermissionLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDocPermissionLevel::Edit => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocPermissionLevel", 1)?;
                s.serialize_field(".tag", "edit")?;
                s.end()
            }
            PaperDocPermissionLevel::ViewAndComment => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocPermissionLevel", 1)?;
                s.serialize_field(".tag", "view_and_comment")?;
                s.end()
            }
            PaperDocPermissionLevel::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocSharingPolicy {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// The default sharing policy to be set for the Paper doc.
    pub sharing_policy: SharingPolicy,
}

impl PaperDocSharingPolicy {
    pub fn new(doc_id: PaperDocId, sharing_policy: SharingPolicy) -> Self {
        PaperDocSharingPolicy {
            doc_id,
            sharing_policy,
        }
    }
}

const PAPER_DOC_SHARING_POLICY_FIELDS: &[&str] = &["doc_id",
                                                   "sharing_policy"];
impl PaperDocSharingPolicy {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocSharingPolicy, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocSharingPolicy>, V::Error> {
        let mut field_doc_id = None;
        let mut field_sharing_policy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "sharing_policy" => {
                    if field_sharing_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sharing_policy"));
                    }
                    field_sharing_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocSharingPolicy {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            sharing_policy: field_sharing_policy.ok_or_else(|| ::serde::de::Error::missing_field("sharing_policy"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("sharing_policy", &self.sharing_policy)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocSharingPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocSharingPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocSharingPolicy struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocSharingPolicy::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocSharingPolicy", PAPER_DOC_SHARING_POLICY_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocSharingPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocSharingPolicy", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperDocUpdateArgs {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// The policy used for the current update call.
    pub doc_update_policy: PaperDocUpdatePolicy,
    /// The latest doc revision. This value must match the head revision or an error code will be
    /// returned. This is to prevent colliding writes.
    pub revision: i64,
    /// The format of provided data.
    pub import_format: ImportFormat,
}

impl PaperDocUpdateArgs {
    pub fn new(
        doc_id: PaperDocId,
        doc_update_policy: PaperDocUpdatePolicy,
        revision: i64,
        import_format: ImportFormat,
    ) -> Self {
        PaperDocUpdateArgs {
            doc_id,
            doc_update_policy,
            revision,
            import_format,
        }
    }
}

const PAPER_DOC_UPDATE_ARGS_FIELDS: &[&str] = &["doc_id",
                                                "doc_update_policy",
                                                "revision",
                                                "import_format"];
impl PaperDocUpdateArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperDocUpdateArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperDocUpdateArgs>, V::Error> {
        let mut field_doc_id = None;
        let mut field_doc_update_policy = None;
        let mut field_revision = None;
        let mut field_import_format = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "doc_update_policy" => {
                    if field_doc_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_update_policy"));
                    }
                    field_doc_update_policy = Some(map.next_value()?);
                }
                "revision" => {
                    if field_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revision"));
                    }
                    field_revision = Some(map.next_value()?);
                }
                "import_format" => {
                    if field_import_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("import_format"));
                    }
                    field_import_format = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperDocUpdateArgs {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            doc_update_policy: field_doc_update_policy.ok_or_else(|| ::serde::de::Error::missing_field("doc_update_policy"))?,
            revision: field_revision.ok_or_else(|| ::serde::de::Error::missing_field("revision"))?,
            import_format: field_import_format.ok_or_else(|| ::serde::de::Error::missing_field("import_format"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("doc_update_policy", &self.doc_update_policy)?;
        s.serialize_field("revision", &self.revision)?;
        s.serialize_field("import_format", &self.import_format)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocUpdateArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperDocUpdateArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocUpdateArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperDocUpdateArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperDocUpdateArgs", PAPER_DOC_UPDATE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocUpdateArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperDocUpdateArgs", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDocUpdateError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// The required doc was not found.
    DocNotFound,
    /// The provided content was malformed and cannot be imported to Paper.
    ContentMalformed,
    /// The provided revision does not match the document head.
    RevisionMismatch,
    /// The newly created Paper doc would be too large, split the content into multiple docs.
    DocLengthExceeded,
    /// The imported document contains an image that is too large. The current limit is 1MB. This
    /// only applies to HTML with data URI.
    ImageSizeExceeded,
    /// This operation is not allowed on archived Paper docs.
    DocArchived,
    /// This operation is not allowed on deleted Paper docs.
    DocDeleted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocUpdateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDocUpdateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocUpdateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperDocUpdateError::InsufficientPermissions,
                    "doc_not_found" => PaperDocUpdateError::DocNotFound,
                    "content_malformed" => PaperDocUpdateError::ContentMalformed,
                    "revision_mismatch" => PaperDocUpdateError::RevisionMismatch,
                    "doc_length_exceeded" => PaperDocUpdateError::DocLengthExceeded,
                    "image_size_exceeded" => PaperDocUpdateError::ImageSizeExceeded,
                    "doc_archived" => PaperDocUpdateError::DocArchived,
                    "doc_deleted" => PaperDocUpdateError::DocDeleted,
                    _ => PaperDocUpdateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other",
                                    "doc_not_found",
                                    "content_malformed",
                                    "revision_mismatch",
                                    "doc_length_exceeded",
                                    "image_size_exceeded",
                                    "doc_archived",
                                    "doc_deleted"];
        deserializer.deserialize_struct("PaperDocUpdateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocUpdateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDocUpdateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperDocUpdateError::DocNotFound => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "doc_not_found")?;
                s.end()
            }
            PaperDocUpdateError::ContentMalformed => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "content_malformed")?;
                s.end()
            }
            PaperDocUpdateError::RevisionMismatch => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "revision_mismatch")?;
                s.end()
            }
            PaperDocUpdateError::DocLengthExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "doc_length_exceeded")?;
                s.end()
            }
            PaperDocUpdateError::ImageSizeExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "image_size_exceeded")?;
                s.end()
            }
            PaperDocUpdateError::DocArchived => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "doc_archived")?;
                s.end()
            }
            PaperDocUpdateError::DocDeleted => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdateError", 1)?;
                s.serialize_field(".tag", "doc_deleted")?;
                s.end()
            }
            PaperDocUpdateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperDocUpdateError {
}

impl ::std::fmt::Display for PaperDocUpdateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperDocUpdateError::DocNotFound => f.write_str("The required doc was not found."),
            PaperDocUpdateError::ContentMalformed => f.write_str("The provided content was malformed and cannot be imported to Paper."),
            PaperDocUpdateError::RevisionMismatch => f.write_str("The provided revision does not match the document head."),
            PaperDocUpdateError::DocLengthExceeded => f.write_str("The newly created Paper doc would be too large, split the content into multiple docs."),
            PaperDocUpdateError::ImageSizeExceeded => f.write_str("The imported document contains an image that is too large. The current limit is 1MB. This only applies to HTML with data URI."),
            PaperDocUpdateError::DocArchived => f.write_str("This operation is not allowed on archived Paper docs."),
            PaperDocUpdateError::DocDeleted => f.write_str("This operation is not allowed on deleted Paper docs."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDocUpdatePolicy {
    /// The content will be appended to the doc.
    Append,
    /// The content will be prepended to the doc. The doc title will not be affected.
    Prepend,
    /// The document will be overwitten at the head with the provided content.
    OverwriteAll,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocUpdatePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDocUpdatePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocUpdatePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "append" => PaperDocUpdatePolicy::Append,
                    "prepend" => PaperDocUpdatePolicy::Prepend,
                    "overwrite_all" => PaperDocUpdatePolicy::OverwriteAll,
                    _ => PaperDocUpdatePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["append",
                                    "prepend",
                                    "overwrite_all",
                                    "other"];
        deserializer.deserialize_struct("PaperDocUpdatePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocUpdatePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDocUpdatePolicy::Append => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "append")?;
                s.end()
            }
            PaperDocUpdatePolicy::Prepend => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "prepend")?;
                s.end()
            }
            PaperDocUpdatePolicy::OverwriteAll => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "overwrite_all")?;
                s.end()
            }
            PaperDocUpdatePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperFolderCreateArg {
    /// The name of the new Paper folder.
    pub name: String,
    /// The encrypted Paper folder Id where the new Paper folder should be created. The API user has
    /// to have write access to this folder or error is thrown. If not supplied, the new folder will
    /// be created at top level.
    pub parent_folder_id: Option<String>,
    /// Whether the folder to be created should be a team folder. This value will be ignored if
    /// parent_folder_id is supplied, as the new folder will inherit the type (private or team
    /// folder) from its parent. We will by default create a top-level private folder if both
    /// parent_folder_id and is_team_folder are not supplied.
    pub is_team_folder: Option<bool>,
}

impl PaperFolderCreateArg {
    pub fn new(name: String) -> Self {
        PaperFolderCreateArg {
            name,
            parent_folder_id: None,
            is_team_folder: None,
        }
    }

    pub fn with_parent_folder_id(mut self, value: String) -> Self {
        self.parent_folder_id = Some(value);
        self
    }

    pub fn with_is_team_folder(mut self, value: bool) -> Self {
        self.is_team_folder = Some(value);
        self
    }
}

const PAPER_FOLDER_CREATE_ARG_FIELDS: &[&str] = &["name",
                                                  "parent_folder_id",
                                                  "is_team_folder"];
impl PaperFolderCreateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperFolderCreateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperFolderCreateArg>, V::Error> {
        let mut field_name = None;
        let mut field_parent_folder_id = None;
        let mut field_is_team_folder = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "parent_folder_id" => {
                    if field_parent_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_folder_id"));
                    }
                    field_parent_folder_id = Some(map.next_value()?);
                }
                "is_team_folder" => {
                    if field_is_team_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_team_folder"));
                    }
                    field_is_team_folder = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperFolderCreateArg {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            parent_folder_id: field_parent_folder_id,
            is_team_folder: field_is_team_folder,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        if let Some(val) = &self.parent_folder_id {
            s.serialize_field("parent_folder_id", val)?;
        }
        if let Some(val) = &self.is_team_folder {
            s.serialize_field("is_team_folder", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperFolderCreateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperFolderCreateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperFolderCreateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperFolderCreateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperFolderCreateArg", PAPER_FOLDER_CREATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperFolderCreateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperFolderCreateArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperFolderCreateError {
    /// Your account does not have permissions to perform this action. This may be due to it only
    /// having access to Paper as files in the Dropbox filesystem. For more information, refer to
    /// the [Paper Migration
    /// Guide](https://www.dropbox.com/lp/developers/reference/paper-migration-guide).
    InsufficientPermissions,
    /// The specified parent Paper folder cannot be found.
    FolderNotFound,
    /// The folder id cannot be decrypted to valid folder id.
    InvalidFolderId,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperFolderCreateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperFolderCreateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperFolderCreateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperFolderCreateError::InsufficientPermissions,
                    "folder_not_found" => PaperFolderCreateError::FolderNotFound,
                    "invalid_folder_id" => PaperFolderCreateError::InvalidFolderId,
                    _ => PaperFolderCreateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "other",
                                    "folder_not_found",
                                    "invalid_folder_id"];
        deserializer.deserialize_struct("PaperFolderCreateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperFolderCreateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperFolderCreateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperFolderCreateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperFolderCreateError::FolderNotFound => {
                // unit
                let mut s = serializer.serialize_struct("PaperFolderCreateError", 1)?;
                s.serialize_field(".tag", "folder_not_found")?;
                s.end()
            }
            PaperFolderCreateError::InvalidFolderId => {
                // unit
                let mut s = serializer.serialize_struct("PaperFolderCreateError", 1)?;
                s.serialize_field(".tag", "invalid_folder_id")?;
                s.end()
            }
            PaperFolderCreateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperFolderCreateError {
}

impl ::std::fmt::Display for PaperFolderCreateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperFolderCreateError::FolderNotFound => f.write_str("The specified parent Paper folder cannot be found."),
            PaperFolderCreateError::InvalidFolderId => f.write_str("The folder id cannot be decrypted to valid folder id."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperFolderCreateResult {
    /// Folder ID of the newly created folder.
    pub folder_id: String,
}

impl PaperFolderCreateResult {
    pub fn new(folder_id: String) -> Self {
        PaperFolderCreateResult {
            folder_id,
        }
    }
}

const PAPER_FOLDER_CREATE_RESULT_FIELDS: &[&str] = &["folder_id"];
impl PaperFolderCreateResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperFolderCreateResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperFolderCreateResult>, V::Error> {
        let mut field_folder_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "folder_id" => {
                    if field_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("folder_id"));
                    }
                    field_folder_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperFolderCreateResult {
            folder_id: field_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("folder_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("folder_id", &self.folder_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperFolderCreateResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperFolderCreateResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperFolderCreateResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperFolderCreateResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperFolderCreateResult", PAPER_FOLDER_CREATE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperFolderCreateResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperFolderCreateResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RefPaperDoc {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
}

impl RefPaperDoc {
    pub fn new(doc_id: PaperDocId) -> Self {
        RefPaperDoc {
            doc_id,
        }
    }
}

const REF_PAPER_DOC_FIELDS: &[&str] = &["doc_id"];
impl RefPaperDoc {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RefPaperDoc, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RefPaperDoc>, V::Error> {
        let mut field_doc_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RefPaperDoc {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RefPaperDoc {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RefPaperDoc;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RefPaperDoc struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RefPaperDoc::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RefPaperDoc", REF_PAPER_DOC_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RefPaperDoc {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RefPaperDoc", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RemovePaperDocUser {
    /// The Paper doc ID.
    pub doc_id: PaperDocId,
    /// User which should be removed from the Paper doc. Specify only email address or Dropbox
    /// account ID.
    pub member: super::sharing::MemberSelector,
}

impl RemovePaperDocUser {
    pub fn new(doc_id: PaperDocId, member: super::sharing::MemberSelector) -> Self {
        RemovePaperDocUser {
            doc_id,
            member,
        }
    }
}

const REMOVE_PAPER_DOC_USER_FIELDS: &[&str] = &["doc_id",
                                                "member"];
impl RemovePaperDocUser {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RemovePaperDocUser, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RemovePaperDocUser>, V::Error> {
        let mut field_doc_id = None;
        let mut field_member = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "doc_id" => {
                    if field_doc_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_id"));
                    }
                    field_doc_id = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RemovePaperDocUser {
            doc_id: field_doc_id.ok_or_else(|| ::serde::de::Error::missing_field("doc_id"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("doc_id", &self.doc_id)?;
        s.serialize_field("member", &self.member)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RemovePaperDocUser {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RemovePaperDocUser;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemovePaperDocUser struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RemovePaperDocUser::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RemovePaperDocUser", REMOVE_PAPER_DOC_USER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RemovePaperDocUser {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RemovePaperDocUser", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sharing policy of Paper doc.
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharingPolicy {
    /// This value applies to the non-team members.
    pub public_sharing_policy: Option<SharingPublicPolicyType>,
    /// This value applies to the team members only. The value is null for all personal accounts.
    pub team_sharing_policy: Option<SharingTeamPolicyType>,
}

impl SharingPolicy {
    pub fn with_public_sharing_policy(mut self, value: SharingPublicPolicyType) -> Self {
        self.public_sharing_policy = Some(value);
        self
    }

    pub fn with_team_sharing_policy(mut self, value: SharingTeamPolicyType) -> Self {
        self.team_sharing_policy = Some(value);
        self
    }
}

const SHARING_POLICY_FIELDS: &[&str] = &["public_sharing_policy",
                                         "team_sharing_policy"];
impl SharingPolicy {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<SharingPolicy, V::Error> {
        let mut field_public_sharing_policy = None;
        let mut field_team_sharing_policy = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "public_sharing_policy" => {
                    if field_public_sharing_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("public_sharing_policy"));
                    }
                    field_public_sharing_policy = Some(map.next_value()?);
                }
                "team_sharing_policy" => {
                    if field_team_sharing_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_sharing_policy"));
                    }
                    field_team_sharing_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = SharingPolicy {
            public_sharing_policy: field_public_sharing_policy,
            team_sharing_policy: field_team_sharing_policy,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.public_sharing_policy {
            s.serialize_field("public_sharing_policy", val)?;
        }
        if let Some(val) = &self.team_sharing_policy {
            s.serialize_field("team_sharing_policy", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharingPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharingPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingPolicy struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharingPolicy::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharingPolicy", SHARING_POLICY_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharingPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharingPolicy", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum SharingPublicPolicyType {
    /// Users who have a link to this doc can edit it.
    PeopleWithLinkCanEdit,
    /// Users who have a link to this doc can view and comment on it.
    PeopleWithLinkCanViewAndComment,
    /// Users must be explicitly invited to this doc.
    InviteOnly,
    /// Value used to indicate that doc sharing is enabled only within team.
    Disabled,
}

impl<'de> ::serde::de::Deserialize<'de> for SharingPublicPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharingPublicPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingPublicPolicyType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "people_with_link_can_edit" => SharingPublicPolicyType::PeopleWithLinkCanEdit,
                    "people_with_link_can_view_and_comment" => SharingPublicPolicyType::PeopleWithLinkCanViewAndComment,
                    "invite_only" => SharingPublicPolicyType::InviteOnly,
                    "disabled" => SharingPublicPolicyType::Disabled,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["people_with_link_can_edit",
                                    "people_with_link_can_view_and_comment",
                                    "invite_only",
                                    "disabled"];
        deserializer.deserialize_struct("SharingPublicPolicyType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharingPublicPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharingPublicPolicyType::PeopleWithLinkCanEdit => {
                // unit
                let mut s = serializer.serialize_struct("SharingPublicPolicyType", 1)?;
                s.serialize_field(".tag", "people_with_link_can_edit")?;
                s.end()
            }
            SharingPublicPolicyType::PeopleWithLinkCanViewAndComment => {
                // unit
                let mut s = serializer.serialize_struct("SharingPublicPolicyType", 1)?;
                s.serialize_field(".tag", "people_with_link_can_view_and_comment")?;
                s.end()
            }
            SharingPublicPolicyType::InviteOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharingPublicPolicyType", 1)?;
                s.serialize_field(".tag", "invite_only")?;
                s.end()
            }
            SharingPublicPolicyType::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("SharingPublicPolicyType", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
        }
    }
}

/// The sharing policy type of the Paper doc.
#[derive(Debug, Clone, PartialEq)]
pub enum SharingTeamPolicyType {
    /// Users who have a link to this doc can edit it.
    PeopleWithLinkCanEdit,
    /// Users who have a link to this doc can view and comment on it.
    PeopleWithLinkCanViewAndComment,
    /// Users must be explicitly invited to this doc.
    InviteOnly,
}

impl<'de> ::serde::de::Deserialize<'de> for SharingTeamPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharingTeamPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingTeamPolicyType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "people_with_link_can_edit" => SharingTeamPolicyType::PeopleWithLinkCanEdit,
                    "people_with_link_can_view_and_comment" => SharingTeamPolicyType::PeopleWithLinkCanViewAndComment,
                    "invite_only" => SharingTeamPolicyType::InviteOnly,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["people_with_link_can_edit",
                                    "people_with_link_can_view_and_comment",
                                    "invite_only"];
        deserializer.deserialize_struct("SharingTeamPolicyType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharingTeamPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharingTeamPolicyType::PeopleWithLinkCanEdit => {
                // unit
                let mut s = serializer.serialize_struct("SharingTeamPolicyType", 1)?;
                s.serialize_field(".tag", "people_with_link_can_edit")?;
                s.end()
            }
            SharingTeamPolicyType::PeopleWithLinkCanViewAndComment => {
                // unit
                let mut s = serializer.serialize_struct("SharingTeamPolicyType", 1)?;
                s.serialize_field(".tag", "people_with_link_can_view_and_comment")?;
                s.end()
            }
            SharingTeamPolicyType::InviteOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharingTeamPolicyType", 1)?;
                s.serialize_field(".tag", "invite_only")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserInfoWithPermissionLevel {
    /// User shared on the Paper doc.
    pub user: super::sharing::UserInfo,
    /// Permission level for the user.
    pub permission_level: PaperDocPermissionLevel,
}

impl UserInfoWithPermissionLevel {
    pub fn new(user: super::sharing::UserInfo, permission_level: PaperDocPermissionLevel) -> Self {
        UserInfoWithPermissionLevel {
            user,
            permission_level,
        }
    }
}

const USER_INFO_WITH_PERMISSION_LEVEL_FIELDS: &[&str] = &["user",
                                                          "permission_level"];
impl UserInfoWithPermissionLevel {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserInfoWithPermissionLevel, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserInfoWithPermissionLevel>, V::Error> {
        let mut field_user = None;
        let mut field_permission_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "permission_level" => {
                    if field_permission_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permission_level"));
                    }
                    field_permission_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserInfoWithPermissionLevel {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            permission_level: field_permission_level.ok_or_else(|| ::serde::de::Error::missing_field("permission_level"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("permission_level", &self.permission_level)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserInfoWithPermissionLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserInfoWithPermissionLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserInfoWithPermissionLevel struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserInfoWithPermissionLevel::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserInfoWithPermissionLevel", USER_INFO_WITH_PERMISSION_LEVEL_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserInfoWithPermissionLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserInfoWithPermissionLevel", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UserOnPaperDocFilter {
    /// all users who have visited the Paper doc.
    Visited,
    /// All uses who are shared on the Paper doc. This includes all users who have visited the Paper
    /// doc as well as those who have not.
    Shared,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UserOnPaperDocFilter {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UserOnPaperDocFilter;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserOnPaperDocFilter structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "visited" => UserOnPaperDocFilter::Visited,
                    "shared" => UserOnPaperDocFilter::Shared,
                    _ => UserOnPaperDocFilter::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["visited",
                                    "shared",
                                    "other"];
        deserializer.deserialize_struct("UserOnPaperDocFilter", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UserOnPaperDocFilter {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UserOnPaperDocFilter::Visited => {
                // unit
                let mut s = serializer.serialize_struct("UserOnPaperDocFilter", 1)?;
                s.serialize_field(".tag", "visited")?;
                s.end()
            }
            UserOnPaperDocFilter::Shared => {
                // unit
                let mut s = serializer.serialize_struct("UserOnPaperDocFilter", 1)?;
                s.serialize_field(".tag", "shared")?;
                s.end()
            }
            UserOnPaperDocFilter::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

