// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

pub type GroupsGetInfoResult = Vec<GroupsGetInfoItem>;
pub type LegalHoldId = String;
pub type LegalHoldPolicyDescription = String;
pub type LegalHoldPolicyName = String;
pub type LegalHoldsGetPolicyResult = LegalHoldPolicy;
pub type LegalHoldsPolicyCreateResult = LegalHoldPolicy;
pub type LegalHoldsPolicyUpdateResult = LegalHoldPolicy;
pub type ListHeldRevisionCursor = String;
pub type MembersGetInfoResult = Vec<MembersGetInfoItem>;
pub type NumberPerDay = Vec<Option<u64>>;
pub type Path = String;
pub type SecondaryEmail = super::secondary_emails::SecondaryEmail;
pub type TeamMemberRoleId = String;
pub type UserQuota = u32;

/// List all device sessions of a team's member.
pub fn devices_list_member_devices(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListMemberDevicesArg,
) -> crate::Result<Result<ListMemberDevicesResult, ListMemberDevicesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/devices/list_member_devices",
        arg,
        None)
}

/// List all device sessions of a team. Permission : Team member file access.
pub fn devices_list_members_devices(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListMembersDevicesArg,
) -> crate::Result<Result<ListMembersDevicesResult, ListMembersDevicesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/devices/list_members_devices",
        arg,
        None)
}

/// List all device sessions of a team. Permission : Team member file access.
#[deprecated(note = "replaced by devices_list_members_devices")]
pub fn devices_list_team_devices(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListTeamDevicesArg,
) -> crate::Result<Result<ListTeamDevicesResult, ListTeamDevicesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/devices/list_team_devices",
        arg,
        None)
}

/// Revoke a device session of a team's member.
pub fn devices_revoke_device_session(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &RevokeDeviceSessionArg,
) -> crate::Result<Result<(), RevokeDeviceSessionError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/devices/revoke_device_session",
        arg,
        None)
}

/// Revoke a list of device sessions of team members.
pub fn devices_revoke_device_session_batch(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &RevokeDeviceSessionBatchArg,
) -> crate::Result<Result<RevokeDeviceSessionBatchResult, RevokeDeviceSessionBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/devices/revoke_device_session_batch",
        arg,
        None)
}

/// Get the values for one or more featues. This route allows you to check your account's capability
/// for what feature you can access or what value you have for certain features. Permission : Team
/// information.
pub fn features_get_values(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &FeaturesGetValuesBatchArg,
) -> crate::Result<Result<FeaturesGetValuesBatchResult, FeaturesGetValuesBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/features/get_values",
        arg,
        None)
}

/// Retrieves information about a team.
pub fn get_info(
    client: &impl crate::client_trait::TeamAuthClient,
) -> crate::Result<Result<TeamGetInfoResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/get_info",
        &(),
        None)
}

/// Creates a new, empty group, with a requested name. Permission : Team member management.
pub fn groups_create(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupCreateArg,
) -> crate::Result<Result<GroupFullInfo, GroupCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/create",
        arg,
        None)
}

/// Deletes a group. The group is deleted immediately. However the revoking of group-owned resources
/// may take additional time. Use the [`groups_job_status_get()`](groups_job_status_get) to
/// determine whether this process has completed. Permission : Team member management.
pub fn groups_delete(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupSelector,
) -> crate::Result<Result<super::dbx_async::LaunchEmptyResult, GroupDeleteError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/delete",
        arg,
        None)
}

/// Retrieves information about one or more groups. Note that the optional field
/// [`GroupFullInfo::members`](GroupFullInfo) is not returned for system-managed groups. Permission
/// : Team Information.
pub fn groups_get_info(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupsSelector,
) -> crate::Result<Result<GroupsGetInfoResult, GroupsGetInfoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/get_info",
        arg,
        None)
}

/// Once an async_job_id is returned from [`groups_delete()`](groups_delete),
/// [`groups_members_add()`](groups_members_add) , or
/// [`groups_members_remove()`](groups_members_remove) use this method to poll the status of
/// granting/revoking group members' access to group-owned resources. Permission : Team member
/// management.
pub fn groups_job_status_get(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<super::dbx_async::PollEmptyResult, GroupsPollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/job_status/get",
        arg,
        None)
}

/// Lists groups on a team. Permission : Team Information.
pub fn groups_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupsListArg,
) -> crate::Result<Result<GroupsListResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`groups_list()`](groups_list), use this to paginate
/// through all groups. Permission : Team Information.
pub fn groups_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupsListContinueArg,
) -> crate::Result<Result<GroupsListResult, GroupsListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/list/continue",
        arg,
        None)
}

/// Adds members to a group. The members are added immediately. However the granting of group-owned
/// resources may take additional time. Use the [`groups_job_status_get()`](groups_job_status_get)
/// to determine whether this process has completed. Permission : Team member management.
pub fn groups_members_add(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupMembersAddArg,
) -> crate::Result<Result<GroupMembersChangeResult, GroupMembersAddError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/members/add",
        arg,
        None)
}

/// Lists members of a group. Permission : Team Information.
pub fn groups_members_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupsMembersListArg,
) -> crate::Result<Result<GroupsMembersListResult, GroupSelectorError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/members/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`groups_members_list()`](groups_members_list), use this
/// to paginate through all members of the group. Permission : Team information.
pub fn groups_members_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupsMembersListContinueArg,
) -> crate::Result<Result<GroupsMembersListResult, GroupsMembersListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/members/list/continue",
        arg,
        None)
}

/// Removes members from a group. The members are removed immediately. However the revoking of
/// group-owned resources may take additional time. Use the
/// [`groups_job_status_get()`](groups_job_status_get) to determine whether this process has
/// completed. This method permits removing the only owner of a group, even in cases where this is
/// not possible via the web client. Permission : Team member management.
pub fn groups_members_remove(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupMembersRemoveArg,
) -> crate::Result<Result<GroupMembersChangeResult, GroupMembersRemoveError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/members/remove",
        arg,
        None)
}

/// Sets a member's access type in a group. Permission : Team member management.
pub fn groups_members_set_access_type(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupMembersSetAccessTypeArg,
) -> crate::Result<Result<GroupsGetInfoResult, GroupMemberSetAccessTypeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/members/set_access_type",
        arg,
        None)
}

/// Updates a group's name and/or external ID. Permission : Team member management.
pub fn groups_update(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GroupUpdateArgs,
) -> crate::Result<Result<GroupFullInfo, GroupUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/groups/update",
        arg,
        None)
}

/// Creates new legal hold policy. Note: Legal Holds is a paid add-on. Not all teams have the
/// feature. Permission : Team member file access.
pub fn legal_holds_create_policy(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsPolicyCreateArg,
) -> crate::Result<Result<LegalHoldsPolicyCreateResult, LegalHoldsPolicyCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/create_policy",
        arg,
        None)
}

/// Gets a legal hold by Id. Note: Legal Holds is a paid add-on. Not all teams have the feature.
/// Permission : Team member file access.
pub fn legal_holds_get_policy(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsGetPolicyArg,
) -> crate::Result<Result<LegalHoldsGetPolicyResult, LegalHoldsGetPolicyError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/get_policy",
        arg,
        None)
}

/// List the file metadata that's under the hold. Note: Legal Holds is a paid add-on. Not all teams
/// have the feature. Permission : Team member file access.
pub fn legal_holds_list_held_revisions(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsListHeldRevisionsArg,
) -> crate::Result<Result<LegalHoldsListHeldRevisionResult, LegalHoldsListHeldRevisionsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/list_held_revisions",
        arg,
        None)
}

/// Continue listing the file metadata that's under the hold. Note: Legal Holds is a paid add-on.
/// Not all teams have the feature. Permission : Team member file access.
pub fn legal_holds_list_held_revisions_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsListHeldRevisionsContinueArg,
) -> crate::Result<Result<LegalHoldsListHeldRevisionResult, LegalHoldsListHeldRevisionsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/list_held_revisions_continue",
        arg,
        None)
}

/// Lists legal holds on a team. Note: Legal Holds is a paid add-on. Not all teams have the feature.
/// Permission : Team member file access.
pub fn legal_holds_list_policies(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsListPoliciesArg,
) -> crate::Result<Result<LegalHoldsListPoliciesResult, LegalHoldsListPoliciesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/list_policies",
        arg,
        None)
}

/// Releases a legal hold by Id. Note: Legal Holds is a paid add-on. Not all teams have the feature.
/// Permission : Team member file access.
pub fn legal_holds_release_policy(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsPolicyReleaseArg,
) -> crate::Result<Result<(), LegalHoldsPolicyReleaseError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/release_policy",
        arg,
        None)
}

/// Updates a legal hold. Note: Legal Holds is a paid add-on. Not all teams have the feature.
/// Permission : Team member file access.
pub fn legal_holds_update_policy(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &LegalHoldsPolicyUpdateArg,
) -> crate::Result<Result<LegalHoldsPolicyUpdateResult, LegalHoldsPolicyUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/legal_holds/update_policy",
        arg,
        None)
}

/// List all linked applications of the team member. Note, this endpoint does not list any
/// team-linked applications.
pub fn linked_apps_list_member_linked_apps(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListMemberAppsArg,
) -> crate::Result<Result<ListMemberAppsResult, ListMemberAppsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/linked_apps/list_member_linked_apps",
        arg,
        None)
}

/// List all applications linked to the team members' accounts. Note, this endpoint does not list
/// any team-linked applications.
pub fn linked_apps_list_members_linked_apps(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListMembersAppsArg,
) -> crate::Result<Result<ListMembersAppsResult, ListMembersAppsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/linked_apps/list_members_linked_apps",
        arg,
        None)
}

/// List all applications linked to the team members' accounts. Note, this endpoint doesn't list any
/// team-linked applications.
#[deprecated(note = "replaced by linked_apps_list_members_linked_apps")]
pub fn linked_apps_list_team_linked_apps(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ListTeamAppsArg,
) -> crate::Result<Result<ListTeamAppsResult, ListTeamAppsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/linked_apps/list_team_linked_apps",
        arg,
        None)
}

/// Revoke a linked application of the team member.
pub fn linked_apps_revoke_linked_app(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &RevokeLinkedApiAppArg,
) -> crate::Result<Result<(), RevokeLinkedAppError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/linked_apps/revoke_linked_app",
        arg,
        None)
}

/// Revoke a list of linked applications of the team members.
pub fn linked_apps_revoke_linked_app_batch(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &RevokeLinkedApiAppBatchArg,
) -> crate::Result<Result<RevokeLinkedAppBatchResult, RevokeLinkedAppBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/linked_apps/revoke_linked_app_batch",
        arg,
        None)
}

/// Add users to member space limits excluded users list.
pub fn member_space_limits_excluded_users_add(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ExcludedUsersUpdateArg,
) -> crate::Result<Result<ExcludedUsersUpdateResult, ExcludedUsersUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/excluded_users/add",
        arg,
        None)
}

/// List member space limits excluded users.
pub fn member_space_limits_excluded_users_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ExcludedUsersListArg,
) -> crate::Result<Result<ExcludedUsersListResult, ExcludedUsersListError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/excluded_users/list",
        arg,
        None)
}

/// Continue listing member space limits excluded users.
pub fn member_space_limits_excluded_users_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ExcludedUsersListContinueArg,
) -> crate::Result<Result<ExcludedUsersListResult, ExcludedUsersListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/excluded_users/list/continue",
        arg,
        None)
}

/// Remove users from member space limits excluded users list.
pub fn member_space_limits_excluded_users_remove(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ExcludedUsersUpdateArg,
) -> crate::Result<Result<ExcludedUsersUpdateResult, ExcludedUsersUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/excluded_users/remove",
        arg,
        None)
}

/// Get users custom quota. Returns none as the custom quota if none was set. A maximum of 1000
/// members can be specified in a single call.
pub fn member_space_limits_get_custom_quota(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &CustomQuotaUsersArg,
) -> crate::Result<Result<Vec<CustomQuotaResult>, CustomQuotaError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/get_custom_quota",
        arg,
        None)
}

/// Remove users custom quota. A maximum of 1000 members can be specified in a single call.
pub fn member_space_limits_remove_custom_quota(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &CustomQuotaUsersArg,
) -> crate::Result<Result<Vec<RemoveCustomQuotaResult>, CustomQuotaError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/remove_custom_quota",
        arg,
        None)
}

/// Set users custom quota. Custom quota has to be at least 15GB. A maximum of 1000 members can be
/// specified in a single call.
pub fn member_space_limits_set_custom_quota(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &SetCustomQuotaArg,
) -> crate::Result<Result<Vec<CustomQuotaResult>, SetCustomQuotaError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/member_space_limits/set_custom_quota",
        arg,
        None)
}

/// Adds members to a team. Permission : Team member management A maximum of 20 members can be
/// specified in a single call. If no Dropbox account exists with the email address specified, a new
/// Dropbox account will be created with the given email address, and that account will be invited
/// to the team. If a personal Dropbox account exists with the email address specified in the call,
/// this call will create a placeholder Dropbox account for the user on the team and send an email
/// inviting the user to migrate their existing personal account onto the team. Team member
/// management apps are required to set an initial given_name and surname for a user to use in the
/// team invitation and for 'Perform as team member' actions taken on the user before they become
/// 'active'.
pub fn members_add_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersAddV2Arg,
) -> crate::Result<Result<MembersAddLaunchV2Result, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/add_v2",
        arg,
        None)
}

/// Adds members to a team. Permission : Team member management A maximum of 20 members can be
/// specified in a single call. If no Dropbox account exists with the email address specified, a new
/// Dropbox account will be created with the given email address, and that account will be invited
/// to the team. If a personal Dropbox account exists with the email address specified in the call,
/// this call will create a placeholder Dropbox account for the user on the team and send an email
/// inviting the user to migrate their existing personal account onto the team. Team member
/// management apps are required to set an initial given_name and surname for a user to use in the
/// team invitation and for 'Perform as team member' actions taken on the user before they become
/// 'active'.
pub fn members_add(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersAddArg,
) -> crate::Result<Result<MembersAddLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/add",
        arg,
        None)
}

/// Once an async_job_id is returned from [`members_add_v2()`](members_add_v2) , use this to poll
/// the status of the asynchronous request. Permission : Team member management.
pub fn members_add_job_status_get_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<MembersAddJobStatusV2Result, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/add/job_status/get_v2",
        arg,
        None)
}

/// Once an async_job_id is returned from [`members_add()`](members_add) , use this to poll the
/// status of the asynchronous request. Permission : Team member management.
pub fn members_add_job_status_get(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<MembersAddJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/add/job_status/get",
        arg,
        None)
}

/// Deletes a team member's profile photo. Permission : Team member management.
pub fn members_delete_profile_photo_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersDeleteProfilePhotoArg,
) -> crate::Result<Result<TeamMemberInfoV2Result, MembersDeleteProfilePhotoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/delete_profile_photo_v2",
        arg,
        None)
}

/// Deletes a team member's profile photo. Permission : Team member management.
pub fn members_delete_profile_photo(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersDeleteProfilePhotoArg,
) -> crate::Result<Result<TeamMemberInfo, MembersDeleteProfilePhotoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/delete_profile_photo",
        arg,
        None)
}

/// Get available TeamMemberRoles for the connected team. To be used with
/// [`members_set_admin_permissions_v2()`](members_set_admin_permissions_v2). Permission : Team
/// member management.
pub fn members_get_available_team_member_roles(
    client: &impl crate::client_trait::TeamAuthClient,
) -> crate::Result<Result<MembersGetAvailableTeamMemberRolesResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/get_available_team_member_roles",
        &(),
        None)
}

/// Returns information about multiple team members. Permission : Team information This endpoint
/// will return [`MembersGetInfoItem::IdNotFound`](MembersGetInfoItem::IdNotFound), for IDs (or
/// emails) that cannot be matched to a valid team member.
pub fn members_get_info_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersGetInfoV2Arg,
) -> crate::Result<Result<MembersGetInfoV2Result, MembersGetInfoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/get_info_v2",
        arg,
        None)
}

/// Returns information about multiple team members. Permission : Team information This endpoint
/// will return [`MembersGetInfoItem::IdNotFound`](MembersGetInfoItem::IdNotFound), for IDs (or
/// emails) that cannot be matched to a valid team member.
pub fn members_get_info(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersGetInfoArgs,
) -> crate::Result<Result<MembersGetInfoResult, MembersGetInfoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/get_info",
        arg,
        None)
}

/// Lists members of a team. Permission : Team information.
pub fn members_list_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersListArg,
) -> crate::Result<Result<MembersListV2Result, MembersListError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/list_v2",
        arg,
        None)
}

/// Lists members of a team. Permission : Team information.
pub fn members_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersListArg,
) -> crate::Result<Result<MembersListResult, MembersListError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`members_list_v2()`](members_list_v2), use this to
/// paginate through all team members. Permission : Team information.
pub fn members_list_continue_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersListContinueArg,
) -> crate::Result<Result<MembersListV2Result, MembersListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/list/continue_v2",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`members_list()`](members_list), use this to paginate
/// through all team members. Permission : Team information.
pub fn members_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersListContinueArg,
) -> crate::Result<Result<MembersListResult, MembersListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/list/continue",
        arg,
        None)
}

/// Moves removed member's files to a different member. This endpoint initiates an asynchronous job.
/// To obtain the final result of the job, the client should periodically poll
/// [`members_move_former_member_files_job_status_check()`](members_move_former_member_files_job_status_check).
/// Permission : Team member management.
pub fn members_move_former_member_files(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersDataTransferArg,
) -> crate::Result<Result<super::dbx_async::LaunchEmptyResult, MembersTransferFormerMembersFilesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/move_former_member_files",
        arg,
        None)
}

/// Once an async_job_id is returned from
/// [`members_move_former_member_files()`](members_move_former_member_files) , use this to poll the
/// status of the asynchronous request. Permission : Team member management.
pub fn members_move_former_member_files_job_status_check(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<super::dbx_async::PollEmptyResult, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/move_former_member_files/job_status/check",
        arg,
        None)
}

/// Recover a deleted member. Permission : Team member management Exactly one of team_member_id,
/// email, or external_id must be provided to identify the user account.
pub fn members_recover(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersRecoverArg,
) -> crate::Result<Result<(), MembersRecoverError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/recover",
        arg,
        None)
}

/// Removes a member from a team. Permission : Team member management Exactly one of team_member_id,
/// email, or external_id must be provided to identify the user account. Accounts can be recovered
/// via [`members_recover()`](members_recover) for a 7 day period or until the account has been
/// permanently deleted or transferred to another account (whichever comes first). Calling
/// [`members_add()`](members_add) while a user is still recoverable on your team will return with
/// [`MemberAddResult::UserAlreadyOnTeam`](MemberAddResult::UserAlreadyOnTeam). Accounts can have
/// their files transferred via the admin console for a limited time, based on the version history
/// length associated with the team (180 days for most teams). This endpoint may initiate an
/// asynchronous job. To obtain the final result of the job, the client should periodically poll
/// [`members_remove_job_status_get()`](members_remove_job_status_get).
pub fn members_remove(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersRemoveArg,
) -> crate::Result<Result<super::dbx_async::LaunchEmptyResult, MembersRemoveError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/remove",
        arg,
        None)
}

/// Once an async_job_id is returned from [`members_remove()`](members_remove) , use this to poll
/// the status of the asynchronous request. Permission : Team member management.
pub fn members_remove_job_status_get(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<super::dbx_async::PollEmptyResult, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/remove/job_status/get",
        arg,
        None)
}

/// Add secondary emails to users. Permission : Team member management. Emails that are on verified
/// domains will be verified automatically. For each email address not on a verified domain a
/// verification email will be sent.
pub fn members_secondary_emails_add(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &AddSecondaryEmailsArg,
) -> crate::Result<Result<AddSecondaryEmailsResult, AddSecondaryEmailsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/secondary_emails/add",
        arg,
        None)
}

/// Delete secondary emails from users Permission : Team member management. Users will be notified
/// of deletions of verified secondary emails at both the secondary email and their primary email.
pub fn members_secondary_emails_delete(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &DeleteSecondaryEmailsArg,
) -> crate::Result<Result<DeleteSecondaryEmailsResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/secondary_emails/delete",
        arg,
        None)
}

/// Resend secondary email verification emails. Permission : Team member management.
pub fn members_secondary_emails_resend_verification_emails(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &ResendVerificationEmailArg,
) -> crate::Result<Result<ResendVerificationEmailResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/secondary_emails/resend_verification_emails",
        arg,
        None)
}

/// Sends welcome email to pending team member. Permission : Team member management Exactly one of
/// team_member_id, email, or external_id must be provided to identify the user account. No-op if
/// team member is not pending.
pub fn members_send_welcome_email(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &UserSelectorArg,
) -> crate::Result<Result<(), MembersSendWelcomeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/send_welcome_email",
        arg,
        None)
}

/// Updates a team member's permissions. Permission : Team member management.
pub fn members_set_admin_permissions_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetPermissions2Arg,
) -> crate::Result<Result<MembersSetPermissions2Result, MembersSetPermissions2Error>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_admin_permissions_v2",
        arg,
        None)
}

/// Updates a team member's permissions. Permission : Team member management.
pub fn members_set_admin_permissions(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetPermissionsArg,
) -> crate::Result<Result<MembersSetPermissionsResult, MembersSetPermissionsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_admin_permissions",
        arg,
        None)
}

/// Updates a team member's profile. Permission : Team member management.
pub fn members_set_profile_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetProfileArg,
) -> crate::Result<Result<TeamMemberInfoV2Result, MembersSetProfileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_profile_v2",
        arg,
        None)
}

/// Updates a team member's profile. Permission : Team member management.
pub fn members_set_profile(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetProfileArg,
) -> crate::Result<Result<TeamMemberInfo, MembersSetProfileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_profile",
        arg,
        None)
}

/// Updates a team member's profile photo. Permission : Team member management.
pub fn members_set_profile_photo_v2(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetProfilePhotoArg,
) -> crate::Result<Result<TeamMemberInfoV2Result, MembersSetProfilePhotoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_profile_photo_v2",
        arg,
        None)
}

/// Updates a team member's profile photo. Permission : Team member management.
pub fn members_set_profile_photo(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersSetProfilePhotoArg,
) -> crate::Result<Result<TeamMemberInfo, MembersSetProfilePhotoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/set_profile_photo",
        arg,
        None)
}

/// Suspend a member from a team. Permission : Team member management Exactly one of team_member_id,
/// email, or external_id must be provided to identify the user account.
pub fn members_suspend(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersDeactivateArg,
) -> crate::Result<Result<(), MembersSuspendError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/suspend",
        arg,
        None)
}

/// Unsuspend a member from a team. Permission : Team member management Exactly one of
/// team_member_id, email, or external_id must be provided to identify the user account.
pub fn members_unsuspend(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &MembersUnsuspendArg,
) -> crate::Result<Result<(), MembersUnsuspendError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/members/unsuspend",
        arg,
        None)
}

/// Returns a list of all team-accessible namespaces. This list includes team folders, shared
/// folders containing team members, team members' home namespaces, and team members' app folders.
/// Home namespaces and app folders are always owned by this team or members of the team, but shared
/// folders may be owned by other users or other teams. Duplicates may occur in the list.
pub fn namespaces_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamNamespacesListArg,
) -> crate::Result<Result<TeamNamespacesListResult, TeamNamespacesListError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/namespaces/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`namespaces_list()`](namespaces_list), use this to
/// paginate through all team-accessible namespaces. Duplicates may occur in the list.
pub fn namespaces_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamNamespacesListContinueArg,
) -> crate::Result<Result<TeamNamespacesListResult, TeamNamespacesListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/namespaces/list/continue",
        arg,
        None)
}

/// Permission : Team member file access.
#[deprecated]
pub fn properties_template_add(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::file_properties::AddTemplateArg,
) -> crate::Result<Result<super::file_properties::AddTemplateResult, super::file_properties::ModifyTemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/properties/template/add",
        arg,
        None)
}

/// Permission : Team member file access. The scope for the route is files.team_metadata.write.
#[deprecated]
pub fn properties_template_get(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::file_properties::GetTemplateArg,
) -> crate::Result<Result<super::file_properties::GetTemplateResult, super::file_properties::TemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/properties/template/get",
        arg,
        None)
}

/// Permission : Team member file access. The scope for the route is files.team_metadata.write.
#[deprecated]
pub fn properties_template_list(
    client: &impl crate::client_trait::TeamAuthClient,
) -> crate::Result<Result<super::file_properties::ListTemplateResult, super::file_properties::TemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/properties/template/list",
        &(),
        None)
}

/// Permission : Team member file access.
#[deprecated]
pub fn properties_template_update(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::file_properties::UpdateTemplateArg,
) -> crate::Result<Result<super::file_properties::UpdateTemplateResult, super::file_properties::ModifyTemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/properties/template/update",
        arg,
        None)
}

/// Retrieves reporting data about a team's user activity. Deprecated: Will be removed on July 1st
/// 2021.
#[deprecated]
pub fn reports_get_activity(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &DateRange,
) -> crate::Result<Result<GetActivityReport, DateRangeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/reports/get_activity",
        arg,
        None)
}

/// Retrieves reporting data about a team's linked devices. Deprecated: Will be removed on July 1st
/// 2021.
#[deprecated]
pub fn reports_get_devices(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &DateRange,
) -> crate::Result<Result<GetDevicesReport, DateRangeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/reports/get_devices",
        arg,
        None)
}

/// Retrieves reporting data about a team's membership. Deprecated: Will be removed on July 1st
/// 2021.
#[deprecated]
pub fn reports_get_membership(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &DateRange,
) -> crate::Result<Result<GetMembershipReport, DateRangeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/reports/get_membership",
        arg,
        None)
}

/// Retrieves reporting data about a team's storage usage. Deprecated: Will be removed on July 1st
/// 2021.
#[deprecated]
pub fn reports_get_storage(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &DateRange,
) -> crate::Result<Result<GetStorageReport, DateRangeError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/reports/get_storage",
        arg,
        None)
}

/// Sets an archived team folder's status to active. Permission : Team member file access.
pub fn team_folder_activate(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderIdArg,
) -> crate::Result<Result<TeamFolderMetadata, TeamFolderActivateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/activate",
        arg,
        None)
}

/// Sets an active team folder's status to archived and removes all folder and file members. This
/// endpoint cannot be used for teams that have a shared team space. Permission : Team member file
/// access.
pub fn team_folder_archive(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderArchiveArg,
) -> crate::Result<Result<TeamFolderArchiveLaunch, TeamFolderArchiveError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/archive",
        arg,
        None)
}

/// Returns the status of an asynchronous job for archiving a team folder. Permission : Team member
/// file access.
pub fn team_folder_archive_check(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<TeamFolderArchiveJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/archive/check",
        arg,
        None)
}

/// Creates a new, active, team folder with no members. This endpoint can only be used for teams
/// that do not already have a shared team space. Permission : Team member file access.
pub fn team_folder_create(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderCreateArg,
) -> crate::Result<Result<TeamFolderMetadata, TeamFolderCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/create",
        arg,
        None)
}

/// Retrieves metadata for team folders. Permission : Team member file access.
pub fn team_folder_get_info(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderIdListArg,
) -> crate::Result<Result<Vec<TeamFolderGetInfoItem>, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/get_info",
        arg,
        None)
}

/// Lists all team folders. Permission : Team member file access.
pub fn team_folder_list(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderListArg,
) -> crate::Result<Result<TeamFolderListResult, TeamFolderListError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/list",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`team_folder_list()`](team_folder_list), use this to
/// paginate through all team folders. Permission : Team member file access.
pub fn team_folder_list_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderListContinueArg,
) -> crate::Result<Result<TeamFolderListResult, TeamFolderListContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/list/continue",
        arg,
        None)
}

/// Permanently deletes an archived team folder. This endpoint cannot be used for teams that have a
/// shared team space. Permission : Team member file access.
pub fn team_folder_permanently_delete(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderIdArg,
) -> crate::Result<Result<(), TeamFolderPermanentlyDeleteError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/permanently_delete",
        arg,
        None)
}

/// Changes an active team folder's name. Permission : Team member file access.
pub fn team_folder_rename(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderRenameArg,
) -> crate::Result<Result<TeamFolderMetadata, TeamFolderRenameError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/rename",
        arg,
        None)
}

/// Updates the sync settings on a team folder or its contents.  Use of this endpoint requires that
/// the team has team selective sync enabled.
pub fn team_folder_update_sync_settings(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &TeamFolderUpdateSyncSettingsArg,
) -> crate::Result<Result<TeamFolderMetadata, TeamFolderUpdateSyncSettingsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/team_folder/update_sync_settings",
        arg,
        None)
}

/// Returns the member profile of the admin who generated the team access token used to make the
/// call.
pub fn token_get_authenticated_admin(
    client: &impl crate::client_trait::TeamAuthClient,
) -> crate::Result<Result<TokenGetAuthenticatedAdminResult, TokenGetAuthenticatedAdminError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team/token/get_authenticated_admin",
        &(),
        None)
}

/// Information on active web sessions.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ActiveWebSession {
    /// The session id.
    pub session_id: String,
    /// Information on the hosting device.
    pub user_agent: String,
    /// Information on the hosting operating system.
    pub os: String,
    /// Information on the browser used for this web session.
    pub browser: String,
    /// The IP address of the last activity from this session.
    pub ip_address: Option<String>,
    /// The country from which the last activity from this session was made.
    pub country: Option<String>,
    /// The time this session was created.
    pub created: Option<super::common::DropboxTimestamp>,
    /// The time of the last activity from this session.
    pub updated: Option<super::common::DropboxTimestamp>,
    /// The time this session expires.
    pub expires: Option<super::common::DropboxTimestamp>,
}

impl ActiveWebSession {
    pub fn new(session_id: String, user_agent: String, os: String, browser: String) -> Self {
        ActiveWebSession {
            session_id,
            user_agent,
            os,
            browser,
            ip_address: None,
            country: None,
            created: None,
            updated: None,
            expires: None,
        }
    }

    pub fn with_ip_address(mut self, value: String) -> Self {
        self.ip_address = Some(value);
        self
    }

    pub fn with_country(mut self, value: String) -> Self {
        self.country = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }

    pub fn with_updated(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.updated = Some(value);
        self
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }
}

const ACTIVE_WEB_SESSION_FIELDS: &[&str] = &["session_id",
                                             "user_agent",
                                             "os",
                                             "browser",
                                             "ip_address",
                                             "country",
                                             "created",
                                             "updated",
                                             "expires"];
impl ActiveWebSession {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ActiveWebSession, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ActiveWebSession>, V::Error> {
        let mut field_session_id = None;
        let mut field_user_agent = None;
        let mut field_os = None;
        let mut field_browser = None;
        let mut field_ip_address = None;
        let mut field_country = None;
        let mut field_created = None;
        let mut field_updated = None;
        let mut field_expires = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "user_agent" => {
                    if field_user_agent.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user_agent"));
                    }
                    field_user_agent = Some(map.next_value()?);
                }
                "os" => {
                    if field_os.is_some() {
                        return Err(::serde::de::Error::duplicate_field("os"));
                    }
                    field_os = Some(map.next_value()?);
                }
                "browser" => {
                    if field_browser.is_some() {
                        return Err(::serde::de::Error::duplicate_field("browser"));
                    }
                    field_browser = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                "country" => {
                    if field_country.is_some() {
                        return Err(::serde::de::Error::duplicate_field("country"));
                    }
                    field_country = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "updated" => {
                    if field_updated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("updated"));
                    }
                    field_updated = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ActiveWebSession {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            user_agent: field_user_agent.ok_or_else(|| ::serde::de::Error::missing_field("user_agent"))?,
            os: field_os.ok_or_else(|| ::serde::de::Error::missing_field("os"))?,
            browser: field_browser.ok_or_else(|| ::serde::de::Error::missing_field("browser"))?,
            ip_address: field_ip_address,
            country: field_country,
            created: field_created,
            updated: field_updated,
            expires: field_expires,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("user_agent", &self.user_agent)?;
        s.serialize_field("os", &self.os)?;
        s.serialize_field("browser", &self.browser)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        if let Some(val) = &self.country {
            s.serialize_field("country", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        if let Some(val) = &self.updated {
            s.serialize_field("updated", val)?;
        }
        if let Some(val) = &self.expires {
            s.serialize_field("expires", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ActiveWebSession {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ActiveWebSession;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ActiveWebSession struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ActiveWebSession::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ActiveWebSession", ACTIVE_WEB_SESSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ActiveWebSession {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ActiveWebSession", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Result of trying to add a secondary email to a user. 'success' is the only value indicating that
/// a secondary email was successfully added to a user. The other values explain the type of error
/// that occurred, and include the email for which the error occurred.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddSecondaryEmailResult {
    /// Describes a secondary email that was successfully added to a user.
    Success(SecondaryEmail),
    /// Secondary email is not available to be claimed by the user.
    Unavailable(super::common::EmailAddress),
    /// Secondary email is already a pending email for the user.
    AlreadyPending(super::common::EmailAddress),
    /// Secondary email is already a verified email for the user.
    AlreadyOwnedByUser(super::common::EmailAddress),
    /// User already has the maximum number of secondary emails allowed.
    ReachedLimit(super::common::EmailAddress),
    /// A transient error occurred. Please try again later.
    TransientError(super::common::EmailAddress),
    /// An error occurred due to conflicting updates. Please try again later.
    TooManyUpdates(super::common::EmailAddress),
    /// An unknown error occurred.
    UnknownError(super::common::EmailAddress),
    /// Too many emails are being sent to this email address. Please try again later.
    RateLimited(super::common::EmailAddress),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddSecondaryEmailResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddSecondaryEmailResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddSecondaryEmailResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => AddSecondaryEmailResult::Success(SecondaryEmail::internal_deserialize(&mut map)?),
                    "unavailable" => {
                        match map.next_key()? {
                            Some("unavailable") => AddSecondaryEmailResult::Unavailable(map.next_value()?),
                            None => return Err(de::Error::missing_field("unavailable")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "already_pending" => {
                        match map.next_key()? {
                            Some("already_pending") => AddSecondaryEmailResult::AlreadyPending(map.next_value()?),
                            None => return Err(de::Error::missing_field("already_pending")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "already_owned_by_user" => {
                        match map.next_key()? {
                            Some("already_owned_by_user") => AddSecondaryEmailResult::AlreadyOwnedByUser(map.next_value()?),
                            None => return Err(de::Error::missing_field("already_owned_by_user")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "reached_limit" => {
                        match map.next_key()? {
                            Some("reached_limit") => AddSecondaryEmailResult::ReachedLimit(map.next_value()?),
                            None => return Err(de::Error::missing_field("reached_limit")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "transient_error" => {
                        match map.next_key()? {
                            Some("transient_error") => AddSecondaryEmailResult::TransientError(map.next_value()?),
                            None => return Err(de::Error::missing_field("transient_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_updates" => {
                        match map.next_key()? {
                            Some("too_many_updates") => AddSecondaryEmailResult::TooManyUpdates(map.next_value()?),
                            None => return Err(de::Error::missing_field("too_many_updates")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unknown_error" => {
                        match map.next_key()? {
                            Some("unknown_error") => AddSecondaryEmailResult::UnknownError(map.next_value()?),
                            None => return Err(de::Error::missing_field("unknown_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "rate_limited" => {
                        match map.next_key()? {
                            Some("rate_limited") => AddSecondaryEmailResult::RateLimited(map.next_value()?),
                            None => return Err(de::Error::missing_field("rate_limited")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => AddSecondaryEmailResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "unavailable",
                                    "already_pending",
                                    "already_owned_by_user",
                                    "reached_limit",
                                    "transient_error",
                                    "too_many_updates",
                                    "unknown_error",
                                    "rate_limited",
                                    "other"];
        deserializer.deserialize_struct("AddSecondaryEmailResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddSecondaryEmailResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddSecondaryEmailResult::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AddSecondaryEmailResult::Unavailable(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "unavailable")?;
                s.serialize_field("unavailable", x)?;
                s.end()
            }
            AddSecondaryEmailResult::AlreadyPending(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "already_pending")?;
                s.serialize_field("already_pending", x)?;
                s.end()
            }
            AddSecondaryEmailResult::AlreadyOwnedByUser(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "already_owned_by_user")?;
                s.serialize_field("already_owned_by_user", x)?;
                s.end()
            }
            AddSecondaryEmailResult::ReachedLimit(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "reached_limit")?;
                s.serialize_field("reached_limit", x)?;
                s.end()
            }
            AddSecondaryEmailResult::TransientError(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "transient_error")?;
                s.serialize_field("transient_error", x)?;
                s.end()
            }
            AddSecondaryEmailResult::TooManyUpdates(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "too_many_updates")?;
                s.serialize_field("too_many_updates", x)?;
                s.end()
            }
            AddSecondaryEmailResult::UnknownError(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "unknown_error")?;
                s.serialize_field("unknown_error", x)?;
                s.end()
            }
            AddSecondaryEmailResult::RateLimited(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "rate_limited")?;
                s.serialize_field("rate_limited", x)?;
                s.end()
            }
            AddSecondaryEmailResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddSecondaryEmailsArg {
    /// List of users and secondary emails to add.
    pub new_secondary_emails: Vec<UserSecondaryEmailsArg>,
}

impl AddSecondaryEmailsArg {
    pub fn new(new_secondary_emails: Vec<UserSecondaryEmailsArg>) -> Self {
        AddSecondaryEmailsArg {
            new_secondary_emails,
        }
    }
}

const ADD_SECONDARY_EMAILS_ARG_FIELDS: &[&str] = &["new_secondary_emails"];
impl AddSecondaryEmailsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddSecondaryEmailsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddSecondaryEmailsArg>, V::Error> {
        let mut field_new_secondary_emails = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_secondary_emails" => {
                    if field_new_secondary_emails.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_secondary_emails"));
                    }
                    field_new_secondary_emails = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddSecondaryEmailsArg {
            new_secondary_emails: field_new_secondary_emails.ok_or_else(|| ::serde::de::Error::missing_field("new_secondary_emails"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_secondary_emails", &self.new_secondary_emails)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddSecondaryEmailsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddSecondaryEmailsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddSecondaryEmailsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddSecondaryEmailsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddSecondaryEmailsArg", ADD_SECONDARY_EMAILS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddSecondaryEmailsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddSecondaryEmailsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned when adding secondary emails fails.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddSecondaryEmailsError {
    /// Secondary emails are disabled for the team.
    SecondaryEmailsDisabled,
    /// A maximum of 20 secondary emails can be added in a single call.
    TooManyEmails,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddSecondaryEmailsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddSecondaryEmailsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddSecondaryEmailsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "secondary_emails_disabled" => AddSecondaryEmailsError::SecondaryEmailsDisabled,
                    "too_many_emails" => AddSecondaryEmailsError::TooManyEmails,
                    _ => AddSecondaryEmailsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["secondary_emails_disabled",
                                    "too_many_emails",
                                    "other"];
        deserializer.deserialize_struct("AddSecondaryEmailsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddSecondaryEmailsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddSecondaryEmailsError::SecondaryEmailsDisabled => {
                // unit
                let mut s = serializer.serialize_struct("AddSecondaryEmailsError", 1)?;
                s.serialize_field(".tag", "secondary_emails_disabled")?;
                s.end()
            }
            AddSecondaryEmailsError::TooManyEmails => {
                // unit
                let mut s = serializer.serialize_struct("AddSecondaryEmailsError", 1)?;
                s.serialize_field(".tag", "too_many_emails")?;
                s.end()
            }
            AddSecondaryEmailsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for AddSecondaryEmailsError {
}

impl ::std::fmt::Display for AddSecondaryEmailsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            AddSecondaryEmailsError::SecondaryEmailsDisabled => f.write_str("Secondary emails are disabled for the team."),
            AddSecondaryEmailsError::TooManyEmails => f.write_str("A maximum of 20 secondary emails can be added in a single call."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddSecondaryEmailsResult {
    /// List of users and secondary email results.
    pub results: Vec<UserAddResult>,
}

impl AddSecondaryEmailsResult {
    pub fn new(results: Vec<UserAddResult>) -> Self {
        AddSecondaryEmailsResult {
            results,
        }
    }
}

const ADD_SECONDARY_EMAILS_RESULT_FIELDS: &[&str] = &["results"];
impl AddSecondaryEmailsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddSecondaryEmailsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddSecondaryEmailsResult>, V::Error> {
        let mut field_results = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "results" => {
                    if field_results.is_some() {
                        return Err(::serde::de::Error::duplicate_field("results"));
                    }
                    field_results = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddSecondaryEmailsResult {
            results: field_results.ok_or_else(|| ::serde::de::Error::missing_field("results"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("results", &self.results)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddSecondaryEmailsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddSecondaryEmailsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddSecondaryEmailsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddSecondaryEmailsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddSecondaryEmailsResult", ADD_SECONDARY_EMAILS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddSecondaryEmailsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddSecondaryEmailsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Describes which team-related admin permissions a user has.
#[derive(Debug, Clone, PartialEq)]
pub enum AdminTier {
    /// User is an administrator of the team - has all permissions.
    TeamAdmin,
    /// User can do most user provisioning, de-provisioning and management.
    UserManagementAdmin,
    /// User can do a limited set of common support tasks for existing users. Note: Dropbox is
    /// adding new types of admin roles; these may display as support_admin.
    SupportAdmin,
    /// User is not an admin of the team.
    MemberOnly,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminTier {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminTier;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminTier structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team_admin" => AdminTier::TeamAdmin,
                    "user_management_admin" => AdminTier::UserManagementAdmin,
                    "support_admin" => AdminTier::SupportAdmin,
                    "member_only" => AdminTier::MemberOnly,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team_admin",
                                    "user_management_admin",
                                    "support_admin",
                                    "member_only"];
        deserializer.deserialize_struct("AdminTier", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminTier {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminTier::TeamAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminTier", 1)?;
                s.serialize_field(".tag", "team_admin")?;
                s.end()
            }
            AdminTier::UserManagementAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminTier", 1)?;
                s.serialize_field(".tag", "user_management_admin")?;
                s.end()
            }
            AdminTier::SupportAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminTier", 1)?;
                s.serialize_field(".tag", "support_admin")?;
                s.end()
            }
            AdminTier::MemberOnly => {
                // unit
                let mut s = serializer.serialize_struct("AdminTier", 1)?;
                s.serialize_field(".tag", "member_only")?;
                s.end()
            }
        }
    }
}

/// Information on linked third party applications.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ApiApp {
    /// The application unique id.
    pub app_id: String,
    /// The application name.
    pub app_name: String,
    /// Whether the linked application uses a dedicated folder.
    pub is_app_folder: bool,
    /// The application publisher name.
    pub publisher: Option<String>,
    /// The publisher's URL.
    pub publisher_url: Option<String>,
    /// The time this application was linked.
    pub linked: Option<super::common::DropboxTimestamp>,
}

impl ApiApp {
    pub fn new(app_id: String, app_name: String, is_app_folder: bool) -> Self {
        ApiApp {
            app_id,
            app_name,
            is_app_folder,
            publisher: None,
            publisher_url: None,
            linked: None,
        }
    }

    pub fn with_publisher(mut self, value: String) -> Self {
        self.publisher = Some(value);
        self
    }

    pub fn with_publisher_url(mut self, value: String) -> Self {
        self.publisher_url = Some(value);
        self
    }

    pub fn with_linked(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.linked = Some(value);
        self
    }
}

const API_APP_FIELDS: &[&str] = &["app_id",
                                  "app_name",
                                  "is_app_folder",
                                  "publisher",
                                  "publisher_url",
                                  "linked"];
impl ApiApp {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ApiApp, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ApiApp>, V::Error> {
        let mut field_app_id = None;
        let mut field_app_name = None;
        let mut field_is_app_folder = None;
        let mut field_publisher = None;
        let mut field_publisher_url = None;
        let mut field_linked = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_id" => {
                    if field_app_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_id"));
                    }
                    field_app_id = Some(map.next_value()?);
                }
                "app_name" => {
                    if field_app_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_name"));
                    }
                    field_app_name = Some(map.next_value()?);
                }
                "is_app_folder" => {
                    if field_is_app_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_app_folder"));
                    }
                    field_is_app_folder = Some(map.next_value()?);
                }
                "publisher" => {
                    if field_publisher.is_some() {
                        return Err(::serde::de::Error::duplicate_field("publisher"));
                    }
                    field_publisher = Some(map.next_value()?);
                }
                "publisher_url" => {
                    if field_publisher_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("publisher_url"));
                    }
                    field_publisher_url = Some(map.next_value()?);
                }
                "linked" => {
                    if field_linked.is_some() {
                        return Err(::serde::de::Error::duplicate_field("linked"));
                    }
                    field_linked = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ApiApp {
            app_id: field_app_id.ok_or_else(|| ::serde::de::Error::missing_field("app_id"))?,
            app_name: field_app_name.ok_or_else(|| ::serde::de::Error::missing_field("app_name"))?,
            is_app_folder: field_is_app_folder.ok_or_else(|| ::serde::de::Error::missing_field("is_app_folder"))?,
            publisher: field_publisher,
            publisher_url: field_publisher_url,
            linked: field_linked,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_id", &self.app_id)?;
        s.serialize_field("app_name", &self.app_name)?;
        s.serialize_field("is_app_folder", &self.is_app_folder)?;
        if let Some(val) = &self.publisher {
            s.serialize_field("publisher", val)?;
        }
        if let Some(val) = &self.publisher_url {
            s.serialize_field("publisher_url", val)?;
        }
        if let Some(val) = &self.linked {
            s.serialize_field("linked", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ApiApp {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ApiApp;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ApiApp struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ApiApp::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ApiApp", API_APP_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ApiApp {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ApiApp", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Base report structure.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BaseDfbReport {
    /// First date present in the results as 'YYYY-MM-DD' or None.
    pub start_date: String,
}

impl BaseDfbReport {
    pub fn new(start_date: String) -> Self {
        BaseDfbReport {
            start_date,
        }
    }
}

const BASE_DFB_REPORT_FIELDS: &[&str] = &["start_date"];
impl BaseDfbReport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BaseDfbReport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BaseDfbReport>, V::Error> {
        let mut field_start_date = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BaseDfbReport {
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("start_date", &self.start_date)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BaseDfbReport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BaseDfbReport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BaseDfbReport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BaseDfbReport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BaseDfbReport", BASE_DFB_REPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BaseDfbReport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BaseDfbReport", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Base error that all errors for existing team folders should extend.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum BaseTeamFolderError {
    AccessError(TeamFolderAccessError),
    StatusError(TeamFolderInvalidStatusError),
    TeamSharedDropboxError(TeamFolderTeamSharedDropboxError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for BaseTeamFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = BaseTeamFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BaseTeamFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => BaseTeamFolderError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "status_error" => {
                        match map.next_key()? {
                            Some("status_error") => BaseTeamFolderError::StatusError(map.next_value()?),
                            None => return Err(de::Error::missing_field("status_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "team_shared_dropbox_error" => {
                        match map.next_key()? {
                            Some("team_shared_dropbox_error") => BaseTeamFolderError::TeamSharedDropboxError(map.next_value()?),
                            None => return Err(de::Error::missing_field("team_shared_dropbox_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => BaseTeamFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "status_error",
                                    "team_shared_dropbox_error",
                                    "other"];
        deserializer.deserialize_struct("BaseTeamFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for BaseTeamFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            BaseTeamFolderError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("BaseTeamFolderError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            BaseTeamFolderError::StatusError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("BaseTeamFolderError", 2)?;
                s.serialize_field(".tag", "status_error")?;
                s.serialize_field("status_error", x)?;
                s.end()
            }
            BaseTeamFolderError::TeamSharedDropboxError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("BaseTeamFolderError", 2)?;
                s.serialize_field(".tag", "team_shared_dropbox_error")?;
                s.serialize_field("team_shared_dropbox_error", x)?;
                s.end()
            }
            BaseTeamFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for BaseTeamFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            BaseTeamFolderError::AccessError(inner) => Some(inner),
            BaseTeamFolderError::StatusError(inner) => Some(inner),
            BaseTeamFolderError::TeamSharedDropboxError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for BaseTeamFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            BaseTeamFolderError::AccessError(inner) => write!(f, "{}", inner),
            BaseTeamFolderError::StatusError(inner) => write!(f, "{}", inner),
            BaseTeamFolderError::TeamSharedDropboxError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Error returned when getting member custom quota.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CustomQuotaError {
    /// A maximum of 1000 users can be set for a single call.
    TooManyUsers,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CustomQuotaError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CustomQuotaError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CustomQuotaError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "too_many_users" => CustomQuotaError::TooManyUsers,
                    _ => CustomQuotaError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["too_many_users",
                                    "other"];
        deserializer.deserialize_struct("CustomQuotaError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CustomQuotaError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CustomQuotaError::TooManyUsers => {
                // unit
                let mut s = serializer.serialize_struct("CustomQuotaError", 1)?;
                s.serialize_field(".tag", "too_many_users")?;
                s.end()
            }
            CustomQuotaError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CustomQuotaError {
}

impl ::std::fmt::Display for CustomQuotaError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CustomQuotaError::TooManyUsers => f.write_str("A maximum of 1000 users can be set for a single call."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// User custom quota.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CustomQuotaResult {
    /// User's custom quota.
    Success(UserCustomQuotaResult),
    /// Invalid user (not in team).
    InvalidUser(UserSelectorArg),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CustomQuotaResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CustomQuotaResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CustomQuotaResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => CustomQuotaResult::Success(UserCustomQuotaResult::internal_deserialize(&mut map)?),
                    "invalid_user" => {
                        match map.next_key()? {
                            Some("invalid_user") => CustomQuotaResult::InvalidUser(map.next_value()?),
                            None => return Err(de::Error::missing_field("invalid_user")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => CustomQuotaResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "invalid_user",
                                    "other"];
        deserializer.deserialize_struct("CustomQuotaResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CustomQuotaResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CustomQuotaResult::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("CustomQuotaResult", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            CustomQuotaResult::InvalidUser(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CustomQuotaResult", 2)?;
                s.serialize_field(".tag", "invalid_user")?;
                s.serialize_field("invalid_user", x)?;
                s.end()
            }
            CustomQuotaResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CustomQuotaUsersArg {
    /// List of users.
    pub users: Vec<UserSelectorArg>,
}

impl CustomQuotaUsersArg {
    pub fn new(users: Vec<UserSelectorArg>) -> Self {
        CustomQuotaUsersArg {
            users,
        }
    }
}

const CUSTOM_QUOTA_USERS_ARG_FIELDS: &[&str] = &["users"];
impl CustomQuotaUsersArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CustomQuotaUsersArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CustomQuotaUsersArg>, V::Error> {
        let mut field_users = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CustomQuotaUsersArg {
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("users", &self.users)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CustomQuotaUsersArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CustomQuotaUsersArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CustomQuotaUsersArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CustomQuotaUsersArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CustomQuotaUsersArg", CUSTOM_QUOTA_USERS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CustomQuotaUsersArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CustomQuotaUsersArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Input arguments that can be provided for most reports.
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DateRange {
    /// Optional starting date (inclusive). If start_date is None or too long ago, this field will
    /// be set to 6 months ago.
    pub start_date: Option<super::common::Date>,
    /// Optional ending date (exclusive).
    pub end_date: Option<super::common::Date>,
}

impl DateRange {
    pub fn with_start_date(mut self, value: super::common::Date) -> Self {
        self.start_date = Some(value);
        self
    }

    pub fn with_end_date(mut self, value: super::common::Date) -> Self {
        self.end_date = Some(value);
        self
    }
}

const DATE_RANGE_FIELDS: &[&str] = &["start_date",
                                     "end_date"];
impl DateRange {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DateRange, V::Error> {
        let mut field_start_date = None;
        let mut field_end_date = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "end_date" => {
                    if field_end_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("end_date"));
                    }
                    field_end_date = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DateRange {
            start_date: field_start_date,
            end_date: field_end_date,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.start_date {
            s.serialize_field("start_date", val)?;
        }
        if let Some(val) = &self.end_date {
            s.serialize_field("end_date", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DateRange {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DateRange;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DateRange struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DateRange::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DateRange", DATE_RANGE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DateRange {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DateRange", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Errors that can originate from problems in input arguments to reports.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DateRangeError {
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DateRangeError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DateRangeError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DateRangeError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                // open enum with no defined variants
                let _ = tag;
                crate::eat_json_fields(&mut map)?;
                Ok(DateRangeError::Other)
            }
        }
        const VARIANTS: &[&str] = &["other"];
        deserializer.deserialize_struct("DateRangeError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DateRangeError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        #![allow(unused_variables)]
        Err(::serde::ser::Error::custom("cannot serialize an open union with no defined variants"))
    }
}

impl ::std::error::Error for DateRangeError {
}

impl ::std::fmt::Display for DateRangeError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Result of trying to delete a secondary email address. 'success' is the only value indicating
/// that a secondary email was successfully deleted. The other values explain the type of error that
/// occurred, and include the email for which the error occurred.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteSecondaryEmailResult {
    /// The secondary email was successfully deleted.
    Success(super::common::EmailAddress),
    /// The email address was not found for the user.
    NotFound(super::common::EmailAddress),
    /// The email address is the primary email address of the user, and cannot be removed.
    CannotRemovePrimary(super::common::EmailAddress),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteSecondaryEmailResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteSecondaryEmailResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteSecondaryEmailResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => {
                        match map.next_key()? {
                            Some("success") => DeleteSecondaryEmailResult::Success(map.next_value()?),
                            None => return Err(de::Error::missing_field("success")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "not_found" => {
                        match map.next_key()? {
                            Some("not_found") => DeleteSecondaryEmailResult::NotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "cannot_remove_primary" => {
                        match map.next_key()? {
                            Some("cannot_remove_primary") => DeleteSecondaryEmailResult::CannotRemovePrimary(map.next_value()?),
                            None => return Err(de::Error::missing_field("cannot_remove_primary")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => DeleteSecondaryEmailResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "not_found",
                                    "cannot_remove_primary",
                                    "other"];
        deserializer.deserialize_struct("DeleteSecondaryEmailResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteSecondaryEmailResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteSecondaryEmailResult::Success(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("DeleteSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "success")?;
                s.serialize_field("success", x)?;
                s.end()
            }
            DeleteSecondaryEmailResult::NotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("DeleteSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "not_found")?;
                s.serialize_field("not_found", x)?;
                s.end()
            }
            DeleteSecondaryEmailResult::CannotRemovePrimary(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("DeleteSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "cannot_remove_primary")?;
                s.serialize_field("cannot_remove_primary", x)?;
                s.end()
            }
            DeleteSecondaryEmailResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteSecondaryEmailsArg {
    /// List of users and their secondary emails to delete.
    pub emails_to_delete: Vec<UserSecondaryEmailsArg>,
}

impl DeleteSecondaryEmailsArg {
    pub fn new(emails_to_delete: Vec<UserSecondaryEmailsArg>) -> Self {
        DeleteSecondaryEmailsArg {
            emails_to_delete,
        }
    }
}

const DELETE_SECONDARY_EMAILS_ARG_FIELDS: &[&str] = &["emails_to_delete"];
impl DeleteSecondaryEmailsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteSecondaryEmailsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteSecondaryEmailsArg>, V::Error> {
        let mut field_emails_to_delete = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "emails_to_delete" => {
                    if field_emails_to_delete.is_some() {
                        return Err(::serde::de::Error::duplicate_field("emails_to_delete"));
                    }
                    field_emails_to_delete = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteSecondaryEmailsArg {
            emails_to_delete: field_emails_to_delete.ok_or_else(|| ::serde::de::Error::missing_field("emails_to_delete"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("emails_to_delete", &self.emails_to_delete)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteSecondaryEmailsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteSecondaryEmailsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteSecondaryEmailsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteSecondaryEmailsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteSecondaryEmailsArg", DELETE_SECONDARY_EMAILS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteSecondaryEmailsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteSecondaryEmailsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteSecondaryEmailsResult {
    pub results: Vec<UserDeleteResult>,
}

impl DeleteSecondaryEmailsResult {
    pub fn new(results: Vec<UserDeleteResult>) -> Self {
        DeleteSecondaryEmailsResult {
            results,
        }
    }
}

const DELETE_SECONDARY_EMAILS_RESULT_FIELDS: &[&str] = &["results"];
impl DeleteSecondaryEmailsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteSecondaryEmailsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteSecondaryEmailsResult>, V::Error> {
        let mut field_results = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "results" => {
                    if field_results.is_some() {
                        return Err(::serde::de::Error::duplicate_field("results"));
                    }
                    field_results = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteSecondaryEmailsResult {
            results: field_results.ok_or_else(|| ::serde::de::Error::missing_field("results"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("results", &self.results)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteSecondaryEmailsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteSecondaryEmailsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteSecondaryEmailsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteSecondaryEmailsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteSecondaryEmailsResult", DELETE_SECONDARY_EMAILS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteSecondaryEmailsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteSecondaryEmailsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information about linked Dropbox desktop client sessions.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DesktopClientSession {
    /// The session id.
    pub session_id: String,
    /// Name of the hosting desktop.
    pub host_name: String,
    /// The Dropbox desktop client type.
    pub client_type: DesktopPlatform,
    /// The Dropbox client version.
    pub client_version: String,
    /// Information on the hosting platform.
    pub platform: String,
    /// Whether it's possible to delete all of the account files upon unlinking.
    pub is_delete_on_unlink_supported: bool,
    /// The IP address of the last activity from this session.
    pub ip_address: Option<String>,
    /// The country from which the last activity from this session was made.
    pub country: Option<String>,
    /// The time this session was created.
    pub created: Option<super::common::DropboxTimestamp>,
    /// The time of the last activity from this session.
    pub updated: Option<super::common::DropboxTimestamp>,
}

impl DesktopClientSession {
    pub fn new(
        session_id: String,
        host_name: String,
        client_type: DesktopPlatform,
        client_version: String,
        platform: String,
        is_delete_on_unlink_supported: bool,
    ) -> Self {
        DesktopClientSession {
            session_id,
            host_name,
            client_type,
            client_version,
            platform,
            is_delete_on_unlink_supported,
            ip_address: None,
            country: None,
            created: None,
            updated: None,
        }
    }

    pub fn with_ip_address(mut self, value: String) -> Self {
        self.ip_address = Some(value);
        self
    }

    pub fn with_country(mut self, value: String) -> Self {
        self.country = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }

    pub fn with_updated(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.updated = Some(value);
        self
    }
}

const DESKTOP_CLIENT_SESSION_FIELDS: &[&str] = &["session_id",
                                                 "host_name",
                                                 "client_type",
                                                 "client_version",
                                                 "platform",
                                                 "is_delete_on_unlink_supported",
                                                 "ip_address",
                                                 "country",
                                                 "created",
                                                 "updated"];
impl DesktopClientSession {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DesktopClientSession, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DesktopClientSession>, V::Error> {
        let mut field_session_id = None;
        let mut field_host_name = None;
        let mut field_client_type = None;
        let mut field_client_version = None;
        let mut field_platform = None;
        let mut field_is_delete_on_unlink_supported = None;
        let mut field_ip_address = None;
        let mut field_country = None;
        let mut field_created = None;
        let mut field_updated = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "host_name" => {
                    if field_host_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("host_name"));
                    }
                    field_host_name = Some(map.next_value()?);
                }
                "client_type" => {
                    if field_client_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_type"));
                    }
                    field_client_type = Some(map.next_value()?);
                }
                "client_version" => {
                    if field_client_version.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_version"));
                    }
                    field_client_version = Some(map.next_value()?);
                }
                "platform" => {
                    if field_platform.is_some() {
                        return Err(::serde::de::Error::duplicate_field("platform"));
                    }
                    field_platform = Some(map.next_value()?);
                }
                "is_delete_on_unlink_supported" => {
                    if field_is_delete_on_unlink_supported.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_delete_on_unlink_supported"));
                    }
                    field_is_delete_on_unlink_supported = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                "country" => {
                    if field_country.is_some() {
                        return Err(::serde::de::Error::duplicate_field("country"));
                    }
                    field_country = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "updated" => {
                    if field_updated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("updated"));
                    }
                    field_updated = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DesktopClientSession {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            host_name: field_host_name.ok_or_else(|| ::serde::de::Error::missing_field("host_name"))?,
            client_type: field_client_type.ok_or_else(|| ::serde::de::Error::missing_field("client_type"))?,
            client_version: field_client_version.ok_or_else(|| ::serde::de::Error::missing_field("client_version"))?,
            platform: field_platform.ok_or_else(|| ::serde::de::Error::missing_field("platform"))?,
            is_delete_on_unlink_supported: field_is_delete_on_unlink_supported.ok_or_else(|| ::serde::de::Error::missing_field("is_delete_on_unlink_supported"))?,
            ip_address: field_ip_address,
            country: field_country,
            created: field_created,
            updated: field_updated,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("host_name", &self.host_name)?;
        s.serialize_field("client_type", &self.client_type)?;
        s.serialize_field("client_version", &self.client_version)?;
        s.serialize_field("platform", &self.platform)?;
        s.serialize_field("is_delete_on_unlink_supported", &self.is_delete_on_unlink_supported)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        if let Some(val) = &self.country {
            s.serialize_field("country", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        if let Some(val) = &self.updated {
            s.serialize_field("updated", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DesktopClientSession {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DesktopClientSession;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DesktopClientSession struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DesktopClientSession::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DesktopClientSession", DESKTOP_CLIENT_SESSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DesktopClientSession {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DesktopClientSession", 10)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DesktopPlatform {
    /// Official Windows Dropbox desktop client.
    Windows,
    /// Official Mac Dropbox desktop client.
    Mac,
    /// Official Linux Dropbox desktop client.
    Linux,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DesktopPlatform {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DesktopPlatform;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DesktopPlatform structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "windows" => DesktopPlatform::Windows,
                    "mac" => DesktopPlatform::Mac,
                    "linux" => DesktopPlatform::Linux,
                    _ => DesktopPlatform::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["windows",
                                    "mac",
                                    "linux",
                                    "other"];
        deserializer.deserialize_struct("DesktopPlatform", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DesktopPlatform {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DesktopPlatform::Windows => {
                // unit
                let mut s = serializer.serialize_struct("DesktopPlatform", 1)?;
                s.serialize_field(".tag", "windows")?;
                s.end()
            }
            DesktopPlatform::Mac => {
                // unit
                let mut s = serializer.serialize_struct("DesktopPlatform", 1)?;
                s.serialize_field(".tag", "mac")?;
                s.end()
            }
            DesktopPlatform::Linux => {
                // unit
                let mut s = serializer.serialize_struct("DesktopPlatform", 1)?;
                s.serialize_field(".tag", "linux")?;
                s.end()
            }
            DesktopPlatform::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceSession {
    /// The session id.
    pub session_id: String,
    /// The IP address of the last activity from this session.
    pub ip_address: Option<String>,
    /// The country from which the last activity from this session was made.
    pub country: Option<String>,
    /// The time this session was created.
    pub created: Option<super::common::DropboxTimestamp>,
    /// The time of the last activity from this session.
    pub updated: Option<super::common::DropboxTimestamp>,
}

impl DeviceSession {
    pub fn new(session_id: String) -> Self {
        DeviceSession {
            session_id,
            ip_address: None,
            country: None,
            created: None,
            updated: None,
        }
    }

    pub fn with_ip_address(mut self, value: String) -> Self {
        self.ip_address = Some(value);
        self
    }

    pub fn with_country(mut self, value: String) -> Self {
        self.country = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }

    pub fn with_updated(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.updated = Some(value);
        self
    }
}

const DEVICE_SESSION_FIELDS: &[&str] = &["session_id",
                                         "ip_address",
                                         "country",
                                         "created",
                                         "updated"];
impl DeviceSession {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceSession, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceSession>, V::Error> {
        let mut field_session_id = None;
        let mut field_ip_address = None;
        let mut field_country = None;
        let mut field_created = None;
        let mut field_updated = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                "country" => {
                    if field_country.is_some() {
                        return Err(::serde::de::Error::duplicate_field("country"));
                    }
                    field_country = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "updated" => {
                    if field_updated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("updated"));
                    }
                    field_updated = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceSession {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            ip_address: field_ip_address,
            country: field_country,
            created: field_created,
            updated: field_updated,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        if let Some(val) = &self.country {
            s.serialize_field("country", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        if let Some(val) = &self.updated {
            s.serialize_field("updated", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceSession {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceSession;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceSession struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceSession::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceSession", DEVICE_SESSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceSession {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceSession", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceSessionArg {
    /// The session id.
    pub session_id: String,
    /// The unique id of the member owning the device.
    pub team_member_id: String,
}

impl DeviceSessionArg {
    pub fn new(session_id: String, team_member_id: String) -> Self {
        DeviceSessionArg {
            session_id,
            team_member_id,
        }
    }
}

const DEVICE_SESSION_ARG_FIELDS: &[&str] = &["session_id",
                                             "team_member_id"];
impl DeviceSessionArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceSessionArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceSessionArg>, V::Error> {
        let mut field_session_id = None;
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceSessionArg {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceSessionArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceSessionArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceSessionArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceSessionArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceSessionArg", DEVICE_SESSION_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceSessionArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceSessionArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Each of the items is an array of values, one value per day. The value is the number of devices
/// active within a time window, ending with that day. If there is no data for a day, then the value
/// will be None.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DevicesActive {
    /// Array of number of linked windows (desktop) clients with activity.
    pub windows: NumberPerDay,
    /// Array of number of linked mac (desktop) clients with activity.
    pub macos: NumberPerDay,
    /// Array of number of linked linus (desktop) clients with activity.
    pub linux: NumberPerDay,
    /// Array of number of linked ios devices with activity.
    pub ios: NumberPerDay,
    /// Array of number of linked android devices with activity.
    pub android: NumberPerDay,
    /// Array of number of other linked devices (blackberry, windows phone, etc)  with activity.
    pub other: NumberPerDay,
    /// Array of total number of linked clients with activity.
    pub total: NumberPerDay,
}

impl DevicesActive {
    pub fn new(
        windows: NumberPerDay,
        macos: NumberPerDay,
        linux: NumberPerDay,
        ios: NumberPerDay,
        android: NumberPerDay,
        other: NumberPerDay,
        total: NumberPerDay,
    ) -> Self {
        DevicesActive {
            windows,
            macos,
            linux,
            ios,
            android,
            other,
            total,
        }
    }
}

const DEVICES_ACTIVE_FIELDS: &[&str] = &["windows",
                                         "macos",
                                         "linux",
                                         "ios",
                                         "android",
                                         "other",
                                         "total"];
impl DevicesActive {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DevicesActive, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DevicesActive>, V::Error> {
        let mut field_windows = None;
        let mut field_macos = None;
        let mut field_linux = None;
        let mut field_ios = None;
        let mut field_android = None;
        let mut field_other = None;
        let mut field_total = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "windows" => {
                    if field_windows.is_some() {
                        return Err(::serde::de::Error::duplicate_field("windows"));
                    }
                    field_windows = Some(map.next_value()?);
                }
                "macos" => {
                    if field_macos.is_some() {
                        return Err(::serde::de::Error::duplicate_field("macos"));
                    }
                    field_macos = Some(map.next_value()?);
                }
                "linux" => {
                    if field_linux.is_some() {
                        return Err(::serde::de::Error::duplicate_field("linux"));
                    }
                    field_linux = Some(map.next_value()?);
                }
                "ios" => {
                    if field_ios.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ios"));
                    }
                    field_ios = Some(map.next_value()?);
                }
                "android" => {
                    if field_android.is_some() {
                        return Err(::serde::de::Error::duplicate_field("android"));
                    }
                    field_android = Some(map.next_value()?);
                }
                "other" => {
                    if field_other.is_some() {
                        return Err(::serde::de::Error::duplicate_field("other"));
                    }
                    field_other = Some(map.next_value()?);
                }
                "total" => {
                    if field_total.is_some() {
                        return Err(::serde::de::Error::duplicate_field("total"));
                    }
                    field_total = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DevicesActive {
            windows: field_windows.ok_or_else(|| ::serde::de::Error::missing_field("windows"))?,
            macos: field_macos.ok_or_else(|| ::serde::de::Error::missing_field("macos"))?,
            linux: field_linux.ok_or_else(|| ::serde::de::Error::missing_field("linux"))?,
            ios: field_ios.ok_or_else(|| ::serde::de::Error::missing_field("ios"))?,
            android: field_android.ok_or_else(|| ::serde::de::Error::missing_field("android"))?,
            other: field_other.ok_or_else(|| ::serde::de::Error::missing_field("other"))?,
            total: field_total.ok_or_else(|| ::serde::de::Error::missing_field("total"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("windows", &self.windows)?;
        s.serialize_field("macos", &self.macos)?;
        s.serialize_field("linux", &self.linux)?;
        s.serialize_field("ios", &self.ios)?;
        s.serialize_field("android", &self.android)?;
        s.serialize_field("other", &self.other)?;
        s.serialize_field("total", &self.total)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DevicesActive {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DevicesActive;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DevicesActive struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DevicesActive::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DevicesActive", DEVICES_ACTIVE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DevicesActive {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DevicesActive", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Excluded users list argument.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExcludedUsersListArg {
    /// Number of results to return per call.
    pub limit: u32,
}

impl Default for ExcludedUsersListArg {
    fn default() -> Self {
        ExcludedUsersListArg {
            limit: 1000,
        }
    }
}

impl ExcludedUsersListArg {
    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const EXCLUDED_USERS_LIST_ARG_FIELDS: &[&str] = &["limit"];
impl ExcludedUsersListArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ExcludedUsersListArg, V::Error> {
        let mut field_limit = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ExcludedUsersListArg {
            limit: field_limit.unwrap_or(1000),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersListArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExcludedUsersListArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersListArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExcludedUsersListArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExcludedUsersListArg", EXCLUDED_USERS_LIST_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersListArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExcludedUsersListArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Excluded users list continue argument.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExcludedUsersListContinueArg {
    /// Indicates from what point to get the next set of users.
    pub cursor: String,
}

impl ExcludedUsersListContinueArg {
    pub fn new(cursor: String) -> Self {
        ExcludedUsersListContinueArg {
            cursor,
        }
    }
}

const EXCLUDED_USERS_LIST_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ExcludedUsersListContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExcludedUsersListContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExcludedUsersListContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExcludedUsersListContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersListContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExcludedUsersListContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersListContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExcludedUsersListContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExcludedUsersListContinueArg", EXCLUDED_USERS_LIST_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersListContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExcludedUsersListContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Excluded users list continue error.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExcludedUsersListContinueError {
    /// The cursor is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersListContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExcludedUsersListContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersListContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_cursor" => ExcludedUsersListContinueError::InvalidCursor,
                    _ => ExcludedUsersListContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("ExcludedUsersListContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersListContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExcludedUsersListContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ExcludedUsersListContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ExcludedUsersListContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ExcludedUsersListContinueError {
}

impl ::std::fmt::Display for ExcludedUsersListContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ExcludedUsersListContinueError::InvalidCursor => f.write_str("The cursor is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Excluded users list error.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExcludedUsersListError {
    /// An error occurred.
    ListError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersListError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExcludedUsersListError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersListError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "list_error" => ExcludedUsersListError::ListError,
                    _ => ExcludedUsersListError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["list_error",
                                    "other"];
        deserializer.deserialize_struct("ExcludedUsersListError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersListError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExcludedUsersListError::ListError => {
                // unit
                let mut s = serializer.serialize_struct("ExcludedUsersListError", 1)?;
                s.serialize_field(".tag", "list_error")?;
                s.end()
            }
            ExcludedUsersListError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ExcludedUsersListError {
}

impl ::std::fmt::Display for ExcludedUsersListError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ExcludedUsersListError::ListError => f.write_str("An error occurred."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Excluded users list result.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExcludedUsersListResult {
    pub users: Vec<MemberProfile>,
    /// Is true if there are additional excluded users that have not been returned yet. An
    /// additional call to
    /// [`member_space_limits_excluded_users_list_continue()`](member_space_limits_excluded_users_list_continue)
    /// can retrieve them.
    pub has_more: bool,
    /// Pass the cursor into
    /// [`member_space_limits_excluded_users_list_continue()`](member_space_limits_excluded_users_list_continue)
    /// to obtain additional excluded users.
    pub cursor: Option<String>,
}

impl ExcludedUsersListResult {
    pub fn new(users: Vec<MemberProfile>, has_more: bool) -> Self {
        ExcludedUsersListResult {
            users,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const EXCLUDED_USERS_LIST_RESULT_FIELDS: &[&str] = &["users",
                                                     "has_more",
                                                     "cursor"];
impl ExcludedUsersListResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExcludedUsersListResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExcludedUsersListResult>, V::Error> {
        let mut field_users = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExcludedUsersListResult {
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersListResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExcludedUsersListResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersListResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExcludedUsersListResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExcludedUsersListResult", EXCLUDED_USERS_LIST_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersListResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExcludedUsersListResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Argument of excluded users update operation. Should include a list of users to add/remove
/// (according to endpoint), Maximum size of the list is 1000 users.
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExcludedUsersUpdateArg {
    /// List of users to be added/removed.
    pub users: Option<Vec<UserSelectorArg>>,
}

impl ExcludedUsersUpdateArg {
    pub fn with_users(mut self, value: Vec<UserSelectorArg>) -> Self {
        self.users = Some(value);
        self
    }
}

const EXCLUDED_USERS_UPDATE_ARG_FIELDS: &[&str] = &["users"];
impl ExcludedUsersUpdateArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ExcludedUsersUpdateArg, V::Error> {
        let mut field_users = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ExcludedUsersUpdateArg {
            users: field_users,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.users {
            s.serialize_field("users", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersUpdateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExcludedUsersUpdateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersUpdateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExcludedUsersUpdateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExcludedUsersUpdateArg", EXCLUDED_USERS_UPDATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersUpdateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExcludedUsersUpdateArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Excluded users update error.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExcludedUsersUpdateError {
    /// At least one of the users is not part of your team.
    UsersNotInTeam,
    /// A maximum of 1000 users for each of addition/removal can be supplied.
    TooManyUsers,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersUpdateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExcludedUsersUpdateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersUpdateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "users_not_in_team" => ExcludedUsersUpdateError::UsersNotInTeam,
                    "too_many_users" => ExcludedUsersUpdateError::TooManyUsers,
                    _ => ExcludedUsersUpdateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["users_not_in_team",
                                    "too_many_users",
                                    "other"];
        deserializer.deserialize_struct("ExcludedUsersUpdateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersUpdateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExcludedUsersUpdateError::UsersNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("ExcludedUsersUpdateError", 1)?;
                s.serialize_field(".tag", "users_not_in_team")?;
                s.end()
            }
            ExcludedUsersUpdateError::TooManyUsers => {
                // unit
                let mut s = serializer.serialize_struct("ExcludedUsersUpdateError", 1)?;
                s.serialize_field(".tag", "too_many_users")?;
                s.end()
            }
            ExcludedUsersUpdateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ExcludedUsersUpdateError {
}

impl ::std::fmt::Display for ExcludedUsersUpdateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ExcludedUsersUpdateError::UsersNotInTeam => f.write_str("At least one of the users is not part of your team."),
            ExcludedUsersUpdateError::TooManyUsers => f.write_str("A maximum of 1000 users for each of addition/removal can be supplied."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Excluded users update result.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExcludedUsersUpdateResult {
    /// Update status.
    pub status: ExcludedUsersUpdateStatus,
}

impl ExcludedUsersUpdateResult {
    pub fn new(status: ExcludedUsersUpdateStatus) -> Self {
        ExcludedUsersUpdateResult {
            status,
        }
    }
}

const EXCLUDED_USERS_UPDATE_RESULT_FIELDS: &[&str] = &["status"];
impl ExcludedUsersUpdateResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExcludedUsersUpdateResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExcludedUsersUpdateResult>, V::Error> {
        let mut field_status = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "status" => {
                    if field_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("status"));
                    }
                    field_status = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExcludedUsersUpdateResult {
            status: field_status.ok_or_else(|| ::serde::de::Error::missing_field("status"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("status", &self.status)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersUpdateResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExcludedUsersUpdateResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersUpdateResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExcludedUsersUpdateResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExcludedUsersUpdateResult", EXCLUDED_USERS_UPDATE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersUpdateResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExcludedUsersUpdateResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Excluded users update operation status.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExcludedUsersUpdateStatus {
    /// Update successful.
    Success,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExcludedUsersUpdateStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExcludedUsersUpdateStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExcludedUsersUpdateStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => ExcludedUsersUpdateStatus::Success,
                    _ => ExcludedUsersUpdateStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "other"];
        deserializer.deserialize_struct("ExcludedUsersUpdateStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExcludedUsersUpdateStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExcludedUsersUpdateStatus::Success => {
                // unit
                let mut s = serializer.serialize_struct("ExcludedUsersUpdateStatus", 1)?;
                s.serialize_field(".tag", "success")?;
                s.end()
            }
            ExcludedUsersUpdateStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// A set of features that a Dropbox Business account may support.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum Feature {
    /// The number of upload API calls allowed per month.
    UploadApiRateLimit,
    /// Does this team have a shared team root.
    HasTeamSharedDropbox,
    /// Does this team have file events.
    HasTeamFileEvents,
    /// Does this team have team selective sync enabled.
    HasTeamSelectiveSync,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for Feature {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = Feature;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Feature structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "upload_api_rate_limit" => Feature::UploadApiRateLimit,
                    "has_team_shared_dropbox" => Feature::HasTeamSharedDropbox,
                    "has_team_file_events" => Feature::HasTeamFileEvents,
                    "has_team_selective_sync" => Feature::HasTeamSelectiveSync,
                    _ => Feature::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["upload_api_rate_limit",
                                    "has_team_shared_dropbox",
                                    "has_team_file_events",
                                    "has_team_selective_sync",
                                    "other"];
        deserializer.deserialize_struct("Feature", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for Feature {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            Feature::UploadApiRateLimit => {
                // unit
                let mut s = serializer.serialize_struct("Feature", 1)?;
                s.serialize_field(".tag", "upload_api_rate_limit")?;
                s.end()
            }
            Feature::HasTeamSharedDropbox => {
                // unit
                let mut s = serializer.serialize_struct("Feature", 1)?;
                s.serialize_field(".tag", "has_team_shared_dropbox")?;
                s.end()
            }
            Feature::HasTeamFileEvents => {
                // unit
                let mut s = serializer.serialize_struct("Feature", 1)?;
                s.serialize_field(".tag", "has_team_file_events")?;
                s.end()
            }
            Feature::HasTeamSelectiveSync => {
                // unit
                let mut s = serializer.serialize_struct("Feature", 1)?;
                s.serialize_field(".tag", "has_team_selective_sync")?;
                s.end()
            }
            Feature::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The values correspond to entries in [`Feature`](Feature). You may get different value according
/// to your Dropbox Business plan.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FeatureValue {
    UploadApiRateLimit(UploadApiRateLimitValue),
    HasTeamSharedDropbox(HasTeamSharedDropboxValue),
    HasTeamFileEvents(HasTeamFileEventsValue),
    HasTeamSelectiveSync(HasTeamSelectiveSyncValue),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FeatureValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FeatureValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FeatureValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "upload_api_rate_limit" => {
                        match map.next_key()? {
                            Some("upload_api_rate_limit") => FeatureValue::UploadApiRateLimit(map.next_value()?),
                            None => return Err(de::Error::missing_field("upload_api_rate_limit")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "has_team_shared_dropbox" => {
                        match map.next_key()? {
                            Some("has_team_shared_dropbox") => FeatureValue::HasTeamSharedDropbox(map.next_value()?),
                            None => return Err(de::Error::missing_field("has_team_shared_dropbox")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "has_team_file_events" => {
                        match map.next_key()? {
                            Some("has_team_file_events") => FeatureValue::HasTeamFileEvents(map.next_value()?),
                            None => return Err(de::Error::missing_field("has_team_file_events")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "has_team_selective_sync" => {
                        match map.next_key()? {
                            Some("has_team_selective_sync") => FeatureValue::HasTeamSelectiveSync(map.next_value()?),
                            None => return Err(de::Error::missing_field("has_team_selective_sync")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => FeatureValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["upload_api_rate_limit",
                                    "has_team_shared_dropbox",
                                    "has_team_file_events",
                                    "has_team_selective_sync",
                                    "other"];
        deserializer.deserialize_struct("FeatureValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FeatureValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FeatureValue::UploadApiRateLimit(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FeatureValue", 2)?;
                s.serialize_field(".tag", "upload_api_rate_limit")?;
                s.serialize_field("upload_api_rate_limit", x)?;
                s.end()
            }
            FeatureValue::HasTeamSharedDropbox(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FeatureValue", 2)?;
                s.serialize_field(".tag", "has_team_shared_dropbox")?;
                s.serialize_field("has_team_shared_dropbox", x)?;
                s.end()
            }
            FeatureValue::HasTeamFileEvents(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FeatureValue", 2)?;
                s.serialize_field(".tag", "has_team_file_events")?;
                s.serialize_field("has_team_file_events", x)?;
                s.end()
            }
            FeatureValue::HasTeamSelectiveSync(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FeatureValue", 2)?;
                s.serialize_field(".tag", "has_team_selective_sync")?;
                s.serialize_field("has_team_selective_sync", x)?;
                s.end()
            }
            FeatureValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FeaturesGetValuesBatchArg {
    /// A list of features in [`Feature`](Feature). If the list is empty, this route will return
    /// [`FeaturesGetValuesBatchError`](FeaturesGetValuesBatchError).
    pub features: Vec<Feature>,
}

impl FeaturesGetValuesBatchArg {
    pub fn new(features: Vec<Feature>) -> Self {
        FeaturesGetValuesBatchArg {
            features,
        }
    }
}

const FEATURES_GET_VALUES_BATCH_ARG_FIELDS: &[&str] = &["features"];
impl FeaturesGetValuesBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FeaturesGetValuesBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FeaturesGetValuesBatchArg>, V::Error> {
        let mut field_features = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "features" => {
                    if field_features.is_some() {
                        return Err(::serde::de::Error::duplicate_field("features"));
                    }
                    field_features = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FeaturesGetValuesBatchArg {
            features: field_features.ok_or_else(|| ::serde::de::Error::missing_field("features"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("features", &self.features)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FeaturesGetValuesBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FeaturesGetValuesBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FeaturesGetValuesBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FeaturesGetValuesBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FeaturesGetValuesBatchArg", FEATURES_GET_VALUES_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FeaturesGetValuesBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FeaturesGetValuesBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FeaturesGetValuesBatchError {
    /// At least one [`Feature`](Feature) must be included in the
    /// [`FeaturesGetValuesBatchArg`](FeaturesGetValuesBatchArg).features list.
    EmptyFeaturesList,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FeaturesGetValuesBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FeaturesGetValuesBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FeaturesGetValuesBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "empty_features_list" => FeaturesGetValuesBatchError::EmptyFeaturesList,
                    _ => FeaturesGetValuesBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["empty_features_list",
                                    "other"];
        deserializer.deserialize_struct("FeaturesGetValuesBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FeaturesGetValuesBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FeaturesGetValuesBatchError::EmptyFeaturesList => {
                // unit
                let mut s = serializer.serialize_struct("FeaturesGetValuesBatchError", 1)?;
                s.serialize_field(".tag", "empty_features_list")?;
                s.end()
            }
            FeaturesGetValuesBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for FeaturesGetValuesBatchError {
}

impl ::std::fmt::Display for FeaturesGetValuesBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FeaturesGetValuesBatchResult {
    pub values: Vec<FeatureValue>,
}

impl FeaturesGetValuesBatchResult {
    pub fn new(values: Vec<FeatureValue>) -> Self {
        FeaturesGetValuesBatchResult {
            values,
        }
    }
}

const FEATURES_GET_VALUES_BATCH_RESULT_FIELDS: &[&str] = &["values"];
impl FeaturesGetValuesBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FeaturesGetValuesBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FeaturesGetValuesBatchResult>, V::Error> {
        let mut field_values = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "values" => {
                    if field_values.is_some() {
                        return Err(::serde::de::Error::duplicate_field("values"));
                    }
                    field_values = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FeaturesGetValuesBatchResult {
            values: field_values.ok_or_else(|| ::serde::de::Error::missing_field("values"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("values", &self.values)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FeaturesGetValuesBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FeaturesGetValuesBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FeaturesGetValuesBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FeaturesGetValuesBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FeaturesGetValuesBatchResult", FEATURES_GET_VALUES_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FeaturesGetValuesBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FeaturesGetValuesBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Activity Report Result. Each of the items in the storage report is an array of values, one value
/// per day. If there is no data for a day, then the value will be None.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetActivityReport {
    /// First date present in the results as 'YYYY-MM-DD' or None.
    pub start_date: String,
    /// Array of total number of adds by team members.
    pub adds: NumberPerDay,
    /// Array of number of edits by team members. If the same user edits the same file multiple
    /// times this is counted as a single edit.
    pub edits: NumberPerDay,
    /// Array of total number of deletes by team members.
    pub deletes: NumberPerDay,
    /// Array of the number of users who have been active in the last 28 days.
    pub active_users_28_day: NumberPerDay,
    /// Array of the number of users who have been active in the last week.
    pub active_users_7_day: NumberPerDay,
    /// Array of the number of users who have been active in the last day.
    pub active_users_1_day: NumberPerDay,
    /// Array of the number of shared folders with some activity in the last 28 days.
    pub active_shared_folders_28_day: NumberPerDay,
    /// Array of the number of shared folders with some activity in the last week.
    pub active_shared_folders_7_day: NumberPerDay,
    /// Array of the number of shared folders with some activity in the last day.
    pub active_shared_folders_1_day: NumberPerDay,
    /// Array of the number of shared links created.
    pub shared_links_created: NumberPerDay,
    /// Array of the number of views by team users to shared links created by the team.
    pub shared_links_viewed_by_team: NumberPerDay,
    /// Array of the number of views by users outside of the team to shared links created by the
    /// team.
    pub shared_links_viewed_by_outside_user: NumberPerDay,
    /// Array of the number of views by non-logged-in users to shared links created by the team.
    pub shared_links_viewed_by_not_logged_in: NumberPerDay,
    /// Array of the total number of views to shared links created by the team.
    pub shared_links_viewed_total: NumberPerDay,
}

impl GetActivityReport {
    pub fn new(
        start_date: String,
        adds: NumberPerDay,
        edits: NumberPerDay,
        deletes: NumberPerDay,
        active_users_28_day: NumberPerDay,
        active_users_7_day: NumberPerDay,
        active_users_1_day: NumberPerDay,
        active_shared_folders_28_day: NumberPerDay,
        active_shared_folders_7_day: NumberPerDay,
        active_shared_folders_1_day: NumberPerDay,
        shared_links_created: NumberPerDay,
        shared_links_viewed_by_team: NumberPerDay,
        shared_links_viewed_by_outside_user: NumberPerDay,
        shared_links_viewed_by_not_logged_in: NumberPerDay,
        shared_links_viewed_total: NumberPerDay,
    ) -> Self {
        GetActivityReport {
            start_date,
            adds,
            edits,
            deletes,
            active_users_28_day,
            active_users_7_day,
            active_users_1_day,
            active_shared_folders_28_day,
            active_shared_folders_7_day,
            active_shared_folders_1_day,
            shared_links_created,
            shared_links_viewed_by_team,
            shared_links_viewed_by_outside_user,
            shared_links_viewed_by_not_logged_in,
            shared_links_viewed_total,
        }
    }
}

const GET_ACTIVITY_REPORT_FIELDS: &[&str] = &["start_date",
                                              "adds",
                                              "edits",
                                              "deletes",
                                              "active_users_28_day",
                                              "active_users_7_day",
                                              "active_users_1_day",
                                              "active_shared_folders_28_day",
                                              "active_shared_folders_7_day",
                                              "active_shared_folders_1_day",
                                              "shared_links_created",
                                              "shared_links_viewed_by_team",
                                              "shared_links_viewed_by_outside_user",
                                              "shared_links_viewed_by_not_logged_in",
                                              "shared_links_viewed_total"];
impl GetActivityReport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetActivityReport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetActivityReport>, V::Error> {
        let mut field_start_date = None;
        let mut field_adds = None;
        let mut field_edits = None;
        let mut field_deletes = None;
        let mut field_active_users_28_day = None;
        let mut field_active_users_7_day = None;
        let mut field_active_users_1_day = None;
        let mut field_active_shared_folders_28_day = None;
        let mut field_active_shared_folders_7_day = None;
        let mut field_active_shared_folders_1_day = None;
        let mut field_shared_links_created = None;
        let mut field_shared_links_viewed_by_team = None;
        let mut field_shared_links_viewed_by_outside_user = None;
        let mut field_shared_links_viewed_by_not_logged_in = None;
        let mut field_shared_links_viewed_total = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "adds" => {
                    if field_adds.is_some() {
                        return Err(::serde::de::Error::duplicate_field("adds"));
                    }
                    field_adds = Some(map.next_value()?);
                }
                "edits" => {
                    if field_edits.is_some() {
                        return Err(::serde::de::Error::duplicate_field("edits"));
                    }
                    field_edits = Some(map.next_value()?);
                }
                "deletes" => {
                    if field_deletes.is_some() {
                        return Err(::serde::de::Error::duplicate_field("deletes"));
                    }
                    field_deletes = Some(map.next_value()?);
                }
                "active_users_28_day" => {
                    if field_active_users_28_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_users_28_day"));
                    }
                    field_active_users_28_day = Some(map.next_value()?);
                }
                "active_users_7_day" => {
                    if field_active_users_7_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_users_7_day"));
                    }
                    field_active_users_7_day = Some(map.next_value()?);
                }
                "active_users_1_day" => {
                    if field_active_users_1_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_users_1_day"));
                    }
                    field_active_users_1_day = Some(map.next_value()?);
                }
                "active_shared_folders_28_day" => {
                    if field_active_shared_folders_28_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_shared_folders_28_day"));
                    }
                    field_active_shared_folders_28_day = Some(map.next_value()?);
                }
                "active_shared_folders_7_day" => {
                    if field_active_shared_folders_7_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_shared_folders_7_day"));
                    }
                    field_active_shared_folders_7_day = Some(map.next_value()?);
                }
                "active_shared_folders_1_day" => {
                    if field_active_shared_folders_1_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_shared_folders_1_day"));
                    }
                    field_active_shared_folders_1_day = Some(map.next_value()?);
                }
                "shared_links_created" => {
                    if field_shared_links_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_links_created"));
                    }
                    field_shared_links_created = Some(map.next_value()?);
                }
                "shared_links_viewed_by_team" => {
                    if field_shared_links_viewed_by_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_links_viewed_by_team"));
                    }
                    field_shared_links_viewed_by_team = Some(map.next_value()?);
                }
                "shared_links_viewed_by_outside_user" => {
                    if field_shared_links_viewed_by_outside_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_links_viewed_by_outside_user"));
                    }
                    field_shared_links_viewed_by_outside_user = Some(map.next_value()?);
                }
                "shared_links_viewed_by_not_logged_in" => {
                    if field_shared_links_viewed_by_not_logged_in.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_links_viewed_by_not_logged_in"));
                    }
                    field_shared_links_viewed_by_not_logged_in = Some(map.next_value()?);
                }
                "shared_links_viewed_total" => {
                    if field_shared_links_viewed_total.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_links_viewed_total"));
                    }
                    field_shared_links_viewed_total = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetActivityReport {
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
            adds: field_adds.ok_or_else(|| ::serde::de::Error::missing_field("adds"))?,
            edits: field_edits.ok_or_else(|| ::serde::de::Error::missing_field("edits"))?,
            deletes: field_deletes.ok_or_else(|| ::serde::de::Error::missing_field("deletes"))?,
            active_users_28_day: field_active_users_28_day.ok_or_else(|| ::serde::de::Error::missing_field("active_users_28_day"))?,
            active_users_7_day: field_active_users_7_day.ok_or_else(|| ::serde::de::Error::missing_field("active_users_7_day"))?,
            active_users_1_day: field_active_users_1_day.ok_or_else(|| ::serde::de::Error::missing_field("active_users_1_day"))?,
            active_shared_folders_28_day: field_active_shared_folders_28_day.ok_or_else(|| ::serde::de::Error::missing_field("active_shared_folders_28_day"))?,
            active_shared_folders_7_day: field_active_shared_folders_7_day.ok_or_else(|| ::serde::de::Error::missing_field("active_shared_folders_7_day"))?,
            active_shared_folders_1_day: field_active_shared_folders_1_day.ok_or_else(|| ::serde::de::Error::missing_field("active_shared_folders_1_day"))?,
            shared_links_created: field_shared_links_created.ok_or_else(|| ::serde::de::Error::missing_field("shared_links_created"))?,
            shared_links_viewed_by_team: field_shared_links_viewed_by_team.ok_or_else(|| ::serde::de::Error::missing_field("shared_links_viewed_by_team"))?,
            shared_links_viewed_by_outside_user: field_shared_links_viewed_by_outside_user.ok_or_else(|| ::serde::de::Error::missing_field("shared_links_viewed_by_outside_user"))?,
            shared_links_viewed_by_not_logged_in: field_shared_links_viewed_by_not_logged_in.ok_or_else(|| ::serde::de::Error::missing_field("shared_links_viewed_by_not_logged_in"))?,
            shared_links_viewed_total: field_shared_links_viewed_total.ok_or_else(|| ::serde::de::Error::missing_field("shared_links_viewed_total"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("start_date", &self.start_date)?;
        s.serialize_field("adds", &self.adds)?;
        s.serialize_field("edits", &self.edits)?;
        s.serialize_field("deletes", &self.deletes)?;
        s.serialize_field("active_users_28_day", &self.active_users_28_day)?;
        s.serialize_field("active_users_7_day", &self.active_users_7_day)?;
        s.serialize_field("active_users_1_day", &self.active_users_1_day)?;
        s.serialize_field("active_shared_folders_28_day", &self.active_shared_folders_28_day)?;
        s.serialize_field("active_shared_folders_7_day", &self.active_shared_folders_7_day)?;
        s.serialize_field("active_shared_folders_1_day", &self.active_shared_folders_1_day)?;
        s.serialize_field("shared_links_created", &self.shared_links_created)?;
        s.serialize_field("shared_links_viewed_by_team", &self.shared_links_viewed_by_team)?;
        s.serialize_field("shared_links_viewed_by_outside_user", &self.shared_links_viewed_by_outside_user)?;
        s.serialize_field("shared_links_viewed_by_not_logged_in", &self.shared_links_viewed_by_not_logged_in)?;
        s.serialize_field("shared_links_viewed_total", &self.shared_links_viewed_total)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetActivityReport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetActivityReport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetActivityReport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetActivityReport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetActivityReport", GET_ACTIVITY_REPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetActivityReport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetActivityReport", 15)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Devices Report Result. Contains subsections for different time ranges of activity. Each of the
/// items in each subsection of the storage report is an array of values, one value per day. If
/// there is no data for a day, then the value will be None.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetDevicesReport {
    /// First date present in the results as 'YYYY-MM-DD' or None.
    pub start_date: String,
    /// Report of the number of devices active in the last day.
    pub active_1_day: DevicesActive,
    /// Report of the number of devices active in the last 7 days.
    pub active_7_day: DevicesActive,
    /// Report of the number of devices active in the last 28 days.
    pub active_28_day: DevicesActive,
}

impl GetDevicesReport {
    pub fn new(
        start_date: String,
        active_1_day: DevicesActive,
        active_7_day: DevicesActive,
        active_28_day: DevicesActive,
    ) -> Self {
        GetDevicesReport {
            start_date,
            active_1_day,
            active_7_day,
            active_28_day,
        }
    }
}

const GET_DEVICES_REPORT_FIELDS: &[&str] = &["start_date",
                                             "active_1_day",
                                             "active_7_day",
                                             "active_28_day"];
impl GetDevicesReport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetDevicesReport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetDevicesReport>, V::Error> {
        let mut field_start_date = None;
        let mut field_active_1_day = None;
        let mut field_active_7_day = None;
        let mut field_active_28_day = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "active_1_day" => {
                    if field_active_1_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_1_day"));
                    }
                    field_active_1_day = Some(map.next_value()?);
                }
                "active_7_day" => {
                    if field_active_7_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_7_day"));
                    }
                    field_active_7_day = Some(map.next_value()?);
                }
                "active_28_day" => {
                    if field_active_28_day.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_28_day"));
                    }
                    field_active_28_day = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetDevicesReport {
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
            active_1_day: field_active_1_day.ok_or_else(|| ::serde::de::Error::missing_field("active_1_day"))?,
            active_7_day: field_active_7_day.ok_or_else(|| ::serde::de::Error::missing_field("active_7_day"))?,
            active_28_day: field_active_28_day.ok_or_else(|| ::serde::de::Error::missing_field("active_28_day"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("start_date", &self.start_date)?;
        s.serialize_field("active_1_day", &self.active_1_day)?;
        s.serialize_field("active_7_day", &self.active_7_day)?;
        s.serialize_field("active_28_day", &self.active_28_day)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetDevicesReport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetDevicesReport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetDevicesReport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetDevicesReport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetDevicesReport", GET_DEVICES_REPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetDevicesReport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetDevicesReport", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Membership Report Result. Each of the items in the storage report is an array of values, one
/// value per day. If there is no data for a day, then the value will be None.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetMembershipReport {
    /// First date present in the results as 'YYYY-MM-DD' or None.
    pub start_date: String,
    /// Team size, for each day.
    pub team_size: NumberPerDay,
    /// The number of pending invites to the team, for each day.
    pub pending_invites: NumberPerDay,
    /// The number of members that joined the team, for each day.
    pub members_joined: NumberPerDay,
    /// The number of suspended team members, for each day.
    pub suspended_members: NumberPerDay,
    /// The total number of licenses the team has, for each day.
    pub licenses: NumberPerDay,
}

impl GetMembershipReport {
    pub fn new(
        start_date: String,
        team_size: NumberPerDay,
        pending_invites: NumberPerDay,
        members_joined: NumberPerDay,
        suspended_members: NumberPerDay,
        licenses: NumberPerDay,
    ) -> Self {
        GetMembershipReport {
            start_date,
            team_size,
            pending_invites,
            members_joined,
            suspended_members,
            licenses,
        }
    }
}

const GET_MEMBERSHIP_REPORT_FIELDS: &[&str] = &["start_date",
                                                "team_size",
                                                "pending_invites",
                                                "members_joined",
                                                "suspended_members",
                                                "licenses"];
impl GetMembershipReport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetMembershipReport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetMembershipReport>, V::Error> {
        let mut field_start_date = None;
        let mut field_team_size = None;
        let mut field_pending_invites = None;
        let mut field_members_joined = None;
        let mut field_suspended_members = None;
        let mut field_licenses = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "team_size" => {
                    if field_team_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_size"));
                    }
                    field_team_size = Some(map.next_value()?);
                }
                "pending_invites" => {
                    if field_pending_invites.is_some() {
                        return Err(::serde::de::Error::duplicate_field("pending_invites"));
                    }
                    field_pending_invites = Some(map.next_value()?);
                }
                "members_joined" => {
                    if field_members_joined.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members_joined"));
                    }
                    field_members_joined = Some(map.next_value()?);
                }
                "suspended_members" => {
                    if field_suspended_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("suspended_members"));
                    }
                    field_suspended_members = Some(map.next_value()?);
                }
                "licenses" => {
                    if field_licenses.is_some() {
                        return Err(::serde::de::Error::duplicate_field("licenses"));
                    }
                    field_licenses = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetMembershipReport {
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
            team_size: field_team_size.ok_or_else(|| ::serde::de::Error::missing_field("team_size"))?,
            pending_invites: field_pending_invites.ok_or_else(|| ::serde::de::Error::missing_field("pending_invites"))?,
            members_joined: field_members_joined.ok_or_else(|| ::serde::de::Error::missing_field("members_joined"))?,
            suspended_members: field_suspended_members.ok_or_else(|| ::serde::de::Error::missing_field("suspended_members"))?,
            licenses: field_licenses.ok_or_else(|| ::serde::de::Error::missing_field("licenses"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("start_date", &self.start_date)?;
        s.serialize_field("team_size", &self.team_size)?;
        s.serialize_field("pending_invites", &self.pending_invites)?;
        s.serialize_field("members_joined", &self.members_joined)?;
        s.serialize_field("suspended_members", &self.suspended_members)?;
        s.serialize_field("licenses", &self.licenses)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetMembershipReport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetMembershipReport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetMembershipReport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetMembershipReport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetMembershipReport", GET_MEMBERSHIP_REPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetMembershipReport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetMembershipReport", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Storage Report Result. Each of the items in the storage report is an array of values, one value
/// per day. If there is no data for a day, then the value will be None.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetStorageReport {
    /// First date present in the results as 'YYYY-MM-DD' or None.
    pub start_date: String,
    /// Sum of the shared, unshared, and datastore usages, for each day.
    pub total_usage: NumberPerDay,
    /// Array of the combined size (bytes) of team members' shared folders, for each day.
    pub shared_usage: NumberPerDay,
    /// Array of the combined size (bytes) of team members' root namespaces, for each day.
    pub unshared_usage: NumberPerDay,
    /// Array of the number of shared folders owned by team members, for each day.
    pub shared_folders: NumberPerDay,
    /// Array of storage summaries of team members' account sizes. Each storage summary is an array
    /// of key, value pairs, where each pair describes a storage bucket. The key indicates the upper
    /// bound of the bucket and the value is the number of users in that bucket. There is one such
    /// summary per day. If there is no data for a day, the storage summary will be empty.
    pub member_storage_map: Vec<Vec<StorageBucket>>,
}

impl GetStorageReport {
    pub fn new(
        start_date: String,
        total_usage: NumberPerDay,
        shared_usage: NumberPerDay,
        unshared_usage: NumberPerDay,
        shared_folders: NumberPerDay,
        member_storage_map: Vec<Vec<StorageBucket>>,
    ) -> Self {
        GetStorageReport {
            start_date,
            total_usage,
            shared_usage,
            unshared_usage,
            shared_folders,
            member_storage_map,
        }
    }
}

const GET_STORAGE_REPORT_FIELDS: &[&str] = &["start_date",
                                             "total_usage",
                                             "shared_usage",
                                             "unshared_usage",
                                             "shared_folders",
                                             "member_storage_map"];
impl GetStorageReport {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetStorageReport, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetStorageReport>, V::Error> {
        let mut field_start_date = None;
        let mut field_total_usage = None;
        let mut field_shared_usage = None;
        let mut field_unshared_usage = None;
        let mut field_shared_folders = None;
        let mut field_member_storage_map = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "total_usage" => {
                    if field_total_usage.is_some() {
                        return Err(::serde::de::Error::duplicate_field("total_usage"));
                    }
                    field_total_usage = Some(map.next_value()?);
                }
                "shared_usage" => {
                    if field_shared_usage.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_usage"));
                    }
                    field_shared_usage = Some(map.next_value()?);
                }
                "unshared_usage" => {
                    if field_unshared_usage.is_some() {
                        return Err(::serde::de::Error::duplicate_field("unshared_usage"));
                    }
                    field_unshared_usage = Some(map.next_value()?);
                }
                "shared_folders" => {
                    if field_shared_folders.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folders"));
                    }
                    field_shared_folders = Some(map.next_value()?);
                }
                "member_storage_map" => {
                    if field_member_storage_map.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_storage_map"));
                    }
                    field_member_storage_map = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetStorageReport {
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
            total_usage: field_total_usage.ok_or_else(|| ::serde::de::Error::missing_field("total_usage"))?,
            shared_usage: field_shared_usage.ok_or_else(|| ::serde::de::Error::missing_field("shared_usage"))?,
            unshared_usage: field_unshared_usage.ok_or_else(|| ::serde::de::Error::missing_field("unshared_usage"))?,
            shared_folders: field_shared_folders.ok_or_else(|| ::serde::de::Error::missing_field("shared_folders"))?,
            member_storage_map: field_member_storage_map.ok_or_else(|| ::serde::de::Error::missing_field("member_storage_map"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("start_date", &self.start_date)?;
        s.serialize_field("total_usage", &self.total_usage)?;
        s.serialize_field("shared_usage", &self.shared_usage)?;
        s.serialize_field("unshared_usage", &self.unshared_usage)?;
        s.serialize_field("shared_folders", &self.shared_folders)?;
        s.serialize_field("member_storage_map", &self.member_storage_map)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetStorageReport {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetStorageReport;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetStorageReport struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetStorageReport::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetStorageReport", GET_STORAGE_REPORT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetStorageReport {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetStorageReport", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Role of a user in group.
#[derive(Debug, Clone, PartialEq)]
pub enum GroupAccessType {
    /// User is a member of the group, but has no special permissions.
    Member,
    /// User can rename the group, and add/remove members.
    Owner,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupAccessType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupAccessType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupAccessType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "member" => GroupAccessType::Member,
                    "owner" => GroupAccessType::Owner,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["member",
                                    "owner"];
        deserializer.deserialize_struct("GroupAccessType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupAccessType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupAccessType::Member => {
                // unit
                let mut s = serializer.serialize_struct("GroupAccessType", 1)?;
                s.serialize_field(".tag", "member")?;
                s.end()
            }
            GroupAccessType::Owner => {
                // unit
                let mut s = serializer.serialize_struct("GroupAccessType", 1)?;
                s.serialize_field(".tag", "owner")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupCreateArg {
    /// Group name.
    pub group_name: String,
    /// Automatically add the creator of the group.
    pub add_creator_as_owner: bool,
    /// The creator of a team can associate an arbitrary external ID to the group.
    pub group_external_id: Option<super::team_common::GroupExternalId>,
    /// Whether the team can be managed by selected users, or only by team admins.
    pub group_management_type: Option<super::team_common::GroupManagementType>,
}

impl GroupCreateArg {
    pub fn new(group_name: String) -> Self {
        GroupCreateArg {
            group_name,
            add_creator_as_owner: false,
            group_external_id: None,
            group_management_type: None,
        }
    }

    pub fn with_add_creator_as_owner(mut self, value: bool) -> Self {
        self.add_creator_as_owner = value;
        self
    }

    pub fn with_group_external_id(mut self, value: super::team_common::GroupExternalId) -> Self {
        self.group_external_id = Some(value);
        self
    }

    pub fn with_group_management_type(
        mut self,
        value: super::team_common::GroupManagementType,
    ) -> Self {
        self.group_management_type = Some(value);
        self
    }
}

const GROUP_CREATE_ARG_FIELDS: &[&str] = &["group_name",
                                           "add_creator_as_owner",
                                           "group_external_id",
                                           "group_management_type"];
impl GroupCreateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupCreateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupCreateArg>, V::Error> {
        let mut field_group_name = None;
        let mut field_add_creator_as_owner = None;
        let mut field_group_external_id = None;
        let mut field_group_management_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group_name" => {
                    if field_group_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_name"));
                    }
                    field_group_name = Some(map.next_value()?);
                }
                "add_creator_as_owner" => {
                    if field_add_creator_as_owner.is_some() {
                        return Err(::serde::de::Error::duplicate_field("add_creator_as_owner"));
                    }
                    field_add_creator_as_owner = Some(map.next_value()?);
                }
                "group_external_id" => {
                    if field_group_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_external_id"));
                    }
                    field_group_external_id = Some(map.next_value()?);
                }
                "group_management_type" => {
                    if field_group_management_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_management_type"));
                    }
                    field_group_management_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupCreateArg {
            group_name: field_group_name.ok_or_else(|| ::serde::de::Error::missing_field("group_name"))?,
            add_creator_as_owner: field_add_creator_as_owner.unwrap_or(false),
            group_external_id: field_group_external_id,
            group_management_type: field_group_management_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group_name", &self.group_name)?;
        s.serialize_field("add_creator_as_owner", &self.add_creator_as_owner)?;
        if let Some(val) = &self.group_external_id {
            s.serialize_field("group_external_id", val)?;
        }
        if let Some(val) = &self.group_management_type {
            s.serialize_field("group_management_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupCreateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupCreateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupCreateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupCreateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupCreateArg", GROUP_CREATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupCreateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupCreateArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupCreateError {
    /// The requested group name is already being used by another group.
    GroupNameAlreadyUsed,
    /// Group name is empty or has invalid characters.
    GroupNameInvalid,
    /// The requested external ID is already being used by another group.
    ExternalIdAlreadyInUse,
    /// System-managed group cannot be manually created.
    SystemManagedGroupDisallowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupCreateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupCreateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupCreateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_name_already_used" => GroupCreateError::GroupNameAlreadyUsed,
                    "group_name_invalid" => GroupCreateError::GroupNameInvalid,
                    "external_id_already_in_use" => GroupCreateError::ExternalIdAlreadyInUse,
                    "system_managed_group_disallowed" => GroupCreateError::SystemManagedGroupDisallowed,
                    _ => GroupCreateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_name_already_used",
                                    "group_name_invalid",
                                    "external_id_already_in_use",
                                    "system_managed_group_disallowed",
                                    "other"];
        deserializer.deserialize_struct("GroupCreateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupCreateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupCreateError::GroupNameAlreadyUsed => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreateError", 1)?;
                s.serialize_field(".tag", "group_name_already_used")?;
                s.end()
            }
            GroupCreateError::GroupNameInvalid => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreateError", 1)?;
                s.serialize_field(".tag", "group_name_invalid")?;
                s.end()
            }
            GroupCreateError::ExternalIdAlreadyInUse => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreateError", 1)?;
                s.serialize_field(".tag", "external_id_already_in_use")?;
                s.end()
            }
            GroupCreateError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreateError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupCreateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupCreateError {
}

impl ::std::fmt::Display for GroupCreateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupCreateError::GroupNameAlreadyUsed => f.write_str("The requested group name is already being used by another group."),
            GroupCreateError::GroupNameInvalid => f.write_str("Group name is empty or has invalid characters."),
            GroupCreateError::ExternalIdAlreadyInUse => f.write_str("The requested external ID is already being used by another group."),
            GroupCreateError::SystemManagedGroupDisallowed => f.write_str("System-managed group cannot be manually created."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupDeleteError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// This group has already been deleted.
    GroupAlreadyDeleted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupDeleteError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupDeleteError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupDeleteError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupDeleteError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupDeleteError::SystemManagedGroupDisallowed,
                    "group_already_deleted" => GroupDeleteError::GroupAlreadyDeleted,
                    _ => GroupDeleteError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "group_already_deleted"];
        deserializer.deserialize_struct("GroupDeleteError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupDeleteError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupDeleteError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupDeleteError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupDeleteError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupDeleteError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupDeleteError::GroupAlreadyDeleted => {
                // unit
                let mut s = serializer.serialize_struct("GroupDeleteError", 1)?;
                s.serialize_field(".tag", "group_already_deleted")?;
                s.end()
            }
            GroupDeleteError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupDeleteError {
}

impl ::std::fmt::Display for GroupDeleteError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupDeleteError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupDeleteError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupDeleteError::GroupAlreadyDeleted => f.write_str("This group has already been deleted."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Full description of a group.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupFullInfo {
    pub group_name: String,
    pub group_id: super::team_common::GroupId,
    /// Who is allowed to manage the group.
    pub group_management_type: super::team_common::GroupManagementType,
    /// The group creation time as a UTC timestamp in milliseconds since the Unix epoch.
    pub created: u64,
    /// External ID of group. This is an arbitrary ID that an admin can attach to a group.
    pub group_external_id: Option<super::team_common::GroupExternalId>,
    /// The number of members in the group.
    pub member_count: Option<u32>,
    /// List of group members.
    pub members: Option<Vec<GroupMemberInfo>>,
}

impl GroupFullInfo {
    pub fn new(
        group_name: String,
        group_id: super::team_common::GroupId,
        group_management_type: super::team_common::GroupManagementType,
        created: u64,
    ) -> Self {
        GroupFullInfo {
            group_name,
            group_id,
            group_management_type,
            created,
            group_external_id: None,
            member_count: None,
            members: None,
        }
    }

    pub fn with_group_external_id(mut self, value: super::team_common::GroupExternalId) -> Self {
        self.group_external_id = Some(value);
        self
    }

    pub fn with_member_count(mut self, value: u32) -> Self {
        self.member_count = Some(value);
        self
    }

    pub fn with_members(mut self, value: Vec<GroupMemberInfo>) -> Self {
        self.members = Some(value);
        self
    }
}

const GROUP_FULL_INFO_FIELDS: &[&str] = &["group_name",
                                          "group_id",
                                          "group_management_type",
                                          "created",
                                          "group_external_id",
                                          "member_count",
                                          "members"];
impl GroupFullInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupFullInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupFullInfo>, V::Error> {
        let mut field_group_name = None;
        let mut field_group_id = None;
        let mut field_group_management_type = None;
        let mut field_created = None;
        let mut field_group_external_id = None;
        let mut field_member_count = None;
        let mut field_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group_name" => {
                    if field_group_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_name"));
                    }
                    field_group_name = Some(map.next_value()?);
                }
                "group_id" => {
                    if field_group_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_id"));
                    }
                    field_group_id = Some(map.next_value()?);
                }
                "group_management_type" => {
                    if field_group_management_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_management_type"));
                    }
                    field_group_management_type = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "group_external_id" => {
                    if field_group_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_external_id"));
                    }
                    field_group_external_id = Some(map.next_value()?);
                }
                "member_count" => {
                    if field_member_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_count"));
                    }
                    field_member_count = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupFullInfo {
            group_name: field_group_name.ok_or_else(|| ::serde::de::Error::missing_field("group_name"))?,
            group_id: field_group_id.ok_or_else(|| ::serde::de::Error::missing_field("group_id"))?,
            group_management_type: field_group_management_type.ok_or_else(|| ::serde::de::Error::missing_field("group_management_type"))?,
            created: field_created.ok_or_else(|| ::serde::de::Error::missing_field("created"))?,
            group_external_id: field_group_external_id,
            member_count: field_member_count,
            members: field_members,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group_name", &self.group_name)?;
        s.serialize_field("group_id", &self.group_id)?;
        s.serialize_field("group_management_type", &self.group_management_type)?;
        s.serialize_field("created", &self.created)?;
        if let Some(val) = &self.group_external_id {
            s.serialize_field("group_external_id", val)?;
        }
        if let Some(val) = &self.member_count {
            s.serialize_field("member_count", val)?;
        }
        if let Some(val) = &self.members {
            s.serialize_field("members", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupFullInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupFullInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupFullInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupFullInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupFullInfo", GROUP_FULL_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupFullInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupFullInfo", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Profile of group member, and role in group.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMemberInfo {
    /// Profile of group member.
    pub profile: MemberProfile,
    /// The role that the user has in the group.
    pub access_type: GroupAccessType,
}

impl GroupMemberInfo {
    pub fn new(profile: MemberProfile, access_type: GroupAccessType) -> Self {
        GroupMemberInfo {
            profile,
            access_type,
        }
    }
}

const GROUP_MEMBER_INFO_FIELDS: &[&str] = &["profile",
                                            "access_type"];
impl GroupMemberInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMemberInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMemberInfo>, V::Error> {
        let mut field_profile = None;
        let mut field_access_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "profile" => {
                    if field_profile.is_some() {
                        return Err(::serde::de::Error::duplicate_field("profile"));
                    }
                    field_profile = Some(map.next_value()?);
                }
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMemberInfo {
            profile: field_profile.ok_or_else(|| ::serde::de::Error::missing_field("profile"))?,
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("profile", &self.profile)?;
        s.serialize_field("access_type", &self.access_type)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMemberInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMemberInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMemberInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMemberInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMemberInfo", GROUP_MEMBER_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMemberInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMemberInfo", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Argument for selecting a group and a single user.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMemberSelector {
    /// Specify a group.
    pub group: GroupSelector,
    /// Identity of a user that is a member of `group`.
    pub user: UserSelectorArg,
}

impl GroupMemberSelector {
    pub fn new(group: GroupSelector, user: UserSelectorArg) -> Self {
        GroupMemberSelector {
            group,
            user,
        }
    }
}

const GROUP_MEMBER_SELECTOR_FIELDS: &[&str] = &["group",
                                                "user"];
impl GroupMemberSelector {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMemberSelector, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMemberSelector>, V::Error> {
        let mut field_group = None;
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMemberSelector {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("user", &self.user)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMemberSelector {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMemberSelector;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMemberSelector struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMemberSelector::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMemberSelector", GROUP_MEMBER_SELECTOR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMemberSelector {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMemberSelector", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error that can be raised when [`GroupMemberSelector`](GroupMemberSelector) is used, and the user
/// is required to be a member of the specified group.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupMemberSelectorError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// The specified user is not a member of this group.
    MemberNotInGroup,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMemberSelectorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupMemberSelectorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMemberSelectorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupMemberSelectorError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupMemberSelectorError::SystemManagedGroupDisallowed,
                    "member_not_in_group" => GroupMemberSelectorError::MemberNotInGroup,
                    _ => GroupMemberSelectorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "member_not_in_group"];
        deserializer.deserialize_struct("GroupMemberSelectorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMemberSelectorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupMemberSelectorError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSelectorError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupMemberSelectorError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSelectorError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupMemberSelectorError::MemberNotInGroup => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSelectorError", 1)?;
                s.serialize_field(".tag", "member_not_in_group")?;
                s.end()
            }
            GroupMemberSelectorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupMemberSelectorError {
}

impl ::std::fmt::Display for GroupMemberSelectorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupMemberSelectorError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupMemberSelectorError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupMemberSelectorError::MemberNotInGroup => f.write_str("The specified user is not a member of this group."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupMemberSetAccessTypeError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// The specified user is not a member of this group.
    MemberNotInGroup,
    /// A company managed group cannot be managed by a user.
    UserCannotBeManagerOfCompanyManagedGroup,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMemberSetAccessTypeError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupMemberSetAccessTypeError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMemberSetAccessTypeError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupMemberSetAccessTypeError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupMemberSetAccessTypeError::SystemManagedGroupDisallowed,
                    "member_not_in_group" => GroupMemberSetAccessTypeError::MemberNotInGroup,
                    "user_cannot_be_manager_of_company_managed_group" => GroupMemberSetAccessTypeError::UserCannotBeManagerOfCompanyManagedGroup,
                    _ => GroupMemberSetAccessTypeError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "member_not_in_group",
                                    "user_cannot_be_manager_of_company_managed_group"];
        deserializer.deserialize_struct("GroupMemberSetAccessTypeError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMemberSetAccessTypeError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupMemberSetAccessTypeError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSetAccessTypeError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupMemberSetAccessTypeError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSetAccessTypeError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupMemberSetAccessTypeError::MemberNotInGroup => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSetAccessTypeError", 1)?;
                s.serialize_field(".tag", "member_not_in_group")?;
                s.end()
            }
            GroupMemberSetAccessTypeError::UserCannotBeManagerOfCompanyManagedGroup => {
                // unit
                let mut s = serializer.serialize_struct("GroupMemberSetAccessTypeError", 1)?;
                s.serialize_field(".tag", "user_cannot_be_manager_of_company_managed_group")?;
                s.end()
            }
            GroupMemberSetAccessTypeError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupMemberSetAccessTypeError {
}

impl ::std::fmt::Display for GroupMemberSetAccessTypeError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupMemberSetAccessTypeError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupMemberSetAccessTypeError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupMemberSetAccessTypeError::MemberNotInGroup => f.write_str("The specified user is not a member of this group."),
            GroupMemberSetAccessTypeError::UserCannotBeManagerOfCompanyManagedGroup => f.write_str("A company managed group cannot be managed by a user."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembersAddArg {
    /// Group to which users will be added.
    pub group: GroupSelector,
    /// List of users to be added to the group.
    pub members: Vec<MemberAccess>,
    /// Whether to return the list of members in the group.  Note that the default value will cause
    /// all the group members  to be returned in the response. This may take a long time for large
    /// groups.
    pub return_members: bool,
}

impl GroupMembersAddArg {
    pub fn new(group: GroupSelector, members: Vec<MemberAccess>) -> Self {
        GroupMembersAddArg {
            group,
            members,
            return_members: true,
        }
    }

    pub fn with_return_members(mut self, value: bool) -> Self {
        self.return_members = value;
        self
    }
}

const GROUP_MEMBERS_ADD_ARG_FIELDS: &[&str] = &["group",
                                                "members",
                                                "return_members"];
impl GroupMembersAddArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembersAddArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembersAddArg>, V::Error> {
        let mut field_group = None;
        let mut field_members = None;
        let mut field_return_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "return_members" => {
                    if field_return_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("return_members"));
                    }
                    field_return_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembersAddArg {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            return_members: field_return_members.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("return_members", &self.return_members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersAddArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembersAddArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersAddArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembersAddArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembersAddArg", GROUP_MEMBERS_ADD_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersAddArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembersAddArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupMembersAddError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// You cannot add duplicate users. One or more of the members you are trying to add is already
    /// a member of the group.
    DuplicateUser,
    /// Group is not in this team. You cannot add members to a group that is outside of your team.
    GroupNotInTeam,
    /// These members are not part of your team. Currently, you cannot add members to a group if
    /// they are not part of your team, though this may change in a subsequent version. To add new
    /// members to your Dropbox Business team, use the [`members_add()`](members_add) endpoint.
    MembersNotInTeam(Vec<String>),
    /// These users were not found in Dropbox.
    UsersNotFound(Vec<String>),
    /// A suspended user cannot be added to a group as
    /// [`GroupAccessType::Owner`](GroupAccessType::Owner).
    UserMustBeActiveToBeOwner,
    /// A company-managed group cannot be managed by a user.
    UserCannotBeManagerOfCompanyManagedGroup(Vec<String>),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersAddError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupMembersAddError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersAddError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupMembersAddError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupMembersAddError::SystemManagedGroupDisallowed,
                    "duplicate_user" => GroupMembersAddError::DuplicateUser,
                    "group_not_in_team" => GroupMembersAddError::GroupNotInTeam,
                    "members_not_in_team" => {
                        match map.next_key()? {
                            Some("members_not_in_team") => GroupMembersAddError::MembersNotInTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("members_not_in_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "users_not_found" => {
                        match map.next_key()? {
                            Some("users_not_found") => GroupMembersAddError::UsersNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("users_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_must_be_active_to_be_owner" => GroupMembersAddError::UserMustBeActiveToBeOwner,
                    "user_cannot_be_manager_of_company_managed_group" => {
                        match map.next_key()? {
                            Some("user_cannot_be_manager_of_company_managed_group") => GroupMembersAddError::UserCannotBeManagerOfCompanyManagedGroup(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_cannot_be_manager_of_company_managed_group")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GroupMembersAddError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "duplicate_user",
                                    "group_not_in_team",
                                    "members_not_in_team",
                                    "users_not_found",
                                    "user_must_be_active_to_be_owner",
                                    "user_cannot_be_manager_of_company_managed_group"];
        deserializer.deserialize_struct("GroupMembersAddError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersAddError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupMembersAddError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersAddError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupMembersAddError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersAddError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupMembersAddError::DuplicateUser => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersAddError", 1)?;
                s.serialize_field(".tag", "duplicate_user")?;
                s.end()
            }
            GroupMembersAddError::GroupNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersAddError", 1)?;
                s.serialize_field(".tag", "group_not_in_team")?;
                s.end()
            }
            GroupMembersAddError::MembersNotInTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupMembersAddError", 2)?;
                s.serialize_field(".tag", "members_not_in_team")?;
                s.serialize_field("members_not_in_team", x)?;
                s.end()
            }
            GroupMembersAddError::UsersNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupMembersAddError", 2)?;
                s.serialize_field(".tag", "users_not_found")?;
                s.serialize_field("users_not_found", x)?;
                s.end()
            }
            GroupMembersAddError::UserMustBeActiveToBeOwner => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersAddError", 1)?;
                s.serialize_field(".tag", "user_must_be_active_to_be_owner")?;
                s.end()
            }
            GroupMembersAddError::UserCannotBeManagerOfCompanyManagedGroup(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupMembersAddError", 2)?;
                s.serialize_field(".tag", "user_cannot_be_manager_of_company_managed_group")?;
                s.serialize_field("user_cannot_be_manager_of_company_managed_group", x)?;
                s.end()
            }
            GroupMembersAddError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupMembersAddError {
}

impl ::std::fmt::Display for GroupMembersAddError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupMembersAddError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupMembersAddError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupMembersAddError::DuplicateUser => f.write_str("You cannot add duplicate users. One or more of the members you are trying to add is already a member of the group."),
            GroupMembersAddError::GroupNotInTeam => f.write_str("Group is not in this team. You cannot add members to a group that is outside of your team."),
            GroupMembersAddError::MembersNotInTeam(inner) => write!(f, "members_not_in_team: {:?}", inner),
            GroupMembersAddError::UsersNotFound(inner) => write!(f, "These users were not found in Dropbox: {:?}", inner),
            GroupMembersAddError::UserCannotBeManagerOfCompanyManagedGroup(inner) => write!(f, "A company-managed group cannot be managed by a user: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result returned by [`groups_members_add()`](groups_members_add) and
/// [`groups_members_remove()`](groups_members_remove).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembersChangeResult {
    /// The group info after member change operation has been performed.
    pub group_info: GroupFullInfo,
    /// For legacy purposes async_job_id will always return one space ' '. Formerly, it was an ID
    /// that was used to obtain the status of granting/revoking group-owned resources. It's no
    /// longer necessary because the async processing now happens automatically.
    pub async_job_id: super::dbx_async::AsyncJobId,
}

impl GroupMembersChangeResult {
    pub fn new(group_info: GroupFullInfo, async_job_id: super::dbx_async::AsyncJobId) -> Self {
        GroupMembersChangeResult {
            group_info,
            async_job_id,
        }
    }
}

const GROUP_MEMBERS_CHANGE_RESULT_FIELDS: &[&str] = &["group_info",
                                                      "async_job_id"];
impl GroupMembersChangeResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembersChangeResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembersChangeResult>, V::Error> {
        let mut field_group_info = None;
        let mut field_async_job_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group_info" => {
                    if field_group_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_info"));
                    }
                    field_group_info = Some(map.next_value()?);
                }
                "async_job_id" => {
                    if field_async_job_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("async_job_id"));
                    }
                    field_async_job_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembersChangeResult {
            group_info: field_group_info.ok_or_else(|| ::serde::de::Error::missing_field("group_info"))?,
            async_job_id: field_async_job_id.ok_or_else(|| ::serde::de::Error::missing_field("async_job_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group_info", &self.group_info)?;
        s.serialize_field("async_job_id", &self.async_job_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersChangeResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembersChangeResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersChangeResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembersChangeResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembersChangeResult", GROUP_MEMBERS_CHANGE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersChangeResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembersChangeResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembersRemoveArg {
    /// Group from which users will be removed.
    pub group: GroupSelector,
    /// List of users to be removed from the group.
    pub users: Vec<UserSelectorArg>,
    /// Whether to return the list of members in the group.  Note that the default value will cause
    /// all the group members  to be returned in the response. This may take a long time for large
    /// groups.
    pub return_members: bool,
}

impl GroupMembersRemoveArg {
    pub fn new(group: GroupSelector, users: Vec<UserSelectorArg>) -> Self {
        GroupMembersRemoveArg {
            group,
            users,
            return_members: true,
        }
    }

    pub fn with_return_members(mut self, value: bool) -> Self {
        self.return_members = value;
        self
    }
}

const GROUP_MEMBERS_REMOVE_ARG_FIELDS: &[&str] = &["group",
                                                   "users",
                                                   "return_members"];
impl GroupMembersRemoveArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembersRemoveArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembersRemoveArg>, V::Error> {
        let mut field_group = None;
        let mut field_users = None;
        let mut field_return_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "return_members" => {
                    if field_return_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("return_members"));
                    }
                    field_return_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembersRemoveArg {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            return_members: field_return_members.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("return_members", &self.return_members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersRemoveArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembersRemoveArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersRemoveArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembersRemoveArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembersRemoveArg", GROUP_MEMBERS_REMOVE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersRemoveArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembersRemoveArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupMembersRemoveError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// At least one of the specified users is not a member of the group.
    MemberNotInGroup,
    /// Group is not in this team. You cannot remove members from a group that is outside of your
    /// team.
    GroupNotInTeam,
    /// These members are not part of your team.
    MembersNotInTeam(Vec<String>),
    /// These users were not found in Dropbox.
    UsersNotFound(Vec<String>),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersRemoveError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupMembersRemoveError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersRemoveError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupMembersRemoveError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupMembersRemoveError::SystemManagedGroupDisallowed,
                    "member_not_in_group" => GroupMembersRemoveError::MemberNotInGroup,
                    "group_not_in_team" => GroupMembersRemoveError::GroupNotInTeam,
                    "members_not_in_team" => {
                        match map.next_key()? {
                            Some("members_not_in_team") => GroupMembersRemoveError::MembersNotInTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("members_not_in_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "users_not_found" => {
                        match map.next_key()? {
                            Some("users_not_found") => GroupMembersRemoveError::UsersNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("users_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GroupMembersRemoveError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "member_not_in_group",
                                    "group_not_in_team",
                                    "members_not_in_team",
                                    "users_not_found"];
        deserializer.deserialize_struct("GroupMembersRemoveError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersRemoveError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupMembersRemoveError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupMembersRemoveError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupMembersRemoveError::MemberNotInGroup => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 1)?;
                s.serialize_field(".tag", "member_not_in_group")?;
                s.end()
            }
            GroupMembersRemoveError::GroupNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 1)?;
                s.serialize_field(".tag", "group_not_in_team")?;
                s.end()
            }
            GroupMembersRemoveError::MembersNotInTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 2)?;
                s.serialize_field(".tag", "members_not_in_team")?;
                s.serialize_field("members_not_in_team", x)?;
                s.end()
            }
            GroupMembersRemoveError::UsersNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupMembersRemoveError", 2)?;
                s.serialize_field(".tag", "users_not_found")?;
                s.serialize_field("users_not_found", x)?;
                s.end()
            }
            GroupMembersRemoveError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupMembersRemoveError {
}

impl ::std::fmt::Display for GroupMembersRemoveError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupMembersRemoveError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupMembersRemoveError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupMembersRemoveError::MemberNotInGroup => f.write_str("At least one of the specified users is not a member of the group."),
            GroupMembersRemoveError::GroupNotInTeam => f.write_str("Group is not in this team. You cannot remove members from a group that is outside of your team."),
            GroupMembersRemoveError::MembersNotInTeam(inner) => write!(f, "These members are not part of your team: {:?}", inner),
            GroupMembersRemoveError::UsersNotFound(inner) => write!(f, "These users were not found in Dropbox: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Argument for selecting a group and a list of users.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembersSelector {
    /// Specify a group.
    pub group: GroupSelector,
    /// A list of users that are members of `group`.
    pub users: UsersSelectorArg,
}

impl GroupMembersSelector {
    pub fn new(group: GroupSelector, users: UsersSelectorArg) -> Self {
        GroupMembersSelector {
            group,
            users,
        }
    }
}

const GROUP_MEMBERS_SELECTOR_FIELDS: &[&str] = &["group",
                                                 "users"];
impl GroupMembersSelector {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembersSelector, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembersSelector>, V::Error> {
        let mut field_group = None;
        let mut field_users = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembersSelector {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("users", &self.users)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersSelector {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembersSelector;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersSelector struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembersSelector::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembersSelector", GROUP_MEMBERS_SELECTOR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersSelector {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembersSelector", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error that can be raised when [`GroupMembersSelector`](GroupMembersSelector) is used, and the
/// users are required to be members of the specified group.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupMembersSelectorError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// At least one of the specified users is not a member of the group.
    MemberNotInGroup,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersSelectorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupMembersSelectorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersSelectorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupMembersSelectorError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupMembersSelectorError::SystemManagedGroupDisallowed,
                    "member_not_in_group" => GroupMembersSelectorError::MemberNotInGroup,
                    _ => GroupMembersSelectorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "member_not_in_group"];
        deserializer.deserialize_struct("GroupMembersSelectorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersSelectorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupMembersSelectorError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersSelectorError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupMembersSelectorError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersSelectorError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupMembersSelectorError::MemberNotInGroup => {
                // unit
                let mut s = serializer.serialize_struct("GroupMembersSelectorError", 1)?;
                s.serialize_field(".tag", "member_not_in_group")?;
                s.end()
            }
            GroupMembersSelectorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupMembersSelectorError {
}

impl ::std::fmt::Display for GroupMembersSelectorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupMembersSelectorError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupMembersSelectorError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupMembersSelectorError::MemberNotInGroup => f.write_str("At least one of the specified users is not a member of the group."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembersSetAccessTypeArg {
    /// Specify a group.
    pub group: GroupSelector,
    /// Identity of a user that is a member of `group`.
    pub user: UserSelectorArg,
    /// New group access type the user will have.
    pub access_type: GroupAccessType,
    /// Whether to return the list of members in the group.  Note that the default value will cause
    /// all the group members  to be returned in the response. This may take a long time for large
    /// groups.
    pub return_members: bool,
}

impl GroupMembersSetAccessTypeArg {
    pub fn new(group: GroupSelector, user: UserSelectorArg, access_type: GroupAccessType) -> Self {
        GroupMembersSetAccessTypeArg {
            group,
            user,
            access_type,
            return_members: true,
        }
    }

    pub fn with_return_members(mut self, value: bool) -> Self {
        self.return_members = value;
        self
    }
}

const GROUP_MEMBERS_SET_ACCESS_TYPE_ARG_FIELDS: &[&str] = &["group",
                                                            "user",
                                                            "access_type",
                                                            "return_members"];
impl GroupMembersSetAccessTypeArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembersSetAccessTypeArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembersSetAccessTypeArg>, V::Error> {
        let mut field_group = None;
        let mut field_user = None;
        let mut field_access_type = None;
        let mut field_return_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "return_members" => {
                    if field_return_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("return_members"));
                    }
                    field_return_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembersSetAccessTypeArg {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            return_members: field_return_members.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("return_members", &self.return_members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembersSetAccessTypeArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembersSetAccessTypeArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembersSetAccessTypeArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembersSetAccessTypeArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembersSetAccessTypeArg", GROUP_MEMBERS_SET_ACCESS_TYPE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembersSetAccessTypeArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembersSetAccessTypeArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Argument for selecting a single group, either by group_id or by external group ID.
#[derive(Debug, Clone, PartialEq)]
pub enum GroupSelector {
    /// Group ID.
    GroupId(super::team_common::GroupId),
    /// External ID of the group.
    GroupExternalId(super::team_common::GroupExternalId),
}

impl<'de> ::serde::de::Deserialize<'de> for GroupSelector {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupSelector;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupSelector structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_id" => {
                        match map.next_key()? {
                            Some("group_id") => GroupSelector::GroupId(map.next_value()?),
                            None => return Err(de::Error::missing_field("group_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "group_external_id" => {
                        match map.next_key()? {
                            Some("group_external_id") => GroupSelector::GroupExternalId(map.next_value()?),
                            None => return Err(de::Error::missing_field("group_external_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_id",
                                    "group_external_id"];
        deserializer.deserialize_struct("GroupSelector", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupSelector {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupSelector::GroupId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupSelector", 2)?;
                s.serialize_field(".tag", "group_id")?;
                s.serialize_field("group_id", x)?;
                s.end()
            }
            GroupSelector::GroupExternalId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupSelector", 2)?;
                s.serialize_field(".tag", "group_external_id")?;
                s.serialize_field("group_external_id", x)?;
                s.end()
            }
        }
    }
}

/// Error that can be raised when [`GroupSelector`](GroupSelector) is used.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupSelectorError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupSelectorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupSelectorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupSelectorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupSelectorError::GroupNotFound,
                    _ => GroupSelectorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other"];
        deserializer.deserialize_struct("GroupSelectorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupSelectorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupSelectorError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupSelectorError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupSelectorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupSelectorError {
}

impl ::std::fmt::Display for GroupSelectorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupSelectorError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Error that can be raised when [`GroupSelector`](GroupSelector) is used and team groups are
/// disallowed from being used.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupSelectorWithTeamGroupError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupSelectorWithTeamGroupError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupSelectorWithTeamGroupError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupSelectorWithTeamGroupError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupSelectorWithTeamGroupError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupSelectorWithTeamGroupError::SystemManagedGroupDisallowed,
                    _ => GroupSelectorWithTeamGroupError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed"];
        deserializer.deserialize_struct("GroupSelectorWithTeamGroupError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupSelectorWithTeamGroupError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupSelectorWithTeamGroupError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupSelectorWithTeamGroupError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupSelectorWithTeamGroupError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupSelectorWithTeamGroupError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupSelectorWithTeamGroupError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupSelectorWithTeamGroupError {
}

impl ::std::fmt::Display for GroupSelectorWithTeamGroupError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupSelectorWithTeamGroupError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupSelectorWithTeamGroupError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupUpdateArgs {
    /// Specify a group.
    pub group: GroupSelector,
    /// Whether to return the list of members in the group.  Note that the default value will cause
    /// all the group members  to be returned in the response. This may take a long time for large
    /// groups.
    pub return_members: bool,
    /// Optional argument. Set group name to this if provided.
    pub new_group_name: Option<String>,
    /// Optional argument. New group external ID. If the argument is None, the group's external_id
    /// won't be updated. If the argument is empty string, the group's external id will be cleared.
    pub new_group_external_id: Option<super::team_common::GroupExternalId>,
    /// Set new group management type, if provided.
    pub new_group_management_type: Option<super::team_common::GroupManagementType>,
}

impl GroupUpdateArgs {
    pub fn new(group: GroupSelector) -> Self {
        GroupUpdateArgs {
            group,
            return_members: true,
            new_group_name: None,
            new_group_external_id: None,
            new_group_management_type: None,
        }
    }

    pub fn with_return_members(mut self, value: bool) -> Self {
        self.return_members = value;
        self
    }

    pub fn with_new_group_name(mut self, value: String) -> Self {
        self.new_group_name = Some(value);
        self
    }

    pub fn with_new_group_external_id(
        mut self,
        value: super::team_common::GroupExternalId,
    ) -> Self {
        self.new_group_external_id = Some(value);
        self
    }

    pub fn with_new_group_management_type(
        mut self,
        value: super::team_common::GroupManagementType,
    ) -> Self {
        self.new_group_management_type = Some(value);
        self
    }
}

const GROUP_UPDATE_ARGS_FIELDS: &[&str] = &["group",
                                            "return_members",
                                            "new_group_name",
                                            "new_group_external_id",
                                            "new_group_management_type"];
impl GroupUpdateArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupUpdateArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupUpdateArgs>, V::Error> {
        let mut field_group = None;
        let mut field_return_members = None;
        let mut field_new_group_name = None;
        let mut field_new_group_external_id = None;
        let mut field_new_group_management_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "return_members" => {
                    if field_return_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("return_members"));
                    }
                    field_return_members = Some(map.next_value()?);
                }
                "new_group_name" => {
                    if field_new_group_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_group_name"));
                    }
                    field_new_group_name = Some(map.next_value()?);
                }
                "new_group_external_id" => {
                    if field_new_group_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_group_external_id"));
                    }
                    field_new_group_external_id = Some(map.next_value()?);
                }
                "new_group_management_type" => {
                    if field_new_group_management_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_group_management_type"));
                    }
                    field_new_group_management_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupUpdateArgs {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            return_members: field_return_members.unwrap_or(true),
            new_group_name: field_new_group_name,
            new_group_external_id: field_new_group_external_id,
            new_group_management_type: field_new_group_management_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("return_members", &self.return_members)?;
        if let Some(val) = &self.new_group_name {
            s.serialize_field("new_group_name", val)?;
        }
        if let Some(val) = &self.new_group_external_id {
            s.serialize_field("new_group_external_id", val)?;
        }
        if let Some(val) = &self.new_group_management_type {
            s.serialize_field("new_group_management_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupUpdateArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupUpdateArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupUpdateArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupUpdateArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupUpdateArgs", GROUP_UPDATE_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupUpdateArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupUpdateArgs", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupUpdateError {
    /// No matching group found. No groups match the specified group ID.
    GroupNotFound,
    /// This operation is not supported on system-managed groups.
    SystemManagedGroupDisallowed,
    /// The requested group name is already being used by another group.
    GroupNameAlreadyUsed,
    /// Group name is empty or has invalid characters.
    GroupNameInvalid,
    /// The requested external ID is already being used by another group.
    ExternalIdAlreadyInUse,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupUpdateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupUpdateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupUpdateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_found" => GroupUpdateError::GroupNotFound,
                    "system_managed_group_disallowed" => GroupUpdateError::SystemManagedGroupDisallowed,
                    "group_name_already_used" => GroupUpdateError::GroupNameAlreadyUsed,
                    "group_name_invalid" => GroupUpdateError::GroupNameInvalid,
                    "external_id_already_in_use" => GroupUpdateError::ExternalIdAlreadyInUse,
                    _ => GroupUpdateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_found",
                                    "other",
                                    "system_managed_group_disallowed",
                                    "group_name_already_used",
                                    "group_name_invalid",
                                    "external_id_already_in_use"];
        deserializer.deserialize_struct("GroupUpdateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupUpdateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupUpdateError::GroupNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GroupUpdateError", 1)?;
                s.serialize_field(".tag", "group_not_found")?;
                s.end()
            }
            GroupUpdateError::SystemManagedGroupDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("GroupUpdateError", 1)?;
                s.serialize_field(".tag", "system_managed_group_disallowed")?;
                s.end()
            }
            GroupUpdateError::GroupNameAlreadyUsed => {
                // unit
                let mut s = serializer.serialize_struct("GroupUpdateError", 1)?;
                s.serialize_field(".tag", "group_name_already_used")?;
                s.end()
            }
            GroupUpdateError::GroupNameInvalid => {
                // unit
                let mut s = serializer.serialize_struct("GroupUpdateError", 1)?;
                s.serialize_field(".tag", "group_name_invalid")?;
                s.end()
            }
            GroupUpdateError::ExternalIdAlreadyInUse => {
                // unit
                let mut s = serializer.serialize_struct("GroupUpdateError", 1)?;
                s.serialize_field(".tag", "external_id_already_in_use")?;
                s.end()
            }
            GroupUpdateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupUpdateError {
}

impl ::std::fmt::Display for GroupUpdateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupUpdateError::GroupNotFound => f.write_str("No matching group found. No groups match the specified group ID."),
            GroupUpdateError::SystemManagedGroupDisallowed => f.write_str("This operation is not supported on system-managed groups."),
            GroupUpdateError::GroupNameAlreadyUsed => f.write_str("The requested group name is already being used by another group."),
            GroupUpdateError::GroupNameInvalid => f.write_str("Group name is empty or has invalid characters."),
            GroupUpdateError::ExternalIdAlreadyInUse => f.write_str("The requested external ID is already being used by another group."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupsGetInfoError {
    /// The group is not on your team.
    GroupNotOnTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsGetInfoError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsGetInfoError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsGetInfoError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_not_on_team" => GroupsGetInfoError::GroupNotOnTeam,
                    _ => GroupsGetInfoError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_not_on_team",
                                    "other"];
        deserializer.deserialize_struct("GroupsGetInfoError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsGetInfoError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsGetInfoError::GroupNotOnTeam => {
                // unit
                let mut s = serializer.serialize_struct("GroupsGetInfoError", 1)?;
                s.serialize_field(".tag", "group_not_on_team")?;
                s.end()
            }
            GroupsGetInfoError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupsGetInfoError {
}

impl ::std::fmt::Display for GroupsGetInfoError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupsGetInfoError::GroupNotOnTeam => f.write_str("The group is not on your team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum GroupsGetInfoItem {
    /// An ID that was provided as a parameter to [`groups_get_info()`](groups_get_info), and did
    /// not match a corresponding group. The ID can be a group ID, or an external ID, depending on
    /// how the method was called.
    IdNotFound(String),
    /// Info about a group.
    GroupInfo(GroupFullInfo),
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsGetInfoItem {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsGetInfoItem;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsGetInfoItem structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "id_not_found" => {
                        match map.next_key()? {
                            Some("id_not_found") => GroupsGetInfoItem::IdNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("id_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "group_info" => GroupsGetInfoItem::GroupInfo(GroupFullInfo::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["id_not_found",
                                    "group_info"];
        deserializer.deserialize_struct("GroupsGetInfoItem", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsGetInfoItem {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsGetInfoItem::IdNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupsGetInfoItem", 2)?;
                s.serialize_field(".tag", "id_not_found")?;
                s.serialize_field("id_not_found", x)?;
                s.end()
            }
            GroupsGetInfoItem::GroupInfo(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("GroupsGetInfoItem", 8)?;
                s.serialize_field(".tag", "group_info")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsListArg {
    /// Number of results to return per call.
    pub limit: u32,
}

impl Default for GroupsListArg {
    fn default() -> Self {
        GroupsListArg {
            limit: 1000,
        }
    }
}

impl GroupsListArg {
    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const GROUPS_LIST_ARG_FIELDS: &[&str] = &["limit"];
impl GroupsListArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<GroupsListArg, V::Error> {
        let mut field_limit = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = GroupsListArg {
            limit: field_limit.unwrap_or(1000),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsListArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsListArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsListArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsListArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsListArg", GROUPS_LIST_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsListArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsListArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsListContinueArg {
    /// Indicates from what point to get the next set of groups.
    pub cursor: String,
}

impl GroupsListContinueArg {
    pub fn new(cursor: String) -> Self {
        GroupsListContinueArg {
            cursor,
        }
    }
}

const GROUPS_LIST_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl GroupsListContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupsListContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupsListContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupsListContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsListContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsListContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsListContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsListContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsListContinueArg", GROUPS_LIST_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsListContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsListContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupsListContinueError {
    /// The cursor is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsListContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsListContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsListContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_cursor" => GroupsListContinueError::InvalidCursor,
                    _ => GroupsListContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("GroupsListContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsListContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsListContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("GroupsListContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            GroupsListContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupsListContinueError {
}

impl ::std::fmt::Display for GroupsListContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupsListContinueError::InvalidCursor => f.write_str("The cursor is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsListResult {
    pub groups: Vec<super::team_common::GroupSummary>,
    /// Pass the cursor into [`groups_list_continue()`](groups_list_continue) to obtain the
    /// additional groups.
    pub cursor: String,
    /// Is true if there are additional groups that have not been returned yet. An additional call
    /// to [`groups_list_continue()`](groups_list_continue) can retrieve them.
    pub has_more: bool,
}

impl GroupsListResult {
    pub fn new(
        groups: Vec<super::team_common::GroupSummary>,
        cursor: String,
        has_more: bool,
    ) -> Self {
        GroupsListResult {
            groups,
            cursor,
            has_more,
        }
    }
}

const GROUPS_LIST_RESULT_FIELDS: &[&str] = &["groups",
                                             "cursor",
                                             "has_more"];
impl GroupsListResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupsListResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupsListResult>, V::Error> {
        let mut field_groups = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "groups" => {
                    if field_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("groups"));
                    }
                    field_groups = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupsListResult {
            groups: field_groups.ok_or_else(|| ::serde::de::Error::missing_field("groups"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("groups", &self.groups)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsListResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsListResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsListResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsListResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsListResult", GROUPS_LIST_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsListResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsListResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsMembersListArg {
    /// The group whose members are to be listed.
    pub group: GroupSelector,
    /// Number of results to return per call.
    pub limit: u32,
}

impl GroupsMembersListArg {
    pub fn new(group: GroupSelector) -> Self {
        GroupsMembersListArg {
            group,
            limit: 1000,
        }
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const GROUPS_MEMBERS_LIST_ARG_FIELDS: &[&str] = &["group",
                                                  "limit"];
impl GroupsMembersListArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupsMembersListArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupsMembersListArg>, V::Error> {
        let mut field_group = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupsMembersListArg {
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            limit: field_limit.unwrap_or(1000),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsMembersListArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsMembersListArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsMembersListArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsMembersListArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsMembersListArg", GROUPS_MEMBERS_LIST_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsMembersListArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsMembersListArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsMembersListContinueArg {
    /// Indicates from what point to get the next set of groups.
    pub cursor: String,
}

impl GroupsMembersListContinueArg {
    pub fn new(cursor: String) -> Self {
        GroupsMembersListContinueArg {
            cursor,
        }
    }
}

const GROUPS_MEMBERS_LIST_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl GroupsMembersListContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupsMembersListContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupsMembersListContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupsMembersListContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsMembersListContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsMembersListContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsMembersListContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsMembersListContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsMembersListContinueArg", GROUPS_MEMBERS_LIST_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsMembersListContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsMembersListContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupsMembersListContinueError {
    /// The cursor is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsMembersListContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsMembersListContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsMembersListContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_cursor" => GroupsMembersListContinueError::InvalidCursor,
                    _ => GroupsMembersListContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("GroupsMembersListContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsMembersListContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsMembersListContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("GroupsMembersListContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            GroupsMembersListContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupsMembersListContinueError {
}

impl ::std::fmt::Display for GroupsMembersListContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupsMembersListContinueError::InvalidCursor => f.write_str("The cursor is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupsMembersListResult {
    pub members: Vec<GroupMemberInfo>,
    /// Pass the cursor into [`groups_members_list_continue()`](groups_members_list_continue) to
    /// obtain additional group members.
    pub cursor: String,
    /// Is true if there are additional group members that have not been returned yet. An additional
    /// call to [`groups_members_list_continue()`](groups_members_list_continue) can retrieve them.
    pub has_more: bool,
}

impl GroupsMembersListResult {
    pub fn new(members: Vec<GroupMemberInfo>, cursor: String, has_more: bool) -> Self {
        GroupsMembersListResult {
            members,
            cursor,
            has_more,
        }
    }
}

const GROUPS_MEMBERS_LIST_RESULT_FIELDS: &[&str] = &["members",
                                                     "cursor",
                                                     "has_more"];
impl GroupsMembersListResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupsMembersListResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupsMembersListResult>, V::Error> {
        let mut field_members = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupsMembersListResult {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsMembersListResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupsMembersListResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsMembersListResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupsMembersListResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupsMembersListResult", GROUPS_MEMBERS_LIST_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsMembersListResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupsMembersListResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GroupsPollError {
    /// The job ID is invalid.
    InvalidAsyncJobId,
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// You are not allowed to poll this job.
    AccessDenied,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsPollError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsPollError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsPollError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_async_job_id" => GroupsPollError::InvalidAsyncJobId,
                    "internal_error" => GroupsPollError::InternalError,
                    "access_denied" => GroupsPollError::AccessDenied,
                    _ => GroupsPollError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_async_job_id",
                                    "internal_error",
                                    "other",
                                    "access_denied"];
        deserializer.deserialize_struct("GroupsPollError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsPollError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsPollError::InvalidAsyncJobId => {
                // unit
                let mut s = serializer.serialize_struct("GroupsPollError", 1)?;
                s.serialize_field(".tag", "invalid_async_job_id")?;
                s.end()
            }
            GroupsPollError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("GroupsPollError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            GroupsPollError::AccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("GroupsPollError", 1)?;
                s.serialize_field(".tag", "access_denied")?;
                s.end()
            }
            GroupsPollError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GroupsPollError {
}

impl ::std::fmt::Display for GroupsPollError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GroupsPollError::InvalidAsyncJobId => f.write_str("The job ID is invalid."),
            GroupsPollError::InternalError => f.write_str("Something went wrong with the job on Dropbox's end. You'll need to verify that the action you were taking succeeded, and if not, try again. This should happen very rarely."),
            GroupsPollError::AccessDenied => f.write_str("You are not allowed to poll this job."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Argument for selecting a list of groups, either by group_ids, or external group IDs.
#[derive(Debug, Clone, PartialEq)]
pub enum GroupsSelector {
    /// List of group IDs.
    GroupIds(Vec<super::team_common::GroupId>),
    /// List of external IDs of groups.
    GroupExternalIds(Vec<String>),
}

impl<'de> ::serde::de::Deserialize<'de> for GroupsSelector {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupsSelector;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupsSelector structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "group_ids" => {
                        match map.next_key()? {
                            Some("group_ids") => GroupsSelector::GroupIds(map.next_value()?),
                            None => return Err(de::Error::missing_field("group_ids")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "group_external_ids" => {
                        match map.next_key()? {
                            Some("group_external_ids") => GroupsSelector::GroupExternalIds(map.next_value()?),
                            None => return Err(de::Error::missing_field("group_external_ids")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["group_ids",
                                    "group_external_ids"];
        deserializer.deserialize_struct("GroupsSelector", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupsSelector {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupsSelector::GroupIds(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupsSelector", 2)?;
                s.serialize_field(".tag", "group_ids")?;
                s.serialize_field("group_ids", x)?;
                s.end()
            }
            GroupsSelector::GroupExternalIds(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GroupsSelector", 2)?;
                s.serialize_field(".tag", "group_external_ids")?;
                s.serialize_field("group_external_ids", x)?;
                s.end()
            }
        }
    }
}

/// The value for [`Feature::HasTeamFileEvents`](Feature::HasTeamFileEvents).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum HasTeamFileEventsValue {
    /// Does this team have file events.
    Enabled(bool),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for HasTeamFileEventsValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = HasTeamFileEventsValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a HasTeamFileEventsValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "enabled" => {
                        match map.next_key()? {
                            Some("enabled") => HasTeamFileEventsValue::Enabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("enabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => HasTeamFileEventsValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["enabled",
                                    "other"];
        deserializer.deserialize_struct("HasTeamFileEventsValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for HasTeamFileEventsValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            HasTeamFileEventsValue::Enabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("HasTeamFileEventsValue", 2)?;
                s.serialize_field(".tag", "enabled")?;
                s.serialize_field("enabled", x)?;
                s.end()
            }
            HasTeamFileEventsValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The value for [`Feature::HasTeamSelectiveSync`](Feature::HasTeamSelectiveSync).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum HasTeamSelectiveSyncValue {
    /// Does this team have team selective sync enabled.
    HasTeamSelectiveSync(bool),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for HasTeamSelectiveSyncValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = HasTeamSelectiveSyncValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a HasTeamSelectiveSyncValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "has_team_selective_sync" => {
                        match map.next_key()? {
                            Some("has_team_selective_sync") => HasTeamSelectiveSyncValue::HasTeamSelectiveSync(map.next_value()?),
                            None => return Err(de::Error::missing_field("has_team_selective_sync")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => HasTeamSelectiveSyncValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["has_team_selective_sync",
                                    "other"];
        deserializer.deserialize_struct("HasTeamSelectiveSyncValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for HasTeamSelectiveSyncValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            HasTeamSelectiveSyncValue::HasTeamSelectiveSync(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("HasTeamSelectiveSyncValue", 2)?;
                s.serialize_field(".tag", "has_team_selective_sync")?;
                s.serialize_field("has_team_selective_sync", x)?;
                s.end()
            }
            HasTeamSelectiveSyncValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The value for [`Feature::HasTeamSharedDropbox`](Feature::HasTeamSharedDropbox).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum HasTeamSharedDropboxValue {
    /// Does this team have a shared team root.
    HasTeamSharedDropbox(bool),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for HasTeamSharedDropboxValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = HasTeamSharedDropboxValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a HasTeamSharedDropboxValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "has_team_shared_dropbox" => {
                        match map.next_key()? {
                            Some("has_team_shared_dropbox") => HasTeamSharedDropboxValue::HasTeamSharedDropbox(map.next_value()?),
                            None => return Err(de::Error::missing_field("has_team_shared_dropbox")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => HasTeamSharedDropboxValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["has_team_shared_dropbox",
                                    "other"];
        deserializer.deserialize_struct("HasTeamSharedDropboxValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for HasTeamSharedDropboxValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            HasTeamSharedDropboxValue::HasTeamSharedDropbox(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("HasTeamSharedDropboxValue", 2)?;
                s.serialize_field(".tag", "has_team_shared_dropbox")?;
                s.serialize_field("has_team_shared_dropbox", x)?;
                s.end()
            }
            HasTeamSharedDropboxValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct IncludeMembersArg {
    /// Whether to return the list of members in the group.  Note that the default value will cause
    /// all the group members  to be returned in the response. This may take a long time for large
    /// groups.
    pub return_members: bool,
}

impl Default for IncludeMembersArg {
    fn default() -> Self {
        IncludeMembersArg {
            return_members: true,
        }
    }
}

impl IncludeMembersArg {
    pub fn with_return_members(mut self, value: bool) -> Self {
        self.return_members = value;
        self
    }
}

const INCLUDE_MEMBERS_ARG_FIELDS: &[&str] = &["return_members"];
impl IncludeMembersArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<IncludeMembersArg, V::Error> {
        let mut field_return_members = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "return_members" => {
                    if field_return_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("return_members"));
                    }
                    field_return_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = IncludeMembersArg {
            return_members: field_return_members.unwrap_or(true),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("return_members", &self.return_members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for IncludeMembersArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = IncludeMembersArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a IncludeMembersArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                IncludeMembersArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("IncludeMembersArg", INCLUDE_MEMBERS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for IncludeMembersArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("IncludeMembersArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldHeldRevisionMetadata {
    /// The held revision filename.
    pub new_filename: String,
    /// The id of the held revision.
    pub original_revision_id: super::files::Rev,
    /// The original path of the held revision.
    pub original_file_path: Path,
    /// The last time the file was modified on Dropbox.
    pub server_modified: super::common::DropboxTimestamp,
    /// The member id of the revision's author.
    pub author_member_id: super::team_common::TeamMemberId,
    /// The member status of the revision's author.
    pub author_member_status: TeamMemberStatus,
    /// The email address of the held revision author.
    pub author_email: super::common::EmailAddress,
    /// The type of the held revision's file.
    pub file_type: String,
    /// The file size in bytes.
    pub size: u64,
    /// A hash of the file content. This field can be used to verify data integrity. For more
    /// information see our [Content
    /// hash](https://www.dropbox.com/developers/reference/content-hash) page.
    pub content_hash: super::files::Sha256HexHash,
}

impl LegalHoldHeldRevisionMetadata {
    pub fn new(
        new_filename: String,
        original_revision_id: super::files::Rev,
        original_file_path: Path,
        server_modified: super::common::DropboxTimestamp,
        author_member_id: super::team_common::TeamMemberId,
        author_member_status: TeamMemberStatus,
        author_email: super::common::EmailAddress,
        file_type: String,
        size: u64,
        content_hash: super::files::Sha256HexHash,
    ) -> Self {
        LegalHoldHeldRevisionMetadata {
            new_filename,
            original_revision_id,
            original_file_path,
            server_modified,
            author_member_id,
            author_member_status,
            author_email,
            file_type,
            size,
            content_hash,
        }
    }
}

const LEGAL_HOLD_HELD_REVISION_METADATA_FIELDS: &[&str] = &["new_filename",
                                                            "original_revision_id",
                                                            "original_file_path",
                                                            "server_modified",
                                                            "author_member_id",
                                                            "author_member_status",
                                                            "author_email",
                                                            "file_type",
                                                            "size",
                                                            "content_hash"];
impl LegalHoldHeldRevisionMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldHeldRevisionMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldHeldRevisionMetadata>, V::Error> {
        let mut field_new_filename = None;
        let mut field_original_revision_id = None;
        let mut field_original_file_path = None;
        let mut field_server_modified = None;
        let mut field_author_member_id = None;
        let mut field_author_member_status = None;
        let mut field_author_email = None;
        let mut field_file_type = None;
        let mut field_size = None;
        let mut field_content_hash = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_filename" => {
                    if field_new_filename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_filename"));
                    }
                    field_new_filename = Some(map.next_value()?);
                }
                "original_revision_id" => {
                    if field_original_revision_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("original_revision_id"));
                    }
                    field_original_revision_id = Some(map.next_value()?);
                }
                "original_file_path" => {
                    if field_original_file_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("original_file_path"));
                    }
                    field_original_file_path = Some(map.next_value()?);
                }
                "server_modified" => {
                    if field_server_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("server_modified"));
                    }
                    field_server_modified = Some(map.next_value()?);
                }
                "author_member_id" => {
                    if field_author_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("author_member_id"));
                    }
                    field_author_member_id = Some(map.next_value()?);
                }
                "author_member_status" => {
                    if field_author_member_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("author_member_status"));
                    }
                    field_author_member_status = Some(map.next_value()?);
                }
                "author_email" => {
                    if field_author_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("author_email"));
                    }
                    field_author_email = Some(map.next_value()?);
                }
                "file_type" => {
                    if field_file_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_type"));
                    }
                    field_file_type = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "content_hash" => {
                    if field_content_hash.is_some() {
                        return Err(::serde::de::Error::duplicate_field("content_hash"));
                    }
                    field_content_hash = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldHeldRevisionMetadata {
            new_filename: field_new_filename.ok_or_else(|| ::serde::de::Error::missing_field("new_filename"))?,
            original_revision_id: field_original_revision_id.ok_or_else(|| ::serde::de::Error::missing_field("original_revision_id"))?,
            original_file_path: field_original_file_path.ok_or_else(|| ::serde::de::Error::missing_field("original_file_path"))?,
            server_modified: field_server_modified.ok_or_else(|| ::serde::de::Error::missing_field("server_modified"))?,
            author_member_id: field_author_member_id.ok_or_else(|| ::serde::de::Error::missing_field("author_member_id"))?,
            author_member_status: field_author_member_status.ok_or_else(|| ::serde::de::Error::missing_field("author_member_status"))?,
            author_email: field_author_email.ok_or_else(|| ::serde::de::Error::missing_field("author_email"))?,
            file_type: field_file_type.ok_or_else(|| ::serde::de::Error::missing_field("file_type"))?,
            size: field_size.ok_or_else(|| ::serde::de::Error::missing_field("size"))?,
            content_hash: field_content_hash.ok_or_else(|| ::serde::de::Error::missing_field("content_hash"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_filename", &self.new_filename)?;
        s.serialize_field("original_revision_id", &self.original_revision_id)?;
        s.serialize_field("original_file_path", &self.original_file_path)?;
        s.serialize_field("server_modified", &self.server_modified)?;
        s.serialize_field("author_member_id", &self.author_member_id)?;
        s.serialize_field("author_member_status", &self.author_member_status)?;
        s.serialize_field("author_email", &self.author_email)?;
        s.serialize_field("file_type", &self.file_type)?;
        s.serialize_field("size", &self.size)?;
        s.serialize_field("content_hash", &self.content_hash)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldHeldRevisionMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldHeldRevisionMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldHeldRevisionMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldHeldRevisionMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldHeldRevisionMetadata", LEGAL_HOLD_HELD_REVISION_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldHeldRevisionMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldHeldRevisionMetadata", 10)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldPolicy {
    /// The legal hold id.
    pub id: LegalHoldId,
    /// Policy name.
    pub name: LegalHoldPolicyName,
    /// Team members IDs and number of permanently deleted members under hold.
    pub members: MembersInfo,
    /// The current state of the hold.
    pub status: LegalHoldStatus,
    /// Start date of the legal hold policy.
    pub start_date: super::common::DropboxTimestamp,
    /// A description of the legal hold policy.
    pub description: Option<LegalHoldPolicyDescription>,
    /// The time at which the legal hold was activated.
    pub activation_time: Option<super::common::DropboxTimestamp>,
    /// End date of the legal hold policy.
    pub end_date: Option<super::common::DropboxTimestamp>,
}

impl LegalHoldPolicy {
    pub fn new(
        id: LegalHoldId,
        name: LegalHoldPolicyName,
        members: MembersInfo,
        status: LegalHoldStatus,
        start_date: super::common::DropboxTimestamp,
    ) -> Self {
        LegalHoldPolicy {
            id,
            name,
            members,
            status,
            start_date,
            description: None,
            activation_time: None,
            end_date: None,
        }
    }

    pub fn with_description(mut self, value: LegalHoldPolicyDescription) -> Self {
        self.description = Some(value);
        self
    }

    pub fn with_activation_time(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.activation_time = Some(value);
        self
    }

    pub fn with_end_date(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.end_date = Some(value);
        self
    }
}

const LEGAL_HOLD_POLICY_FIELDS: &[&str] = &["id",
                                            "name",
                                            "members",
                                            "status",
                                            "start_date",
                                            "description",
                                            "activation_time",
                                            "end_date"];
impl LegalHoldPolicy {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldPolicy, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldPolicy>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut field_members = None;
        let mut field_status = None;
        let mut field_start_date = None;
        let mut field_description = None;
        let mut field_activation_time = None;
        let mut field_end_date = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "status" => {
                    if field_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("status"));
                    }
                    field_status = Some(map.next_value()?);
                }
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                "activation_time" => {
                    if field_activation_time.is_some() {
                        return Err(::serde::de::Error::duplicate_field("activation_time"));
                    }
                    field_activation_time = Some(map.next_value()?);
                }
                "end_date" => {
                    if field_end_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("end_date"));
                    }
                    field_end_date = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldPolicy {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            status: field_status.ok_or_else(|| ::serde::de::Error::missing_field("status"))?,
            start_date: field_start_date.ok_or_else(|| ::serde::de::Error::missing_field("start_date"))?,
            description: field_description,
            activation_time: field_activation_time,
            end_date: field_end_date,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("status", &self.status)?;
        s.serialize_field("start_date", &self.start_date)?;
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        if let Some(val) = &self.activation_time {
            s.serialize_field("activation_time", val)?;
        }
        if let Some(val) = &self.end_date {
            s.serialize_field("end_date", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldPolicy struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldPolicy::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldPolicy", LEGAL_HOLD_POLICY_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldPolicy", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldStatus {
    /// The legal hold policy is active.
    Active,
    /// The legal hold policy was released.
    Released,
    /// The legal hold policy is activating.
    Activating,
    /// The legal hold policy is updating.
    Updating,
    /// The legal hold policy is exporting.
    Exporting,
    /// The legal hold policy is releasing.
    Releasing,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "active" => LegalHoldStatus::Active,
                    "released" => LegalHoldStatus::Released,
                    "activating" => LegalHoldStatus::Activating,
                    "updating" => LegalHoldStatus::Updating,
                    "exporting" => LegalHoldStatus::Exporting,
                    "releasing" => LegalHoldStatus::Releasing,
                    _ => LegalHoldStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["active",
                                    "released",
                                    "activating",
                                    "updating",
                                    "exporting",
                                    "releasing",
                                    "other"];
        deserializer.deserialize_struct("LegalHoldStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldStatus::Active => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "active")?;
                s.end()
            }
            LegalHoldStatus::Released => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "released")?;
                s.end()
            }
            LegalHoldStatus::Activating => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "activating")?;
                s.end()
            }
            LegalHoldStatus::Updating => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "updating")?;
                s.end()
            }
            LegalHoldStatus::Exporting => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "exporting")?;
                s.end()
            }
            LegalHoldStatus::Releasing => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldStatus", 1)?;
                s.serialize_field(".tag", "releasing")?;
                s.end()
            }
            LegalHoldStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsError::InsufficientPermissions,
                    _ => LegalHoldsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other"];
        deserializer.deserialize_struct("LegalHoldsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsError {
}

impl ::std::fmt::Display for LegalHoldsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsGetPolicyArg {
    /// The legal hold Id.
    pub id: LegalHoldId,
}

impl LegalHoldsGetPolicyArg {
    pub fn new(id: LegalHoldId) -> Self {
        LegalHoldsGetPolicyArg {
            id,
        }
    }
}

const LEGAL_HOLDS_GET_POLICY_ARG_FIELDS: &[&str] = &["id"];
impl LegalHoldsGetPolicyArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsGetPolicyArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsGetPolicyArg>, V::Error> {
        let mut field_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsGetPolicyArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsGetPolicyArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsGetPolicyArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsGetPolicyArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsGetPolicyArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsGetPolicyArg", LEGAL_HOLDS_GET_POLICY_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsGetPolicyArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsGetPolicyArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsGetPolicyError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Legal hold policy does not exist for [`LegalHoldsGetPolicyArg::id`](LegalHoldsGetPolicyArg).
    LegalHoldPolicyNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsGetPolicyError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsGetPolicyError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsGetPolicyError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsGetPolicyError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsGetPolicyError::InsufficientPermissions,
                    "legal_hold_policy_not_found" => LegalHoldsGetPolicyError::LegalHoldPolicyNotFound,
                    _ => LegalHoldsGetPolicyError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "legal_hold_policy_not_found"];
        deserializer.deserialize_struct("LegalHoldsGetPolicyError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsGetPolicyError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsGetPolicyError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsGetPolicyError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsGetPolicyError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsGetPolicyError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsGetPolicyError::LegalHoldPolicyNotFound => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsGetPolicyError", 1)?;
                s.serialize_field(".tag", "legal_hold_policy_not_found")?;
                s.end()
            }
            LegalHoldsGetPolicyError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsGetPolicyError {
}

impl ::std::fmt::Display for LegalHoldsGetPolicyError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsGetPolicyError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsGetPolicyError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsListHeldRevisionResult {
    /// List of file entries that under the hold.
    pub entries: Vec<LegalHoldHeldRevisionMetadata>,
    /// True if there are more file entries that haven't been returned. You can retrieve them with a
    /// call to /legal_holds/list_held_revisions_continue.
    pub has_more: bool,
    /// The cursor idicates where to continue reading file metadata entries for the next API call.
    /// When there are no more entries, the cursor will return none. Pass the cursor into
    /// /2/team/legal_holds/list_held_revisions/continue.
    pub cursor: Option<ListHeldRevisionCursor>,
}

impl LegalHoldsListHeldRevisionResult {
    pub fn new(entries: Vec<LegalHoldHeldRevisionMetadata>, has_more: bool) -> Self {
        LegalHoldsListHeldRevisionResult {
            entries,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: ListHeldRevisionCursor) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LEGAL_HOLDS_LIST_HELD_REVISION_RESULT_FIELDS: &[&str] = &["entries",
                                                                "has_more",
                                                                "cursor"];
impl LegalHoldsListHeldRevisionResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsListHeldRevisionResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsListHeldRevisionResult>, V::Error> {
        let mut field_entries = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsListHeldRevisionResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListHeldRevisionResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsListHeldRevisionResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListHeldRevisionResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsListHeldRevisionResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsListHeldRevisionResult", LEGAL_HOLDS_LIST_HELD_REVISION_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListHeldRevisionResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsListHeldRevisionsArg {
    /// The legal hold Id.
    pub id: LegalHoldId,
}

impl LegalHoldsListHeldRevisionsArg {
    pub fn new(id: LegalHoldId) -> Self {
        LegalHoldsListHeldRevisionsArg {
            id,
        }
    }
}

const LEGAL_HOLDS_LIST_HELD_REVISIONS_ARG_FIELDS: &[&str] = &["id"];
impl LegalHoldsListHeldRevisionsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsListHeldRevisionsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsListHeldRevisionsArg>, V::Error> {
        let mut field_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsListHeldRevisionsArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListHeldRevisionsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsListHeldRevisionsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListHeldRevisionsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsListHeldRevisionsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsListHeldRevisionsArg", LEGAL_HOLDS_LIST_HELD_REVISIONS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListHeldRevisionsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsListHeldRevisionsContinueArg {
    /// The legal hold Id.
    pub id: LegalHoldId,
    /// The cursor idicates where to continue reading file metadata entries for the next API call.
    /// When there are no more entries, the cursor will return none.
    pub cursor: Option<ListHeldRevisionCursor>,
}

impl LegalHoldsListHeldRevisionsContinueArg {
    pub fn new(id: LegalHoldId) -> Self {
        LegalHoldsListHeldRevisionsContinueArg {
            id,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: ListHeldRevisionCursor) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LEGAL_HOLDS_LIST_HELD_REVISIONS_CONTINUE_ARG_FIELDS: &[&str] = &["id",
                                                                       "cursor"];
impl LegalHoldsListHeldRevisionsContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsListHeldRevisionsContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsListHeldRevisionsContinueArg>, V::Error> {
        let mut field_id = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsListHeldRevisionsContinueArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListHeldRevisionsContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsListHeldRevisionsContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListHeldRevisionsContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsListHeldRevisionsContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsListHeldRevisionsContinueArg", LEGAL_HOLDS_LIST_HELD_REVISIONS_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListHeldRevisionsContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsContinueArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsListHeldRevisionsContinueError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// Temporary infrastructure failure, please retry.
    TransientError,
    /// Indicates that the cursor has been invalidated. Call
    /// [`legal_holds_list_held_revisions_continue()`](legal_holds_list_held_revisions_continue)
    /// again with an empty cursor to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListHeldRevisionsContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsListHeldRevisionsContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListHeldRevisionsContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsListHeldRevisionsContinueError::UnknownLegalHoldError,
                    "transient_error" => LegalHoldsListHeldRevisionsContinueError::TransientError,
                    "reset" => LegalHoldsListHeldRevisionsContinueError::Reset,
                    _ => LegalHoldsListHeldRevisionsContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "transient_error",
                                    "reset",
                                    "other"];
        deserializer.deserialize_struct("LegalHoldsListHeldRevisionsContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListHeldRevisionsContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsListHeldRevisionsContinueError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsContinueError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsContinueError::TransientError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsContinueError", 1)?;
                s.serialize_field(".tag", "transient_error")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsContinueError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsContinueError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsListHeldRevisionsContinueError {
}

impl ::std::fmt::Display for LegalHoldsListHeldRevisionsContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsListHeldRevisionsContinueError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsListHeldRevisionsContinueError::TransientError => f.write_str("Temporary infrastructure failure, please retry."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsListHeldRevisionsError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Temporary infrastructure failure, please retry.
    TransientError,
    /// The legal hold is not holding any revisions yet.
    LegalHoldStillEmpty,
    /// Trying to list revisions for an inactive legal hold.
    InactiveLegalHold,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListHeldRevisionsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsListHeldRevisionsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListHeldRevisionsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsListHeldRevisionsError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsListHeldRevisionsError::InsufficientPermissions,
                    "transient_error" => LegalHoldsListHeldRevisionsError::TransientError,
                    "legal_hold_still_empty" => LegalHoldsListHeldRevisionsError::LegalHoldStillEmpty,
                    "inactive_legal_hold" => LegalHoldsListHeldRevisionsError::InactiveLegalHold,
                    _ => LegalHoldsListHeldRevisionsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "transient_error",
                                    "legal_hold_still_empty",
                                    "inactive_legal_hold"];
        deserializer.deserialize_struct("LegalHoldsListHeldRevisionsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListHeldRevisionsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsListHeldRevisionsError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsError::TransientError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsError", 1)?;
                s.serialize_field(".tag", "transient_error")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsError::LegalHoldStillEmpty => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsError", 1)?;
                s.serialize_field(".tag", "legal_hold_still_empty")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsError::InactiveLegalHold => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListHeldRevisionsError", 1)?;
                s.serialize_field(".tag", "inactive_legal_hold")?;
                s.end()
            }
            LegalHoldsListHeldRevisionsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsListHeldRevisionsError {
}

impl ::std::fmt::Display for LegalHoldsListHeldRevisionsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsListHeldRevisionsError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsListHeldRevisionsError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            LegalHoldsListHeldRevisionsError::TransientError => f.write_str("Temporary infrastructure failure, please retry."),
            LegalHoldsListHeldRevisionsError::LegalHoldStillEmpty => f.write_str("The legal hold is not holding any revisions yet."),
            LegalHoldsListHeldRevisionsError::InactiveLegalHold => f.write_str("Trying to list revisions for an inactive legal hold."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsListPoliciesArg {
    /// Whether to return holds that were released.
    pub include_released: bool,
}

impl LegalHoldsListPoliciesArg {
    pub fn with_include_released(mut self, value: bool) -> Self {
        self.include_released = value;
        self
    }
}

const LEGAL_HOLDS_LIST_POLICIES_ARG_FIELDS: &[&str] = &["include_released"];
impl LegalHoldsListPoliciesArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<LegalHoldsListPoliciesArg, V::Error> {
        let mut field_include_released = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "include_released" => {
                    if field_include_released.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_released"));
                    }
                    field_include_released = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = LegalHoldsListPoliciesArg {
            include_released: field_include_released.unwrap_or(false),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("include_released", &self.include_released)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListPoliciesArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsListPoliciesArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListPoliciesArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsListPoliciesArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsListPoliciesArg", LEGAL_HOLDS_LIST_POLICIES_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListPoliciesArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsListPoliciesArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsListPoliciesError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Temporary infrastructure failure, please retry.
    TransientError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListPoliciesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsListPoliciesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListPoliciesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsListPoliciesError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsListPoliciesError::InsufficientPermissions,
                    "transient_error" => LegalHoldsListPoliciesError::TransientError,
                    _ => LegalHoldsListPoliciesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "transient_error"];
        deserializer.deserialize_struct("LegalHoldsListPoliciesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListPoliciesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsListPoliciesError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListPoliciesError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsListPoliciesError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListPoliciesError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsListPoliciesError::TransientError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsListPoliciesError", 1)?;
                s.serialize_field(".tag", "transient_error")?;
                s.end()
            }
            LegalHoldsListPoliciesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsListPoliciesError {
}

impl ::std::fmt::Display for LegalHoldsListPoliciesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsListPoliciesError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsListPoliciesError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            LegalHoldsListPoliciesError::TransientError => f.write_str("Temporary infrastructure failure, please retry."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsListPoliciesResult {
    pub policies: Vec<LegalHoldPolicy>,
}

impl LegalHoldsListPoliciesResult {
    pub fn new(policies: Vec<LegalHoldPolicy>) -> Self {
        LegalHoldsListPoliciesResult {
            policies,
        }
    }
}

const LEGAL_HOLDS_LIST_POLICIES_RESULT_FIELDS: &[&str] = &["policies"];
impl LegalHoldsListPoliciesResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsListPoliciesResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsListPoliciesResult>, V::Error> {
        let mut field_policies = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "policies" => {
                    if field_policies.is_some() {
                        return Err(::serde::de::Error::duplicate_field("policies"));
                    }
                    field_policies = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsListPoliciesResult {
            policies: field_policies.ok_or_else(|| ::serde::de::Error::missing_field("policies"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("policies", &self.policies)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsListPoliciesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsListPoliciesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsListPoliciesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsListPoliciesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsListPoliciesResult", LEGAL_HOLDS_LIST_POLICIES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsListPoliciesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsListPoliciesResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsPolicyCreateArg {
    /// Policy name.
    pub name: LegalHoldPolicyName,
    /// List of team member IDs added to the hold.
    pub members: Vec<super::team_common::TeamMemberId>,
    /// A description of the legal hold policy.
    pub description: Option<LegalHoldPolicyDescription>,
    /// start date of the legal hold policy.
    pub start_date: Option<super::common::DropboxTimestamp>,
    /// end date of the legal hold policy.
    pub end_date: Option<super::common::DropboxTimestamp>,
}

impl LegalHoldsPolicyCreateArg {
    pub fn new(name: LegalHoldPolicyName, members: Vec<super::team_common::TeamMemberId>) -> Self {
        LegalHoldsPolicyCreateArg {
            name,
            members,
            description: None,
            start_date: None,
            end_date: None,
        }
    }

    pub fn with_description(mut self, value: LegalHoldPolicyDescription) -> Self {
        self.description = Some(value);
        self
    }

    pub fn with_start_date(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.start_date = Some(value);
        self
    }

    pub fn with_end_date(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.end_date = Some(value);
        self
    }
}

const LEGAL_HOLDS_POLICY_CREATE_ARG_FIELDS: &[&str] = &["name",
                                                        "members",
                                                        "description",
                                                        "start_date",
                                                        "end_date"];
impl LegalHoldsPolicyCreateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsPolicyCreateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsPolicyCreateArg>, V::Error> {
        let mut field_name = None;
        let mut field_members = None;
        let mut field_description = None;
        let mut field_start_date = None;
        let mut field_end_date = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                "start_date" => {
                    if field_start_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start_date"));
                    }
                    field_start_date = Some(map.next_value()?);
                }
                "end_date" => {
                    if field_end_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("end_date"));
                    }
                    field_end_date = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsPolicyCreateArg {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            description: field_description,
            start_date: field_start_date,
            end_date: field_end_date,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("members", &self.members)?;
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        if let Some(val) = &self.start_date {
            s.serialize_field("start_date", val)?;
        }
        if let Some(val) = &self.end_date {
            s.serialize_field("end_date", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyCreateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsPolicyCreateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyCreateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsPolicyCreateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsPolicyCreateArg", LEGAL_HOLDS_POLICY_CREATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyCreateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateArg", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsPolicyCreateError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Start date must be earlier than end date.
    StartDateIsLaterThanEndDate,
    /// The users list must have at least one user.
    EmptyMembersList,
    /// Some members in the members list are not valid to be placed under legal hold.
    InvalidMembers,
    /// You cannot add more than 5 users in a legal hold.
    NumberOfUsersOnHoldIsGreaterThanHoldLimitation,
    /// Temporary infrastructure failure, please retry.
    TransientError,
    /// The name provided is already in use by another legal hold.
    NameMustBeUnique,
    /// Team exceeded legal hold quota.
    TeamExceededLegalHoldQuota,
    /// The provided date is invalid.
    InvalidDate,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyCreateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsPolicyCreateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyCreateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsPolicyCreateError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsPolicyCreateError::InsufficientPermissions,
                    "start_date_is_later_than_end_date" => LegalHoldsPolicyCreateError::StartDateIsLaterThanEndDate,
                    "empty_members_list" => LegalHoldsPolicyCreateError::EmptyMembersList,
                    "invalid_members" => LegalHoldsPolicyCreateError::InvalidMembers,
                    "number_of_users_on_hold_is_greater_than_hold_limitation" => LegalHoldsPolicyCreateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation,
                    "transient_error" => LegalHoldsPolicyCreateError::TransientError,
                    "name_must_be_unique" => LegalHoldsPolicyCreateError::NameMustBeUnique,
                    "team_exceeded_legal_hold_quota" => LegalHoldsPolicyCreateError::TeamExceededLegalHoldQuota,
                    "invalid_date" => LegalHoldsPolicyCreateError::InvalidDate,
                    _ => LegalHoldsPolicyCreateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "start_date_is_later_than_end_date",
                                    "empty_members_list",
                                    "invalid_members",
                                    "number_of_users_on_hold_is_greater_than_hold_limitation",
                                    "transient_error",
                                    "name_must_be_unique",
                                    "team_exceeded_legal_hold_quota",
                                    "invalid_date"];
        deserializer.deserialize_struct("LegalHoldsPolicyCreateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyCreateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsPolicyCreateError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::StartDateIsLaterThanEndDate => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "start_date_is_later_than_end_date")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::EmptyMembersList => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "empty_members_list")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::InvalidMembers => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "invalid_members")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "number_of_users_on_hold_is_greater_than_hold_limitation")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::TransientError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "transient_error")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::NameMustBeUnique => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "name_must_be_unique")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::TeamExceededLegalHoldQuota => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "team_exceeded_legal_hold_quota")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::InvalidDate => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyCreateError", 1)?;
                s.serialize_field(".tag", "invalid_date")?;
                s.end()
            }
            LegalHoldsPolicyCreateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsPolicyCreateError {
}

impl ::std::fmt::Display for LegalHoldsPolicyCreateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsPolicyCreateError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsPolicyCreateError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            LegalHoldsPolicyCreateError::StartDateIsLaterThanEndDate => f.write_str("Start date must be earlier than end date."),
            LegalHoldsPolicyCreateError::EmptyMembersList => f.write_str("The users list must have at least one user."),
            LegalHoldsPolicyCreateError::InvalidMembers => f.write_str("Some members in the members list are not valid to be placed under legal hold."),
            LegalHoldsPolicyCreateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation => f.write_str("You cannot add more than 5 users in a legal hold."),
            LegalHoldsPolicyCreateError::TransientError => f.write_str("Temporary infrastructure failure, please retry."),
            LegalHoldsPolicyCreateError::NameMustBeUnique => f.write_str("The name provided is already in use by another legal hold."),
            LegalHoldsPolicyCreateError::TeamExceededLegalHoldQuota => f.write_str("Team exceeded legal hold quota."),
            LegalHoldsPolicyCreateError::InvalidDate => f.write_str("The provided date is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsPolicyReleaseArg {
    /// The legal hold Id.
    pub id: LegalHoldId,
}

impl LegalHoldsPolicyReleaseArg {
    pub fn new(id: LegalHoldId) -> Self {
        LegalHoldsPolicyReleaseArg {
            id,
        }
    }
}

const LEGAL_HOLDS_POLICY_RELEASE_ARG_FIELDS: &[&str] = &["id"];
impl LegalHoldsPolicyReleaseArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsPolicyReleaseArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsPolicyReleaseArg>, V::Error> {
        let mut field_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsPolicyReleaseArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyReleaseArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsPolicyReleaseArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyReleaseArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsPolicyReleaseArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsPolicyReleaseArg", LEGAL_HOLDS_POLICY_RELEASE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyReleaseArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsPolicyReleaseError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Legal hold is currently performing another operation.
    LegalHoldPerformingAnotherOperation,
    /// Legal hold is currently performing a release or is already released.
    LegalHoldAlreadyReleasing,
    /// Legal hold policy does not exist for
    /// [`LegalHoldsPolicyReleaseArg::id`](LegalHoldsPolicyReleaseArg).
    LegalHoldPolicyNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyReleaseError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsPolicyReleaseError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyReleaseError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsPolicyReleaseError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsPolicyReleaseError::InsufficientPermissions,
                    "legal_hold_performing_another_operation" => LegalHoldsPolicyReleaseError::LegalHoldPerformingAnotherOperation,
                    "legal_hold_already_releasing" => LegalHoldsPolicyReleaseError::LegalHoldAlreadyReleasing,
                    "legal_hold_policy_not_found" => LegalHoldsPolicyReleaseError::LegalHoldPolicyNotFound,
                    _ => LegalHoldsPolicyReleaseError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "legal_hold_performing_another_operation",
                                    "legal_hold_already_releasing",
                                    "legal_hold_policy_not_found"];
        deserializer.deserialize_struct("LegalHoldsPolicyReleaseError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyReleaseError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsPolicyReleaseError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsPolicyReleaseError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsPolicyReleaseError::LegalHoldPerformingAnotherOperation => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseError", 1)?;
                s.serialize_field(".tag", "legal_hold_performing_another_operation")?;
                s.end()
            }
            LegalHoldsPolicyReleaseError::LegalHoldAlreadyReleasing => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseError", 1)?;
                s.serialize_field(".tag", "legal_hold_already_releasing")?;
                s.end()
            }
            LegalHoldsPolicyReleaseError::LegalHoldPolicyNotFound => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyReleaseError", 1)?;
                s.serialize_field(".tag", "legal_hold_policy_not_found")?;
                s.end()
            }
            LegalHoldsPolicyReleaseError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsPolicyReleaseError {
}

impl ::std::fmt::Display for LegalHoldsPolicyReleaseError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsPolicyReleaseError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsPolicyReleaseError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            LegalHoldsPolicyReleaseError::LegalHoldPerformingAnotherOperation => f.write_str("Legal hold is currently performing another operation."),
            LegalHoldsPolicyReleaseError::LegalHoldAlreadyReleasing => f.write_str("Legal hold is currently performing a release or is already released."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LegalHoldsPolicyUpdateArg {
    /// The legal hold Id.
    pub id: LegalHoldId,
    /// Policy new name.
    pub name: Option<LegalHoldPolicyName>,
    /// Policy new description.
    pub description: Option<LegalHoldPolicyDescription>,
    /// List of team member IDs to apply the policy on.
    pub members: Option<Vec<super::team_common::TeamMemberId>>,
}

impl LegalHoldsPolicyUpdateArg {
    pub fn new(id: LegalHoldId) -> Self {
        LegalHoldsPolicyUpdateArg {
            id,
            name: None,
            description: None,
            members: None,
        }
    }

    pub fn with_name(mut self, value: LegalHoldPolicyName) -> Self {
        self.name = Some(value);
        self
    }

    pub fn with_description(mut self, value: LegalHoldPolicyDescription) -> Self {
        self.description = Some(value);
        self
    }

    pub fn with_members(mut self, value: Vec<super::team_common::TeamMemberId>) -> Self {
        self.members = Some(value);
        self
    }
}

const LEGAL_HOLDS_POLICY_UPDATE_ARG_FIELDS: &[&str] = &["id",
                                                        "name",
                                                        "description",
                                                        "members"];
impl LegalHoldsPolicyUpdateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LegalHoldsPolicyUpdateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LegalHoldsPolicyUpdateArg>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut field_description = None;
        let mut field_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LegalHoldsPolicyUpdateArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name,
            description: field_description,
            members: field_members,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        if let Some(val) = &self.name {
            s.serialize_field("name", val)?;
        }
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        if let Some(val) = &self.members {
            s.serialize_field("members", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyUpdateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LegalHoldsPolicyUpdateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyUpdateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LegalHoldsPolicyUpdateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LegalHoldsPolicyUpdateArg", LEGAL_HOLDS_POLICY_UPDATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyUpdateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LegalHoldsPolicyUpdateError {
    /// There has been an unknown legal hold error.
    UnknownLegalHoldError,
    /// You don't have permissions to perform this action.
    InsufficientPermissions,
    /// Temporary infrastructure failure, please retry.
    TransientError,
    /// Trying to release an inactive legal hold.
    InactiveLegalHold,
    /// Legal hold is currently performing another operation.
    LegalHoldPerformingAnotherOperation,
    /// Some members in the members list are not valid to be placed under legal hold.
    InvalidMembers,
    /// You cannot add more than 5 users in a legal hold.
    NumberOfUsersOnHoldIsGreaterThanHoldLimitation,
    /// The users list must have at least one user.
    EmptyMembersList,
    /// The name provided is already in use by another legal hold.
    NameMustBeUnique,
    /// Legal hold policy does not exist for
    /// [`LegalHoldsPolicyUpdateArg::id`](LegalHoldsPolicyUpdateArg).
    LegalHoldPolicyNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LegalHoldsPolicyUpdateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LegalHoldsPolicyUpdateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LegalHoldsPolicyUpdateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unknown_legal_hold_error" => LegalHoldsPolicyUpdateError::UnknownLegalHoldError,
                    "insufficient_permissions" => LegalHoldsPolicyUpdateError::InsufficientPermissions,
                    "transient_error" => LegalHoldsPolicyUpdateError::TransientError,
                    "inactive_legal_hold" => LegalHoldsPolicyUpdateError::InactiveLegalHold,
                    "legal_hold_performing_another_operation" => LegalHoldsPolicyUpdateError::LegalHoldPerformingAnotherOperation,
                    "invalid_members" => LegalHoldsPolicyUpdateError::InvalidMembers,
                    "number_of_users_on_hold_is_greater_than_hold_limitation" => LegalHoldsPolicyUpdateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation,
                    "empty_members_list" => LegalHoldsPolicyUpdateError::EmptyMembersList,
                    "name_must_be_unique" => LegalHoldsPolicyUpdateError::NameMustBeUnique,
                    "legal_hold_policy_not_found" => LegalHoldsPolicyUpdateError::LegalHoldPolicyNotFound,
                    _ => LegalHoldsPolicyUpdateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unknown_legal_hold_error",
                                    "insufficient_permissions",
                                    "other",
                                    "transient_error",
                                    "inactive_legal_hold",
                                    "legal_hold_performing_another_operation",
                                    "invalid_members",
                                    "number_of_users_on_hold_is_greater_than_hold_limitation",
                                    "empty_members_list",
                                    "name_must_be_unique",
                                    "legal_hold_policy_not_found"];
        deserializer.deserialize_struct("LegalHoldsPolicyUpdateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LegalHoldsPolicyUpdateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LegalHoldsPolicyUpdateError::UnknownLegalHoldError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "unknown_legal_hold_error")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::TransientError => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "transient_error")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::InactiveLegalHold => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "inactive_legal_hold")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::LegalHoldPerformingAnotherOperation => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "legal_hold_performing_another_operation")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::InvalidMembers => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "invalid_members")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "number_of_users_on_hold_is_greater_than_hold_limitation")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::EmptyMembersList => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "empty_members_list")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::NameMustBeUnique => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "name_must_be_unique")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::LegalHoldPolicyNotFound => {
                // unit
                let mut s = serializer.serialize_struct("LegalHoldsPolicyUpdateError", 1)?;
                s.serialize_field(".tag", "legal_hold_policy_not_found")?;
                s.end()
            }
            LegalHoldsPolicyUpdateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LegalHoldsPolicyUpdateError {
}

impl ::std::fmt::Display for LegalHoldsPolicyUpdateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LegalHoldsPolicyUpdateError::UnknownLegalHoldError => f.write_str("There has been an unknown legal hold error."),
            LegalHoldsPolicyUpdateError::InsufficientPermissions => f.write_str("You don't have permissions to perform this action."),
            LegalHoldsPolicyUpdateError::TransientError => f.write_str("Temporary infrastructure failure, please retry."),
            LegalHoldsPolicyUpdateError::InactiveLegalHold => f.write_str("Trying to release an inactive legal hold."),
            LegalHoldsPolicyUpdateError::LegalHoldPerformingAnotherOperation => f.write_str("Legal hold is currently performing another operation."),
            LegalHoldsPolicyUpdateError::InvalidMembers => f.write_str("Some members in the members list are not valid to be placed under legal hold."),
            LegalHoldsPolicyUpdateError::NumberOfUsersOnHoldIsGreaterThanHoldLimitation => f.write_str("You cannot add more than 5 users in a legal hold."),
            LegalHoldsPolicyUpdateError::EmptyMembersList => f.write_str("The users list must have at least one user."),
            LegalHoldsPolicyUpdateError::NameMustBeUnique => f.write_str("The name provided is already in use by another legal hold."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMemberAppsArg {
    /// The team member id.
    pub team_member_id: String,
}

impl ListMemberAppsArg {
    pub fn new(team_member_id: String) -> Self {
        ListMemberAppsArg {
            team_member_id,
        }
    }
}

const LIST_MEMBER_APPS_ARG_FIELDS: &[&str] = &["team_member_id"];
impl ListMemberAppsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListMemberAppsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListMemberAppsArg>, V::Error> {
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListMemberAppsArg {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberAppsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMemberAppsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberAppsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMemberAppsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMemberAppsArg", LIST_MEMBER_APPS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberAppsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMemberAppsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned by
/// [`linked_apps_list_member_linked_apps()`](linked_apps_list_member_linked_apps).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListMemberAppsError {
    /// Member not found.
    MemberNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberAppsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListMemberAppsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberAppsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "member_not_found" => ListMemberAppsError::MemberNotFound,
                    _ => ListMemberAppsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["member_not_found",
                                    "other"];
        deserializer.deserialize_struct("ListMemberAppsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberAppsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListMemberAppsError::MemberNotFound => {
                // unit
                let mut s = serializer.serialize_struct("ListMemberAppsError", 1)?;
                s.serialize_field(".tag", "member_not_found")?;
                s.end()
            }
            ListMemberAppsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListMemberAppsError {
}

impl ::std::fmt::Display for ListMemberAppsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListMemberAppsError::MemberNotFound => f.write_str("Member not found."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMemberAppsResult {
    /// List of third party applications linked by this team member.
    pub linked_api_apps: Vec<ApiApp>,
}

impl ListMemberAppsResult {
    pub fn new(linked_api_apps: Vec<ApiApp>) -> Self {
        ListMemberAppsResult {
            linked_api_apps,
        }
    }
}

const LIST_MEMBER_APPS_RESULT_FIELDS: &[&str] = &["linked_api_apps"];
impl ListMemberAppsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListMemberAppsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListMemberAppsResult>, V::Error> {
        let mut field_linked_api_apps = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "linked_api_apps" => {
                    if field_linked_api_apps.is_some() {
                        return Err(::serde::de::Error::duplicate_field("linked_api_apps"));
                    }
                    field_linked_api_apps = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListMemberAppsResult {
            linked_api_apps: field_linked_api_apps.ok_or_else(|| ::serde::de::Error::missing_field("linked_api_apps"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("linked_api_apps", &self.linked_api_apps)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberAppsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMemberAppsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberAppsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMemberAppsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMemberAppsResult", LIST_MEMBER_APPS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberAppsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMemberAppsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMemberDevicesArg {
    /// The team's member id.
    pub team_member_id: String,
    /// Whether to list web sessions of the team's member.
    pub include_web_sessions: bool,
    /// Whether to list linked desktop devices of the team's member.
    pub include_desktop_clients: bool,
    /// Whether to list linked mobile devices of the team's member.
    pub include_mobile_clients: bool,
}

impl ListMemberDevicesArg {
    pub fn new(team_member_id: String) -> Self {
        ListMemberDevicesArg {
            team_member_id,
            include_web_sessions: true,
            include_desktop_clients: true,
            include_mobile_clients: true,
        }
    }

    pub fn with_include_web_sessions(mut self, value: bool) -> Self {
        self.include_web_sessions = value;
        self
    }

    pub fn with_include_desktop_clients(mut self, value: bool) -> Self {
        self.include_desktop_clients = value;
        self
    }

    pub fn with_include_mobile_clients(mut self, value: bool) -> Self {
        self.include_mobile_clients = value;
        self
    }
}

const LIST_MEMBER_DEVICES_ARG_FIELDS: &[&str] = &["team_member_id",
                                                  "include_web_sessions",
                                                  "include_desktop_clients",
                                                  "include_mobile_clients"];
impl ListMemberDevicesArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListMemberDevicesArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListMemberDevicesArg>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_include_web_sessions = None;
        let mut field_include_desktop_clients = None;
        let mut field_include_mobile_clients = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "include_web_sessions" => {
                    if field_include_web_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_web_sessions"));
                    }
                    field_include_web_sessions = Some(map.next_value()?);
                }
                "include_desktop_clients" => {
                    if field_include_desktop_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_desktop_clients"));
                    }
                    field_include_desktop_clients = Some(map.next_value()?);
                }
                "include_mobile_clients" => {
                    if field_include_mobile_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_mobile_clients"));
                    }
                    field_include_mobile_clients = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListMemberDevicesArg {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            include_web_sessions: field_include_web_sessions.unwrap_or(true),
            include_desktop_clients: field_include_desktop_clients.unwrap_or(true),
            include_mobile_clients: field_include_mobile_clients.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("include_web_sessions", &self.include_web_sessions)?;
        s.serialize_field("include_desktop_clients", &self.include_desktop_clients)?;
        s.serialize_field("include_mobile_clients", &self.include_mobile_clients)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberDevicesArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMemberDevicesArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberDevicesArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMemberDevicesArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMemberDevicesArg", LIST_MEMBER_DEVICES_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberDevicesArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMemberDevicesArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListMemberDevicesError {
    /// Member not found.
    MemberNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberDevicesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListMemberDevicesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberDevicesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "member_not_found" => ListMemberDevicesError::MemberNotFound,
                    _ => ListMemberDevicesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["member_not_found",
                                    "other"];
        deserializer.deserialize_struct("ListMemberDevicesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberDevicesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListMemberDevicesError::MemberNotFound => {
                // unit
                let mut s = serializer.serialize_struct("ListMemberDevicesError", 1)?;
                s.serialize_field(".tag", "member_not_found")?;
                s.end()
            }
            ListMemberDevicesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListMemberDevicesError {
}

impl ::std::fmt::Display for ListMemberDevicesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListMemberDevicesError::MemberNotFound => f.write_str("Member not found."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMemberDevicesResult {
    /// List of web sessions made by this team member.
    pub active_web_sessions: Option<Vec<ActiveWebSession>>,
    /// List of desktop clients used by this team member.
    pub desktop_client_sessions: Option<Vec<DesktopClientSession>>,
    /// List of mobile client used by this team member.
    pub mobile_client_sessions: Option<Vec<MobileClientSession>>,
}

impl ListMemberDevicesResult {
    pub fn with_active_web_sessions(mut self, value: Vec<ActiveWebSession>) -> Self {
        self.active_web_sessions = Some(value);
        self
    }

    pub fn with_desktop_client_sessions(mut self, value: Vec<DesktopClientSession>) -> Self {
        self.desktop_client_sessions = Some(value);
        self
    }

    pub fn with_mobile_client_sessions(mut self, value: Vec<MobileClientSession>) -> Self {
        self.mobile_client_sessions = Some(value);
        self
    }
}

const LIST_MEMBER_DEVICES_RESULT_FIELDS: &[&str] = &["active_web_sessions",
                                                     "desktop_client_sessions",
                                                     "mobile_client_sessions"];
impl ListMemberDevicesResult {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListMemberDevicesResult, V::Error> {
        let mut field_active_web_sessions = None;
        let mut field_desktop_client_sessions = None;
        let mut field_mobile_client_sessions = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "active_web_sessions" => {
                    if field_active_web_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("active_web_sessions"));
                    }
                    field_active_web_sessions = Some(map.next_value()?);
                }
                "desktop_client_sessions" => {
                    if field_desktop_client_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("desktop_client_sessions"));
                    }
                    field_desktop_client_sessions = Some(map.next_value()?);
                }
                "mobile_client_sessions" => {
                    if field_mobile_client_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mobile_client_sessions"));
                    }
                    field_mobile_client_sessions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListMemberDevicesResult {
            active_web_sessions: field_active_web_sessions,
            desktop_client_sessions: field_desktop_client_sessions,
            mobile_client_sessions: field_mobile_client_sessions,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.active_web_sessions {
            s.serialize_field("active_web_sessions", val)?;
        }
        if let Some(val) = &self.desktop_client_sessions {
            s.serialize_field("desktop_client_sessions", val)?;
        }
        if let Some(val) = &self.mobile_client_sessions {
            s.serialize_field("mobile_client_sessions", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMemberDevicesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMemberDevicesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMemberDevicesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMemberDevicesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMemberDevicesResult", LIST_MEMBER_DEVICES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMemberDevicesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMemberDevicesResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps).
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMembersAppsArg {
    /// At the first call to the
    /// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps) the cursor
    /// shouldn't be passed. Then, if the result of the call includes a cursor, the following
    /// requests should include the received cursors in order to receive the next sub list of the
    /// team applications.
    pub cursor: Option<String>,
}

impl ListMembersAppsArg {
    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_MEMBERS_APPS_ARG_FIELDS: &[&str] = &["cursor"];
impl ListMembersAppsArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListMembersAppsArg, V::Error> {
        let mut field_cursor = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListMembersAppsArg {
            cursor: field_cursor,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersAppsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMembersAppsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersAppsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMembersAppsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMembersAppsArg", LIST_MEMBERS_APPS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersAppsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMembersAppsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned by
/// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListMembersAppsError {
    /// Indicates that the cursor has been invalidated. Call
    /// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps) again with
    /// an empty cursor to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersAppsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListMembersAppsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersAppsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "reset" => ListMembersAppsError::Reset,
                    _ => ListMembersAppsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["reset",
                                    "other"];
        deserializer.deserialize_struct("ListMembersAppsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersAppsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListMembersAppsError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListMembersAppsError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListMembersAppsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListMembersAppsError {
}

impl ::std::fmt::Display for ListMembersAppsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Information returned by
/// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMembersAppsResult {
    /// The linked applications of each member of the team.
    pub apps: Vec<MemberLinkedApps>,
    /// If true, then there are more apps available. Pass the cursor to
    /// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps) to retrieve
    /// the rest.
    pub has_more: bool,
    /// Pass the cursor into
    /// [`linked_apps_list_members_linked_apps()`](linked_apps_list_members_linked_apps) to receive
    /// the next sub list of team's applications.
    pub cursor: Option<String>,
}

impl ListMembersAppsResult {
    pub fn new(apps: Vec<MemberLinkedApps>, has_more: bool) -> Self {
        ListMembersAppsResult {
            apps,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_MEMBERS_APPS_RESULT_FIELDS: &[&str] = &["apps",
                                                   "has_more",
                                                   "cursor"];
impl ListMembersAppsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListMembersAppsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListMembersAppsResult>, V::Error> {
        let mut field_apps = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "apps" => {
                    if field_apps.is_some() {
                        return Err(::serde::de::Error::duplicate_field("apps"));
                    }
                    field_apps = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListMembersAppsResult {
            apps: field_apps.ok_or_else(|| ::serde::de::Error::missing_field("apps"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("apps", &self.apps)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersAppsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMembersAppsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersAppsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMembersAppsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMembersAppsResult", LIST_MEMBERS_APPS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersAppsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMembersAppsResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMembersDevicesArg {
    /// At the first call to the [`devices_list_members_devices()`](devices_list_members_devices)
    /// the cursor shouldn't be passed. Then, if the result of the call includes a cursor, the
    /// following requests should include the received cursors in order to receive the next sub list
    /// of team devices.
    pub cursor: Option<String>,
    /// Whether to list web sessions of the team members.
    pub include_web_sessions: bool,
    /// Whether to list desktop clients of the team members.
    pub include_desktop_clients: bool,
    /// Whether to list mobile clients of the team members.
    pub include_mobile_clients: bool,
}

impl Default for ListMembersDevicesArg {
    fn default() -> Self {
        ListMembersDevicesArg {
            cursor: None,
            include_web_sessions: true,
            include_desktop_clients: true,
            include_mobile_clients: true,
        }
    }
}

impl ListMembersDevicesArg {
    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }

    pub fn with_include_web_sessions(mut self, value: bool) -> Self {
        self.include_web_sessions = value;
        self
    }

    pub fn with_include_desktop_clients(mut self, value: bool) -> Self {
        self.include_desktop_clients = value;
        self
    }

    pub fn with_include_mobile_clients(mut self, value: bool) -> Self {
        self.include_mobile_clients = value;
        self
    }
}

const LIST_MEMBERS_DEVICES_ARG_FIELDS: &[&str] = &["cursor",
                                                   "include_web_sessions",
                                                   "include_desktop_clients",
                                                   "include_mobile_clients"];
impl ListMembersDevicesArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListMembersDevicesArg, V::Error> {
        let mut field_cursor = None;
        let mut field_include_web_sessions = None;
        let mut field_include_desktop_clients = None;
        let mut field_include_mobile_clients = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "include_web_sessions" => {
                    if field_include_web_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_web_sessions"));
                    }
                    field_include_web_sessions = Some(map.next_value()?);
                }
                "include_desktop_clients" => {
                    if field_include_desktop_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_desktop_clients"));
                    }
                    field_include_desktop_clients = Some(map.next_value()?);
                }
                "include_mobile_clients" => {
                    if field_include_mobile_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_mobile_clients"));
                    }
                    field_include_mobile_clients = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListMembersDevicesArg {
            cursor: field_cursor,
            include_web_sessions: field_include_web_sessions.unwrap_or(true),
            include_desktop_clients: field_include_desktop_clients.unwrap_or(true),
            include_mobile_clients: field_include_mobile_clients.unwrap_or(true),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        s.serialize_field("include_web_sessions", &self.include_web_sessions)?;
        s.serialize_field("include_desktop_clients", &self.include_desktop_clients)?;
        s.serialize_field("include_mobile_clients", &self.include_mobile_clients)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersDevicesArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMembersDevicesArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersDevicesArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMembersDevicesArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMembersDevicesArg", LIST_MEMBERS_DEVICES_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersDevicesArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMembersDevicesArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListMembersDevicesError {
    /// Indicates that the cursor has been invalidated. Call
    /// [`devices_list_members_devices()`](devices_list_members_devices) again with an empty cursor
    /// to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersDevicesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListMembersDevicesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersDevicesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "reset" => ListMembersDevicesError::Reset,
                    _ => ListMembersDevicesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["reset",
                                    "other"];
        deserializer.deserialize_struct("ListMembersDevicesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersDevicesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListMembersDevicesError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListMembersDevicesError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListMembersDevicesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListMembersDevicesError {
}

impl ::std::fmt::Display for ListMembersDevicesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListMembersDevicesResult {
    /// The devices of each member of the team.
    pub devices: Vec<MemberDevices>,
    /// If true, then there are more devices available. Pass the cursor to
    /// [`devices_list_members_devices()`](devices_list_members_devices) to retrieve the rest.
    pub has_more: bool,
    /// Pass the cursor into [`devices_list_members_devices()`](devices_list_members_devices) to
    /// receive the next sub list of team's devices.
    pub cursor: Option<String>,
}

impl ListMembersDevicesResult {
    pub fn new(devices: Vec<MemberDevices>, has_more: bool) -> Self {
        ListMembersDevicesResult {
            devices,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_MEMBERS_DEVICES_RESULT_FIELDS: &[&str] = &["devices",
                                                      "has_more",
                                                      "cursor"];
impl ListMembersDevicesResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListMembersDevicesResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListMembersDevicesResult>, V::Error> {
        let mut field_devices = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "devices" => {
                    if field_devices.is_some() {
                        return Err(::serde::de::Error::duplicate_field("devices"));
                    }
                    field_devices = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListMembersDevicesResult {
            devices: field_devices.ok_or_else(|| ::serde::de::Error::missing_field("devices"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("devices", &self.devices)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListMembersDevicesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListMembersDevicesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListMembersDevicesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListMembersDevicesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListMembersDevicesResult", LIST_MEMBERS_DEVICES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListMembersDevicesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListMembersDevicesResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps).
#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListTeamAppsArg {
    /// At the first call to the
    /// [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps) the cursor
    /// shouldn't be passed. Then, if the result of the call includes a cursor, the following
    /// requests should include the received cursors in order to receive the next sub list of the
    /// team applications.
    pub cursor: Option<String>,
}

impl ListTeamAppsArg {
    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_TEAM_APPS_ARG_FIELDS: &[&str] = &["cursor"];
impl ListTeamAppsArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListTeamAppsArg, V::Error> {
        let mut field_cursor = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListTeamAppsArg {
            cursor: field_cursor,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamAppsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListTeamAppsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamAppsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListTeamAppsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListTeamAppsArg", LIST_TEAM_APPS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamAppsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListTeamAppsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned by [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListTeamAppsError {
    /// Indicates that the cursor has been invalidated. Call
    /// [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps) again with an
    /// empty cursor to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamAppsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListTeamAppsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamAppsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "reset" => ListTeamAppsError::Reset,
                    _ => ListTeamAppsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["reset",
                                    "other"];
        deserializer.deserialize_struct("ListTeamAppsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamAppsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListTeamAppsError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListTeamAppsError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListTeamAppsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListTeamAppsError {
}

impl ::std::fmt::Display for ListTeamAppsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Information returned by
/// [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListTeamAppsResult {
    /// The linked applications of each member of the team.
    pub apps: Vec<MemberLinkedApps>,
    /// If true, then there are more apps available. Pass the cursor to
    /// [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps) to retrieve the
    /// rest.
    pub has_more: bool,
    /// Pass the cursor into
    /// [`linked_apps_list_team_linked_apps()`](linked_apps_list_team_linked_apps) to receive the
    /// next sub list of team's applications.
    pub cursor: Option<String>,
}

impl ListTeamAppsResult {
    pub fn new(apps: Vec<MemberLinkedApps>, has_more: bool) -> Self {
        ListTeamAppsResult {
            apps,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_TEAM_APPS_RESULT_FIELDS: &[&str] = &["apps",
                                                "has_more",
                                                "cursor"];
impl ListTeamAppsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListTeamAppsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListTeamAppsResult>, V::Error> {
        let mut field_apps = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "apps" => {
                    if field_apps.is_some() {
                        return Err(::serde::de::Error::duplicate_field("apps"));
                    }
                    field_apps = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListTeamAppsResult {
            apps: field_apps.ok_or_else(|| ::serde::de::Error::missing_field("apps"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("apps", &self.apps)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamAppsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListTeamAppsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamAppsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListTeamAppsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListTeamAppsResult", LIST_TEAM_APPS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamAppsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListTeamAppsResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListTeamDevicesArg {
    /// At the first call to the [`devices_list_team_devices()`](devices_list_team_devices) the
    /// cursor shouldn't be passed. Then, if the result of the call includes a cursor, the following
    /// requests should include the received cursors in order to receive the next sub list of team
    /// devices.
    pub cursor: Option<String>,
    /// Whether to list web sessions of the team members.
    pub include_web_sessions: bool,
    /// Whether to list desktop clients of the team members.
    pub include_desktop_clients: bool,
    /// Whether to list mobile clients of the team members.
    pub include_mobile_clients: bool,
}

impl Default for ListTeamDevicesArg {
    fn default() -> Self {
        ListTeamDevicesArg {
            cursor: None,
            include_web_sessions: true,
            include_desktop_clients: true,
            include_mobile_clients: true,
        }
    }
}

impl ListTeamDevicesArg {
    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }

    pub fn with_include_web_sessions(mut self, value: bool) -> Self {
        self.include_web_sessions = value;
        self
    }

    pub fn with_include_desktop_clients(mut self, value: bool) -> Self {
        self.include_desktop_clients = value;
        self
    }

    pub fn with_include_mobile_clients(mut self, value: bool) -> Self {
        self.include_mobile_clients = value;
        self
    }
}

const LIST_TEAM_DEVICES_ARG_FIELDS: &[&str] = &["cursor",
                                                "include_web_sessions",
                                                "include_desktop_clients",
                                                "include_mobile_clients"];
impl ListTeamDevicesArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListTeamDevicesArg, V::Error> {
        let mut field_cursor = None;
        let mut field_include_web_sessions = None;
        let mut field_include_desktop_clients = None;
        let mut field_include_mobile_clients = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "include_web_sessions" => {
                    if field_include_web_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_web_sessions"));
                    }
                    field_include_web_sessions = Some(map.next_value()?);
                }
                "include_desktop_clients" => {
                    if field_include_desktop_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_desktop_clients"));
                    }
                    field_include_desktop_clients = Some(map.next_value()?);
                }
                "include_mobile_clients" => {
                    if field_include_mobile_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_mobile_clients"));
                    }
                    field_include_mobile_clients = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListTeamDevicesArg {
            cursor: field_cursor,
            include_web_sessions: field_include_web_sessions.unwrap_or(true),
            include_desktop_clients: field_include_desktop_clients.unwrap_or(true),
            include_mobile_clients: field_include_mobile_clients.unwrap_or(true),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        s.serialize_field("include_web_sessions", &self.include_web_sessions)?;
        s.serialize_field("include_desktop_clients", &self.include_desktop_clients)?;
        s.serialize_field("include_mobile_clients", &self.include_mobile_clients)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamDevicesArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListTeamDevicesArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamDevicesArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListTeamDevicesArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListTeamDevicesArg", LIST_TEAM_DEVICES_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamDevicesArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListTeamDevicesArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListTeamDevicesError {
    /// Indicates that the cursor has been invalidated. Call
    /// [`devices_list_team_devices()`](devices_list_team_devices) again with an empty cursor to
    /// obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamDevicesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListTeamDevicesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamDevicesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "reset" => ListTeamDevicesError::Reset,
                    _ => ListTeamDevicesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["reset",
                                    "other"];
        deserializer.deserialize_struct("ListTeamDevicesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamDevicesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListTeamDevicesError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListTeamDevicesError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListTeamDevicesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListTeamDevicesError {
}

impl ::std::fmt::Display for ListTeamDevicesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListTeamDevicesResult {
    /// The devices of each member of the team.
    pub devices: Vec<MemberDevices>,
    /// If true, then there are more devices available. Pass the cursor to
    /// [`devices_list_team_devices()`](devices_list_team_devices) to retrieve the rest.
    pub has_more: bool,
    /// Pass the cursor into [`devices_list_team_devices()`](devices_list_team_devices) to receive
    /// the next sub list of team's devices.
    pub cursor: Option<String>,
}

impl ListTeamDevicesResult {
    pub fn new(devices: Vec<MemberDevices>, has_more: bool) -> Self {
        ListTeamDevicesResult {
            devices,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_TEAM_DEVICES_RESULT_FIELDS: &[&str] = &["devices",
                                                   "has_more",
                                                   "cursor"];
impl ListTeamDevicesResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListTeamDevicesResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListTeamDevicesResult>, V::Error> {
        let mut field_devices = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "devices" => {
                    if field_devices.is_some() {
                        return Err(::serde::de::Error::duplicate_field("devices"));
                    }
                    field_devices = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListTeamDevicesResult {
            devices: field_devices.ok_or_else(|| ::serde::de::Error::missing_field("devices"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("devices", &self.devices)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListTeamDevicesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListTeamDevicesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListTeamDevicesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListTeamDevicesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListTeamDevicesResult", LIST_TEAM_DEVICES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListTeamDevicesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListTeamDevicesResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Specify access type a member should have when joined to a group.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberAccess {
    /// Identity of a user.
    pub user: UserSelectorArg,
    /// Access type.
    pub access_type: GroupAccessType,
}

impl MemberAccess {
    pub fn new(user: UserSelectorArg, access_type: GroupAccessType) -> Self {
        MemberAccess {
            user,
            access_type,
        }
    }
}

const MEMBER_ACCESS_FIELDS: &[&str] = &["user",
                                        "access_type"];
impl MemberAccess {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberAccess, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberAccess>, V::Error> {
        let mut field_user = None;
        let mut field_access_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberAccess {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("access_type", &self.access_type)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAccess {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberAccess;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAccess struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberAccess::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberAccess", MEMBER_ACCESS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAccess {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberAccess", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberAddArg {
    pub member_email: super::common::EmailAddress,
    /// Member's first name.
    pub member_given_name: Option<super::common::OptionalNamePart>,
    /// Member's last name.
    pub member_surname: Option<super::common::OptionalNamePart>,
    /// External ID for member.
    pub member_external_id: Option<super::team_common::MemberExternalId>,
    /// Persistent ID for member. This field is only available to teams using persistent ID SAML
    /// configuration.
    pub member_persistent_id: Option<String>,
    /// Whether to send a welcome email to the member. If send_welcome_email is false, no email
    /// invitation will be sent to the user. This may be useful for apps using single sign-on (SSO)
    /// flows for onboarding that want to handle announcements themselves.
    pub send_welcome_email: bool,
    /// Whether a user is directory restricted.
    pub is_directory_restricted: Option<bool>,
    pub role: AdminTier,
}

impl MemberAddArg {
    pub fn new(member_email: super::common::EmailAddress) -> Self {
        MemberAddArg {
            member_email,
            member_given_name: None,
            member_surname: None,
            member_external_id: None,
            member_persistent_id: None,
            send_welcome_email: true,
            is_directory_restricted: None,
            role: AdminTier::MemberOnly,
        }
    }

    pub fn with_member_given_name(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_given_name = Some(value);
        self
    }

    pub fn with_member_surname(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_surname = Some(value);
        self
    }

    pub fn with_member_external_id(mut self, value: super::team_common::MemberExternalId) -> Self {
        self.member_external_id = Some(value);
        self
    }

    pub fn with_member_persistent_id(mut self, value: String) -> Self {
        self.member_persistent_id = Some(value);
        self
    }

    pub fn with_send_welcome_email(mut self, value: bool) -> Self {
        self.send_welcome_email = value;
        self
    }

    pub fn with_is_directory_restricted(mut self, value: bool) -> Self {
        self.is_directory_restricted = Some(value);
        self
    }

    pub fn with_role(mut self, value: AdminTier) -> Self {
        self.role = value;
        self
    }
}

const MEMBER_ADD_ARG_FIELDS: &[&str] = &["member_email",
                                         "member_given_name",
                                         "member_surname",
                                         "member_external_id",
                                         "member_persistent_id",
                                         "send_welcome_email",
                                         "is_directory_restricted",
                                         "role"];
impl MemberAddArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberAddArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberAddArg>, V::Error> {
        let mut field_member_email = None;
        let mut field_member_given_name = None;
        let mut field_member_surname = None;
        let mut field_member_external_id = None;
        let mut field_member_persistent_id = None;
        let mut field_send_welcome_email = None;
        let mut field_is_directory_restricted = None;
        let mut field_role = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member_email" => {
                    if field_member_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_email"));
                    }
                    field_member_email = Some(map.next_value()?);
                }
                "member_given_name" => {
                    if field_member_given_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_given_name"));
                    }
                    field_member_given_name = Some(map.next_value()?);
                }
                "member_surname" => {
                    if field_member_surname.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_surname"));
                    }
                    field_member_surname = Some(map.next_value()?);
                }
                "member_external_id" => {
                    if field_member_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_external_id"));
                    }
                    field_member_external_id = Some(map.next_value()?);
                }
                "member_persistent_id" => {
                    if field_member_persistent_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_persistent_id"));
                    }
                    field_member_persistent_id = Some(map.next_value()?);
                }
                "send_welcome_email" => {
                    if field_send_welcome_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("send_welcome_email"));
                    }
                    field_send_welcome_email = Some(map.next_value()?);
                }
                "is_directory_restricted" => {
                    if field_is_directory_restricted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_directory_restricted"));
                    }
                    field_is_directory_restricted = Some(map.next_value()?);
                }
                "role" => {
                    if field_role.is_some() {
                        return Err(::serde::de::Error::duplicate_field("role"));
                    }
                    field_role = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberAddArg {
            member_email: field_member_email.ok_or_else(|| ::serde::de::Error::missing_field("member_email"))?,
            member_given_name: field_member_given_name,
            member_surname: field_member_surname,
            member_external_id: field_member_external_id,
            member_persistent_id: field_member_persistent_id,
            send_welcome_email: field_send_welcome_email.unwrap_or(true),
            is_directory_restricted: field_is_directory_restricted,
            role: field_role.unwrap_or(AdminTier::MemberOnly),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member_email", &self.member_email)?;
        if let Some(val) = &self.member_given_name {
            s.serialize_field("member_given_name", val)?;
        }
        if let Some(val) = &self.member_surname {
            s.serialize_field("member_surname", val)?;
        }
        if let Some(val) = &self.member_external_id {
            s.serialize_field("member_external_id", val)?;
        }
        if let Some(val) = &self.member_persistent_id {
            s.serialize_field("member_persistent_id", val)?;
        }
        s.serialize_field("send_welcome_email", &self.send_welcome_email)?;
        if let Some(val) = &self.is_directory_restricted {
            s.serialize_field("is_directory_restricted", val)?;
        }
        s.serialize_field("role", &self.role)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberAddArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberAddArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberAddArg", MEMBER_ADD_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberAddArg", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberAddArgBase {
    pub member_email: super::common::EmailAddress,
    /// Member's first name.
    pub member_given_name: Option<super::common::OptionalNamePart>,
    /// Member's last name.
    pub member_surname: Option<super::common::OptionalNamePart>,
    /// External ID for member.
    pub member_external_id: Option<super::team_common::MemberExternalId>,
    /// Persistent ID for member. This field is only available to teams using persistent ID SAML
    /// configuration.
    pub member_persistent_id: Option<String>,
    /// Whether to send a welcome email to the member. If send_welcome_email is false, no email
    /// invitation will be sent to the user. This may be useful for apps using single sign-on (SSO)
    /// flows for onboarding that want to handle announcements themselves.
    pub send_welcome_email: bool,
    /// Whether a user is directory restricted.
    pub is_directory_restricted: Option<bool>,
}

impl MemberAddArgBase {
    pub fn new(member_email: super::common::EmailAddress) -> Self {
        MemberAddArgBase {
            member_email,
            member_given_name: None,
            member_surname: None,
            member_external_id: None,
            member_persistent_id: None,
            send_welcome_email: true,
            is_directory_restricted: None,
        }
    }

    pub fn with_member_given_name(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_given_name = Some(value);
        self
    }

    pub fn with_member_surname(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_surname = Some(value);
        self
    }

    pub fn with_member_external_id(mut self, value: super::team_common::MemberExternalId) -> Self {
        self.member_external_id = Some(value);
        self
    }

    pub fn with_member_persistent_id(mut self, value: String) -> Self {
        self.member_persistent_id = Some(value);
        self
    }

    pub fn with_send_welcome_email(mut self, value: bool) -> Self {
        self.send_welcome_email = value;
        self
    }

    pub fn with_is_directory_restricted(mut self, value: bool) -> Self {
        self.is_directory_restricted = Some(value);
        self
    }
}

const MEMBER_ADD_ARG_BASE_FIELDS: &[&str] = &["member_email",
                                              "member_given_name",
                                              "member_surname",
                                              "member_external_id",
                                              "member_persistent_id",
                                              "send_welcome_email",
                                              "is_directory_restricted"];
impl MemberAddArgBase {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberAddArgBase, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberAddArgBase>, V::Error> {
        let mut field_member_email = None;
        let mut field_member_given_name = None;
        let mut field_member_surname = None;
        let mut field_member_external_id = None;
        let mut field_member_persistent_id = None;
        let mut field_send_welcome_email = None;
        let mut field_is_directory_restricted = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member_email" => {
                    if field_member_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_email"));
                    }
                    field_member_email = Some(map.next_value()?);
                }
                "member_given_name" => {
                    if field_member_given_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_given_name"));
                    }
                    field_member_given_name = Some(map.next_value()?);
                }
                "member_surname" => {
                    if field_member_surname.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_surname"));
                    }
                    field_member_surname = Some(map.next_value()?);
                }
                "member_external_id" => {
                    if field_member_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_external_id"));
                    }
                    field_member_external_id = Some(map.next_value()?);
                }
                "member_persistent_id" => {
                    if field_member_persistent_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_persistent_id"));
                    }
                    field_member_persistent_id = Some(map.next_value()?);
                }
                "send_welcome_email" => {
                    if field_send_welcome_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("send_welcome_email"));
                    }
                    field_send_welcome_email = Some(map.next_value()?);
                }
                "is_directory_restricted" => {
                    if field_is_directory_restricted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_directory_restricted"));
                    }
                    field_is_directory_restricted = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberAddArgBase {
            member_email: field_member_email.ok_or_else(|| ::serde::de::Error::missing_field("member_email"))?,
            member_given_name: field_member_given_name,
            member_surname: field_member_surname,
            member_external_id: field_member_external_id,
            member_persistent_id: field_member_persistent_id,
            send_welcome_email: field_send_welcome_email.unwrap_or(true),
            is_directory_restricted: field_is_directory_restricted,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member_email", &self.member_email)?;
        if let Some(val) = &self.member_given_name {
            s.serialize_field("member_given_name", val)?;
        }
        if let Some(val) = &self.member_surname {
            s.serialize_field("member_surname", val)?;
        }
        if let Some(val) = &self.member_external_id {
            s.serialize_field("member_external_id", val)?;
        }
        if let Some(val) = &self.member_persistent_id {
            s.serialize_field("member_persistent_id", val)?;
        }
        s.serialize_field("send_welcome_email", &self.send_welcome_email)?;
        if let Some(val) = &self.is_directory_restricted {
            s.serialize_field("is_directory_restricted", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddArgBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberAddArgBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddArgBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberAddArgBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberAddArgBase", MEMBER_ADD_ARG_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddArgBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberAddArgBase", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Describes the result of attempting to add a single user to the team. 'success' is the only value
/// indicating that a user was indeed added to the team - the other values explain the type of
/// failure that occurred, and include the email of the user for which the operation has failed.
#[derive(Debug, Clone, PartialEq)]
pub enum MemberAddResult {
    /// Team is already full. The organization has no available licenses.
    TeamLicenseLimit(super::common::EmailAddress),
    /// Team is already full. The free team member limit has been reached.
    FreeTeamMemberLimitReached(super::common::EmailAddress),
    /// User is already on this team. The provided email address is associated with a user who is
    /// already a member of (including in recoverable state) or invited to the team.
    UserAlreadyOnTeam(super::common::EmailAddress),
    /// User is already on another team. The provided email address is associated with a user that
    /// is already a member or invited to another team.
    UserOnAnotherTeam(super::common::EmailAddress),
    /// User is already paired.
    UserAlreadyPaired(super::common::EmailAddress),
    /// User migration has failed.
    UserMigrationFailed(super::common::EmailAddress),
    /// A user with the given external member ID already exists on the team (including in
    /// recoverable state).
    DuplicateExternalMemberId(super::common::EmailAddress),
    /// A user with the given persistent ID already exists on the team (including in recoverable
    /// state).
    DuplicateMemberPersistentId(super::common::EmailAddress),
    /// Persistent ID is only available to teams with persistent ID SAML configuration. Please
    /// contact Dropbox for more information.
    PersistentIdDisabled(super::common::EmailAddress),
    /// User creation has failed.
    UserCreationFailed(super::common::EmailAddress),
    /// Describes a user that was successfully added to the team.
    Success(TeamMemberInfo),
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberAddResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team_license_limit" => {
                        match map.next_key()? {
                            Some("team_license_limit") => MemberAddResult::TeamLicenseLimit(map.next_value()?),
                            None => return Err(de::Error::missing_field("team_license_limit")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "free_team_member_limit_reached" => {
                        match map.next_key()? {
                            Some("free_team_member_limit_reached") => MemberAddResult::FreeTeamMemberLimitReached(map.next_value()?),
                            None => return Err(de::Error::missing_field("free_team_member_limit_reached")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_on_team" => {
                        match map.next_key()? {
                            Some("user_already_on_team") => MemberAddResult::UserAlreadyOnTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_on_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_on_another_team" => {
                        match map.next_key()? {
                            Some("user_on_another_team") => MemberAddResult::UserOnAnotherTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_on_another_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_paired" => {
                        match map.next_key()? {
                            Some("user_already_paired") => MemberAddResult::UserAlreadyPaired(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_paired")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_migration_failed" => {
                        match map.next_key()? {
                            Some("user_migration_failed") => MemberAddResult::UserMigrationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_migration_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_external_member_id" => {
                        match map.next_key()? {
                            Some("duplicate_external_member_id") => MemberAddResult::DuplicateExternalMemberId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_external_member_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_member_persistent_id" => {
                        match map.next_key()? {
                            Some("duplicate_member_persistent_id") => MemberAddResult::DuplicateMemberPersistentId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_member_persistent_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "persistent_id_disabled" => {
                        match map.next_key()? {
                            Some("persistent_id_disabled") => MemberAddResult::PersistentIdDisabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("persistent_id_disabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_creation_failed" => {
                        match map.next_key()? {
                            Some("user_creation_failed") => MemberAddResult::UserCreationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_creation_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "success" => MemberAddResult::Success(TeamMemberInfo::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team_license_limit",
                                    "free_team_member_limit_reached",
                                    "user_already_on_team",
                                    "user_on_another_team",
                                    "user_already_paired",
                                    "user_migration_failed",
                                    "duplicate_external_member_id",
                                    "duplicate_member_persistent_id",
                                    "persistent_id_disabled",
                                    "user_creation_failed",
                                    "success"];
        deserializer.deserialize_struct("MemberAddResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberAddResult::TeamLicenseLimit(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.serialize_field("team_license_limit", x)?;
                s.end()
            }
            MemberAddResult::FreeTeamMemberLimitReached(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "free_team_member_limit_reached")?;
                s.serialize_field("free_team_member_limit_reached", x)?;
                s.end()
            }
            MemberAddResult::UserAlreadyOnTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "user_already_on_team")?;
                s.serialize_field("user_already_on_team", x)?;
                s.end()
            }
            MemberAddResult::UserOnAnotherTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "user_on_another_team")?;
                s.serialize_field("user_on_another_team", x)?;
                s.end()
            }
            MemberAddResult::UserAlreadyPaired(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "user_already_paired")?;
                s.serialize_field("user_already_paired", x)?;
                s.end()
            }
            MemberAddResult::UserMigrationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "user_migration_failed")?;
                s.serialize_field("user_migration_failed", x)?;
                s.end()
            }
            MemberAddResult::DuplicateExternalMemberId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "duplicate_external_member_id")?;
                s.serialize_field("duplicate_external_member_id", x)?;
                s.end()
            }
            MemberAddResult::DuplicateMemberPersistentId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "duplicate_member_persistent_id")?;
                s.serialize_field("duplicate_member_persistent_id", x)?;
                s.end()
            }
            MemberAddResult::PersistentIdDisabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "persistent_id_disabled")?;
                s.serialize_field("persistent_id_disabled", x)?;
                s.end()
            }
            MemberAddResult::UserCreationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResult", 2)?;
                s.serialize_field(".tag", "user_creation_failed")?;
                s.serialize_field("user_creation_failed", x)?;
                s.end()
            }
            MemberAddResult::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("MemberAddResult", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MemberAddResultBase {
    /// Team is already full. The organization has no available licenses.
    TeamLicenseLimit(super::common::EmailAddress),
    /// Team is already full. The free team member limit has been reached.
    FreeTeamMemberLimitReached(super::common::EmailAddress),
    /// User is already on this team. The provided email address is associated with a user who is
    /// already a member of (including in recoverable state) or invited to the team.
    UserAlreadyOnTeam(super::common::EmailAddress),
    /// User is already on another team. The provided email address is associated with a user that
    /// is already a member or invited to another team.
    UserOnAnotherTeam(super::common::EmailAddress),
    /// User is already paired.
    UserAlreadyPaired(super::common::EmailAddress),
    /// User migration has failed.
    UserMigrationFailed(super::common::EmailAddress),
    /// A user with the given external member ID already exists on the team (including in
    /// recoverable state).
    DuplicateExternalMemberId(super::common::EmailAddress),
    /// A user with the given persistent ID already exists on the team (including in recoverable
    /// state).
    DuplicateMemberPersistentId(super::common::EmailAddress),
    /// Persistent ID is only available to teams with persistent ID SAML configuration. Please
    /// contact Dropbox for more information.
    PersistentIdDisabled(super::common::EmailAddress),
    /// User creation has failed.
    UserCreationFailed(super::common::EmailAddress),
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddResultBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberAddResultBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddResultBase structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team_license_limit" => {
                        match map.next_key()? {
                            Some("team_license_limit") => MemberAddResultBase::TeamLicenseLimit(map.next_value()?),
                            None => return Err(de::Error::missing_field("team_license_limit")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "free_team_member_limit_reached" => {
                        match map.next_key()? {
                            Some("free_team_member_limit_reached") => MemberAddResultBase::FreeTeamMemberLimitReached(map.next_value()?),
                            None => return Err(de::Error::missing_field("free_team_member_limit_reached")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_on_team" => {
                        match map.next_key()? {
                            Some("user_already_on_team") => MemberAddResultBase::UserAlreadyOnTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_on_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_on_another_team" => {
                        match map.next_key()? {
                            Some("user_on_another_team") => MemberAddResultBase::UserOnAnotherTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_on_another_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_paired" => {
                        match map.next_key()? {
                            Some("user_already_paired") => MemberAddResultBase::UserAlreadyPaired(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_paired")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_migration_failed" => {
                        match map.next_key()? {
                            Some("user_migration_failed") => MemberAddResultBase::UserMigrationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_migration_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_external_member_id" => {
                        match map.next_key()? {
                            Some("duplicate_external_member_id") => MemberAddResultBase::DuplicateExternalMemberId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_external_member_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_member_persistent_id" => {
                        match map.next_key()? {
                            Some("duplicate_member_persistent_id") => MemberAddResultBase::DuplicateMemberPersistentId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_member_persistent_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "persistent_id_disabled" => {
                        match map.next_key()? {
                            Some("persistent_id_disabled") => MemberAddResultBase::PersistentIdDisabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("persistent_id_disabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_creation_failed" => {
                        match map.next_key()? {
                            Some("user_creation_failed") => MemberAddResultBase::UserCreationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_creation_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team_license_limit",
                                    "free_team_member_limit_reached",
                                    "user_already_on_team",
                                    "user_on_another_team",
                                    "user_already_paired",
                                    "user_migration_failed",
                                    "duplicate_external_member_id",
                                    "duplicate_member_persistent_id",
                                    "persistent_id_disabled",
                                    "user_creation_failed"];
        deserializer.deserialize_struct("MemberAddResultBase", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddResultBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberAddResultBase::TeamLicenseLimit(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.serialize_field("team_license_limit", x)?;
                s.end()
            }
            MemberAddResultBase::FreeTeamMemberLimitReached(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "free_team_member_limit_reached")?;
                s.serialize_field("free_team_member_limit_reached", x)?;
                s.end()
            }
            MemberAddResultBase::UserAlreadyOnTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "user_already_on_team")?;
                s.serialize_field("user_already_on_team", x)?;
                s.end()
            }
            MemberAddResultBase::UserOnAnotherTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "user_on_another_team")?;
                s.serialize_field("user_on_another_team", x)?;
                s.end()
            }
            MemberAddResultBase::UserAlreadyPaired(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "user_already_paired")?;
                s.serialize_field("user_already_paired", x)?;
                s.end()
            }
            MemberAddResultBase::UserMigrationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "user_migration_failed")?;
                s.serialize_field("user_migration_failed", x)?;
                s.end()
            }
            MemberAddResultBase::DuplicateExternalMemberId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "duplicate_external_member_id")?;
                s.serialize_field("duplicate_external_member_id", x)?;
                s.end()
            }
            MemberAddResultBase::DuplicateMemberPersistentId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "duplicate_member_persistent_id")?;
                s.serialize_field("duplicate_member_persistent_id", x)?;
                s.end()
            }
            MemberAddResultBase::PersistentIdDisabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "persistent_id_disabled")?;
                s.serialize_field("persistent_id_disabled", x)?;
                s.end()
            }
            MemberAddResultBase::UserCreationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddResultBase", 2)?;
                s.serialize_field(".tag", "user_creation_failed")?;
                s.serialize_field("user_creation_failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberAddV2Arg {
    pub member_email: super::common::EmailAddress,
    /// Member's first name.
    pub member_given_name: Option<super::common::OptionalNamePart>,
    /// Member's last name.
    pub member_surname: Option<super::common::OptionalNamePart>,
    /// External ID for member.
    pub member_external_id: Option<super::team_common::MemberExternalId>,
    /// Persistent ID for member. This field is only available to teams using persistent ID SAML
    /// configuration.
    pub member_persistent_id: Option<String>,
    /// Whether to send a welcome email to the member. If send_welcome_email is false, no email
    /// invitation will be sent to the user. This may be useful for apps using single sign-on (SSO)
    /// flows for onboarding that want to handle announcements themselves.
    pub send_welcome_email: bool,
    /// Whether a user is directory restricted.
    pub is_directory_restricted: Option<bool>,
    pub role_ids: Option<Vec<TeamMemberRoleId>>,
}

impl MemberAddV2Arg {
    pub fn new(member_email: super::common::EmailAddress) -> Self {
        MemberAddV2Arg {
            member_email,
            member_given_name: None,
            member_surname: None,
            member_external_id: None,
            member_persistent_id: None,
            send_welcome_email: true,
            is_directory_restricted: None,
            role_ids: None,
        }
    }

    pub fn with_member_given_name(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_given_name = Some(value);
        self
    }

    pub fn with_member_surname(mut self, value: super::common::OptionalNamePart) -> Self {
        self.member_surname = Some(value);
        self
    }

    pub fn with_member_external_id(mut self, value: super::team_common::MemberExternalId) -> Self {
        self.member_external_id = Some(value);
        self
    }

    pub fn with_member_persistent_id(mut self, value: String) -> Self {
        self.member_persistent_id = Some(value);
        self
    }

    pub fn with_send_welcome_email(mut self, value: bool) -> Self {
        self.send_welcome_email = value;
        self
    }

    pub fn with_is_directory_restricted(mut self, value: bool) -> Self {
        self.is_directory_restricted = Some(value);
        self
    }

    pub fn with_role_ids(mut self, value: Vec<TeamMemberRoleId>) -> Self {
        self.role_ids = Some(value);
        self
    }
}

const MEMBER_ADD_V2_ARG_FIELDS: &[&str] = &["member_email",
                                            "member_given_name",
                                            "member_surname",
                                            "member_external_id",
                                            "member_persistent_id",
                                            "send_welcome_email",
                                            "is_directory_restricted",
                                            "role_ids"];
impl MemberAddV2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberAddV2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberAddV2Arg>, V::Error> {
        let mut field_member_email = None;
        let mut field_member_given_name = None;
        let mut field_member_surname = None;
        let mut field_member_external_id = None;
        let mut field_member_persistent_id = None;
        let mut field_send_welcome_email = None;
        let mut field_is_directory_restricted = None;
        let mut field_role_ids = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member_email" => {
                    if field_member_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_email"));
                    }
                    field_member_email = Some(map.next_value()?);
                }
                "member_given_name" => {
                    if field_member_given_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_given_name"));
                    }
                    field_member_given_name = Some(map.next_value()?);
                }
                "member_surname" => {
                    if field_member_surname.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_surname"));
                    }
                    field_member_surname = Some(map.next_value()?);
                }
                "member_external_id" => {
                    if field_member_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_external_id"));
                    }
                    field_member_external_id = Some(map.next_value()?);
                }
                "member_persistent_id" => {
                    if field_member_persistent_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_persistent_id"));
                    }
                    field_member_persistent_id = Some(map.next_value()?);
                }
                "send_welcome_email" => {
                    if field_send_welcome_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("send_welcome_email"));
                    }
                    field_send_welcome_email = Some(map.next_value()?);
                }
                "is_directory_restricted" => {
                    if field_is_directory_restricted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_directory_restricted"));
                    }
                    field_is_directory_restricted = Some(map.next_value()?);
                }
                "role_ids" => {
                    if field_role_ids.is_some() {
                        return Err(::serde::de::Error::duplicate_field("role_ids"));
                    }
                    field_role_ids = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberAddV2Arg {
            member_email: field_member_email.ok_or_else(|| ::serde::de::Error::missing_field("member_email"))?,
            member_given_name: field_member_given_name,
            member_surname: field_member_surname,
            member_external_id: field_member_external_id,
            member_persistent_id: field_member_persistent_id,
            send_welcome_email: field_send_welcome_email.unwrap_or(true),
            is_directory_restricted: field_is_directory_restricted,
            role_ids: field_role_ids,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member_email", &self.member_email)?;
        if let Some(val) = &self.member_given_name {
            s.serialize_field("member_given_name", val)?;
        }
        if let Some(val) = &self.member_surname {
            s.serialize_field("member_surname", val)?;
        }
        if let Some(val) = &self.member_external_id {
            s.serialize_field("member_external_id", val)?;
        }
        if let Some(val) = &self.member_persistent_id {
            s.serialize_field("member_persistent_id", val)?;
        }
        s.serialize_field("send_welcome_email", &self.send_welcome_email)?;
        if let Some(val) = &self.is_directory_restricted {
            s.serialize_field("is_directory_restricted", val)?;
        }
        if let Some(val) = &self.role_ids {
            s.serialize_field("role_ids", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddV2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberAddV2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddV2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberAddV2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberAddV2Arg", MEMBER_ADD_V2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddV2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberAddV2Arg", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Describes the result of attempting to add a single user to the team. 'success' is the only value
/// indicating that a user was indeed added to the team - the other values explain the type of
/// failure that occurred, and include the email of the user for which the operation has failed.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MemberAddV2Result {
    /// Team is already full. The organization has no available licenses.
    TeamLicenseLimit(super::common::EmailAddress),
    /// Team is already full. The free team member limit has been reached.
    FreeTeamMemberLimitReached(super::common::EmailAddress),
    /// User is already on this team. The provided email address is associated with a user who is
    /// already a member of (including in recoverable state) or invited to the team.
    UserAlreadyOnTeam(super::common::EmailAddress),
    /// User is already on another team. The provided email address is associated with a user that
    /// is already a member or invited to another team.
    UserOnAnotherTeam(super::common::EmailAddress),
    /// User is already paired.
    UserAlreadyPaired(super::common::EmailAddress),
    /// User migration has failed.
    UserMigrationFailed(super::common::EmailAddress),
    /// A user with the given external member ID already exists on the team (including in
    /// recoverable state).
    DuplicateExternalMemberId(super::common::EmailAddress),
    /// A user with the given persistent ID already exists on the team (including in recoverable
    /// state).
    DuplicateMemberPersistentId(super::common::EmailAddress),
    /// Persistent ID is only available to teams with persistent ID SAML configuration. Please
    /// contact Dropbox for more information.
    PersistentIdDisabled(super::common::EmailAddress),
    /// User creation has failed.
    UserCreationFailed(super::common::EmailAddress),
    /// Describes a user that was successfully added to the team.
    Success(TeamMemberInfoV2),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAddV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberAddV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAddV2Result structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team_license_limit" => {
                        match map.next_key()? {
                            Some("team_license_limit") => MemberAddV2Result::TeamLicenseLimit(map.next_value()?),
                            None => return Err(de::Error::missing_field("team_license_limit")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "free_team_member_limit_reached" => {
                        match map.next_key()? {
                            Some("free_team_member_limit_reached") => MemberAddV2Result::FreeTeamMemberLimitReached(map.next_value()?),
                            None => return Err(de::Error::missing_field("free_team_member_limit_reached")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_on_team" => {
                        match map.next_key()? {
                            Some("user_already_on_team") => MemberAddV2Result::UserAlreadyOnTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_on_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_on_another_team" => {
                        match map.next_key()? {
                            Some("user_on_another_team") => MemberAddV2Result::UserOnAnotherTeam(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_on_another_team")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_already_paired" => {
                        match map.next_key()? {
                            Some("user_already_paired") => MemberAddV2Result::UserAlreadyPaired(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_already_paired")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_migration_failed" => {
                        match map.next_key()? {
                            Some("user_migration_failed") => MemberAddV2Result::UserMigrationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_migration_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_external_member_id" => {
                        match map.next_key()? {
                            Some("duplicate_external_member_id") => MemberAddV2Result::DuplicateExternalMemberId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_external_member_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "duplicate_member_persistent_id" => {
                        match map.next_key()? {
                            Some("duplicate_member_persistent_id") => MemberAddV2Result::DuplicateMemberPersistentId(map.next_value()?),
                            None => return Err(de::Error::missing_field("duplicate_member_persistent_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "persistent_id_disabled" => {
                        match map.next_key()? {
                            Some("persistent_id_disabled") => MemberAddV2Result::PersistentIdDisabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("persistent_id_disabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "user_creation_failed" => {
                        match map.next_key()? {
                            Some("user_creation_failed") => MemberAddV2Result::UserCreationFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_creation_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "success" => MemberAddV2Result::Success(TeamMemberInfoV2::internal_deserialize(&mut map)?),
                    _ => MemberAddV2Result::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team_license_limit",
                                    "free_team_member_limit_reached",
                                    "user_already_on_team",
                                    "user_on_another_team",
                                    "user_already_paired",
                                    "user_migration_failed",
                                    "duplicate_external_member_id",
                                    "duplicate_member_persistent_id",
                                    "persistent_id_disabled",
                                    "user_creation_failed",
                                    "success",
                                    "other"];
        deserializer.deserialize_struct("MemberAddV2Result", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAddV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberAddV2Result::TeamLicenseLimit(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.serialize_field("team_license_limit", x)?;
                s.end()
            }
            MemberAddV2Result::FreeTeamMemberLimitReached(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "free_team_member_limit_reached")?;
                s.serialize_field("free_team_member_limit_reached", x)?;
                s.end()
            }
            MemberAddV2Result::UserAlreadyOnTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "user_already_on_team")?;
                s.serialize_field("user_already_on_team", x)?;
                s.end()
            }
            MemberAddV2Result::UserOnAnotherTeam(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "user_on_another_team")?;
                s.serialize_field("user_on_another_team", x)?;
                s.end()
            }
            MemberAddV2Result::UserAlreadyPaired(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "user_already_paired")?;
                s.serialize_field("user_already_paired", x)?;
                s.end()
            }
            MemberAddV2Result::UserMigrationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "user_migration_failed")?;
                s.serialize_field("user_migration_failed", x)?;
                s.end()
            }
            MemberAddV2Result::DuplicateExternalMemberId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "duplicate_external_member_id")?;
                s.serialize_field("duplicate_external_member_id", x)?;
                s.end()
            }
            MemberAddV2Result::DuplicateMemberPersistentId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "duplicate_member_persistent_id")?;
                s.serialize_field("duplicate_member_persistent_id", x)?;
                s.end()
            }
            MemberAddV2Result::PersistentIdDisabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "persistent_id_disabled")?;
                s.serialize_field("persistent_id_disabled", x)?;
                s.end()
            }
            MemberAddV2Result::UserCreationFailed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberAddV2Result", 2)?;
                s.serialize_field(".tag", "user_creation_failed")?;
                s.serialize_field("user_creation_failed", x)?;
                s.end()
            }
            MemberAddV2Result::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("MemberAddV2Result", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            MemberAddV2Result::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Information on devices of a team's member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberDevices {
    /// The member unique Id.
    pub team_member_id: String,
    /// List of web sessions made by this team member.
    pub web_sessions: Option<Vec<ActiveWebSession>>,
    /// List of desktop clients by this team member.
    pub desktop_clients: Option<Vec<DesktopClientSession>>,
    /// List of mobile clients by this team member.
    pub mobile_clients: Option<Vec<MobileClientSession>>,
}

impl MemberDevices {
    pub fn new(team_member_id: String) -> Self {
        MemberDevices {
            team_member_id,
            web_sessions: None,
            desktop_clients: None,
            mobile_clients: None,
        }
    }

    pub fn with_web_sessions(mut self, value: Vec<ActiveWebSession>) -> Self {
        self.web_sessions = Some(value);
        self
    }

    pub fn with_desktop_clients(mut self, value: Vec<DesktopClientSession>) -> Self {
        self.desktop_clients = Some(value);
        self
    }

    pub fn with_mobile_clients(mut self, value: Vec<MobileClientSession>) -> Self {
        self.mobile_clients = Some(value);
        self
    }
}

const MEMBER_DEVICES_FIELDS: &[&str] = &["team_member_id",
                                         "web_sessions",
                                         "desktop_clients",
                                         "mobile_clients"];
impl MemberDevices {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberDevices, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberDevices>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_web_sessions = None;
        let mut field_desktop_clients = None;
        let mut field_mobile_clients = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "web_sessions" => {
                    if field_web_sessions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("web_sessions"));
                    }
                    field_web_sessions = Some(map.next_value()?);
                }
                "desktop_clients" => {
                    if field_desktop_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("desktop_clients"));
                    }
                    field_desktop_clients = Some(map.next_value()?);
                }
                "mobile_clients" => {
                    if field_mobile_clients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mobile_clients"));
                    }
                    field_mobile_clients = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberDevices {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            web_sessions: field_web_sessions,
            desktop_clients: field_desktop_clients,
            mobile_clients: field_mobile_clients,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        if let Some(val) = &self.web_sessions {
            s.serialize_field("web_sessions", val)?;
        }
        if let Some(val) = &self.desktop_clients {
            s.serialize_field("desktop_clients", val)?;
        }
        if let Some(val) = &self.mobile_clients {
            s.serialize_field("mobile_clients", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberDevices {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberDevices;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberDevices struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberDevices::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberDevices", MEMBER_DEVICES_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberDevices {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberDevices", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information on linked applications of a team member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberLinkedApps {
    /// The member unique Id.
    pub team_member_id: String,
    /// List of third party applications linked by this team member.
    pub linked_api_apps: Vec<ApiApp>,
}

impl MemberLinkedApps {
    pub fn new(team_member_id: String, linked_api_apps: Vec<ApiApp>) -> Self {
        MemberLinkedApps {
            team_member_id,
            linked_api_apps,
        }
    }
}

const MEMBER_LINKED_APPS_FIELDS: &[&str] = &["team_member_id",
                                             "linked_api_apps"];
impl MemberLinkedApps {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberLinkedApps, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberLinkedApps>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_linked_api_apps = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "linked_api_apps" => {
                    if field_linked_api_apps.is_some() {
                        return Err(::serde::de::Error::duplicate_field("linked_api_apps"));
                    }
                    field_linked_api_apps = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberLinkedApps {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            linked_api_apps: field_linked_api_apps.ok_or_else(|| ::serde::de::Error::missing_field("linked_api_apps"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("linked_api_apps", &self.linked_api_apps)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberLinkedApps {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberLinkedApps;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberLinkedApps struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberLinkedApps::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberLinkedApps", MEMBER_LINKED_APPS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberLinkedApps {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberLinkedApps", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Basic member profile.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberProfile {
    /// ID of user as a member of a team.
    pub team_member_id: super::team_common::TeamMemberId,
    /// Email address of user.
    pub email: String,
    /// Is true if the user's email is verified to be owned by the user.
    pub email_verified: bool,
    /// The user's status as a member of a specific team.
    pub status: TeamMemberStatus,
    /// Representations for a person's name.
    pub name: super::users::Name,
    /// The user's membership type: full (normal team member) vs limited (does not use a license; no
    /// access to the team's shared quota).
    pub membership_type: TeamMembershipType,
    /// External ID that a team can attach to the user. An application using the API may find it
    /// easier to use their own IDs instead of Dropbox IDs like account_id or team_member_id.
    pub external_id: Option<String>,
    /// A user's account identifier.
    pub account_id: Option<super::users_common::AccountId>,
    /// Secondary emails of a user.
    pub secondary_emails: Option<Vec<super::secondary_emails::SecondaryEmail>>,
    /// The date and time the user was invited to the team (contains value only when the member's
    /// status matches [`TeamMemberStatus::Invited`](TeamMemberStatus::Invited)).
    pub invited_on: Option<super::common::DropboxTimestamp>,
    /// The date and time the user joined as a member of a specific team.
    pub joined_on: Option<super::common::DropboxTimestamp>,
    /// The date and time the user was suspended from the team (contains value only when the
    /// member's status matches [`TeamMemberStatus::Suspended`](TeamMemberStatus::Suspended)).
    pub suspended_on: Option<super::common::DropboxTimestamp>,
    /// Persistent ID that a team can attach to the user. The persistent ID is unique ID to be used
    /// for SAML authentication.
    pub persistent_id: Option<String>,
    /// Whether the user is a directory restricted user.
    pub is_directory_restricted: Option<bool>,
    /// URL for the photo representing the user, if one is set.
    pub profile_photo_url: Option<String>,
}

impl MemberProfile {
    pub fn new(
        team_member_id: super::team_common::TeamMemberId,
        email: String,
        email_verified: bool,
        status: TeamMemberStatus,
        name: super::users::Name,
        membership_type: TeamMembershipType,
    ) -> Self {
        MemberProfile {
            team_member_id,
            email,
            email_verified,
            status,
            name,
            membership_type,
            external_id: None,
            account_id: None,
            secondary_emails: None,
            invited_on: None,
            joined_on: None,
            suspended_on: None,
            persistent_id: None,
            is_directory_restricted: None,
            profile_photo_url: None,
        }
    }

    pub fn with_external_id(mut self, value: String) -> Self {
        self.external_id = Some(value);
        self
    }

    pub fn with_account_id(mut self, value: super::users_common::AccountId) -> Self {
        self.account_id = Some(value);
        self
    }

    pub fn with_secondary_emails(
        mut self,
        value: Vec<super::secondary_emails::SecondaryEmail>,
    ) -> Self {
        self.secondary_emails = Some(value);
        self
    }

    pub fn with_invited_on(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.invited_on = Some(value);
        self
    }

    pub fn with_joined_on(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.joined_on = Some(value);
        self
    }

    pub fn with_suspended_on(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.suspended_on = Some(value);
        self
    }

    pub fn with_persistent_id(mut self, value: String) -> Self {
        self.persistent_id = Some(value);
        self
    }

    pub fn with_is_directory_restricted(mut self, value: bool) -> Self {
        self.is_directory_restricted = Some(value);
        self
    }

    pub fn with_profile_photo_url(mut self, value: String) -> Self {
        self.profile_photo_url = Some(value);
        self
    }
}

const MEMBER_PROFILE_FIELDS: &[&str] = &["team_member_id",
                                         "email",
                                         "email_verified",
                                         "status",
                                         "name",
                                         "membership_type",
                                         "external_id",
                                         "account_id",
                                         "secondary_emails",
                                         "invited_on",
                                         "joined_on",
                                         "suspended_on",
                                         "persistent_id",
                                         "is_directory_restricted",
                                         "profile_photo_url"];
impl MemberProfile {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberProfile, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberProfile>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_email = None;
        let mut field_email_verified = None;
        let mut field_status = None;
        let mut field_name = None;
        let mut field_membership_type = None;
        let mut field_external_id = None;
        let mut field_account_id = None;
        let mut field_secondary_emails = None;
        let mut field_invited_on = None;
        let mut field_joined_on = None;
        let mut field_suspended_on = None;
        let mut field_persistent_id = None;
        let mut field_is_directory_restricted = None;
        let mut field_profile_photo_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "email" => {
                    if field_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email"));
                    }
                    field_email = Some(map.next_value()?);
                }
                "email_verified" => {
                    if field_email_verified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email_verified"));
                    }
                    field_email_verified = Some(map.next_value()?);
                }
                "status" => {
                    if field_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("status"));
                    }
                    field_status = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "membership_type" => {
                    if field_membership_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("membership_type"));
                    }
                    field_membership_type = Some(map.next_value()?);
                }
                "external_id" => {
                    if field_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("external_id"));
                    }
                    field_external_id = Some(map.next_value()?);
                }
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                "secondary_emails" => {
                    if field_secondary_emails.is_some() {
                        return Err(::serde::de::Error::duplicate_field("secondary_emails"));
                    }
                    field_secondary_emails = Some(map.next_value()?);
                }
                "invited_on" => {
                    if field_invited_on.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invited_on"));
                    }
                    field_invited_on = Some(map.next_value()?);
                }
                "joined_on" => {
                    if field_joined_on.is_some() {
                        return Err(::serde::de::Error::duplicate_field("joined_on"));
                    }
                    field_joined_on = Some(map.next_value()?);
                }
                "suspended_on" => {
                    if field_suspended_on.is_some() {
                        return Err(::serde::de::Error::duplicate_field("suspended_on"));
                    }
                    field_suspended_on = Some(map.next_value()?);
                }
                "persistent_id" => {
                    if field_persistent_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("persistent_id"));
                    }
                    field_persistent_id = Some(map.next_value()?);
                }
                "is_directory_restricted" => {
                    if field_is_directory_restricted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_directory_restricted"));
                    }
                    field_is_directory_restricted = Some(map.next_value()?);
                }
                "profile_photo_url" => {
                    if field_profile_photo_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("profile_photo_url"));
                    }
                    field_profile_photo_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberProfile {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            email: field_email.ok_or_else(|| ::serde::de::Error::missing_field("email"))?,
            email_verified: field_email_verified.ok_or_else(|| ::serde::de::Error::missing_field("email_verified"))?,
            status: field_status.ok_or_else(|| ::serde::de::Error::missing_field("status"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            membership_type: field_membership_type.ok_or_else(|| ::serde::de::Error::missing_field("membership_type"))?,
            external_id: field_external_id,
            account_id: field_account_id,
            secondary_emails: field_secondary_emails,
            invited_on: field_invited_on,
            joined_on: field_joined_on,
            suspended_on: field_suspended_on,
            persistent_id: field_persistent_id,
            is_directory_restricted: field_is_directory_restricted,
            profile_photo_url: field_profile_photo_url,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("email", &self.email)?;
        s.serialize_field("email_verified", &self.email_verified)?;
        s.serialize_field("status", &self.status)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("membership_type", &self.membership_type)?;
        if let Some(val) = &self.external_id {
            s.serialize_field("external_id", val)?;
        }
        if let Some(val) = &self.account_id {
            s.serialize_field("account_id", val)?;
        }
        if let Some(val) = &self.secondary_emails {
            s.serialize_field("secondary_emails", val)?;
        }
        if let Some(val) = &self.invited_on {
            s.serialize_field("invited_on", val)?;
        }
        if let Some(val) = &self.joined_on {
            s.serialize_field("joined_on", val)?;
        }
        if let Some(val) = &self.suspended_on {
            s.serialize_field("suspended_on", val)?;
        }
        if let Some(val) = &self.persistent_id {
            s.serialize_field("persistent_id", val)?;
        }
        if let Some(val) = &self.is_directory_restricted {
            s.serialize_field("is_directory_restricted", val)?;
        }
        if let Some(val) = &self.profile_photo_url {
            s.serialize_field("profile_photo_url", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberProfile {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberProfile;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberProfile struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberProfile::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberProfile", MEMBER_PROFILE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberProfile {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberProfile", 15)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MemberSelectorError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
}

impl<'de> ::serde::de::Deserialize<'de> for MemberSelectorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberSelectorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberSelectorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MemberSelectorError::UserNotFound,
                    "user_not_in_team" => MemberSelectorError::UserNotInTeam,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team"];
        deserializer.deserialize_struct("MemberSelectorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberSelectorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberSelectorError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MemberSelectorError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MemberSelectorError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MemberSelectorError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for MemberSelectorError {
}

impl ::std::fmt::Display for MemberSelectorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MemberSelectorError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MemberSelectorError::UserNotInTeam => f.write_str("The user is not a member of the team."),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersAddArg {
    /// Details of new members to be added to the team.
    pub new_members: Vec<MemberAddArg>,
    /// Whether to force the add to happen asynchronously.
    pub force_async: bool,
}

impl MembersAddArg {
    pub fn new(new_members: Vec<MemberAddArg>) -> Self {
        MembersAddArg {
            new_members,
            force_async: false,
        }
    }

    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }
}

const MEMBERS_ADD_ARG_FIELDS: &[&str] = &["new_members",
                                          "force_async"];
impl MembersAddArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersAddArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersAddArg>, V::Error> {
        let mut field_new_members = None;
        let mut field_force_async = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_members" => {
                    if field_new_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_members"));
                    }
                    field_new_members = Some(map.next_value()?);
                }
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersAddArg {
            new_members: field_new_members.ok_or_else(|| ::serde::de::Error::missing_field("new_members"))?,
            force_async: field_force_async.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_members", &self.new_members)?;
        s.serialize_field("force_async", &self.force_async)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersAddArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersAddArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersAddArg", MEMBERS_ADD_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersAddArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq, Default)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersAddArgBase {
    /// Whether to force the add to happen asynchronously.
    pub force_async: bool,
}

impl MembersAddArgBase {
    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }
}

const MEMBERS_ADD_ARG_BASE_FIELDS: &[&str] = &["force_async"];
impl MembersAddArgBase {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<MembersAddArgBase, V::Error> {
        let mut field_force_async = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = MembersAddArgBase {
            force_async: field_force_async.unwrap_or(false),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("force_async", &self.force_async)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddArgBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersAddArgBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddArgBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersAddArgBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersAddArgBase", MEMBERS_ADD_ARG_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddArgBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersAddArgBase", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MembersAddJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The asynchronous job has finished. For each member that was specified in the parameter
    /// [`MembersAddArg`](MembersAddArg) that was provided to [`members_add()`](members_add), a
    /// corresponding item is returned in this list.
    Complete(Vec<MemberAddResult>),
    /// The asynchronous job returned an error. The string contains an error message.
    Failed(String),
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersAddJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => MembersAddJobStatus::InProgress,
                    "complete" => {
                        match map.next_key()? {
                            Some("complete") => MembersAddJobStatus::Complete(map.next_value()?),
                            None => return Err(de::Error::missing_field("complete")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => MembersAddJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("MembersAddJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersAddJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("MembersAddJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            MembersAddJobStatus::Complete(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddJobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                s.serialize_field("complete", x)?;
                s.end()
            }
            MembersAddJobStatus::Failed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersAddJobStatusV2Result {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The asynchronous job has finished. For each member that was specified in the parameter
    /// [`MembersAddArg`](MembersAddArg) that was provided to [`members_add_v2()`](members_add_v2),
    /// a corresponding item is returned in this list.
    Complete(Vec<MemberAddV2Result>),
    /// The asynchronous job returned an error. The string contains an error message.
    Failed(String),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddJobStatusV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersAddJobStatusV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddJobStatusV2Result structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => MembersAddJobStatusV2Result::InProgress,
                    "complete" => {
                        match map.next_key()? {
                            Some("complete") => MembersAddJobStatusV2Result::Complete(map.next_value()?),
                            None => return Err(de::Error::missing_field("complete")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => MembersAddJobStatusV2Result::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => MembersAddJobStatusV2Result::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed",
                                    "other"];
        deserializer.deserialize_struct("MembersAddJobStatusV2Result", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddJobStatusV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersAddJobStatusV2Result::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("MembersAddJobStatusV2Result", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            MembersAddJobStatusV2Result::Complete(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddJobStatusV2Result", 2)?;
                s.serialize_field(".tag", "complete")?;
                s.serialize_field("complete", x)?;
                s.end()
            }
            MembersAddJobStatusV2Result::Failed(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddJobStatusV2Result", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
            MembersAddJobStatusV2Result::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MembersAddLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(Vec<MemberAddResult>),
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersAddLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => MembersAddLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => {
                        match map.next_key()? {
                            Some("complete") => MembersAddLaunch::Complete(map.next_value()?),
                            None => return Err(de::Error::missing_field("complete")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete"];
        deserializer.deserialize_struct("MembersAddLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersAddLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            MembersAddLaunch::Complete(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddLaunch", 2)?;
                s.serialize_field(".tag", "complete")?;
                s.serialize_field("complete", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersAddLaunchV2Result {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(Vec<MemberAddV2Result>),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddLaunchV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersAddLaunchV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddLaunchV2Result structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => MembersAddLaunchV2Result::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => {
                        match map.next_key()? {
                            Some("complete") => MembersAddLaunchV2Result::Complete(map.next_value()?),
                            None => return Err(de::Error::missing_field("complete")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => MembersAddLaunchV2Result::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete",
                                    "other"];
        deserializer.deserialize_struct("MembersAddLaunchV2Result", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddLaunchV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersAddLaunchV2Result::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddLaunchV2Result", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            MembersAddLaunchV2Result::Complete(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersAddLaunchV2Result", 2)?;
                s.serialize_field(".tag", "complete")?;
                s.serialize_field("complete", x)?;
                s.end()
            }
            MembersAddLaunchV2Result::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersAddV2Arg {
    /// Details of new members to be added to the team.
    pub new_members: Vec<MemberAddV2Arg>,
    /// Whether to force the add to happen asynchronously.
    pub force_async: bool,
}

impl MembersAddV2Arg {
    pub fn new(new_members: Vec<MemberAddV2Arg>) -> Self {
        MembersAddV2Arg {
            new_members,
            force_async: false,
        }
    }

    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }
}

const MEMBERS_ADD_V2_ARG_FIELDS: &[&str] = &["new_members",
                                             "force_async"];
impl MembersAddV2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersAddV2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersAddV2Arg>, V::Error> {
        let mut field_new_members = None;
        let mut field_force_async = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_members" => {
                    if field_new_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_members"));
                    }
                    field_new_members = Some(map.next_value()?);
                }
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersAddV2Arg {
            new_members: field_new_members.ok_or_else(|| ::serde::de::Error::missing_field("new_members"))?,
            force_async: field_force_async.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_members", &self.new_members)?;
        s.serialize_field("force_async", &self.force_async)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersAddV2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersAddV2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersAddV2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersAddV2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersAddV2Arg", MEMBERS_ADD_V2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersAddV2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersAddV2Arg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersDataTransferArg {
    /// Identity of user to remove/suspend/have their files moved.
    pub user: UserSelectorArg,
    /// Files from the deleted member account will be transferred to this user.
    pub transfer_dest_id: UserSelectorArg,
    /// Errors during the transfer process will be sent via email to this user.
    pub transfer_admin_id: UserSelectorArg,
}

impl MembersDataTransferArg {
    pub fn new(
        user: UserSelectorArg,
        transfer_dest_id: UserSelectorArg,
        transfer_admin_id: UserSelectorArg,
    ) -> Self {
        MembersDataTransferArg {
            user,
            transfer_dest_id,
            transfer_admin_id,
        }
    }
}

const MEMBERS_DATA_TRANSFER_ARG_FIELDS: &[&str] = &["user",
                                                    "transfer_dest_id",
                                                    "transfer_admin_id"];
impl MembersDataTransferArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersDataTransferArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersDataTransferArg>, V::Error> {
        let mut field_user = None;
        let mut field_transfer_dest_id = None;
        let mut field_transfer_admin_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "transfer_dest_id" => {
                    if field_transfer_dest_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("transfer_dest_id"));
                    }
                    field_transfer_dest_id = Some(map.next_value()?);
                }
                "transfer_admin_id" => {
                    if field_transfer_admin_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("transfer_admin_id"));
                    }
                    field_transfer_admin_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersDataTransferArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            transfer_dest_id: field_transfer_dest_id.ok_or_else(|| ::serde::de::Error::missing_field("transfer_dest_id"))?,
            transfer_admin_id: field_transfer_admin_id.ok_or_else(|| ::serde::de::Error::missing_field("transfer_admin_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("transfer_dest_id", &self.transfer_dest_id)?;
        s.serialize_field("transfer_admin_id", &self.transfer_admin_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDataTransferArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersDataTransferArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDataTransferArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersDataTransferArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersDataTransferArg", MEMBERS_DATA_TRANSFER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDataTransferArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersDataTransferArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersDeactivateArg {
    /// Identity of user to remove/suspend/have their files moved.
    pub user: UserSelectorArg,
    /// If provided, controls if the user's data will be deleted on their linked devices.
    pub wipe_data: bool,
}

impl MembersDeactivateArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersDeactivateArg {
            user,
            wipe_data: true,
        }
    }

    pub fn with_wipe_data(mut self, value: bool) -> Self {
        self.wipe_data = value;
        self
    }
}

const MEMBERS_DEACTIVATE_ARG_FIELDS: &[&str] = &["user",
                                                 "wipe_data"];
impl MembersDeactivateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersDeactivateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersDeactivateArg>, V::Error> {
        let mut field_user = None;
        let mut field_wipe_data = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "wipe_data" => {
                    if field_wipe_data.is_some() {
                        return Err(::serde::de::Error::duplicate_field("wipe_data"));
                    }
                    field_wipe_data = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersDeactivateArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            wipe_data: field_wipe_data.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("wipe_data", &self.wipe_data)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDeactivateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersDeactivateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDeactivateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersDeactivateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersDeactivateArg", MEMBERS_DEACTIVATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDeactivateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersDeactivateArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersDeactivateBaseArg {
    /// Identity of user to remove/suspend/have their files moved.
    pub user: UserSelectorArg,
}

impl MembersDeactivateBaseArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersDeactivateBaseArg {
            user,
        }
    }
}

const MEMBERS_DEACTIVATE_BASE_ARG_FIELDS: &[&str] = &["user"];
impl MembersDeactivateBaseArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersDeactivateBaseArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersDeactivateBaseArg>, V::Error> {
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersDeactivateBaseArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDeactivateBaseArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersDeactivateBaseArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDeactivateBaseArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersDeactivateBaseArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersDeactivateBaseArg", MEMBERS_DEACTIVATE_BASE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDeactivateBaseArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersDeactivateBaseArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersDeactivateError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDeactivateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersDeactivateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDeactivateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersDeactivateError::UserNotFound,
                    "user_not_in_team" => MembersDeactivateError::UserNotInTeam,
                    _ => MembersDeactivateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other"];
        deserializer.deserialize_struct("MembersDeactivateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDeactivateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersDeactivateError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersDeactivateError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersDeactivateError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersDeactivateError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersDeactivateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersDeactivateError {
}

impl ::std::fmt::Display for MembersDeactivateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersDeactivateError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersDeactivateError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersDeleteProfilePhotoArg {
    /// Identity of the user whose profile photo will be deleted.
    pub user: UserSelectorArg,
}

impl MembersDeleteProfilePhotoArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersDeleteProfilePhotoArg {
            user,
        }
    }
}

const MEMBERS_DELETE_PROFILE_PHOTO_ARG_FIELDS: &[&str] = &["user"];
impl MembersDeleteProfilePhotoArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersDeleteProfilePhotoArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersDeleteProfilePhotoArg>, V::Error> {
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersDeleteProfilePhotoArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDeleteProfilePhotoArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersDeleteProfilePhotoArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDeleteProfilePhotoArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersDeleteProfilePhotoArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersDeleteProfilePhotoArg", MEMBERS_DELETE_PROFILE_PHOTO_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDeleteProfilePhotoArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersDeleteProfilePhotoArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersDeleteProfilePhotoError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Modifying deleted users is not allowed.
    SetProfileDisallowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersDeleteProfilePhotoError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersDeleteProfilePhotoError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersDeleteProfilePhotoError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersDeleteProfilePhotoError::UserNotFound,
                    "user_not_in_team" => MembersDeleteProfilePhotoError::UserNotInTeam,
                    "set_profile_disallowed" => MembersDeleteProfilePhotoError::SetProfileDisallowed,
                    _ => MembersDeleteProfilePhotoError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "set_profile_disallowed",
                                    "other"];
        deserializer.deserialize_struct("MembersDeleteProfilePhotoError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersDeleteProfilePhotoError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersDeleteProfilePhotoError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersDeleteProfilePhotoError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersDeleteProfilePhotoError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersDeleteProfilePhotoError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersDeleteProfilePhotoError::SetProfileDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("MembersDeleteProfilePhotoError", 1)?;
                s.serialize_field(".tag", "set_profile_disallowed")?;
                s.end()
            }
            MembersDeleteProfilePhotoError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersDeleteProfilePhotoError {
}

impl ::std::fmt::Display for MembersDeleteProfilePhotoError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersDeleteProfilePhotoError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersDeleteProfilePhotoError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersDeleteProfilePhotoError::SetProfileDisallowed => f.write_str("Modifying deleted users is not allowed."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Available TeamMemberRole for the connected team. To be used with
/// [`members_set_admin_permissions_v2()`](members_set_admin_permissions_v2).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersGetAvailableTeamMemberRolesResult {
    /// Available roles.
    pub roles: Vec<TeamMemberRole>,
}

impl MembersGetAvailableTeamMemberRolesResult {
    pub fn new(roles: Vec<TeamMemberRole>) -> Self {
        MembersGetAvailableTeamMemberRolesResult {
            roles,
        }
    }
}

const MEMBERS_GET_AVAILABLE_TEAM_MEMBER_ROLES_RESULT_FIELDS: &[&str] = &["roles"];
impl MembersGetAvailableTeamMemberRolesResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersGetAvailableTeamMemberRolesResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersGetAvailableTeamMemberRolesResult>, V::Error> {
        let mut field_roles = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "roles" => {
                    if field_roles.is_some() {
                        return Err(::serde::de::Error::duplicate_field("roles"));
                    }
                    field_roles = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersGetAvailableTeamMemberRolesResult {
            roles: field_roles.ok_or_else(|| ::serde::de::Error::missing_field("roles"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("roles", &self.roles)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetAvailableTeamMemberRolesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersGetAvailableTeamMemberRolesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetAvailableTeamMemberRolesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersGetAvailableTeamMemberRolesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersGetAvailableTeamMemberRolesResult", MEMBERS_GET_AVAILABLE_TEAM_MEMBER_ROLES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetAvailableTeamMemberRolesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersGetAvailableTeamMemberRolesResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersGetInfoArgs {
    /// List of team members.
    pub members: Vec<UserSelectorArg>,
}

impl MembersGetInfoArgs {
    pub fn new(members: Vec<UserSelectorArg>) -> Self {
        MembersGetInfoArgs {
            members,
        }
    }
}

const MEMBERS_GET_INFO_ARGS_FIELDS: &[&str] = &["members"];
impl MembersGetInfoArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersGetInfoArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersGetInfoArgs>, V::Error> {
        let mut field_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersGetInfoArgs {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersGetInfoArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersGetInfoArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersGetInfoArgs", MEMBERS_GET_INFO_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersGetInfoArgs", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}


#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersGetInfoError {
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersGetInfoError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                // open enum with no defined variants
                let _ = tag;
                crate::eat_json_fields(&mut map)?;
                Ok(MembersGetInfoError::Other)
            }
        }
        const VARIANTS: &[&str] = &["other"];
        deserializer.deserialize_struct("MembersGetInfoError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        #![allow(unused_variables)]
        Err(::serde::ser::Error::custom("cannot serialize an open union with no defined variants"))
    }
}

impl ::std::error::Error for MembersGetInfoError {
}

impl ::std::fmt::Display for MembersGetInfoError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Describes a result obtained for a single user whose id was specified in the parameter of
/// [`members_get_info()`](members_get_info).
#[derive(Debug, Clone, PartialEq)]
pub enum MembersGetInfoItem {
    /// An ID that was provided as a parameter to [`members_get_info()`](members_get_info) or
    /// [`members_get_info_v2()`](members_get_info_v2), and did not match a corresponding user. This
    /// might be a team_member_id, an email, or an external ID, depending on how the method was
    /// called.
    IdNotFound(String),
    /// Info about a team member.
    MemberInfo(TeamMemberInfo),
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoItem {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersGetInfoItem;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoItem structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "id_not_found" => {
                        match map.next_key()? {
                            Some("id_not_found") => MembersGetInfoItem::IdNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("id_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "member_info" => MembersGetInfoItem::MemberInfo(TeamMemberInfo::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["id_not_found",
                                    "member_info"];
        deserializer.deserialize_struct("MembersGetInfoItem", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoItem {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersGetInfoItem::IdNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersGetInfoItem", 2)?;
                s.serialize_field(".tag", "id_not_found")?;
                s.serialize_field("id_not_found", x)?;
                s.end()
            }
            MembersGetInfoItem::MemberInfo(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("MembersGetInfoItem", 3)?;
                s.serialize_field(".tag", "member_info")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MembersGetInfoItemBase {
    /// An ID that was provided as a parameter to [`members_get_info()`](members_get_info) or
    /// [`members_get_info_v2()`](members_get_info_v2), and did not match a corresponding user. This
    /// might be a team_member_id, an email, or an external ID, depending on how the method was
    /// called.
    IdNotFound(String),
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoItemBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersGetInfoItemBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoItemBase structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "id_not_found" => {
                        match map.next_key()? {
                            Some("id_not_found") => MembersGetInfoItemBase::IdNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("id_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["id_not_found"];
        deserializer.deserialize_struct("MembersGetInfoItemBase", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoItemBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersGetInfoItemBase::IdNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersGetInfoItemBase", 2)?;
                s.serialize_field(".tag", "id_not_found")?;
                s.serialize_field("id_not_found", x)?;
                s.end()
            }
        }
    }
}

/// Describes a result obtained for a single user whose id was specified in the parameter of
/// [`members_get_info_v2()`](members_get_info_v2).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersGetInfoItemV2 {
    /// An ID that was provided as a parameter to [`members_get_info()`](members_get_info) or
    /// [`members_get_info_v2()`](members_get_info_v2), and did not match a corresponding user. This
    /// might be a team_member_id, an email, or an external ID, depending on how the method was
    /// called.
    IdNotFound(String),
    /// Info about a team member.
    MemberInfo(TeamMemberInfoV2),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoItemV2 {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersGetInfoItemV2;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoItemV2 structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "id_not_found" => {
                        match map.next_key()? {
                            Some("id_not_found") => MembersGetInfoItemV2::IdNotFound(map.next_value()?),
                            None => return Err(de::Error::missing_field("id_not_found")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "member_info" => MembersGetInfoItemV2::MemberInfo(TeamMemberInfoV2::internal_deserialize(&mut map)?),
                    _ => MembersGetInfoItemV2::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["id_not_found",
                                    "member_info",
                                    "other"];
        deserializer.deserialize_struct("MembersGetInfoItemV2", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoItemV2 {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersGetInfoItemV2::IdNotFound(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MembersGetInfoItemV2", 2)?;
                s.serialize_field(".tag", "id_not_found")?;
                s.serialize_field("id_not_found", x)?;
                s.end()
            }
            MembersGetInfoItemV2::MemberInfo(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("MembersGetInfoItemV2", 3)?;
                s.serialize_field(".tag", "member_info")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            MembersGetInfoItemV2::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersGetInfoV2Arg {
    /// List of team members.
    pub members: Vec<UserSelectorArg>,
}

impl MembersGetInfoV2Arg {
    pub fn new(members: Vec<UserSelectorArg>) -> Self {
        MembersGetInfoV2Arg {
            members,
        }
    }
}

const MEMBERS_GET_INFO_V2_ARG_FIELDS: &[&str] = &["members"];
impl MembersGetInfoV2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersGetInfoV2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersGetInfoV2Arg>, V::Error> {
        let mut field_members = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersGetInfoV2Arg {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoV2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersGetInfoV2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoV2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersGetInfoV2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersGetInfoV2Arg", MEMBERS_GET_INFO_V2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoV2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersGetInfoV2Arg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersGetInfoV2Result {
    /// List of team members info.
    pub members_info: Vec<MembersGetInfoItemV2>,
}

impl MembersGetInfoV2Result {
    pub fn new(members_info: Vec<MembersGetInfoItemV2>) -> Self {
        MembersGetInfoV2Result {
            members_info,
        }
    }
}

const MEMBERS_GET_INFO_V2_RESULT_FIELDS: &[&str] = &["members_info"];
impl MembersGetInfoV2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersGetInfoV2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersGetInfoV2Result>, V::Error> {
        let mut field_members_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members_info" => {
                    if field_members_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members_info"));
                    }
                    field_members_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersGetInfoV2Result {
            members_info: field_members_info.ok_or_else(|| ::serde::de::Error::missing_field("members_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members_info", &self.members_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersGetInfoV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersGetInfoV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersGetInfoV2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersGetInfoV2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersGetInfoV2Result", MEMBERS_GET_INFO_V2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersGetInfoV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersGetInfoV2Result", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersInfo {
    /// Team member IDs of the users under this hold.
    pub team_member_ids: Vec<super::team_common::TeamMemberId>,
    /// The number of permanently deleted users that were under this hold.
    pub permanently_deleted_users: u64,
}

impl MembersInfo {
    pub fn new(
        team_member_ids: Vec<super::team_common::TeamMemberId>,
        permanently_deleted_users: u64,
    ) -> Self {
        MembersInfo {
            team_member_ids,
            permanently_deleted_users,
        }
    }
}

const MEMBERS_INFO_FIELDS: &[&str] = &["team_member_ids",
                                       "permanently_deleted_users"];
impl MembersInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersInfo>, V::Error> {
        let mut field_team_member_ids = None;
        let mut field_permanently_deleted_users = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_ids" => {
                    if field_team_member_ids.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_ids"));
                    }
                    field_team_member_ids = Some(map.next_value()?);
                }
                "permanently_deleted_users" => {
                    if field_permanently_deleted_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permanently_deleted_users"));
                    }
                    field_permanently_deleted_users = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersInfo {
            team_member_ids: field_team_member_ids.ok_or_else(|| ::serde::de::Error::missing_field("team_member_ids"))?,
            permanently_deleted_users: field_permanently_deleted_users.ok_or_else(|| ::serde::de::Error::missing_field("permanently_deleted_users"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_ids", &self.team_member_ids)?;
        s.serialize_field("permanently_deleted_users", &self.permanently_deleted_users)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersInfo", MEMBERS_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersInfo", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersListArg {
    /// Number of results to return per call.
    pub limit: u32,
    /// Whether to return removed members.
    pub include_removed: bool,
}

impl Default for MembersListArg {
    fn default() -> Self {
        MembersListArg {
            limit: 1000,
            include_removed: false,
        }
    }
}

impl MembersListArg {
    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }

    pub fn with_include_removed(mut self, value: bool) -> Self {
        self.include_removed = value;
        self
    }
}

const MEMBERS_LIST_ARG_FIELDS: &[&str] = &["limit",
                                           "include_removed"];
impl MembersListArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<MembersListArg, V::Error> {
        let mut field_limit = None;
        let mut field_include_removed = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                "include_removed" => {
                    if field_include_removed.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_removed"));
                    }
                    field_include_removed = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = MembersListArg {
            limit: field_limit.unwrap_or(1000),
            include_removed: field_include_removed.unwrap_or(false),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        s.serialize_field("include_removed", &self.include_removed)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersListArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersListArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersListArg", MEMBERS_LIST_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersListArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersListContinueArg {
    /// Indicates from what point to get the next set of members.
    pub cursor: String,
}

impl MembersListContinueArg {
    pub fn new(cursor: String) -> Self {
        MembersListContinueArg {
            cursor,
        }
    }
}

const MEMBERS_LIST_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl MembersListContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersListContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersListContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersListContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersListContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersListContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersListContinueArg", MEMBERS_LIST_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersListContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersListContinueError {
    /// The cursor is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersListContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_cursor" => MembersListContinueError::InvalidCursor,
                    _ => MembersListContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("MembersListContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersListContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("MembersListContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            MembersListContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersListContinueError {
}

impl ::std::fmt::Display for MembersListContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersListContinueError::InvalidCursor => f.write_str("The cursor is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}


#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersListError {
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersListError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                // open enum with no defined variants
                let _ = tag;
                crate::eat_json_fields(&mut map)?;
                Ok(MembersListError::Other)
            }
        }
        const VARIANTS: &[&str] = &["other"];
        deserializer.deserialize_struct("MembersListError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        #![allow(unused_variables)]
        Err(::serde::ser::Error::custom("cannot serialize an open union with no defined variants"))
    }
}

impl ::std::error::Error for MembersListError {
}

impl ::std::fmt::Display for MembersListError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersListResult {
    /// List of team members.
    pub members: Vec<TeamMemberInfo>,
    /// Pass the cursor into [`members_list_continue()`](members_list_continue) to obtain the
    /// additional members.
    pub cursor: String,
    /// Is true if there are additional team members that have not been returned yet. An additional
    /// call to [`members_list_continue()`](members_list_continue) can retrieve them.
    pub has_more: bool,
}

impl MembersListResult {
    pub fn new(members: Vec<TeamMemberInfo>, cursor: String, has_more: bool) -> Self {
        MembersListResult {
            members,
            cursor,
            has_more,
        }
    }
}

const MEMBERS_LIST_RESULT_FIELDS: &[&str] = &["members",
                                              "cursor",
                                              "has_more"];
impl MembersListResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersListResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersListResult>, V::Error> {
        let mut field_members = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersListResult {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersListResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersListResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersListResult", MEMBERS_LIST_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersListResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersListV2Result {
    /// List of team members.
    pub members: Vec<TeamMemberInfoV2>,
    /// Pass the cursor into [`members_list_continue_v2()`](members_list_continue_v2) to obtain the
    /// additional members.
    pub cursor: String,
    /// Is true if there are additional team members that have not been returned yet. An additional
    /// call to [`members_list_continue_v2()`](members_list_continue_v2) can retrieve them.
    pub has_more: bool,
}

impl MembersListV2Result {
    pub fn new(members: Vec<TeamMemberInfoV2>, cursor: String, has_more: bool) -> Self {
        MembersListV2Result {
            members,
            cursor,
            has_more,
        }
    }
}

const MEMBERS_LIST_V2_RESULT_FIELDS: &[&str] = &["members",
                                                 "cursor",
                                                 "has_more"];
impl MembersListV2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersListV2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersListV2Result>, V::Error> {
        let mut field_members = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersListV2Result {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersListV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersListV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersListV2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersListV2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersListV2Result", MEMBERS_LIST_V2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersListV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersListV2Result", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersRecoverArg {
    /// Identity of user to recover.
    pub user: UserSelectorArg,
}

impl MembersRecoverArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersRecoverArg {
            user,
        }
    }
}

const MEMBERS_RECOVER_ARG_FIELDS: &[&str] = &["user"];
impl MembersRecoverArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersRecoverArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersRecoverArg>, V::Error> {
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersRecoverArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersRecoverArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersRecoverArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersRecoverArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersRecoverArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersRecoverArg", MEMBERS_RECOVER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersRecoverArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersRecoverArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersRecoverError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not recoverable.
    UserUnrecoverable,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Team is full. The organization has no available licenses.
    TeamLicenseLimit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersRecoverError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersRecoverError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersRecoverError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersRecoverError::UserNotFound,
                    "user_unrecoverable" => MembersRecoverError::UserUnrecoverable,
                    "user_not_in_team" => MembersRecoverError::UserNotInTeam,
                    "team_license_limit" => MembersRecoverError::TeamLicenseLimit,
                    _ => MembersRecoverError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_unrecoverable",
                                    "user_not_in_team",
                                    "team_license_limit",
                                    "other"];
        deserializer.deserialize_struct("MembersRecoverError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersRecoverError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersRecoverError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersRecoverError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersRecoverError::UserUnrecoverable => {
                // unit
                let mut s = serializer.serialize_struct("MembersRecoverError", 1)?;
                s.serialize_field(".tag", "user_unrecoverable")?;
                s.end()
            }
            MembersRecoverError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersRecoverError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersRecoverError::TeamLicenseLimit => {
                // unit
                let mut s = serializer.serialize_struct("MembersRecoverError", 1)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.end()
            }
            MembersRecoverError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersRecoverError {
}

impl ::std::fmt::Display for MembersRecoverError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersRecoverError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersRecoverError::UserUnrecoverable => f.write_str("The user is not recoverable."),
            MembersRecoverError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersRecoverError::TeamLicenseLimit => f.write_str("Team is full. The organization has no available licenses."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersRemoveArg {
    /// Identity of user to remove/suspend/have their files moved.
    pub user: UserSelectorArg,
    /// If provided, controls if the user's data will be deleted on their linked devices.
    pub wipe_data: bool,
    /// If provided, files from the deleted member account will be transferred to this user.
    pub transfer_dest_id: Option<UserSelectorArg>,
    /// If provided, errors during the transfer process will be sent via email to this user. If the
    /// transfer_dest_id argument was provided, then this argument must be provided as well.
    pub transfer_admin_id: Option<UserSelectorArg>,
    /// Downgrade the member to a Basic account. The user will retain the email address associated
    /// with their Dropbox  account and data in their account that is not restricted to team
    /// members. In order to keep the account the argument `wipe_data` should be set to `false`.
    pub keep_account: bool,
    /// If provided, allows removed users to keep access to Dropbox folders (not Dropbox Paper
    /// folders) already explicitly shared with them (not via a group) when they are downgraded to a
    /// Basic account. Users will not retain access to folders that do not allow external sharing.
    /// In order to keep the sharing relationships, the arguments `wipe_data` should be set to
    /// `false` and `keep_account` should be set to `true`.
    pub retain_team_shares: bool,
}

impl MembersRemoveArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersRemoveArg {
            user,
            wipe_data: true,
            transfer_dest_id: None,
            transfer_admin_id: None,
            keep_account: false,
            retain_team_shares: false,
        }
    }

    pub fn with_wipe_data(mut self, value: bool) -> Self {
        self.wipe_data = value;
        self
    }

    pub fn with_transfer_dest_id(mut self, value: UserSelectorArg) -> Self {
        self.transfer_dest_id = Some(value);
        self
    }

    pub fn with_transfer_admin_id(mut self, value: UserSelectorArg) -> Self {
        self.transfer_admin_id = Some(value);
        self
    }

    pub fn with_keep_account(mut self, value: bool) -> Self {
        self.keep_account = value;
        self
    }

    pub fn with_retain_team_shares(mut self, value: bool) -> Self {
        self.retain_team_shares = value;
        self
    }
}

const MEMBERS_REMOVE_ARG_FIELDS: &[&str] = &["user",
                                             "wipe_data",
                                             "transfer_dest_id",
                                             "transfer_admin_id",
                                             "keep_account",
                                             "retain_team_shares"];
impl MembersRemoveArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersRemoveArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersRemoveArg>, V::Error> {
        let mut field_user = None;
        let mut field_wipe_data = None;
        let mut field_transfer_dest_id = None;
        let mut field_transfer_admin_id = None;
        let mut field_keep_account = None;
        let mut field_retain_team_shares = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "wipe_data" => {
                    if field_wipe_data.is_some() {
                        return Err(::serde::de::Error::duplicate_field("wipe_data"));
                    }
                    field_wipe_data = Some(map.next_value()?);
                }
                "transfer_dest_id" => {
                    if field_transfer_dest_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("transfer_dest_id"));
                    }
                    field_transfer_dest_id = Some(map.next_value()?);
                }
                "transfer_admin_id" => {
                    if field_transfer_admin_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("transfer_admin_id"));
                    }
                    field_transfer_admin_id = Some(map.next_value()?);
                }
                "keep_account" => {
                    if field_keep_account.is_some() {
                        return Err(::serde::de::Error::duplicate_field("keep_account"));
                    }
                    field_keep_account = Some(map.next_value()?);
                }
                "retain_team_shares" => {
                    if field_retain_team_shares.is_some() {
                        return Err(::serde::de::Error::duplicate_field("retain_team_shares"));
                    }
                    field_retain_team_shares = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersRemoveArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            wipe_data: field_wipe_data.unwrap_or(true),
            transfer_dest_id: field_transfer_dest_id,
            transfer_admin_id: field_transfer_admin_id,
            keep_account: field_keep_account.unwrap_or(false),
            retain_team_shares: field_retain_team_shares.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("wipe_data", &self.wipe_data)?;
        if let Some(val) = &self.transfer_dest_id {
            s.serialize_field("transfer_dest_id", val)?;
        }
        if let Some(val) = &self.transfer_admin_id {
            s.serialize_field("transfer_admin_id", val)?;
        }
        s.serialize_field("keep_account", &self.keep_account)?;
        s.serialize_field("retain_team_shares", &self.retain_team_shares)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersRemoveArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersRemoveArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersRemoveArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersRemoveArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersRemoveArg", MEMBERS_REMOVE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersRemoveArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersRemoveArg", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersRemoveError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Expected removed user and transfer_dest user to be different.
    RemovedAndTransferDestShouldDiffer,
    /// Expected removed user and transfer_admin user to be different.
    RemovedAndTransferAdminShouldDiffer,
    /// No matching user found for the argument transfer_dest_id.
    TransferDestUserNotFound,
    /// The provided transfer_dest_id does not exist on this team.
    TransferDestUserNotInTeam,
    /// The provided transfer_admin_id does not exist on this team.
    TransferAdminUserNotInTeam,
    /// No matching user found for the argument transfer_admin_id.
    TransferAdminUserNotFound,
    /// The transfer_admin_id argument must be provided when file transfer is requested.
    UnspecifiedTransferAdminId,
    /// Specified transfer_admin user is not a team admin.
    TransferAdminIsNotAdmin,
    /// The recipient user's email is not verified.
    RecipientNotVerified,
    /// The user is the last admin of the team, so it cannot be removed from it.
    RemoveLastAdmin,
    /// Cannot keep account and transfer the data to another user at the same time.
    CannotKeepAccountAndTransfer,
    /// Cannot keep account and delete the data at the same time. To keep the account the argument
    /// wipe_data should be set to `false`.
    CannotKeepAccountAndDeleteData,
    /// The email address of the user is too long to be disabled.
    EmailAddressTooLongToBeDisabled,
    /// Cannot keep account of an invited user.
    CannotKeepInvitedUserAccount,
    /// Cannot retain team shares when the user's data is marked for deletion on their linked
    /// devices. The argument wipe_data should be set to `false`.
    CannotRetainSharesWhenDataWiped,
    /// The user's account must be kept in order to retain team shares. The argument keep_account
    /// should be set to `true`.
    CannotRetainSharesWhenNoAccountKept,
    /// Externally sharing files, folders, and links must be enabled in team settings in order to
    /// retain team shares for the user.
    CannotRetainSharesWhenTeamExternalSharingOff,
    /// Only a team admin, can convert this account to a Basic account.
    CannotKeepAccount,
    /// This user content is currently being held. To convert this member's account to a Basic
    /// account, you'll first need to remove them from the hold.
    CannotKeepAccountUnderLegalHold,
    /// To convert this member to a Basic account, they'll first need to sign in to Dropbox and
    /// agree to the terms of service.
    CannotKeepAccountRequiredToSignTos,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersRemoveError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersRemoveError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersRemoveError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersRemoveError::UserNotFound,
                    "user_not_in_team" => MembersRemoveError::UserNotInTeam,
                    "removed_and_transfer_dest_should_differ" => MembersRemoveError::RemovedAndTransferDestShouldDiffer,
                    "removed_and_transfer_admin_should_differ" => MembersRemoveError::RemovedAndTransferAdminShouldDiffer,
                    "transfer_dest_user_not_found" => MembersRemoveError::TransferDestUserNotFound,
                    "transfer_dest_user_not_in_team" => MembersRemoveError::TransferDestUserNotInTeam,
                    "transfer_admin_user_not_in_team" => MembersRemoveError::TransferAdminUserNotInTeam,
                    "transfer_admin_user_not_found" => MembersRemoveError::TransferAdminUserNotFound,
                    "unspecified_transfer_admin_id" => MembersRemoveError::UnspecifiedTransferAdminId,
                    "transfer_admin_is_not_admin" => MembersRemoveError::TransferAdminIsNotAdmin,
                    "recipient_not_verified" => MembersRemoveError::RecipientNotVerified,
                    "remove_last_admin" => MembersRemoveError::RemoveLastAdmin,
                    "cannot_keep_account_and_transfer" => MembersRemoveError::CannotKeepAccountAndTransfer,
                    "cannot_keep_account_and_delete_data" => MembersRemoveError::CannotKeepAccountAndDeleteData,
                    "email_address_too_long_to_be_disabled" => MembersRemoveError::EmailAddressTooLongToBeDisabled,
                    "cannot_keep_invited_user_account" => MembersRemoveError::CannotKeepInvitedUserAccount,
                    "cannot_retain_shares_when_data_wiped" => MembersRemoveError::CannotRetainSharesWhenDataWiped,
                    "cannot_retain_shares_when_no_account_kept" => MembersRemoveError::CannotRetainSharesWhenNoAccountKept,
                    "cannot_retain_shares_when_team_external_sharing_off" => MembersRemoveError::CannotRetainSharesWhenTeamExternalSharingOff,
                    "cannot_keep_account" => MembersRemoveError::CannotKeepAccount,
                    "cannot_keep_account_under_legal_hold" => MembersRemoveError::CannotKeepAccountUnderLegalHold,
                    "cannot_keep_account_required_to_sign_tos" => MembersRemoveError::CannotKeepAccountRequiredToSignTos,
                    _ => MembersRemoveError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other",
                                    "removed_and_transfer_dest_should_differ",
                                    "removed_and_transfer_admin_should_differ",
                                    "transfer_dest_user_not_found",
                                    "transfer_dest_user_not_in_team",
                                    "transfer_admin_user_not_in_team",
                                    "transfer_admin_user_not_found",
                                    "unspecified_transfer_admin_id",
                                    "transfer_admin_is_not_admin",
                                    "recipient_not_verified",
                                    "remove_last_admin",
                                    "cannot_keep_account_and_transfer",
                                    "cannot_keep_account_and_delete_data",
                                    "email_address_too_long_to_be_disabled",
                                    "cannot_keep_invited_user_account",
                                    "cannot_retain_shares_when_data_wiped",
                                    "cannot_retain_shares_when_no_account_kept",
                                    "cannot_retain_shares_when_team_external_sharing_off",
                                    "cannot_keep_account",
                                    "cannot_keep_account_under_legal_hold",
                                    "cannot_keep_account_required_to_sign_tos"];
        deserializer.deserialize_struct("MembersRemoveError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersRemoveError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersRemoveError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersRemoveError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersRemoveError::RemovedAndTransferDestShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_dest_should_differ")?;
                s.end()
            }
            MembersRemoveError::RemovedAndTransferAdminShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_admin_should_differ")?;
                s.end()
            }
            MembersRemoveError::TransferDestUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_found")?;
                s.end()
            }
            MembersRemoveError::TransferDestUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_in_team")?;
                s.end()
            }
            MembersRemoveError::TransferAdminUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_in_team")?;
                s.end()
            }
            MembersRemoveError::TransferAdminUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_found")?;
                s.end()
            }
            MembersRemoveError::UnspecifiedTransferAdminId => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "unspecified_transfer_admin_id")?;
                s.end()
            }
            MembersRemoveError::TransferAdminIsNotAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "transfer_admin_is_not_admin")?;
                s.end()
            }
            MembersRemoveError::RecipientNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "recipient_not_verified")?;
                s.end()
            }
            MembersRemoveError::RemoveLastAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "remove_last_admin")?;
                s.end()
            }
            MembersRemoveError::CannotKeepAccountAndTransfer => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_account_and_transfer")?;
                s.end()
            }
            MembersRemoveError::CannotKeepAccountAndDeleteData => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_account_and_delete_data")?;
                s.end()
            }
            MembersRemoveError::EmailAddressTooLongToBeDisabled => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "email_address_too_long_to_be_disabled")?;
                s.end()
            }
            MembersRemoveError::CannotKeepInvitedUserAccount => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_invited_user_account")?;
                s.end()
            }
            MembersRemoveError::CannotRetainSharesWhenDataWiped => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_retain_shares_when_data_wiped")?;
                s.end()
            }
            MembersRemoveError::CannotRetainSharesWhenNoAccountKept => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_retain_shares_when_no_account_kept")?;
                s.end()
            }
            MembersRemoveError::CannotRetainSharesWhenTeamExternalSharingOff => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_retain_shares_when_team_external_sharing_off")?;
                s.end()
            }
            MembersRemoveError::CannotKeepAccount => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_account")?;
                s.end()
            }
            MembersRemoveError::CannotKeepAccountUnderLegalHold => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_account_under_legal_hold")?;
                s.end()
            }
            MembersRemoveError::CannotKeepAccountRequiredToSignTos => {
                // unit
                let mut s = serializer.serialize_struct("MembersRemoveError", 1)?;
                s.serialize_field(".tag", "cannot_keep_account_required_to_sign_tos")?;
                s.end()
            }
            MembersRemoveError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersRemoveError {
}

impl ::std::fmt::Display for MembersRemoveError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersRemoveError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersRemoveError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersRemoveError::RemovedAndTransferDestShouldDiffer => f.write_str("Expected removed user and transfer_dest user to be different."),
            MembersRemoveError::RemovedAndTransferAdminShouldDiffer => f.write_str("Expected removed user and transfer_admin user to be different."),
            MembersRemoveError::TransferDestUserNotFound => f.write_str("No matching user found for the argument transfer_dest_id."),
            MembersRemoveError::TransferDestUserNotInTeam => f.write_str("The provided transfer_dest_id does not exist on this team."),
            MembersRemoveError::TransferAdminUserNotInTeam => f.write_str("The provided transfer_admin_id does not exist on this team."),
            MembersRemoveError::TransferAdminUserNotFound => f.write_str("No matching user found for the argument transfer_admin_id."),
            MembersRemoveError::UnspecifiedTransferAdminId => f.write_str("The transfer_admin_id argument must be provided when file transfer is requested."),
            MembersRemoveError::TransferAdminIsNotAdmin => f.write_str("Specified transfer_admin user is not a team admin."),
            MembersRemoveError::RecipientNotVerified => f.write_str("The recipient user's email is not verified."),
            MembersRemoveError::RemoveLastAdmin => f.write_str("The user is the last admin of the team, so it cannot be removed from it."),
            MembersRemoveError::CannotKeepAccountAndTransfer => f.write_str("Cannot keep account and transfer the data to another user at the same time."),
            MembersRemoveError::EmailAddressTooLongToBeDisabled => f.write_str("The email address of the user is too long to be disabled."),
            MembersRemoveError::CannotKeepInvitedUserAccount => f.write_str("Cannot keep account of an invited user."),
            MembersRemoveError::CannotRetainSharesWhenTeamExternalSharingOff => f.write_str("Externally sharing files, folders, and links must be enabled in team settings in order to retain team shares for the user."),
            MembersRemoveError::CannotKeepAccount => f.write_str("Only a team admin, can convert this account to a Basic account."),
            MembersRemoveError::CannotKeepAccountUnderLegalHold => f.write_str("This user content is currently being held. To convert this member's account to a Basic account, you'll first need to remove them from the hold."),
            MembersRemoveError::CannotKeepAccountRequiredToSignTos => f.write_str("To convert this member to a Basic account, they'll first need to sign in to Dropbox and agree to the terms of service."),
            _ => write!(f, "{:?}", *self),
        }
    }
}


#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSendWelcomeError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSendWelcomeError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSendWelcomeError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSendWelcomeError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSendWelcomeError::UserNotFound,
                    "user_not_in_team" => MembersSendWelcomeError::UserNotInTeam,
                    _ => MembersSendWelcomeError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other"];
        deserializer.deserialize_struct("MembersSendWelcomeError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSendWelcomeError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSendWelcomeError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSendWelcomeError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSendWelcomeError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSendWelcomeError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSendWelcomeError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSendWelcomeError {
}

impl ::std::fmt::Display for MembersSendWelcomeError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSendWelcomeError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSendWelcomeError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetPermissions2Arg {
    /// Identity of user whose role will be set.
    pub user: UserSelectorArg,
    /// The new roles for the member. Send empty list to make user member only. For now, only up to
    /// one role is allowed.
    pub new_roles: Option<Vec<TeamMemberRoleId>>,
}

impl MembersSetPermissions2Arg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersSetPermissions2Arg {
            user,
            new_roles: None,
        }
    }

    pub fn with_new_roles(mut self, value: Vec<TeamMemberRoleId>) -> Self {
        self.new_roles = Some(value);
        self
    }
}

const MEMBERS_SET_PERMISSIONS2_ARG_FIELDS: &[&str] = &["user",
                                                       "new_roles"];
impl MembersSetPermissions2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetPermissions2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetPermissions2Arg>, V::Error> {
        let mut field_user = None;
        let mut field_new_roles = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "new_roles" => {
                    if field_new_roles.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_roles"));
                    }
                    field_new_roles = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetPermissions2Arg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            new_roles: field_new_roles,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        if let Some(val) = &self.new_roles {
            s.serialize_field("new_roles", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissions2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetPermissions2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissions2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetPermissions2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetPermissions2Arg", MEMBERS_SET_PERMISSIONS2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissions2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetPermissions2Arg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSetPermissions2Error {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// Cannot remove the admin setting of the last admin.
    LastAdmin,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Cannot remove/grant permissions. This can happen if the team member is suspended.
    CannotSetPermissions,
    /// No matching role found. At least one of the provided new_roles does not exist on this team.
    RoleNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissions2Error {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSetPermissions2Error;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissions2Error structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSetPermissions2Error::UserNotFound,
                    "last_admin" => MembersSetPermissions2Error::LastAdmin,
                    "user_not_in_team" => MembersSetPermissions2Error::UserNotInTeam,
                    "cannot_set_permissions" => MembersSetPermissions2Error::CannotSetPermissions,
                    "role_not_found" => MembersSetPermissions2Error::RoleNotFound,
                    _ => MembersSetPermissions2Error::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "last_admin",
                                    "user_not_in_team",
                                    "cannot_set_permissions",
                                    "role_not_found",
                                    "other"];
        deserializer.deserialize_struct("MembersSetPermissions2Error", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissions2Error {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSetPermissions2Error::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissions2Error", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSetPermissions2Error::LastAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissions2Error", 1)?;
                s.serialize_field(".tag", "last_admin")?;
                s.end()
            }
            MembersSetPermissions2Error::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissions2Error", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSetPermissions2Error::CannotSetPermissions => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissions2Error", 1)?;
                s.serialize_field(".tag", "cannot_set_permissions")?;
                s.end()
            }
            MembersSetPermissions2Error::RoleNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissions2Error", 1)?;
                s.serialize_field(".tag", "role_not_found")?;
                s.end()
            }
            MembersSetPermissions2Error::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSetPermissions2Error {
}

impl ::std::fmt::Display for MembersSetPermissions2Error {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSetPermissions2Error::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSetPermissions2Error::LastAdmin => f.write_str("Cannot remove the admin setting of the last admin."),
            MembersSetPermissions2Error::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersSetPermissions2Error::CannotSetPermissions => f.write_str("Cannot remove/grant permissions. This can happen if the team member is suspended."),
            MembersSetPermissions2Error::RoleNotFound => f.write_str("No matching role found. At least one of the provided new_roles does not exist on this team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetPermissions2Result {
    /// The member ID of the user to which the change was applied.
    pub team_member_id: super::team_common::TeamMemberId,
    /// The roles after the change. Empty in case the user become a non-admin.
    pub roles: Option<Vec<TeamMemberRole>>,
}

impl MembersSetPermissions2Result {
    pub fn new(team_member_id: super::team_common::TeamMemberId) -> Self {
        MembersSetPermissions2Result {
            team_member_id,
            roles: None,
        }
    }

    pub fn with_roles(mut self, value: Vec<TeamMemberRole>) -> Self {
        self.roles = Some(value);
        self
    }
}

const MEMBERS_SET_PERMISSIONS2_RESULT_FIELDS: &[&str] = &["team_member_id",
                                                          "roles"];
impl MembersSetPermissions2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetPermissions2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetPermissions2Result>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_roles = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "roles" => {
                    if field_roles.is_some() {
                        return Err(::serde::de::Error::duplicate_field("roles"));
                    }
                    field_roles = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetPermissions2Result {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            roles: field_roles,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        if let Some(val) = &self.roles {
            s.serialize_field("roles", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissions2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetPermissions2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissions2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetPermissions2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetPermissions2Result", MEMBERS_SET_PERMISSIONS2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissions2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetPermissions2Result", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetPermissionsArg {
    /// Identity of user whose role will be set.
    pub user: UserSelectorArg,
    /// The new role of the member.
    pub new_role: AdminTier,
}

impl MembersSetPermissionsArg {
    pub fn new(user: UserSelectorArg, new_role: AdminTier) -> Self {
        MembersSetPermissionsArg {
            user,
            new_role,
        }
    }
}

const MEMBERS_SET_PERMISSIONS_ARG_FIELDS: &[&str] = &["user",
                                                      "new_role"];
impl MembersSetPermissionsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetPermissionsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetPermissionsArg>, V::Error> {
        let mut field_user = None;
        let mut field_new_role = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "new_role" => {
                    if field_new_role.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_role"));
                    }
                    field_new_role = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetPermissionsArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            new_role: field_new_role.ok_or_else(|| ::serde::de::Error::missing_field("new_role"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("new_role", &self.new_role)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissionsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetPermissionsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissionsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetPermissionsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetPermissionsArg", MEMBERS_SET_PERMISSIONS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissionsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetPermissionsArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSetPermissionsError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// Cannot remove the admin setting of the last admin.
    LastAdmin,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Cannot remove/grant permissions.
    CannotSetPermissions,
    /// Team is full. The organization has no available licenses.
    TeamLicenseLimit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissionsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSetPermissionsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissionsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSetPermissionsError::UserNotFound,
                    "last_admin" => MembersSetPermissionsError::LastAdmin,
                    "user_not_in_team" => MembersSetPermissionsError::UserNotInTeam,
                    "cannot_set_permissions" => MembersSetPermissionsError::CannotSetPermissions,
                    "team_license_limit" => MembersSetPermissionsError::TeamLicenseLimit,
                    _ => MembersSetPermissionsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "last_admin",
                                    "user_not_in_team",
                                    "cannot_set_permissions",
                                    "team_license_limit",
                                    "other"];
        deserializer.deserialize_struct("MembersSetPermissionsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissionsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSetPermissionsError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissionsError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSetPermissionsError::LastAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissionsError", 1)?;
                s.serialize_field(".tag", "last_admin")?;
                s.end()
            }
            MembersSetPermissionsError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissionsError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSetPermissionsError::CannotSetPermissions => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissionsError", 1)?;
                s.serialize_field(".tag", "cannot_set_permissions")?;
                s.end()
            }
            MembersSetPermissionsError::TeamLicenseLimit => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetPermissionsError", 1)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.end()
            }
            MembersSetPermissionsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSetPermissionsError {
}

impl ::std::fmt::Display for MembersSetPermissionsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSetPermissionsError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSetPermissionsError::LastAdmin => f.write_str("Cannot remove the admin setting of the last admin."),
            MembersSetPermissionsError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersSetPermissionsError::CannotSetPermissions => f.write_str("Cannot remove/grant permissions."),
            MembersSetPermissionsError::TeamLicenseLimit => f.write_str("Team is full. The organization has no available licenses."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetPermissionsResult {
    /// The member ID of the user to which the change was applied.
    pub team_member_id: super::team_common::TeamMemberId,
    /// The role after the change.
    pub role: AdminTier,
}

impl MembersSetPermissionsResult {
    pub fn new(team_member_id: super::team_common::TeamMemberId, role: AdminTier) -> Self {
        MembersSetPermissionsResult {
            team_member_id,
            role,
        }
    }
}

const MEMBERS_SET_PERMISSIONS_RESULT_FIELDS: &[&str] = &["team_member_id",
                                                         "role"];
impl MembersSetPermissionsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetPermissionsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetPermissionsResult>, V::Error> {
        let mut field_team_member_id = None;
        let mut field_role = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "role" => {
                    if field_role.is_some() {
                        return Err(::serde::de::Error::duplicate_field("role"));
                    }
                    field_role = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetPermissionsResult {
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            role: field_role.ok_or_else(|| ::serde::de::Error::missing_field("role"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("role", &self.role)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetPermissionsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetPermissionsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetPermissionsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetPermissionsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetPermissionsResult", MEMBERS_SET_PERMISSIONS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetPermissionsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetPermissionsResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account. At least one of new_email, new_external_id, new_given_name, and/or new_surname must be
/// provided.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetProfileArg {
    /// Identity of user whose profile will be set.
    pub user: UserSelectorArg,
    /// New email for member.
    pub new_email: Option<super::common::EmailAddress>,
    /// New external ID for member.
    pub new_external_id: Option<super::team_common::MemberExternalId>,
    /// New given name for member.
    pub new_given_name: Option<super::common::OptionalNamePart>,
    /// New surname for member.
    pub new_surname: Option<super::common::OptionalNamePart>,
    /// New persistent ID. This field only available to teams using persistent ID SAML
    /// configuration.
    pub new_persistent_id: Option<String>,
    /// New value for whether the user is a directory restricted user.
    pub new_is_directory_restricted: Option<bool>,
}

impl MembersSetProfileArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersSetProfileArg {
            user,
            new_email: None,
            new_external_id: None,
            new_given_name: None,
            new_surname: None,
            new_persistent_id: None,
            new_is_directory_restricted: None,
        }
    }

    pub fn with_new_email(mut self, value: super::common::EmailAddress) -> Self {
        self.new_email = Some(value);
        self
    }

    pub fn with_new_external_id(mut self, value: super::team_common::MemberExternalId) -> Self {
        self.new_external_id = Some(value);
        self
    }

    pub fn with_new_given_name(mut self, value: super::common::OptionalNamePart) -> Self {
        self.new_given_name = Some(value);
        self
    }

    pub fn with_new_surname(mut self, value: super::common::OptionalNamePart) -> Self {
        self.new_surname = Some(value);
        self
    }

    pub fn with_new_persistent_id(mut self, value: String) -> Self {
        self.new_persistent_id = Some(value);
        self
    }

    pub fn with_new_is_directory_restricted(mut self, value: bool) -> Self {
        self.new_is_directory_restricted = Some(value);
        self
    }
}

const MEMBERS_SET_PROFILE_ARG_FIELDS: &[&str] = &["user",
                                                  "new_email",
                                                  "new_external_id",
                                                  "new_given_name",
                                                  "new_surname",
                                                  "new_persistent_id",
                                                  "new_is_directory_restricted"];
impl MembersSetProfileArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetProfileArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetProfileArg>, V::Error> {
        let mut field_user = None;
        let mut field_new_email = None;
        let mut field_new_external_id = None;
        let mut field_new_given_name = None;
        let mut field_new_surname = None;
        let mut field_new_persistent_id = None;
        let mut field_new_is_directory_restricted = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "new_email" => {
                    if field_new_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_email"));
                    }
                    field_new_email = Some(map.next_value()?);
                }
                "new_external_id" => {
                    if field_new_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_external_id"));
                    }
                    field_new_external_id = Some(map.next_value()?);
                }
                "new_given_name" => {
                    if field_new_given_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_given_name"));
                    }
                    field_new_given_name = Some(map.next_value()?);
                }
                "new_surname" => {
                    if field_new_surname.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_surname"));
                    }
                    field_new_surname = Some(map.next_value()?);
                }
                "new_persistent_id" => {
                    if field_new_persistent_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_persistent_id"));
                    }
                    field_new_persistent_id = Some(map.next_value()?);
                }
                "new_is_directory_restricted" => {
                    if field_new_is_directory_restricted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_is_directory_restricted"));
                    }
                    field_new_is_directory_restricted = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetProfileArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            new_email: field_new_email,
            new_external_id: field_new_external_id,
            new_given_name: field_new_given_name,
            new_surname: field_new_surname,
            new_persistent_id: field_new_persistent_id,
            new_is_directory_restricted: field_new_is_directory_restricted,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        if let Some(val) = &self.new_email {
            s.serialize_field("new_email", val)?;
        }
        if let Some(val) = &self.new_external_id {
            s.serialize_field("new_external_id", val)?;
        }
        if let Some(val) = &self.new_given_name {
            s.serialize_field("new_given_name", val)?;
        }
        if let Some(val) = &self.new_surname {
            s.serialize_field("new_surname", val)?;
        }
        if let Some(val) = &self.new_persistent_id {
            s.serialize_field("new_persistent_id", val)?;
        }
        if let Some(val) = &self.new_is_directory_restricted {
            s.serialize_field("new_is_directory_restricted", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetProfileArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetProfileArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetProfileArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetProfileArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetProfileArg", MEMBERS_SET_PROFILE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetProfileArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetProfileArg", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSetProfileError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// It is unsafe to use both external_id and new_external_id.
    ExternalIdAndNewExternalIdUnsafe,
    /// None of new_email, new_given_name, new_surname, or new_external_id are specified.
    NoNewDataSpecified,
    /// Email is already reserved for another user.
    EmailReservedForOtherUser,
    /// The external ID is already in use by another team member.
    ExternalIdUsedByOtherUser,
    /// Modifying deleted users is not allowed.
    SetProfileDisallowed,
    /// Parameter new_email cannot be empty.
    ParamCannotBeEmpty,
    /// Persistent ID is only available to teams with persistent ID SAML configuration. Please
    /// contact Dropbox for more information.
    PersistentIdDisabled,
    /// The persistent ID is already in use by another team member.
    PersistentIdUsedByOtherUser,
    /// Directory Restrictions option is not available.
    DirectoryRestrictedOff,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetProfileError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSetProfileError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetProfileError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSetProfileError::UserNotFound,
                    "user_not_in_team" => MembersSetProfileError::UserNotInTeam,
                    "external_id_and_new_external_id_unsafe" => MembersSetProfileError::ExternalIdAndNewExternalIdUnsafe,
                    "no_new_data_specified" => MembersSetProfileError::NoNewDataSpecified,
                    "email_reserved_for_other_user" => MembersSetProfileError::EmailReservedForOtherUser,
                    "external_id_used_by_other_user" => MembersSetProfileError::ExternalIdUsedByOtherUser,
                    "set_profile_disallowed" => MembersSetProfileError::SetProfileDisallowed,
                    "param_cannot_be_empty" => MembersSetProfileError::ParamCannotBeEmpty,
                    "persistent_id_disabled" => MembersSetProfileError::PersistentIdDisabled,
                    "persistent_id_used_by_other_user" => MembersSetProfileError::PersistentIdUsedByOtherUser,
                    "directory_restricted_off" => MembersSetProfileError::DirectoryRestrictedOff,
                    _ => MembersSetProfileError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "external_id_and_new_external_id_unsafe",
                                    "no_new_data_specified",
                                    "email_reserved_for_other_user",
                                    "external_id_used_by_other_user",
                                    "set_profile_disallowed",
                                    "param_cannot_be_empty",
                                    "persistent_id_disabled",
                                    "persistent_id_used_by_other_user",
                                    "directory_restricted_off",
                                    "other"];
        deserializer.deserialize_struct("MembersSetProfileError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetProfileError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSetProfileError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSetProfileError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSetProfileError::ExternalIdAndNewExternalIdUnsafe => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "external_id_and_new_external_id_unsafe")?;
                s.end()
            }
            MembersSetProfileError::NoNewDataSpecified => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "no_new_data_specified")?;
                s.end()
            }
            MembersSetProfileError::EmailReservedForOtherUser => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "email_reserved_for_other_user")?;
                s.end()
            }
            MembersSetProfileError::ExternalIdUsedByOtherUser => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "external_id_used_by_other_user")?;
                s.end()
            }
            MembersSetProfileError::SetProfileDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "set_profile_disallowed")?;
                s.end()
            }
            MembersSetProfileError::ParamCannotBeEmpty => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "param_cannot_be_empty")?;
                s.end()
            }
            MembersSetProfileError::PersistentIdDisabled => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "persistent_id_disabled")?;
                s.end()
            }
            MembersSetProfileError::PersistentIdUsedByOtherUser => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "persistent_id_used_by_other_user")?;
                s.end()
            }
            MembersSetProfileError::DirectoryRestrictedOff => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfileError", 1)?;
                s.serialize_field(".tag", "directory_restricted_off")?;
                s.end()
            }
            MembersSetProfileError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSetProfileError {
}

impl ::std::fmt::Display for MembersSetProfileError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSetProfileError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSetProfileError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersSetProfileError::ExternalIdAndNewExternalIdUnsafe => f.write_str("It is unsafe to use both external_id and new_external_id."),
            MembersSetProfileError::NoNewDataSpecified => f.write_str("None of new_email, new_given_name, new_surname, or new_external_id are specified."),
            MembersSetProfileError::EmailReservedForOtherUser => f.write_str("Email is already reserved for another user."),
            MembersSetProfileError::ExternalIdUsedByOtherUser => f.write_str("The external ID is already in use by another team member."),
            MembersSetProfileError::SetProfileDisallowed => f.write_str("Modifying deleted users is not allowed."),
            MembersSetProfileError::ParamCannotBeEmpty => f.write_str("Parameter new_email cannot be empty."),
            MembersSetProfileError::PersistentIdDisabled => f.write_str("Persistent ID is only available to teams with persistent ID SAML configuration. Please contact Dropbox for more information."),
            MembersSetProfileError::PersistentIdUsedByOtherUser => f.write_str("The persistent ID is already in use by another team member."),
            MembersSetProfileError::DirectoryRestrictedOff => f.write_str("Directory Restrictions option is not available."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersSetProfilePhotoArg {
    /// Identity of the user whose profile photo will be set.
    pub user: UserSelectorArg,
    /// Image to set as the member's new profile photo.
    pub photo: super::account::PhotoSourceArg,
}

impl MembersSetProfilePhotoArg {
    pub fn new(user: UserSelectorArg, photo: super::account::PhotoSourceArg) -> Self {
        MembersSetProfilePhotoArg {
            user,
            photo,
        }
    }
}

const MEMBERS_SET_PROFILE_PHOTO_ARG_FIELDS: &[&str] = &["user",
                                                        "photo"];
impl MembersSetProfilePhotoArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersSetProfilePhotoArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersSetProfilePhotoArg>, V::Error> {
        let mut field_user = None;
        let mut field_photo = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "photo" => {
                    if field_photo.is_some() {
                        return Err(::serde::de::Error::duplicate_field("photo"));
                    }
                    field_photo = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersSetProfilePhotoArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            photo: field_photo.ok_or_else(|| ::serde::de::Error::missing_field("photo"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("photo", &self.photo)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetProfilePhotoArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersSetProfilePhotoArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetProfilePhotoArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersSetProfilePhotoArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersSetProfilePhotoArg", MEMBERS_SET_PROFILE_PHOTO_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetProfilePhotoArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersSetProfilePhotoArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSetProfilePhotoError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Modifying deleted users is not allowed.
    SetProfileDisallowed,
    PhotoError(super::account::SetProfilePhotoError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSetProfilePhotoError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSetProfilePhotoError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSetProfilePhotoError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSetProfilePhotoError::UserNotFound,
                    "user_not_in_team" => MembersSetProfilePhotoError::UserNotInTeam,
                    "set_profile_disallowed" => MembersSetProfilePhotoError::SetProfileDisallowed,
                    "photo_error" => {
                        match map.next_key()? {
                            Some("photo_error") => MembersSetProfilePhotoError::PhotoError(map.next_value()?),
                            None => return Err(de::Error::missing_field("photo_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => MembersSetProfilePhotoError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "set_profile_disallowed",
                                    "photo_error",
                                    "other"];
        deserializer.deserialize_struct("MembersSetProfilePhotoError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSetProfilePhotoError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSetProfilePhotoError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfilePhotoError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSetProfilePhotoError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfilePhotoError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSetProfilePhotoError::SetProfileDisallowed => {
                // unit
                let mut s = serializer.serialize_struct("MembersSetProfilePhotoError", 1)?;
                s.serialize_field(".tag", "set_profile_disallowed")?;
                s.end()
            }
            MembersSetProfilePhotoError::PhotoError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("MembersSetProfilePhotoError", 2)?;
                s.serialize_field(".tag", "photo_error")?;
                s.serialize_field("photo_error", x)?;
                s.end()
            }
            MembersSetProfilePhotoError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSetProfilePhotoError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            MembersSetProfilePhotoError::PhotoError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for MembersSetProfilePhotoError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSetProfilePhotoError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSetProfilePhotoError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersSetProfilePhotoError::SetProfileDisallowed => f.write_str("Modifying deleted users is not allowed."),
            MembersSetProfilePhotoError::PhotoError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersSuspendError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// The user is not active, so it cannot be suspended.
    SuspendInactiveUser,
    /// The user is the last admin of the team, so it cannot be suspended.
    SuspendLastAdmin,
    /// Team is full. The organization has no available licenses.
    TeamLicenseLimit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersSuspendError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersSuspendError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersSuspendError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersSuspendError::UserNotFound,
                    "user_not_in_team" => MembersSuspendError::UserNotInTeam,
                    "suspend_inactive_user" => MembersSuspendError::SuspendInactiveUser,
                    "suspend_last_admin" => MembersSuspendError::SuspendLastAdmin,
                    "team_license_limit" => MembersSuspendError::TeamLicenseLimit,
                    _ => MembersSuspendError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other",
                                    "suspend_inactive_user",
                                    "suspend_last_admin",
                                    "team_license_limit"];
        deserializer.deserialize_struct("MembersSuspendError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersSuspendError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersSuspendError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersSuspendError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersSuspendError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersSuspendError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersSuspendError::SuspendInactiveUser => {
                // unit
                let mut s = serializer.serialize_struct("MembersSuspendError", 1)?;
                s.serialize_field(".tag", "suspend_inactive_user")?;
                s.end()
            }
            MembersSuspendError::SuspendLastAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersSuspendError", 1)?;
                s.serialize_field(".tag", "suspend_last_admin")?;
                s.end()
            }
            MembersSuspendError::TeamLicenseLimit => {
                // unit
                let mut s = serializer.serialize_struct("MembersSuspendError", 1)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.end()
            }
            MembersSuspendError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersSuspendError {
}

impl ::std::fmt::Display for MembersSuspendError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersSuspendError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersSuspendError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersSuspendError::SuspendInactiveUser => f.write_str("The user is not active, so it cannot be suspended."),
            MembersSuspendError::SuspendLastAdmin => f.write_str("The user is the last admin of the team, so it cannot be suspended."),
            MembersSuspendError::TeamLicenseLimit => f.write_str("Team is full. The organization has no available licenses."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersTransferFilesError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Expected removed user and transfer_dest user to be different.
    RemovedAndTransferDestShouldDiffer,
    /// Expected removed user and transfer_admin user to be different.
    RemovedAndTransferAdminShouldDiffer,
    /// No matching user found for the argument transfer_dest_id.
    TransferDestUserNotFound,
    /// The provided transfer_dest_id does not exist on this team.
    TransferDestUserNotInTeam,
    /// The provided transfer_admin_id does not exist on this team.
    TransferAdminUserNotInTeam,
    /// No matching user found for the argument transfer_admin_id.
    TransferAdminUserNotFound,
    /// The transfer_admin_id argument must be provided when file transfer is requested.
    UnspecifiedTransferAdminId,
    /// Specified transfer_admin user is not a team admin.
    TransferAdminIsNotAdmin,
    /// The recipient user's email is not verified.
    RecipientNotVerified,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersTransferFilesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersTransferFilesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersTransferFilesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersTransferFilesError::UserNotFound,
                    "user_not_in_team" => MembersTransferFilesError::UserNotInTeam,
                    "removed_and_transfer_dest_should_differ" => MembersTransferFilesError::RemovedAndTransferDestShouldDiffer,
                    "removed_and_transfer_admin_should_differ" => MembersTransferFilesError::RemovedAndTransferAdminShouldDiffer,
                    "transfer_dest_user_not_found" => MembersTransferFilesError::TransferDestUserNotFound,
                    "transfer_dest_user_not_in_team" => MembersTransferFilesError::TransferDestUserNotInTeam,
                    "transfer_admin_user_not_in_team" => MembersTransferFilesError::TransferAdminUserNotInTeam,
                    "transfer_admin_user_not_found" => MembersTransferFilesError::TransferAdminUserNotFound,
                    "unspecified_transfer_admin_id" => MembersTransferFilesError::UnspecifiedTransferAdminId,
                    "transfer_admin_is_not_admin" => MembersTransferFilesError::TransferAdminIsNotAdmin,
                    "recipient_not_verified" => MembersTransferFilesError::RecipientNotVerified,
                    _ => MembersTransferFilesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other",
                                    "removed_and_transfer_dest_should_differ",
                                    "removed_and_transfer_admin_should_differ",
                                    "transfer_dest_user_not_found",
                                    "transfer_dest_user_not_in_team",
                                    "transfer_admin_user_not_in_team",
                                    "transfer_admin_user_not_found",
                                    "unspecified_transfer_admin_id",
                                    "transfer_admin_is_not_admin",
                                    "recipient_not_verified"];
        deserializer.deserialize_struct("MembersTransferFilesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersTransferFilesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersTransferFilesError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersTransferFilesError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersTransferFilesError::RemovedAndTransferDestShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_dest_should_differ")?;
                s.end()
            }
            MembersTransferFilesError::RemovedAndTransferAdminShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_admin_should_differ")?;
                s.end()
            }
            MembersTransferFilesError::TransferDestUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_found")?;
                s.end()
            }
            MembersTransferFilesError::TransferDestUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_in_team")?;
                s.end()
            }
            MembersTransferFilesError::TransferAdminUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_in_team")?;
                s.end()
            }
            MembersTransferFilesError::TransferAdminUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_found")?;
                s.end()
            }
            MembersTransferFilesError::UnspecifiedTransferAdminId => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "unspecified_transfer_admin_id")?;
                s.end()
            }
            MembersTransferFilesError::TransferAdminIsNotAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_is_not_admin")?;
                s.end()
            }
            MembersTransferFilesError::RecipientNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFilesError", 1)?;
                s.serialize_field(".tag", "recipient_not_verified")?;
                s.end()
            }
            MembersTransferFilesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersTransferFilesError {
}

impl ::std::fmt::Display for MembersTransferFilesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersTransferFilesError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersTransferFilesError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersTransferFilesError::RemovedAndTransferDestShouldDiffer => f.write_str("Expected removed user and transfer_dest user to be different."),
            MembersTransferFilesError::RemovedAndTransferAdminShouldDiffer => f.write_str("Expected removed user and transfer_admin user to be different."),
            MembersTransferFilesError::TransferDestUserNotFound => f.write_str("No matching user found for the argument transfer_dest_id."),
            MembersTransferFilesError::TransferDestUserNotInTeam => f.write_str("The provided transfer_dest_id does not exist on this team."),
            MembersTransferFilesError::TransferAdminUserNotInTeam => f.write_str("The provided transfer_admin_id does not exist on this team."),
            MembersTransferFilesError::TransferAdminUserNotFound => f.write_str("No matching user found for the argument transfer_admin_id."),
            MembersTransferFilesError::UnspecifiedTransferAdminId => f.write_str("The transfer_admin_id argument must be provided when file transfer is requested."),
            MembersTransferFilesError::TransferAdminIsNotAdmin => f.write_str("Specified transfer_admin user is not a team admin."),
            MembersTransferFilesError::RecipientNotVerified => f.write_str("The recipient user's email is not verified."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersTransferFormerMembersFilesError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// Expected removed user and transfer_dest user to be different.
    RemovedAndTransferDestShouldDiffer,
    /// Expected removed user and transfer_admin user to be different.
    RemovedAndTransferAdminShouldDiffer,
    /// No matching user found for the argument transfer_dest_id.
    TransferDestUserNotFound,
    /// The provided transfer_dest_id does not exist on this team.
    TransferDestUserNotInTeam,
    /// The provided transfer_admin_id does not exist on this team.
    TransferAdminUserNotInTeam,
    /// No matching user found for the argument transfer_admin_id.
    TransferAdminUserNotFound,
    /// The transfer_admin_id argument must be provided when file transfer is requested.
    UnspecifiedTransferAdminId,
    /// Specified transfer_admin user is not a team admin.
    TransferAdminIsNotAdmin,
    /// The recipient user's email is not verified.
    RecipientNotVerified,
    /// The user's data is being transferred. Please wait some time before retrying.
    UserDataIsBeingTransferred,
    /// No matching removed user found for the argument user.
    UserNotRemoved,
    /// User files aren't transferable anymore.
    UserDataCannotBeTransferred,
    /// User's data has already been transferred to another user.
    UserDataAlreadyTransferred,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersTransferFormerMembersFilesError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersTransferFormerMembersFilesError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersTransferFormerMembersFilesError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersTransferFormerMembersFilesError::UserNotFound,
                    "user_not_in_team" => MembersTransferFormerMembersFilesError::UserNotInTeam,
                    "removed_and_transfer_dest_should_differ" => MembersTransferFormerMembersFilesError::RemovedAndTransferDestShouldDiffer,
                    "removed_and_transfer_admin_should_differ" => MembersTransferFormerMembersFilesError::RemovedAndTransferAdminShouldDiffer,
                    "transfer_dest_user_not_found" => MembersTransferFormerMembersFilesError::TransferDestUserNotFound,
                    "transfer_dest_user_not_in_team" => MembersTransferFormerMembersFilesError::TransferDestUserNotInTeam,
                    "transfer_admin_user_not_in_team" => MembersTransferFormerMembersFilesError::TransferAdminUserNotInTeam,
                    "transfer_admin_user_not_found" => MembersTransferFormerMembersFilesError::TransferAdminUserNotFound,
                    "unspecified_transfer_admin_id" => MembersTransferFormerMembersFilesError::UnspecifiedTransferAdminId,
                    "transfer_admin_is_not_admin" => MembersTransferFormerMembersFilesError::TransferAdminIsNotAdmin,
                    "recipient_not_verified" => MembersTransferFormerMembersFilesError::RecipientNotVerified,
                    "user_data_is_being_transferred" => MembersTransferFormerMembersFilesError::UserDataIsBeingTransferred,
                    "user_not_removed" => MembersTransferFormerMembersFilesError::UserNotRemoved,
                    "user_data_cannot_be_transferred" => MembersTransferFormerMembersFilesError::UserDataCannotBeTransferred,
                    "user_data_already_transferred" => MembersTransferFormerMembersFilesError::UserDataAlreadyTransferred,
                    _ => MembersTransferFormerMembersFilesError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other",
                                    "removed_and_transfer_dest_should_differ",
                                    "removed_and_transfer_admin_should_differ",
                                    "transfer_dest_user_not_found",
                                    "transfer_dest_user_not_in_team",
                                    "transfer_admin_user_not_in_team",
                                    "transfer_admin_user_not_found",
                                    "unspecified_transfer_admin_id",
                                    "transfer_admin_is_not_admin",
                                    "recipient_not_verified",
                                    "user_data_is_being_transferred",
                                    "user_not_removed",
                                    "user_data_cannot_be_transferred",
                                    "user_data_already_transferred"];
        deserializer.deserialize_struct("MembersTransferFormerMembersFilesError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersTransferFormerMembersFilesError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersTransferFormerMembersFilesError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::RemovedAndTransferDestShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_dest_should_differ")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::RemovedAndTransferAdminShouldDiffer => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "removed_and_transfer_admin_should_differ")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::TransferDestUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_found")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::TransferDestUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "transfer_dest_user_not_in_team")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::TransferAdminUserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_in_team")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::TransferAdminUserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_user_not_found")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UnspecifiedTransferAdminId => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "unspecified_transfer_admin_id")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::TransferAdminIsNotAdmin => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "transfer_admin_is_not_admin")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::RecipientNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "recipient_not_verified")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UserDataIsBeingTransferred => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_data_is_being_transferred")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UserNotRemoved => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_not_removed")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UserDataCannotBeTransferred => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_data_cannot_be_transferred")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::UserDataAlreadyTransferred => {
                // unit
                let mut s = serializer.serialize_struct("MembersTransferFormerMembersFilesError", 1)?;
                s.serialize_field(".tag", "user_data_already_transferred")?;
                s.end()
            }
            MembersTransferFormerMembersFilesError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersTransferFormerMembersFilesError {
}

impl ::std::fmt::Display for MembersTransferFormerMembersFilesError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersTransferFormerMembersFilesError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersTransferFormerMembersFilesError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersTransferFormerMembersFilesError::RemovedAndTransferDestShouldDiffer => f.write_str("Expected removed user and transfer_dest user to be different."),
            MembersTransferFormerMembersFilesError::RemovedAndTransferAdminShouldDiffer => f.write_str("Expected removed user and transfer_admin user to be different."),
            MembersTransferFormerMembersFilesError::TransferDestUserNotFound => f.write_str("No matching user found for the argument transfer_dest_id."),
            MembersTransferFormerMembersFilesError::TransferDestUserNotInTeam => f.write_str("The provided transfer_dest_id does not exist on this team."),
            MembersTransferFormerMembersFilesError::TransferAdminUserNotInTeam => f.write_str("The provided transfer_admin_id does not exist on this team."),
            MembersTransferFormerMembersFilesError::TransferAdminUserNotFound => f.write_str("No matching user found for the argument transfer_admin_id."),
            MembersTransferFormerMembersFilesError::UnspecifiedTransferAdminId => f.write_str("The transfer_admin_id argument must be provided when file transfer is requested."),
            MembersTransferFormerMembersFilesError::TransferAdminIsNotAdmin => f.write_str("Specified transfer_admin user is not a team admin."),
            MembersTransferFormerMembersFilesError::RecipientNotVerified => f.write_str("The recipient user's email is not verified."),
            MembersTransferFormerMembersFilesError::UserDataIsBeingTransferred => f.write_str("The user's data is being transferred. Please wait some time before retrying."),
            MembersTransferFormerMembersFilesError::UserNotRemoved => f.write_str("No matching removed user found for the argument user."),
            MembersTransferFormerMembersFilesError::UserDataCannotBeTransferred => f.write_str("User files aren't transferable anymore."),
            MembersTransferFormerMembersFilesError::UserDataAlreadyTransferred => f.write_str("User's data has already been transferred to another user."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Exactly one of team_member_id, email, or external_id must be provided to identify the user
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembersUnsuspendArg {
    /// Identity of user to unsuspend.
    pub user: UserSelectorArg,
}

impl MembersUnsuspendArg {
    pub fn new(user: UserSelectorArg) -> Self {
        MembersUnsuspendArg {
            user,
        }
    }
}

const MEMBERS_UNSUSPEND_ARG_FIELDS: &[&str] = &["user"];
impl MembersUnsuspendArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembersUnsuspendArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembersUnsuspendArg>, V::Error> {
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembersUnsuspendArg {
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user", &self.user)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembersUnsuspendArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembersUnsuspendArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersUnsuspendArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembersUnsuspendArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembersUnsuspendArg", MEMBERS_UNSUSPEND_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembersUnsuspendArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembersUnsuspendArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MembersUnsuspendError {
    /// No matching user found. The provided team_member_id, email, or external_id does not exist on
    /// this team.
    UserNotFound,
    /// The user is not a member of the team.
    UserNotInTeam,
    /// The user is unsuspended, so it cannot be unsuspended again.
    UnsuspendNonSuspendedMember,
    /// Team is full. The organization has no available licenses.
    TeamLicenseLimit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MembersUnsuspendError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MembersUnsuspendError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembersUnsuspendError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_found" => MembersUnsuspendError::UserNotFound,
                    "user_not_in_team" => MembersUnsuspendError::UserNotInTeam,
                    "unsuspend_non_suspended_member" => MembersUnsuspendError::UnsuspendNonSuspendedMember,
                    "team_license_limit" => MembersUnsuspendError::TeamLicenseLimit,
                    _ => MembersUnsuspendError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_found",
                                    "user_not_in_team",
                                    "other",
                                    "unsuspend_non_suspended_member",
                                    "team_license_limit"];
        deserializer.deserialize_struct("MembersUnsuspendError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MembersUnsuspendError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MembersUnsuspendError::UserNotFound => {
                // unit
                let mut s = serializer.serialize_struct("MembersUnsuspendError", 1)?;
                s.serialize_field(".tag", "user_not_found")?;
                s.end()
            }
            MembersUnsuspendError::UserNotInTeam => {
                // unit
                let mut s = serializer.serialize_struct("MembersUnsuspendError", 1)?;
                s.serialize_field(".tag", "user_not_in_team")?;
                s.end()
            }
            MembersUnsuspendError::UnsuspendNonSuspendedMember => {
                // unit
                let mut s = serializer.serialize_struct("MembersUnsuspendError", 1)?;
                s.serialize_field(".tag", "unsuspend_non_suspended_member")?;
                s.end()
            }
            MembersUnsuspendError::TeamLicenseLimit => {
                // unit
                let mut s = serializer.serialize_struct("MembersUnsuspendError", 1)?;
                s.serialize_field(".tag", "team_license_limit")?;
                s.end()
            }
            MembersUnsuspendError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MembersUnsuspendError {
}

impl ::std::fmt::Display for MembersUnsuspendError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MembersUnsuspendError::UserNotFound => f.write_str("No matching user found. The provided team_member_id, email, or external_id does not exist on this team."),
            MembersUnsuspendError::UserNotInTeam => f.write_str("The user is not a member of the team."),
            MembersUnsuspendError::UnsuspendNonSuspendedMember => f.write_str("The user is unsuspended, so it cannot be unsuspended again."),
            MembersUnsuspendError::TeamLicenseLimit => f.write_str("Team is full. The organization has no available licenses."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MobileClientPlatform {
    /// Official Dropbox iPhone client.
    Iphone,
    /// Official Dropbox iPad client.
    Ipad,
    /// Official Dropbox Android client.
    Android,
    /// Official Dropbox Windows phone client.
    WindowsPhone,
    /// Official Dropbox Blackberry client.
    Blackberry,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MobileClientPlatform {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MobileClientPlatform;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MobileClientPlatform structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "iphone" => MobileClientPlatform::Iphone,
                    "ipad" => MobileClientPlatform::Ipad,
                    "android" => MobileClientPlatform::Android,
                    "windows_phone" => MobileClientPlatform::WindowsPhone,
                    "blackberry" => MobileClientPlatform::Blackberry,
                    _ => MobileClientPlatform::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["iphone",
                                    "ipad",
                                    "android",
                                    "windows_phone",
                                    "blackberry",
                                    "other"];
        deserializer.deserialize_struct("MobileClientPlatform", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MobileClientPlatform {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MobileClientPlatform::Iphone => {
                // unit
                let mut s = serializer.serialize_struct("MobileClientPlatform", 1)?;
                s.serialize_field(".tag", "iphone")?;
                s.end()
            }
            MobileClientPlatform::Ipad => {
                // unit
                let mut s = serializer.serialize_struct("MobileClientPlatform", 1)?;
                s.serialize_field(".tag", "ipad")?;
                s.end()
            }
            MobileClientPlatform::Android => {
                // unit
                let mut s = serializer.serialize_struct("MobileClientPlatform", 1)?;
                s.serialize_field(".tag", "android")?;
                s.end()
            }
            MobileClientPlatform::WindowsPhone => {
                // unit
                let mut s = serializer.serialize_struct("MobileClientPlatform", 1)?;
                s.serialize_field(".tag", "windows_phone")?;
                s.end()
            }
            MobileClientPlatform::Blackberry => {
                // unit
                let mut s = serializer.serialize_struct("MobileClientPlatform", 1)?;
                s.serialize_field(".tag", "blackberry")?;
                s.end()
            }
            MobileClientPlatform::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Information about linked Dropbox mobile client sessions.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MobileClientSession {
    /// The session id.
    pub session_id: String,
    /// The device name.
    pub device_name: String,
    /// The mobile application type.
    pub client_type: MobileClientPlatform,
    /// The IP address of the last activity from this session.
    pub ip_address: Option<String>,
    /// The country from which the last activity from this session was made.
    pub country: Option<String>,
    /// The time this session was created.
    pub created: Option<super::common::DropboxTimestamp>,
    /// The time of the last activity from this session.
    pub updated: Option<super::common::DropboxTimestamp>,
    /// The dropbox client version.
    pub client_version: Option<String>,
    /// The hosting OS version.
    pub os_version: Option<String>,
    /// last carrier used by the device.
    pub last_carrier: Option<String>,
}

impl MobileClientSession {
    pub fn new(
        session_id: String,
        device_name: String,
        client_type: MobileClientPlatform,
    ) -> Self {
        MobileClientSession {
            session_id,
            device_name,
            client_type,
            ip_address: None,
            country: None,
            created: None,
            updated: None,
            client_version: None,
            os_version: None,
            last_carrier: None,
        }
    }

    pub fn with_ip_address(mut self, value: String) -> Self {
        self.ip_address = Some(value);
        self
    }

    pub fn with_country(mut self, value: String) -> Self {
        self.country = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }

    pub fn with_updated(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.updated = Some(value);
        self
    }

    pub fn with_client_version(mut self, value: String) -> Self {
        self.client_version = Some(value);
        self
    }

    pub fn with_os_version(mut self, value: String) -> Self {
        self.os_version = Some(value);
        self
    }

    pub fn with_last_carrier(mut self, value: String) -> Self {
        self.last_carrier = Some(value);
        self
    }
}

const MOBILE_CLIENT_SESSION_FIELDS: &[&str] = &["session_id",
                                                "device_name",
                                                "client_type",
                                                "ip_address",
                                                "country",
                                                "created",
                                                "updated",
                                                "client_version",
                                                "os_version",
                                                "last_carrier"];
impl MobileClientSession {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MobileClientSession, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MobileClientSession>, V::Error> {
        let mut field_session_id = None;
        let mut field_device_name = None;
        let mut field_client_type = None;
        let mut field_ip_address = None;
        let mut field_country = None;
        let mut field_created = None;
        let mut field_updated = None;
        let mut field_client_version = None;
        let mut field_os_version = None;
        let mut field_last_carrier = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "device_name" => {
                    if field_device_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("device_name"));
                    }
                    field_device_name = Some(map.next_value()?);
                }
                "client_type" => {
                    if field_client_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_type"));
                    }
                    field_client_type = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                "country" => {
                    if field_country.is_some() {
                        return Err(::serde::de::Error::duplicate_field("country"));
                    }
                    field_country = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "updated" => {
                    if field_updated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("updated"));
                    }
                    field_updated = Some(map.next_value()?);
                }
                "client_version" => {
                    if field_client_version.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_version"));
                    }
                    field_client_version = Some(map.next_value()?);
                }
                "os_version" => {
                    if field_os_version.is_some() {
                        return Err(::serde::de::Error::duplicate_field("os_version"));
                    }
                    field_os_version = Some(map.next_value()?);
                }
                "last_carrier" => {
                    if field_last_carrier.is_some() {
                        return Err(::serde::de::Error::duplicate_field("last_carrier"));
                    }
                    field_last_carrier = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MobileClientSession {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            device_name: field_device_name.ok_or_else(|| ::serde::de::Error::missing_field("device_name"))?,
            client_type: field_client_type.ok_or_else(|| ::serde::de::Error::missing_field("client_type"))?,
            ip_address: field_ip_address,
            country: field_country,
            created: field_created,
            updated: field_updated,
            client_version: field_client_version,
            os_version: field_os_version,
            last_carrier: field_last_carrier,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("device_name", &self.device_name)?;
        s.serialize_field("client_type", &self.client_type)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        if let Some(val) = &self.country {
            s.serialize_field("country", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        if let Some(val) = &self.updated {
            s.serialize_field("updated", val)?;
        }
        if let Some(val) = &self.client_version {
            s.serialize_field("client_version", val)?;
        }
        if let Some(val) = &self.os_version {
            s.serialize_field("os_version", val)?;
        }
        if let Some(val) = &self.last_carrier {
            s.serialize_field("last_carrier", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MobileClientSession {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MobileClientSession;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MobileClientSession struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MobileClientSession::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MobileClientSession", MOBILE_CLIENT_SESSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MobileClientSession {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MobileClientSession", 10)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Properties of a namespace.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct NamespaceMetadata {
    /// The name of this namespace.
    pub name: String,
    /// The ID of this namespace.
    pub namespace_id: super::common::SharedFolderId,
    /// The type of this namespace.
    pub namespace_type: NamespaceType,
    /// If this is a team member or app folder, the ID of the owning team member. Otherwise, this
    /// field is not present.
    pub team_member_id: Option<super::team_common::TeamMemberId>,
}

impl NamespaceMetadata {
    pub fn new(
        name: String,
        namespace_id: super::common::SharedFolderId,
        namespace_type: NamespaceType,
    ) -> Self {
        NamespaceMetadata {
            name,
            namespace_id,
            namespace_type,
            team_member_id: None,
        }
    }

    pub fn with_team_member_id(mut self, value: super::team_common::TeamMemberId) -> Self {
        self.team_member_id = Some(value);
        self
    }
}

const NAMESPACE_METADATA_FIELDS: &[&str] = &["name",
                                             "namespace_id",
                                             "namespace_type",
                                             "team_member_id"];
impl NamespaceMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<NamespaceMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<NamespaceMetadata>, V::Error> {
        let mut field_name = None;
        let mut field_namespace_id = None;
        let mut field_namespace_type = None;
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "namespace_id" => {
                    if field_namespace_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("namespace_id"));
                    }
                    field_namespace_id = Some(map.next_value()?);
                }
                "namespace_type" => {
                    if field_namespace_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("namespace_type"));
                    }
                    field_namespace_type = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = NamespaceMetadata {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            namespace_id: field_namespace_id.ok_or_else(|| ::serde::de::Error::missing_field("namespace_id"))?,
            namespace_type: field_namespace_type.ok_or_else(|| ::serde::de::Error::missing_field("namespace_type"))?,
            team_member_id: field_team_member_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("namespace_id", &self.namespace_id)?;
        s.serialize_field("namespace_type", &self.namespace_type)?;
        if let Some(val) = &self.team_member_id {
            s.serialize_field("team_member_id", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for NamespaceMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = NamespaceMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a NamespaceMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                NamespaceMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("NamespaceMetadata", NAMESPACE_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for NamespaceMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("NamespaceMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum NamespaceType {
    /// App sandbox folder.
    AppFolder,
    /// Shared folder.
    SharedFolder,
    /// Top-level team-owned folder.
    TeamFolder,
    /// Team member's home folder.
    TeamMemberFolder,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for NamespaceType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = NamespaceType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a NamespaceType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "app_folder" => NamespaceType::AppFolder,
                    "shared_folder" => NamespaceType::SharedFolder,
                    "team_folder" => NamespaceType::TeamFolder,
                    "team_member_folder" => NamespaceType::TeamMemberFolder,
                    _ => NamespaceType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["app_folder",
                                    "shared_folder",
                                    "team_folder",
                                    "team_member_folder",
                                    "other"];
        deserializer.deserialize_struct("NamespaceType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for NamespaceType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            NamespaceType::AppFolder => {
                // unit
                let mut s = serializer.serialize_struct("NamespaceType", 1)?;
                s.serialize_field(".tag", "app_folder")?;
                s.end()
            }
            NamespaceType::SharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("NamespaceType", 1)?;
                s.serialize_field(".tag", "shared_folder")?;
                s.end()
            }
            NamespaceType::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("NamespaceType", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            NamespaceType::TeamMemberFolder => {
                // unit
                let mut s = serializer.serialize_struct("NamespaceType", 1)?;
                s.serialize_field(".tag", "team_member_folder")?;
                s.end()
            }
            NamespaceType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// User result for setting member custom quota.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RemoveCustomQuotaResult {
    /// Successfully removed user.
    Success(UserSelectorArg),
    /// Invalid user (not in team).
    InvalidUser(UserSelectorArg),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveCustomQuotaResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RemoveCustomQuotaResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveCustomQuotaResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => {
                        match map.next_key()? {
                            Some("success") => RemoveCustomQuotaResult::Success(map.next_value()?),
                            None => return Err(de::Error::missing_field("success")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_user" => {
                        match map.next_key()? {
                            Some("invalid_user") => RemoveCustomQuotaResult::InvalidUser(map.next_value()?),
                            None => return Err(de::Error::missing_field("invalid_user")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => RemoveCustomQuotaResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "invalid_user",
                                    "other"];
        deserializer.deserialize_struct("RemoveCustomQuotaResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveCustomQuotaResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RemoveCustomQuotaResult::Success(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveCustomQuotaResult", 2)?;
                s.serialize_field(".tag", "success")?;
                s.serialize_field("success", x)?;
                s.end()
            }
            RemoveCustomQuotaResult::InvalidUser(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveCustomQuotaResult", 2)?;
                s.serialize_field(".tag", "invalid_user")?;
                s.serialize_field("invalid_user", x)?;
                s.end()
            }
            RemoveCustomQuotaResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RemovedStatus {
    /// True if the removed team member is recoverable.
    pub is_recoverable: bool,
    /// True if the team member's account was converted to individual account.
    pub is_disconnected: bool,
}

impl RemovedStatus {
    pub fn new(is_recoverable: bool, is_disconnected: bool) -> Self {
        RemovedStatus {
            is_recoverable,
            is_disconnected,
        }
    }
}

const REMOVED_STATUS_FIELDS: &[&str] = &["is_recoverable",
                                         "is_disconnected"];
impl RemovedStatus {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RemovedStatus, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RemovedStatus>, V::Error> {
        let mut field_is_recoverable = None;
        let mut field_is_disconnected = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "is_recoverable" => {
                    if field_is_recoverable.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_recoverable"));
                    }
                    field_is_recoverable = Some(map.next_value()?);
                }
                "is_disconnected" => {
                    if field_is_disconnected.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_disconnected"));
                    }
                    field_is_disconnected = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RemovedStatus {
            is_recoverable: field_is_recoverable.ok_or_else(|| ::serde::de::Error::missing_field("is_recoverable"))?,
            is_disconnected: field_is_disconnected.ok_or_else(|| ::serde::de::Error::missing_field("is_disconnected"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("is_recoverable", &self.is_recoverable)?;
        s.serialize_field("is_disconnected", &self.is_disconnected)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RemovedStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RemovedStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemovedStatus struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RemovedStatus::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RemovedStatus", REMOVED_STATUS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RemovedStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RemovedStatus", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Result of trying to resend verification email to a secondary email address. 'success' is the
/// only value indicating that a verification email was successfully sent. The other values explain
/// the type of error that occurred, and include the email for which the error occurred.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ResendSecondaryEmailResult {
    /// A verification email was successfully sent to the secondary email address.
    Success(super::common::EmailAddress),
    /// This secondary email address is not pending for the user.
    NotPending(super::common::EmailAddress),
    /// Too many emails are being sent to this email address. Please try again later.
    RateLimited(super::common::EmailAddress),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ResendSecondaryEmailResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ResendSecondaryEmailResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ResendSecondaryEmailResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => {
                        match map.next_key()? {
                            Some("success") => ResendSecondaryEmailResult::Success(map.next_value()?),
                            None => return Err(de::Error::missing_field("success")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "not_pending" => {
                        match map.next_key()? {
                            Some("not_pending") => ResendSecondaryEmailResult::NotPending(map.next_value()?),
                            None => return Err(de::Error::missing_field("not_pending")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "rate_limited" => {
                        match map.next_key()? {
                            Some("rate_limited") => ResendSecondaryEmailResult::RateLimited(map.next_value()?),
                            None => return Err(de::Error::missing_field("rate_limited")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ResendSecondaryEmailResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "not_pending",
                                    "rate_limited",
                                    "other"];
        deserializer.deserialize_struct("ResendSecondaryEmailResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ResendSecondaryEmailResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ResendSecondaryEmailResult::Success(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("ResendSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "success")?;
                s.serialize_field("success", x)?;
                s.end()
            }
            ResendSecondaryEmailResult::NotPending(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("ResendSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "not_pending")?;
                s.serialize_field("not_pending", x)?;
                s.end()
            }
            ResendSecondaryEmailResult::RateLimited(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("ResendSecondaryEmailResult", 2)?;
                s.serialize_field(".tag", "rate_limited")?;
                s.serialize_field("rate_limited", x)?;
                s.end()
            }
            ResendSecondaryEmailResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ResendVerificationEmailArg {
    /// List of users and secondary emails to resend verification emails to.
    pub emails_to_resend: Vec<UserSecondaryEmailsArg>,
}

impl ResendVerificationEmailArg {
    pub fn new(emails_to_resend: Vec<UserSecondaryEmailsArg>) -> Self {
        ResendVerificationEmailArg {
            emails_to_resend,
        }
    }
}

const RESEND_VERIFICATION_EMAIL_ARG_FIELDS: &[&str] = &["emails_to_resend"];
impl ResendVerificationEmailArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ResendVerificationEmailArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ResendVerificationEmailArg>, V::Error> {
        let mut field_emails_to_resend = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "emails_to_resend" => {
                    if field_emails_to_resend.is_some() {
                        return Err(::serde::de::Error::duplicate_field("emails_to_resend"));
                    }
                    field_emails_to_resend = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ResendVerificationEmailArg {
            emails_to_resend: field_emails_to_resend.ok_or_else(|| ::serde::de::Error::missing_field("emails_to_resend"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("emails_to_resend", &self.emails_to_resend)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ResendVerificationEmailArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ResendVerificationEmailArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ResendVerificationEmailArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ResendVerificationEmailArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ResendVerificationEmailArg", RESEND_VERIFICATION_EMAIL_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ResendVerificationEmailArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ResendVerificationEmailArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// List of users and resend results.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ResendVerificationEmailResult {
    pub results: Vec<UserResendResult>,
}

impl ResendVerificationEmailResult {
    pub fn new(results: Vec<UserResendResult>) -> Self {
        ResendVerificationEmailResult {
            results,
        }
    }
}

const RESEND_VERIFICATION_EMAIL_RESULT_FIELDS: &[&str] = &["results"];
impl ResendVerificationEmailResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ResendVerificationEmailResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ResendVerificationEmailResult>, V::Error> {
        let mut field_results = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "results" => {
                    if field_results.is_some() {
                        return Err(::serde::de::Error::duplicate_field("results"));
                    }
                    field_results = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ResendVerificationEmailResult {
            results: field_results.ok_or_else(|| ::serde::de::Error::missing_field("results"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("results", &self.results)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ResendVerificationEmailResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ResendVerificationEmailResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ResendVerificationEmailResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ResendVerificationEmailResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ResendVerificationEmailResult", RESEND_VERIFICATION_EMAIL_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ResendVerificationEmailResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ResendVerificationEmailResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeDesktopClientArg {
    /// The session id.
    pub session_id: String,
    /// The unique id of the member owning the device.
    pub team_member_id: String,
    /// Whether to delete all files of the account (this is possible only if supported by the
    /// desktop client and  will be made the next time the client access the account).
    pub delete_on_unlink: bool,
}

impl RevokeDesktopClientArg {
    pub fn new(session_id: String, team_member_id: String) -> Self {
        RevokeDesktopClientArg {
            session_id,
            team_member_id,
            delete_on_unlink: false,
        }
    }

    pub fn with_delete_on_unlink(mut self, value: bool) -> Self {
        self.delete_on_unlink = value;
        self
    }
}

const REVOKE_DESKTOP_CLIENT_ARG_FIELDS: &[&str] = &["session_id",
                                                    "team_member_id",
                                                    "delete_on_unlink"];
impl RevokeDesktopClientArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeDesktopClientArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeDesktopClientArg>, V::Error> {
        let mut field_session_id = None;
        let mut field_team_member_id = None;
        let mut field_delete_on_unlink = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "delete_on_unlink" => {
                    if field_delete_on_unlink.is_some() {
                        return Err(::serde::de::Error::duplicate_field("delete_on_unlink"));
                    }
                    field_delete_on_unlink = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeDesktopClientArg {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            delete_on_unlink: field_delete_on_unlink.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("delete_on_unlink", &self.delete_on_unlink)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDesktopClientArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeDesktopClientArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDesktopClientArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeDesktopClientArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeDesktopClientArg", REVOKE_DESKTOP_CLIENT_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDesktopClientArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeDesktopClientArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum RevokeDeviceSessionArg {
    /// End an active session.
    WebSession(DeviceSessionArg),
    /// Unlink a linked desktop device.
    DesktopClient(RevokeDesktopClientArg),
    /// Unlink a linked mobile device.
    MobileClient(DeviceSessionArg),
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeDeviceSessionArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionArg structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "web_session" => RevokeDeviceSessionArg::WebSession(DeviceSessionArg::internal_deserialize(&mut map)?),
                    "desktop_client" => RevokeDeviceSessionArg::DesktopClient(RevokeDesktopClientArg::internal_deserialize(&mut map)?),
                    "mobile_client" => RevokeDeviceSessionArg::MobileClient(DeviceSessionArg::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["web_session",
                                    "desktop_client",
                                    "mobile_client"];
        deserializer.deserialize_struct("RevokeDeviceSessionArg", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RevokeDeviceSessionArg::WebSession(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RevokeDeviceSessionArg", 3)?;
                s.serialize_field(".tag", "web_session")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RevokeDeviceSessionArg::DesktopClient(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RevokeDeviceSessionArg", 4)?;
                s.serialize_field(".tag", "desktop_client")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RevokeDeviceSessionArg::MobileClient(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RevokeDeviceSessionArg", 3)?;
                s.serialize_field(".tag", "mobile_client")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeDeviceSessionBatchArg {
    pub revoke_devices: Vec<RevokeDeviceSessionArg>,
}

impl RevokeDeviceSessionBatchArg {
    pub fn new(revoke_devices: Vec<RevokeDeviceSessionArg>) -> Self {
        RevokeDeviceSessionBatchArg {
            revoke_devices,
        }
    }
}

const REVOKE_DEVICE_SESSION_BATCH_ARG_FIELDS: &[&str] = &["revoke_devices"];
impl RevokeDeviceSessionBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeDeviceSessionBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeDeviceSessionBatchArg>, V::Error> {
        let mut field_revoke_devices = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "revoke_devices" => {
                    if field_revoke_devices.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revoke_devices"));
                    }
                    field_revoke_devices = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeDeviceSessionBatchArg {
            revoke_devices: field_revoke_devices.ok_or_else(|| ::serde::de::Error::missing_field("revoke_devices"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("revoke_devices", &self.revoke_devices)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeDeviceSessionBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeDeviceSessionBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeDeviceSessionBatchArg", REVOKE_DEVICE_SESSION_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeDeviceSessionBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}


#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RevokeDeviceSessionBatchError {
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeDeviceSessionBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                // open enum with no defined variants
                let _ = tag;
                crate::eat_json_fields(&mut map)?;
                Ok(RevokeDeviceSessionBatchError::Other)
            }
        }
        const VARIANTS: &[&str] = &["other"];
        deserializer.deserialize_struct("RevokeDeviceSessionBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        #![allow(unused_variables)]
        Err(::serde::ser::Error::custom("cannot serialize an open union with no defined variants"))
    }
}

impl ::std::error::Error for RevokeDeviceSessionBatchError {
}

impl ::std::fmt::Display for RevokeDeviceSessionBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeDeviceSessionBatchResult {
    pub revoke_devices_status: Vec<RevokeDeviceSessionStatus>,
}

impl RevokeDeviceSessionBatchResult {
    pub fn new(revoke_devices_status: Vec<RevokeDeviceSessionStatus>) -> Self {
        RevokeDeviceSessionBatchResult {
            revoke_devices_status,
        }
    }
}

const REVOKE_DEVICE_SESSION_BATCH_RESULT_FIELDS: &[&str] = &["revoke_devices_status"];
impl RevokeDeviceSessionBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeDeviceSessionBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeDeviceSessionBatchResult>, V::Error> {
        let mut field_revoke_devices_status = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "revoke_devices_status" => {
                    if field_revoke_devices_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revoke_devices_status"));
                    }
                    field_revoke_devices_status = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeDeviceSessionBatchResult {
            revoke_devices_status: field_revoke_devices_status.ok_or_else(|| ::serde::de::Error::missing_field("revoke_devices_status"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("revoke_devices_status", &self.revoke_devices_status)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeDeviceSessionBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeDeviceSessionBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeDeviceSessionBatchResult", REVOKE_DEVICE_SESSION_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeDeviceSessionBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RevokeDeviceSessionError {
    /// Device session not found.
    DeviceSessionNotFound,
    /// Member not found.
    MemberNotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeDeviceSessionError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "device_session_not_found" => RevokeDeviceSessionError::DeviceSessionNotFound,
                    "member_not_found" => RevokeDeviceSessionError::MemberNotFound,
                    _ => RevokeDeviceSessionError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["device_session_not_found",
                                    "member_not_found",
                                    "other"];
        deserializer.deserialize_struct("RevokeDeviceSessionError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RevokeDeviceSessionError::DeviceSessionNotFound => {
                // unit
                let mut s = serializer.serialize_struct("RevokeDeviceSessionError", 1)?;
                s.serialize_field(".tag", "device_session_not_found")?;
                s.end()
            }
            RevokeDeviceSessionError::MemberNotFound => {
                // unit
                let mut s = serializer.serialize_struct("RevokeDeviceSessionError", 1)?;
                s.serialize_field(".tag", "member_not_found")?;
                s.end()
            }
            RevokeDeviceSessionError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RevokeDeviceSessionError {
}

impl ::std::fmt::Display for RevokeDeviceSessionError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RevokeDeviceSessionError::DeviceSessionNotFound => f.write_str("Device session not found."),
            RevokeDeviceSessionError::MemberNotFound => f.write_str("Member not found."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeDeviceSessionStatus {
    /// Result of the revoking request.
    pub success: bool,
    /// The error cause in case of a failure.
    pub error_type: Option<RevokeDeviceSessionError>,
}

impl RevokeDeviceSessionStatus {
    pub fn new(success: bool) -> Self {
        RevokeDeviceSessionStatus {
            success,
            error_type: None,
        }
    }

    pub fn with_error_type(mut self, value: RevokeDeviceSessionError) -> Self {
        self.error_type = Some(value);
        self
    }
}

const REVOKE_DEVICE_SESSION_STATUS_FIELDS: &[&str] = &["success",
                                                       "error_type"];
impl RevokeDeviceSessionStatus {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeDeviceSessionStatus, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeDeviceSessionStatus>, V::Error> {
        let mut field_success = None;
        let mut field_error_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "success" => {
                    if field_success.is_some() {
                        return Err(::serde::de::Error::duplicate_field("success"));
                    }
                    field_success = Some(map.next_value()?);
                }
                "error_type" => {
                    if field_error_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("error_type"));
                    }
                    field_error_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeDeviceSessionStatus {
            success: field_success.ok_or_else(|| ::serde::de::Error::missing_field("success"))?,
            error_type: field_error_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("success", &self.success)?;
        if let Some(val) = &self.error_type {
            s.serialize_field("error_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeDeviceSessionStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeDeviceSessionStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeDeviceSessionStatus struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeDeviceSessionStatus::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeDeviceSessionStatus", REVOKE_DEVICE_SESSION_STATUS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeDeviceSessionStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeDeviceSessionStatus", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeLinkedApiAppArg {
    /// The application's unique id.
    pub app_id: String,
    /// The unique id of the member owning the device.
    pub team_member_id: String,
    /// This flag is not longer supported, the application dedicated folder (in case the application
    /// uses  one) will be kept.
    pub keep_app_folder: bool,
}

impl RevokeLinkedApiAppArg {
    pub fn new(app_id: String, team_member_id: String) -> Self {
        RevokeLinkedApiAppArg {
            app_id,
            team_member_id,
            keep_app_folder: true,
        }
    }

    pub fn with_keep_app_folder(mut self, value: bool) -> Self {
        self.keep_app_folder = value;
        self
    }
}

const REVOKE_LINKED_API_APP_ARG_FIELDS: &[&str] = &["app_id",
                                                    "team_member_id",
                                                    "keep_app_folder"];
impl RevokeLinkedApiAppArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeLinkedApiAppArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeLinkedApiAppArg>, V::Error> {
        let mut field_app_id = None;
        let mut field_team_member_id = None;
        let mut field_keep_app_folder = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_id" => {
                    if field_app_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_id"));
                    }
                    field_app_id = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                "keep_app_folder" => {
                    if field_keep_app_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("keep_app_folder"));
                    }
                    field_keep_app_folder = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeLinkedApiAppArg {
            app_id: field_app_id.ok_or_else(|| ::serde::de::Error::missing_field("app_id"))?,
            team_member_id: field_team_member_id.ok_or_else(|| ::serde::de::Error::missing_field("team_member_id"))?,
            keep_app_folder: field_keep_app_folder.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_id", &self.app_id)?;
        s.serialize_field("team_member_id", &self.team_member_id)?;
        s.serialize_field("keep_app_folder", &self.keep_app_folder)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedApiAppArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeLinkedApiAppArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedApiAppArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeLinkedApiAppArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeLinkedApiAppArg", REVOKE_LINKED_API_APP_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedApiAppArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeLinkedApiAppArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeLinkedApiAppBatchArg {
    pub revoke_linked_app: Vec<RevokeLinkedApiAppArg>,
}

impl RevokeLinkedApiAppBatchArg {
    pub fn new(revoke_linked_app: Vec<RevokeLinkedApiAppArg>) -> Self {
        RevokeLinkedApiAppBatchArg {
            revoke_linked_app,
        }
    }
}

const REVOKE_LINKED_API_APP_BATCH_ARG_FIELDS: &[&str] = &["revoke_linked_app"];
impl RevokeLinkedApiAppBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeLinkedApiAppBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeLinkedApiAppBatchArg>, V::Error> {
        let mut field_revoke_linked_app = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "revoke_linked_app" => {
                    if field_revoke_linked_app.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revoke_linked_app"));
                    }
                    field_revoke_linked_app = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeLinkedApiAppBatchArg {
            revoke_linked_app: field_revoke_linked_app.ok_or_else(|| ::serde::de::Error::missing_field("revoke_linked_app"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("revoke_linked_app", &self.revoke_linked_app)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedApiAppBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeLinkedApiAppBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedApiAppBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeLinkedApiAppBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeLinkedApiAppBatchArg", REVOKE_LINKED_API_APP_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedApiAppBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeLinkedApiAppBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned by
/// [`linked_apps_revoke_linked_app_batch()`](linked_apps_revoke_linked_app_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RevokeLinkedAppBatchError {
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedAppBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeLinkedAppBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedAppBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                // open enum with no defined variants
                let _ = tag;
                crate::eat_json_fields(&mut map)?;
                Ok(RevokeLinkedAppBatchError::Other)
            }
        }
        const VARIANTS: &[&str] = &["other"];
        deserializer.deserialize_struct("RevokeLinkedAppBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedAppBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        #![allow(unused_variables)]
        Err(::serde::ser::Error::custom("cannot serialize an open union with no defined variants"))
    }
}

impl ::std::error::Error for RevokeLinkedAppBatchError {
}

impl ::std::fmt::Display for RevokeLinkedAppBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeLinkedAppBatchResult {
    pub revoke_linked_app_status: Vec<RevokeLinkedAppStatus>,
}

impl RevokeLinkedAppBatchResult {
    pub fn new(revoke_linked_app_status: Vec<RevokeLinkedAppStatus>) -> Self {
        RevokeLinkedAppBatchResult {
            revoke_linked_app_status,
        }
    }
}

const REVOKE_LINKED_APP_BATCH_RESULT_FIELDS: &[&str] = &["revoke_linked_app_status"];
impl RevokeLinkedAppBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeLinkedAppBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeLinkedAppBatchResult>, V::Error> {
        let mut field_revoke_linked_app_status = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "revoke_linked_app_status" => {
                    if field_revoke_linked_app_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revoke_linked_app_status"));
                    }
                    field_revoke_linked_app_status = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeLinkedAppBatchResult {
            revoke_linked_app_status: field_revoke_linked_app_status.ok_or_else(|| ::serde::de::Error::missing_field("revoke_linked_app_status"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("revoke_linked_app_status", &self.revoke_linked_app_status)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedAppBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeLinkedAppBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedAppBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeLinkedAppBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeLinkedAppBatchResult", REVOKE_LINKED_APP_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedAppBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeLinkedAppBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned by [`linked_apps_revoke_linked_app()`](linked_apps_revoke_linked_app).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RevokeLinkedAppError {
    /// Application not found.
    AppNotFound,
    /// Member not found.
    MemberNotFound,
    /// App folder removal is not supported.
    AppFolderRemovalNotSupported,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedAppError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeLinkedAppError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedAppError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "app_not_found" => RevokeLinkedAppError::AppNotFound,
                    "member_not_found" => RevokeLinkedAppError::MemberNotFound,
                    "app_folder_removal_not_supported" => RevokeLinkedAppError::AppFolderRemovalNotSupported,
                    _ => RevokeLinkedAppError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["app_not_found",
                                    "member_not_found",
                                    "app_folder_removal_not_supported",
                                    "other"];
        deserializer.deserialize_struct("RevokeLinkedAppError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedAppError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RevokeLinkedAppError::AppNotFound => {
                // unit
                let mut s = serializer.serialize_struct("RevokeLinkedAppError", 1)?;
                s.serialize_field(".tag", "app_not_found")?;
                s.end()
            }
            RevokeLinkedAppError::MemberNotFound => {
                // unit
                let mut s = serializer.serialize_struct("RevokeLinkedAppError", 1)?;
                s.serialize_field(".tag", "member_not_found")?;
                s.end()
            }
            RevokeLinkedAppError::AppFolderRemovalNotSupported => {
                // unit
                let mut s = serializer.serialize_struct("RevokeLinkedAppError", 1)?;
                s.serialize_field(".tag", "app_folder_removal_not_supported")?;
                s.end()
            }
            RevokeLinkedAppError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RevokeLinkedAppError {
}

impl ::std::fmt::Display for RevokeLinkedAppError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RevokeLinkedAppError::AppNotFound => f.write_str("Application not found."),
            RevokeLinkedAppError::MemberNotFound => f.write_str("Member not found."),
            RevokeLinkedAppError::AppFolderRemovalNotSupported => f.write_str("App folder removal is not supported."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeLinkedAppStatus {
    /// Result of the revoking request.
    pub success: bool,
    /// The error cause in case of a failure.
    pub error_type: Option<RevokeLinkedAppError>,
}

impl RevokeLinkedAppStatus {
    pub fn new(success: bool) -> Self {
        RevokeLinkedAppStatus {
            success,
            error_type: None,
        }
    }

    pub fn with_error_type(mut self, value: RevokeLinkedAppError) -> Self {
        self.error_type = Some(value);
        self
    }
}

const REVOKE_LINKED_APP_STATUS_FIELDS: &[&str] = &["success",
                                                   "error_type"];
impl RevokeLinkedAppStatus {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeLinkedAppStatus, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeLinkedAppStatus>, V::Error> {
        let mut field_success = None;
        let mut field_error_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "success" => {
                    if field_success.is_some() {
                        return Err(::serde::de::Error::duplicate_field("success"));
                    }
                    field_success = Some(map.next_value()?);
                }
                "error_type" => {
                    if field_error_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("error_type"));
                    }
                    field_error_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeLinkedAppStatus {
            success: field_success.ok_or_else(|| ::serde::de::Error::missing_field("success"))?,
            error_type: field_error_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("success", &self.success)?;
        if let Some(val) = &self.error_type {
            s.serialize_field("error_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeLinkedAppStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeLinkedAppStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeLinkedAppStatus struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeLinkedAppStatus::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeLinkedAppStatus", REVOKE_LINKED_APP_STATUS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeLinkedAppStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeLinkedAppStatus", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SetCustomQuotaArg {
    /// List of users and their custom quotas.
    pub users_and_quotas: Vec<UserCustomQuotaArg>,
}

impl SetCustomQuotaArg {
    pub fn new(users_and_quotas: Vec<UserCustomQuotaArg>) -> Self {
        SetCustomQuotaArg {
            users_and_quotas,
        }
    }
}

const SET_CUSTOM_QUOTA_ARG_FIELDS: &[&str] = &["users_and_quotas"];
impl SetCustomQuotaArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SetCustomQuotaArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SetCustomQuotaArg>, V::Error> {
        let mut field_users_and_quotas = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "users_and_quotas" => {
                    if field_users_and_quotas.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users_and_quotas"));
                    }
                    field_users_and_quotas = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SetCustomQuotaArg {
            users_and_quotas: field_users_and_quotas.ok_or_else(|| ::serde::de::Error::missing_field("users_and_quotas"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("users_and_quotas", &self.users_and_quotas)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SetCustomQuotaArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SetCustomQuotaArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SetCustomQuotaArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SetCustomQuotaArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SetCustomQuotaArg", SET_CUSTOM_QUOTA_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SetCustomQuotaArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SetCustomQuotaArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error returned when setting member custom quota.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SetCustomQuotaError {
    /// A maximum of 1000 users can be set for a single call.
    TooManyUsers,
    /// Some of the users are on the excluded users list and can't have custom quota set.
    SomeUsersAreExcluded,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SetCustomQuotaError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SetCustomQuotaError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SetCustomQuotaError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "too_many_users" => SetCustomQuotaError::TooManyUsers,
                    "some_users_are_excluded" => SetCustomQuotaError::SomeUsersAreExcluded,
                    _ => SetCustomQuotaError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["too_many_users",
                                    "other",
                                    "some_users_are_excluded"];
        deserializer.deserialize_struct("SetCustomQuotaError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SetCustomQuotaError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SetCustomQuotaError::TooManyUsers => {
                // unit
                let mut s = serializer.serialize_struct("SetCustomQuotaError", 1)?;
                s.serialize_field(".tag", "too_many_users")?;
                s.end()
            }
            SetCustomQuotaError::SomeUsersAreExcluded => {
                // unit
                let mut s = serializer.serialize_struct("SetCustomQuotaError", 1)?;
                s.serialize_field(".tag", "some_users_are_excluded")?;
                s.end()
            }
            SetCustomQuotaError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SetCustomQuotaError {
}

impl ::std::fmt::Display for SetCustomQuotaError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SetCustomQuotaError::TooManyUsers => f.write_str("A maximum of 1000 users can be set for a single call."),
            SetCustomQuotaError::SomeUsersAreExcluded => f.write_str("Some of the users are on the excluded users list and can't have custom quota set."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Describes the number of users in a specific storage bucket.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct StorageBucket {
    /// The name of the storage bucket. For example, '1G' is a bucket of users with storage size up
    /// to 1 Giga.
    pub bucket: Stri