// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

//! This namespace contains endpoints and data types for basic file operations.

pub type CopyBatchArg = RelocationBatchArgBase;
pub type FileId = String;
pub type Id = String;
pub type ListFolderCursor = String;
pub type MalformedPathError = Option<String>;
pub type Path = String;
pub type PathOrId = String;
pub type PathR = String;
pub type PathROrId = String;
pub type ReadPath = String;
pub type Rev = String;
pub type SearchV2Cursor = String;
pub type Sha256HexHash = String;
pub type SharedLinkUrl = String;
pub type WritePath = String;
pub type WritePathOrId = String;

/// Returns the metadata for a file or folder. This is an alpha endpoint compatible with the
/// properties API. Note: Metadata for the root folder is unsupported.
#[deprecated(note = "replaced by get_metadata")]
pub fn alpha_get_metadata(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &AlphaGetMetadataArg,
) -> crate::Result<Result<Metadata, AlphaGetMetadataError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/alpha/get_metadata",
        arg,
        None)
}

/// Create a new file with the contents provided in the request. Note that this endpoint is part of
/// the properties API alpha and is slightly different from [`upload()`](upload). Do not use this to
/// upload a file larger than 150 MB. Instead, create an upload session with
/// [`upload_session_start()`](upload_session_start).
#[deprecated(note = "replaced by alpha_upload")]
pub fn alpha_upload(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CommitInfoWithProperties,
    body: &[u8],
) -> crate::Result<Result<FileMetadata, UploadErrorWithProperties>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/alpha/upload",
        arg,
        Some(body))
}

/// Copy a file or folder to a different location in the user's Dropbox. If the source path is a
/// folder all its contents will be copied.
pub fn copy_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationArg,
) -> crate::Result<Result<RelocationResult, RelocationError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_v2",
        arg,
        None)
}

/// Copy a file or folder to a different location in the user's Dropbox. If the source path is a
/// folder all its contents will be copied.
#[deprecated(note = "replaced by copy_v2")]
pub fn copy(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationArg,
) -> crate::Result<Result<Metadata, RelocationError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy",
        arg,
        None)
}

/// Copy multiple files or folders to different locations at once in the user's Dropbox. This route
/// will replace [`copy_batch()`](copy_batch). The main difference is this route will return status
/// for each entry, while [`copy_batch()`](copy_batch) raises failure if any entry fails. This route
/// will either finish synchronously, or return a job ID and do the async copy job in background.
/// Please use [`copy_batch_check_v2()`](copy_batch_check_v2) to check the job status.
pub fn copy_batch_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CopyBatchArg,
) -> crate::Result<Result<RelocationBatchV2Launch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_batch_v2",
        arg,
        None)
}

/// Copy multiple files or folders to different locations at once in the user's Dropbox. This route
/// will return job ID immediately and do the async copy job in background. Please use
/// [`copy_batch_check()`](copy_batch_check) to check the job status.
#[deprecated(note = "replaced by copy_batch_v2")]
pub fn copy_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationBatchArg,
) -> crate::Result<Result<RelocationBatchLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_batch",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`copy_batch_v2()`](copy_batch_v2). It returns
/// list of results for each entry.
pub fn copy_batch_check_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<RelocationBatchV2JobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_batch/check_v2",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`copy_batch()`](copy_batch). If success, it
/// returns list of results for each entry.
#[deprecated(note = "replaced by copy_batch_check_v2")]
pub fn copy_batch_check(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<RelocationBatchJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_batch/check",
        arg,
        None)
}

/// Get a copy reference to a file or folder. This reference string can be used to save that file or
/// folder to another user's Dropbox by passing it to
/// [`copy_reference_save()`](copy_reference_save).
pub fn copy_reference_get(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetCopyReferenceArg,
) -> crate::Result<Result<GetCopyReferenceResult, GetCopyReferenceError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_reference/get",
        arg,
        None)
}

/// Save a copy reference returned by [`copy_reference_get()`](copy_reference_get) to the user's
/// Dropbox.
pub fn copy_reference_save(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SaveCopyReferenceArg,
) -> crate::Result<Result<SaveCopyReferenceResult, SaveCopyReferenceError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/copy_reference/save",
        arg,
        None)
}

/// Create a folder at a given path.
pub fn create_folder_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateFolderArg,
) -> crate::Result<Result<CreateFolderResult, CreateFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/create_folder_v2",
        arg,
        None)
}

/// Create a folder at a given path.
#[deprecated(note = "replaced by create_folder_v2")]
pub fn create_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateFolderArg,
) -> crate::Result<Result<FolderMetadata, CreateFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/create_folder",
        arg,
        None)
}

/// Create multiple folders at once. This route is asynchronous for large batches, which returns a
/// job ID immediately and runs the create folder batch asynchronously. Otherwise, creates the
/// folders and returns the result synchronously for smaller inputs. You can force asynchronous
/// behaviour by using the [`CreateFolderBatchArg::force_async`](CreateFolderBatchArg) flag.  Use
/// [`create_folder_batch_check()`](create_folder_batch_check) to check the job status.
pub fn create_folder_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateFolderBatchArg,
) -> crate::Result<Result<CreateFolderBatchLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/create_folder_batch",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`create_folder_batch()`](create_folder_batch). If
/// success, it returns list of result for each entry.
pub fn create_folder_batch_check(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<CreateFolderBatchJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/create_folder_batch/check",
        arg,
        None)
}

/// Delete the file or folder at a given path. If the path is a folder, all its contents will be
/// deleted too. A successful response indicates that the file or folder was deleted. The returned
/// metadata will be the corresponding [`FileMetadata`](FileMetadata) or
/// [`FolderMetadata`](FolderMetadata) for the item at time of deletion, and not a
/// [`DeletedMetadata`](DeletedMetadata) object.
pub fn delete_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DeleteArg,
) -> crate::Result<Result<DeleteResult, DeleteError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/delete_v2",
        arg,
        None)
}

/// Delete the file or folder at a given path. If the path is a folder, all its contents will be
/// deleted too. A successful response indicates that the file or folder was deleted. The returned
/// metadata will be the corresponding [`FileMetadata`](FileMetadata) or
/// [`FolderMetadata`](FolderMetadata) for the item at time of deletion, and not a
/// [`DeletedMetadata`](DeletedMetadata) object.
#[deprecated(note = "replaced by delete_v2")]
pub fn delete(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DeleteArg,
) -> crate::Result<Result<Metadata, DeleteError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/delete",
        arg,
        None)
}

/// Delete multiple files/folders at once. This route is asynchronous, which returns a job ID
/// immediately and runs the delete batch asynchronously. Use
/// [`delete_batch_check()`](delete_batch_check) to check the job status.
pub fn delete_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DeleteBatchArg,
) -> crate::Result<Result<DeleteBatchLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/delete_batch",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`delete_batch()`](delete_batch). If success, it
/// returns list of result for each entry.
pub fn delete_batch_check(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<DeleteBatchJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/delete_batch/check",
        arg,
        None)
}

/// Download a file from a user's Dropbox.
pub fn download(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DownloadArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<FileMetadata>, DownloadError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/download",
        arg,
        None,
        range_start,
        range_end)
}

/// Download a folder from the user's Dropbox, as a zip file. The folder must be less than 20 GB in
/// size and any single file within must be less than 4 GB in size. The resulting zip must have
/// fewer than 10,000 total file and folder entries, including the top level folder. The input
/// cannot be a single file.
pub fn download_zip(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DownloadZipArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<DownloadZipResult>, DownloadZipError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/download_zip",
        arg,
        None,
        range_start,
        range_end)
}

/// Export a file from a user's Dropbox. This route only supports exporting files that cannot be
/// downloaded directly  and whose [`ExportResult::file_metadata`](ExportResult) has
/// [`ExportInfo::export_as`](ExportInfo) populated.
pub fn export(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ExportArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<ExportResult>, ExportError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/export",
        arg,
        None,
        range_start,
        range_end)
}

/// Return the lock metadata for the given list of paths.
pub fn get_file_lock_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &LockFileBatchArg,
) -> crate::Result<Result<LockFileBatchResult, LockFileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/get_file_lock_batch",
        arg,
        None)
}

/// Returns the metadata for a file or folder. Note: Metadata for the root folder is unsupported.
pub fn get_metadata(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetMetadataArg,
) -> crate::Result<Result<Metadata, GetMetadataError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/get_metadata",
        arg,
        None)
}

/// Get a preview for a file. Currently, PDF previews are generated for files with the following
/// extensions: .ai, .doc, .docm, .docx, .eps, .gdoc, .gslides, .odp, .odt, .pps, .ppsm, .ppsx,
/// .ppt, .pptm, .pptx, .rtf. HTML previews are generated for files with the following extensions:
/// .csv, .ods, .xls, .xlsm, .gsheet, .xlsx. Other formats will return an unsupported extension
/// error.
pub fn get_preview(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PreviewArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<FileMetadata>, PreviewError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/get_preview",
        arg,
        None,
        range_start,
        range_end)
}

/// Get a temporary link to stream content of a file. This link will expire in four hours and
/// afterwards you will get 410 Gone. This URL should not be used to display content directly in the
/// browser. The Content-Type of the link is determined automatically by the file's mime type.
pub fn get_temporary_link(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetTemporaryLinkArg,
) -> crate::Result<Result<GetTemporaryLinkResult, GetTemporaryLinkError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/get_temporary_link",
        arg,
        None)
}

/// Get a one-time use temporary upload link to upload a file to a Dropbox location.
///
/// This endpoint acts as a delayed [`upload()`](upload). The returned temporary upload link may be
/// used to make a POST request with the data to be uploaded. The upload will then be perfomed with
/// the [`CommitInfo`](CommitInfo) previously provided to
/// [`get_temporary_upload_link()`](get_temporary_upload_link) but evaluated only upon consumption.
/// Hence, errors stemming from invalid [`CommitInfo`](CommitInfo) with respect to the state of the
/// user's Dropbox will only be communicated at consumption time. Additionally, these errors are
/// surfaced as generic HTTP 409 Conflict responses, potentially hiding issue details. The maximum
/// temporary upload link duration is 4 hours. Upon consumption or expiration, a new link will have
/// to be generated. Multiple links may exist for a specific upload path at any given time.
///
/// The POST request on the temporary upload link must have its Content-Type set to
/// "application/octet-stream".
///
/// Example temporary upload link consumption request:
///
/// curl -X POST https://content.dropboxapi.com/apitul/1/bNi2uIYF51cVBND --header "Content-Type:
/// application/octet-stream" --data-binary @local_file.txt
///
/// A successful temporary upload link consumption request returns the content hash of the uploaded
/// data in JSON format.
///
/// Example successful temporary upload link consumption response: {"content-hash":
/// "599d71033d700ac892a0e48fa61b125d2f5994"}
///
/// An unsuccessful temporary upload link consumption request returns any of the following status
/// codes:
///
/// HTTP 400 Bad Request: Content-Type is not one of application/octet-stream and text/plain or
/// request is invalid. HTTP 409 Conflict: The temporary upload link does not exist or is currently
/// unavailable, the upload failed, or another error happened. HTTP 410 Gone: The temporary upload
/// link is expired or consumed.
///
/// Example unsuccessful temporary upload link consumption response: Temporary upload link has been
/// recently consumed.
pub fn get_temporary_upload_link(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetTemporaryUploadLinkArg,
) -> crate::Result<Result<GetTemporaryUploadLinkResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/get_temporary_upload_link",
        arg,
        None)
}

/// Get a thumbnail for an image. This method currently supports files with the following file
/// extensions: jpg, jpeg, png, tiff, tif, gif, webp, ppm and bmp. Photos that are larger than 20MB
/// in size won't be converted to a thumbnail.
pub fn get_thumbnail(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ThumbnailArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<FileMetadata>, ThumbnailError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/get_thumbnail",
        arg,
        None,
        range_start,
        range_end)
}

/// Get a thumbnail for an image. This method currently supports files with the following file
/// extensions: jpg, jpeg, png, tiff, tif, gif, webp, ppm and bmp. Photos that are larger than 20MB
/// in size won't be converted to a thumbnail.
pub fn get_thumbnail_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ThumbnailV2Arg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<PreviewResult>, ThumbnailV2Error>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/get_thumbnail_v2",
        arg,
        None,
        range_start,
        range_end)
}

/// Get a thumbnail for an image. This method currently supports files with the following file
/// extensions: jpg, jpeg, png, tiff, tif, gif, webp, ppm and bmp. Photos that are larger than 20MB
/// in size won't be converted to a thumbnail.
pub fn get_thumbnail_v2_app_auth(
    client: &impl crate::client_trait::AppAuthClient,
    arg: &ThumbnailV2Arg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<PreviewResult>, ThumbnailV2Error>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "files/get_thumbnail_v2",
        arg,
        None,
        range_start,
        range_end)
}

/// Get thumbnails for a list of images. We allow up to 25 thumbnails in a single batch. This method
/// currently supports files with the following file extensions: jpg, jpeg, png, tiff, tif, gif,
/// webp, ppm and bmp. Photos that are larger than 20MB in size won't be converted to a thumbnail.
pub fn get_thumbnail_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetThumbnailBatchArg,
) -> crate::Result<Result<GetThumbnailBatchResult, GetThumbnailBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Rpc,
        "files/get_thumbnail_batch",
        arg,
        None)
}

/// Starts returning the contents of a folder. If the result's
/// [`ListFolderResult::has_more`](ListFolderResult) field is `true`, call
/// [`list_folder_continue()`](list_folder_continue) with the returned
/// [`ListFolderResult::cursor`](ListFolderResult) to retrieve more entries. If you're using
/// [`ListFolderArg::recursive`](ListFolderArg) set to `true` to keep a local cache of the contents
/// of a Dropbox account, iterate through each entry in order and process them as follows to keep
/// your local state in sync: For each [`FileMetadata`](FileMetadata), store the new entry at the
/// given path in your local state. If the required parent folders don't exist yet, create them. If
/// there's already something else at the given path, replace it and remove all its children. For
/// each [`FolderMetadata`](FolderMetadata), store the new entry at the given path in your local
/// state. If the required parent folders don't exist yet, create them. If there's already something
/// else at the given path, replace it but leave the children as they are. Check the new entry's
/// [`FolderSharingInfo::read_only`](FolderSharingInfo) and set all its children's read-only
/// statuses to match. For each [`DeletedMetadata`](DeletedMetadata), if your local state has
/// something at the given path, remove it and all its children. If there's nothing at the given
/// path, ignore this entry. Note: [`auth::RateLimitError`](super::auth::RateLimitError) may be
/// returned if multiple [`list_folder()`](list_folder) or
/// [`list_folder_continue()`](list_folder_continue) calls with same parameters are made
/// simultaneously by same API app for same user. If your app implements retry logic, please hold
/// off the retry until the previous request finishes.
pub fn list_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFolderArg,
) -> crate::Result<Result<ListFolderResult, ListFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/list_folder",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`list_folder()`](list_folder), use this to paginate
/// through all files and retrieve updates to the folder, following the same rules as documented for
/// [`list_folder()`](list_folder).
pub fn list_folder_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFolderContinueArg,
) -> crate::Result<Result<ListFolderResult, ListFolderContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/list_folder/continue",
        arg,
        None)
}

/// A way to quickly get a cursor for the folder's state. Unlike [`list_folder()`](list_folder),
/// [`list_folder_get_latest_cursor()`](list_folder_get_latest_cursor) doesn't return any entries.
/// This endpoint is for app which only needs to know about new files and modifications and doesn't
/// need to know about files that already exist in Dropbox.
pub fn list_folder_get_latest_cursor(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFolderArg,
) -> crate::Result<Result<ListFolderGetLatestCursorResult, ListFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/list_folder/get_latest_cursor",
        arg,
        None)
}

/// A longpoll endpoint to wait for changes on an account. In conjunction with
/// [`list_folder_continue()`](list_folder_continue), this call gives you a low-latency way to
/// monitor an account for file changes. The connection will block until there are changes available
/// or a timeout occurs. This endpoint is useful mostly for client-side apps. If you're looking for
/// server-side notifications, check out our [webhooks
/// documentation](https://www.dropbox.com/developers/reference/webhooks).
pub fn list_folder_longpoll(
    client: &impl crate::client_trait::NoauthClient,
    arg: &ListFolderLongpollArg,
) -> crate::Result<Result<ListFolderLongpollResult, ListFolderLongpollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Notify,
        crate::client_trait::Style::Rpc,
        "files/list_folder/longpoll",
        arg,
        None)
}

/// Returns revisions for files based on a file path or a file id. The file path or file id is
/// identified from the latest file entry at the given file path or id. This end point allows your
/// app to query either by file path or file id by setting the mode parameter appropriately. In the
/// [`ListRevisionsMode::Path`](ListRevisionsMode::Path) (default) mode, all revisions at the same
/// file path as the latest file entry are returned. If revisions with the same file id are desired,
/// then mode must be set to [`ListRevisionsMode::Id`](ListRevisionsMode::Id). The
/// [`ListRevisionsMode::Id`](ListRevisionsMode::Id) mode is useful to retrieve revisions for a
/// given file across moves or renames.
pub fn list_revisions(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListRevisionsArg,
) -> crate::Result<Result<ListRevisionsResult, ListRevisionsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/list_revisions",
        arg,
        None)
}

/// Lock the files at the given paths. A locked file will be writable only by the lock holder. A
/// successful response indicates that the file has been locked. Returns a list of the locked file
/// paths and their metadata after this operation.
pub fn lock_file_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &LockFileBatchArg,
) -> crate::Result<Result<LockFileBatchResult, LockFileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/lock_file_batch",
        arg,
        None)
}

/// Move a file or folder to a different location in the user's Dropbox. If the source path is a
/// folder all its contents will be moved. Note that we do not currently support case-only renaming.
pub fn move_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationArg,
) -> crate::Result<Result<RelocationResult, RelocationError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move_v2",
        arg,
        None)
}

/// Move a file or folder to a different location in the user's Dropbox. If the source path is a
/// folder all its contents will be moved.
#[deprecated(note = "replaced by move_v2")]
pub fn do_move(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationArg,
) -> crate::Result<Result<Metadata, RelocationError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move",
        arg,
        None)
}

/// Move multiple files or folders to different locations at once in the user's Dropbox. Note that
/// we do not currently support case-only renaming. This route will replace
/// [`move_batch()`](move_batch). The main difference is this route will return status for each
/// entry, while [`move_batch()`](move_batch) raises failure if any entry fails. This route will
/// either finish synchronously, or return a job ID and do the async move job in background. Please
/// use [`move_batch_check_v2()`](move_batch_check_v2) to check the job status.
pub fn move_batch_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &MoveBatchArg,
) -> crate::Result<Result<RelocationBatchV2Launch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move_batch_v2",
        arg,
        None)
}

/// Move multiple files or folders to different locations at once in the user's Dropbox. This route
/// will return job ID immediately and do the async moving job in background. Please use
/// [`move_batch_check()`](move_batch_check) to check the job status.
#[deprecated(note = "replaced by move_batch_v2")]
pub fn move_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelocationBatchArg,
) -> crate::Result<Result<RelocationBatchLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move_batch",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`move_batch_v2()`](move_batch_v2). It returns
/// list of results for each entry.
pub fn move_batch_check_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<RelocationBatchV2JobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move_batch/check_v2",
        arg,
        None)
}

/// Returns the status of an asynchronous job for [`move_batch()`](move_batch). If success, it
/// returns list of results for each entry.
#[deprecated(note = "replaced by move_batch_check_v2")]
pub fn move_batch_check(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<RelocationBatchJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/move_batch/check",
        arg,
        None)
}

/// Creates a new Paper doc with the provided content.
pub fn paper_create(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperCreateArg,
    body: &[u8],
) -> crate::Result<Result<PaperCreateResult, PaperCreateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Upload,
        "files/paper/create",
        arg,
        Some(body))
}

/// Updates an existing Paper doc with the provided content.
pub fn paper_update(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &PaperUpdateArg,
    body: &[u8],
) -> crate::Result<Result<PaperUpdateResult, PaperUpdateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Upload,
        "files/paper/update",
        arg,
        Some(body))
}

/// Permanently delete the file or folder at a given path (see https://www.dropbox.com/en/help/40).
/// If the given file or folder is not yet deleted, this route will first delete it. It is possible
/// for this route to successfully delete, then fail to permanently delete. Note: This endpoint is
/// only available for Dropbox Business apps.
pub fn permanently_delete(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DeleteArg,
) -> crate::Result<Result<(), DeleteError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/permanently_delete",
        arg,
        None)
}

#[deprecated]
pub fn properties_add(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::file_properties::AddPropertiesArg,
) -> crate::Result<Result<(), super::file_properties::AddPropertiesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/add",
        arg,
        None)
}

#[deprecated]
pub fn properties_overwrite(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::file_properties::OverwritePropertyGroupArg,
) -> crate::Result<Result<(), super::file_properties::InvalidPropertyGroupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/overwrite",
        arg,
        None)
}

#[deprecated]
pub fn properties_remove(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::file_properties::RemovePropertiesArg,
) -> crate::Result<Result<(), super::file_properties::RemovePropertiesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/remove",
        arg,
        None)
}

#[deprecated]
pub fn properties_template_get(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::file_properties::GetTemplateArg,
) -> crate::Result<Result<super::file_properties::GetTemplateResult, super::file_properties::TemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/template/get",
        arg,
        None)
}

#[deprecated]
pub fn properties_template_list(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<super::file_properties::ListTemplateResult, super::file_properties::TemplateError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/template/list",
        &(),
        None)
}

#[deprecated]
pub fn properties_update(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::file_properties::UpdatePropertiesArg,
) -> crate::Result<Result<(), super::file_properties::UpdatePropertiesError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/properties/update",
        arg,
        None)
}

/// Restore a specific revision of a file to the given path.
pub fn restore(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RestoreArg,
) -> crate::Result<Result<FileMetadata, RestoreError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/restore",
        arg,
        None)
}

/// Save the data from a specified URL into a file in user's Dropbox. Note that the transfer from
/// the URL must complete within 5 minutes, or the operation will time out and the job will fail. If
/// the given path already exists, the file will be renamed to avoid the conflict (e.g. myfile
/// (1).txt).
pub fn save_url(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SaveUrlArg,
) -> crate::Result<Result<SaveUrlResult, SaveUrlError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/save_url",
        arg,
        None)
}

/// Check the status of a [`save_url()`](save_url) job.
pub fn save_url_check_job_status(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<SaveUrlJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/save_url/check_job_status",
        arg,
        None)
}

/// Searches for files and folders. Note: Recent changes will be reflected in search results within
/// a few seconds and older revisions of existing files may still match your query for up to a few
/// days.
#[deprecated(note = "replaced by search_v2")]
pub fn search(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SearchArg,
) -> crate::Result<Result<SearchResult, SearchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/search",
        arg,
        None)
}

/// Searches for files and folders. Note: [`search_v2()`](search_v2) along with
/// [`search_continue_v2()`](search_continue_v2) can only be used to retrieve a maximum of 10,000
/// matches. Recent changes may not immediately be reflected in search results due to a short delay
/// in indexing. Duplicate results may be returned across pages. Some results may not be returned.
pub fn search_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SearchV2Arg,
) -> crate::Result<Result<SearchV2Result, SearchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/search_v2",
        arg,
        None)
}

/// Fetches the next page of search results returned from [`search_v2()`](search_v2). Note:
/// [`search_v2()`](search_v2) along with [`search_continue_v2()`](search_continue_v2) can only be
/// used to retrieve a maximum of 10,000 matches. Recent changes may not immediately be reflected in
/// search results due to a short delay in indexing. Duplicate results may be returned across pages.
/// Some results may not be returned.
pub fn search_continue_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SearchV2ContinueArg,
) -> crate::Result<Result<SearchV2Result, SearchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/search/continue_v2",
        arg,
        None)
}

/// Unlock the files at the given paths. A locked file can only be unlocked by the lock holder or,
/// if a business account, a team admin. A successful response indicates that the file has been
/// unlocked. Returns a list of the unlocked file paths and their metadata after this operation.
pub fn unlock_file_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UnlockFileBatchArg,
) -> crate::Result<Result<LockFileBatchResult, LockFileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/unlock_file_batch",
        arg,
        None)
}

/// Create a new file with the contents provided in the request. Do not use this to upload a file
/// larger than 150 MB. Instead, create an upload session with
/// [`upload_session_start()`](upload_session_start). Calls to this endpoint will count as data
/// transport calls for any Dropbox Business teams with a limit on the number of data transport
/// calls allowed per month. For more information, see the [Data transport limit
/// page](https://www.dropbox.com/developers/reference/data-transport-limit).
pub fn upload(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CommitInfo,
    body: &[u8],
) -> crate::Result<Result<FileMetadata, UploadError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/upload",
        arg,
        Some(body))
}

/// Append more data to an upload session. When the parameter close is set, this call will close the
/// session. A single request should not upload more than 150 MB. The maximum size of a file one can
/// upload to an upload session is 350 GB. Calls to this endpoint will count as data transport calls
/// for any Dropbox Business teams with a limit on the number of data transport calls allowed per
/// month. For more information, see the [Data transport limit
/// page](https://www.dropbox.com/developers/reference/data-transport-limit).
pub fn upload_session_append_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionAppendArg,
    body: &[u8],
) -> crate::Result<Result<(), UploadSessionLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/upload_session/append_v2",
        arg,
        Some(body))
}

/// Append more data to an upload session. A single request should not upload more than 150 MB. The
/// maximum size of a file one can upload to an upload session is 350 GB. Calls to this endpoint
/// will count as data transport calls for any Dropbox Business teams with a limit on the number of
/// data transport calls allowed per month. For more information, see the [Data transport limit
/// page](https://www.dropbox.com/developers/reference/data-transport-limit).
#[deprecated(note = "replaced by upload_session_append_v2")]
pub fn upload_session_append(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionCursor,
    body: &[u8],
) -> crate::Result<Result<(), UploadSessionLookupError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/upload_session/append",
        arg,
        Some(body))
}

/// Finish an upload session and save the uploaded data to the given file path. A single request
/// should not upload more than 150 MB. The maximum size of a file one can upload to an upload
/// session is 350 GB. Calls to this endpoint will count as data transport calls for any Dropbox
/// Business teams with a limit on the number of data transport calls allowed per month. For more
/// information, see the [Data transport limit
/// page](https://www.dropbox.com/developers/reference/data-transport-limit).
pub fn upload_session_finish(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionFinishArg,
    body: &[u8],
) -> crate::Result<Result<FileMetadata, UploadSessionFinishError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/upload_session/finish",
        arg,
        Some(body))
}

/// This route helps you commit many files at once into a user's Dropbox. Use
/// [`upload_session_start()`](upload_session_start) and
/// [`upload_session_append_v2()`](upload_session_append_v2) to upload file contents. We recommend
/// uploading many files in parallel to increase throughput. Once the file contents have been
/// uploaded, rather than calling [`upload_session_finish()`](upload_session_finish), use this route
/// to finish all your upload sessions in a single request.
/// [`UploadSessionStartArg::close`](UploadSessionStartArg) or
/// [`UploadSessionAppendArg::close`](UploadSessionAppendArg) needs to be true for the last
/// [`upload_session_start()`](upload_session_start) or
/// [`upload_session_append_v2()`](upload_session_append_v2) call. The maximum size of a file one
/// can upload to an upload session is 350 GB. This route will return a job_id immediately and do
/// the async commit job in background. Use
/// [`upload_session_finish_batch_check()`](upload_session_finish_batch_check) to check the job
/// status. For the same account, this route should be executed serially. That means you should not
/// start the next job before current job finishes. We allow up to 1000 entries in a single request.
/// Calls to this endpoint will count as data transport calls for any Dropbox Business teams with a
/// limit on the number of data transport calls allowed per month. For more information, see the
/// [Data transport limit page](https://www.dropbox.com/developers/reference/data-transport-limit).
pub fn upload_session_finish_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionFinishBatchArg,
) -> crate::Result<Result<UploadSessionFinishBatchLaunch, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/upload_session/finish_batch",
        arg,
        None)
}

/// This route helps you commit many files at once into a user's Dropbox. Use
/// [`upload_session_start()`](upload_session_start) and
/// [`upload_session_append_v2()`](upload_session_append_v2) to upload file contents. We recommend
/// uploading many files in parallel to increase throughput. Once the file contents have been
/// uploaded, rather than calling [`upload_session_finish()`](upload_session_finish), use this route
/// to finish all your upload sessions in a single request.
/// [`UploadSessionStartArg::close`](UploadSessionStartArg) or
/// [`UploadSessionAppendArg::close`](UploadSessionAppendArg) needs to be true for the last
/// [`upload_session_start()`](upload_session_start) or
/// [`upload_session_append_v2()`](upload_session_append_v2) call of each upload session. The
/// maximum size of a file one can upload to an upload session is 350 GB. We allow up to 1000
/// entries in a single request. Calls to this endpoint will count as data transport calls for any
/// Dropbox Business teams with a limit on the number of data transport calls allowed per month. For
/// more information, see the [Data transport limit
/// page](https://www.dropbox.com/developers/reference/data-transport-limit).
pub fn upload_session_finish_batch_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionFinishBatchArg,
) -> crate::Result<Result<UploadSessionFinishBatchResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/upload_session/finish_batch_v2",
        arg,
        None)
}

/// Returns the status of an asynchronous job for
/// [`upload_session_finish_batch()`](upload_session_finish_batch). If success, it returns list of
/// result for each entry.
pub fn upload_session_finish_batch_check(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<UploadSessionFinishBatchJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "files/upload_session/finish_batch/check",
        arg,
        None)
}

/// Upload sessions allow you to upload a single file in one or more requests, for example where the
/// size of the file is greater than 150 MB.  This call starts a new upload session with the given
/// data. You can then use [`upload_session_append_v2()`](upload_session_append_v2) to add more data
/// and [`upload_session_finish()`](upload_session_finish) to save all the data to a file in
/// Dropbox. A single request should not upload more than 150 MB. The maximum size of a file one can
/// upload to an upload session is 350 GB. An upload session can be used for a maximum of 7 days.
/// Attempting to use an [`UploadSessionStartResult::session_id`](UploadSessionStartResult) with
/// [`upload_session_append_v2()`](upload_session_append_v2) or
/// [`upload_session_finish()`](upload_session_finish) more than 7 days after its creation will
/// return a [`UploadSessionLookupError::NotFound`](UploadSessionLookupError::NotFound). Calls to
/// this endpoint will count as data transport calls for any Dropbox Business teams with a limit on
/// the number of data transport calls allowed per month. For more information, see the [Data
/// transport limit page](https://www.dropbox.com/developers/reference/data-transport-limit). By
/// default, upload sessions require you to send content of the file in sequential order via
/// consecutive [`upload_session_start()`](upload_session_start),
/// [`upload_session_append_v2()`](upload_session_append_v2),
/// [`upload_session_finish()`](upload_session_finish) calls. For better performance, you can
/// instead optionally use a [`UploadSessionType::Concurrent`](UploadSessionType::Concurrent) upload
/// session. To start a new concurrent session, set
/// [`UploadSessionStartArg::session_type`](UploadSessionStartArg) to
/// [`UploadSessionType::Concurrent`](UploadSessionType::Concurrent). After that, you can send file
/// data in concurrent [`upload_session_append_v2()`](upload_session_append_v2) requests. Finally
/// finish the session with [`upload_session_finish()`](upload_session_finish). There are couple of
/// constraints with concurrent sessions to make them work. You can not send data with
/// [`upload_session_start()`](upload_session_start) or
/// [`upload_session_finish()`](upload_session_finish) call, only with
/// [`upload_session_append_v2()`](upload_session_append_v2) call. Also data uploaded in
/// [`upload_session_append_v2()`](upload_session_append_v2) call must be multiple of 4194304 bytes
/// (except for last [`upload_session_append_v2()`](upload_session_append_v2) with
/// [`UploadSessionStartArg::close`](UploadSessionStartArg) to `true`, that may contain any
/// remaining data).
pub fn upload_session_start(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UploadSessionStartArg,
    body: &[u8],
) -> crate::Result<Result<UploadSessionStartResult, UploadSessionStartError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Upload,
        "files/upload_session/start",
        arg,
        Some(body))
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AlphaGetMetadataArg {
    /// The path of a file or folder on Dropbox.
    pub path: ReadPath,
    /// If true, [`FileMetadata::media_info`](FileMetadata) is set for photo and video.
    pub include_media_info: bool,
    /// If true, [`DeletedMetadata`](DeletedMetadata) will be returned for deleted file or folder,
    /// otherwise [`LookupError::NotFound`](LookupError::NotFound) will be returned.
    pub include_deleted: bool,
    /// If true, the results will include a flag for each file indicating whether or not  that file
    /// has any explicit members.
    pub include_has_explicit_shared_members: bool,
    /// If set to a valid list of template IDs, [`FileMetadata::property_groups`](FileMetadata) is
    /// set if there exists property data associated with the file and each of the listed templates.
    pub include_property_groups: Option<super::file_properties::TemplateFilterBase>,
    /// If set to a valid list of template IDs, [`FileMetadata::property_groups`](FileMetadata) is
    /// set for files with custom properties.
    pub include_property_templates: Option<Vec<super::file_properties::TemplateId>>,
}

impl AlphaGetMetadataArg {
    pub fn new(path: ReadPath) -> Self {
        AlphaGetMetadataArg {
            path,
            include_media_info: false,
            include_deleted: false,
            include_has_explicit_shared_members: false,
            include_property_groups: None,
            include_property_templates: None,
        }
    }

    pub fn with_include_media_info(mut self, value: bool) -> Self {
        self.include_media_info = value;
        self
    }

    pub fn with_include_deleted(mut self, value: bool) -> Self {
        self.include_deleted = value;
        self
    }

    pub fn with_include_has_explicit_shared_members(mut self, value: bool) -> Self {
        self.include_has_explicit_shared_members = value;
        self
    }

    pub fn with_include_property_groups(
        mut self,
        value: super::file_properties::TemplateFilterBase,
    ) -> Self {
        self.include_property_groups = Some(value);
        self
    }

    pub fn with_include_property_templates(
        mut self,
        value: Vec<super::file_properties::TemplateId>,
    ) -> Self {
        self.include_property_templates = Some(value);
        self
    }
}

const ALPHA_GET_METADATA_ARG_FIELDS: &[&str] = &["path",
                                                 "include_media_info",
                                                 "include_deleted",
                                                 "include_has_explicit_shared_members",
                                                 "include_property_groups",
                                                 "include_property_templates"];
impl AlphaGetMetadataArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AlphaGetMetadataArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AlphaGetMetadataArg>, V::Error> {
        let mut field_path = None;
        let mut field_include_media_info = None;
        let mut field_include_deleted = None;
        let mut field_include_has_explicit_shared_members = None;
        let mut field_include_property_groups = None;
        let mut field_include_property_templates = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "include_media_info" => {
                    if field_include_media_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_media_info"));
                    }
                    field_include_media_info = Some(map.next_value()?);
                }
                "include_deleted" => {
                    if field_include_deleted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_deleted"));
                    }
                    field_include_deleted = Some(map.next_value()?);
                }
                "include_has_explicit_shared_members" => {
                    if field_include_has_explicit_shared_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_has_explicit_shared_members"));
                    }
                    field_include_has_explicit_shared_members = Some(map.next_value()?);
                }
                "include_property_groups" => {
                    if field_include_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_property_groups"));
                    }
                    field_include_property_groups = Some(map.next_value()?);
                }
                "include_property_templates" => {
                    if field_include_property_templates.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_property_templates"));
                    }
                    field_include_property_templates = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AlphaGetMetadataArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            include_media_info: field_include_media_info.unwrap_or(false),
            include_deleted: field_include_deleted.unwrap_or(false),
            include_has_explicit_shared_members: field_include_has_explicit_shared_members.unwrap_or(false),
            include_property_groups: field_include_property_groups,
            include_property_templates: field_include_property_templates,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("include_media_info", &self.include_media_info)?;
        s.serialize_field("include_deleted", &self.include_deleted)?;
        s.serialize_field("include_has_explicit_shared_members", &self.include_has_explicit_shared_members)?;
        if let Some(val) = &self.include_property_groups {
            s.serialize_field("include_property_groups", val)?;
        }
        if let Some(val) = &self.include_property_templates {
            s.serialize_field("include_property_templates", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AlphaGetMetadataArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AlphaGetMetadataArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AlphaGetMetadataArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AlphaGetMetadataArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AlphaGetMetadataArg", ALPHA_GET_METADATA_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AlphaGetMetadataArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AlphaGetMetadataArg", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum AlphaGetMetadataError {
    Path(LookupError),
    PropertiesError(super::file_properties::LookUpPropertiesError),
}

impl<'de> ::serde::de::Deserialize<'de> for AlphaGetMetadataError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AlphaGetMetadataError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AlphaGetMetadataError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => AlphaGetMetadataError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "properties_error" => {
                        match map.next_key()? {
                            Some("properties_error") => AlphaGetMetadataError::PropertiesError(map.next_value()?),
                            None => return Err(de::Error::missing_field("properties_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "properties_error"];
        deserializer.deserialize_struct("AlphaGetMetadataError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AlphaGetMetadataError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AlphaGetMetadataError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AlphaGetMetadataError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            AlphaGetMetadataError::PropertiesError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AlphaGetMetadataError", 2)?;
                s.serialize_field(".tag", "properties_error")?;
                s.serialize_field("properties_error", x)?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for AlphaGetMetadataError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            AlphaGetMetadataError::Path(inner) => Some(inner),
            AlphaGetMetadataError::PropertiesError(inner) => Some(inner),
        }
    }
}

impl ::std::fmt::Display for AlphaGetMetadataError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            AlphaGetMetadataError::Path(inner) => write!(f, "{}", inner),
            AlphaGetMetadataError::PropertiesError(inner) => write!(f, "{}", inner),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CommitInfo {
    /// Path in the user's Dropbox to save the file.
    pub path: WritePathOrId,
    /// Selects what to do if the file already exists.
    pub mode: WriteMode,
    /// If there's a conflict, as determined by `mode`, have the Dropbox server try to autorename
    /// the file to avoid conflict.
    pub autorename: bool,
    /// The value to store as the `client_modified` timestamp. Dropbox automatically records the
    /// time at which the file was written to the Dropbox servers. It can also record an additional
    /// timestamp, provided by Dropbox desktop clients, mobile clients, and API apps of when the
    /// file was actually created or modified.
    pub client_modified: Option<super::common::DropboxTimestamp>,
    /// Normally, users are made aware of any file modifications in their Dropbox account via
    /// notifications in the client software. If `true`, this tells the clients that this
    /// modification shouldn't result in a user notification.
    pub mute: bool,
    /// List of custom properties to add to file.
    pub property_groups: Option<Vec<super::file_properties::PropertyGroup>>,
    /// Be more strict about how each [`WriteMode`](WriteMode) detects conflict. For example, always
    /// return a conflict error when `mode` = [`WriteMode::Update`](WriteMode::Update) and the given
    /// "rev" doesn't match the existing file's "rev", even if the existing file has been deleted.
    /// This also forces a conflict even when the target path refers to a file with identical
    /// contents.
    pub strict_conflict: bool,
}

impl CommitInfo {
    pub fn new(path: WritePathOrId) -> Self {
        CommitInfo {
            path,
            mode: WriteMode::Add,
            autorename: false,
            client_modified: None,
            mute: false,
            property_groups: None,
            strict_conflict: false,
        }
    }

    pub fn with_mode(mut self, value: WriteMode) -> Self {
        self.mode = value;
        self
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_client_modified(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.client_modified = Some(value);
        self
    }

    pub fn with_mute(mut self, value: bool) -> Self {
        self.mute = value;
        self
    }

    pub fn with_property_groups(
        mut self,
        value: Vec<super::file_properties::PropertyGroup>,
    ) -> Self {
        self.property_groups = Some(value);
        self
    }

    pub fn with_strict_conflict(mut self, value: bool) -> Self {
        self.strict_conflict = value;
        self
    }
}

const COMMIT_INFO_FIELDS: &[&str] = &["path",
                                      "mode",
                                      "autorename",
                                      "client_modified",
                                      "mute",
                                      "property_groups",
                                      "strict_conflict"];
impl CommitInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CommitInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CommitInfo>, V::Error> {
        let mut field_path = None;
        let mut field_mode = None;
        let mut field_autorename = None;
        let mut field_client_modified = None;
        let mut field_mute = None;
        let mut field_property_groups = None;
        let mut field_strict_conflict = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "client_modified" => {
                    if field_client_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_modified"));
                    }
                    field_client_modified = Some(map.next_value()?);
                }
                "mute" => {
                    if field_mute.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mute"));
                    }
                    field_mute = Some(map.next_value()?);
                }
                "property_groups" => {
                    if field_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("property_groups"));
                    }
                    field_property_groups = Some(map.next_value()?);
                }
                "strict_conflict" => {
                    if field_strict_conflict.is_some() {
                        return Err(::serde::de::Error::duplicate_field("strict_conflict"));
                    }
                    field_strict_conflict = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CommitInfo {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            mode: field_mode.unwrap_or(WriteMode::Add),
            autorename: field_autorename.unwrap_or(false),
            client_modified: field_client_modified,
            mute: field_mute.unwrap_or(false),
            property_groups: field_property_groups,
            strict_conflict: field_strict_conflict.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("mode", &self.mode)?;
        s.serialize_field("autorename", &self.autorename)?;
        if let Some(val) = &self.client_modified {
            s.serialize_field("client_modified", val)?;
        }
        s.serialize_field("mute", &self.mute)?;
        if let Some(val) = &self.property_groups {
            s.serialize_field("property_groups", val)?;
        }
        s.serialize_field("strict_conflict", &self.strict_conflict)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CommitInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CommitInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CommitInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CommitInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CommitInfo", COMMIT_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CommitInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CommitInfo", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CommitInfoWithProperties {
    /// Path in the user's Dropbox to save the file.
    pub path: WritePathOrId,
    /// Selects what to do if the file already exists.
    pub mode: WriteMode,
    /// If there's a conflict, as determined by `mode`, have the Dropbox server try to autorename
    /// the file to avoid conflict.
    pub autorename: bool,
    /// The value to store as the `client_modified` timestamp. Dropbox automatically records the
    /// time at which the file was written to the Dropbox servers. It can also record an additional
    /// timestamp, provided by Dropbox desktop clients, mobile clients, and API apps of when the
    /// file was actually created or modified.
    pub client_modified: Option<super::common::DropboxTimestamp>,
    /// Normally, users are made aware of any file modifications in their Dropbox account via
    /// notifications in the client software. If `true`, this tells the clients that this
    /// modification shouldn't result in a user notification.
    pub mute: bool,
    /// List of custom properties to add to file.
    pub property_groups: Option<Vec<super::file_properties::PropertyGroup>>,
    /// Be more strict about how each [`WriteMode`](WriteMode) detects conflict. For example, always
    /// return a conflict error when `mode` = [`WriteMode::Update`](WriteMode::Update) and the given
    /// "rev" doesn't match the existing file's "rev", even if the existing file has been deleted.
    /// This also forces a conflict even when the target path refers to a file with identical
    /// contents.
    pub strict_conflict: bool,
}

impl CommitInfoWithProperties {
    pub fn new(path: WritePathOrId) -> Self {
        CommitInfoWithProperties {
            path,
            mode: WriteMode::Add,
            autorename: false,
            client_modified: None,
            mute: false,
            property_groups: None,
            strict_conflict: false,
        }
    }

    pub fn with_mode(mut self, value: WriteMode) -> Self {
        self.mode = value;
        self
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_client_modified(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.client_modified = Some(value);
        self
    }

    pub fn with_mute(mut self, value: bool) -> Self {
        self.mute = value;
        self
    }

    pub fn with_property_groups(
        mut self,
        value: Vec<super::file_properties::PropertyGroup>,
    ) -> Self {
        self.property_groups = Some(value);
        self
    }

    pub fn with_strict_conflict(mut self, value: bool) -> Self {
        self.strict_conflict = value;
        self
    }
}

const COMMIT_INFO_WITH_PROPERTIES_FIELDS: &[&str] = &["path",
                                                      "mode",
                                                      "autorename",
                                                      "client_modified",
                                                      "mute",
                                                      "property_groups",
                                                      "strict_conflict"];
impl CommitInfoWithProperties {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CommitInfoWithProperties, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CommitInfoWithProperties>, V::Error> {
        let mut field_path = None;
        let mut field_mode = None;
        let mut field_autorename = None;
        let mut field_client_modified = None;
        let mut field_mute = None;
        let mut field_property_groups = None;
        let mut field_strict_conflict = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "client_modified" => {
                    if field_client_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_modified"));
                    }
                    field_client_modified = Some(map.next_value()?);
                }
                "mute" => {
                    if field_mute.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mute"));
                    }
                    field_mute = Some(map.next_value()?);
                }
                "property_groups" => {
                    if field_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("property_groups"));
                    }
                    field_property_groups = Some(map.next_value()?);
                }
                "strict_conflict" => {
                    if field_strict_conflict.is_some() {
                        return Err(::serde::de::Error::duplicate_field("strict_conflict"));
                    }
                    field_strict_conflict = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CommitInfoWithProperties {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            mode: field_mode.unwrap_or(WriteMode::Add),
            autorename: field_autorename.unwrap_or(false),
            client_modified: field_client_modified,
            mute: field_mute.unwrap_or(false),
            property_groups: field_property_groups,
            strict_conflict: field_strict_conflict.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("mode", &self.mode)?;
        s.serialize_field("autorename", &self.autorename)?;
        if let Some(val) = &self.client_modified {
            s.serialize_field("client_modified", val)?;
        }
        s.serialize_field("mute", &self.mute)?;
        if let Some(val) = &self.property_groups {
            s.serialize_field("property_groups", val)?;
        }
        s.serialize_field("strict_conflict", &self.strict_conflict)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CommitInfoWithProperties {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CommitInfoWithProperties;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CommitInfoWithProperties struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CommitInfoWithProperties::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CommitInfoWithProperties", COMMIT_INFO_WITH_PROPERTIES_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CommitInfoWithProperties {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CommitInfoWithProperties", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ContentSyncSetting {
    /// Id of the item this setting is applied to.
    pub id: FileId,
    /// Setting for this item.
    pub sync_setting: SyncSetting,
}

impl ContentSyncSetting {
    pub fn new(id: FileId, sync_setting: SyncSetting) -> Self {
        ContentSyncSetting {
            id,
            sync_setting,
        }
    }
}

const CONTENT_SYNC_SETTING_FIELDS: &[&str] = &["id",
                                               "sync_setting"];
impl ContentSyncSetting {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ContentSyncSetting, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ContentSyncSetting>, V::Error> {
        let mut field_id = None;
        let mut field_sync_setting = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "sync_setting" => {
                    if field_sync_setting.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sync_setting"));
                    }
                    field_sync_setting = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ContentSyncSetting {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            sync_setting: field_sync_setting.ok_or_else(|| ::serde::de::Error::missing_field("sync_setting"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("sync_setting", &self.sync_setting)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ContentSyncSetting {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ContentSyncSetting;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContentSyncSetting struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ContentSyncSetting::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ContentSyncSetting", CONTENT_SYNC_SETTING_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ContentSyncSetting {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ContentSyncSetting", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ContentSyncSettingArg {
    /// Id of the item this setting is applied to.
    pub id: FileId,
    /// Setting for this item.
    pub sync_setting: SyncSettingArg,
}

impl ContentSyncSettingArg {
    pub fn new(id: FileId, sync_setting: SyncSettingArg) -> Self {
        ContentSyncSettingArg {
            id,
            sync_setting,
        }
    }
}

const CONTENT_SYNC_SETTING_ARG_FIELDS: &[&str] = &["id",
                                                   "sync_setting"];
impl ContentSyncSettingArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ContentSyncSettingArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ContentSyncSettingArg>, V::Error> {
        let mut field_id = None;
        let mut field_sync_setting = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "sync_setting" => {
                    if field_sync_setting.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sync_setting"));
                    }
                    field_sync_setting = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ContentSyncSettingArg {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            sync_setting: field_sync_setting.ok_or_else(|| ::serde::de::Error::missing_field("sync_setting"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("sync_setting", &self.sync_setting)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ContentSyncSettingArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ContentSyncSettingArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContentSyncSettingArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ContentSyncSettingArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ContentSyncSettingArg", CONTENT_SYNC_SETTING_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ContentSyncSettingArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ContentSyncSettingArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderArg {
    /// Path in the user's Dropbox to create.
    pub path: WritePath,
    /// If there's a conflict, have the Dropbox server try to autorename the folder to avoid the
    /// conflict.
    pub autorename: bool,
}

impl CreateFolderArg {
    pub fn new(path: WritePath) -> Self {
        CreateFolderArg {
            path,
            autorename: false,
        }
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }
}

const CREATE_FOLDER_ARG_FIELDS: &[&str] = &["path",
                                            "autorename"];
impl CreateFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderArg>, V::Error> {
        let mut field_path = None;
        let mut field_autorename = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            autorename: field_autorename.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("autorename", &self.autorename)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderArg", CREATE_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderBatchArg {
    /// List of paths to be created in the user's Dropbox. Duplicate path arguments in the batch are
    /// considered only once.
    pub paths: Vec<WritePath>,
    /// If there's a conflict, have the Dropbox server try to autorename the folder to avoid the
    /// conflict.
    pub autorename: bool,
    /// Whether to force the create to happen asynchronously.
    pub force_async: bool,
}

impl CreateFolderBatchArg {
    pub fn new(paths: Vec<WritePath>) -> Self {
        CreateFolderBatchArg {
            paths,
            autorename: false,
            force_async: false,
        }
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }
}

const CREATE_FOLDER_BATCH_ARG_FIELDS: &[&str] = &["paths",
                                                  "autorename",
                                                  "force_async"];
impl CreateFolderBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderBatchArg>, V::Error> {
        let mut field_paths = None;
        let mut field_autorename = None;
        let mut field_force_async = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "paths" => {
                    if field_paths.is_some() {
                        return Err(::serde::de::Error::duplicate_field("paths"));
                    }
                    field_paths = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderBatchArg {
            paths: field_paths.ok_or_else(|| ::serde::de::Error::missing_field("paths"))?,
            autorename: field_autorename.unwrap_or(false),
            force_async: field_force_async.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("paths", &self.paths)?;
        s.serialize_field("autorename", &self.autorename)?;
        s.serialize_field("force_async", &self.force_async)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderBatchArg", CREATE_FOLDER_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderBatchArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateFolderBatchError {
    /// The operation would involve too many files or folders.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "too_many_files" => CreateFolderBatchError::TooManyFiles,
                    _ => CreateFolderBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["too_many_files",
                                    "other"];
        deserializer.deserialize_struct("CreateFolderBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderBatchError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("CreateFolderBatchError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            CreateFolderBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CreateFolderBatchError {
}

impl ::std::fmt::Display for CreateFolderBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateFolderBatchError::TooManyFiles => f.write_str("The operation would involve too many files or folders."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateFolderBatchJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The batch create folder has finished.
    Complete(CreateFolderBatchResult),
    /// The batch create folder has failed.
    Failed(CreateFolderBatchError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderBatchJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => CreateFolderBatchJobStatus::InProgress,
                    "complete" => CreateFolderBatchJobStatus::Complete(CreateFolderBatchResult::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => CreateFolderBatchJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => CreateFolderBatchJobStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed",
                                    "other"];
        deserializer.deserialize_struct("CreateFolderBatchJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderBatchJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("CreateFolderBatchJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            CreateFolderBatchJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("CreateFolderBatchJobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            CreateFolderBatchJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateFolderBatchJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
            CreateFolderBatchJobStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Result returned by [`create_folder_batch()`](create_folder_batch) that may either launch an
/// asynchronous job or complete synchronously.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateFolderBatchLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(CreateFolderBatchResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderBatchLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => CreateFolderBatchLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => CreateFolderBatchLaunch::Complete(CreateFolderBatchResult::internal_deserialize(&mut map)?),
                    _ => CreateFolderBatchLaunch::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete",
                                    "other"];
        deserializer.deserialize_struct("CreateFolderBatchLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderBatchLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("CreateFolderBatchLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            CreateFolderBatchLaunch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("CreateFolderBatchLaunch", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            CreateFolderBatchLaunch::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderBatchResult {
    /// Each entry in [`CreateFolderBatchArg::paths`](CreateFolderBatchArg) will appear at the same
    /// position inside [`CreateFolderBatchResult::entries`](CreateFolderBatchResult).
    pub entries: Vec<CreateFolderBatchResultEntry>,
}

impl CreateFolderBatchResult {
    pub fn new(entries: Vec<CreateFolderBatchResultEntry>) -> Self {
        CreateFolderBatchResult {
            entries,
        }
    }
}

const CREATE_FOLDER_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl CreateFolderBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderBatchResult", CREATE_FOLDER_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum CreateFolderBatchResultEntry {
    Success(CreateFolderEntryResult),
    Failure(CreateFolderEntryError),
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderBatchResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderBatchResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderBatchResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => CreateFolderBatchResultEntry::Success(CreateFolderEntryResult::internal_deserialize(&mut map)?),
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => CreateFolderBatchResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure"];
        deserializer.deserialize_struct("CreateFolderBatchResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderBatchResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderBatchResultEntry::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("CreateFolderBatchResultEntry", 2)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            CreateFolderBatchResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateFolderBatchResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateFolderEntryError {
    Path(WriteError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderEntryError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderEntryError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderEntryError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => CreateFolderEntryError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => CreateFolderEntryError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "other"];
        deserializer.deserialize_struct("CreateFolderEntryError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderEntryError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderEntryError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateFolderEntryError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            CreateFolderEntryError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CreateFolderEntryError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            CreateFolderEntryError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for CreateFolderEntryError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateFolderEntryError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderEntryResult {
    /// Metadata of the created folder.
    pub metadata: FolderMetadata,
}

impl CreateFolderEntryResult {
    pub fn new(metadata: FolderMetadata) -> Self {
        CreateFolderEntryResult {
            metadata,
        }
    }
}

const CREATE_FOLDER_ENTRY_RESULT_FIELDS: &[&str] = &["metadata"];
impl CreateFolderEntryResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderEntryResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderEntryResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderEntryResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderEntryResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderEntryResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderEntryResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderEntryResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderEntryResult", CREATE_FOLDER_ENTRY_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderEntryResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderEntryResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum CreateFolderError {
    Path(WriteError),
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => CreateFolderError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path"];
        deserializer.deserialize_struct("CreateFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFolderError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateFolderError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for CreateFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            CreateFolderError::Path(inner) => Some(inner),
        }
    }
}

impl ::std::fmt::Display for CreateFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateFolderError::Path(inner) => write!(f, "{}", inner),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderResult {
    /// Metadata of the created folder.
    pub metadata: FolderMetadata,
}

impl CreateFolderResult {
    pub fn new(metadata: FolderMetadata) -> Self {
        CreateFolderResult {
            metadata,
        }
    }
}

const CREATE_FOLDER_RESULT_FIELDS: &[&str] = &["metadata"];
impl CreateFolderResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderResult", CREATE_FOLDER_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteArg {
    /// Path in the user's Dropbox to delete.
    pub path: WritePathOrId,
    /// Perform delete if given "rev" matches the existing file's latest "rev". This field does not
    /// support deleting a folder.
    pub parent_rev: Option<Rev>,
}

impl DeleteArg {
    pub fn new(path: WritePathOrId) -> Self {
        DeleteArg {
            path,
            parent_rev: None,
        }
    }

    pub fn with_parent_rev(mut self, value: Rev) -> Self {
        self.parent_rev = Some(value);
        self
    }
}

const DELETE_ARG_FIELDS: &[&str] = &["path",
                                     "parent_rev"];
impl DeleteArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteArg>, V::Error> {
        let mut field_path = None;
        let mut field_parent_rev = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "parent_rev" => {
                    if field_parent_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_rev"));
                    }
                    field_parent_rev = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            parent_rev: field_parent_rev,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        if let Some(val) = &self.parent_rev {
            s.serialize_field("parent_rev", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteArg", DELETE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteBatchArg {
    pub entries: Vec<DeleteArg>,
}

impl DeleteBatchArg {
    pub fn new(entries: Vec<DeleteArg>) -> Self {
        DeleteBatchArg {
            entries,
        }
    }
}

const DELETE_BATCH_ARG_FIELDS: &[&str] = &["entries"];
impl DeleteBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteBatchArg", DELETE_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteBatchError {
    /// Use [`DeleteError::TooManyWriteOperations`](DeleteError::TooManyWriteOperations).
    /// [`delete_batch()`](delete_batch) now provides smaller granularity about which entry has
    /// failed because of this.
    TooManyWriteOperations,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "too_many_write_operations" => DeleteBatchError::TooManyWriteOperations,
                    _ => DeleteBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["too_many_write_operations",
                                    "other"];
        deserializer.deserialize_struct("DeleteBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteBatchError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("DeleteBatchError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            DeleteBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DeleteBatchError {
}

impl ::std::fmt::Display for DeleteBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteBatchJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The batch delete has finished.
    Complete(DeleteBatchResult),
    /// The batch delete has failed.
    Failed(DeleteBatchError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteBatchJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => DeleteBatchJobStatus::InProgress,
                    "complete" => DeleteBatchJobStatus::Complete(DeleteBatchResult::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => DeleteBatchJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => DeleteBatchJobStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed",
                                    "other"];
        deserializer.deserialize_struct("DeleteBatchJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteBatchJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("DeleteBatchJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            DeleteBatchJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("DeleteBatchJobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            DeleteBatchJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DeleteBatchJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
            DeleteBatchJobStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Result returned by [`delete_batch()`](delete_batch) that may either launch an asynchronous job
/// or complete synchronously.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteBatchLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(DeleteBatchResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteBatchLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => DeleteBatchLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => DeleteBatchLaunch::Complete(DeleteBatchResult::internal_deserialize(&mut map)?),
                    _ => DeleteBatchLaunch::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete",
                                    "other"];
        deserializer.deserialize_struct("DeleteBatchLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteBatchLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("DeleteBatchLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            DeleteBatchLaunch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("DeleteBatchLaunch", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            DeleteBatchLaunch::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteBatchResult {
    /// Each entry in [`DeleteBatchArg::entries`](DeleteBatchArg) will appear at the same position
    /// inside [`DeleteBatchResult::entries`](DeleteBatchResult).
    pub entries: Vec<DeleteBatchResultEntry>,
}

impl DeleteBatchResult {
    pub fn new(entries: Vec<DeleteBatchResultEntry>) -> Self {
        DeleteBatchResult {
            entries,
        }
    }
}

const DELETE_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl DeleteBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteBatchResult", DELETE_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteBatchResultData {
    /// Metadata of the deleted object.
    pub metadata: Metadata,
}

impl DeleteBatchResultData {
    pub fn new(metadata: Metadata) -> Self {
        DeleteBatchResultData {
            metadata,
        }
    }
}

const DELETE_BATCH_RESULT_DATA_FIELDS: &[&str] = &["metadata"];
impl DeleteBatchResultData {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteBatchResultData, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteBatchResultData>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteBatchResultData {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchResultData {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteBatchResultData;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchResultData struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteBatchResultData::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteBatchResultData", DELETE_BATCH_RESULT_DATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchResultData {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteBatchResultData", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum DeleteBatchResultEntry {
    Success(DeleteBatchResultData),
    Failure(DeleteError),
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteBatchResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteBatchResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteBatchResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => DeleteBatchResultEntry::Success(DeleteBatchResultData::internal_deserialize(&mut map)?),
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => DeleteBatchResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure"];
        deserializer.deserialize_struct("DeleteBatchResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteBatchResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteBatchResultEntry::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("DeleteBatchResultEntry", 2)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            DeleteBatchResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DeleteBatchResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteError {
    PathLookup(LookupError),
    PathWrite(WriteError),
    /// There are too many write operations in user's Dropbox. Please retry this request.
    TooManyWriteOperations,
    /// There are too many files in one request. Please retry with fewer files.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path_lookup" => {
                        match map.next_key()? {
                            Some("path_lookup") => DeleteError::PathLookup(map.next_value()?),
                            None => return Err(de::Error::missing_field("path_lookup")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "path_write" => {
                        match map.next_key()? {
                            Some("path_write") => DeleteError::PathWrite(map.next_value()?),
                            None => return Err(de::Error::missing_field("path_write")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_write_operations" => DeleteError::TooManyWriteOperations,
                    "too_many_files" => DeleteError::TooManyFiles,
                    _ => DeleteError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path_lookup",
                                    "path_write",
                                    "too_many_write_operations",
                                    "too_many_files",
                                    "other"];
        deserializer.deserialize_struct("DeleteError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteError::PathLookup(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DeleteError", 2)?;
                s.serialize_field(".tag", "path_lookup")?;
                s.serialize_field("path_lookup", x)?;
                s.end()
            }
            DeleteError::PathWrite(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DeleteError", 2)?;
                s.serialize_field(".tag", "path_write")?;
                s.serialize_field("path_write", x)?;
                s.end()
            }
            DeleteError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("DeleteError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            DeleteError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("DeleteError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            DeleteError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DeleteError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            DeleteError::PathLookup(inner) => Some(inner),
            DeleteError::PathWrite(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for DeleteError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DeleteError::PathLookup(inner) => write!(f, "{}", inner),
            DeleteError::PathWrite(inner) => write!(f, "{}", inner),
            DeleteError::TooManyWriteOperations => f.write_str("There are too many write operations in user's Dropbox. Please retry this request."),
            DeleteError::TooManyFiles => f.write_str("There are too many files in one request. Please retry with fewer files."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteResult {
    /// Metadata of the deleted object.
    pub metadata: Metadata,
}

impl DeleteResult {
    pub fn new(metadata: Metadata) -> Self {
        DeleteResult {
            metadata,
        }
    }
}

const DELETE_RESULT_FIELDS: &[&str] = &["metadata"];
impl DeleteResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteResult", DELETE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Indicates that there used to be a file or folder at this path, but it no longer exists.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeletedMetadata {
    /// The last component of the path (including extension). This never contains a slash.
    pub name: String,
    /// The lowercased full path in the user's Dropbox. This always starts with a slash. This field
    /// will be null if the file or folder is not mounted.
    pub path_lower: Option<String>,
    /// The cased path to be used for display purposes only. In rare instances the casing will not
    /// correctly match the user's filesystem, but this behavior will match the path provided in the
    /// Core API v1, and at least the last path component will have the correct casing. Changes to
    /// only the casing of paths won't be returned by
    /// [`list_folder_continue()`](list_folder_continue). This field will be null if the file or
    /// folder is not mounted.
    pub path_display: Option<String>,
    /// Please use [`FileSharingInfo::parent_shared_folder_id`](FileSharingInfo) or
    /// [`FolderSharingInfo::parent_shared_folder_id`](FolderSharingInfo) instead.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
}

impl DeletedMetadata {
    pub fn new(name: String) -> Self {
        DeletedMetadata {
            name,
            path_lower: None,
            path_display: None,
            parent_shared_folder_id: None,
        }
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_path_display(mut self, value: String) -> Self {
        self.path_display = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }
}

const DELETED_METADATA_FIELDS: &[&str] = &["name",
                                           "path_lower",
                                           "path_display",
                                           "parent_shared_folder_id"];
impl DeletedMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeletedMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeletedMetadata>, V::Error> {
        let mut field_name = None;
        let mut field_path_lower = None;
        let mut field_path_display = None;
        let mut field_parent_shared_folder_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "path_display" => {
                    if field_path_display.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_display"));
                    }
                    field_path_display = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeletedMetadata {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            path_lower: field_path_lower,
            path_display: field_path_display,
            parent_shared_folder_id: field_parent_shared_folder_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        if let Some(val) = &self.path_lower {
            s.serialize_field("path_lower", val)?;
        }
        if let Some(val) = &self.path_display {
            s.serialize_field("path_display", val)?;
        }
        if let Some(val) = &self.parent_shared_folder_id {
            s.serialize_field("parent_shared_folder_id", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeletedMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeletedMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeletedMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeletedMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeletedMetadata", DELETED_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeletedMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeletedMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Dimensions for a photo or video.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Dimensions {
    /// Height of the photo/video.
    pub height: u64,
    /// Width of the photo/video.
    pub width: u64,
}

impl Dimensions {
    pub fn new(height: u64, width: u64) -> Self {
        Dimensions {
            height,
            width,
        }
    }
}

const DIMENSIONS_FIELDS: &[&str] = &["height",
                                     "width"];
impl Dimensions {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Dimensions, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Dimensions>, V::Error> {
        let mut field_height = None;
        let mut field_width = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "height" => {
                    if field_height.is_some() {
                        return Err(::serde::de::Error::duplicate_field("height"));
                    }
                    field_height = Some(map.next_value()?);
                }
                "width" => {
                    if field_width.is_some() {
                        return Err(::serde::de::Error::duplicate_field("width"));
                    }
                    field_width = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Dimensions {
            height: field_height.ok_or_else(|| ::serde::de::Error::missing_field("height"))?,
            width: field_width.ok_or_else(|| ::serde::de::Error::missing_field("width"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("height", &self.height)?;
        s.serialize_field("width", &self.width)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Dimensions {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Dimensions;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Dimensions struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Dimensions::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Dimensions", DIMENSIONS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Dimensions {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Dimensions", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DownloadArg {
    /// The path of the file to download.
    pub path: ReadPath,
    /// Please specify revision in `path` instead.
    pub rev: Option<Rev>,
}

impl DownloadArg {
    pub fn new(path: ReadPath) -> Self {
        DownloadArg {
            path,
            rev: None,
        }
    }

    pub fn with_rev(mut self, value: Rev) -> Self {
        self.rev = Some(value);
        self
    }
}

const DOWNLOAD_ARG_FIELDS: &[&str] = &["path",
                                       "rev"];
impl DownloadArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DownloadArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DownloadArg>, V::Error> {
        let mut field_path = None;
        let mut field_rev = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DownloadArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            rev: field_rev,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        if let Some(val) = &self.rev {
            s.serialize_field("rev", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DownloadArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DownloadArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DownloadArg", DOWNLOAD_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DownloadArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DownloadError {
    Path(LookupError),
    /// This file type cannot be downloaded directly; use [`export()`](export) instead.
    UnsupportedFile,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DownloadError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => DownloadError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unsupported_file" => DownloadError::UnsupportedFile,
                    _ => DownloadError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "unsupported_file",
                                    "other"];
        deserializer.deserialize_struct("DownloadError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DownloadError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DownloadError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            DownloadError::UnsupportedFile => {
                // unit
                let mut s = serializer.serialize_struct("DownloadError", 1)?;
                s.serialize_field(".tag", "unsupported_file")?;
                s.end()
            }
            DownloadError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DownloadError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            DownloadError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for DownloadError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DownloadError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DownloadZipArg {
    /// The path of the folder to download.
    pub path: ReadPath,
}

impl DownloadZipArg {
    pub fn new(path: ReadPath) -> Self {
        DownloadZipArg {
            path,
        }
    }
}

const DOWNLOAD_ZIP_ARG_FIELDS: &[&str] = &["path"];
impl DownloadZipArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DownloadZipArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DownloadZipArg>, V::Error> {
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DownloadZipArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadZipArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DownloadZipArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadZipArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DownloadZipArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DownloadZipArg", DOWNLOAD_ZIP_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadZipArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DownloadZipArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DownloadZipError {
    Path(LookupError),
    /// The folder or a file is too large to download.
    TooLarge,
    /// The folder has too many files to download.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadZipError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DownloadZipError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadZipError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => DownloadZipError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_large" => DownloadZipError::TooLarge,
                    "too_many_files" => DownloadZipError::TooManyFiles,
                    _ => DownloadZipError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "too_large",
                                    "too_many_files",
                                    "other"];
        deserializer.deserialize_struct("DownloadZipError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadZipError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DownloadZipError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("DownloadZipError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            DownloadZipError::TooLarge => {
                // unit
                let mut s = serializer.serialize_struct("DownloadZipError", 1)?;
                s.serialize_field(".tag", "too_large")?;
                s.end()
            }
            DownloadZipError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("DownloadZipError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            DownloadZipError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DownloadZipError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            DownloadZipError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for DownloadZipError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DownloadZipError::Path(inner) => write!(f, "{}", inner),
            DownloadZipError::TooLarge => f.write_str("The folder or a file is too large to download."),
            DownloadZipError::TooManyFiles => f.write_str("The folder has too many files to download."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DownloadZipResult {
    pub metadata: FolderMetadata,
}

impl DownloadZipResult {
    pub fn new(metadata: FolderMetadata) -> Self {
        DownloadZipResult {
            metadata,
        }
    }
}

const DOWNLOAD_ZIP_RESULT_FIELDS: &[&str] = &["metadata"];
impl DownloadZipResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DownloadZipResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DownloadZipResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DownloadZipResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadZipResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DownloadZipResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadZipResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DownloadZipResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DownloadZipResult", DOWNLOAD_ZIP_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadZipResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DownloadZipResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExportArg {
    /// The path of the file to be exported.
    pub path: ReadPath,
    /// The file format to which the file should be exported. This must be one of the formats listed
    /// in the file's export_options returned by [`get_metadata()`](get_metadata). If none is
    /// specified, the default format (specified in export_as in file metadata) will be used.
    pub export_format: Option<String>,
}

impl ExportArg {
    pub fn new(path: ReadPath) -> Self {
        ExportArg {
            path,
            export_format: None,
        }
    }

    pub fn with_export_format(mut self, value: String) -> Self {
        self.export_format = Some(value);
        self
    }
}

const EXPORT_ARG_FIELDS: &[&str] = &["path",
                                     "export_format"];
impl ExportArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExportArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExportArg>, V::Error> {
        let mut field_path = None;
        let mut field_export_format = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "export_format" => {
                    if field_export_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_format"));
                    }
                    field_export_format = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExportArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            export_format: field_export_format,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        if let Some(val) = &self.export_format {
            s.serialize_field("export_format", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExportArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExportArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExportArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExportArg", EXPORT_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExportArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExportArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ExportError {
    Path(LookupError),
    /// This file type cannot be exported. Use [`download()`](download) instead.
    NonExportable,
    /// The specified export format is not a valid option for this file type.
    InvalidExportFormat,
    /// The exportable content is not yet available. Please retry later.
    RetryError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ExportError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ExportError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ExportError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "non_exportable" => ExportError::NonExportable,
                    "invalid_export_format" => ExportError::InvalidExportFormat,
                    "retry_error" => ExportError::RetryError,
                    _ => ExportError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "non_exportable",
                                    "invalid_export_format",
                                    "retry_error",
                                    "other"];
        deserializer.deserialize_struct("ExportError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ExportError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ExportError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ExportError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ExportError::NonExportable => {
                // unit
                let mut s = serializer.serialize_struct("ExportError", 1)?;
                s.serialize_field(".tag", "non_exportable")?;
                s.end()
            }
            ExportError::InvalidExportFormat => {
                // unit
                let mut s = serializer.serialize_struct("ExportError", 1)?;
                s.serialize_field(".tag", "invalid_export_format")?;
                s.end()
            }
            ExportError::RetryError => {
                // unit
                let mut s = serializer.serialize_struct("ExportError", 1)?;
                s.serialize_field(".tag", "retry_error")?;
                s.end()
            }
            ExportError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ExportError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ExportError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ExportError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ExportError::Path(inner) => write!(f, "{}", inner),
            ExportError::InvalidExportFormat => f.write_str("The specified export format is not a valid option for this file type."),
            ExportError::RetryError => f.write_str("The exportable content is not yet available. Please retry later."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Export information for a file.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExportInfo {
    /// Format to which the file can be exported to.
    pub export_as: Option<String>,
    /// Additional formats to which the file can be exported. These values can be specified as the
    /// export_format in /files/export.
    pub export_options: Option<Vec<String>>,
}

impl Default for ExportInfo {
    fn default() -> Self {
        ExportInfo {
            export_as: None,
            export_options: None,
        }
    }
}

impl ExportInfo {
    pub fn with_export_as(mut self, value: String) -> Self {
        self.export_as = Some(value);
        self
    }

    pub fn with_export_options(mut self, value: Vec<String>) -> Self {
        self.export_options = Some(value);
        self
    }
}

const EXPORT_INFO_FIELDS: &[&str] = &["export_as",
                                      "export_options"];
impl ExportInfo {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ExportInfo, V::Error> {
        let mut field_export_as = None;
        let mut field_export_options = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "export_as" => {
                    if field_export_as.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_as"));
                    }
                    field_export_as = Some(map.next_value()?);
                }
                "export_options" => {
                    if field_export_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_options"));
                    }
                    field_export_options = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ExportInfo {
            export_as: field_export_as,
            export_options: field_export_options,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.export_as {
            s.serialize_field("export_as", val)?;
        }
        if let Some(val) = &self.export_options {
            s.serialize_field("export_options", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExportInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExportInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExportInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExportInfo", EXPORT_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExportInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExportInfo", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExportMetadata {
    /// The last component of the path (including extension). This never contains a slash.
    pub name: String,
    /// The file size in bytes.
    pub size: u64,
    /// A hash based on the exported file content. This field can be used to verify data integrity.
    /// Similar to content hash. For more information see our [Content
    /// hash](https://www.dropbox.com/developers/reference/content-hash) page.
    pub export_hash: Option<Sha256HexHash>,
    /// If the file is a Paper doc, this gives the latest doc revision which can be used in
    /// [`paper_update()`](paper_update).
    pub paper_revision: Option<i64>,
}

impl ExportMetadata {
    pub fn new(name: String, size: u64) -> Self {
        ExportMetadata {
            name,
            size,
            export_hash: None,
            paper_revision: None,
        }
    }

    pub fn with_export_hash(mut self, value: Sha256HexHash) -> Self {
        self.export_hash = Some(value);
        self
    }

    pub fn with_paper_revision(mut self, value: i64) -> Self {
        self.paper_revision = Some(value);
        self
    }
}

const EXPORT_METADATA_FIELDS: &[&str] = &["name",
                                          "size",
                                          "export_hash",
                                          "paper_revision"];
impl ExportMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExportMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExportMetadata>, V::Error> {
        let mut field_name = None;
        let mut field_size = None;
        let mut field_export_hash = None;
        let mut field_paper_revision = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "export_hash" => {
                    if field_export_hash.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_hash"));
                    }
                    field_export_hash = Some(map.next_value()?);
                }
                "paper_revision" => {
                    if field_paper_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("paper_revision"));
                    }
                    field_paper_revision = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExportMetadata {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            size: field_size.ok_or_else(|| ::serde::de::Error::missing_field("size"))?,
            export_hash: field_export_hash,
            paper_revision: field_paper_revision,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("size", &self.size)?;
        if let Some(val) = &self.export_hash {
            s.serialize_field("export_hash", val)?;
        }
        if let Some(val) = &self.paper_revision {
            s.serialize_field("paper_revision", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExportMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExportMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExportMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExportMetadata", EXPORT_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExportMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExportMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExportResult {
    /// Metadata for the exported version of the file.
    pub export_metadata: ExportMetadata,
    /// Metadata for the original file.
    pub file_metadata: FileMetadata,
}

impl ExportResult {
    pub fn new(export_metadata: ExportMetadata, file_metadata: FileMetadata) -> Self {
        ExportResult {
            export_metadata,
            file_metadata,
        }
    }
}

const EXPORT_RESULT_FIELDS: &[&str] = &["export_metadata",
                                        "file_metadata"];
impl ExportResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExportResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExportResult>, V::Error> {
        let mut field_export_metadata = None;
        let mut field_file_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "export_metadata" => {
                    if field_export_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_metadata"));
                    }
                    field_export_metadata = Some(map.next_value()?);
                }
                "file_metadata" => {
                    if field_file_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_metadata"));
                    }
                    field_file_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExportResult {
            export_metadata: field_export_metadata.ok_or_else(|| ::serde::de::Error::missing_field("export_metadata"))?,
            file_metadata: field_file_metadata.ok_or_else(|| ::serde::de::Error::missing_field("file_metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("export_metadata", &self.export_metadata)?;
        s.serialize_field("file_metadata", &self.file_metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExportResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExportResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExportResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExportResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExportResult", EXPORT_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExportResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExportResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileCategory {
    /// jpg, png, gif, and more.
    Image,
    /// doc, docx, txt, and more.
    Document,
    /// pdf.
    Pdf,
    /// xlsx, xls, csv, and more.
    Spreadsheet,
    /// ppt, pptx, key, and more.
    Presentation,
    /// mp3, wav, mid, and more.
    Audio,
    /// mov, wmv, mp4, and more.
    Video,
    /// dropbox folder.
    Folder,
    /// dropbox paper doc.
    Paper,
    /// any file not in one of the categories above.
    Others,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileCategory {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileCategory;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileCategory structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "image" => FileCategory::Image,
                    "document" => FileCategory::Document,
                    "pdf" => FileCategory::Pdf,
                    "spreadsheet" => FileCategory::Spreadsheet,
                    "presentation" => FileCategory::Presentation,
                    "audio" => FileCategory::Audio,
                    "video" => FileCategory::Video,
                    "folder" => FileCategory::Folder,
                    "paper" => FileCategory::Paper,
                    "others" => FileCategory::Others,
                    _ => FileCategory::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["image",
                                    "document",
                                    "pdf",
                                    "spreadsheet",
                                    "presentation",
                                    "audio",
                                    "video",
                                    "folder",
                                    "paper",
                                    "others",
                                    "other"];
        deserializer.deserialize_struct("FileCategory", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileCategory {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileCategory::Image => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "image")?;
                s.end()
            }
            FileCategory::Document => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "document")?;
                s.end()
            }
            FileCategory::Pdf => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "pdf")?;
                s.end()
            }
            FileCategory::Spreadsheet => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "spreadsheet")?;
                s.end()
            }
            FileCategory::Presentation => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "presentation")?;
                s.end()
            }
            FileCategory::Audio => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "audio")?;
                s.end()
            }
            FileCategory::Video => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "video")?;
                s.end()
            }
            FileCategory::Folder => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "folder")?;
                s.end()
            }
            FileCategory::Paper => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "paper")?;
                s.end()
            }
            FileCategory::Others => {
                // unit
                let mut s = serializer.serialize_struct("FileCategory", 1)?;
                s.serialize_field(".tag", "others")?;
                s.end()
            }
            FileCategory::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileLock {
    /// The lock description.
    pub content: FileLockContent,
}

impl FileLock {
    pub fn new(content: FileLockContent) -> Self {
        FileLock {
            content,
        }
    }
}

const FILE_LOCK_FIELDS: &[&str] = &["content"];
impl FileLock {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileLock, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileLock>, V::Error> {
        let mut field_content = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "content" => {
                    if field_content.is_some() {
                        return Err(::serde::de::Error::duplicate_field("content"));
                    }
                    field_content = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileLock {
            content: field_content.ok_or_else(|| ::serde::de::Error::missing_field("content"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("content", &self.content)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileLock {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileLock;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLock struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileLock::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileLock", FILE_LOCK_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileLock {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileLock", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileLockContent {
    /// Empty type to indicate no lock.
    Unlocked,
    /// A lock held by a single user.
    SingleUser(SingleUserLock),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileLockContent {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileLockContent;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLockContent structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unlocked" => FileLockContent::Unlocked,
                    "single_user" => FileLockContent::SingleUser(SingleUserLock::internal_deserialize(&mut map)?),
                    _ => FileLockContent::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unlocked",
                                    "single_user",
                                    "other"];
        deserializer.deserialize_struct("FileLockContent", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileLockContent {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileLockContent::Unlocked => {
                // unit
                let mut s = serializer.serialize_struct("FileLockContent", 1)?;
                s.serialize_field(".tag", "unlocked")?;
                s.end()
            }
            FileLockContent::SingleUser(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("FileLockContent", 4)?;
                s.serialize_field(".tag", "single_user")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            FileLockContent::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileLockMetadata {
    /// True if caller holds the file lock.
    pub is_lockholder: Option<bool>,
    /// The display name of the lock holder.
    pub lockholder_name: Option<String>,
    /// The account ID of the lock holder if known.
    pub lockholder_account_id: Option<super::users_common::AccountId>,
    /// The timestamp of the lock was created.
    pub created: Option<super::common::DropboxTimestamp>,
}

impl Default for FileLockMetadata {
    fn default() -> Self {
        FileLockMetadata {
            is_lockholder: None,
            lockholder_name: None,
            lockholder_account_id: None,
            created: None,
        }
    }
}

impl FileLockMetadata {
    pub fn with_is_lockholder(mut self, value: bool) -> Self {
        self.is_lockholder = Some(value);
        self
    }

    pub fn with_lockholder_name(mut self, value: String) -> Self {
        self.lockholder_name = Some(value);
        self
    }

    pub fn with_lockholder_account_id(mut self, value: super::users_common::AccountId) -> Self {
        self.lockholder_account_id = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }
}

const FILE_LOCK_METADATA_FIELDS: &[&str] = &["is_lockholder",
                                             "lockholder_name",
                                             "lockholder_account_id",
                                             "created"];
impl FileLockMetadata {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<FileLockMetadata, V::Error> {
        let mut field_is_lockholder = None;
        let mut field_lockholder_name = None;
        let mut field_lockholder_account_id = None;
        let mut field_created = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "is_lockholder" => {
                    if field_is_lockholder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_lockholder"));
                    }
                    field_is_lockholder = Some(map.next_value()?);
                }
                "lockholder_name" => {
                    if field_lockholder_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lockholder_name"));
                    }
                    field_lockholder_name = Some(map.next_value()?);
                }
                "lockholder_account_id" => {
                    if field_lockholder_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lockholder_account_id"));
                    }
                    field_lockholder_account_id = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = FileLockMetadata {
            is_lockholder: field_is_lockholder,
            lockholder_name: field_lockholder_name,
            lockholder_account_id: field_lockholder_account_id,
            created: field_created,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.is_lockholder {
            s.serialize_field("is_lockholder", val)?;
        }
        if let Some(val) = &self.lockholder_name {
            s.serialize_field("lockholder_name", val)?;
        }
        if let Some(val) = &self.lockholder_account_id {
            s.serialize_field("lockholder_account_id", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileLockMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileLockMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLockMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileLockMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileLockMetadata", FILE_LOCK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileLockMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileLockMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileMetadata {
    /// The last component of the path (including extension). This never contains a slash.
    pub name: String,
    /// A unique identifier for the file.
    pub id: Id,
    /// For files, this is the modification time set by the desktop client when the file was added
    /// to Dropbox. Since this time is not verified (the Dropbox server stores whatever the desktop
    /// client sends up), this should only be used for display purposes (such as sorting) and not,
    /// for example, to determine if a file has changed or not.
    pub client_modified: super::common::DropboxTimestamp,
    /// The last time the file was modified on Dropbox.
    pub server_modified: super::common::DropboxTimestamp,
    /// A unique identifier for the current revision of a file. This field is the same rev as
    /// elsewhere in the API and can be used to detect changes and avoid conflicts.
    pub rev: Rev,
    /// The file size in bytes.
    pub size: u64,
    /// The lowercased full path in the user's Dropbox. This always starts with a slash. This field
    /// will be null if the file or folder is not mounted.
    pub path_lower: Option<String>,
    /// The cased path to be used for display purposes only. In rare instances the casing will not
    /// correctly match the user's filesystem, but this behavior will match the path provided in the
    /// Core API v1, and at least the last path component will have the correct casing. Changes to
    /// only the casing of paths won't be returned by
    /// [`list_folder_continue()`](list_folder_continue). This field will be null if the file or
    /// folder is not mounted.
    pub path_display: Option<String>,
    /// Please use [`FileSharingInfo::parent_shared_folder_id`](FileSharingInfo) or
    /// [`FolderSharingInfo::parent_shared_folder_id`](FolderSharingInfo) instead.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// Additional information if the file is a photo or video. This field will not be set on
    /// entries returned by [`list_folder()`](list_folder),
    /// [`list_folder_continue()`](list_folder_continue), or
    /// [`get_thumbnail_batch()`](get_thumbnail_batch), starting December 2, 2019.
    pub media_info: Option<MediaInfo>,
    /// Set if this file is a symlink.
    pub symlink_info: Option<SymlinkInfo>,
    /// Set if this file is contained in a shared folder.
    pub sharing_info: Option<FileSharingInfo>,
    /// If true, file can be downloaded directly; else the file must be exported.
    pub is_downloadable: bool,
    /// Information about format this file can be exported to. This filed must be set if
    /// `is_downloadable` is set to false.
    pub export_info: Option<ExportInfo>,
    /// Additional information if the file has custom properties with the property template
    /// specified.
    pub property_groups: Option<Vec<super::file_properties::PropertyGroup>>,
    /// This flag will only be present if include_has_explicit_shared_members  is true in
    /// [`list_folder()`](list_folder) or [`get_metadata()`](get_metadata). If this  flag is
    /// present, it will be true if this file has any explicit shared  members. This is different
    /// from sharing_info in that this could be true  in the case where a file has explicit members
    /// but is not contained within  a shared folder.
    pub has_explicit_shared_members: Option<bool>,
    /// A hash of the file content. This field can be used to verify data integrity. For more
    /// information see our [Content
    /// hash](https://www.dropbox.com/developers/reference/content-hash) page.
    pub content_hash: Option<Sha256HexHash>,
    /// If present, the metadata associated with the file's current lock.
    pub file_lock_info: Option<FileLockMetadata>,
}

impl FileMetadata {
    pub fn new(
        name: String,
        id: Id,
        client_modified: super::common::DropboxTimestamp,
        server_modified: super::common::DropboxTimestamp,
        rev: Rev,
        size: u64,
    ) -> Self {
        FileMetadata {
            name,
            id,
            client_modified,
            server_modified,
            rev,
            size,
            path_lower: None,
            path_display: None,
            parent_shared_folder_id: None,
            media_info: None,
            symlink_info: None,
            sharing_info: None,
            is_downloadable: true,
            export_info: None,
            property_groups: None,
            has_explicit_shared_members: None,
            content_hash: None,
            file_lock_info: None,
        }
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_path_display(mut self, value: String) -> Self {
        self.path_display = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_media_info(mut self, value: MediaInfo) -> Self {
        self.media_info = Some(value);
        self
    }

    pub fn with_symlink_info(mut self, value: SymlinkInfo) -> Self {
        self.symlink_info = Some(value);
        self
    }

    pub fn with_sharing_info(mut self, value: FileSharingInfo) -> Self {
        self.sharing_info = Some(value);
        self
    }

    pub fn with_is_downloadable(mut self, value: bool) -> Self {
        self.is_downloadable = value;
        self
    }

    pub fn with_export_info(mut self, value: ExportInfo) -> Self {
        self.export_info = Some(value);
        self
    }

    pub fn with_property_groups(
        mut self,
        value: Vec<super::file_properties::PropertyGroup>,
    ) -> Self {
        self.property_groups = Some(value);
        self
    }

    pub fn with_has_explicit_shared_members(mut self, value: bool) -> Self {
        self.has_explicit_shared_members = Some(value);
        self
    }

    pub fn with_content_hash(mut self, value: Sha256HexHash) -> Self {
        self.content_hash = Some(value);
        self
    }

    pub fn with_file_lock_info(mut self, value: FileLockMetadata) -> Self {
        self.file_lock_info = Some(value);
        self
    }
}

const FILE_METADATA_FIELDS: &[&str] = &["name",
                                        "id",
                                        "client_modified",
                                        "server_modified",
                                        "rev",
                                        "size",
                                        "path_lower",
                                        "path_display",
                                        "parent_shared_folder_id",
                                        "media_info",
                                        "symlink_info",
                                        "sharing_info",
                                        "is_downloadable",
                                        "export_info",
                                        "property_groups",
                                        "has_explicit_shared_members",
                                        "content_hash",
                                        "file_lock_info"];
impl FileMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileMetadata>, V::Error> {
        let mut field_name = None;
        let mut field_id = None;
        let mut field_client_modified = None;
        let mut field_server_modified = None;
        let mut field_rev = None;
        let mut field_size = None;
        let mut field_path_lower = None;
        let mut field_path_display = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_media_info = None;
        let mut field_symlink_info = None;
        let mut field_sharing_info = None;
        let mut field_is_downloadable = None;
        let mut field_export_info = None;
        let mut field_property_groups = None;
        let mut field_has_explicit_shared_members = None;
        let mut field_content_hash = None;
        let mut field_file_lock_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "client_modified" => {
                    if field_client_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_modified"));
                    }
                    field_client_modified = Some(map.next_value()?);
                }
                "server_modified" => {
                    if field_server_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("server_modified"));
                    }
                    field_server_modified = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "path_display" => {
                    if field_path_display.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_display"));
                    }
                    field_path_display = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "media_info" => {
                    if field_media_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("media_info"));
                    }
                    field_media_info = Some(map.next_value()?);
                }
                "symlink_info" => {
                    if field_symlink_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("symlink_info"));
                    }
                    field_symlink_info = Some(map.next_value()?);
                }
                "sharing_info" => {
                    if field_sharing_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sharing_info"));
                    }
                    field_sharing_info = Some(map.next_value()?);
                }
                "is_downloadable" => {
                    if field_is_downloadable.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_downloadable"));
                    }
                    field_is_downloadable = Some(map.next_value()?);
                }
                "export_info" => {
                    if field_export_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("export_info"));
                    }
                    field_export_info = Some(map.next_value()?);
                }
                "property_groups" => {
                    if field_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("property_groups"));
                    }
                    field_property_groups = Some(map.next_value()?);
                }
                "has_explicit_shared_members" => {
                    if field_has_explicit_shared_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_explicit_shared_members"));
                    }
                    field_has_explicit_shared_members = Some(map.next_value()?);
                }
                "content_hash" => {
                    if field_content_hash.is_some() {
                        return Err(::serde::de::Error::duplicate_field("content_hash"));
                    }
                    field_content_hash = Some(map.next_value()?);
                }
                "file_lock_info" => {
                    if field_file_lock_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_lock_info"));
                    }
                    field_file_lock_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileMetadata {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            client_modified: field_client_modified.ok_or_else(|| ::serde::de::Error::missing_field("client_modified"))?,
            server_modified: field_server_modified.ok_or_else(|| ::serde::de::Error::missing_field("server_modified"))?,
            rev: field_rev.ok_or_else(|| ::serde::de::Error::missing_field("rev"))?,
            size: field_size.ok_or_else(|| ::serde::de::Error::missing_field("size"))?,
            path_lower: field_path_lower,
            path_display: field_path_display,
            parent_shared_folder_id: field_parent_shared_folder_id,
            media_info: field_media_info,
            symlink_info: field_symlink_info,
            sharing_info: field_sharing_info,
            is_downloadable: field_is_downloadable.unwrap_or(true),
            export_info: field_export_info,
            property_groups: field_property_groups,
            has_explicit_shared_members: field_has_explicit_shared_members,
            content_hash: field_content_hash,
            file_lock_info: field_file_lock_info,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("client_modified", &self.client_modified)?;
        s.serialize_field("server_modified", &self.server_modified)?;
        s.serialize_field("rev", &self.rev)?;
        s.serialize_field("size", &self.size)?;
        if let Some(val) = &self.path_lower {
            s.serialize_field("path_lower", val)?;
        }
        if let Some(val) = &self.path_display {
            s.serialize_field("path_display", val)?;
        }
        if let Some(val) = &self.parent_shared_folder_id {
            s.serialize_field("parent_shared_folder_id", val)?;
        }
        if let Some(val) = &self.media_info {
            s.serialize_field("media_info", val)?;
        }
        if let Some(val) = &self.symlink_info {
            s.serialize_field("symlink_info", val)?;
        }
        if let Some(val) = &self.sharing_info {
            s.serialize_field("sharing_info", val)?;
        }
        s.serialize_field("is_downloadable", &self.is_downloadable)?;
        if let Some(val) = &self.export_info {
            s.serialize_field("export_info", val)?;
        }
        if let Some(val) = &self.property_groups {
            s.serialize_field("property_groups", val)?;
        }
        if let Some(val) = &self.has_explicit_shared_members {
            s.serialize_field("has_explicit_shared_members", val)?;
        }
        if let Some(val) = &self.content_hash {
            s.serialize_field("content_hash", val)?;
        }
        if let Some(val) = &self.file_lock_info {
            s.serialize_field("file_lock_info", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileMetadata", FILE_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileMetadata", 18)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileOpsResult {
}

impl Default for FileOpsResult {
    fn default() -> Self {
        FileOpsResult {
        }
    }
}

const FILE_OPS_RESULT_FIELDS: &[&str] = &[];
impl FileOpsResult {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<FileOpsResult, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(FileOpsResult {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileOpsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileOpsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileOpsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileOpsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileOpsResult", FILE_OPS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileOpsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("FileOpsResult", 0)?.end()
    }
}

/// Sharing info for a file which is contained by a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileSharingInfo {
    /// True if the file or folder is inside a read-only shared folder.
    pub read_only: bool,
    /// ID of shared folder that holds this file.
    pub parent_shared_folder_id: super::common::SharedFolderId,
    /// The last user who modified the file. This field will be null if the user's account has been
    /// deleted.
    pub modified_by: Option<super::users_common::AccountId>,
}

impl FileSharingInfo {
    pub fn new(read_only: bool, parent_shared_folder_id: super::common::SharedFolderId) -> Self {
        FileSharingInfo {
            read_only,
            parent_shared_folder_id,
            modified_by: None,
        }
    }

    pub fn with_modified_by(mut self, value: super::users_common::AccountId) -> Self {
        self.modified_by = Some(value);
        self
    }
}

const FILE_SHARING_INFO_FIELDS: &[&str] = &["read_only",
                                            "parent_shared_folder_id",
                                            "modified_by"];
impl FileSharingInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileSharingInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileSharingInfo>, V::Error> {
        let mut field_read_only = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_modified_by = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "read_only" => {
                    if field_read_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("read_only"));
                    }
                    field_read_only = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "modified_by" => {
                    if field_modified_by.is_some() {
                        return Err(::serde::de::Error::duplicate_field("modified_by"));
                    }
                    field_modified_by = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileSharingInfo {
            read_only: field_read_only.ok_or_else(|| ::serde::de::Error::missing_field("read_only"))?,
            parent_shared_folder_id: field_parent_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("parent_shared_folder_id"))?,
            modified_by: field_modified_by,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("read_only", &self.read_only)?;
        s.serialize_field("parent_shared_folder_id", &self.parent_shared_folder_id)?;
        if let Some(val) = &self.modified_by {
            s.serialize_field("modified_by", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileSharingInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileSharingInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileSharingInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileSharingInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileSharingInfo", FILE_SHARING_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileSharingInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileSharingInfo", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileStatus {
    Active,
    Deleted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "active" => FileStatus::Active,
                    "deleted" => FileStatus::Deleted,
                    _ => FileStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["active",
                                    "deleted",
                                    "other"];
        deserializer.deserialize_struct("FileStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileStatus::Active => {
                // unit
                let mut s = serializer.serialize_struct("FileStatus", 1)?;
                s.serialize_field(".tag", "active")?;
                s.end()
            }
            FileStatus::Deleted => {
                // unit
                let mut s = serializer.serialize_struct("FileStatus", 1)?;
                s.serialize_field(".tag", "deleted")?;
                s.end()
            }
            FileStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FolderMetadata {
    /// The last component of the path (including extension). This never contains a slash.
    pub name: String,
    /// A unique identifier for the folder.
    pub id: Id,
    /// The lowercased full path in the user's Dropbox. This always starts with a slash. This field
    /// will be null if the file or folder is not mounted.
    pub path_lower: Option<String>,
    /// The cased path to be used for display purposes only. In rare instances the casing will not
    /// correctly match the user's filesystem, but this behavior will match the path provided in the
    /// Core API v1, and at least the last path component will have the correct casing. Changes to
    /// only the casing of paths won't be returned by
    /// [`list_folder_continue()`](list_folder_continue). This field will be null if the file or
    /// folder is not mounted.
    pub path_display: Option<String>,
    /// Please use [`FileSharingInfo::parent_shared_folder_id`](FileSharingInfo) or
    /// [`FolderSharingInfo::parent_shared_folder_id`](FolderSharingInfo) instead.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// Please use `sharing_info` instead.
    pub shared_folder_id: Option<super::common::SharedFolderId>,
    /// Set if the folder is contained in a shared folder or is a shared folder mount point.
    pub sharing_info: Option<FolderSharingInfo>,
    /// Additional information if the file has custom properties with the property template
    /// specified. Note that only properties associated with user-owned templates, not team-owned
    /// templates, can be attached to folders.
    pub property_groups: Option<Vec<super::file_properties::PropertyGroup>>,
}

impl FolderMetadata {
    pub fn new(name: String, id: Id) -> Self {
        FolderMetadata {
            name,
            id,
            path_lower: None,
            path_display: None,
            parent_shared_folder_id: None,
            shared_folder_id: None,
            sharing_info: None,
            property_groups: None,
        }
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_path_display(mut self, value: String) -> Self {
        self.path_display = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.shared_folder_id = Some(value);
        self
    }

    pub fn with_sharing_info(mut self, value: FolderSharingInfo) -> Self {
        self.sharing_info = Some(value);
        self
    }

    pub fn with_property_groups(
        mut self,
        value: Vec<super::file_properties::PropertyGroup>,
    ) -> Self {
        self.property_groups = Some(value);
        self
    }
}

const FOLDER_METADATA_FIELDS: &[&str] = &["name",
                                          "id",
                                          "path_lower",
                                          "path_display",
                                          "parent_shared_folder_id",
                                          "shared_folder_id",
                                          "sharing_info",
                                          "property_groups"];
impl FolderMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FolderMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FolderMetadata>, V::Error> {
        let mut field_name = None;
        let mut field_id = None;
        let mut field_path_lower = None;
        let mut field_path_display = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_shared_folder_id = None;
        let mut field_sharing_info = None;
        let mut field_property_groups = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "path_display" => {
                    if field_path_display.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_display"));
                    }
                    field_path_display = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "sharing_info" => {
                    if field_sharing_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sharing_info"));
                    }
                    field_sharing_info = Some(map.next_value()?);
                }
                "property_groups" => {
                    if field_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("property_groups"));
                    }
                    field_property_groups = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FolderMetadata {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            path_lower: field_path_lower,
            path_display: field_path_display,
            parent_shared_folder_id: field_parent_shared_folder_id,
            shared_folder_id: field_shared_folder_id,
            sharing_info: field_sharing_info,
            property_groups: field_property_groups,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("id", &self.id)?;
        if let Some(val) = &self.path_lower {
            s.serialize_field("path_lower", val)?;
        }
        if let Some(val) = &self.path_display {
            s.serialize_field("path_display", val)?;
        }
        if let Some(val) = &self.parent_shared_folder_id {
            s.serialize_field("parent_shared_folder_id", val)?;
        }
        if let Some(val) = &self.shared_folder_id {
            s.serialize_field("shared_folder_id", val)?;
        }
        if let Some(val) = &self.sharing_info {
            s.serialize_field("sharing_info", val)?;
        }
        if let Some(val) = &self.property_groups {
            s.serialize_field("property_groups", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FolderMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FolderMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FolderMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FolderMetadata", FOLDER_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FolderMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FolderMetadata", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sharing info for a folder which is contained in a shared folder or is a shared folder mount
/// point.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FolderSharingInfo {
    /// True if the file or folder is inside a read-only shared folder.
    pub read_only: bool,
    /// Set if the folder is contained by a shared folder.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// If this folder is a shared folder mount point, the ID of the shared folder mounted at this
    /// location.
    pub shared_folder_id: Option<super::common::SharedFolderId>,
    /// Specifies that the folder can only be traversed and the user can only see a limited subset
    /// of the contents of this folder because they don't have read access to this folder. They do,
    /// however, have access to some sub folder.
    pub traverse_only: bool,
    /// Specifies that the folder cannot be accessed by the user.
    pub no_access: bool,
}

impl FolderSharingInfo {
    pub fn new(read_only: bool) -> Self {
        FolderSharingInfo {
            read_only,
            parent_shared_folder_id: None,
            shared_folder_id: None,
            traverse_only: false,
            no_access: false,
        }
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.shared_folder_id = Some(value);
        self
    }

    pub fn with_traverse_only(mut self, value: bool) -> Self {
        self.traverse_only = value;
        self
    }

    pub fn with_no_access(mut self, value: bool) -> Self {
        self.no_access = value;
        self
    }
}

const FOLDER_SHARING_INFO_FIELDS: &[&str] = &["read_only",
                                              "parent_shared_folder_id",
                                              "shared_folder_id",
                                              "traverse_only",
                                              "no_access"];
impl FolderSharingInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FolderSharingInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FolderSharingInfo>, V::Error> {
        let mut field_read_only = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_shared_folder_id = None;
        let mut field_traverse_only = None;
        let mut field_no_access = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "read_only" => {
                    if field_read_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("read_only"));
                    }
                    field_read_only = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "traverse_only" => {
                    if field_traverse_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("traverse_only"));
                    }
                    field_traverse_only = Some(map.next_value()?);
                }
                "no_access" => {
                    if field_no_access.is_some() {
                        return Err(::serde::de::Error::duplicate_field("no_access"));
                    }
                    field_no_access = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FolderSharingInfo {
            read_only: field_read_only.ok_or_else(|| ::serde::de::Error::missing_field("read_only"))?,
            parent_shared_folder_id: field_parent_shared_folder_id,
            shared_folder_id: field_shared_folder_id,
            traverse_only: field_traverse_only.unwrap_or(false),
            no_access: field_no_access.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("read_only", &self.read_only)?;
        if let Some(val) = &self.parent_shared_folder_id {
            s.serialize_field("parent_shared_folder_id", val)?;
        }
        if let Some(val) = &self.shared_folder_id {
            s.serialize_field("shared_folder_id", val)?;
        }
        s.serialize_field("traverse_only", &self.traverse_only)?;
        s.serialize_field("no_access", &self.no_access)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FolderSharingInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FolderSharingInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderSharingInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FolderSharingInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FolderSharingInfo", FOLDER_SHARING_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FolderSharingInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FolderSharingInfo", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetCopyReferenceArg {
    /// The path to the file or folder you want to get a copy reference to.
    pub path: ReadPath,
}

impl GetCopyReferenceArg {
    pub fn new(path: ReadPath) -> Self {
        GetCopyReferenceArg {
            path,
        }
    }
}

const GET_COPY_REFERENCE_ARG_FIELDS: &[&str] = &["path"];
impl GetCopyReferenceArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetCopyReferenceArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetCopyReferenceArg>, V::Error> {
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetCopyReferenceArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetCopyReferenceArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetCopyReferenceArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetCopyReferenceArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetCopyReferenceArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetCopyReferenceArg", GET_COPY_REFERENCE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetCopyReferenceArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetCopyReferenceArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetCopyReferenceError {
    Path(LookupError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetCopyReferenceError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetCopyReferenceError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetCopyReferenceError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => GetCopyReferenceError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetCopyReferenceError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "other"];
        deserializer.deserialize_struct("GetCopyReferenceError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetCopyReferenceError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetCopyReferenceError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetCopyReferenceError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            GetCopyReferenceError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetCopyReferenceError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            GetCopyReferenceError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for GetCopyReferenceError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetCopyReferenceError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetCopyReferenceResult {
    /// Metadata of the file or folder.
    pub metadata: Metadata,
    /// A copy reference to the file or folder.
    pub copy_reference: String,
    /// The expiration date of the copy reference. This value is currently set to be far enough in
    /// the future so that expiration is effectively not an issue.
    pub expires: super::common::DropboxTimestamp,
}

impl GetCopyReferenceResult {
    pub fn new(
        metadata: Metadata,
        copy_reference: String,
        expires: super::common::DropboxTimestamp,
    ) -> Self {
        GetCopyReferenceResult {
            metadata,
            copy_reference,
            expires,
        }
    }
}

const GET_COPY_REFERENCE_RESULT_FIELDS: &[&str] = &["metadata",
                                                    "copy_reference",
                                                    "expires"];
impl GetCopyReferenceResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetCopyReferenceResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetCopyReferenceResult>, V::Error> {
        let mut field_metadata = None;
        let mut field_copy_reference = None;
        let mut field_expires = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                "copy_reference" => {
                    if field_copy_reference.is_some() {
                        return Err(::serde::de::Error::duplicate_field("copy_reference"));
                    }
                    field_copy_reference = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetCopyReferenceResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
            copy_reference: field_copy_reference.ok_or_else(|| ::serde::de::Error::missing_field("copy_reference"))?,
            expires: field_expires.ok_or_else(|| ::serde::de::Error::missing_field("expires"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        s.serialize_field("copy_reference", &self.copy_reference)?;
        s.serialize_field("expires", &self.expires)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetCopyReferenceResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetCopyReferenceResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetCopyReferenceResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetCopyReferenceResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetCopyReferenceResult", GET_COPY_REFERENCE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetCopyReferenceResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetCopyReferenceResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetMetadataArg {
    /// The path of a file or folder on Dropbox.
    pub path: ReadPath,
    /// If true, [`FileMetadata::media_info`](FileMetadata) is set for photo and video.
    pub include_media_info: bool,
    /// If true, [`DeletedMetadata`](DeletedMetadata) will be returned for deleted file or folder,
    /// otherwise [`LookupError::NotFound`](LookupError::NotFound) will be returned.
    pub include_deleted: bool,
    /// If true, the results will include a flag for each file indicating whether or not  that file
    /// has any explicit members.
    pub include_has_explicit_shared_members: bool,
    /// If set to a valid list of template IDs, [`FileMetadata::property_groups`](FileMetadata) is
    /// set if there exists property data associated with the file and each of the listed templates.
    pub include_property_groups: Option<super::file_properties::TemplateFilterBase>,
}

impl GetMetadataArg {
    pub fn new(path: ReadPath) -> Self {
        GetMetadataArg {
            path,
            include_media_info: false,
            include_deleted: false,
            include_has_explicit_shared_members: false,
            include_property_groups: None,
        }
    }

    pub fn with_include_media_info(mut self, value: bool) -> Self {
        self.include_media_info = value;
        self
    }

    pub fn with_include_deleted(mut self, value: bool) -> Self {
        self.include_deleted = value;
        self
    }

    pub fn with_include_has_explicit_shared_members(mut self, value: bool) -> Self {
        self.include_has_explicit_shared_members = value;
        self
    }

    pub fn with_include_property_groups(
        mut self,
        value: super::file_properties::TemplateFilterBase,
    ) -> Self {
        self.include_property_groups = Some(value);
        self
    }
}

const GET_METADATA_ARG_FIELDS: &[&str] = &["path",
                                           "include_media_info",
                                           "include_deleted",
                                           "include_has_explicit_shared_members",
                                           "include_property_groups"];
impl GetMetadataArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetMetadataArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetMetadataArg>, V::Error> {
        let mut field_path = None;
        let mut field_include_media_info = None;
        let mut field_include_deleted = None;
        let mut field_include_has_explicit_shared_members = None;
        let mut field_include_property_groups = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "include_media_info" => {
                    if field_include_media_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_media_info"));
                    }
                    field_include_media_info = Some(map.next_value()?);
                }
                "include_deleted" => {
                    if field_include_deleted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_deleted"));
                    }
                    field_include_deleted = Some(map.next_value()?);
                }
                "include_has_explicit_shared_members" => {
                    if field_include_has_explicit_shared_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_has_explicit_shared_members"));
                    }
                    field_include_has_explicit_shared_members = Some(map.next_value()?);
                }
                "include_property_groups" => {
                    if field_include_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_property_groups"));
                    }
                    field_include_property_groups = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetMetadataArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            include_media_info: field_include_media_info.unwrap_or(false),
            include_deleted: field_include_deleted.unwrap_or(false),
            include_has_explicit_shared_members: field_include_has_explicit_shared_members.unwrap_or(false),
            include_property_groups: field_include_property_groups,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("include_media_info", &self.include_media_info)?;
        s.serialize_field("include_deleted", &self.include_deleted)?;
        s.serialize_field("include_has_explicit_shared_members", &self.include_has_explicit_shared_members)?;
        if let Some(val) = &self.include_property_groups {
            s.serialize_field("include_property_groups", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetMetadataArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetMetadataArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetMetadataArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetMetadataArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetMetadataArg", GET_METADATA_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetMetadataArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetMetadataArg", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum GetMetadataError {
    Path(LookupError),
}

impl<'de> ::serde::de::Deserialize<'de> for GetMetadataError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetMetadataError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetMetadataError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => GetMetadataError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path"];
        deserializer.deserialize_struct("GetMetadataError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetMetadataError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetMetadataError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetMetadataError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for GetMetadataError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            GetMetadataError::Path(inner) => Some(inner),
        }
    }
}

impl ::std::fmt::Display for GetMetadataError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetMetadataError::Path(inner) => write!(f, "{}", inner),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetTemporaryLinkArg {
    /// The path to the file you want a temporary link to.
    pub path: ReadPath,
}

impl GetTemporaryLinkArg {
    pub fn new(path: ReadPath) -> Self {
        GetTemporaryLinkArg {
            path,
        }
    }
}

const GET_TEMPORARY_LINK_ARG_FIELDS: &[&str] = &["path"];
impl GetTemporaryLinkArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetTemporaryLinkArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetTemporaryLinkArg>, V::Error> {
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetTemporaryLinkArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetTemporaryLinkArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetTemporaryLinkArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetTemporaryLinkArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetTemporaryLinkArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetTemporaryLinkArg", GET_TEMPORARY_LINK_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetTemporaryLinkArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetTemporaryLinkArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetTemporaryLinkError {
    Path(LookupError),
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailNotVerified,
    /// Cannot get temporary link to this file type; use [`export()`](export) instead.
    UnsupportedFile,
    /// The user is not allowed to request a temporary link to the specified file. For example, this
    /// can occur if the file is restricted or if the user's links are
    /// [banned](https://help.dropbox.com/files-folders/share/banned-links).
    NotAllowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetTemporaryLinkError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetTemporaryLinkError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetTemporaryLinkError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => GetTemporaryLinkError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "email_not_verified" => GetTemporaryLinkError::EmailNotVerified,
                    "unsupported_file" => GetTemporaryLinkError::UnsupportedFile,
                    "not_allowed" => GetTemporaryLinkError::NotAllowed,
                    _ => GetTemporaryLinkError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "email_not_verified",
                                    "unsupported_file",
                                    "not_allowed",
                                    "other"];
        deserializer.deserialize_struct("GetTemporaryLinkError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetTemporaryLinkError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetTemporaryLinkError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetTemporaryLinkError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            GetTemporaryLinkError::EmailNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("GetTemporaryLinkError", 1)?;
                s.serialize_field(".tag", "email_not_verified")?;
                s.end()
            }
            GetTemporaryLinkError::UnsupportedFile => {
                // unit
                let mut s = serializer.serialize_struct("GetTemporaryLinkError", 1)?;
                s.serialize_field(".tag", "unsupported_file")?;
                s.end()
            }
            GetTemporaryLinkError::NotAllowed => {
                // unit
                let mut s = serializer.serialize_struct("GetTemporaryLinkError", 1)?;
                s.serialize_field(".tag", "not_allowed")?;
                s.end()
            }
            GetTemporaryLinkError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetTemporaryLinkError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            GetTemporaryLinkError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for GetTemporaryLinkError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetTemporaryLinkError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetTemporaryLinkResult {
    /// Metadata of the file.
    pub metadata: FileMetadata,
    /// The temporary link which can be used to stream content the file.
    pub link: String,
}

impl GetTemporaryLinkResult {
    pub fn new(metadata: FileMetadata, link: String) -> Self {
        GetTemporaryLinkResult {
            metadata,
            link,
        }
    }
}

const GET_TEMPORARY_LINK_RESULT_FIELDS: &[&str] = &["metadata",
                                                    "link"];
impl GetTemporaryLinkResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetTemporaryLinkResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetTemporaryLinkResult>, V::Error> {
        let mut field_metadata = None;
        let mut field_link = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                "link" => {
                    if field_link.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link"));
                    }
                    field_link = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetTemporaryLinkResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
            link: field_link.ok_or_else(|| ::serde::de::Error::missing_field("link"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        s.serialize_field("link", &self.link)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetTemporaryLinkResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetTemporaryLinkResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetTemporaryLinkResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetTemporaryLinkResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetTemporaryLinkResult", GET_TEMPORARY_LINK_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetTemporaryLinkResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetTemporaryLinkResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetTemporaryUploadLinkArg {
    /// Contains the path and other optional modifiers for the future upload commit. Equivalent to
    /// the parameters provided to [`upload()`](upload).
    pub commit_info: CommitInfo,
    /// How long before this link expires, in seconds.  Attempting to start an upload with this link
    /// longer than this period  of time after link creation will result in an error.
    pub duration: f64,
}

impl GetTemporaryUploadLinkArg {
    pub fn new(commit_info: CommitInfo) -> Self {
        GetTemporaryUploadLinkArg {
            commit_info,
            duration: 14400.0,
        }
    }

    pub fn with_duration(mut self, value: f64) -> Self {
        self.duration = value;
        self
    }
}

const GET_TEMPORARY_UPLOAD_LINK_ARG_FIELDS: &[&str] = &["commit_info",
                                                        "duration"];
impl GetTemporaryUploadLinkArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetTemporaryUploadLinkArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetTemporaryUploadLinkArg>, V::Error> {
        let mut field_commit_info = None;
        let mut field_duration = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "commit_info" => {
                    if field_commit_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("commit_info"));
                    }
                    field_commit_info = Some(map.next_value()?);
                }
                "duration" => {
                    if field_duration.is_some() {
                        return Err(::serde::de::Error::duplicate_field("duration"));
                    }
                    field_duration = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetTemporaryUploadLinkArg {
            commit_info: field_commit_info.ok_or_else(|| ::serde::de::Error::missing_field("commit_info"))?,
            duration: field_duration.unwrap_or(14400.0),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("commit_info", &self.commit_info)?;
        s.serialize_field("duration", &self.duration)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetTemporaryUploadLinkArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetTemporaryUploadLinkArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetTemporaryUploadLinkArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetTemporaryUploadLinkArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetTemporaryUploadLinkArg", GET_TEMPORARY_UPLOAD_LINK_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetTemporaryUploadLinkArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetTemporaryUploadLinkArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetTemporaryUploadLinkResult {
    /// The temporary link which can be used to stream a file to a Dropbox location.
    pub link: String,
}

impl GetTemporaryUploadLinkResult {
    pub fn new(link: String) -> Self {
        GetTemporaryUploadLinkResult {
            link,
        }
    }
}

const GET_TEMPORARY_UPLOAD_LINK_RESULT_FIELDS: &[&str] = &["link"];
impl GetTemporaryUploadLinkResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetTemporaryUploadLinkResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetTemporaryUploadLinkResult>, V::Error> {
        let mut field_link = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "link" => {
                    if field_link.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link"));
                    }
                    field_link = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetTemporaryUploadLinkResult {
            link: field_link.ok_or_else(|| ::serde::de::Error::missing_field("link"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("link", &self.link)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetTemporaryUploadLinkResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetTemporaryUploadLinkResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetTemporaryUploadLinkResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetTemporaryUploadLinkResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetTemporaryUploadLinkResult", GET_TEMPORARY_UPLOAD_LINK_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetTemporaryUploadLinkResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetTemporaryUploadLinkResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`get_thumbnail_batch()`](get_thumbnail_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetThumbnailBatchArg {
    /// List of files to get thumbnails.
    pub entries: Vec<ThumbnailArg>,
}

impl GetThumbnailBatchArg {
    pub fn new(entries: Vec<ThumbnailArg>) -> Self {
        GetThumbnailBatchArg {
            entries,
        }
    }
}

const GET_THUMBNAIL_BATCH_ARG_FIELDS: &[&str] = &["entries"];
impl GetThumbnailBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetThumbnailBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetThumbnailBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetThumbnailBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetThumbnailBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetThumbnailBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetThumbnailBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetThumbnailBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetThumbnailBatchArg", GET_THUMBNAIL_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetThumbnailBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetThumbnailBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetThumbnailBatchError {
    /// The operation involves more than 25 files.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetThumbnailBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetThumbnailBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetThumbnailBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "too_many_files" => GetThumbnailBatchError::TooManyFiles,
                    _ => GetThumbnailBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["too_many_files",
                                    "other"];
        deserializer.deserialize_struct("GetThumbnailBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetThumbnailBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetThumbnailBatchError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("GetThumbnailBatchError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            GetThumbnailBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetThumbnailBatchError {
}

impl ::std::fmt::Display for GetThumbnailBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetThumbnailBatchError::TooManyFiles => f.write_str("The operation involves more than 25 files."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetThumbnailBatchResult {
    /// List of files and their thumbnails.
    pub entries: Vec<GetThumbnailBatchResultEntry>,
}

impl GetThumbnailBatchResult {
    pub fn new(entries: Vec<GetThumbnailBatchResultEntry>) -> Self {
        GetThumbnailBatchResult {
            entries,
        }
    }
}

const GET_THUMBNAIL_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl GetThumbnailBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetThumbnailBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetThumbnailBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetThumbnailBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetThumbnailBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetThumbnailBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetThumbnailBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetThumbnailBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetThumbnailBatchResult", GET_THUMBNAIL_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetThumbnailBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetThumbnailBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetThumbnailBatchResultData {
    pub metadata: FileMetadata,
    /// A string containing the base64-encoded thumbnail data for this file.
    pub thumbnail: String,
}

impl GetThumbnailBatchResultData {
    pub fn new(metadata: FileMetadata, thumbnail: String) -> Self {
        GetThumbnailBatchResultData {
            metadata,
            thumbnail,
        }
    }
}

const GET_THUMBNAIL_BATCH_RESULT_DATA_FIELDS: &[&str] = &["metadata",
                                                          "thumbnail"];
impl GetThumbnailBatchResultData {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetThumbnailBatchResultData, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetThumbnailBatchResultData>, V::Error> {
        let mut field_metadata = None;
        let mut field_thumbnail = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                "thumbnail" => {
                    if field_thumbnail.is_some() {
                        return Err(::serde::de::Error::duplicate_field("thumbnail"));
                    }
                    field_thumbnail = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetThumbnailBatchResultData {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
            thumbnail: field_thumbnail.ok_or_else(|| ::serde::de::Error::missing_field("thumbnail"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        s.serialize_field("thumbnail", &self.thumbnail)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetThumbnailBatchResultData {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetThumbnailBatchResultData;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetThumbnailBatchResultData struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetThumbnailBatchResultData::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetThumbnailBatchResultData", GET_THUMBNAIL_BATCH_RESULT_DATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetThumbnailBatchResultData {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetThumbnailBatchResultData", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetThumbnailBatchResultEntry {
    Success(GetThumbnailBatchResultData),
    /// The result for this file if it was an error.
    Failure(ThumbnailError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetThumbnailBatchResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetThumbnailBatchResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetThumbnailBatchResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => GetThumbnailBatchResultEntry::Success(GetThumbnailBatchResultData::internal_deserialize(&mut map)?),
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => GetThumbnailBatchResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetThumbnailBatchResultEntry::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure",
                                    "other"];
        deserializer.deserialize_struct("GetThumbnailBatchResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetThumbnailBatchResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetThumbnailBatchResultEntry::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("GetThumbnailBatchResultEntry", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            GetThumbnailBatchResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetThumbnailBatchResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
            GetThumbnailBatchResultEntry::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// GPS coordinates for a photo or video.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GpsCoordinates {
    /// Latitude of the GPS coordinates.
    pub latitude: f64,
    /// Longitude of the GPS coordinates.
    pub longitude: f64,
}

impl GpsCoordinates {
    pub fn new(latitude: f64, longitude: f64) -> Self {
        GpsCoordinates {
            latitude,
            longitude,
        }
    }
}

const GPS_COORDINATES_FIELDS: &[&str] = &["latitude",
                                          "longitude"];
impl GpsCoordinates {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GpsCoordinates, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GpsCoordinates>, V::Error> {
        let mut field_latitude = None;
        let mut field_longitude = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "latitude" => {
                    if field_latitude.is_some() {
                        return Err(::serde::de::Error::duplicate_field("latitude"));
                    }
                    field_latitude = Some(map.next_value()?);
                }
                "longitude" => {
                    if field_longitude.is_some() {
                        return Err(::serde::de::Error::duplicate_field("longitude"));
                    }
                    field_longitude = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GpsCoordinates {
            latitude: field_latitude.ok_or_else(|| ::serde::de::Error::missing_field("latitude"))?,
            longitude: field_longitude.ok_or_else(|| ::serde::de::Error::missing_field("longitude"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("latitude", &self.latitude)?;
        s.serialize_field("longitude", &self.longitude)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GpsCoordinates {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GpsCoordinates;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GpsCoordinates struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GpsCoordinates::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GpsCoordinates", GPS_COORDINATES_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GpsCoordinates {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GpsCoordinates", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct HighlightSpan {
    /// String to be determined whether it should be highlighted or not.
    pub highlight_str: String,
    /// The string should be highlighted or not.
    pub is_highlighted: bool,
}

impl HighlightSpan {
    pub fn new(highlight_str: String, is_highlighted: bool) -> Self {
        HighlightSpan {
            highlight_str,
            is_highlighted,
        }
    }
}

const HIGHLIGHT_SPAN_FIELDS: &[&str] = &["highlight_str",
                                         "is_highlighted"];
impl HighlightSpan {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<HighlightSpan, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<HighlightSpan>, V::Error> {
        let mut field_highlight_str = None;
        let mut field_is_highlighted = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "highlight_str" => {
                    if field_highlight_str.is_some() {
                        return Err(::serde::de::Error::duplicate_field("highlight_str"));
                    }
                    field_highlight_str = Some(map.next_value()?);
                }
                "is_highlighted" => {
                    if field_is_highlighted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_highlighted"));
                    }
                    field_is_highlighted = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = HighlightSpan {
            highlight_str: field_highlight_str.ok_or_else(|| ::serde::de::Error::missing_field("highlight_str"))?,
            is_highlighted: field_is_highlighted.ok_or_else(|| ::serde::de::Error::missing_field("is_highlighted"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("highlight_str", &self.highlight_str)?;
        s.serialize_field("is_highlighted", &self.is_highlighted)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for HighlightSpan {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = HighlightSpan;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a HighlightSpan struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                HighlightSpan::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("HighlightSpan", HIGHLIGHT_SPAN_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for HighlightSpan {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("HighlightSpan", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The import format of the incoming Paper doc content.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ImportFormat {
    /// The provided data is interpreted as standard HTML.
    Html,
    /// The provided data is interpreted as markdown.
    Markdown,
    /// The provided data is interpreted as plain text.
    PlainText,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ImportFormat {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ImportFormat;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ImportFormat structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "html" => ImportFormat::Html,
                    "markdown" => ImportFormat::Markdown,
                    "plain_text" => ImportFormat::PlainText,
                    _ => ImportFormat::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["html",
                                    "markdown",
                                    "plain_text",
                                    "other"];
        deserializer.deserialize_struct("ImportFormat", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ImportFormat {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ImportFormat::Html => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "html")?;
                s.end()
            }
            ImportFormat::Markdown => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "markdown")?;
                s.end()
            }
            ImportFormat::PlainText => {
                // unit
                let mut s = serializer.serialize_struct("ImportFormat", 1)?;
                s.serialize_field(".tag", "plain_text")?;
                s.end()
            }
            ImportFormat::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderArg {
    /// A unique identifier for the file.
    pub path: PathROrId,
    /// If true, the list folder operation will be applied recursively to all subfolders and the
    /// response will contain contents of all subfolders.
    pub recursive: bool,
    /// If true, [`FileMetadata::media_info`](FileMetadata) is set for photo and video. This
    /// parameter will no longer have an effect starting December 2, 2019.
    pub include_media_info: bool,
    /// If true, the results will include entries for files and folders that used to exist but were
    /// deleted.
    pub include_deleted: bool,
    /// If true, the results will include a flag for each file indicating whether or not  that file
    /// has any explicit members.
    pub include_has_explicit_shared_members: bool,
    /// If true, the results will include entries under mounted folders which includes app folder,
    /// shared folder and team folder.
    pub include_mounted_folders: bool,
    /// The maximum number of results to return per request. Note: This is an approximate number and
    /// there can be slightly more entries returned in some cases.
    pub limit: Option<u32>,
    /// A shared link to list the contents of. If the link is password-protected, the password must
    /// be provided. If this field is present, [`ListFolderArg::path`](ListFolderArg) will be
    /// relative to root of the shared link. Only non-recursive mode is supported for shared link.
    pub shared_link: Option<SharedLink>,
    /// If set to a valid list of template IDs, [`FileMetadata::property_groups`](FileMetadata) is
    /// set if there exists property data associated with the file and each of the listed templates.
    pub include_property_groups: Option<super::file_properties::TemplateFilterBase>,
    /// If true, include files that are not downloadable, i.e. Google Docs.
    pub include_non_downloadable_files: bool,
}

impl ListFolderArg {
    pub fn new(path: PathROrId) -> Self {
        ListFolderArg {
            path,
            recursive: false,
            include_media_info: false,
            include_deleted: false,
            include_has_explicit_shared_members: false,
            include_mounted_folders: true,
            limit: None,
            shared_link: None,
            include_property_groups: None,
            include_non_downloadable_files: true,
        }
    }

    pub fn with_recursive(mut self, value: bool) -> Self {
        self.recursive = value;
        self
    }

    pub fn with_include_media_info(mut self, value: bool) -> Self {
        self.include_media_info = value;
        self
    }

    pub fn with_include_deleted(mut self, value: bool) -> Self {
        self.include_deleted = value;
        self
    }

    pub fn with_include_has_explicit_shared_members(mut self, value: bool) -> Self {
        self.include_has_explicit_shared_members = value;
        self
    }

    pub fn with_include_mounted_folders(mut self, value: bool) -> Self {
        self.include_mounted_folders = value;
        self
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = Some(value);
        self
    }

    pub fn with_shared_link(mut self, value: SharedLink) -> Self {
        self.shared_link = Some(value);
        self
    }

    pub fn with_include_property_groups(
        mut self,
        value: super::file_properties::TemplateFilterBase,
    ) -> Self {
        self.include_property_groups = Some(value);
        self
    }

    pub fn with_include_non_downloadable_files(mut self, value: bool) -> Self {
        self.include_non_downloadable_files = value;
        self
    }
}

const LIST_FOLDER_ARG_FIELDS: &[&str] = &["path",
                                          "recursive",
                                          "include_media_info",
                                          "include_deleted",
                                          "include_has_explicit_shared_members",
                                          "include_mounted_folders",
                                          "limit",
                                          "shared_link",
                                          "include_property_groups",
                                          "include_non_downloadable_files"];
impl ListFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderArg>, V::Error> {
        let mut field_path = None;
        let mut field_recursive = None;
        let mut field_include_media_info = None;
        let mut field_include_deleted = None;
        let mut field_include_has_explicit_shared_members = None;
        let mut field_include_mounted_folders = None;
        let mut field_limit = None;
        let mut field_shared_link = None;
        let mut field_include_property_groups = None;
        let mut field_include_non_downloadable_files = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "recursive" => {
                    if field_recursive.is_some() {
                        return Err(::serde::de::Error::duplicate_field("recursive"));
                    }
                    field_recursive = Some(map.next_value()?);
                }
                "include_media_info" => {
                    if field_include_media_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_media_info"));
                    }
                    field_include_media_info = Some(map.next_value()?);
                }
                "include_deleted" => {
                    if field_include_deleted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_deleted"));
                    }
                    field_include_deleted = Some(map.next_value()?);
                }
                "include_has_explicit_shared_members" => {
                    if field_include_has_explicit_shared_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_has_explicit_shared_members"));
                    }
                    field_include_has_explicit_shared_members = Some(map.next_value()?);
                }
                "include_mounted_folders" => {
                    if field_include_mounted_folders.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_mounted_folders"));
                    }
                    field_include_mounted_folders = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                "shared_link" => {
                    if field_shared_link.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link"));
                    }
                    field_shared_link = Some(map.next_value()?);
                }
                "include_property_groups" => {
                    if field_include_property_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_property_groups"));
                    }
                    field_include_property_groups = Some(map.next_value()?);
                }
                "include_non_downloadable_files" => {
                    if field_include_non_downloadable_files.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_non_downloadable_files"));
                    }
                    field_include_non_downloadable_files = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            recursive: field_recursive.unwrap_or(false),
            include_media_info: field_include_media_info.unwrap_or(false),
            include_deleted: field_include_deleted.unwrap_or(false),
            include_has_explicit_shared_members: field_include_has_explicit_shared_members.unwrap_or(false),
            include_mounted_folders: field_include_mounted_folders.unwrap_or(true),
            limit: field_limit,
            shared_link: field_shared_link,
            include_property_groups: field_include_property_groups,
            include_non_downloadable_files: field_include_non_downloadable_files.unwrap_or(true),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("recursive", &self.recursive)?;
        s.serialize_field("include_media_info", &self.include_media_info)?;
        s.serialize_field("include_deleted", &self.include_deleted)?;
        s.serialize_field("include_has_explicit_shared_members", &self.include_has_explicit_shared_members)?;
        s.serialize_field("include_mounted_folders", &self.include_mounted_folders)?;
        if let Some(val) = &self.limit {
            s.serialize_field("limit", val)?;
        }
        if let Some(val) = &self.shared_link {
            s.serialize_field("shared_link", val)?;
        }
        if let Some(val) = &self.include_property_groups {
            s.serialize_field("include_property_groups", val)?;
        }
        s.serialize_field("include_non_downloadable_files", &self.include_non_downloadable_files)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderArg", LIST_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderArg", 10)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderContinueArg {
    /// The cursor returned by your last call to [`list_folder()`](list_folder) or
    /// [`list_folder_continue()`](list_folder_continue).
    pub cursor: ListFolderCursor,
}

impl ListFolderContinueArg {
    pub fn new(cursor: ListFolderCursor) -> Self {
        ListFolderContinueArg {
            cursor,
        }
    }
}

const LIST_FOLDER_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFolderContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderContinueArg", LIST_FOLDER_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFolderContinueError {
    Path(LookupError),
    /// Indicates that the cursor has been invalidated. Call [`list_folder()`](list_folder) to
    /// obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFolderContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ListFolderContinueError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "reset" => ListFolderContinueError::Reset,
                    _ => ListFolderContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "reset",
                                    "other"];
        deserializer.deserialize_struct("ListFolderContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFolderContinueError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFolderContinueError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ListFolderContinueError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListFolderContinueError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListFolderContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFolderContinueError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFolderContinueError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFolderContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFolderContinueError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFolderError {
    Path(LookupError),
    TemplateError(super::file_properties::TemplateError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ListFolderError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "template_error" => {
                        match map.next_key()? {
                            Some("template_error") => ListFolderError::TemplateError(map.next_value()?),
                            None => return Err(de::Error::missing_field("template_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "template_error",
                                    "other"];
        deserializer.deserialize_struct("ListFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFolderError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFolderError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ListFolderError::TemplateError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFolderError", 2)?;
                s.serialize_field(".tag", "template_error")?;
                s.serialize_field("template_error", x)?;
                s.end()
            }
            ListFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFolderError::Path(inner) => Some(inner),
            ListFolderError::TemplateError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFolderError::Path(inner) => write!(f, "{}", inner),
            ListFolderError::TemplateError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderGetLatestCursorResult {
    /// Pass the cursor into [`list_folder_continue()`](list_folder_continue) to see what's changed
    /// in the folder since your previous query.
    pub cursor: ListFolderCursor,
}

impl ListFolderGetLatestCursorResult {
    pub fn new(cursor: ListFolderCursor) -> Self {
        ListFolderGetLatestCursorResult {
            cursor,
        }
    }
}

const LIST_FOLDER_GET_LATEST_CURSOR_RESULT_FIELDS: &[&str] = &["cursor"];
impl ListFolderGetLatestCursorResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderGetLatestCursorResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderGetLatestCursorResult>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderGetLatestCursorResult {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderGetLatestCursorResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderGetLatestCursorResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderGetLatestCursorResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderGetLatestCursorResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderGetLatestCursorResult", LIST_FOLDER_GET_LATEST_CURSOR_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderGetLatestCursorResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderGetLatestCursorResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderLongpollArg {
    /// A cursor as returned by [`list_folder()`](list_folder) or
    /// [`list_folder_continue()`](list_folder_continue). Cursors retrieved by setting
    /// [`ListFolderArg::include_media_info`](ListFolderArg) to `true` are not supported.
    pub cursor: ListFolderCursor,
    /// A timeout in seconds. The request will block for at most this length of time, plus up to 90
    /// seconds of random jitter added to avoid the thundering herd problem. Care should be taken
    /// when using this parameter, as some network infrastructure does not support long timeouts.
    pub timeout: u64,
}

impl ListFolderLongpollArg {
    pub fn new(cursor: ListFolderCursor) -> Self {
        ListFolderLongpollArg {
            cursor,
            timeout: 30,
        }
    }

    pub fn with_timeout(mut self, value: u64) -> Self {
        self.timeout = value;
        self
    }
}

const LIST_FOLDER_LONGPOLL_ARG_FIELDS: &[&str] = &["cursor",
                                                   "timeout"];
impl ListFolderLongpollArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderLongpollArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderLongpollArg>, V::Error> {
        let mut field_cursor = None;
        let mut field_timeout = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "timeout" => {
                    if field_timeout.is_some() {
                        return Err(::serde::de::Error::duplicate_field("timeout"));
                    }
                    field_timeout = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderLongpollArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            timeout: field_timeout.unwrap_or(30),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("timeout", &self.timeout)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderLongpollArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderLongpollArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderLongpollArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderLongpollArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderLongpollArg", LIST_FOLDER_LONGPOLL_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderLongpollArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderLongpollArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFolderLongpollError {
    /// Indicates that the cursor has been invalidated. Call [`list_folder()`](list_folder) to
    /// obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderLongpollError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFolderLongpollError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderLongpollError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "reset" => ListFolderLongpollError::Reset,
                    _ => ListFolderLongpollError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["reset",
                                    "other"];
        deserializer.deserialize_struct("ListFolderLongpollError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderLongpollError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFolderLongpollError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListFolderLongpollError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListFolderLongpollError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFolderLongpollError {
}

impl ::std::fmt::Display for ListFolderLongpollError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderLongpollResult {
    /// Indicates whether new changes are available. If true, call
    /// [`list_folder_continue()`](list_folder_continue) to retrieve the changes.
    pub changes: bool,
    /// If present, backoff for at least this many seconds before calling
    /// [`list_folder_longpoll()`](list_folder_longpoll) again.
    pub backoff: Option<u64>,
}

impl ListFolderLongpollResult {
    pub fn new(changes: bool) -> Self {
        ListFolderLongpollResult {
            changes,
            backoff: None,
        }
    }

    pub fn with_backoff(mut self, value: u64) -> Self {
        self.backoff = Some(value);
        self
    }
}

const LIST_FOLDER_LONGPOLL_RESULT_FIELDS: &[&str] = &["changes",
                                                      "backoff"];
impl ListFolderLongpollResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderLongpollResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderLongpollResult>, V::Error> {
        let mut field_changes = None;
        let mut field_backoff = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "changes" => {
                    if field_changes.is_some() {
                        return Err(::serde::de::Error::duplicate_field("changes"));
                    }
                    field_changes = Some(map.next_value()?);
                }
                "backoff" => {
                    if field_backoff.is_some() {
                        return Err(::serde::de::Error::duplicate_field("backoff"));
                    }
                    field_backoff = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderLongpollResult {
            changes: field_changes.ok_or_else(|| ::serde::de::Error::missing_field("changes"))?,
            backoff: field_backoff,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("changes", &self.changes)?;
        if let Some(val) = &self.backoff {
            s.serialize_field("backoff", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderLongpollResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderLongpollResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderLongpollResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderLongpollResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderLongpollResult", LIST_FOLDER_LONGPOLL_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderLongpollResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderLongpollResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderResult {
    /// The files and (direct) subfolders in the folder.
    pub entries: Vec<Metadata>,
    /// Pass the cursor into [`list_folder_continue()`](list_folder_continue) to see what's changed
    /// in the folder since your previous query.
    pub cursor: ListFolderCursor,
    /// If true, then there are more entries available. Pass the cursor to
    /// [`list_folder_continue()`](list_folder_continue) to retrieve the rest.
    pub has_more: bool,
}

impl ListFolderResult {
    pub fn new(entries: Vec<Metadata>, cursor: ListFolderCursor, has_more: bool) -> Self {
        ListFolderResult {
            entries,
            cursor,
            has_more,
        }
    }
}

const LIST_FOLDER_RESULT_FIELDS: &[&str] = &["entries",
                                             "cursor",
                                             "has_more"];
impl ListFolderResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderResult>, V::Error> {
        let mut field_entries = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderResult", LIST_FOLDER_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListRevisionsArg {
    /// The path to the file you want to see the revisions of.
    pub path: PathOrId,
    /// Determines the behavior of the API in listing the revisions for a given file path or id.
    pub mode: ListRevisionsMode,
    /// The maximum number of revision entries returned.
    pub limit: u64,
}

impl ListRevisionsArg {
    pub fn new(path: PathOrId) -> Self {
        ListRevisionsArg {
            path,
            mode: ListRevisionsMode::Path,
            limit: 10,
        }
    }

    pub fn with_mode(mut self, value: ListRevisionsMode) -> Self {
        self.mode = value;
        self
    }

    pub fn with_limit(mut self, value: u64) -> Self {
        self.limit = value;
        self
    }
}

const LIST_REVISIONS_ARG_FIELDS: &[&str] = &["path",
                                             "mode",
                                             "limit"];
impl ListRevisionsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListRevisionsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListRevisionsArg>, V::Error> {
        let mut field_path = None;
        let mut field_mode = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListRevisionsArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            mode: field_mode.unwrap_or(ListRevisionsMode::Path),
            limit: field_limit.unwrap_or(10),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("mode", &self.mode)?;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListRevisionsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListRevisionsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListRevisionsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListRevisionsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListRevisionsArg", LIST_REVISIONS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListRevisionsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListRevisionsArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListRevisionsError {
    Path(LookupError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListRevisionsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListRevisionsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListRevisionsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ListRevisionsError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListRevisionsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "other"];
        deserializer.deserialize_struct("ListRevisionsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListRevisionsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListRevisionsError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListRevisionsError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ListRevisionsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListRevisionsError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListRevisionsError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListRevisionsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListRevisionsError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListRevisionsMode {
    /// Returns revisions with the same file path as identified by the latest file entry at the
    /// given file path or id.
    Path,
    /// Returns revisions with the same file id as identified by the latest file entry at the given
    /// file path or id.
    Id,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListRevisionsMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListRevisionsMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListRevisionsMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => ListRevisionsMode::Path,
                    "id" => ListRevisionsMode::Id,
                    _ => ListRevisionsMode::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "id",
                                    "other"];
        deserializer.deserialize_struct("ListRevisionsMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListRevisionsMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListRevisionsMode::Path => {
                // unit
                let mut s = serializer.serialize_struct("ListRevisionsMode", 1)?;
                s.serialize_field(".tag", "path")?;
                s.end()
            }
            ListRevisionsMode::Id => {
                // unit
                let mut s = serializer.serialize_struct("ListRevisionsMode", 1)?;
                s.serialize_field(".tag", "id")?;
                s.end()
            }
            ListRevisionsMode::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListRevisionsResult {
    /// If the file identified by the latest revision in the response is either deleted or moved.
    pub is_deleted: bool,
    /// The revisions for the file. Only revisions that are not deleted will show up here.
    pub entries: Vec<FileMetadata>,
    /// The time of deletion if the file was deleted.
    pub server_deleted: Option<super::common::DropboxTimestamp>,
}

impl ListRevisionsResult {
    pub fn new(is_deleted: bool, entries: Vec<FileMetadata>) -> Self {
        ListRevisionsResult {
            is_deleted,
            entries,
            server_deleted: None,
        }
    }

    pub fn with_server_deleted(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.server_deleted = Some(value);
        self
    }
}

const LIST_REVISIONS_RESULT_FIELDS: &[&str] = &["is_deleted",
                                                "entries",
                                                "server_deleted"];
impl ListRevisionsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListRevisionsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListRevisionsResult>, V::Error> {
        let mut field_is_deleted = None;
        let mut field_entries = None;
        let mut field_server_deleted = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "is_deleted" => {
                    if field_is_deleted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_deleted"));
                    }
                    field_is_deleted = Some(map.next_value()?);
                }
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "server_deleted" => {
                    if field_server_deleted.is_some() {
                        return Err(::serde::de::Error::duplicate_field("server_deleted"));
                    }
                    field_server_deleted = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListRevisionsResult {
            is_deleted: field_is_deleted.ok_or_else(|| ::serde::de::Error::missing_field("is_deleted"))?,
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            server_deleted: field_server_deleted,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("is_deleted", &self.is_deleted)?;
        s.serialize_field("entries", &self.entries)?;
        if let Some(val) = &self.server_deleted {
            s.serialize_field("server_deleted", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListRevisionsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListRevisionsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListRevisionsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListRevisionsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListRevisionsResult", LIST_REVISIONS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListRevisionsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListRevisionsResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LockConflictError {
    /// The lock that caused the conflict.
    pub lock: FileLock,
}

impl LockConflictError {
    pub fn new(lock: FileLock) -> Self {
        LockConflictError {
            lock,
        }
    }
}

const LOCK_CONFLICT_ERROR_FIELDS: &[&str] = &["lock"];
impl LockConflictError {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LockConflictError, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LockConflictError>, V::Error> {
        let mut field_lock = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "lock" => {
                    if field_lock.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lock"));
                    }
                    field_lock = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LockConflictError {
            lock: field_lock.ok_or_else(|| ::serde::de::Error::missing_field("lock"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("lock", &self.lock)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LockConflictError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LockConflictError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockConflictError struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LockConflictError::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LockConflictError", LOCK_CONFLICT_ERROR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LockConflictError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LockConflictError", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LockFileArg {
    /// Path in the user's Dropbox to a file.
    pub path: WritePathOrId,
}

impl LockFileArg {
    pub fn new(path: WritePathOrId) -> Self {
        LockFileArg {
            path,
        }
    }
}

const LOCK_FILE_ARG_FIELDS: &[&str] = &["path"];
impl LockFileArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LockFileArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LockFileArg>, V::Error> {
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LockFileArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LockFileArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LockFileArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LockFileArg", LOCK_FILE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LockFileArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LockFileBatchArg {
    /// List of 'entries'. Each 'entry' contains a path of the file which will be locked or queried.
    /// Duplicate path arguments in the batch are considered only once.
    pub entries: Vec<LockFileArg>,
}

impl LockFileBatchArg {
    pub fn new(entries: Vec<LockFileArg>) -> Self {
        LockFileBatchArg {
            entries,
        }
    }
}

const LOCK_FILE_BATCH_ARG_FIELDS: &[&str] = &["entries"];
impl LockFileBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LockFileBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LockFileBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LockFileBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LockFileBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LockFileBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LockFileBatchArg", LOCK_FILE_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LockFileBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LockFileBatchResult {
    /// Each Entry in the 'entries' will have '.tag' with the operation status (e.g. success), the
    /// metadata for the file and the lock state after the operation.
    pub entries: Vec<LockFileResultEntry>,
}

impl LockFileBatchResult {
    pub fn new(entries: Vec<LockFileResultEntry>) -> Self {
        LockFileBatchResult {
            entries,
        }
    }
}

const LOCK_FILE_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl LockFileBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LockFileBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LockFileBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LockFileBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LockFileBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LockFileBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LockFileBatchResult", LOCK_FILE_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LockFileBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LockFileError {
    /// Could not find the specified resource.
    PathLookup(LookupError),
    /// There are too many write operations in user's Dropbox. Please retry this request.
    TooManyWriteOperations,
    /// There are too many files in one request. Please retry with fewer files.
    TooManyFiles,
    /// The user does not have permissions to change the lock state or access the file.
    NoWritePermission,
    /// Item is a type that cannot be locked.
    CannotBeLocked,
    /// Requested file is not currently shared.
    FileNotShared,
    /// The user action conflicts with an existing lock on the file.
    LockConflict(LockConflictError),
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LockFileError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path_lookup" => {
                        match map.next_key()? {
                            Some("path_lookup") => LockFileError::PathLookup(map.next_value()?),
                            None => return Err(de::Error::missing_field("path_lookup")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_write_operations" => LockFileError::TooManyWriteOperations,
                    "too_many_files" => LockFileError::TooManyFiles,
                    "no_write_permission" => LockFileError::NoWritePermission,
                    "cannot_be_locked" => LockFileError::CannotBeLocked,
                    "file_not_shared" => LockFileError::FileNotShared,
                    "lock_conflict" => LockFileError::LockConflict(LockConflictError::internal_deserialize(&mut map)?),
                    "internal_error" => LockFileError::InternalError,
                    _ => LockFileError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path_lookup",
                                    "too_many_write_operations",
                                    "too_many_files",
                                    "no_write_permission",
                                    "cannot_be_locked",
                                    "file_not_shared",
                                    "lock_conflict",
                                    "internal_error",
                                    "other"];
        deserializer.deserialize_struct("LockFileError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LockFileError::PathLookup(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("LockFileError", 2)?;
                s.serialize_field(".tag", "path_lookup")?;
                s.serialize_field("path_lookup", x)?;
                s.end()
            }
            LockFileError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            LockFileError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            LockFileError::NoWritePermission => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "no_write_permission")?;
                s.end()
            }
            LockFileError::CannotBeLocked => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "cannot_be_locked")?;
                s.end()
            }
            LockFileError::FileNotShared => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "file_not_shared")?;
                s.end()
            }
            LockFileError::LockConflict(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("LockFileError", 2)?;
                s.serialize_field(".tag", "lock_conflict")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            LockFileError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("LockFileError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            LockFileError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LockFileError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            LockFileError::PathLookup(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for LockFileError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LockFileError::PathLookup(inner) => write!(f, "Could not find the specified resource: {}", inner),
            LockFileError::TooManyWriteOperations => f.write_str("There are too many write operations in user's Dropbox. Please retry this request."),
            LockFileError::TooManyFiles => f.write_str("There are too many files in one request. Please retry with fewer files."),
            LockFileError::NoWritePermission => f.write_str("The user does not have permissions to change the lock state or access the file."),
            LockFileError::CannotBeLocked => f.write_str("Item is a type that cannot be locked."),
            LockFileError::FileNotShared => f.write_str("Requested file is not currently shared."),
            LockFileError::LockConflict(inner) => write!(f, "The user action conflicts with an existing lock on the file: {:?}", inner),
            LockFileError::InternalError => f.write_str("Something went wrong with the job on Dropbox's end. You'll need to verify that the action you were taking succeeded, and if not, try again. This should happen very rarely."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LockFileResult {
    /// Metadata of the file.
    pub metadata: Metadata,
    /// The file lock state after the operation.
    pub lock: FileLock,
}

impl LockFileResult {
    pub fn new(metadata: Metadata, lock: FileLock) -> Self {
        LockFileResult {
            metadata,
            lock,
        }
    }
}

const LOCK_FILE_RESULT_FIELDS: &[&str] = &["metadata",
                                           "lock"];
impl LockFileResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LockFileResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LockFileResult>, V::Error> {
        let mut field_metadata = None;
        let mut field_lock = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                "lock" => {
                    if field_lock.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lock"));
                    }
                    field_lock = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LockFileResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
            lock: field_lock.ok_or_else(|| ::serde::de::Error::missing_field("lock"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        s.serialize_field("lock", &self.lock)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LockFileResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LockFileResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LockFileResult", LOCK_FILE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LockFileResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum LockFileResultEntry {
    Success(LockFileResult),
    Failure(LockFileError),
}

impl<'de> ::serde::de::Deserialize<'de> for LockFileResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LockFileResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LockFileResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => LockFileResultEntry::Success(LockFileResult::internal_deserialize(&mut map)?),
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => LockFileResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure"];
        deserializer.deserialize_struct("LockFileResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LockFileResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LockFileResultEntry::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("LockFileResultEntry", 3)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            LockFileResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("LockFileResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LookupError {
    /// The given path does not satisfy the required path format. Please refer to the [Path formats
    /// documentation](https://www.dropbox.com/developers/documentation/http/documentation#path-formats)
    /// for more information.
    MalformedPath(MalformedPathError),
    /// There is nothing at the given path.
    NotFound,
    /// We were expecting a file, but the given path refers to something that isn't a file.
    NotFile,
    /// We were expecting a folder, but the given path refers to something that isn't a folder.
    NotFolder,
    /// The file cannot be transferred because the content is restricted.  For example, sometimes
    /// there are legal restrictions due to copyright claims.
    RestrictedContent,
    /// This operation is not supported for this content type.
    UnsupportedContentType,
    /// The given path is locked.
    Locked,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LookupError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LookupError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LookupError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "malformed_path" => {
                        match map.next_key()? {
                            Some("malformed_path") => LookupError::MalformedPath(map.next_value()?),
                            None => LookupError::MalformedPath(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "not_found" => LookupError::NotFound,
                    "not_file" => LookupError::NotFile,
                    "not_folder" => LookupError::NotFolder,
                    "restricted_content" => LookupError::RestrictedContent,
                    "unsupported_content_type" => LookupError::UnsupportedContentType,
                    "locked" => LookupError::Locked,
                    _ => LookupError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["malformed_path",
                                    "not_found",
                                    "not_file",
                                    "not_folder",
                                    "restricted_content",
                                    "unsupported_content_type",
                                    "locked",
                                    "other"];
        deserializer.deserialize_struct("LookupError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LookupError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LookupError::MalformedPath(ref x) => {
                // nullable (struct or primitive)
                let n = if x.is_some() { 2 } else { 1 };
                let mut s = serializer.serialize_struct("LookupError", n)?;
                s.serialize_field(".tag", "malformed_path")?;
                if let Some(ref x) = x {
                    s.serialize_field("malformed_path", &x)?;
                }
                s.end()
            }
            LookupError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            LookupError::NotFile => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "not_file")?;
                s.end()
            }
            LookupError::NotFolder => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "not_folder")?;
                s.end()
            }
            LookupError::RestrictedContent => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "restricted_content")?;
                s.end()
            }
            LookupError::UnsupportedContentType => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "unsupported_content_type")?;
                s.end()
            }
            LookupError::Locked => {
                // unit
                let mut s = serializer.serialize_struct("LookupError", 1)?;
                s.serialize_field(".tag", "locked")?;
                s.end()
            }
            LookupError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for LookupError {
}

impl ::std::fmt::Display for LookupError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            LookupError::MalformedPath(inner) => write!(f, "malformed_path: {:?}", inner),
            LookupError::NotFound => f.write_str("There is nothing at the given path."),
            LookupError::NotFile => f.write_str("We were expecting a file, but the given path refers to something that isn't a file."),
            LookupError::NotFolder => f.write_str("We were expecting a folder, but the given path refers to something that isn't a folder."),
            LookupError::RestrictedContent => f.write_str("The file cannot be transferred because the content is restricted.  For example, sometimes there are legal restrictions due to copyright claims."),
            LookupError::UnsupportedContentType => f.write_str("This operation is not supported for this content type."),
            LookupError::Locked => f.write_str("The given path is locked."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum MediaInfo {
    /// Indicate the photo/video is still under processing and metadata is not available yet.
    Pending,
    /// The metadata for the photo/video.
    Metadata(MediaMetadata),
}

impl<'de> ::serde::de::Deserialize<'de> for MediaInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MediaInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MediaInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "pending" => MediaInfo::Pending,
                    "metadata" => {
                        match map.next_key()? {
                            Some("metadata") => MediaInfo::Metadata(map.next_value()?),
                            None => return Err(de::Error::missing_field("metadata")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["pending",
                                    "metadata"];
        deserializer.deserialize_struct("MediaInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MediaInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MediaInfo::Pending => {
                // unit
                let mut s = serializer.serialize_struct("MediaInfo", 1)?;
                s.serialize_field(".tag", "pending")?;
                s.end()
            }
            MediaInfo::Metadata(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("MediaInfo", 2)?;
                s.serialize_field(".tag", "metadata")?;
                s.serialize_field("metadata", x)?;
                s.end()
            }
        }
    }
}

/// Metadata for a photo or video.
#[derive(Debug, Clone, PartialEq)]
pub enum MediaMetadata {
    Photo(PhotoMetadata),
    Video(VideoMetadata),
}

impl<'de> ::serde::de::Deserialize<'de> for MediaMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MediaMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MediaMetadata structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "photo" => Ok(MediaMetadata::Photo(PhotoMetadata::internal_deserialize(map)?)),
                    "video" => Ok(MediaMetadata::Video(VideoMetadata::internal_deserialize(map)?)),
                    _ => Err(de::Error::unknown_variant(tag, VARIANTS))
                }
            }
        }
        const VARIANTS: &[&str] = &["photo",
                                    "video"];
        deserializer.deserialize_struct("MediaMetadata", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MediaMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            MediaMetadata::Photo(ref x) => {
                let mut s = serializer.serialize_struct("MediaMetadata", 4)?;
                s.serialize_field(".tag", "photo")?;
                s.serialize_field("dimensions", &x.dimensions)?;
                s.serialize_field("location", &x.location)?;
                s.serialize_field("time_taken", &x.time_taken)?;
                s.end()
            }
            MediaMetadata::Video(ref x) => {
                let mut s = serializer.serialize_struct("MediaMetadata", 5)?;
                s.serialize_field(".tag", "video")?;
                s.serialize_field("dimensions", &x.dimensions)?;
                s.serialize_field("location", &x.location)?;
                s.serialize_field("time_taken", &x.time_taken)?;
                s.serialize_field("duration", &x.duration)?;
                s.end()
            }
        }
    }
}

/// Metadata for a file or folder.
#[derive(Debug, Clone, PartialEq)]
pub enum Metadata {
    File(FileMetadata),
    Folder(FolderMetadata),
    Deleted(DeletedMetadata),
}

impl<'de> ::serde::de::Deserialize<'de> for Metadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = Metadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Metadata structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "file" => Ok(Metadata::File(FileMetadata::internal_deserialize(map)?)),
                    "folder" => Ok(Metadata::Folder(FolderMetadata::internal_deserialize(map)?)),
                    "deleted" => Ok(Metadata::Deleted(DeletedMetadata::internal_deserialize(map)?)),
                    _ => Err(de::Error::unknown_variant(tag, VARIANTS))
                }
            }
        }
        const VARIANTS: &[&str] = &["file",
                                    "folder",
                                    "deleted"];
        deserializer.deserialize_struct("Metadata", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for Metadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            Metadata::File(ref x) => {
                let mut s = serializer.serialize_struct("Metadata", 19)?;
                s.serialize_field(".tag", "file")?;
                s.serialize_field("name", &x.name)?;
                s.serialize_field("id", &x.id)?;
                s.serialize_field("client_modified", &x.client_modified)?;
                s.serialize_field("server_modified", &x.server_modified)?;
                s.serialize_field("rev", &x.rev)?;
                s.serialize_field("size", &x.size)?;
                s.serialize_field("path_lower", &x.path_lower)?;
                s.serialize_field("path_display", &x.path_display)?;
                s.serialize_field("parent_shared_folder_id", &x.parent_shared_folder_id)?;
                s.serialize_field("media_info", &x.media_info)?;
                s.serialize_field("symlink_info", &x.symlink_info)?;
                s.serialize_field("sharing_info", &x.sharing_info)?;
                s.serialize_field("is_downloadable", &x.is_downloadable)?;
                s.serialize_field("export_info", &x.export_info)?;
                s.serialize_field("property_groups", &x.property_groups)?;
                s.serialize_field("has_explicit_shared_members", &x.has_explicit_shared_members)?;
                s.serialize_field("content_hash", &x.content_hash)?;
                s.serialize_field("file_lock_info", &x.file_lock_info)?;
                s.end()
            }
            Metadata::Folder(ref x) => {
                let mut s = serializer.serialize_struct("Metadata", 9)?;
                s.serialize_field(".tag", "folder")?;
                s.serialize_field("name", &x.name)?;
                s.serialize_field("id", &x.id)?;
                s.serialize_field("path_lower", &x.path_lower)?;
                s.serialize_field("path_display", &x.path_display)?;
                s.serialize_field("parent_shared_folder_id", &x.parent_shared_folder_id)?;
                s.serialize_field("shared_folder_id", &x.shared_folder_id)?;
                s.serialize_field("sharing_info", &x.sharing_info)?;
                s.serialize_field("property_groups", &x.property_groups)?;
                s.end()
            }
            Metadata::Deleted(ref x) => {
                let mut s = serializer.serialize_struct("Metadata", 5)?;
                s.serialize_field(".tag", "deleted")?;
                s.serialize_field("name", &x.name)?;
                s.serialize_field("path_lower", &x.path_lower)?;
                s.serialize_field("path_display", &x.path_display)?;
                s.serialize_field("parent_shared_folder_id", &x.parent_shared_folder_id)?;
                s.end()
            }
        }
    }
}

/// Metadata for a file, folder or other resource types.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MetadataV2 {
    Metadata(Metadata),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MetadataV2 {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MetadataV2;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MetadataV2 structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "metadata" => {
                        match map.next_key()? {
                            Some("metadata") => MetadataV2::Metadata(map.next_value()?),
                            None => return Err(de::Error::missing_field("metadata")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => MetadataV2::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["metadata",
                                    "other"];
        deserializer.deserialize_struct("MetadataV2", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MetadataV2 {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MetadataV2::Metadata(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("MetadataV2", 2)?;
                s.serialize_field(".tag", "metadata")?;
                s.serialize_field("metadata", x)?;
                s.end()
            }
            MetadataV2::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MinimalFileLinkMetadata {
    /// URL of the shared link.
    pub url: String,
    /// A unique identifier for the current revision of a file. This field is the same rev as
    /// elsewhere in the API and can be used to detect changes and avoid conflicts.
    pub rev: Rev,
    /// Unique identifier for the linked file.
    pub id: Option<Id>,
    /// Full path in the user's Dropbox. This always starts with a slash. This field will only be
    /// present only if the linked file is in the authenticated user's Dropbox.
    pub path: Option<String>,
}

impl MinimalFileLinkMetadata {
    pub fn new(url: String, rev: Rev) -> Self {
        MinimalFileLinkMetadata {
            url,
            rev,
            id: None,
            path: None,
        }
    }

    pub fn with_id(mut self, value: Id) -> Self {
        self.id = Some(value);
        self
    }

    pub fn with_path(mut self, value: String) -> Self {
        self.path = Some(value);
        self
    }
}

const MINIMAL_FILE_LINK_METADATA_FIELDS: &[&str] = &["url",
                                                     "rev",
                                                     "id",
                                                     "path"];
impl MinimalFileLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MinimalFileLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MinimalFileLinkMetadata>, V::Error> {
        let mut field_url = None;
        let mut field_rev = None;
        let mut field_id = None;
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MinimalFileLinkMetadata {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            rev: field_rev.ok_or_else(|| ::serde::de::Error::missing_field("rev"))?,
            id: field_id,
            path: field_path,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("rev", &self.rev)?;
        if let Some(val) = &self.id {
            s.serialize_field("id", val)?;
        }
        if let Some(val) = &self.path {
            s.serialize_field("path", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MinimalFileLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MinimalFileLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MinimalFileLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MinimalFileLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MinimalFileLinkMetadata", MINIMAL_FILE_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MinimalFileLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MinimalFileLinkMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MoveBatchArg {
    /// List of entries to be moved or copied. Each entry is [`RelocationPath`](RelocationPath).
    pub entries: Vec<RelocationPath>,
    /// If there's a conflict with any file, have the Dropbox server try to autorename that file to
    /// avoid the conflict.
    pub autorename: bool,
    /// Allow moves by owner even if it would result in an ownership transfer for the content being
    /// moved. This does not apply to copies.
    pub allow_ownership_transfer: bool,
}

impl MoveBatchArg {
    pub fn new(entries: Vec<RelocationPath>) -> Self {
        MoveBatchArg {
            entries,
            autorename: false,
            allow_ownership_transfer: false,
        }
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_allow_ownership_transfer(mut self, value: bool) -> Self {
        self.allow_ownership_transfer = value;
        self
    }
}

const MOVE_BATCH_ARG_FIELDS: &[&str] = &["entries",
                                         "autorename",
                                         "allow_ownership_transfer"];
impl MoveBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MoveBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MoveBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut field_autorename = None;
        let mut field_allow_ownership_transfer = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "allow_ownership_transfer" => {
                    if field_allow_ownership_transfer.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_ownership_transfer"));
                    }
                    field_allow_ownership_transfer = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MoveBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            autorename: field_autorename.unwrap_or(false),
            allow_ownership_transfer: field_allow_ownership_transfer.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("autorename", &self.autorename)?;
        s.serialize_field("allow_ownership_transfer", &self.allow_ownership_transfer)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MoveBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MoveBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MoveBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MoveBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MoveBatchArg", MOVE_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MoveBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MoveBatchArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MoveIntoVaultError {
    /// Moving shared folder into Vault is not allowed.
    IsSharedFolder,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MoveIntoVaultError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MoveIntoVaultError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MoveIntoVaultError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "is_shared_folder" => MoveIntoVaultError::IsSharedFolder,
                    _ => MoveIntoVaultError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["is_shared_folder",
                                    "other"];
        deserializer.deserialize_struct("MoveIntoVaultError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MoveIntoVaultError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MoveIntoVaultError::IsSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("MoveIntoVaultError", 1)?;
                s.serialize_field(".tag", "is_shared_folder")?;
                s.end()
            }
            MoveIntoVaultError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MoveIntoVaultError {
}

impl ::std::fmt::Display for MoveIntoVaultError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MoveIntoVaultError::IsSharedFolder => f.write_str("Moving shared folder into Vault is not allowed."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperContentError {
    /// Your account does not have permissions to edit Paper docs.
    InsufficientPermissions,
    /// The provided content was malformed and cannot be imported to Paper.
    ContentMalformed,
    /// The Paper doc would be too large, split the content into multiple docs.
    DocLengthExceeded,
    /// The imported document contains an image that is too large. The current limit is 1MB. This
    /// only applies to HTML with data URI.
    ImageSizeExceeded,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperContentError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperContentError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperContentError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperContentError::InsufficientPermissions,
                    "content_malformed" => PaperContentError::ContentMalformed,
                    "doc_length_exceeded" => PaperContentError::DocLengthExceeded,
                    "image_size_exceeded" => PaperContentError::ImageSizeExceeded,
                    _ => PaperContentError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "content_malformed",
                                    "doc_length_exceeded",
                                    "image_size_exceeded",
                                    "other"];
        deserializer.deserialize_struct("PaperContentError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperContentError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperContentError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperContentError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperContentError::ContentMalformed => {
                // unit
                let mut s = serializer.serialize_struct("PaperContentError", 1)?;
                s.serialize_field(".tag", "content_malformed")?;
                s.end()
            }
            PaperContentError::DocLengthExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperContentError", 1)?;
                s.serialize_field(".tag", "doc_length_exceeded")?;
                s.end()
            }
            PaperContentError::ImageSizeExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperContentError", 1)?;
                s.serialize_field(".tag", "image_size_exceeded")?;
                s.end()
            }
            PaperContentError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperContentError {
}

impl ::std::fmt::Display for PaperContentError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperContentError::InsufficientPermissions => f.write_str("Your account does not have permissions to edit Paper docs."),
            PaperContentError::ContentMalformed => f.write_str("The provided content was malformed and cannot be imported to Paper."),
            PaperContentError::DocLengthExceeded => f.write_str("The Paper doc would be too large, split the content into multiple docs."),
            PaperContentError::ImageSizeExceeded => f.write_str("The imported document contains an image that is too large. The current limit is 1MB. This only applies to HTML with data URI."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperCreateArg {
    /// The fully qualified path to the location in the user's Dropbox where the Paper Doc should be
    /// created. This should include the document's title and end with .paper.
    pub path: Path,
    /// The format of the provided data.
    pub import_format: ImportFormat,
}

impl PaperCreateArg {
    pub fn new(path: Path, import_format: ImportFormat) -> Self {
        PaperCreateArg {
            path,
            import_format,
        }
    }
}

const PAPER_CREATE_ARG_FIELDS: &[&str] = &["path",
                                           "import_format"];
impl PaperCreateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperCreateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperCreateArg>, V::Error> {
        let mut field_path = None;
        let mut field_import_format = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "import_format" => {
                    if field_import_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("import_format"));
                    }
                    field_import_format = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperCreateArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            import_format: field_import_format.ok_or_else(|| ::serde::de::Error::missing_field("import_format"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("import_format", &self.import_format)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperCreateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperCreateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperCreateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperCreateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperCreateArg", PAPER_CREATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperCreateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperCreateArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperCreateError {
    /// Your account does not have permissions to edit Paper docs.
    InsufficientPermissions,
    /// The provided content was malformed and cannot be imported to Paper.
    ContentMalformed,
    /// The Paper doc would be too large, split the content into multiple docs.
    DocLengthExceeded,
    /// The imported document contains an image that is too large. The current limit is 1MB. This
    /// only applies to HTML with data URI.
    ImageSizeExceeded,
    /// The file could not be saved to the specified location.
    InvalidPath,
    /// The user's email must be verified to create Paper docs.
    EmailUnverified,
    /// The file path must end in .paper.
    InvalidFileExtension,
    /// Paper is disabled for your team.
    PaperDisabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperCreateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperCreateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperCreateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperCreateError::InsufficientPermissions,
                    "content_malformed" => PaperCreateError::ContentMalformed,
                    "doc_length_exceeded" => PaperCreateError::DocLengthExceeded,
                    "image_size_exceeded" => PaperCreateError::ImageSizeExceeded,
                    "invalid_path" => PaperCreateError::InvalidPath,
                    "email_unverified" => PaperCreateError::EmailUnverified,
                    "invalid_file_extension" => PaperCreateError::InvalidFileExtension,
                    "paper_disabled" => PaperCreateError::PaperDisabled,
                    _ => PaperCreateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "content_malformed",
                                    "doc_length_exceeded",
                                    "image_size_exceeded",
                                    "other",
                                    "invalid_path",
                                    "email_unverified",
                                    "invalid_file_extension",
                                    "paper_disabled"];
        deserializer.deserialize_struct("PaperCreateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperCreateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperCreateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperCreateError::ContentMalformed => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "content_malformed")?;
                s.end()
            }
            PaperCreateError::DocLengthExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "doc_length_exceeded")?;
                s.end()
            }
            PaperCreateError::ImageSizeExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "image_size_exceeded")?;
                s.end()
            }
            PaperCreateError::InvalidPath => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "invalid_path")?;
                s.end()
            }
            PaperCreateError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            PaperCreateError::InvalidFileExtension => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "invalid_file_extension")?;
                s.end()
            }
            PaperCreateError::PaperDisabled => {
                // unit
                let mut s = serializer.serialize_struct("PaperCreateError", 1)?;
                s.serialize_field(".tag", "paper_disabled")?;
                s.end()
            }
            PaperCreateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperCreateError {
}

impl ::std::fmt::Display for PaperCreateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperCreateError::InsufficientPermissions => f.write_str("Your account does not have permissions to edit Paper docs."),
            PaperCreateError::ContentMalformed => f.write_str("The provided content was malformed and cannot be imported to Paper."),
            PaperCreateError::DocLengthExceeded => f.write_str("The Paper doc would be too large, split the content into multiple docs."),
            PaperCreateError::ImageSizeExceeded => f.write_str("The imported document contains an image that is too large. The current limit is 1MB. This only applies to HTML with data URI."),
            PaperCreateError::InvalidPath => f.write_str("The file could not be saved to the specified location."),
            PaperCreateError::EmailUnverified => f.write_str("The user's email must be verified to create Paper docs."),
            PaperCreateError::InvalidFileExtension => f.write_str("The file path must end in .paper."),
            PaperCreateError::PaperDisabled => f.write_str("Paper is disabled for your team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperCreateResult {
    /// URL to open the Paper Doc.
    pub url: String,
    /// The fully qualified path the Paper Doc was actually created at.
    pub result_path: String,
    /// The id to use in Dropbox APIs when referencing the Paper Doc.
    pub file_id: FileId,
    /// The current doc revision.
    pub paper_revision: i64,
}

impl PaperCreateResult {
    pub fn new(url: String, result_path: String, file_id: FileId, paper_revision: i64) -> Self {
        PaperCreateResult {
            url,
            result_path,
            file_id,
            paper_revision,
        }
    }
}

const PAPER_CREATE_RESULT_FIELDS: &[&str] = &["url",
                                              "result_path",
                                              "file_id",
                                              "paper_revision"];
impl PaperCreateResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperCreateResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperCreateResult>, V::Error> {
        let mut field_url = None;
        let mut field_result_path = None;
        let mut field_file_id = None;
        let mut field_paper_revision = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "result_path" => {
                    if field_result_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result_path"));
                    }
                    field_result_path = Some(map.next_value()?);
                }
                "file_id" => {
                    if field_file_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_id"));
                    }
                    field_file_id = Some(map.next_value()?);
                }
                "paper_revision" => {
                    if field_paper_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("paper_revision"));
                    }
                    field_paper_revision = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperCreateResult {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            result_path: field_result_path.ok_or_else(|| ::serde::de::Error::missing_field("result_path"))?,
            file_id: field_file_id.ok_or_else(|| ::serde::de::Error::missing_field("file_id"))?,
            paper_revision: field_paper_revision.ok_or_else(|| ::serde::de::Error::missing_field("paper_revision"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("result_path", &self.result_path)?;
        s.serialize_field("file_id", &self.file_id)?;
        s.serialize_field("paper_revision", &self.paper_revision)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperCreateResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperCreateResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperCreateResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperCreateResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperCreateResult", PAPER_CREATE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperCreateResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperCreateResult", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDocUpdatePolicy {
    /// Sets the doc content to the provided content if the provided paper_revision matches the
    /// latest doc revision. Otherwise, returns an error.
    Update,
    /// Sets the doc content to the provided content without checking paper_revision.
    Overwrite,
    /// Adds the provided content to the beginning of the doc without checking paper_revision.
    Prepend,
    /// Adds the provided content to the end of the doc without checking paper_revision.
    Append,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDocUpdatePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDocUpdatePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDocUpdatePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "update" => PaperDocUpdatePolicy::Update,
                    "overwrite" => PaperDocUpdatePolicy::Overwrite,
                    "prepend" => PaperDocUpdatePolicy::Prepend,
                    "append" => PaperDocUpdatePolicy::Append,
                    _ => PaperDocUpdatePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["update",
                                    "overwrite",
                                    "prepend",
                                    "append",
                                    "other"];
        deserializer.deserialize_struct("PaperDocUpdatePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDocUpdatePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDocUpdatePolicy::Update => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "update")?;
                s.end()
            }
            PaperDocUpdatePolicy::Overwrite => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "overwrite")?;
                s.end()
            }
            PaperDocUpdatePolicy::Prepend => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "prepend")?;
                s.end()
            }
            PaperDocUpdatePolicy::Append => {
                // unit
                let mut s = serializer.serialize_struct("PaperDocUpdatePolicy", 1)?;
                s.serialize_field(".tag", "append")?;
                s.end()
            }
            PaperDocUpdatePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperUpdateArg {
    /// Path in the user's Dropbox to update. The path must correspond to a Paper doc or an error
    /// will be returned.
    pub path: WritePathOrId,
    /// The format of the provided data.
    pub import_format: ImportFormat,
    /// How the provided content should be applied to the doc.
    pub doc_update_policy: PaperDocUpdatePolicy,
    /// The latest doc revision. Required when doc_update_policy is update. This value must match
    /// the current revision of the doc or error revision_mismatch will be returned.
    pub paper_revision: Option<i64>,
}

impl PaperUpdateArg {
    pub fn new(
        path: WritePathOrId,
        import_format: ImportFormat,
        doc_update_policy: PaperDocUpdatePolicy,
    ) -> Self {
        PaperUpdateArg {
            path,
            import_format,
            doc_update_policy,
            paper_revision: None,
        }
    }

    pub fn with_paper_revision(mut self, value: i64) -> Self {
        self.paper_revision = Some(value);
        self
    }
}

const PAPER_UPDATE_ARG_FIELDS: &[&str] = &["path",
                                           "import_format",
                                           "doc_update_policy",
                                           "paper_revision"];
impl PaperUpdateArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperUpdateArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperUpdateArg>, V::Error> {
        let mut field_path = None;
        let mut field_import_format = None;
        let mut field_doc_update_policy = None;
        let mut field_paper_revision = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "import_format" => {
                    if field_import_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("import_format"));
                    }
                    field_import_format = Some(map.next_value()?);
                }
                "doc_update_policy" => {
                    if field_doc_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_update_policy"));
                    }
                    field_doc_update_policy = Some(map.next_value()?);
                }
                "paper_revision" => {
                    if field_paper_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("paper_revision"));
                    }
                    field_paper_revision = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperUpdateArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            import_format: field_import_format.ok_or_else(|| ::serde::de::Error::missing_field("import_format"))?,
            doc_update_policy: field_doc_update_policy.ok_or_else(|| ::serde::de::Error::missing_field("doc_update_policy"))?,
            paper_revision: field_paper_revision,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("import_format", &self.import_format)?;
        s.serialize_field("doc_update_policy", &self.doc_update_policy)?;
        if let Some(val) = &self.paper_revision {
            s.serialize_field("paper_revision", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperUpdateArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperUpdateArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperUpdateArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperUpdateArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperUpdateArg", PAPER_UPDATE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperUpdateArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperUpdateArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperUpdateError {
    /// Your account does not have permissions to edit Paper docs.
    InsufficientPermissions,
    /// The provided content was malformed and cannot be imported to Paper.
    ContentMalformed,
    /// The Paper doc would be too large, split the content into multiple docs.
    DocLengthExceeded,
    /// The imported document contains an image that is too large. The current limit is 1MB. This
    /// only applies to HTML with data URI.
    ImageSizeExceeded,
    Path(LookupError),
    /// The provided revision does not match the document head.
    RevisionMismatch,
    /// This operation is not allowed on archived Paper docs.
    DocArchived,
    /// This operation is not allowed on deleted Paper docs.
    DocDeleted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperUpdateError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperUpdateError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperUpdateError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "insufficient_permissions" => PaperUpdateError::InsufficientPermissions,
                    "content_malformed" => PaperUpdateError::ContentMalformed,
                    "doc_length_exceeded" => PaperUpdateError::DocLengthExceeded,
                    "image_size_exceeded" => PaperUpdateError::ImageSizeExceeded,
                    "path" => {
                        match map.next_key()? {
                            Some("path") => PaperUpdateError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "revision_mismatch" => PaperUpdateError::RevisionMismatch,
                    "doc_archived" => PaperUpdateError::DocArchived,
                    "doc_deleted" => PaperUpdateError::DocDeleted,
                    _ => PaperUpdateError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["insufficient_permissions",
                                    "content_malformed",
                                    "doc_length_exceeded",
                                    "image_size_exceeded",
                                    "other",
                                    "path",
                                    "revision_mismatch",
                                    "doc_archived",
                                    "doc_deleted"];
        deserializer.deserialize_struct("PaperUpdateError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperUpdateError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperUpdateError::InsufficientPermissions => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "insufficient_permissions")?;
                s.end()
            }
            PaperUpdateError::ContentMalformed => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "content_malformed")?;
                s.end()
            }
            PaperUpdateError::DocLengthExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "doc_length_exceeded")?;
                s.end()
            }
            PaperUpdateError::ImageSizeExceeded => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "image_size_exceeded")?;
                s.end()
            }
            PaperUpdateError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("PaperUpdateError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            PaperUpdateError::RevisionMismatch => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "revision_mismatch")?;
                s.end()
            }
            PaperUpdateError::DocArchived => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "doc_archived")?;
                s.end()
            }
            PaperUpdateError::DocDeleted => {
                // unit
                let mut s = serializer.serialize_struct("PaperUpdateError", 1)?;
                s.serialize_field(".tag", "doc_deleted")?;
                s.end()
            }
            PaperUpdateError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PaperUpdateError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            PaperUpdateError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for PaperUpdateError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PaperUpdateError::InsufficientPermissions => f.write_str("Your account does not have permissions to edit Paper docs."),
            PaperUpdateError::ContentMalformed => f.write_str("The provided content was malformed and cannot be imported to Paper."),
            PaperUpdateError::DocLengthExceeded => f.write_str("The Paper doc would be too large, split the content into multiple docs."),
            PaperUpdateError::ImageSizeExceeded => f.write_str("The imported document contains an image that is too large. The current limit is 1MB. This only applies to HTML with data URI."),
            PaperUpdateError::Path(inner) => write!(f, "{}", inner),
            PaperUpdateError::RevisionMismatch => f.write_str("The provided revision does not match the document head."),
            PaperUpdateError::DocArchived => f.write_str("This operation is not allowed on archived Paper docs."),
            PaperUpdateError::DocDeleted => f.write_str("This operation is not allowed on deleted Paper docs."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PaperUpdateResult {
    /// The current doc revision.
    pub paper_revision: i64,
}

impl PaperUpdateResult {
    pub fn new(paper_revision: i64) -> Self {
        PaperUpdateResult {
            paper_revision,
        }
    }
}

const PAPER_UPDATE_RESULT_FIELDS: &[&str] = &["paper_revision"];
impl PaperUpdateResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PaperUpdateResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PaperUpdateResult>, V::Error> {
        let mut field_paper_revision = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "paper_revision" => {
                    if field_paper_revision.is_some() {
                        return Err(::serde::de::Error::duplicate_field("paper_revision"));
                    }
                    field_paper_revision = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PaperUpdateResult {
            paper_revision: field_paper_revision.ok_or_else(|| ::serde::de::Error::missing_field("paper_revision"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("paper_revision", &self.paper_revision)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PaperUpdateResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PaperUpdateResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperUpdateResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PaperUpdateResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PaperUpdateResult", PAPER_UPDATE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PaperUpdateResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PaperUpdateResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PathOrLink {
    Path(ReadPath),
    Link(SharedLinkFileInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PathOrLink {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PathOrLink;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PathOrLink structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => PathOrLink::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "link" => PathOrLink::Link(SharedLinkFileInfo::internal_deserialize(&mut map)?),
                    _ => PathOrLink::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "link",
                                    "other"];
        deserializer.deserialize_struct("PathOrLink", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PathOrLink {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PathOrLink::Path(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("PathOrLink", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            PathOrLink::Link(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("PathOrLink", 4)?;
                s.serialize_field(".tag", "link")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            PathOrLink::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Metadata for a photo.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PhotoMetadata {
    /// Dimension of the photo/video.
    pub dimensions: Option<Dimensions>,
    /// The GPS coordinate of the photo/video.
    pub location: Option<GpsCoordinates>,
    /// The timestamp when the photo/video is taken.
    pub time_taken: Option<super::common::DropboxTimestamp>,
}

impl Default for PhotoMetadata {
    fn default() -> Self {
        PhotoMetadata {
            dimensions: None,
            location: None,
            time_taken: None,
        }
    }
}

impl PhotoMetadata {
    pub fn with_dimensions(mut self, value: Dimensions) -> Self {
        self.dimensions = Some(value);
        self
    }

    pub fn with_location(mut self, value: GpsCoordinates) -> Self {
        self.location = Some(value);
        self
    }

    pub fn with_time_taken(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.time_taken = Some(value);
        self
    }
}

const PHOTO_METADATA_FIELDS: &[&str] = &["dimensions",
                                         "location",
                                         "time_taken"];
impl PhotoMetadata {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<PhotoMetadata, V::Error> {
        let mut field_dimensions = None;
        let mut field_location = None;
        let mut field_time_taken = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "dimensions" => {
                    if field_dimensions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("dimensions"));
                    }
                    field_dimensions = Some(map.next_value()?);
                }
                "location" => {
                    if field_location.is_some() {
                        return Err(::serde::de::Error::duplicate_field("location"));
                    }
                    field_location = Some(map.next_value()?);
                }
                "time_taken" => {
                    if field_time_taken.is_some() {
                        return Err(::serde::de::Error::duplicate_field("time_taken"));
                    }
                    field_time_taken = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = PhotoMetadata {
            dimensions: field_dimensions,
            location: field_location,
            time_taken: field_time_taken,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.dimensions {
            s.serialize_field("dimensions", val)?;
        }
        if let Some(val) = &self.location {
            s.serialize_field("location", val)?;
        }
        if let Some(val) = &self.time_taken {
            s.serialize_field("time_taken", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PhotoMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PhotoMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PhotoMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PhotoMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PhotoMetadata", PHOTO_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PhotoMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PhotoMetadata", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PreviewArg {
    /// The path of the file to preview.
    pub path: ReadPath,
    /// Please specify revision in `path` instead.
    pub rev: Option<Rev>,
}

impl PreviewArg {
    pub fn new(path: ReadPath) -> Self {
        PreviewArg {
            path,
            rev: None,
        }
    }

    pub fn with_rev(mut self, value: Rev) -> Self {
        self.rev = Some(value);
        self
    }
}

const PREVIEW_ARG_FIELDS: &[&str] = &["path",
                                      "rev"];
impl PreviewArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PreviewArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PreviewArg>, V::Error> {
        let mut field_path = None;
        let mut field_rev = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PreviewArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            rev: field_rev,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        if let Some(val) = &self.rev {
            s.serialize_field("rev", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PreviewArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PreviewArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PreviewArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PreviewArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PreviewArg", PREVIEW_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PreviewArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PreviewArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum PreviewError {
    /// An error occurs when downloading metadata for the file.
    Path(LookupError),
    /// This preview generation is still in progress and the file is not ready  for preview yet.
    InProgress,
    /// The file extension is not supported preview generation.
    UnsupportedExtension,
    /// The file content is not supported for preview generation.
    UnsupportedContent,
}

impl<'de> ::serde::de::Deserialize<'de> for PreviewError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PreviewError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PreviewError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => PreviewError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "in_progress" => PreviewError::InProgress,
                    "unsupported_extension" => PreviewError::UnsupportedExtension,
                    "unsupported_content" => PreviewError::UnsupportedContent,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "in_progress",
                                    "unsupported_extension",
                                    "unsupported_content"];
        deserializer.deserialize_struct("PreviewError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PreviewError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PreviewError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("PreviewError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            PreviewError::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("PreviewError", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            PreviewError::UnsupportedExtension => {
                // unit
                let mut s = serializer.serialize_struct("PreviewError", 1)?;
                s.serialize_field(".tag", "unsupported_extension")?;
                s.end()
            }
            PreviewError::UnsupportedContent => {
                // unit
                let mut s = serializer.serialize_struct("PreviewError", 1)?;
                s.serialize_field(".tag", "unsupported_content")?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for PreviewError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            PreviewError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for PreviewError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PreviewError::Path(inner) => write!(f, "An error occurs when downloading metadata for the file: {}", inner),
            PreviewError::InProgress => f.write_str("This preview generation is still in progress and the file is not ready  for preview yet."),
            PreviewError::UnsupportedExtension => f.write_str("The file extension is not supported preview generation."),
            PreviewError::UnsupportedContent => f.write_str("The file content is not supported for preview generation."),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PreviewResult {
    /// Metadata corresponding to the file received as an argument. Will be populated if the
    /// endpoint is called with a path (ReadPath).
    pub file_metadata: Option<FileMetadata>,
    /// Minimal metadata corresponding to the file received as an argument. Will be populated if the
    /// endpoint is called using a shared link (SharedLinkFileInfo).
    pub link_metadata: Option<MinimalFileLinkMetadata>,
}

impl Default for PreviewResult {
    fn default() -> Self {
        PreviewResult {
            file_metadata: None,
            link_metadata: None,
        }
    }
}

impl PreviewResult {
    pub fn with_file_metadata(mut self, value: FileMetadata) -> Self {
        self.file_metadata = Some(value);
        self
    }

    pub fn with_link_metadata(mut self, value: MinimalFileLinkMetadata) -> Self {
        self.link_metadata = Some(value);
        self
    }
}

const PREVIEW_RESULT_FIELDS: &[&str] = &["file_metadata",
                                         "link_metadata"];
impl PreviewResult {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<PreviewResult, V::Error> {
        let mut field_file_metadata = None;
        let mut field_link_metadata = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "file_metadata" => {
                    if field_file_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_metadata"));
                    }
                    field_file_metadata = Some(map.next_value()?);
                }
                "link_metadata" => {
                    if field_link_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_metadata"));
                    }
                    field_link_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = PreviewResult {
            file_metadata: field_file_metadata,
            link_metadata: field_link_metadata,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.file_metadata {
            s.serialize_field("file_metadata", val)?;
        }
        if let Some(val) = &self.link_metadata {
            s.serialize_field("link_metadata", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PreviewResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PreviewResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PreviewResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PreviewResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PreviewResult", PREVIEW_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PreviewResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PreviewResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationArg {
    /// Path in the user's Dropbox to be copied or moved.
    pub from_path: WritePathOrId,
    /// Path in the user's Dropbox that is the destination.
    pub to_path: WritePathOrId,
    /// This flag has no effect.
    pub allow_shared_folder: bool,
    /// If there's a conflict, have the Dropbox server try to autorename the file to avoid the
    /// conflict.
    pub autorename: bool,
    /// Allow moves by owner even if it would result in an ownership transfer for the content being
    /// moved. This does not apply to copies.
    pub allow_ownership_transfer: bool,
}

impl RelocationArg {
    pub fn new(from_path: WritePathOrId, to_path: WritePathOrId) -> Self {
        RelocationArg {
            from_path,
            to_path,
            allow_shared_folder: false,
            autorename: false,
            allow_ownership_transfer: false,
        }
    }

    pub fn with_allow_shared_folder(mut self, value: bool) -> Self {
        self.allow_shared_folder = value;
        self
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_allow_ownership_transfer(mut self, value: bool) -> Self {
        self.allow_ownership_transfer = value;
        self
    }
}

const RELOCATION_ARG_FIELDS: &[&str] = &["from_path",
                                         "to_path",
                                         "allow_shared_folder",
                                         "autorename",
                                         "allow_ownership_transfer"];
impl RelocationArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationArg>, V::Error> {
        let mut field_from_path = None;
        let mut field_to_path = None;
        let mut field_allow_shared_folder = None;
        let mut field_autorename = None;
        let mut field_allow_ownership_transfer = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "from_path" => {
                    if field_from_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("from_path"));
                    }
                    field_from_path = Some(map.next_value()?);
                }
                "to_path" => {
                    if field_to_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("to_path"));
                    }
                    field_to_path = Some(map.next_value()?);
                }
                "allow_shared_folder" => {
                    if field_allow_shared_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_shared_folder"));
                    }
                    field_allow_shared_folder = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "allow_ownership_transfer" => {
                    if field_allow_ownership_transfer.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_ownership_transfer"));
                    }
                    field_allow_ownership_transfer = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationArg {
            from_path: field_from_path.ok_or_else(|| ::serde::de::Error::missing_field("from_path"))?,
            to_path: field_to_path.ok_or_else(|| ::serde::de::Error::missing_field("to_path"))?,
            allow_shared_folder: field_allow_shared_folder.unwrap_or(false),
            autorename: field_autorename.unwrap_or(false),
            allow_ownership_transfer: field_allow_ownership_transfer.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("from_path", &self.from_path)?;
        s.serialize_field("to_path", &self.to_path)?;
        s.serialize_field("allow_shared_folder", &self.allow_shared_folder)?;
        s.serialize_field("autorename", &self.autorename)?;
        s.serialize_field("allow_ownership_transfer", &self.allow_ownership_transfer)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationArg", RELOCATION_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationArg", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationBatchArg {
    /// List of entries to be moved or copied. Each entry is [`RelocationPath`](RelocationPath).
    pub entries: Vec<RelocationPath>,
    /// If there's a conflict with any file, have the Dropbox server try to autorename that file to
    /// avoid the conflict.
    pub autorename: bool,
    /// This flag has no effect.
    pub allow_shared_folder: bool,
    /// Allow moves by owner even if it would result in an ownership transfer for the content being
    /// moved. This does not apply to copies.
    pub allow_ownership_transfer: bool,
}

impl RelocationBatchArg {
    pub fn new(entries: Vec<RelocationPath>) -> Self {
        RelocationBatchArg {
            entries,
            autorename: false,
            allow_shared_folder: false,
            allow_ownership_transfer: false,
        }
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }

    pub fn with_allow_shared_folder(mut self, value: bool) -> Self {
        self.allow_shared_folder = value;
        self
    }

    pub fn with_allow_ownership_transfer(mut self, value: bool) -> Self {
        self.allow_ownership_transfer = value;
        self
    }
}

const RELOCATION_BATCH_ARG_FIELDS: &[&str] = &["entries",
                                               "autorename",
                                               "allow_shared_folder",
                                               "allow_ownership_transfer"];
impl RelocationBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut field_autorename = None;
        let mut field_allow_shared_folder = None;
        let mut field_allow_ownership_transfer = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                "allow_shared_folder" => {
                    if field_allow_shared_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_shared_folder"));
                    }
                    field_allow_shared_folder = Some(map.next_value()?);
                }
                "allow_ownership_transfer" => {
                    if field_allow_ownership_transfer.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_ownership_transfer"));
                    }
                    field_allow_ownership_transfer = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            autorename: field_autorename.unwrap_or(false),
            allow_shared_folder: field_allow_shared_folder.unwrap_or(false),
            allow_ownership_transfer: field_allow_ownership_transfer.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("autorename", &self.autorename)?;
        s.serialize_field("allow_shared_folder", &self.allow_shared_folder)?;
        s.serialize_field("allow_ownership_transfer", &self.allow_ownership_transfer)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationBatchArg", RELOCATION_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationBatchArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationBatchArgBase {
    /// List of entries to be moved or copied. Each entry is [`RelocationPath`](RelocationPath).
    pub entries: Vec<RelocationPath>,
    /// If there's a conflict with any file, have the Dropbox server try to autorename that file to
    /// avoid the conflict.
    pub autorename: bool,
}

impl RelocationBatchArgBase {
    pub fn new(entries: Vec<RelocationPath>) -> Self {
        RelocationBatchArgBase {
            entries,
            autorename: false,
        }
    }

    pub fn with_autorename(mut self, value: bool) -> Self {
        self.autorename = value;
        self
    }
}

const RELOCATION_BATCH_ARG_BASE_FIELDS: &[&str] = &["entries",
                                                    "autorename"];
impl RelocationBatchArgBase {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationBatchArgBase, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationBatchArgBase>, V::Error> {
        let mut field_entries = None;
        let mut field_autorename = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "autorename" => {
                    if field_autorename.is_some() {
                        return Err(::serde::de::Error::duplicate_field("autorename"));
                    }
                    field_autorename = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationBatchArgBase {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            autorename: field_autorename.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("autorename", &self.autorename)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchArgBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationBatchArgBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchArgBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationBatchArgBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationBatchArgBase", RELOCATION_BATCH_ARG_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchArgBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationBatchArgBase", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelocationBatchError {
    FromLookup(LookupError),
    FromWrite(WriteError),
    To(WriteError),
    /// Shared folders can't be copied.
    CantCopySharedFolder,
    /// Your move operation would result in nested shared folders.  This is not allowed.
    CantNestSharedFolder,
    /// You cannot move a folder into itself.
    CantMoveFolderIntoItself,
    /// The operation would involve more than 10,000 files and folders.
    TooManyFiles,
    /// There are duplicated/nested paths among [`RelocationArg::from_path`](RelocationArg) and
    /// [`RelocationArg::to_path`](RelocationArg).
    DuplicatedOrNestedPaths,
    /// Your move operation would result in an ownership transfer. You may reissue the request with
    /// the field [`RelocationArg::allow_ownership_transfer`](RelocationArg) to true.
    CantTransferOwnership,
    /// The current user does not have enough space to move or copy the files.
    InsufficientQuota,
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// Can't move the shared folder to the given destination.
    CantMoveSharedFolder,
    /// Some content cannot be moved into Vault under certain circumstances, see detailed error.
    CantMoveIntoVault(MoveIntoVaultError),
    /// There are too many write operations in user's Dropbox. Please retry this request.
    TooManyWriteOperations,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "from_lookup" => {
                        match map.next_key()? {
                            Some("from_lookup") => RelocationBatchError::FromLookup(map.next_value()?),
                            None => return Err(de::Error::missing_field("from_lookup")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "from_write" => {
                        match map.next_key()? {
                            Some("from_write") => RelocationBatchError::FromWrite(map.next_value()?),
                            None => return Err(de::Error::missing_field("from_write")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "to" => {
                        match map.next_key()? {
                            Some("to") => RelocationBatchError::To(map.next_value()?),
                            None => return Err(de::Error::missing_field("to")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "cant_copy_shared_folder" => RelocationBatchError::CantCopySharedFolder,
                    "cant_nest_shared_folder" => RelocationBatchError::CantNestSharedFolder,
                    "cant_move_folder_into_itself" => RelocationBatchError::CantMoveFolderIntoItself,
                    "too_many_files" => RelocationBatchError::TooManyFiles,
                    "duplicated_or_nested_paths" => RelocationBatchError::DuplicatedOrNestedPaths,
                    "cant_transfer_ownership" => RelocationBatchError::CantTransferOwnership,
                    "insufficient_quota" => RelocationBatchError::InsufficientQuota,
                    "internal_error" => RelocationBatchError::InternalError,
                    "cant_move_shared_folder" => RelocationBatchError::CantMoveSharedFolder,
                    "cant_move_into_vault" => {
                        match map.next_key()? {
                            Some("cant_move_into_vault") => RelocationBatchError::CantMoveIntoVault(map.next_value()?),
                            None => return Err(de::Error::missing_field("cant_move_into_vault")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_write_operations" => RelocationBatchError::TooManyWriteOperations,
                    _ => RelocationBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["from_lookup",
                                    "from_write",
                                    "to",
                                    "cant_copy_shared_folder",
                                    "cant_nest_shared_folder",
                                    "cant_move_folder_into_itself",
                                    "too_many_files",
                                    "duplicated_or_nested_paths",
                                    "cant_transfer_ownership",
                                    "insufficient_quota",
                                    "internal_error",
                                    "cant_move_shared_folder",
                                    "cant_move_into_vault",
                                    "other",
                                    "too_many_write_operations"];
        deserializer.deserialize_struct("RelocationBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchError::FromLookup(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchError", 2)?;
                s.serialize_field(".tag", "from_lookup")?;
                s.serialize_field("from_lookup", x)?;
                s.end()
            }
            RelocationBatchError::FromWrite(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchError", 2)?;
                s.serialize_field(".tag", "from_write")?;
                s.serialize_field("from_write", x)?;
                s.end()
            }
            RelocationBatchError::To(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchError", 2)?;
                s.serialize_field(".tag", "to")?;
                s.serialize_field("to", x)?;
                s.end()
            }
            RelocationBatchError::CantCopySharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "cant_copy_shared_folder")?;
                s.end()
            }
            RelocationBatchError::CantNestSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "cant_nest_shared_folder")?;
                s.end()
            }
            RelocationBatchError::CantMoveFolderIntoItself => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "cant_move_folder_into_itself")?;
                s.end()
            }
            RelocationBatchError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            RelocationBatchError::DuplicatedOrNestedPaths => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "duplicated_or_nested_paths")?;
                s.end()
            }
            RelocationBatchError::CantTransferOwnership => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "cant_transfer_ownership")?;
                s.end()
            }
            RelocationBatchError::InsufficientQuota => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "insufficient_quota")?;
                s.end()
            }
            RelocationBatchError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            RelocationBatchError::CantMoveSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "cant_move_shared_folder")?;
                s.end()
            }
            RelocationBatchError::CantMoveIntoVault(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchError", 2)?;
                s.serialize_field(".tag", "cant_move_into_vault")?;
                s.serialize_field("cant_move_into_vault", x)?;
                s.end()
            }
            RelocationBatchError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            RelocationBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RelocationBatchError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RelocationBatchError::FromLookup(inner) => Some(inner),
            RelocationBatchError::FromWrite(inner) => Some(inner),
            RelocationBatchError::To(inner) => Some(inner),
            RelocationBatchError::CantMoveIntoVault(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RelocationBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RelocationBatchError::FromLookup(inner) => write!(f, "{}", inner),
            RelocationBatchError::FromWrite(inner) => write!(f, "{}", inner),
            RelocationBatchError::To(inner) => write!(f, "{}", inner),
            RelocationBatchError::CantCopySharedFolder => f.write_str("Shared folders can't be copied."),
            RelocationBatchError::CantNestSharedFolder => f.write_str("Your move operation would result in nested shared folders.  This is not allowed."),
            RelocationBatchError::CantMoveFolderIntoItself => f.write_str("You cannot move a folder into itself."),
            RelocationBatchError::TooManyFiles => f.write_str("The operation would involve more than 10,000 files and folders."),
            RelocationBatchError::InsufficientQuota => f.write_str("The current user does not have enough space to move or copy the files."),
            RelocationBatchError::InternalError => f.write_str("Something went wrong with the job on Dropbox's end. You'll need to verify that the action you were taking succeeded, and if not, try again. This should happen very rarely."),
            RelocationBatchError::CantMoveSharedFolder => f.write_str("Can't move the shared folder to the given destination."),
            RelocationBatchError::CantMoveIntoVault(inner) => write!(f, "Some content cannot be moved into Vault under certain circumstances, see detailed error: {}", inner),
            RelocationBatchError::TooManyWriteOperations => f.write_str("There are too many write operations in user's Dropbox. Please retry this request."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelocationBatchErrorEntry {
    /// User errors that retry won't help.
    RelocationError(RelocationError),
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// There are too many write operations in user's Dropbox. Please retry this request.
    TooManyWriteOperations,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchErrorEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchErrorEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchErrorEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "relocation_error" => {
                        match map.next_key()? {
                            Some("relocation_error") => RelocationBatchErrorEntry::RelocationError(map.next_value()?),
                            None => return Err(de::Error::missing_field("relocation_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "internal_error" => RelocationBatchErrorEntry::InternalError,
                    "too_many_write_operations" => RelocationBatchErrorEntry::TooManyWriteOperations,
                    _ => RelocationBatchErrorEntry::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["relocation_error",
                                    "internal_error",
                                    "too_many_write_operations",
                                    "other"];
        deserializer.deserialize_struct("RelocationBatchErrorEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchErrorEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchErrorEntry::RelocationError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchErrorEntry", 2)?;
                s.serialize_field(".tag", "relocation_error")?;
                s.serialize_field("relocation_error", x)?;
                s.end()
            }
            RelocationBatchErrorEntry::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchErrorEntry", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            RelocationBatchErrorEntry::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchErrorEntry", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            RelocationBatchErrorEntry::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum RelocationBatchJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The copy or move batch job has finished.
    Complete(RelocationBatchResult),
    /// The copy or move batch job has failed with exception.
    Failed(RelocationBatchError),
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => RelocationBatchJobStatus::InProgress,
                    "complete" => RelocationBatchJobStatus::Complete(RelocationBatchResult::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => RelocationBatchJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("RelocationBatchJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            RelocationBatchJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RelocationBatchJobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RelocationBatchJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

/// Result returned by [`copy_batch()`](copy_batch) or [`move_batch()`](move_batch) that may either
/// launch an asynchronous job or complete synchronously.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelocationBatchLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(RelocationBatchResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => RelocationBatchLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => RelocationBatchLaunch::Complete(RelocationBatchResult::internal_deserialize(&mut map)?),
                    _ => RelocationBatchLaunch::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete",
                                    "other"];
        deserializer.deserialize_struct("RelocationBatchLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("RelocationBatchLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            RelocationBatchLaunch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RelocationBatchLaunch", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RelocationBatchLaunch::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationBatchResult {
    pub entries: Vec<RelocationBatchResultData>,
}

impl RelocationBatchResult {
    pub fn new(entries: Vec<RelocationBatchResultData>) -> Self {
        RelocationBatchResult {
            entries,
        }
    }
}

const RELOCATION_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl RelocationBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationBatchResult", RELOCATION_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationBatchResultData {
    /// Metadata of the relocated object.
    pub metadata: Metadata,
}

impl RelocationBatchResultData {
    pub fn new(metadata: Metadata) -> Self {
        RelocationBatchResultData {
            metadata,
        }
    }
}

const RELOCATION_BATCH_RESULT_DATA_FIELDS: &[&str] = &["metadata"];
impl RelocationBatchResultData {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationBatchResultData, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationBatchResultData>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationBatchResultData {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchResultData {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationBatchResultData;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchResultData struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationBatchResultData::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationBatchResultData", RELOCATION_BATCH_RESULT_DATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchResultData {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationBatchResultData", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelocationBatchResultEntry {
    Success(Metadata),
    Failure(RelocationBatchErrorEntry),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => {
                        match map.next_key()? {
                            Some("success") => RelocationBatchResultEntry::Success(map.next_value()?),
                            None => return Err(de::Error::missing_field("success")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => RelocationBatchResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => RelocationBatchResultEntry::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure",
                                    "other"];
        deserializer.deserialize_struct("RelocationBatchResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchResultEntry::Success(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchResultEntry", 2)?;
                s.serialize_field(".tag", "success")?;
                s.serialize_field("success", x)?;
                s.end()
            }
            RelocationBatchResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationBatchResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
            RelocationBatchResultEntry::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Result returned by [`copy_batch_check_v2()`](copy_batch_check_v2) or
/// [`move_batch_check_v2()`](move_batch_check_v2) that may either be in progress or completed with
/// result for each entry.
#[derive(Debug, Clone, PartialEq)]
pub enum RelocationBatchV2JobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The copy or move batch job has finished.
    Complete(RelocationBatchV2Result),
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchV2JobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchV2JobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchV2JobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => RelocationBatchV2JobStatus::InProgress,
                    "complete" => RelocationBatchV2JobStatus::Complete(RelocationBatchV2Result::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete"];
        deserializer.deserialize_struct("RelocationBatchV2JobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchV2JobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchV2JobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("RelocationBatchV2JobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            RelocationBatchV2JobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RelocationBatchV2JobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

/// Result returned by [`copy_batch_v2()`](copy_batch_v2) or [`move_batch_v2()`](move_batch_v2) that
/// may either launch an asynchronous job or complete synchronously.
#[derive(Debug, Clone, PartialEq)]
pub enum RelocationBatchV2Launch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(RelocationBatchV2Result),
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchV2Launch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationBatchV2Launch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchV2Launch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => RelocationBatchV2Launch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => RelocationBatchV2Launch::Complete(RelocationBatchV2Result::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete"];
        deserializer.deserialize_struct("RelocationBatchV2Launch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchV2Launch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationBatchV2Launch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("RelocationBatchV2Launch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            RelocationBatchV2Launch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RelocationBatchV2Launch", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationBatchV2Result {
    /// Each entry in CopyBatchArg.entries or [`MoveBatchArg::entries`](MoveBatchArg) will appear at
    /// the same position inside [`RelocationBatchV2Result::entries`](RelocationBatchV2Result).
    pub entries: Vec<RelocationBatchResultEntry>,
}

impl RelocationBatchV2Result {
    pub fn new(entries: Vec<RelocationBatchResultEntry>) -> Self {
        RelocationBatchV2Result {
            entries,
        }
    }
}

const RELOCATION_BATCH_V2_RESULT_FIELDS: &[&str] = &["entries"];
impl RelocationBatchV2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationBatchV2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationBatchV2Result>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationBatchV2Result {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationBatchV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationBatchV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationBatchV2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationBatchV2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationBatchV2Result", RELOCATION_BATCH_V2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationBatchV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationBatchV2Result", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelocationError {
    FromLookup(LookupError),
    FromWrite(WriteError),
    To(WriteError),
    /// Shared folders can't be copied.
    CantCopySharedFolder,
    /// Your move operation would result in nested shared folders.  This is not allowed.
    CantNestSharedFolder,
    /// You cannot move a folder into itself.
    CantMoveFolderIntoItself,
    /// The operation would involve more than 10,000 files and folders.
    TooManyFiles,
    /// There are duplicated/nested paths among [`RelocationArg::from_path`](RelocationArg) and
    /// [`RelocationArg::to_path`](RelocationArg).
    DuplicatedOrNestedPaths,
    /// Your move operation would result in an ownership transfer. You may reissue the request with
    /// the field [`RelocationArg::allow_ownership_transfer`](RelocationArg) to true.
    CantTransferOwnership,
    /// The current user does not have enough space to move or copy the files.
    InsufficientQuota,
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// Can't move the shared folder to the given destination.
    CantMoveSharedFolder,
    /// Some content cannot be moved into Vault under certain circumstances, see detailed error.
    CantMoveIntoVault(MoveIntoVaultError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelocationError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "from_lookup" => {
                        match map.next_key()? {
                            Some("from_lookup") => RelocationError::FromLookup(map.next_value()?),
                            None => return Err(de::Error::missing_field("from_lookup")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "from_write" => {
                        match map.next_key()? {
                            Some("from_write") => RelocationError::FromWrite(map.next_value()?),
                            None => return Err(de::Error::missing_field("from_write")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "to" => {
                        match map.next_key()? {
                            Some("to") => RelocationError::To(map.next_value()?),
                            None => return Err(de::Error::missing_field("to")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "cant_copy_shared_folder" => RelocationError::CantCopySharedFolder,
                    "cant_nest_shared_folder" => RelocationError::CantNestSharedFolder,
                    "cant_move_folder_into_itself" => RelocationError::CantMoveFolderIntoItself,
                    "too_many_files" => RelocationError::TooManyFiles,
                    "duplicated_or_nested_paths" => RelocationError::DuplicatedOrNestedPaths,
                    "cant_transfer_ownership" => RelocationError::CantTransferOwnership,
                    "insufficient_quota" => RelocationError::InsufficientQuota,
                    "internal_error" => RelocationError::InternalError,
                    "cant_move_shared_folder" => RelocationError::CantMoveSharedFolder,
                    "cant_move_into_vault" => {
                        match map.next_key()? {
                            Some("cant_move_into_vault") => RelocationError::CantMoveIntoVault(map.next_value()?),
                            None => return Err(de::Error::missing_field("cant_move_into_vault")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => RelocationError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["from_lookup",
                                    "from_write",
                                    "to",
                                    "cant_copy_shared_folder",
                                    "cant_nest_shared_folder",
                                    "cant_move_folder_into_itself",
                                    "too_many_files",
                                    "duplicated_or_nested_paths",
                                    "cant_transfer_ownership",
                                    "insufficient_quota",
                                    "internal_error",
                                    "cant_move_shared_folder",
                                    "cant_move_into_vault",
                                    "other"];
        deserializer.deserialize_struct("RelocationError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelocationError::FromLookup(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationError", 2)?;
                s.serialize_field(".tag", "from_lookup")?;
                s.serialize_field("from_lookup", x)?;
                s.end()
            }
            RelocationError::FromWrite(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationError", 2)?;
                s.serialize_field(".tag", "from_write")?;
                s.serialize_field("from_write", x)?;
                s.end()
            }
            RelocationError::To(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationError", 2)?;
                s.serialize_field(".tag", "to")?;
                s.serialize_field("to", x)?;
                s.end()
            }
            RelocationError::CantCopySharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "cant_copy_shared_folder")?;
                s.end()
            }
            RelocationError::CantNestSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "cant_nest_shared_folder")?;
                s.end()
            }
            RelocationError::CantMoveFolderIntoItself => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "cant_move_folder_into_itself")?;
                s.end()
            }
            RelocationError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            RelocationError::DuplicatedOrNestedPaths => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "duplicated_or_nested_paths")?;
                s.end()
            }
            RelocationError::CantTransferOwnership => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "cant_transfer_ownership")?;
                s.end()
            }
            RelocationError::InsufficientQuota => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "insufficient_quota")?;
                s.end()
            }
            RelocationError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            RelocationError::CantMoveSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelocationError", 1)?;
                s.serialize_field(".tag", "cant_move_shared_folder")?;
                s.end()
            }
            RelocationError::CantMoveIntoVault(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelocationError", 2)?;
                s.serialize_field(".tag", "cant_move_into_vault")?;
                s.serialize_field("cant_move_into_vault", x)?;
                s.end()
            }
            RelocationError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RelocationError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RelocationError::FromLookup(inner) => Some(inner),
            RelocationError::FromWrite(inner) => Some(inner),
            RelocationError::To(inner) => Some(inner),
            RelocationError::CantMoveIntoVault(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RelocationError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RelocationError::FromLookup(inner) => write!(f, "{}", inner),
            RelocationError::FromWrite(inner) => write!(f, "{}", inner),
            RelocationError::To(inner) => write!(f, "{}", inner),
            RelocationError::CantCopySharedFolder => f.write_str("Shared folders can't be copied."),
            RelocationError::CantNestSharedFolder => f.write_str("Your move operation would result in nested shared folders.  This is not allowed."),
            RelocationError::CantMoveFolderIntoItself => f.write_str("You cannot move a folder into itself."),
            RelocationError::TooManyFiles => f.write_str("The operation would involve more than 10,000 files and folders."),
            RelocationError::InsufficientQuota => f.write_str("The current user does not have enough space to move or copy the files."),
            RelocationError::InternalError => f.write_str("Something went wrong with the job on Dropbox's end. You'll need to verify that the action you were taking succeeded, and if not, try again. This should happen very rarely."),
            RelocationError::CantMoveSharedFolder => f.write_str("Can't move the shared folder to the given destination."),
            RelocationError::CantMoveIntoVault(inner) => write!(f, "Some content cannot be moved into Vault under certain circumstances, see detailed error: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationPath {
    /// Path in the user's Dropbox to be copied or moved.
    pub from_path: WritePathOrId,
    /// Path in the user's Dropbox that is the destination.
    pub to_path: WritePathOrId,
}

impl RelocationPath {
    pub fn new(from_path: WritePathOrId, to_path: WritePathOrId) -> Self {
        RelocationPath {
            from_path,
            to_path,
        }
    }
}

const RELOCATION_PATH_FIELDS: &[&str] = &["from_path",
                                          "to_path"];
impl RelocationPath {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationPath, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationPath>, V::Error> {
        let mut field_from_path = None;
        let mut field_to_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "from_path" => {
                    if field_from_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("from_path"));
                    }
                    field_from_path = Some(map.next_value()?);
                }
                "to_path" => {
                    if field_to_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("to_path"));
                    }
                    field_to_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationPath {
            from_path: field_from_path.ok_or_else(|| ::serde::de::Error::missing_field("from_path"))?,
            to_path: field_to_path.ok_or_else(|| ::serde::de::Error::missing_field("to_path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("from_path", &self.from_path)?;
        s.serialize_field("to_path", &self.to_path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationPath {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationPath;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationPath struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationPath::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationPath", RELOCATION_PATH_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationPath {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationPath", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelocationResult {
    /// Metadata of the relocated object.
    pub metadata: Metadata,
}

impl RelocationResult {
    pub fn new(metadata: Metadata) -> Self {
        RelocationResult {
            metadata,
        }
    }
}

const RELOCATION_RESULT_FIELDS: &[&str] = &["metadata"];
impl RelocationResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelocationResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelocationResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelocationResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelocationResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelocationResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelocationResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelocationResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelocationResult", RELOCATION_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelocationResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelocationResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RestoreArg {
    /// The path to save the restored file.
    pub path: WritePath,
    /// The revision to restore.
    pub rev: Rev,
}

impl RestoreArg {
    pub fn new(path: WritePath, rev: Rev) -> Self {
        RestoreArg {
            path,
            rev,
        }
    }
}

const RESTORE_ARG_FIELDS: &[&str] = &["path",
                                      "rev"];
impl RestoreArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RestoreArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RestoreArg>, V::Error> {
        let mut field_path = None;
        let mut field_rev = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RestoreArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            rev: field_rev.ok_or_else(|| ::serde::de::Error::missing_field("rev"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("rev", &self.rev)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RestoreArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RestoreArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RestoreArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RestoreArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RestoreArg", RESTORE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RestoreArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RestoreArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RestoreError {
    /// An error occurs when downloading metadata for the file.
    PathLookup(LookupError),
    /// An error occurs when trying to restore the file to that path.
    PathWrite(WriteError),
    /// The revision is invalid. It may not exist or may point to a deleted file.
    InvalidRevision,
    /// The restore is currently executing, but has not yet completed.
    InProgress,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RestoreError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RestoreError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RestoreError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path_lookup" => {
                        match map.next_key()? {
                            Some("path_lookup") => RestoreError::PathLookup(map.next_value()?),
                            None => return Err(de::Error::missing_field("path_lookup")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "path_write" => {
                        match map.next_key()? {
                            Some("path_write") => RestoreError::PathWrite(map.next_value()?),
                            None => return Err(de::Error::missing_field("path_write")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_revision" => RestoreError::InvalidRevision,
                    "in_progress" => RestoreError::InProgress,
                    _ => RestoreError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path_lookup",
                                    "path_write",
                                    "invalid_revision",
                                    "in_progress",
                                    "other"];
        deserializer.deserialize_struct("RestoreError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RestoreError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RestoreError::PathLookup(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RestoreError", 2)?;
                s.serialize_field(".tag", "path_lookup")?;
                s.serialize_field("path_lookup", x)?;
                s.end()
            }
            RestoreError::PathWrite(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RestoreError", 2)?;
                s.serialize_field(".tag", "path_write")?;
                s.serialize_field("path_write", x)?;
                s.end()
            }
            RestoreError::InvalidRevision => {
                // unit
                let mut s = serializer.serialize_struct("RestoreError", 1)?;
                s.serialize_field(".tag", "invalid_revision")?;
                s.end()
            }
            RestoreError::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("RestoreError", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            RestoreError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RestoreError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RestoreError::PathLookup(inner) => Some(inner),
            RestoreError::PathWrite(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RestoreError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RestoreError::PathLookup(inner) => write!(f, "An error occurs when downloading metadata for the file: {}", inner),
            RestoreError::PathWrite(inner) => write!(f, "An error occurs when trying to restore the file to that path: {}", inner),
            RestoreError::InvalidRevision => f.write_str("The revision is invalid. It may not exist or may point to a deleted file."),
            RestoreError::InProgress => f.write_str("The restore is currently executing, but has not yet completed."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SaveCopyReferenceArg {
    /// A copy reference returned by [`copy_reference_get()`](copy_reference_get).
    pub copy_reference: String,
    /// Path in the user's Dropbox that is the destination.
    pub path: Path,
}

impl SaveCopyReferenceArg {
    pub fn new(copy_reference: String, path: Path) -> Self {
        SaveCopyReferenceArg {
            copy_reference,
            path,
        }
    }
}

const SAVE_COPY_REFERENCE_ARG_FIELDS: &[&str] = &["copy_reference",
                                                  "path"];
impl SaveCopyReferenceArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SaveCopyReferenceArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SaveCopyReferenceArg>, V::Error> {
        let mut field_copy_reference = None;
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "copy_reference" => {
                    if field_copy_reference.is_some() {
                        return Err(::serde::de::Error::duplicate_field("copy_reference"));
                    }
                    field_copy_reference = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SaveCopyReferenceArg {
            copy_reference: field_copy_reference.ok_or_else(|| ::serde::de::Error::missing_field("copy_reference"))?,
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("copy_reference", &self.copy_reference)?;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SaveCopyReferenceArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SaveCopyReferenceArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveCopyReferenceArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SaveCopyReferenceArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SaveCopyReferenceArg", SAVE_COPY_REFERENCE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SaveCopyReferenceArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SaveCopyReferenceArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SaveCopyReferenceError {
    Path(WriteError),
    /// The copy reference is invalid.
    InvalidCopyReference,
    /// You don't have permission to save the given copy reference. Please make sure this app is
    /// same app which created the copy reference and the source user is still linked to the app.
    NoPermission,
    /// The file referenced by the copy reference cannot be found.
    NotFound,
    /// The operation would involve more than 10,000 files and folders.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SaveCopyReferenceError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SaveCopyReferenceError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveCopyReferenceError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => SaveCopyReferenceError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_copy_reference" => SaveCopyReferenceError::InvalidCopyReference,
                    "no_permission" => SaveCopyReferenceError::NoPermission,
                    "not_found" => SaveCopyReferenceError::NotFound,
                    "too_many_files" => SaveCopyReferenceError::TooManyFiles,
                    _ => SaveCopyReferenceError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "invalid_copy_reference",
                                    "no_permission",
                                    "not_found",
                                    "too_many_files",
                                    "other"];
        deserializer.deserialize_struct("SaveCopyReferenceError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SaveCopyReferenceError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SaveCopyReferenceError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SaveCopyReferenceError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            SaveCopyReferenceError::InvalidCopyReference => {
                // unit
                let mut s = serializer.serialize_struct("SaveCopyReferenceError", 1)?;
                s.serialize_field(".tag", "invalid_copy_reference")?;
                s.end()
            }
            SaveCopyReferenceError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("SaveCopyReferenceError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            SaveCopyReferenceError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("SaveCopyReferenceError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            SaveCopyReferenceError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("SaveCopyReferenceError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            SaveCopyReferenceError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SaveCopyReferenceError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            SaveCopyReferenceError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for SaveCopyReferenceError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SaveCopyReferenceError::Path(inner) => write!(f, "{}", inner),
            SaveCopyReferenceError::InvalidCopyReference => f.write_str("The copy reference is invalid."),
            SaveCopyReferenceError::NoPermission => f.write_str("You don't have permission to save the given copy reference. Please make sure this app is same app which created the copy reference and the source user is still linked to the app."),
            SaveCopyReferenceError::NotFound => f.write_str("The file referenced by the copy reference cannot be found."),
            SaveCopyReferenceError::TooManyFiles => f.write_str("The operation would involve more than 10,000 files and folders."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SaveCopyReferenceResult {
    /// The metadata of the saved file or folder in the user's Dropbox.
    pub metadata: Metadata,
}

impl SaveCopyReferenceResult {
    pub fn new(metadata: Metadata) -> Self {
        SaveCopyReferenceResult {
            metadata,
        }
    }
}

const SAVE_COPY_REFERENCE_RESULT_FIELDS: &[&str] = &["metadata"];
impl SaveCopyReferenceResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SaveCopyReferenceResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SaveCopyReferenceResult>, V::Error> {
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SaveCopyReferenceResult {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SaveCopyReferenceResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SaveCopyReferenceResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveCopyReferenceResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SaveCopyReferenceResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SaveCopyReferenceResult", SAVE_COPY_REFERENCE_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SaveCopyReferenceResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SaveCopyReferenceResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SaveUrlArg {
    /// The path in Dropbox where the URL will be saved to.
    pub path: Path,
    /// The URL to be saved.
    pub url: String,
}

impl SaveUrlArg {
    pub fn new(path: Path, url: String) -> Self {
        SaveUrlArg {
            path,
            url,
        }
    }
}

const SAVE_URL_ARG_FIELDS: &[&str] = &["path",
                                       "url"];
impl SaveUrlArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SaveUrlArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SaveUrlArg>, V::Error> {
        let mut field_path = None;
        let mut field_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SaveUrlArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("url", &self.url)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SaveUrlArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SaveUrlArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveUrlArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SaveUrlArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SaveUrlArg", SAVE_URL_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SaveUrlArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SaveUrlArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SaveUrlError {
    Path(WriteError),
    /// Failed downloading the given URL. The URL may be  password-protected and the password
    /// provided was incorrect,  or the link may be disabled.
    DownloadFailed,
    /// The given URL is invalid.
    InvalidUrl,
    /// The file where the URL is saved to no longer exists.
    NotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SaveUrlError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SaveUrlError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveUrlError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => SaveUrlError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "download_failed" => SaveUrlError::DownloadFailed,
                    "invalid_url" => SaveUrlError::InvalidUrl,
                    "not_found" => SaveUrlError::NotFound,
                    _ => SaveUrlError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "download_failed",
                                    "invalid_url",
                                    "not_found",
                                    "other"];
        deserializer.deserialize_struct("SaveUrlError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SaveUrlError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SaveUrlError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SaveUrlError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            SaveUrlError::DownloadFailed => {
                // unit
                let mut s = serializer.serialize_struct("SaveUrlError", 1)?;
                s.serialize_field(".tag", "download_failed")?;
                s.end()
            }
            SaveUrlError::InvalidUrl => {
                // unit
                let mut s = serializer.serialize_struct("SaveUrlError", 1)?;
                s.serialize_field(".tag", "invalid_url")?;
                s.end()
            }
            SaveUrlError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("SaveUrlError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            SaveUrlError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SaveUrlError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            SaveUrlError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for SaveUrlError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SaveUrlError::Path(inner) => write!(f, "{}", inner),
            SaveUrlError::DownloadFailed => f.write_str("Failed downloading the given URL. The URL may be  password-protected and the password provided was incorrect,  or the link may be disabled."),
            SaveUrlError::InvalidUrl => f.write_str("The given URL is invalid."),
            SaveUrlError::NotFound => f.write_str("The file where the URL is saved to no longer exists."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum SaveUrlJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// Metadata of the file where the URL is saved to.
    Complete(FileMetadata),
    Failed(SaveUrlError),
}

impl<'de> ::serde::de::Deserialize<'de> for SaveUrlJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SaveUrlJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveUrlJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => SaveUrlJobStatus::InProgress,
                    "complete" => SaveUrlJobStatus::Complete(FileMetadata::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => SaveUrlJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("SaveUrlJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SaveUrlJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SaveUrlJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("SaveUrlJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            SaveUrlJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SaveUrlJobStatus", 19)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            SaveUrlJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SaveUrlJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum SaveUrlResult {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    /// Metadata of the file where the URL is saved to.
    Complete(FileMetadata),
}

impl<'de> ::serde::de::Deserialize<'de> for SaveUrlResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SaveUrlResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SaveUrlResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => SaveUrlResult::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => SaveUrlResult::Complete(FileMetadata::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete"];
        deserializer.deserialize_struct("SaveUrlResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SaveUrlResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SaveUrlResult::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("SaveUrlResult", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            SaveUrlResult::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SaveUrlResult", 19)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchArg {
    /// The path in the user's Dropbox to search. Should probably be a folder.
    pub path: PathROrId,
    /// The string to search for. Query string may be rewritten to improve relevance of results. The
    /// string is split on spaces into multiple tokens. For file name searching, the last token is
    /// used for prefix matching (i.e. "bat c" matches "bat cave" but not "batman car").
    pub query: String,
    /// The starting index within the search results (used for paging).
    pub start: u64,
    /// The maximum number of search results to return.
    pub max_results: u64,
    /// The search mode (filename, filename_and_content, or deleted_filename). Note that searching
    /// file content is only available for Dropbox Business accounts.
    pub mode: SearchMode,
}

impl SearchArg {
    pub fn new(path: PathROrId, query: String) -> Self {
        SearchArg {
            path,
            query,
            start: 0,
            max_results: 100,
            mode: SearchMode::Filename,
        }
    }

    pub fn with_start(mut self, value: u64) -> Self {
        self.start = value;
        self
    }

    pub fn with_max_results(mut self, value: u64) -> Self {
        self.max_results = value;
        self
    }

    pub fn with_mode(mut self, value: SearchMode) -> Self {
        self.mode = value;
        self
    }
}

const SEARCH_ARG_FIELDS: &[&str] = &["path",
                                     "query",
                                     "start",
                                     "max_results",
                                     "mode"];
impl SearchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchArg>, V::Error> {
        let mut field_path = None;
        let mut field_query = None;
        let mut field_start = None;
        let mut field_max_results = None;
        let mut field_mode = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "query" => {
                    if field_query.is_some() {
                        return Err(::serde::de::Error::duplicate_field("query"));
                    }
                    field_query = Some(map.next_value()?);
                }
                "start" => {
                    if field_start.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start"));
                    }
                    field_start = Some(map.next_value()?);
                }
                "max_results" => {
                    if field_max_results.is_some() {
                        return Err(::serde::de::Error::duplicate_field("max_results"));
                    }
                    field_max_results = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            query: field_query.ok_or_else(|| ::serde::de::Error::missing_field("query"))?,
            start: field_start.unwrap_or(0),
            max_results: field_max_results.unwrap_or(100),
            mode: field_mode.unwrap_or(SearchMode::Filename),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("query", &self.query)?;
        s.serialize_field("start", &self.start)?;
        s.serialize_field("max_results", &self.max_results)?;
        s.serialize_field("mode", &self.mode)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchArg", SEARCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchArg", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SearchError {
    Path(LookupError),
    InvalidArgument(Option<String>),
    /// Something went wrong, please try again.
    InternalError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SearchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SearchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => SearchError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_argument" => {
                        match map.next_key()? {
                            Some("invalid_argument") => SearchError::InvalidArgument(map.next_value()?),
                            None => SearchError::InvalidArgument(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "internal_error" => SearchError::InternalError,
                    _ => SearchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "invalid_argument",
                                    "internal_error",
                                    "other"];
        deserializer.deserialize_struct("SearchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SearchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SearchError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SearchError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            SearchError::InvalidArgument(ref x) => {
                // nullable (struct or primitive)
                let n = if x.is_some() { 2 } else { 1 };
                let mut s = serializer.serialize_struct("SearchError", n)?;
                s.serialize_field(".tag", "invalid_argument")?;
                if let Some(ref x) = x {
                    s.serialize_field("invalid_argument", &x)?;
                }
                s.end()
            }
            SearchError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("SearchError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            SearchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SearchError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            SearchError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for SearchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SearchError::Path(inner) => write!(f, "{}", inner),
            SearchError::InvalidArgument(None) => f.write_str("invalid_argument"),
            SearchError::InvalidArgument(Some(inner)) => write!(f, "invalid_argument: {:?}", inner),
            SearchError::InternalError => f.write_str("Something went wrong, please try again."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchMatch {
    /// The type of the match.
    pub match_type: SearchMatchType,
    /// The metadata for the matched file or folder.
    pub metadata: Metadata,
}

impl SearchMatch {
    pub fn new(match_type: SearchMatchType, metadata: Metadata) -> Self {
        SearchMatch {
            match_type,
            metadata,
        }
    }
}

const SEARCH_MATCH_FIELDS: &[&str] = &["match_type",
                                       "metadata"];
impl SearchMatch {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchMatch, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchMatch>, V::Error> {
        let mut field_match_type = None;
        let mut field_metadata = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "match_type" => {
                    if field_match_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("match_type"));
                    }
                    field_match_type = Some(map.next_value()?);
                }
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchMatch {
            match_type: field_match_type.ok_or_else(|| ::serde::de::Error::missing_field("match_type"))?,
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("match_type", &self.match_type)?;
        s.serialize_field("metadata", &self.metadata)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMatch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchMatch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMatch struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchMatch::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchMatch", SEARCH_MATCH_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMatch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchMatch", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchMatchFieldOptions {
    /// Whether to include highlight span from file title.
    pub include_highlights: bool,
}

impl Default for SearchMatchFieldOptions {
    fn default() -> Self {
        SearchMatchFieldOptions {
            include_highlights: false,
        }
    }
}

impl SearchMatchFieldOptions {
    pub fn with_include_highlights(mut self, value: bool) -> Self {
        self.include_highlights = value;
        self
    }
}

const SEARCH_MATCH_FIELD_OPTIONS_FIELDS: &[&str] = &["include_highlights"];
impl SearchMatchFieldOptions {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<SearchMatchFieldOptions, V::Error> {
        let mut field_include_highlights = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "include_highlights" => {
                    if field_include_highlights.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_highlights"));
                    }
                    field_include_highlights = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = SearchMatchFieldOptions {
            include_highlights: field_include_highlights.unwrap_or(false),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("include_highlights", &self.include_highlights)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMatchFieldOptions {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchMatchFieldOptions;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMatchFieldOptions struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchMatchFieldOptions::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchMatchFieldOptions", SEARCH_MATCH_FIELD_OPTIONS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMatchFieldOptions {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchMatchFieldOptions", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Indicates what type of match was found for a given item.
#[derive(Debug, Clone, PartialEq)]
pub enum SearchMatchType {
    /// This item was matched on its file or folder name.
    Filename,
    /// This item was matched based on its file contents.
    Content,
    /// This item was matched based on both its contents and its file name.
    Both,
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMatchType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SearchMatchType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMatchType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "filename" => SearchMatchType::Filename,
                    "content" => SearchMatchType::Content,
                    "both" => SearchMatchType::Both,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["filename",
                                    "content",
                                    "both"];
        deserializer.deserialize_struct("SearchMatchType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMatchType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SearchMatchType::Filename => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchType", 1)?;
                s.serialize_field(".tag", "filename")?;
                s.end()
            }
            SearchMatchType::Content => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchType", 1)?;
                s.serialize_field(".tag", "content")?;
                s.end()
            }
            SearchMatchType::Both => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchType", 1)?;
                s.serialize_field(".tag", "both")?;
                s.end()
            }
        }
    }
}

/// Indicates what type of match was found for a given item.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SearchMatchTypeV2 {
    /// This item was matched on its file or folder name.
    Filename,
    /// This item was matched based on its file contents.
    FileContent,
    /// This item was matched based on both its contents and its file name.
    FilenameAndContent,
    /// This item was matched on image content.
    ImageContent,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMatchTypeV2 {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SearchMatchTypeV2;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMatchTypeV2 structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "filename" => SearchMatchTypeV2::Filename,
                    "file_content" => SearchMatchTypeV2::FileContent,
                    "filename_and_content" => SearchMatchTypeV2::FilenameAndContent,
                    "image_content" => SearchMatchTypeV2::ImageContent,
                    _ => SearchMatchTypeV2::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["filename",
                                    "file_content",
                                    "filename_and_content",
                                    "image_content",
                                    "other"];
        deserializer.deserialize_struct("SearchMatchTypeV2", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMatchTypeV2 {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SearchMatchTypeV2::Filename => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchTypeV2", 1)?;
                s.serialize_field(".tag", "filename")?;
                s.end()
            }
            SearchMatchTypeV2::FileContent => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchTypeV2", 1)?;
                s.serialize_field(".tag", "file_content")?;
                s.end()
            }
            SearchMatchTypeV2::FilenameAndContent => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchTypeV2", 1)?;
                s.serialize_field(".tag", "filename_and_content")?;
                s.end()
            }
            SearchMatchTypeV2::ImageContent => {
                // unit
                let mut s = serializer.serialize_struct("SearchMatchTypeV2", 1)?;
                s.serialize_field(".tag", "image_content")?;
                s.end()
            }
            SearchMatchTypeV2::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchMatchV2 {
    /// The metadata for the matched file or folder.
    pub metadata: MetadataV2,
    /// The type of the match.
    pub match_type: Option<SearchMatchTypeV2>,
    /// The list of HighlightSpan determines which parts of the file title should be highlighted.
    pub highlight_spans: Option<Vec<HighlightSpan>>,
}

impl SearchMatchV2 {
    pub fn new(metadata: MetadataV2) -> Self {
        SearchMatchV2 {
            metadata,
            match_type: None,
            highlight_spans: None,
        }
    }

    pub fn with_match_type(mut self, value: SearchMatchTypeV2) -> Self {
        self.match_type = Some(value);
        self
    }

    pub fn with_highlight_spans(mut self, value: Vec<HighlightSpan>) -> Self {
        self.highlight_spans = Some(value);
        self
    }
}

const SEARCH_MATCH_V2_FIELDS: &[&str] = &["metadata",
                                          "match_type",
                                          "highlight_spans"];
impl SearchMatchV2 {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchMatchV2, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchMatchV2>, V::Error> {
        let mut field_metadata = None;
        let mut field_match_type = None;
        let mut field_highlight_spans = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "metadata" => {
                    if field_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("metadata"));
                    }
                    field_metadata = Some(map.next_value()?);
                }
                "match_type" => {
                    if field_match_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("match_type"));
                    }
                    field_match_type = Some(map.next_value()?);
                }
                "highlight_spans" => {
                    if field_highlight_spans.is_some() {
                        return Err(::serde::de::Error::duplicate_field("highlight_spans"));
                    }
                    field_highlight_spans = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchMatchV2 {
            metadata: field_metadata.ok_or_else(|| ::serde::de::Error::missing_field("metadata"))?,
            match_type: field_match_type,
            highlight_spans: field_highlight_spans,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("metadata", &self.metadata)?;
        if let Some(val) = &self.match_type {
            s.serialize_field("match_type", val)?;
        }
        if let Some(val) = &self.highlight_spans {
            s.serialize_field("highlight_spans", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMatchV2 {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchMatchV2;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMatchV2 struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchMatchV2::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchMatchV2", SEARCH_MATCH_V2_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMatchV2 {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchMatchV2", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum SearchMode {
    /// Search file and folder names.
    Filename,
    /// Search file and folder names as well as file contents.
    FilenameAndContent,
    /// Search for deleted file and folder names.
    DeletedFilename,
}

impl<'de> ::serde::de::Deserialize<'de> for SearchMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SearchMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "filename" => SearchMode::Filename,
                    "filename_and_content" => SearchMode::FilenameAndContent,
                    "deleted_filename" => SearchMode::DeletedFilename,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["filename",
                                    "filename_and_content",
                                    "deleted_filename"];
        deserializer.deserialize_struct("SearchMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SearchMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SearchMode::Filename => {
                // unit
                let mut s = serializer.serialize_struct("SearchMode", 1)?;
                s.serialize_field(".tag", "filename")?;
                s.end()
            }
            SearchMode::FilenameAndContent => {
                // unit
                let mut s = serializer.serialize_struct("SearchMode", 1)?;
                s.serialize_field(".tag", "filename_and_content")?;
                s.end()
            }
            SearchMode::DeletedFilename => {
                // unit
                let mut s = serializer.serialize_struct("SearchMode", 1)?;
                s.serialize_field(".tag", "deleted_filename")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchOptions {
    /// Scopes the search to a path in the user's Dropbox. Searches the entire Dropbox if not
    /// specified.
    pub path: Option<PathROrId>,
    /// The maximum number of search results to return.
    pub max_results: u64,
    /// Specified property of the order of search results. By default, results are sorted by
    /// relevance.
    pub order_by: Option<SearchOrderBy>,
    /// Restricts search to the given file status.
    pub file_status: FileStatus,
    /// Restricts search to only match on filenames.
    pub filename_only: bool,
    /// Restricts search to only the extensions specified. Only supported for active file search.
    pub file_extensions: Option<Vec<String>>,
    /// Restricts search to only the file categories specified. Only supported for active file
    /// search.
    pub file_categories: Option<Vec<FileCategory>>,
}

impl Default for SearchOptions {
    fn default() -> Self {
        SearchOptions {
            path: None,
            max_results: 100,
            order_by: None,
            file_status: FileStatus::Active,
            filename_only: false,
            file_extensions: None,
            file_categories: None,
        }
    }
}

impl SearchOptions {
    pub fn with_path(mut self, value: PathROrId) -> Self {
        self.path = Some(value);
        self
    }

    pub fn with_max_results(mut self, value: u64) -> Self {
        self.max_results = value;
        self
    }

    pub fn with_order_by(mut self, value: SearchOrderBy) -> Self {
        self.order_by = Some(value);
        self
    }

    pub fn with_file_status(mut self, value: FileStatus) -> Self {
        self.file_status = value;
        self
    }

    pub fn with_filename_only(mut self, value: bool) -> Self {
        self.filename_only = value;
        self
    }

    pub fn with_file_extensions(mut self, value: Vec<String>) -> Self {
        self.file_extensions = Some(value);
        self
    }

    pub fn with_file_categories(mut self, value: Vec<FileCategory>) -> Self {
        self.file_categories = Some(value);
        self
    }
}

const SEARCH_OPTIONS_FIELDS: &[&str] = &["path",
                                         "max_results",
                                         "order_by",
                                         "file_status",
                                         "filename_only",
                                         "file_extensions",
                                         "file_categories"];
impl SearchOptions {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<SearchOptions, V::Error> {
        let mut field_path = None;
        let mut field_max_results = None;
        let mut field_order_by = None;
        let mut field_file_status = None;
        let mut field_filename_only = None;
        let mut field_file_extensions = None;
        let mut field_file_categories = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "max_results" => {
                    if field_max_results.is_some() {
                        return Err(::serde::de::Error::duplicate_field("max_results"));
                    }
                    field_max_results = Some(map.next_value()?);
                }
                "order_by" => {
                    if field_order_by.is_some() {
                        return Err(::serde::de::Error::duplicate_field("order_by"));
                    }
                    field_order_by = Some(map.next_value()?);
                }
                "file_status" => {
                    if field_file_status.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_status"));
                    }
                    field_file_status = Some(map.next_value()?);
                }
                "filename_only" => {
                    if field_filename_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("filename_only"));
                    }
                    field_filename_only = Some(map.next_value()?);
                }
                "file_extensions" => {
                    if field_file_extensions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_extensions"));
                    }
                    field_file_extensions = Some(map.next_value()?);
                }
                "file_categories" => {
                    if field_file_categories.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_categories"));
                    }
                    field_file_categories = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = SearchOptions {
            path: field_path,
            max_results: field_max_results.unwrap_or(100),
            order_by: field_order_by,
            file_status: field_file_status.unwrap_or(FileStatus::Active),
            filename_only: field_filename_only.unwrap_or(false),
            file_extensions: field_file_extensions,
            file_categories: field_file_categories,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.path {
            s.serialize_field("path", val)?;
        }
        s.serialize_field("max_results", &self.max_results)?;
        if let Some(val) = &self.order_by {
            s.serialize_field("order_by", val)?;
        }
        s.serialize_field("file_status", &self.file_status)?;
        s.serialize_field("filename_only", &self.filename_only)?;
        if let Some(val) = &self.file_extensions {
            s.serialize_field("file_extensions", val)?;
        }
        if let Some(val) = &self.file_categories {
            s.serialize_field("file_categories", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchOptions {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchOptions;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchOptions struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchOptions::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchOptions", SEARCH_OPTIONS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchOptions {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchOptions", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SearchOrderBy {
    Relevance,
    LastModifiedTime,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SearchOrderBy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SearchOrderBy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchOrderBy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "relevance" => SearchOrderBy::Relevance,
                    "last_modified_time" => SearchOrderBy::LastModifiedTime,
                    _ => SearchOrderBy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["relevance",
                                    "last_modified_time",
                                    "other"];
        deserializer.deserialize_struct("SearchOrderBy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SearchOrderBy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SearchOrderBy::Relevance => {
                // unit
                let mut s = serializer.serialize_struct("SearchOrderBy", 1)?;
                s.serialize_field(".tag", "relevance")?;
                s.end()
            }
            SearchOrderBy::LastModifiedTime => {
                // unit
                let mut s = serializer.serialize_struct("SearchOrderBy", 1)?;
                s.serialize_field(".tag", "last_modified_time")?;
                s.end()
            }
            SearchOrderBy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchResult {
    /// A list (possibly empty) of matches for the query.
    pub matches: Vec<SearchMatch>,
    /// Used for paging. If true, indicates there is another page of results available that can be
    /// fetched by calling [`search()`](search) again.
    pub more: bool,
    /// Used for paging. Value to set the start argument to when calling [`search()`](search) to
    /// fetch the next page of results.
    pub start: u64,
}

impl SearchResult {
    pub fn new(matches: Vec<SearchMatch>, more: bool, start: u64) -> Self {
        SearchResult {
            matches,
            more,
            start,
        }
    }
}

const SEARCH_RESULT_FIELDS: &[&str] = &["matches",
                                        "more",
                                        "start"];
impl SearchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchResult>, V::Error> {
        let mut field_matches = None;
        let mut field_more = None;
        let mut field_start = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "matches" => {
                    if field_matches.is_some() {
                        return Err(::serde::de::Error::duplicate_field("matches"));
                    }
                    field_matches = Some(map.next_value()?);
                }
                "more" => {
                    if field_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("more"));
                    }
                    field_more = Some(map.next_value()?);
                }
                "start" => {
                    if field_start.is_some() {
                        return Err(::serde::de::Error::duplicate_field("start"));
                    }
                    field_start = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchResult {
            matches: field_matches.ok_or_else(|| ::serde::de::Error::missing_field("matches"))?,
            more: field_more.ok_or_else(|| ::serde::de::Error::missing_field("more"))?,
            start: field_start.ok_or_else(|| ::serde::de::Error::missing_field("start"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("matches", &self.matches)?;
        s.serialize_field("more", &self.more)?;
        s.serialize_field("start", &self.start)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchResult", SEARCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchV2Arg {
    /// The string to search for. May match across multiple fields based on the request arguments.
    pub query: String,
    /// Options for more targeted search results.
    pub options: Option<SearchOptions>,
    /// Options for search results match fields.
    pub match_field_options: Option<SearchMatchFieldOptions>,
    /// Deprecated and moved this option to SearchMatchFieldOptions.
    pub include_highlights: Option<bool>,
}

impl SearchV2Arg {
    pub fn new(query: String) -> Self {
        SearchV2Arg {
            query,
            options: None,
            match_field_options: None,
            include_highlights: None,
        }
    }

    pub fn with_options(mut self, value: SearchOptions) -> Self {
        self.options = Some(value);
        self
    }

    pub fn with_match_field_options(mut self, value: SearchMatchFieldOptions) -> Self {
        self.match_field_options = Some(value);
        self
    }

    pub fn with_include_highlights(mut self, value: bool) -> Self {
        self.include_highlights = Some(value);
        self
    }
}

const SEARCH_V2_ARG_FIELDS: &[&str] = &["query",
                                        "options",
                                        "match_field_options",
                                        "include_highlights"];
impl SearchV2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchV2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchV2Arg>, V::Error> {
        let mut field_query = None;
        let mut field_options = None;
        let mut field_match_field_options = None;
        let mut field_include_highlights = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "query" => {
                    if field_query.is_some() {
                        return Err(::serde::de::Error::duplicate_field("query"));
                    }
                    field_query = Some(map.next_value()?);
                }
                "options" => {
                    if field_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("options"));
                    }
                    field_options = Some(map.next_value()?);
                }
                "match_field_options" => {
                    if field_match_field_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("match_field_options"));
                    }
                    field_match_field_options = Some(map.next_value()?);
                }
                "include_highlights" => {
                    if field_include_highlights.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_highlights"));
                    }
                    field_include_highlights = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchV2Arg {
            query: field_query.ok_or_else(|| ::serde::de::Error::missing_field("query"))?,
            options: field_options,
            match_field_options: field_match_field_options,
            include_highlights: field_include_highlights,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("query", &self.query)?;
        if let Some(val) = &self.options {
            s.serialize_field("options", val)?;
        }
        if let Some(val) = &self.match_field_options {
            s.serialize_field("match_field_options", val)?;
        }
        if let Some(val) = &self.include_highlights {
            s.serialize_field("include_highlights", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchV2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchV2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchV2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchV2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchV2Arg", SEARCH_V2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchV2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchV2Arg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchV2ContinueArg {
    /// The cursor returned by your last call to [`search_v2()`](search_v2). Used to fetch the next
    /// page of results.
    pub cursor: SearchV2Cursor,
}

impl SearchV2ContinueArg {
    pub fn new(cursor: SearchV2Cursor) -> Self {
        SearchV2ContinueArg {
            cursor,
        }
    }
}

const SEARCH_V2_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl SearchV2ContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchV2ContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchV2ContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchV2ContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchV2ContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchV2ContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchV2ContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchV2ContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchV2ContinueArg", SEARCH_V2_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchV2ContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchV2ContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SearchV2Result {
    /// A list (possibly empty) of matches for the query.
    pub matches: Vec<SearchMatchV2>,
    /// Used for paging. If true, indicates there is another page of results available that can be
    /// fetched by calling [`search_continue_v2()`](search_continue_v2) with the cursor.
    pub has_more: bool,
    /// Pass the cursor into [`search_continue_v2()`](search_continue_v2) to fetch the next page of
    /// results.
    pub cursor: Option<SearchV2Cursor>,
}

impl SearchV2Result {
    pub fn new(matches: Vec<SearchMatchV2>, has_more: bool) -> Self {
        SearchV2Result {
            matches,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: SearchV2Cursor) -> Self {
        self.cursor = Some(value);
        self
    }
}

const SEARCH_V2_RESULT_FIELDS: &[&str] = &["matches",
                                           "has_more",
                                           "cursor"];
impl SearchV2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SearchV2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SearchV2Result>, V::Error> {
        let mut field_matches = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "matches" => {
                    if field_matches.is_some() {
                        return Err(::serde::de::Error::duplicate_field("matches"));
                    }
                    field_matches = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SearchV2Result {
            matches: field_matches.ok_or_else(|| ::serde::de::Error::missing_field("matches"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("matches", &self.matches)?;
        s.serialize_field("has_more", &self.has_more)?;
        if let Some(val) = &self.cursor {
            s.serialize_field("cursor", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SearchV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SearchV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SearchV2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SearchV2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SearchV2Result", SEARCH_V2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SearchV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SearchV2Result", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedLink {
    /// Shared link url.
    pub url: SharedLinkUrl,
    /// Password for the shared link.
    pub password: Option<String>,
}

impl SharedLink {
    pub fn new(url: SharedLinkUrl) -> Self {
        SharedLink {
            url,
            password: None,
        }
    }

    pub fn with_password(mut self, value: String) -> Self {
        self.password = Some(value);
        self
    }
}

const SHARED_LINK_FIELDS: &[&str] = &["url",
                                      "password"];
impl SharedLink {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedLink, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedLink>, V::Error> {
        let mut field_url = None;
        let mut field_password = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "password" => {
                    if field_password.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password"));
                    }
                    field_password = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedLink {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            password: field_password,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        if let Some(val) = &self.password {
            s.serialize_field("password", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLink {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedLink;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLink struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedLink::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedLink", SHARED_LINK_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLink {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedLink", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedLinkFileInfo {
    /// The shared link corresponding to either a file or shared link to a folder. If it is for a
    /// folder shared link, we use the path param to determine for which file in the folder the view
    /// is for.
    pub url: String,
    /// The path corresponding to a file in a shared link to a folder. Required for shared links to
    /// folders.
    pub path: Option<String>,
    /// Password for the shared link. Required for password-protected shared links to files  unless
    /// it can be read from a cookie.
    pub password: Option<String>,
}

impl SharedLinkFileInfo {
    pub fn new(url: String) -> Self {
        SharedLinkFileInfo {
            url,
            path: None,
            password: None,
        }
    }

    pub fn with_path(mut self, value: String) -> Self {
        self.path = Some(value);
        self
    }

    pub fn with_password(mut self, value: String) -> Self {
        self.password = Some(value);
        self
    }
}

const SHARED_LINK_FILE_INFO_FIELDS: &[&str] = &["url",
                                                "path",
                                                "password"];
impl SharedLinkFileInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedLinkFileInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedLinkFileInfo>, V::Error> {
        let mut field_url = None;
        let mut field_path = None;
        let mut field_password = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "password" => {
                    if field_password.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password"));
                    }
                    field_password = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedLinkFileInfo {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            path: field_path,
            password: field_password,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        if let Some(val) = &self.path {
            s.serialize_field("path", val)?;
        }
        if let Some(val) = &self.password {
            s.serialize_field("password", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkFileInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedLinkFileInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkFileInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedLinkFileInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedLinkFileInfo", SHARED_LINK_FILE_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkFileInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedLinkFileInfo", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sharing info for a file or folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharingInfo {
    /// True if the file or folder is inside a read-only shared folder.
    pub read_only: bool,
}

impl SharingInfo {
    pub fn new(read_only: bool) -> Self {
        SharingInfo {
            read_only,
        }
    }
}

const SHARING_INFO_FIELDS: &[&str] = &["read_only"];
impl SharingInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharingInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharingInfo>, V::Error> {
        let mut field_read_only = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "read_only" => {
                    if field_read_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("read_only"));
                    }
                    field_read_only = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharingInfo {
            read_only: field_read_only.ok_or_else(|| ::serde::de::Error::missing_field("read_only"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("read_only", &self.read_only)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharingInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharingInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharingInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharingInfo", SHARING_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharingInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharingInfo", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SingleUserLock {
    /// The time the lock was created.
    pub created: super::common::DropboxTimestamp,
    /// The account ID of the lock holder if known.
    pub lock_holder_account_id: super::users_common::AccountId,
    /// The id of the team of the account holder if it exists.
    pub lock_holder_team_id: Option<String>,
}

impl SingleUserLock {
    pub fn new(
        created: super::common::DropboxTimestamp,
        lock_holder_account_id: super::users_common::AccountId,
    ) -> Self {
        SingleUserLock {
            created,
            lock_holder_account_id,
            lock_holder_team_id: None,
        }
    }

    pub fn with_lock_holder_team_id(mut self, value: String) -> Self {
        self.lock_holder_team_id = Some(value);
        self
    }
}

const SINGLE_USER_LOCK_FIELDS: &[&str] = &["created",
                                           "lock_holder_account_id",
                                           "lock_holder_team_id"];
impl SingleUserLock {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SingleUserLock, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SingleUserLock>, V::Error> {
        let mut field_created = None;
        let mut field_lock_holder_account_id = None;
        let mut field_lock_holder_team_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "lock_holder_account_id" => {
                    if field_lock_holder_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lock_holder_account_id"));
                    }
                    field_lock_holder_account_id = Some(map.next_value()?);
                }
                "lock_holder_team_id" => {
                    if field_lock_holder_team_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("lock_holder_team_id"));
                    }
                    field_lock_holder_team_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SingleUserLock {
            created: field_created.ok_or_else(|| ::serde::de::Error::missing_field("created"))?,
            lock_holder_account_id: field_lock_holder_account_id.ok_or_else(|| ::serde::de::Error::missing_field("lock_holder_account_id"))?,
            lock_holder_team_id: field_lock_holder_team_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("created", &self.created)?;
        s.serialize_field("lock_holder_account_id", &self.lock_holder_account_id)?;
        if let Some(val) = &self.lock_holder_team_id {
            s.serialize_field("lock_holder_team_id", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SingleUserLock {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SingleUserLock;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SingleUserLock struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SingleUserLock::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SingleUserLock", SINGLE_USER_LOCK_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SingleUserLock {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SingleUserLock", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SymlinkInfo {
    /// The target this symlink points to.
    pub target: String,
}

impl SymlinkInfo {
    pub fn new(target: String) -> Self {
        SymlinkInfo {
            target,
        }
    }
}

const SYMLINK_INFO_FIELDS: &[&str] = &["target"];
impl SymlinkInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SymlinkInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SymlinkInfo>, V::Error> {
        let mut field_target = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "target" => {
                    if field_target.is_some() {
                        return Err(::serde::de::Error::duplicate_field("target"));
                    }
                    field_target = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SymlinkInfo {
            target: field_target.ok_or_else(|| ::serde::de::Error::missing_field("target"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("target", &self.target)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SymlinkInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SymlinkInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SymlinkInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SymlinkInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SymlinkInfo", SYMLINK_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SymlinkInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SymlinkInfo", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SyncSetting {
    /// On first sync to members' computers, the specified folder will follow its parent folder's
    /// setting or otherwise follow default sync behavior.
    Default,
    /// On first sync to members' computers, the specified folder will be set to not sync with
    /// selective sync.
    NotSynced,
    /// The specified folder's not_synced setting is inactive due to its location or other
    /// configuration changes. It will follow its parent folder's setting.
    NotSyncedInactive,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SyncSetting {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SyncSetting;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SyncSetting structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default" => SyncSetting::Default,
                    "not_synced" => SyncSetting::NotSynced,
                    "not_synced_inactive" => SyncSetting::NotSyncedInactive,
                    _ => SyncSetting::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default",
                                    "not_synced",
                                    "not_synced_inactive",
                                    "other"];
        deserializer.deserialize_struct("SyncSetting", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SyncSetting {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SyncSetting::Default => {
                // unit
                let mut s = serializer.serialize_struct("SyncSetting", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            SyncSetting::NotSynced => {
                // unit
                let mut s = serializer.serialize_struct("SyncSetting", 1)?;
                s.serialize_field(".tag", "not_synced")?;
                s.end()
            }
            SyncSetting::NotSyncedInactive => {
                // unit
                let mut s = serializer.serialize_struct("SyncSetting", 1)?;
                s.serialize_field(".tag", "not_synced_inactive")?;
                s.end()
            }
            SyncSetting::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SyncSettingArg {
    /// On first sync to members' computers, the specified folder will follow its parent folder's
    /// setting or otherwise follow default sync behavior.
    Default,
    /// On first sync to members' computers, the specified folder will be set to not sync with
    /// selective sync.
    NotSynced,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SyncSettingArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SyncSettingArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SyncSettingArg structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default" => SyncSettingArg::Default,
                    "not_synced" => SyncSettingArg::NotSynced,
                    _ => SyncSettingArg::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default",
                                    "not_synced",
                                    "other"];
        deserializer.deserialize_struct("SyncSettingArg", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SyncSettingArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SyncSettingArg::Default => {
                // unit
                let mut s = serializer.serialize_struct("SyncSettingArg", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            SyncSettingArg::NotSynced => {
                // unit
                let mut s = serializer.serialize_struct("SyncSettingArg", 1)?;
                s.serialize_field(".tag", "not_synced")?;
                s.end()
            }
            SyncSettingArg::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SyncSettingsError {
    Path(LookupError),
    /// Setting this combination of sync settings simultaneously is not supported.
    UnsupportedCombination,
    /// The specified configuration is not supported.
    UnsupportedConfiguration,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SyncSettingsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SyncSettingsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SyncSettingsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => SyncSettingsError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unsupported_combination" => SyncSettingsError::UnsupportedCombination,
                    "unsupported_configuration" => SyncSettingsError::UnsupportedConfiguration,
                    _ => SyncSettingsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "unsupported_combination",
                                    "unsupported_configuration",
                                    "other"];
        deserializer.deserialize_struct("SyncSettingsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SyncSettingsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SyncSettingsError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SyncSettingsError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            SyncSettingsError::UnsupportedCombination => {
                // unit
                let mut s = serializer.serialize_struct("SyncSettingsError", 1)?;
                s.serialize_field(".tag", "unsupported_combination")?;
                s.end()
            }
            SyncSettingsError::UnsupportedConfiguration => {
                // unit
                let mut s = serializer.serialize_struct("SyncSettingsError", 1)?;
                s.serialize_field(".tag", "unsupported_configuration")?;
                s.end()
            }
            SyncSettingsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SyncSettingsError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            SyncSettingsError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for SyncSettingsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SyncSettingsError::Path(inner) => write!(f, "{}", inner),
            SyncSettingsError::UnsupportedCombination => f.write_str("Setting this combination of sync settings simultaneously is not supported."),
            SyncSettingsError::UnsupportedConfiguration => f.write_str("The specified configuration is not supported."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ThumbnailArg {
    /// The path to the image file you want to thumbnail.
    pub path: ReadPath,
    /// The format for the thumbnail image, jpeg (default) or png. For  images that are photos, jpeg
    /// should be preferred, while png is  better for screenshots and digital arts.
    pub format: ThumbnailFormat,
    /// The size for the thumbnail image.
    pub size: ThumbnailSize,
    /// How to resize and crop the image to achieve the desired size.
    pub mode: ThumbnailMode,
}

impl ThumbnailArg {
    pub fn new(path: ReadPath) -> Self {
        ThumbnailArg {
            path,
            format: ThumbnailFormat::Jpeg,
            size: ThumbnailSize::W64h64,
            mode: ThumbnailMode::Strict,
        }
    }

    pub fn with_format(mut self, value: ThumbnailFormat) -> Self {
        self.format = value;
        self
    }

    pub fn with_size(mut self, value: ThumbnailSize) -> Self {
        self.size = value;
        self
    }

    pub fn with_mode(mut self, value: ThumbnailMode) -> Self {
        self.mode = value;
        self
    }
}

const THUMBNAIL_ARG_FIELDS: &[&str] = &["path",
                                        "format",
                                        "size",
                                        "mode"];
impl ThumbnailArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ThumbnailArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ThumbnailArg>, V::Error> {
        let mut field_path = None;
        let mut field_format = None;
        let mut field_size = None;
        let mut field_mode = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "format" => {
                    if field_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("format"));
                    }
                    field_format = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ThumbnailArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            format: field_format.unwrap_or(ThumbnailFormat::Jpeg),
            size: field_size.unwrap_or(ThumbnailSize::W64h64),
            mode: field_mode.unwrap_or(ThumbnailMode::Strict),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("format", &self.format)?;
        s.serialize_field("size", &self.size)?;
        s.serialize_field("mode", &self.mode)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ThumbnailArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ThumbnailArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ThumbnailArg", THUMBNAIL_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ThumbnailArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ThumbnailError {
    /// An error occurs when downloading metadata for the image.
    Path(LookupError),
    /// The file extension doesn't allow conversion to a thumbnail.
    UnsupportedExtension,
    /// The image cannot be converted to a thumbnail.
    UnsupportedImage,
    /// An error occurs during thumbnail conversion.
    ConversionError,
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ThumbnailError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ThumbnailError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unsupported_extension" => ThumbnailError::UnsupportedExtension,
                    "unsupported_image" => ThumbnailError::UnsupportedImage,
                    "conversion_error" => ThumbnailError::ConversionError,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "unsupported_extension",
                                    "unsupported_image",
                                    "conversion_error"];
        deserializer.deserialize_struct("ThumbnailError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ThumbnailError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ThumbnailError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ThumbnailError::UnsupportedExtension => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailError", 1)?;
                s.serialize_field(".tag", "unsupported_extension")?;
                s.end()
            }
            ThumbnailError::UnsupportedImage => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailError", 1)?;
                s.serialize_field(".tag", "unsupported_image")?;
                s.end()
            }
            ThumbnailError::ConversionError => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailError", 1)?;
                s.serialize_field(".tag", "conversion_error")?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for ThumbnailError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ThumbnailError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ThumbnailError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ThumbnailError::Path(inner) => write!(f, "An error occurs when downloading metadata for the image: {}", inner),
            ThumbnailError::UnsupportedExtension => f.write_str("The file extension doesn't allow conversion to a thumbnail."),
            ThumbnailError::UnsupportedImage => f.write_str("The image cannot be converted to a thumbnail."),
            ThumbnailError::ConversionError => f.write_str("An error occurs during thumbnail conversion."),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ThumbnailFormat {
    Jpeg,
    Png,
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailFormat {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ThumbnailFormat;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailFormat structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "jpeg" => ThumbnailFormat::Jpeg,
                    "png" => ThumbnailFormat::Png,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["jpeg",
                                    "png"];
        deserializer.deserialize_struct("ThumbnailFormat", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailFormat {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ThumbnailFormat::Jpeg => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailFormat", 1)?;
                s.serialize_field(".tag", "jpeg")?;
                s.end()
            }
            ThumbnailFormat::Png => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailFormat", 1)?;
                s.serialize_field(".tag", "png")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ThumbnailMode {
    /// Scale down the image to fit within the given size.
    Strict,
    /// Scale down the image to fit within the given size or its transpose.
    Bestfit,
    /// Scale down the image to completely cover the given size or its transpose.
    FitoneBestfit,
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ThumbnailMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "strict" => ThumbnailMode::Strict,
                    "bestfit" => ThumbnailMode::Bestfit,
                    "fitone_bestfit" => ThumbnailMode::FitoneBestfit,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["strict",
                                    "bestfit",
                                    "fitone_bestfit"];
        deserializer.deserialize_struct("ThumbnailMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ThumbnailMode::Strict => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailMode", 1)?;
                s.serialize_field(".tag", "strict")?;
                s.end()
            }
            ThumbnailMode::Bestfit => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailMode", 1)?;
                s.serialize_field(".tag", "bestfit")?;
                s.end()
            }
            ThumbnailMode::FitoneBestfit => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailMode", 1)?;
                s.serialize_field(".tag", "fitone_bestfit")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ThumbnailSize {
    /// 32 by 32 px.
    W32h32,
    /// 64 by 64 px.
    W64h64,
    /// 128 by 128 px.
    W128h128,
    /// 256 by 256 px.
    W256h256,
    /// 480 by 320 px.
    W480h320,
    /// 640 by 480 px.
    W640h480,
    /// 960 by 640 px.
    W960h640,
    /// 1024 by 768 px.
    W1024h768,
    /// 2048 by 1536 px.
    W2048h1536,
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailSize {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ThumbnailSize;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailSize structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "w32h32" => ThumbnailSize::W32h32,
                    "w64h64" => ThumbnailSize::W64h64,
                    "w128h128" => ThumbnailSize::W128h128,
                    "w256h256" => ThumbnailSize::W256h256,
                    "w480h320" => ThumbnailSize::W480h320,
                    "w640h480" => ThumbnailSize::W640h480,
                    "w960h640" => ThumbnailSize::W960h640,
                    "w1024h768" => ThumbnailSize::W1024h768,
                    "w2048h1536" => ThumbnailSize::W2048h1536,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["w32h32",
                                    "w64h64",
                                    "w128h128",
                                    "w256h256",
                                    "w480h320",
                                    "w640h480",
                                    "w960h640",
                                    "w1024h768",
                                    "w2048h1536"];
        deserializer.deserialize_struct("ThumbnailSize", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailSize {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ThumbnailSize::W32h32 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w32h32")?;
                s.end()
            }
            ThumbnailSize::W64h64 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w64h64")?;
                s.end()
            }
            ThumbnailSize::W128h128 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w128h128")?;
                s.end()
            }
            ThumbnailSize::W256h256 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w256h256")?;
                s.end()
            }
            ThumbnailSize::W480h320 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w480h320")?;
                s.end()
            }
            ThumbnailSize::W640h480 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w640h480")?;
                s.end()
            }
            ThumbnailSize::W960h640 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w960h640")?;
                s.end()
            }
            ThumbnailSize::W1024h768 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w1024h768")?;
                s.end()
            }
            ThumbnailSize::W2048h1536 => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailSize", 1)?;
                s.serialize_field(".tag", "w2048h1536")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ThumbnailV2Arg {
    /// Information specifying which file to preview. This could be a path to a file, a shared link
    /// pointing to a file, or a shared link pointing to a folder, with a relative path.
    pub resource: PathOrLink,
    /// The format for the thumbnail image, jpeg (default) or png. For  images that are photos, jpeg
    /// should be preferred, while png is  better for screenshots and digital arts.
    pub format: ThumbnailFormat,
    /// The size for the thumbnail image.
    pub size: ThumbnailSize,
    /// How to resize and crop the image to achieve the desired size.
    pub mode: ThumbnailMode,
}

impl ThumbnailV2Arg {
    pub fn new(resource: PathOrLink) -> Self {
        ThumbnailV2Arg {
            resource,
            format: ThumbnailFormat::Jpeg,
            size: ThumbnailSize::W64h64,
            mode: ThumbnailMode::Strict,
        }
    }

    pub fn with_format(mut self, value: ThumbnailFormat) -> Self {
        self.format = value;
        self
    }

    pub fn with_size(mut self, value: ThumbnailSize) -> Self {
        self.size = value;
        self
    }

    pub fn with_mode(mut self, value: ThumbnailMode) -> Self {
        self.mode = value;
        self
    }
}

const THUMBNAIL_V2_ARG_FIELDS: &[&str] = &["resource",
                                           "format",
                                           "size",
                                           "mode"];
impl ThumbnailV2Arg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ThumbnailV2Arg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ThumbnailV2Arg>, V::Error> {
        let mut field_resource = None;
        let mut field_format = None;
        let mut field_size = None;
        let mut field_mode = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "resource" => {
                    if field_resource.is_some() {
                        return Err(::serde::de::Error::duplicate_field("resource"));
                    }
                    field_resource = Some(map.next_value()?);
                }
                "format" => {
                    if field_format.is_some() {
                        return Err(::serde::de::Error::duplicate_field("format"));
                    }
                    field_format = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "mode" => {
                    if field_mode.is_some() {
                        return Err(::serde::de::Error::duplicate_field("mode"));
                    }
                    field_mode = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ThumbnailV2Arg {
            resource: field_resource.ok_or_else(|| ::serde::de::Error::missing_field("resource"))?,
            format: field_format.unwrap_or(ThumbnailFormat::Jpeg),
            size: field_size.unwrap_or(ThumbnailSize::W64h64),
            mode: field_mode.unwrap_or(ThumbnailMode::Strict),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("resource", &self.resource)?;
        s.serialize_field("format", &self.format)?;
        s.serialize_field("size", &self.size)?;
        s.serialize_field("mode", &self.mode)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailV2Arg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ThumbnailV2Arg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailV2Arg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ThumbnailV2Arg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ThumbnailV2Arg", THUMBNAIL_V2_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailV2Arg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ThumbnailV2Arg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ThumbnailV2Error {
    /// An error occurred when downloading metadata for the image.
    Path(LookupError),
    /// The file extension doesn't allow conversion to a thumbnail.
    UnsupportedExtension,
    /// The image cannot be converted to a thumbnail.
    UnsupportedImage,
    /// An error occurred during thumbnail conversion.
    ConversionError,
    /// Access to this shared link is forbidden.
    AccessDenied,
    /// The shared link does not exist.
    NotFound,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ThumbnailV2Error {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ThumbnailV2Error;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ThumbnailV2Error structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ThumbnailV2Error::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unsupported_extension" => ThumbnailV2Error::UnsupportedExtension,
                    "unsupported_image" => ThumbnailV2Error::UnsupportedImage,
                    "conversion_error" => ThumbnailV2Error::ConversionError,
                    "access_denied" => ThumbnailV2Error::AccessDenied,
                    "not_found" => ThumbnailV2Error::NotFound,
                    _ => ThumbnailV2Error::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "unsupported_extension",
                                    "unsupported_image",
                                    "conversion_error",
                                    "access_denied",
                                    "not_found",
                                    "other"];
        deserializer.deserialize_struct("ThumbnailV2Error", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ThumbnailV2Error {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ThumbnailV2Error::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ThumbnailV2Error::UnsupportedExtension => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 1)?;
                s.serialize_field(".tag", "unsupported_extension")?;
                s.end()
            }
            ThumbnailV2Error::UnsupportedImage => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 1)?;
                s.serialize_field(".tag", "unsupported_image")?;
                s.end()
            }
            ThumbnailV2Error::ConversionError => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 1)?;
                s.serialize_field(".tag", "conversion_error")?;
                s.end()
            }
            ThumbnailV2Error::AccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 1)?;
                s.serialize_field(".tag", "access_denied")?;
                s.end()
            }
            ThumbnailV2Error::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("ThumbnailV2Error", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            ThumbnailV2Error::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ThumbnailV2Error {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ThumbnailV2Error::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ThumbnailV2Error {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ThumbnailV2Error::Path(inner) => write!(f, "An error occurred when downloading metadata for the image: {}", inner),
            ThumbnailV2Error::UnsupportedExtension => f.write_str("The file extension doesn't allow conversion to a thumbnail."),
            ThumbnailV2Error::UnsupportedImage => f.write_str("The image cannot be converted to a thumbnail."),
            ThumbnailV2Error::ConversionError => f.write_str("An error occurred during thumbnail conversion."),
            ThumbnailV2Error::AccessDenied => f.write_str("Access to this shared link is forbidden."),
            ThumbnailV2Error::NotFound => f.write_str("The shared link does not exist."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UnlockFileArg {
    /// Path in the user's Dropbox to a file.
    pub path: WritePathOrId,
}

impl UnlockFileArg {
    pub fn new(path: WritePathOrId) -> Self {
        UnlockFileArg {
            path,
        }
    }
}

const UNLOCK_FILE_ARG_FIELDS: &[&str] = &["path"];
impl UnlockFileArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UnlockFileArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UnlockFileArg>, V::Error> {
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UnlockFileArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UnlockFileArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UnlockFileArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnlockFileArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UnlockFileArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UnlockFileArg", UNLOCK_FILE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UnlockFileArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UnlockFileArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UnlockFileBatchArg {
    /// List of 'entries'. Each 'entry' contains a path of the file which will be unlocked.
    /// Duplicate path arguments in the batch are considered only once.
    pub entries: Vec<UnlockFileArg>,
}

impl UnlockFileBatchArg {
    pub fn new(entries: Vec<UnlockFileArg>) -> Self {
        UnlockFileBatchArg {
            entries,
        }
    }
}

const UNLOCK_FILE_BATCH_ARG_FIELDS: &[&str] = &["entries"];
impl UnlockFileBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UnlockFileBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UnlockFileBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UnlockFileBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UnlockFileBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UnlockFileBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnlockFileBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UnlockFileBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UnlockFileBatchArg", UNLOCK_FILE_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UnlockFileBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UnlockFileBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadError {
    /// Unable to save the uploaded contents to a file.
    Path(UploadWriteFailed),
    /// The supplied property group is invalid. The file has uploaded without property groups.
    PropertiesError(super::file_properties::InvalidPropertyGroupError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => UploadError::Path(UploadWriteFailed::internal_deserialize(&mut map)?),
                    "properties_error" => {
                        match map.next_key()? {
                            Some("properties_error") => UploadError::PropertiesError(map.next_value()?),
                            None => return Err(de::Error::missing_field("properties_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => UploadError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "properties_error",
                                    "other"];
        deserializer.deserialize_struct("UploadError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadError::Path(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadError", 3)?;
                s.serialize_field(".tag", "path")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            UploadError::PropertiesError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadError", 2)?;
                s.serialize_field(".tag", "properties_error")?;
                s.serialize_field("properties_error", x)?;
                s.end()
            }
            UploadError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UploadError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UploadError::PropertiesError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UploadError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UploadError::Path(inner) => write!(f, "Unable to save the uploaded contents to a file: {:?}", inner),
            UploadError::PropertiesError(inner) => write!(f, "The supplied property group is invalid. The file has uploaded without property groups: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadErrorWithProperties {
    /// Unable to save the uploaded contents to a file.
    Path(UploadWriteFailed),
    /// The supplied property group is invalid. The file has uploaded without property groups.
    PropertiesError(super::file_properties::InvalidPropertyGroupError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadErrorWithProperties {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadErrorWithProperties;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadErrorWithProperties structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => UploadErrorWithProperties::Path(UploadWriteFailed::internal_deserialize(&mut map)?),
                    "properties_error" => {
                        match map.next_key()? {
                            Some("properties_error") => UploadErrorWithProperties::PropertiesError(map.next_value()?),
                            None => return Err(de::Error::missing_field("properties_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => UploadErrorWithProperties::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "properties_error",
                                    "other"];
        deserializer.deserialize_struct("UploadErrorWithProperties", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadErrorWithProperties {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadErrorWithProperties::Path(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadErrorWithProperties", 3)?;
                s.serialize_field(".tag", "path")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            UploadErrorWithProperties::PropertiesError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadErrorWithProperties", 2)?;
                s.serialize_field(".tag", "properties_error")?;
                s.serialize_field("properties_error", x)?;
                s.end()
            }
            UploadErrorWithProperties::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UploadErrorWithProperties {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UploadErrorWithProperties::PropertiesError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UploadErrorWithProperties {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UploadErrorWithProperties::Path(inner) => write!(f, "Unable to save the uploaded contents to a file: {:?}", inner),
            UploadErrorWithProperties::PropertiesError(inner) => write!(f, "The supplied property group is invalid. The file has uploaded without property groups: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionAppendArg {
    /// Contains the upload session ID and the offset.
    pub cursor: UploadSessionCursor,
    /// If true, the current session will be closed, at which point you won't be able to call
    /// [`upload_session_append_v2()`](upload_session_append_v2) anymore with the current session.
    pub close: bool,
}

impl UploadSessionAppendArg {
    pub fn new(cursor: UploadSessionCursor) -> Self {
        UploadSessionAppendArg {
            cursor,
            close: false,
        }
    }

    pub fn with_close(mut self, value: bool) -> Self {
        self.close = value;
        self
    }
}

const UPLOAD_SESSION_APPEND_ARG_FIELDS: &[&str] = &["cursor",
                                                    "close"];
impl UploadSessionAppendArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionAppendArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionAppendArg>, V::Error> {
        let mut field_cursor = None;
        let mut field_close = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "close" => {
                    if field_close.is_some() {
                        return Err(::serde::de::Error::duplicate_field("close"));
                    }
                    field_close = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionAppendArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            close: field_close.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("close", &self.close)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionAppendArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionAppendArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionAppendArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionAppendArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionAppendArg", UPLOAD_SESSION_APPEND_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionAppendArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionAppendArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionCursor {
    /// The upload session ID (returned by [`upload_session_start()`](upload_session_start)).
    pub session_id: String,
    /// Offset in bytes at which data should be appended. We use this to make sure upload data isn't
    /// lost or duplicated in the event of a network error.
    pub offset: u64,
}

impl UploadSessionCursor {
    pub fn new(session_id: String, offset: u64) -> Self {
        UploadSessionCursor {
            session_id,
            offset,
        }
    }
}

const UPLOAD_SESSION_CURSOR_FIELDS: &[&str] = &["session_id",
                                                "offset"];
impl UploadSessionCursor {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionCursor, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionCursor>, V::Error> {
        let mut field_session_id = None;
        let mut field_offset = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                "offset" => {
                    if field_offset.is_some() {
                        return Err(::serde::de::Error::duplicate_field("offset"));
                    }
                    field_offset = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionCursor {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
            offset: field_offset.ok_or_else(|| ::serde::de::Error::missing_field("offset"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        s.serialize_field("offset", &self.offset)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionCursor {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionCursor;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionCursor struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionCursor::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionCursor", UPLOAD_SESSION_CURSOR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionCursor {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionCursor", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionFinishArg {
    /// Contains the upload session ID and the offset.
    pub cursor: UploadSessionCursor,
    /// Contains the path and other optional modifiers for the commit.
    pub commit: CommitInfo,
}

impl UploadSessionFinishArg {
    pub fn new(cursor: UploadSessionCursor, commit: CommitInfo) -> Self {
        UploadSessionFinishArg {
            cursor,
            commit,
        }
    }
}

const UPLOAD_SESSION_FINISH_ARG_FIELDS: &[&str] = &["cursor",
                                                    "commit"];
impl UploadSessionFinishArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionFinishArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionFinishArg>, V::Error> {
        let mut field_cursor = None;
        let mut field_commit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "commit" => {
                    if field_commit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("commit"));
                    }
                    field_commit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionFinishArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            commit: field_commit.ok_or_else(|| ::serde::de::Error::missing_field("commit"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("commit", &self.commit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionFinishArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionFinishArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionFinishArg", UPLOAD_SESSION_FINISH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionFinishArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionFinishBatchArg {
    /// Commit information for each file in the batch.
    pub entries: Vec<UploadSessionFinishArg>,
}

impl UploadSessionFinishBatchArg {
    pub fn new(entries: Vec<UploadSessionFinishArg>) -> Self {
        UploadSessionFinishBatchArg {
            entries,
        }
    }
}

const UPLOAD_SESSION_FINISH_BATCH_ARG_FIELDS: &[&str] = &["entries"];
impl UploadSessionFinishBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionFinishBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionFinishBatchArg>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionFinishBatchArg {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionFinishBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionFinishBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionFinishBatchArg", UPLOAD_SESSION_FINISH_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionFinishBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum UploadSessionFinishBatchJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The [`upload_session_finish_batch()`](upload_session_finish_batch) has finished.
    Complete(UploadSessionFinishBatchResult),
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishBatchJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionFinishBatchJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishBatchJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => UploadSessionFinishBatchJobStatus::InProgress,
                    "complete" => UploadSessionFinishBatchJobStatus::Complete(UploadSessionFinishBatchResult::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete"];
        deserializer.deserialize_struct("UploadSessionFinishBatchJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishBatchJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionFinishBatchJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            UploadSessionFinishBatchJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchJobStatus", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

/// Result returned by [`upload_session_finish_batch()`](upload_session_finish_batch) that may
/// either launch an asynchronous job or complete synchronously.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadSessionFinishBatchLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(UploadSessionFinishBatchResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishBatchLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionFinishBatchLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishBatchLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => UploadSessionFinishBatchLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => UploadSessionFinishBatchLaunch::Complete(UploadSessionFinishBatchResult::internal_deserialize(&mut map)?),
                    _ => UploadSessionFinishBatchLaunch::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete",
                                    "other"];
        deserializer.deserialize_struct("UploadSessionFinishBatchLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishBatchLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionFinishBatchLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            UploadSessionFinishBatchLaunch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchLaunch", 2)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            UploadSessionFinishBatchLaunch::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionFinishBatchResult {
    /// Each entry in [`UploadSessionFinishBatchArg::entries`](UploadSessionFinishBatchArg) will
    /// appear at the same position inside
    /// [`UploadSessionFinishBatchResult::entries`](UploadSessionFinishBatchResult).
    pub entries: Vec<UploadSessionFinishBatchResultEntry>,
}

impl UploadSessionFinishBatchResult {
    pub fn new(entries: Vec<UploadSessionFinishBatchResultEntry>) -> Self {
        UploadSessionFinishBatchResult {
            entries,
        }
    }
}

const UPLOAD_SESSION_FINISH_BATCH_RESULT_FIELDS: &[&str] = &["entries"];
impl UploadSessionFinishBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionFinishBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionFinishBatchResult>, V::Error> {
        let mut field_entries = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionFinishBatchResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionFinishBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionFinishBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionFinishBatchResult", UPLOAD_SESSION_FINISH_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionFinishBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum UploadSessionFinishBatchResultEntry {
    Success(FileMetadata),
    Failure(UploadSessionFinishError),
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishBatchResultEntry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionFinishBatchResultEntry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishBatchResultEntry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => UploadSessionFinishBatchResultEntry::Success(FileMetadata::internal_deserialize(&mut map)?),
                    "failure" => {
                        match map.next_key()? {
                            Some("failure") => UploadSessionFinishBatchResultEntry::Failure(map.next_value()?),
                            None => return Err(de::Error::missing_field("failure")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "failure"];
        deserializer.deserialize_struct("UploadSessionFinishBatchResultEntry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishBatchResultEntry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionFinishBatchResultEntry::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchResultEntry", 19)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            UploadSessionFinishBatchResultEntry::Failure(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadSessionFinishBatchResultEntry", 2)?;
                s.serialize_field(".tag", "failure")?;
                s.serialize_field("failure", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadSessionFinishError {
    /// The session arguments are incorrect; the value explains the reason.
    LookupFailed(UploadSessionLookupError),
    /// Unable to save the uploaded contents to a file. Data has already been appended to the upload
    /// session. Please retry with empty data body and updated offset.
    Path(WriteError),
    /// The supplied property group is invalid. The file has uploaded without property groups.
    PropertiesError(super::file_properties::InvalidPropertyGroupError),
    /// The batch request commits files into too many different shared folders. Please limit your
    /// batch request to files contained in a single shared folder.
    TooManySharedFolderTargets,
    /// There are too many write operations happening in the user's Dropbox. You should retry
    /// uploading this file.
    TooManyWriteOperations,
    /// Uploading data not allowed when finishing concurrent upload session.
    ConcurrentSessionDataNotAllowed,
    /// Concurrent upload sessions need to be closed before finishing.
    ConcurrentSessionNotClosed,
    /// Not all pieces of data were uploaded before trying to finish the session.
    ConcurrentSessionMissingData,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionFinishError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionFinishError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionFinishError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "lookup_failed" => {
                        match map.next_key()? {
                            Some("lookup_failed") => UploadSessionFinishError::LookupFailed(map.next_value()?),
                            None => return Err(de::Error::missing_field("lookup_failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "path" => {
                        match map.next_key()? {
                            Some("path") => UploadSessionFinishError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "properties_error" => {
                        match map.next_key()? {
                            Some("properties_error") => UploadSessionFinishError::PropertiesError(map.next_value()?),
                            None => return Err(de::Error::missing_field("properties_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_shared_folder_targets" => UploadSessionFinishError::TooManySharedFolderTargets,
                    "too_many_write_operations" => UploadSessionFinishError::TooManyWriteOperations,
                    "concurrent_session_data_not_allowed" => UploadSessionFinishError::ConcurrentSessionDataNotAllowed,
                    "concurrent_session_not_closed" => UploadSessionFinishError::ConcurrentSessionNotClosed,
                    "concurrent_session_missing_data" => UploadSessionFinishError::ConcurrentSessionMissingData,
                    _ => UploadSessionFinishError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["lookup_failed",
                                    "path",
                                    "properties_error",
                                    "too_many_shared_folder_targets",
                                    "too_many_write_operations",
                                    "concurrent_session_data_not_allowed",
                                    "concurrent_session_not_closed",
                                    "concurrent_session_missing_data",
                                    "other"];
        deserializer.deserialize_struct("UploadSessionFinishError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionFinishError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionFinishError::LookupFailed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 2)?;
                s.serialize_field(".tag", "lookup_failed")?;
                s.serialize_field("lookup_failed", x)?;
                s.end()
            }
            UploadSessionFinishError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            UploadSessionFinishError::PropertiesError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 2)?;
                s.serialize_field(".tag", "properties_error")?;
                s.serialize_field("properties_error", x)?;
                s.end()
            }
            UploadSessionFinishError::TooManySharedFolderTargets => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 1)?;
                s.serialize_field(".tag", "too_many_shared_folder_targets")?;
                s.end()
            }
            UploadSessionFinishError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            UploadSessionFinishError::ConcurrentSessionDataNotAllowed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 1)?;
                s.serialize_field(".tag", "concurrent_session_data_not_allowed")?;
                s.end()
            }
            UploadSessionFinishError::ConcurrentSessionNotClosed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 1)?;
                s.serialize_field(".tag", "concurrent_session_not_closed")?;
                s.end()
            }
            UploadSessionFinishError::ConcurrentSessionMissingData => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionFinishError", 1)?;
                s.serialize_field(".tag", "concurrent_session_missing_data")?;
                s.end()
            }
            UploadSessionFinishError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UploadSessionFinishError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UploadSessionFinishError::LookupFailed(inner) => Some(inner),
            UploadSessionFinishError::Path(inner) => Some(inner),
            UploadSessionFinishError::PropertiesError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UploadSessionFinishError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UploadSessionFinishError::LookupFailed(inner) => write!(f, "The session arguments are incorrect; the value explains the reason: {}", inner),
            UploadSessionFinishError::Path(inner) => write!(f, "Unable to save the uploaded contents to a file. Data has already been appended to the upload session. Please retry with empty data body and updated offset: {}", inner),
            UploadSessionFinishError::PropertiesError(inner) => write!(f, "The supplied property group is invalid. The file has uploaded without property groups: {}", inner),
            UploadSessionFinishError::TooManySharedFolderTargets => f.write_str("The batch request commits files into too many different shared folders. Please limit your batch request to files contained in a single shared folder."),
            UploadSessionFinishError::TooManyWriteOperations => f.write_str("There are too many write operations happening in the user's Dropbox. You should retry uploading this file."),
            UploadSessionFinishError::ConcurrentSessionDataNotAllowed => f.write_str("Uploading data not allowed when finishing concurrent upload session."),
            UploadSessionFinishError::ConcurrentSessionNotClosed => f.write_str("Concurrent upload sessions need to be closed before finishing."),
            UploadSessionFinishError::ConcurrentSessionMissingData => f.write_str("Not all pieces of data were uploaded before trying to finish the session."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadSessionLookupError {
    /// The upload session ID was not found or has expired. Upload sessions are valid for 7 days.
    NotFound,
    /// The specified offset was incorrect. See the value for the correct offset. This error may
    /// occur when a previous request was received and processed successfully but the client did not
    /// receive the response, e.g. due to a network error.
    IncorrectOffset(UploadSessionOffsetError),
    /// You are attempting to append data to an upload session that has already been closed (i.e.
    /// committed).
    Closed,
    /// The session must be closed before calling upload_session/finish_batch.
    NotClosed,
    /// You can not append to the upload session because the size of a file should not reach the max
    /// file size limit (i.e. 350GB).
    TooLarge,
    /// For concurrent upload sessions, offset needs to be multiple of 4194304 bytes.
    ConcurrentSessionInvalidOffset,
    /// For concurrent upload sessions, only chunks with size multiple of 4194304 bytes can be
    /// uploaded.
    ConcurrentSessionInvalidDataSize,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionLookupError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionLookupError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionLookupError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "not_found" => UploadSessionLookupError::NotFound,
                    "incorrect_offset" => UploadSessionLookupError::IncorrectOffset(UploadSessionOffsetError::internal_deserialize(&mut map)?),
                    "closed" => UploadSessionLookupError::Closed,
                    "not_closed" => UploadSessionLookupError::NotClosed,
                    "too_large" => UploadSessionLookupError::TooLarge,
                    "concurrent_session_invalid_offset" => UploadSessionLookupError::ConcurrentSessionInvalidOffset,
                    "concurrent_session_invalid_data_size" => UploadSessionLookupError::ConcurrentSessionInvalidDataSize,
                    _ => UploadSessionLookupError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["not_found",
                                    "incorrect_offset",
                                    "closed",
                                    "not_closed",
                                    "too_large",
                                    "concurrent_session_invalid_offset",
                                    "concurrent_session_invalid_data_size",
                                    "other"];
        deserializer.deserialize_struct("UploadSessionLookupError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionLookupError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionLookupError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            UploadSessionLookupError::IncorrectOffset(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 2)?;
                s.serialize_field(".tag", "incorrect_offset")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            UploadSessionLookupError::Closed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "closed")?;
                s.end()
            }
            UploadSessionLookupError::NotClosed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "not_closed")?;
                s.end()
            }
            UploadSessionLookupError::TooLarge => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "too_large")?;
                s.end()
            }
            UploadSessionLookupError::ConcurrentSessionInvalidOffset => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "concurrent_session_invalid_offset")?;
                s.end()
            }
            UploadSessionLookupError::ConcurrentSessionInvalidDataSize => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionLookupError", 1)?;
                s.serialize_field(".tag", "concurrent_session_invalid_data_size")?;
                s.end()
            }
            UploadSessionLookupError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UploadSessionLookupError {
}

impl ::std::fmt::Display for UploadSessionLookupError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UploadSessionLookupError::NotFound => f.write_str("The upload session ID was not found or has expired. Upload sessions are valid for 7 days."),
            UploadSessionLookupError::IncorrectOffset(inner) => write!(f, "The specified offset was incorrect. See the value for the correct offset. This error may occur when a previous request was received and processed successfully but the client did not receive the response, e.g. due to a network error: {:?}", inner),
            UploadSessionLookupError::Closed => f.write_str("You are attempting to append data to an upload session that has already been closed (i.e. committed)."),
            UploadSessionLookupError::NotClosed => f.write_str("The session must be closed before calling upload_session/finish_batch."),
            UploadSessionLookupError::TooLarge => f.write_str("You can not append to the upload session because the size of a file should not reach the max file size limit (i.e. 350GB)."),
            UploadSessionLookupError::ConcurrentSessionInvalidOffset => f.write_str("For concurrent upload sessions, offset needs to be multiple of 4194304 bytes."),
            UploadSessionLookupError::ConcurrentSessionInvalidDataSize => f.write_str("For concurrent upload sessions, only chunks with size multiple of 4194304 bytes can be uploaded."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionOffsetError {
    /// The offset up to which data has been collected.
    pub correct_offset: u64,
}

impl UploadSessionOffsetError {
    pub fn new(correct_offset: u64) -> Self {
        UploadSessionOffsetError {
            correct_offset,
        }
    }
}

const UPLOAD_SESSION_OFFSET_ERROR_FIELDS: &[&str] = &["correct_offset"];
impl UploadSessionOffsetError {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionOffsetError, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionOffsetError>, V::Error> {
        let mut field_correct_offset = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "correct_offset" => {
                    if field_correct_offset.is_some() {
                        return Err(::serde::de::Error::duplicate_field("correct_offset"));
                    }
                    field_correct_offset = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionOffsetError {
            correct_offset: field_correct_offset.ok_or_else(|| ::serde::de::Error::missing_field("correct_offset"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("correct_offset", &self.correct_offset)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionOffsetError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionOffsetError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionOffsetError struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionOffsetError::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionOffsetError", UPLOAD_SESSION_OFFSET_ERROR_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionOffsetError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionOffsetError", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionStartArg {
    /// If true, the current session will be closed, at which point you won't be able to call
    /// [`upload_session_append_v2()`](upload_session_append_v2) anymore with the current session.
    pub close: bool,
    /// Type of upload session you want to start. If not specified, default is
    /// [`UploadSessionType::Sequential`](UploadSessionType::Sequential).
    pub session_type: Option<UploadSessionType>,
}

impl Default for UploadSessionStartArg {
    fn default() -> Self {
        UploadSessionStartArg {
            close: false,
            session_type: None,
        }
    }
}

impl UploadSessionStartArg {
    pub fn with_close(mut self, value: bool) -> Self {
        self.close = value;
        self
    }

    pub fn with_session_type(mut self, value: UploadSessionType) -> Self {
        self.session_type = Some(value);
        self
    }
}

const UPLOAD_SESSION_START_ARG_FIELDS: &[&str] = &["close",
                                                   "session_type"];
impl UploadSessionStartArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<UploadSessionStartArg, V::Error> {
        let mut field_close = None;
        let mut field_session_type = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "close" => {
                    if field_close.is_some() {
                        return Err(::serde::de::Error::duplicate_field("close"));
                    }
                    field_close = Some(map.next_value()?);
                }
                "session_type" => {
                    if field_session_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_type"));
                    }
                    field_session_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = UploadSessionStartArg {
            close: field_close.unwrap_or(false),
            session_type: field_session_type,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("close", &self.close)?;
        if let Some(val) = &self.session_type {
            s.serialize_field("session_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionStartArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionStartArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionStartArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionStartArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionStartArg", UPLOAD_SESSION_START_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionStartArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionStartArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadSessionStartError {
    /// Uploading data not allowed when starting concurrent upload session.
    ConcurrentSessionDataNotAllowed,
    /// Can not start a closed concurrent upload session.
    ConcurrentSessionCloseNotAllowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionStartError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionStartError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionStartError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "concurrent_session_data_not_allowed" => UploadSessionStartError::ConcurrentSessionDataNotAllowed,
                    "concurrent_session_close_not_allowed" => UploadSessionStartError::ConcurrentSessionCloseNotAllowed,
                    _ => UploadSessionStartError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["concurrent_session_data_not_allowed",
                                    "concurrent_session_close_not_allowed",
                                    "other"];
        deserializer.deserialize_struct("UploadSessionStartError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionStartError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionStartError::ConcurrentSessionDataNotAllowed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionStartError", 1)?;
                s.serialize_field(".tag", "concurrent_session_data_not_allowed")?;
                s.end()
            }
            UploadSessionStartError::ConcurrentSessionCloseNotAllowed => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionStartError", 1)?;
                s.serialize_field(".tag", "concurrent_session_close_not_allowed")?;
                s.end()
            }
            UploadSessionStartError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UploadSessionStartError {
}

impl ::std::fmt::Display for UploadSessionStartError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UploadSessionStartError::ConcurrentSessionDataNotAllowed => f.write_str("Uploading data not allowed when starting concurrent upload session."),
            UploadSessionStartError::ConcurrentSessionCloseNotAllowed => f.write_str("Can not start a closed concurrent upload session."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadSessionStartResult {
    /// A unique identifier for the upload session. Pass this to
    /// [`upload_session_append_v2()`](upload_session_append_v2) and
    /// [`upload_session_finish()`](upload_session_finish).
    pub session_id: String,
}

impl UploadSessionStartResult {
    pub fn new(session_id: String) -> Self {
        UploadSessionStartResult {
            session_id,
        }
    }
}

const UPLOAD_SESSION_START_RESULT_FIELDS: &[&str] = &["session_id"];
impl UploadSessionStartResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadSessionStartResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadSessionStartResult>, V::Error> {
        let mut field_session_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadSessionStartResult {
            session_id: field_session_id.ok_or_else(|| ::serde::de::Error::missing_field("session_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("session_id", &self.session_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionStartResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadSessionStartResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionStartResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadSessionStartResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadSessionStartResult", UPLOAD_SESSION_START_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionStartResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadSessionStartResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UploadSessionType {
    /// Pieces of data are uploaded sequentially one after another. This is the default behavior.
    Sequential,
    /// Pieces of data can be uploaded in concurrent RPCs in any order.
    Concurrent,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UploadSessionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UploadSessionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadSessionType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "sequential" => UploadSessionType::Sequential,
                    "concurrent" => UploadSessionType::Concurrent,
                    _ => UploadSessionType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["sequential",
                                    "concurrent",
                                    "other"];
        deserializer.deserialize_struct("UploadSessionType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UploadSessionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UploadSessionType::Sequential => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionType", 1)?;
                s.serialize_field(".tag", "sequential")?;
                s.end()
            }
            UploadSessionType::Concurrent => {
                // unit
                let mut s = serializer.serialize_struct("UploadSessionType", 1)?;
                s.serialize_field(".tag", "concurrent")?;
                s.end()
            }
            UploadSessionType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UploadWriteFailed {
    /// The reason why the file couldn't be saved.
    pub reason: WriteError,
    /// The upload session ID; data has already been uploaded to the corresponding upload session
    /// and this ID may be used to retry the commit with
    /// [`upload_session_finish()`](upload_session_finish).
    pub upload_session_id: String,
}

impl UploadWriteFailed {
    pub fn new(reason: WriteError, upload_session_id: String) -> Self {
        UploadWriteFailed {
            reason,
            upload_session_id,
        }
    }
}

const UPLOAD_WRITE_FAILED_FIELDS: &[&str] = &["reason",
                                              "upload_session_id"];
impl UploadWriteFailed {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UploadWriteFailed, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UploadWriteFailed>, V::Error> {
        let mut field_reason = None;
        let mut field_upload_session_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "reason" => {
                    if field_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("reason"));
                    }
                    field_reason = Some(map.next_value()?);
                }
                "upload_session_id" => {
                    if field_upload_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("upload_session_id"));
                    }
                    field_upload_session_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UploadWriteFailed {
            reason: field_reason.ok_or_else(|| ::serde::de::Error::missing_field("reason"))?,
            upload_session_id: field_upload_session_id.ok_or_else(|| ::serde::de::Error::missing_field("upload_session_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("reason", &self.reason)?;
        s.serialize_field("upload_session_id", &self.upload_session_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UploadWriteFailed {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UploadWriteFailed;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UploadWriteFailed struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UploadWriteFailed::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UploadWriteFailed", UPLOAD_WRITE_FAILED_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UploadWriteFailed {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UploadWriteFailed", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Metadata for a video.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct VideoMetadata {
    /// Dimension of the photo/video.
    pub dimensions: Option<Dimensions>,
    /// The GPS coordinate of the photo/video.
    pub location: Option<GpsCoordinates>,
    /// The timestamp when the photo/video is taken.
    pub time_taken: Option<super::common::DropboxTimestamp>,
    /// The duration of the video in milliseconds.
    pub duration: Option<u64>,
}

impl Default for VideoMetadata {
    fn default() -> Self {
        VideoMetadata {
            dimensions: None,
            location: None,
            time_taken: None,
            duration: None,
        }
    }
}

impl VideoMetadata {
    pub fn with_dimensions(mut self, value: Dimensions) -> Self {
        self.dimensions = Some(value);
        self
    }

    pub fn with_location(mut self, value: GpsCoordinates) -> Self {
        self.location = Some(value);
        self
    }

    pub fn with_time_taken(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.time_taken = Some(value);
        self
    }

    pub fn with_duration(mut self, value: u64) -> Self {
        self.duration = Some(value);
        self
    }
}

const VIDEO_METADATA_FIELDS: &[&str] = &["dimensions",
                                         "location",
                                         "time_taken",
                                         "duration"];
impl VideoMetadata {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<VideoMetadata, V::Error> {
        let mut field_dimensions = None;
        let mut field_location = None;
        let mut field_time_taken = None;
        let mut field_duration = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "dimensions" => {
                    if field_dimensions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("dimensions"));
                    }
                    field_dimensions = Some(map.next_value()?);
                }
                "location" => {
                    if field_location.is_some() {
                        return Err(::serde::de::Error::duplicate_field("location"));
                    }
                    field_location = Some(map.next_value()?);
                }
                "time_taken" => {
                    if field_time_taken.is_some() {
                        return Err(::serde::de::Error::duplicate_field("time_taken"));
                    }
                    field_time_taken = Some(map.next_value()?);
                }
                "duration" => {
                    if field_duration.is_some() {
                        return Err(::serde::de::Error::duplicate_field("duration"));
                    }
                    field_duration = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = VideoMetadata {
            dimensions: field_dimensions,
            location: field_location,
            time_taken: field_time_taken,
            duration: field_duration,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.dimensions {
            s.serialize_field("dimensions", val)?;
        }
        if let Some(val) = &self.location {
            s.serialize_field("location", val)?;
        }
        if let Some(val) = &self.time_taken {
            s.serialize_field("time_taken", val)?;
        }
        if let Some(val) = &self.duration {
            s.serialize_field("duration", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for VideoMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = VideoMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a VideoMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                VideoMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("VideoMetadata", VIDEO_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for VideoMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("VideoMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum WriteConflictError {
    /// There's a file in the way.
    File,
    /// There's a folder in the way.
    Folder,
    /// There's a file at an ancestor path, so we couldn't create the required parent folders.
    FileAncestor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for WriteConflictError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = WriteConflictError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a WriteConflictError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "file" => WriteConflictError::File,
                    "folder" => WriteConflictError::Folder,
                    "file_ancestor" => WriteConflictError::FileAncestor,
                    _ => WriteConflictError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["file",
                                    "folder",
                                    "file_ancestor",
                                    "other"];
        deserializer.deserialize_struct("WriteConflictError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for WriteConflictError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            WriteConflictError::File => {
                // unit
                let mut s = serializer.serialize_struct("WriteConflictError", 1)?;
                s.serialize_field(".tag", "file")?;
                s.end()
            }
            WriteConflictError::Folder => {
                // unit
                let mut s = serializer.serialize_struct("WriteConflictError", 1)?;
                s.serialize_field(".tag", "folder")?;
                s.end()
            }
            WriteConflictError::FileAncestor => {
                // unit
                let mut s = serializer.serialize_struct("WriteConflictError", 1)?;
                s.serialize_field(".tag", "file_ancestor")?;
                s.end()
            }
            WriteConflictError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for WriteConflictError {
}

impl ::std::fmt::Display for WriteConflictError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            WriteConflictError::File => f.write_str("There's a file in the way."),
            WriteConflictError::Folder => f.write_str("There's a folder in the way."),
            WriteConflictError::FileAncestor => f.write_str("There's a file at an ancestor path, so we couldn't create the required parent folders."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum WriteError {
    /// The given path does not satisfy the required path format. Please refer to the [Path formats
    /// documentation](https://www.dropbox.com/developers/documentation/http/documentation#path-formats)
    /// for more information.
    MalformedPath(MalformedPathError),
    /// Couldn't write to the target path because there was something in the way.
    Conflict(WriteConflictError),
    /// The user doesn't have permissions to write to the target location.
    NoWritePermission,
    /// The user doesn't have enough available space (bytes) to write more data.
    InsufficientSpace,
    /// Dropbox will not save the file or folder because of its name.
    DisallowedName,
    /// This endpoint cannot move or delete team folders.
    TeamFolder,
    /// This file operation is not allowed at this path.
    OperationSuppressed,
    /// There are too many write operations in user's Dropbox. Please retry this request.
    TooManyWriteOperations,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for WriteError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = WriteError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a WriteError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "malformed_path" => {
                        match map.next_key()? {
                            Some("malformed_path") => WriteError::MalformedPath(map.next_value()?),
                            None => WriteError::MalformedPath(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "conflict" => {
                        match map.next_key()? {
                            Some("conflict") => WriteError::Conflict(map.next_value()?),
                            None => return Err(de::Error::missing_field("conflict")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_write_permission" => WriteError::NoWritePermission,
                    "insufficient_space" => WriteError::InsufficientSpace,
                    "disallowed_name" => WriteError::DisallowedName,
                    "team_folder" => WriteError::TeamFolder,
                    "operation_suppressed" => WriteError::OperationSuppressed,
                    "too_many_write_operations" => WriteError::TooManyWriteOperations,
                    _ => WriteError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["malformed_path",
                                    "conflict",
                                    "no_write_permission",
                                    "insufficient_space",
                                    "disallowed_name",
                                    "team_folder",
                                    "operation_suppressed",
                                    "too_many_write_operations",
                                    "other"];
        deserializer.deserialize_struct("WriteError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for WriteError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            WriteError::MalformedPath(ref x) => {
                // nullable (struct or primitive)
                let n = if x.is_some() { 2 } else { 1 };
                let mut s = serializer.serialize_struct("WriteError", n)?;
                s.serialize_field(".tag", "malformed_path")?;
                if let Some(ref x) = x {
                    s.serialize_field("malformed_path", &x)?;
                }
                s.end()
            }
            WriteError::Conflict(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("WriteError", 2)?;
                s.serialize_field(".tag", "conflict")?;
                s.serialize_field("conflict", x)?;
                s.end()
            }
            WriteError::NoWritePermission => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "no_write_permission")?;
                s.end()
            }
            WriteError::InsufficientSpace => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "insufficient_space")?;
                s.end()
            }
            WriteError::DisallowedName => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "disallowed_name")?;
                s.end()
            }
            WriteError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            WriteError::OperationSuppressed => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "operation_suppressed")?;
                s.end()
            }
            WriteError::TooManyWriteOperations => {
                // unit
                let mut s = serializer.serialize_struct("WriteError", 1)?;
                s.serialize_field(".tag", "too_many_write_operations")?;
                s.end()
            }
            WriteError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for WriteError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            WriteError::Conflict(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for WriteError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            WriteError::MalformedPath(inner) => write!(f, "malformed_path: {:?}", inner),
            WriteError::Conflict(inner) => write!(f, "Couldn't write to the target path because there was something in the way: {}", inner),
            WriteError::NoWritePermission => f.write_str("The user doesn't have permissions to write to the target location."),
            WriteError::InsufficientSpace => f.write_str("The user doesn't have enough available space (bytes) to write more data."),
            WriteError::DisallowedName => f.write_str("Dropbox will not save the file or folder because of its name."),
            WriteError::TeamFolder => f.write_str("This endpoint cannot move or delete team folders."),
            WriteError::OperationSuppressed => f.write_str("This file operation is not allowed at this path."),
            WriteError::TooManyWriteOperations => f.write_str("There are too many write operations in user's Dropbox. Please retry this request."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Your intent when writing a file to some path. This is used to determine what constitutes a
/// conflict and what the autorename strategy is. In some situations, the conflict behavior is
/// identical: (a) If the target path doesn't refer to anything, the file is always written; no
/// conflict. (b) If the target path refers to a folder, it's always a conflict. (c) If the target
/// path refers to a file with identical contents, nothing gets written; no conflict. The conflict
/// checking differs in the case where there's a file at the target path with contents different
/// from the contents you're trying to write.
#[derive(Debug, Clone, PartialEq)]
pub enum WriteMode {
    /// Do not overwrite an existing file if there is a conflict. The autorename strategy is to
    /// append a number to the file name. For example, "document.txt" might become "document
    /// (2).txt".
    Add,
    /// Always overwrite the existing file. The autorename strategy is the same as it is for
    /// [`Add`](WriteMode::Add).
    Overwrite,
    /// Overwrite if the given "rev" matches the existing file's "rev". The supplied value should be
    /// the latest known "rev" of the file, for example, from [`FileMetadata`](FileMetadata), from
    /// when the file was last downloaded by the app. This will cause the file on the Dropbox
    /// servers to be overwritten if the given "rev" matches the existing file's current "rev" on
    /// the Dropbox servers. The autorename strategy is to append the string "conflicted copy" to
    /// the file name. For example, "document.txt" might become "document (conflicted copy).txt" or
    /// "document (Panda's conflicted copy).txt".
    Update(Rev),
}

impl<'de> ::serde::de::Deserialize<'de> for WriteMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = WriteMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a WriteMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "add" => WriteMode::Add,
                    "overwrite" => WriteMode::Overwrite,
                    "update" => {
                        match map.next_key()? {
                            Some("update") => WriteMode::Update(map.next_value()?),
                            None => return Err(de::Error::missing_field("update")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["add",
                                    "overwrite",
                                    "update"];
        deserializer.deserialize_struct("WriteMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for WriteMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            WriteMode::Add => {
                // unit
                let mut s = serializer.serialize_struct("WriteMode", 1)?;
                s.serialize_field(".tag", "add")?;
                s.end()
            }
            WriteMode::Overwrite => {
                // unit
                let mut s = serializer.serialize_struct("WriteMode", 1)?;
                s.serialize_field(".tag", "overwrite")?;
                s.end()
            }
            WriteMode::Update(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("WriteMode", 2)?;
                s.serialize_field(".tag", "update")?;
                s.serialize_field("update", x)?;
                s.end()
            }
        }
    }
}

