// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

pub type AsyncJobId = String;

/// Result returned by methods that may either launch an asynchronous job or complete synchronously.
/// Upon synchronous completion of the job, no additional information is returned.
#[derive(Debug, Clone, PartialEq)]
pub enum LaunchEmptyResult {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(AsyncJobId),
    /// The job finished synchronously and successfully.
    Complete,
}

impl<'de> ::serde::de::Deserialize<'de> for LaunchEmptyResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LaunchEmptyResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LaunchEmptyResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => LaunchEmptyResult::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => LaunchEmptyResult::Complete,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete"];
        deserializer.deserialize_struct("LaunchEmptyResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LaunchEmptyResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LaunchEmptyResult::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("LaunchEmptyResult", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            LaunchEmptyResult::Complete => {
                // unit
                let mut s = serializer.serialize_struct("LaunchEmptyResult", 1)?;
                s.serialize_field(".tag", "complete")?;
                s.end()
            }
        }
    }
}

/// Result returned by methods that launch an asynchronous job. A method who may either launch an
/// asynchronous job, or complete the request synchronously, can use this union by extending it, and
/// adding a 'complete' field with the type of the synchronous response. See
/// [`LaunchEmptyResult`](LaunchEmptyResult) for an example.
#[derive(Debug, Clone, PartialEq)]
pub enum LaunchResultBase {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(AsyncJobId),
}

impl<'de> ::serde::de::Deserialize<'de> for LaunchResultBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LaunchResultBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LaunchResultBase structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => LaunchResultBase::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id"];
        deserializer.deserialize_struct("LaunchResultBase", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LaunchResultBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LaunchResultBase::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("LaunchResultBase", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
        }
    }
}

/// Arguments for methods that poll the status of an asynchronous job.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PollArg {
    /// Id of the asynchronous job. This is the value of a response returned from the method that
    /// launched the job.
    pub async_job_id: AsyncJobId,
}

impl PollArg {
    pub fn new(async_job_id: AsyncJobId) -> Self {
        PollArg {
            async_job_id,
        }
    }
}

const POLL_ARG_FIELDS: &[&str] = &["async_job_id"];
impl PollArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PollArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PollArg>, V::Error> {
        let mut field_async_job_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "async_job_id" => {
                    if field_async_job_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("async_job_id"));
                    }
                    field_async_job_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PollArg {
            async_job_id: field_async_job_id.ok_or_else(|| ::serde::de::Error::missing_field("async_job_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("async_job_id", &self.async_job_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PollArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PollArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PollArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PollArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PollArg", POLL_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PollArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PollArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Result returned by methods that poll for the status of an asynchronous job. Upon completion of
/// the job, no additional information is returned.
#[derive(Debug, Clone, PartialEq)]
pub enum PollEmptyResult {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The asynchronous job has completed successfully.
    Complete,
}

impl<'de> ::serde::de::Deserialize<'de> for PollEmptyResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PollEmptyResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PollEmptyResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => PollEmptyResult::InProgress,
                    "complete" => PollEmptyResult::Complete,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete"];
        deserializer.deserialize_struct("PollEmptyResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PollEmptyResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PollEmptyResult::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("PollEmptyResult", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            PollEmptyResult::Complete => {
                // unit
                let mut s = serializer.serialize_struct("PollEmptyResult", 1)?;
                s.serialize_field(".tag", "complete")?;
                s.end()
            }
        }
    }
}

/// Error returned by methods for polling the status of asynchronous job.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PollError {
    /// The job ID is invalid.
    InvalidAsyncJobId,
    /// Something went wrong with the job on Dropbox's end. You'll need to verify that the action
    /// you were taking succeeded, and if not, try again. This should happen very rarely.
    InternalError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PollError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PollError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PollError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_async_job_id" => PollError::InvalidAsyncJobId,
                    "internal_error" => PollError::InternalError,
                    _ => PollError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_async_job_id",
                                    "internal_error",
                                    "other"];
        deserializer.deserialize_struct("PollError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PollError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PollError::InvalidAsyncJobId => {
                // unit
                let mut s = serializer.serialize_struct("PollError", 1)?;
                s.serialize_field(".tag", "invalid_async_job_id")?;
                s.end()
            }
            PollError::InternalError => {
                // unit
                let mut s = serializer.serialize_struct("PollError", 1)?;
                s.serialize_field(".tag", "internal_error")?;
                s.end()
            }
            PollError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for PollError {
}

impl ::std::fmt::Display for PollError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            PollError::InvalidAsyncJobId => f.write_str("The job ID is invalid."),
            PollError::InternalError => f.write_str("Something went wrong with the job on Dropbox's end. You'll need to verify that the action you were taking succeeded, and if not, try again. This should happen very rarely."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result returned by methods that poll for the status of an asynchronous job. Unions that extend
/// this union should add a 'complete' field with a type of the information returned upon job
/// completion. See [`PollEmptyResult`](PollEmptyResult) for an example.
#[derive(Debug, Clone, PartialEq)]
pub enum PollResultBase {
    /// The asynchronous job is still in progress.
    InProgress,
}

impl<'de> ::serde::de::Deserialize<'de> for PollResultBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PollResultBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PollResultBase structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => PollResultBase::InProgress,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress"];
        deserializer.deserialize_struct("PollResultBase", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PollResultBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PollResultBase::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("PollResultBase", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
        }
    }
}

