// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

pub type AppId = String;
pub type EmailAddress = String;
pub type FilePath = String;
pub type IpAddress = String;
pub type NamespaceId = String;
pub type RequestId = String;
pub type TeamEventList = Vec<TeamEvent>;

/// Retrieves team events. If the result's [`GetTeamEventsResult::has_more`](GetTeamEventsResult)
/// field is `true`, call [`get_events_continue()`](get_events_continue) with the returned cursor to
/// retrieve more entries. If end_time is not specified in your request, you may use the returned
/// cursor to poll [`get_events_continue()`](get_events_continue) for new events. Many attributes
/// note 'may be missing due to historical data gap'. Note that the file_operations category and &
/// analogous paper events are not available on all Dropbox Business
/// [plans](/business/plans-comparison). Use
/// [features/get_values](/developers/documentation/http/teams#team-features-get_values) to check
/// for this feature. Permission : Team Auditing.
pub fn get_events(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GetTeamEventsArg,
) -> crate::Result<Result<GetTeamEventsResult, GetTeamEventsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team_log/get_events",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`get_events()`](get_events), use this to paginate through
/// all events. Permission : Team Auditing.
pub fn get_events_continue(
    client: &impl crate::client_trait::TeamAuthClient,
    arg: &GetTeamEventsContinueArg,
) -> crate::Result<Result<GetTeamEventsResult, GetTeamEventsContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "team_log/get_events/continue",
        arg,
        None)
}

/// Indicates the method in which the action was performed.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccessMethodLogInfo {
    /// Admin console session details.
    AdminConsole(WebSessionLogInfo),
    /// Api session details.
    Api(ApiSessionLogInfo),
    /// Content manager session details.
    ContentManager(WebSessionLogInfo),
    /// End user session details.
    EndUser(SessionLogInfo),
    /// Enterprise console session details.
    EnterpriseConsole(WebSessionLogInfo),
    /// Sign in as session details.
    SignInAs(WebSessionLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccessMethodLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccessMethodLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccessMethodLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "admin_console" => AccessMethodLogInfo::AdminConsole(WebSessionLogInfo::internal_deserialize(&mut map)?),
                    "api" => AccessMethodLogInfo::Api(ApiSessionLogInfo::internal_deserialize(&mut map)?),
                    "content_manager" => AccessMethodLogInfo::ContentManager(WebSessionLogInfo::internal_deserialize(&mut map)?),
                    "end_user" => {
                        match map.next_key()? {
                            Some("end_user") => AccessMethodLogInfo::EndUser(map.next_value()?),
                            None => return Err(de::Error::missing_field("end_user")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "enterprise_console" => AccessMethodLogInfo::EnterpriseConsole(WebSessionLogInfo::internal_deserialize(&mut map)?),
                    "sign_in_as" => AccessMethodLogInfo::SignInAs(WebSessionLogInfo::internal_deserialize(&mut map)?),
                    _ => AccessMethodLogInfo::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["admin_console",
                                    "api",
                                    "content_manager",
                                    "end_user",
                                    "enterprise_console",
                                    "sign_in_as",
                                    "other"];
        deserializer.deserialize_struct("AccessMethodLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccessMethodLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccessMethodLogInfo::AdminConsole(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "admin_console")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AccessMethodLogInfo::Api(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "api")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AccessMethodLogInfo::ContentManager(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "content_manager")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AccessMethodLogInfo::EndUser(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "end_user")?;
                s.serialize_field("end_user", x)?;
                s.end()
            }
            AccessMethodLogInfo::EnterpriseConsole(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "enterprise_console")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AccessMethodLogInfo::SignInAs(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AccessMethodLogInfo", 2)?;
                s.serialize_field(".tag", "sign_in_as")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AccessMethodLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccountCaptureAvailability {
    Available,
    Unavailable,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureAvailability {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccountCaptureAvailability;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureAvailability structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "available" => AccountCaptureAvailability::Available,
                    "unavailable" => AccountCaptureAvailability::Unavailable,
                    _ => AccountCaptureAvailability::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["available",
                                    "unavailable",
                                    "other"];
        deserializer.deserialize_struct("AccountCaptureAvailability", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureAvailability {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccountCaptureAvailability::Available => {
                // unit
                let mut s = serializer.serialize_struct("AccountCaptureAvailability", 1)?;
                s.serialize_field(".tag", "available")?;
                s.end()
            }
            AccountCaptureAvailability::Unavailable => {
                // unit
                let mut s = serializer.serialize_struct("AccountCaptureAvailability", 1)?;
                s.serialize_field(".tag", "unavailable")?;
                s.end()
            }
            AccountCaptureAvailability::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Granted/revoked option to enable account capture on team domains.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureChangeAvailabilityDetails {
    /// New account capture availabilty value.
    pub new_value: AccountCaptureAvailability,
    /// Previous account capture availabilty value. Might be missing due to historical data gap.
    pub previous_value: Option<AccountCaptureAvailability>,
}

impl AccountCaptureChangeAvailabilityDetails {
    pub fn new(new_value: AccountCaptureAvailability) -> Self {
        AccountCaptureChangeAvailabilityDetails {
            new_value,
            previous_value: None,
        }
    }

    pub fn with_previous_value(mut self, value: AccountCaptureAvailability) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const ACCOUNT_CAPTURE_CHANGE_AVAILABILITY_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                      "previous_value"];
impl AccountCaptureChangeAvailabilityDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureChangeAvailabilityDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureChangeAvailabilityDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureChangeAvailabilityDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureChangeAvailabilityDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureChangeAvailabilityDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureChangeAvailabilityDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureChangeAvailabilityDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureChangeAvailabilityDetails", ACCOUNT_CAPTURE_CHANGE_AVAILABILITY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureChangeAvailabilityDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureChangeAvailabilityDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureChangeAvailabilityType {
    pub description: String,
}

impl AccountCaptureChangeAvailabilityType {
    pub fn new(description: String) -> Self {
        AccountCaptureChangeAvailabilityType {
            description,
        }
    }
}

const ACCOUNT_CAPTURE_CHANGE_AVAILABILITY_TYPE_FIELDS: &[&str] = &["description"];
impl AccountCaptureChangeAvailabilityType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureChangeAvailabilityType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureChangeAvailabilityType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureChangeAvailabilityType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureChangeAvailabilityType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureChangeAvailabilityType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureChangeAvailabilityType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureChangeAvailabilityType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureChangeAvailabilityType", ACCOUNT_CAPTURE_CHANGE_AVAILABILITY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureChangeAvailabilityType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureChangeAvailabilityType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed account capture setting on team domain.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureChangePolicyDetails {
    /// New account capture policy.
    pub new_value: AccountCapturePolicy,
    /// Previous account capture policy. Might be missing due to historical data gap.
    pub previous_value: Option<AccountCapturePolicy>,
}

impl AccountCaptureChangePolicyDetails {
    pub fn new(new_value: AccountCapturePolicy) -> Self {
        AccountCaptureChangePolicyDetails {
            new_value,
            previous_value: None,
        }
    }

    pub fn with_previous_value(mut self, value: AccountCapturePolicy) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const ACCOUNT_CAPTURE_CHANGE_POLICY_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                "previous_value"];
impl AccountCaptureChangePolicyDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureChangePolicyDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureChangePolicyDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureChangePolicyDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureChangePolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureChangePolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureChangePolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureChangePolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureChangePolicyDetails", ACCOUNT_CAPTURE_CHANGE_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureChangePolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureChangePolicyDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureChangePolicyType {
    pub description: String,
}

impl AccountCaptureChangePolicyType {
    pub fn new(description: String) -> Self {
        AccountCaptureChangePolicyType {
            description,
        }
    }
}

const ACCOUNT_CAPTURE_CHANGE_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl AccountCaptureChangePolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureChangePolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureChangePolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureChangePolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureChangePolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureChangePolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureChangePolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureChangePolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureChangePolicyType", ACCOUNT_CAPTURE_CHANGE_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureChangePolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureChangePolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Account-captured user migrated account to team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureMigrateAccountDetails {
    /// Domain name.
    pub domain_name: String,
}

impl AccountCaptureMigrateAccountDetails {
    pub fn new(domain_name: String) -> Self {
        AccountCaptureMigrateAccountDetails {
            domain_name,
        }
    }
}

const ACCOUNT_CAPTURE_MIGRATE_ACCOUNT_DETAILS_FIELDS: &[&str] = &["domain_name"];
impl AccountCaptureMigrateAccountDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureMigrateAccountDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureMigrateAccountDetails>, V::Error> {
        let mut field_domain_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_name" => {
                    if field_domain_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_name"));
                    }
                    field_domain_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureMigrateAccountDetails {
            domain_name: field_domain_name.ok_or_else(|| ::serde::de::Error::missing_field("domain_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_name", &self.domain_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureMigrateAccountDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureMigrateAccountDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureMigrateAccountDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureMigrateAccountDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureMigrateAccountDetails", ACCOUNT_CAPTURE_MIGRATE_ACCOUNT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureMigrateAccountDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureMigrateAccountDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureMigrateAccountType {
    pub description: String,
}

impl AccountCaptureMigrateAccountType {
    pub fn new(description: String) -> Self {
        AccountCaptureMigrateAccountType {
            description,
        }
    }
}

const ACCOUNT_CAPTURE_MIGRATE_ACCOUNT_TYPE_FIELDS: &[&str] = &["description"];
impl AccountCaptureMigrateAccountType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureMigrateAccountType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureMigrateAccountType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureMigrateAccountType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureMigrateAccountType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureMigrateAccountType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureMigrateAccountType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureMigrateAccountType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureMigrateAccountType", ACCOUNT_CAPTURE_MIGRATE_ACCOUNT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureMigrateAccountType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureMigrateAccountType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sent account capture email to all unmanaged members.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureNotificationEmailsSentDetails {
    /// Domain name.
    pub domain_name: String,
    /// Account-capture email notification type.
    pub notification_type: Option<AccountCaptureNotificationType>,
}

impl AccountCaptureNotificationEmailsSentDetails {
    pub fn new(domain_name: String) -> Self {
        AccountCaptureNotificationEmailsSentDetails {
            domain_name,
            notification_type: None,
        }
    }

    pub fn with_notification_type(mut self, value: AccountCaptureNotificationType) -> Self {
        self.notification_type = Some(value);
        self
    }
}

const ACCOUNT_CAPTURE_NOTIFICATION_EMAILS_SENT_DETAILS_FIELDS: &[&str] = &["domain_name",
                                                                           "notification_type"];
impl AccountCaptureNotificationEmailsSentDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureNotificationEmailsSentDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureNotificationEmailsSentDetails>, V::Error> {
        let mut field_domain_name = None;
        let mut field_notification_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_name" => {
                    if field_domain_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_name"));
                    }
                    field_domain_name = Some(map.next_value()?);
                }
                "notification_type" => {
                    if field_notification_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("notification_type"));
                    }
                    field_notification_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureNotificationEmailsSentDetails {
            domain_name: field_domain_name.ok_or_else(|| ::serde::de::Error::missing_field("domain_name"))?,
            notification_type: field_notification_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_name", &self.domain_name)?;
        if let Some(val) = &self.notification_type {
            s.serialize_field("notification_type", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureNotificationEmailsSentDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureNotificationEmailsSentDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureNotificationEmailsSentDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureNotificationEmailsSentDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureNotificationEmailsSentDetails", ACCOUNT_CAPTURE_NOTIFICATION_EMAILS_SENT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureNotificationEmailsSentDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureNotificationEmailsSentDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureNotificationEmailsSentType {
    pub description: String,
}

impl AccountCaptureNotificationEmailsSentType {
    pub fn new(description: String) -> Self {
        AccountCaptureNotificationEmailsSentType {
            description,
        }
    }
}

const ACCOUNT_CAPTURE_NOTIFICATION_EMAILS_SENT_TYPE_FIELDS: &[&str] = &["description"];
impl AccountCaptureNotificationEmailsSentType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureNotificationEmailsSentType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureNotificationEmailsSentType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureNotificationEmailsSentType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureNotificationEmailsSentType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureNotificationEmailsSentType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureNotificationEmailsSentType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureNotificationEmailsSentType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureNotificationEmailsSentType", ACCOUNT_CAPTURE_NOTIFICATION_EMAILS_SENT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureNotificationEmailsSentType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureNotificationEmailsSentType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccountCaptureNotificationType {
    ActionableNotification,
    ProactiveWarningNotification,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureNotificationType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccountCaptureNotificationType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureNotificationType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "actionable_notification" => AccountCaptureNotificationType::ActionableNotification,
                    "proactive_warning_notification" => AccountCaptureNotificationType::ProactiveWarningNotification,
                    _ => AccountCaptureNotificationType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["actionable_notification",
                                    "proactive_warning_notification",
                                    "other"];
        deserializer.deserialize_struct("AccountCaptureNotificationType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureNotificationType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccountCaptureNotificationType::ActionableNotification => {
                // unit
                let mut s = serializer.serialize_struct("AccountCaptureNotificationType", 1)?;
                s.serialize_field(".tag", "actionable_notification")?;
                s.end()
            }
            AccountCaptureNotificationType::ProactiveWarningNotification => {
                // unit
                let mut s = serializer.serialize_struct("AccountCaptureNotificationType", 1)?;
                s.serialize_field(".tag", "proactive_warning_notification")?;
                s.end()
            }
            AccountCaptureNotificationType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccountCapturePolicy {
    AllUsers,
    Disabled,
    InvitedUsers,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCapturePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccountCapturePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCapturePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "all_users" => AccountCapturePolicy::AllUsers,
                    "disabled" => AccountCapturePolicy::Disabled,
                    "invited_users" => AccountCapturePolicy::InvitedUsers,
                    _ => AccountCapturePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["all_users",
                                    "disabled",
                                    "invited_users",
                                    "other"];
        deserializer.deserialize_struct("AccountCapturePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCapturePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccountCapturePolicy::AllUsers => {
                // unit
                let mut s = serializer.serialize_struct("AccountCapturePolicy", 1)?;
                s.serialize_field(".tag", "all_users")?;
                s.end()
            }
            AccountCapturePolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("AccountCapturePolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            AccountCapturePolicy::InvitedUsers => {
                // unit
                let mut s = serializer.serialize_struct("AccountCapturePolicy", 1)?;
                s.serialize_field(".tag", "invited_users")?;
                s.end()
            }
            AccountCapturePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Account-captured user changed account email to personal email.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureRelinquishAccountDetails {
    /// Domain name.
    pub domain_name: String,
}

impl AccountCaptureRelinquishAccountDetails {
    pub fn new(domain_name: String) -> Self {
        AccountCaptureRelinquishAccountDetails {
            domain_name,
        }
    }
}

const ACCOUNT_CAPTURE_RELINQUISH_ACCOUNT_DETAILS_FIELDS: &[&str] = &["domain_name"];
impl AccountCaptureRelinquishAccountDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureRelinquishAccountDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureRelinquishAccountDetails>, V::Error> {
        let mut field_domain_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_name" => {
                    if field_domain_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_name"));
                    }
                    field_domain_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureRelinquishAccountDetails {
            domain_name: field_domain_name.ok_or_else(|| ::serde::de::Error::missing_field("domain_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_name", &self.domain_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureRelinquishAccountDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureRelinquishAccountDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureRelinquishAccountDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureRelinquishAccountDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureRelinquishAccountDetails", ACCOUNT_CAPTURE_RELINQUISH_ACCOUNT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureRelinquishAccountDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureRelinquishAccountDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountCaptureRelinquishAccountType {
    pub description: String,
}

impl AccountCaptureRelinquishAccountType {
    pub fn new(description: String) -> Self {
        AccountCaptureRelinquishAccountType {
            description,
        }
    }
}

const ACCOUNT_CAPTURE_RELINQUISH_ACCOUNT_TYPE_FIELDS: &[&str] = &["description"];
impl AccountCaptureRelinquishAccountType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountCaptureRelinquishAccountType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountCaptureRelinquishAccountType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountCaptureRelinquishAccountType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountCaptureRelinquishAccountType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountCaptureRelinquishAccountType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountCaptureRelinquishAccountType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountCaptureRelinquishAccountType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountCaptureRelinquishAccountType", ACCOUNT_CAPTURE_RELINQUISH_ACCOUNT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountCaptureRelinquishAccountType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountCaptureRelinquishAccountType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Unlocked/locked account after failed sign in attempts.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountLockOrUnlockedDetails {
    /// The previous account status.
    pub previous_value: AccountState,
    /// The new account status.
    pub new_value: AccountState,
}

impl AccountLockOrUnlockedDetails {
    pub fn new(previous_value: AccountState, new_value: AccountState) -> Self {
        AccountLockOrUnlockedDetails {
            previous_value,
            new_value,
        }
    }
}

const ACCOUNT_LOCK_OR_UNLOCKED_DETAILS_FIELDS: &[&str] = &["previous_value",
                                                           "new_value"];
impl AccountLockOrUnlockedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountLockOrUnlockedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountLockOrUnlockedDetails>, V::Error> {
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountLockOrUnlockedDetails {
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountLockOrUnlockedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountLockOrUnlockedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountLockOrUnlockedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountLockOrUnlockedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountLockOrUnlockedDetails", ACCOUNT_LOCK_OR_UNLOCKED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountLockOrUnlockedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountLockOrUnlockedDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AccountLockOrUnlockedType {
    pub description: String,
}

impl AccountLockOrUnlockedType {
    pub fn new(description: String) -> Self {
        AccountLockOrUnlockedType {
            description,
        }
    }
}

const ACCOUNT_LOCK_OR_UNLOCKED_TYPE_FIELDS: &[&str] = &["description"];
impl AccountLockOrUnlockedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AccountLockOrUnlockedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AccountLockOrUnlockedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AccountLockOrUnlockedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AccountLockOrUnlockedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AccountLockOrUnlockedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountLockOrUnlockedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AccountLockOrUnlockedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AccountLockOrUnlockedType", ACCOUNT_LOCK_OR_UNLOCKED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AccountLockOrUnlockedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AccountLockOrUnlockedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccountState {
    Locked,
    Unlocked,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccountState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccountState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccountState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "locked" => AccountState::Locked,
                    "unlocked" => AccountState::Unlocked,
                    _ => AccountState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["locked",
                                    "unlocked",
                                    "other"];
        deserializer.deserialize_struct("AccountState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccountState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccountState::Locked => {
                // unit
                let mut s = serializer.serialize_struct("AccountState", 1)?;
                s.serialize_field(".tag", "locked")?;
                s.end()
            }
            AccountState::Unlocked => {
                // unit
                let mut s = serializer.serialize_struct("AccountState", 1)?;
                s.serialize_field(".tag", "unlocked")?;
                s.end()
            }
            AccountState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Additional information indicating the action taken that caused status change.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ActionDetails {
    /// Define how the user was removed from the team.
    RemoveAction(MemberRemoveActionType),
    /// Additional information relevant when someone is invited to the team.
    TeamInviteDetails(TeamInviteDetails),
    /// Additional information relevant when a new member joins the team.
    TeamJoinDetails(JoinTeamDetails),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ActionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ActionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ActionDetails structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "remove_action" => {
                        match map.next_key()? {
                            Some("remove_action") => ActionDetails::RemoveAction(map.next_value()?),
                            None => return Err(de::Error::missing_field("remove_action")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "team_invite_details" => ActionDetails::TeamInviteDetails(TeamInviteDetails::internal_deserialize(&mut map)?),
                    "team_join_details" => ActionDetails::TeamJoinDetails(JoinTeamDetails::internal_deserialize(&mut map)?),
                    _ => ActionDetails::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["remove_action",
                                    "team_invite_details",
                                    "team_join_details",
                                    "other"];
        deserializer.deserialize_struct("ActionDetails", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ActionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ActionDetails::RemoveAction(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ActionDetails", 2)?;
                s.serialize_field(".tag", "remove_action")?;
                s.serialize_field("remove_action", x)?;
                s.end()
            }
            ActionDetails::TeamInviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ActionDetails", 3)?;
                s.serialize_field(".tag", "team_invite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ActionDetails::TeamJoinDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ActionDetails", 10)?;
                s.serialize_field(".tag", "team_join_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ActionDetails::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The entity who performed the action.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ActorLogInfo {
    /// The admin who did the action.
    Admin(UserLogInfo),
    /// Anonymous actor.
    Anonymous,
    /// The application who did the action.
    App(AppLogInfo),
    /// Action done by Dropbox.
    Dropbox,
    /// Action done by reseller.
    Reseller(ResellerLogInfo),
    /// The user who did the action.
    User(UserLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ActorLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ActorLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ActorLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "admin" => {
                        match map.next_key()? {
                            Some("admin") => ActorLogInfo::Admin(map.next_value()?),
                            None => return Err(de::Error::missing_field("admin")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "anonymous" => ActorLogInfo::Anonymous,
                    "app" => {
                        match map.next_key()? {
                            Some("app") => ActorLogInfo::App(map.next_value()?),
                            None => return Err(de::Error::missing_field("app")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "dropbox" => ActorLogInfo::Dropbox,
                    "reseller" => ActorLogInfo::Reseller(ResellerLogInfo::internal_deserialize(&mut map)?),
                    "user" => {
                        match map.next_key()? {
                            Some("user") => ActorLogInfo::User(map.next_value()?),
                            None => return Err(de::Error::missing_field("user")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ActorLogInfo::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["admin",
                                    "anonymous",
                                    "app",
                                    "dropbox",
                                    "reseller",
                                    "user",
                                    "other"];
        deserializer.deserialize_struct("ActorLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ActorLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ActorLogInfo::Admin(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ActorLogInfo", 2)?;
                s.serialize_field(".tag", "admin")?;
                s.serialize_field("admin", x)?;
                s.end()
            }
            ActorLogInfo::Anonymous => {
                // unit
                let mut s = serializer.serialize_struct("ActorLogInfo", 1)?;
                s.serialize_field(".tag", "anonymous")?;
                s.end()
            }
            ActorLogInfo::App(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ActorLogInfo", 2)?;
                s.serialize_field(".tag", "app")?;
                s.serialize_field("app", x)?;
                s.end()
            }
            ActorLogInfo::Dropbox => {
                // unit
                let mut s = serializer.serialize_struct("ActorLogInfo", 1)?;
                s.serialize_field(".tag", "dropbox")?;
                s.end()
            }
            ActorLogInfo::Reseller(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ActorLogInfo", 3)?;
                s.serialize_field(".tag", "reseller")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ActorLogInfo::User(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ActorLogInfo", 2)?;
                s.serialize_field(".tag", "user")?;
                s.serialize_field("user", x)?;
                s.end()
            }
            ActorLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Alert category
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminAlertCategoryEnum {
    AccountTakeover,
    DataLossProtection,
    InformationGovernance,
    MalwareSharing,
    MassiveFileOperation,
    Na,
    ThreatManagement,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertCategoryEnum {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminAlertCategoryEnum;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertCategoryEnum structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "account_takeover" => AdminAlertCategoryEnum::AccountTakeover,
                    "data_loss_protection" => AdminAlertCategoryEnum::DataLossProtection,
                    "information_governance" => AdminAlertCategoryEnum::InformationGovernance,
                    "malware_sharing" => AdminAlertCategoryEnum::MalwareSharing,
                    "massive_file_operation" => AdminAlertCategoryEnum::MassiveFileOperation,
                    "na" => AdminAlertCategoryEnum::Na,
                    "threat_management" => AdminAlertCategoryEnum::ThreatManagement,
                    _ => AdminAlertCategoryEnum::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["account_takeover",
                                    "data_loss_protection",
                                    "information_governance",
                                    "malware_sharing",
                                    "massive_file_operation",
                                    "na",
                                    "threat_management",
                                    "other"];
        deserializer.deserialize_struct("AdminAlertCategoryEnum", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertCategoryEnum {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminAlertCategoryEnum::AccountTakeover => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "account_takeover")?;
                s.end()
            }
            AdminAlertCategoryEnum::DataLossProtection => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "data_loss_protection")?;
                s.end()
            }
            AdminAlertCategoryEnum::InformationGovernance => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "information_governance")?;
                s.end()
            }
            AdminAlertCategoryEnum::MalwareSharing => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "malware_sharing")?;
                s.end()
            }
            AdminAlertCategoryEnum::MassiveFileOperation => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "massive_file_operation")?;
                s.end()
            }
            AdminAlertCategoryEnum::Na => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "na")?;
                s.end()
            }
            AdminAlertCategoryEnum::ThreatManagement => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertCategoryEnum", 1)?;
                s.serialize_field(".tag", "threat_management")?;
                s.end()
            }
            AdminAlertCategoryEnum::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Alert state
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminAlertGeneralStateEnum {
    Active,
    Dismissed,
    InProgress,
    Na,
    Resolved,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertGeneralStateEnum {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminAlertGeneralStateEnum;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertGeneralStateEnum structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "active" => AdminAlertGeneralStateEnum::Active,
                    "dismissed" => AdminAlertGeneralStateEnum::Dismissed,
                    "in_progress" => AdminAlertGeneralStateEnum::InProgress,
                    "na" => AdminAlertGeneralStateEnum::Na,
                    "resolved" => AdminAlertGeneralStateEnum::Resolved,
                    _ => AdminAlertGeneralStateEnum::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["active",
                                    "dismissed",
                                    "in_progress",
                                    "na",
                                    "resolved",
                                    "other"];
        deserializer.deserialize_struct("AdminAlertGeneralStateEnum", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertGeneralStateEnum {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminAlertGeneralStateEnum::Active => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertGeneralStateEnum", 1)?;
                s.serialize_field(".tag", "active")?;
                s.end()
            }
            AdminAlertGeneralStateEnum::Dismissed => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertGeneralStateEnum", 1)?;
                s.serialize_field(".tag", "dismissed")?;
                s.end()
            }
            AdminAlertGeneralStateEnum::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertGeneralStateEnum", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            AdminAlertGeneralStateEnum::Na => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertGeneralStateEnum", 1)?;
                s.serialize_field(".tag", "na")?;
                s.end()
            }
            AdminAlertGeneralStateEnum::Resolved => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertGeneralStateEnum", 1)?;
                s.serialize_field(".tag", "resolved")?;
                s.end()
            }
            AdminAlertGeneralStateEnum::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Alert severity
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminAlertSeverityEnum {
    High,
    Info,
    Low,
    Medium,
    Na,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertSeverityEnum {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminAlertSeverityEnum;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertSeverityEnum structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "high" => AdminAlertSeverityEnum::High,
                    "info" => AdminAlertSeverityEnum::Info,
                    "low" => AdminAlertSeverityEnum::Low,
                    "medium" => AdminAlertSeverityEnum::Medium,
                    "na" => AdminAlertSeverityEnum::Na,
                    _ => AdminAlertSeverityEnum::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["high",
                                    "info",
                                    "low",
                                    "medium",
                                    "na",
                                    "other"];
        deserializer.deserialize_struct("AdminAlertSeverityEnum", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertSeverityEnum {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminAlertSeverityEnum::High => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertSeverityEnum", 1)?;
                s.serialize_field(".tag", "high")?;
                s.end()
            }
            AdminAlertSeverityEnum::Info => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertSeverityEnum", 1)?;
                s.serialize_field(".tag", "info")?;
                s.end()
            }
            AdminAlertSeverityEnum::Low => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertSeverityEnum", 1)?;
                s.serialize_field(".tag", "low")?;
                s.end()
            }
            AdminAlertSeverityEnum::Medium => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertSeverityEnum", 1)?;
                s.serialize_field(".tag", "medium")?;
                s.end()
            }
            AdminAlertSeverityEnum::Na => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertSeverityEnum", 1)?;
                s.serialize_field(".tag", "na")?;
                s.end()
            }
            AdminAlertSeverityEnum::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Alert configurations
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingAlertConfiguration {
    /// Alert state.
    pub alert_state: Option<AdminAlertingAlertStatePolicy>,
    /// Sensitivity level.
    pub sensitivity_level: Option<AdminAlertingAlertSensitivity>,
    /// Recipient settings.
    pub recipients_settings: Option<RecipientsConfiguration>,
}

impl Default for AdminAlertingAlertConfiguration {
    fn default() -> Self {
        AdminAlertingAlertConfiguration {
            alert_state: None,
            sensitivity_level: None,
            recipients_settings: None,
        }
    }
}

impl AdminAlertingAlertConfiguration {
    pub fn with_alert_state(mut self, value: AdminAlertingAlertStatePolicy) -> Self {
        self.alert_state = Some(value);
        self
    }

    pub fn with_sensitivity_level(mut self, value: AdminAlertingAlertSensitivity) -> Self {
        self.sensitivity_level = Some(value);
        self
    }

    pub fn with_recipients_settings(mut self, value: RecipientsConfiguration) -> Self {
        self.recipients_settings = Some(value);
        self
    }
}

const ADMIN_ALERTING_ALERT_CONFIGURATION_FIELDS: &[&str] = &["alert_state",
                                                             "sensitivity_level",
                                                             "recipients_settings"];
impl AdminAlertingAlertConfiguration {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<AdminAlertingAlertConfiguration, V::Error> {
        let mut field_alert_state = None;
        let mut field_sensitivity_level = None;
        let mut field_recipients_settings = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "alert_state" => {
                    if field_alert_state.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_state"));
                    }
                    field_alert_state = Some(map.next_value()?);
                }
                "sensitivity_level" => {
                    if field_sensitivity_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sensitivity_level"));
                    }
                    field_sensitivity_level = Some(map.next_value()?);
                }
                "recipients_settings" => {
                    if field_recipients_settings.is_some() {
                        return Err(::serde::de::Error::duplicate_field("recipients_settings"));
                    }
                    field_recipients_settings = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = AdminAlertingAlertConfiguration {
            alert_state: field_alert_state,
            sensitivity_level: field_sensitivity_level,
            recipients_settings: field_recipients_settings,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.alert_state {
            s.serialize_field("alert_state", val)?;
        }
        if let Some(val) = &self.sensitivity_level {
            s.serialize_field("sensitivity_level", val)?;
        }
        if let Some(val) = &self.recipients_settings {
            s.serialize_field("recipients_settings", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingAlertConfiguration {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingAlertConfiguration;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingAlertConfiguration struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingAlertConfiguration::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingAlertConfiguration", ADMIN_ALERTING_ALERT_CONFIGURATION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingAlertConfiguration {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingAlertConfiguration", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Alert sensitivity
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminAlertingAlertSensitivity {
    High,
    Highest,
    Invalid,
    Low,
    Lowest,
    Medium,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingAlertSensitivity {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminAlertingAlertSensitivity;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingAlertSensitivity structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "high" => AdminAlertingAlertSensitivity::High,
                    "highest" => AdminAlertingAlertSensitivity::Highest,
                    "invalid" => AdminAlertingAlertSensitivity::Invalid,
                    "low" => AdminAlertingAlertSensitivity::Low,
                    "lowest" => AdminAlertingAlertSensitivity::Lowest,
                    "medium" => AdminAlertingAlertSensitivity::Medium,
                    _ => AdminAlertingAlertSensitivity::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["high",
                                    "highest",
                                    "invalid",
                                    "low",
                                    "lowest",
                                    "medium",
                                    "other"];
        deserializer.deserialize_struct("AdminAlertingAlertSensitivity", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingAlertSensitivity {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminAlertingAlertSensitivity::High => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "high")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Highest => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "highest")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Invalid => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "invalid")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Low => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "low")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Lowest => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "lowest")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Medium => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertSensitivity", 1)?;
                s.serialize_field(".tag", "medium")?;
                s.end()
            }
            AdminAlertingAlertSensitivity::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed an alert state.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingAlertStateChangedDetails {
    /// Alert name.
    pub alert_name: String,
    /// Alert severity.
    pub alert_severity: AdminAlertSeverityEnum,
    /// Alert category.
    pub alert_category: AdminAlertCategoryEnum,
    /// Alert ID.
    pub alert_instance_id: String,
    /// Alert state before the change.
    pub previous_value: AdminAlertGeneralStateEnum,
    /// Alert state after the change.
    pub new_value: AdminAlertGeneralStateEnum,
}

impl AdminAlertingAlertStateChangedDetails {
    pub fn new(
        alert_name: String,
        alert_severity: AdminAlertSeverityEnum,
        alert_category: AdminAlertCategoryEnum,
        alert_instance_id: String,
        previous_value: AdminAlertGeneralStateEnum,
        new_value: AdminAlertGeneralStateEnum,
    ) -> Self {
        AdminAlertingAlertStateChangedDetails {
            alert_name,
            alert_severity,
            alert_category,
            alert_instance_id,
            previous_value,
            new_value,
        }
    }
}

const ADMIN_ALERTING_ALERT_STATE_CHANGED_DETAILS_FIELDS: &[&str] = &["alert_name",
                                                                     "alert_severity",
                                                                     "alert_category",
                                                                     "alert_instance_id",
                                                                     "previous_value",
                                                                     "new_value"];
impl AdminAlertingAlertStateChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingAlertStateChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingAlertStateChangedDetails>, V::Error> {
        let mut field_alert_name = None;
        let mut field_alert_severity = None;
        let mut field_alert_category = None;
        let mut field_alert_instance_id = None;
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "alert_name" => {
                    if field_alert_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_name"));
                    }
                    field_alert_name = Some(map.next_value()?);
                }
                "alert_severity" => {
                    if field_alert_severity.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_severity"));
                    }
                    field_alert_severity = Some(map.next_value()?);
                }
                "alert_category" => {
                    if field_alert_category.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_category"));
                    }
                    field_alert_category = Some(map.next_value()?);
                }
                "alert_instance_id" => {
                    if field_alert_instance_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_instance_id"));
                    }
                    field_alert_instance_id = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingAlertStateChangedDetails {
            alert_name: field_alert_name.ok_or_else(|| ::serde::de::Error::missing_field("alert_name"))?,
            alert_severity: field_alert_severity.ok_or_else(|| ::serde::de::Error::missing_field("alert_severity"))?,
            alert_category: field_alert_category.ok_or_else(|| ::serde::de::Error::missing_field("alert_category"))?,
            alert_instance_id: field_alert_instance_id.ok_or_else(|| ::serde::de::Error::missing_field("alert_instance_id"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("alert_name", &self.alert_name)?;
        s.serialize_field("alert_severity", &self.alert_severity)?;
        s.serialize_field("alert_category", &self.alert_category)?;
        s.serialize_field("alert_instance_id", &self.alert_instance_id)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingAlertStateChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingAlertStateChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingAlertStateChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingAlertStateChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingAlertStateChangedDetails", ADMIN_ALERTING_ALERT_STATE_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingAlertStateChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingAlertStateChangedDetails", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingAlertStateChangedType {
    pub description: String,
}

impl AdminAlertingAlertStateChangedType {
    pub fn new(description: String) -> Self {
        AdminAlertingAlertStateChangedType {
            description,
        }
    }
}

const ADMIN_ALERTING_ALERT_STATE_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl AdminAlertingAlertStateChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingAlertStateChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingAlertStateChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingAlertStateChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingAlertStateChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingAlertStateChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingAlertStateChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingAlertStateChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingAlertStateChangedType", ADMIN_ALERTING_ALERT_STATE_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingAlertStateChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingAlertStateChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for controlling whether an alert can be triggered or not
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminAlertingAlertStatePolicy {
    Off,
    On,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingAlertStatePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminAlertingAlertStatePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingAlertStatePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "off" => AdminAlertingAlertStatePolicy::Off,
                    "on" => AdminAlertingAlertStatePolicy::On,
                    _ => AdminAlertingAlertStatePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["off",
                                    "on",
                                    "other"];
        deserializer.deserialize_struct("AdminAlertingAlertStatePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingAlertStatePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminAlertingAlertStatePolicy::Off => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertStatePolicy", 1)?;
                s.serialize_field(".tag", "off")?;
                s.end()
            }
            AdminAlertingAlertStatePolicy::On => {
                // unit
                let mut s = serializer.serialize_struct("AdminAlertingAlertStatePolicy", 1)?;
                s.serialize_field(".tag", "on")?;
                s.end()
            }
            AdminAlertingAlertStatePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed an alert setting.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingChangedAlertConfigDetails {
    /// Alert Name.
    pub alert_name: String,
    /// Previous alert configuration.
    pub previous_alert_config: AdminAlertingAlertConfiguration,
    /// New alert configuration.
    pub new_alert_config: AdminAlertingAlertConfiguration,
}

impl AdminAlertingChangedAlertConfigDetails {
    pub fn new(
        alert_name: String,
        previous_alert_config: AdminAlertingAlertConfiguration,
        new_alert_config: AdminAlertingAlertConfiguration,
    ) -> Self {
        AdminAlertingChangedAlertConfigDetails {
            alert_name,
            previous_alert_config,
            new_alert_config,
        }
    }
}

const ADMIN_ALERTING_CHANGED_ALERT_CONFIG_DETAILS_FIELDS: &[&str] = &["alert_name",
                                                                      "previous_alert_config",
                                                                      "new_alert_config"];
impl AdminAlertingChangedAlertConfigDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingChangedAlertConfigDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingChangedAlertConfigDetails>, V::Error> {
        let mut field_alert_name = None;
        let mut field_previous_alert_config = None;
        let mut field_new_alert_config = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "alert_name" => {
                    if field_alert_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_name"));
                    }
                    field_alert_name = Some(map.next_value()?);
                }
                "previous_alert_config" => {
                    if field_previous_alert_config.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_alert_config"));
                    }
                    field_previous_alert_config = Some(map.next_value()?);
                }
                "new_alert_config" => {
                    if field_new_alert_config.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_alert_config"));
                    }
                    field_new_alert_config = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingChangedAlertConfigDetails {
            alert_name: field_alert_name.ok_or_else(|| ::serde::de::Error::missing_field("alert_name"))?,
            previous_alert_config: field_previous_alert_config.ok_or_else(|| ::serde::de::Error::missing_field("previous_alert_config"))?,
            new_alert_config: field_new_alert_config.ok_or_else(|| ::serde::de::Error::missing_field("new_alert_config"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("alert_name", &self.alert_name)?;
        s.serialize_field("previous_alert_config", &self.previous_alert_config)?;
        s.serialize_field("new_alert_config", &self.new_alert_config)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingChangedAlertConfigDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingChangedAlertConfigDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingChangedAlertConfigDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingChangedAlertConfigDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingChangedAlertConfigDetails", ADMIN_ALERTING_CHANGED_ALERT_CONFIG_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingChangedAlertConfigDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingChangedAlertConfigDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingChangedAlertConfigType {
    pub description: String,
}

impl AdminAlertingChangedAlertConfigType {
    pub fn new(description: String) -> Self {
        AdminAlertingChangedAlertConfigType {
            description,
        }
    }
}

const ADMIN_ALERTING_CHANGED_ALERT_CONFIG_TYPE_FIELDS: &[&str] = &["description"];
impl AdminAlertingChangedAlertConfigType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingChangedAlertConfigType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingChangedAlertConfigType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingChangedAlertConfigType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingChangedAlertConfigType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingChangedAlertConfigType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingChangedAlertConfigType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingChangedAlertConfigType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingChangedAlertConfigType", ADMIN_ALERTING_CHANGED_ALERT_CONFIG_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingChangedAlertConfigType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingChangedAlertConfigType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Triggered security alert.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingTriggeredAlertDetails {
    /// Alert name.
    pub alert_name: String,
    /// Alert severity.
    pub alert_severity: AdminAlertSeverityEnum,
    /// Alert category.
    pub alert_category: AdminAlertCategoryEnum,
    /// Alert ID.
    pub alert_instance_id: String,
}

impl AdminAlertingTriggeredAlertDetails {
    pub fn new(
        alert_name: String,
        alert_severity: AdminAlertSeverityEnum,
        alert_category: AdminAlertCategoryEnum,
        alert_instance_id: String,
    ) -> Self {
        AdminAlertingTriggeredAlertDetails {
            alert_name,
            alert_severity,
            alert_category,
            alert_instance_id,
        }
    }
}

const ADMIN_ALERTING_TRIGGERED_ALERT_DETAILS_FIELDS: &[&str] = &["alert_name",
                                                                 "alert_severity",
                                                                 "alert_category",
                                                                 "alert_instance_id"];
impl AdminAlertingTriggeredAlertDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingTriggeredAlertDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingTriggeredAlertDetails>, V::Error> {
        let mut field_alert_name = None;
        let mut field_alert_severity = None;
        let mut field_alert_category = None;
        let mut field_alert_instance_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "alert_name" => {
                    if field_alert_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_name"));
                    }
                    field_alert_name = Some(map.next_value()?);
                }
                "alert_severity" => {
                    if field_alert_severity.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_severity"));
                    }
                    field_alert_severity = Some(map.next_value()?);
                }
                "alert_category" => {
                    if field_alert_category.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_category"));
                    }
                    field_alert_category = Some(map.next_value()?);
                }
                "alert_instance_id" => {
                    if field_alert_instance_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("alert_instance_id"));
                    }
                    field_alert_instance_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingTriggeredAlertDetails {
            alert_name: field_alert_name.ok_or_else(|| ::serde::de::Error::missing_field("alert_name"))?,
            alert_severity: field_alert_severity.ok_or_else(|| ::serde::de::Error::missing_field("alert_severity"))?,
            alert_category: field_alert_category.ok_or_else(|| ::serde::de::Error::missing_field("alert_category"))?,
            alert_instance_id: field_alert_instance_id.ok_or_else(|| ::serde::de::Error::missing_field("alert_instance_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("alert_name", &self.alert_name)?;
        s.serialize_field("alert_severity", &self.alert_severity)?;
        s.serialize_field("alert_category", &self.alert_category)?;
        s.serialize_field("alert_instance_id", &self.alert_instance_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingTriggeredAlertDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingTriggeredAlertDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingTriggeredAlertDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingTriggeredAlertDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingTriggeredAlertDetails", ADMIN_ALERTING_TRIGGERED_ALERT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingTriggeredAlertDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingTriggeredAlertDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AdminAlertingTriggeredAlertType {
    pub description: String,
}

impl AdminAlertingTriggeredAlertType {
    pub fn new(description: String) -> Self {
        AdminAlertingTriggeredAlertType {
            description,
        }
    }
}

const ADMIN_ALERTING_TRIGGERED_ALERT_TYPE_FIELDS: &[&str] = &["description"];
impl AdminAlertingTriggeredAlertType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AdminAlertingTriggeredAlertType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AdminAlertingTriggeredAlertType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AdminAlertingTriggeredAlertType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AdminAlertingTriggeredAlertType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AdminAlertingTriggeredAlertType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminAlertingTriggeredAlertType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AdminAlertingTriggeredAlertType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AdminAlertingTriggeredAlertType", ADMIN_ALERTING_TRIGGERED_ALERT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AdminAlertingTriggeredAlertType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AdminAlertingTriggeredAlertType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminConsoleAppPermission {
    DefaultForListedApps,
    DefaultForUnlistedApps,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminConsoleAppPermission {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminConsoleAppPermission;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminConsoleAppPermission structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default_for_listed_apps" => AdminConsoleAppPermission::DefaultForListedApps,
                    "default_for_unlisted_apps" => AdminConsoleAppPermission::DefaultForUnlistedApps,
                    _ => AdminConsoleAppPermission::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default_for_listed_apps",
                                    "default_for_unlisted_apps",
                                    "other"];
        deserializer.deserialize_struct("AdminConsoleAppPermission", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminConsoleAppPermission {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminConsoleAppPermission::DefaultForListedApps => {
                // unit
                let mut s = serializer.serialize_struct("AdminConsoleAppPermission", 1)?;
                s.serialize_field(".tag", "default_for_listed_apps")?;
                s.end()
            }
            AdminConsoleAppPermission::DefaultForUnlistedApps => {
                // unit
                let mut s = serializer.serialize_struct("AdminConsoleAppPermission", 1)?;
                s.serialize_field(".tag", "default_for_unlisted_apps")?;
                s.end()
            }
            AdminConsoleAppPermission::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminConsoleAppPolicy {
    Allow,
    Block,
    Default,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminConsoleAppPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminConsoleAppPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminConsoleAppPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "allow" => AdminConsoleAppPolicy::Allow,
                    "block" => AdminConsoleAppPolicy::Block,
                    "default" => AdminConsoleAppPolicy::Default,
                    _ => AdminConsoleAppPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["allow",
                                    "block",
                                    "default",
                                    "other"];
        deserializer.deserialize_struct("AdminConsoleAppPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminConsoleAppPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminConsoleAppPolicy::Allow => {
                // unit
                let mut s = serializer.serialize_struct("AdminConsoleAppPolicy", 1)?;
                s.serialize_field(".tag", "allow")?;
                s.end()
            }
            AdminConsoleAppPolicy::Block => {
                // unit
                let mut s = serializer.serialize_struct("AdminConsoleAppPolicy", 1)?;
                s.serialize_field(".tag", "block")?;
                s.end()
            }
            AdminConsoleAppPolicy::Default => {
                // unit
                let mut s = serializer.serialize_struct("AdminConsoleAppPolicy", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            AdminConsoleAppPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AdminRole {
    BillingAdmin,
    ComplianceAdmin,
    ContentAdmin,
    LimitedAdmin,
    MemberOnly,
    ReportingAdmin,
    SecurityAdmin,
    SupportAdmin,
    TeamAdmin,
    UserManagementAdmin,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AdminRole {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AdminRole;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AdminRole structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "billing_admin" => AdminRole::BillingAdmin,
                    "compliance_admin" => AdminRole::ComplianceAdmin,
                    "content_admin" => AdminRole::ContentAdmin,
                    "limited_admin" => AdminRole::LimitedAdmin,
                    "member_only" => AdminRole::MemberOnly,
                    "reporting_admin" => AdminRole::ReportingAdmin,
                    "security_admin" => AdminRole::SecurityAdmin,
                    "support_admin" => AdminRole::SupportAdmin,
                    "team_admin" => AdminRole::TeamAdmin,
                    "user_management_admin" => AdminRole::UserManagementAdmin,
                    _ => AdminRole::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["billing_admin",
                                    "compliance_admin",
                                    "content_admin",
                                    "limited_admin",
                                    "member_only",
                                    "reporting_admin",
                                    "security_admin",
                                    "support_admin",
                                    "team_admin",
                                    "user_management_admin",
                                    "other"];
        deserializer.deserialize_struct("AdminRole", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AdminRole {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AdminRole::BillingAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "billing_admin")?;
                s.end()
            }
            AdminRole::ComplianceAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "compliance_admin")?;
                s.end()
            }
            AdminRole::ContentAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "content_admin")?;
                s.end()
            }
            AdminRole::LimitedAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "limited_admin")?;
                s.end()
            }
            AdminRole::MemberOnly => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "member_only")?;
                s.end()
            }
            AdminRole::ReportingAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "reporting_admin")?;
                s.end()
            }
            AdminRole::SecurityAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "security_admin")?;
                s.end()
            }
            AdminRole::SupportAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "support_admin")?;
                s.end()
            }
            AdminRole::TeamAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "team_admin")?;
                s.end()
            }
            AdminRole::UserManagementAdmin => {
                // unit
                let mut s = serializer.serialize_struct("AdminRole", 1)?;
                s.serialize_field(".tag", "user_management_admin")?;
                s.end()
            }
            AdminRole::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Alert recipients setting type
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AlertRecipientsSettingType {
    CustomList,
    Invalid,
    None,
    TeamAdmins,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AlertRecipientsSettingType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AlertRecipientsSettingType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AlertRecipientsSettingType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "custom_list" => AlertRecipientsSettingType::CustomList,
                    "invalid" => AlertRecipientsSettingType::Invalid,
                    "none" => AlertRecipientsSettingType::None,
                    "team_admins" => AlertRecipientsSettingType::TeamAdmins,
                    _ => AlertRecipientsSettingType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["custom_list",
                                    "invalid",
                                    "none",
                                    "team_admins",
                                    "other"];
        deserializer.deserialize_struct("AlertRecipientsSettingType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AlertRecipientsSettingType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AlertRecipientsSettingType::CustomList => {
                // unit
                let mut s = serializer.serialize_struct("AlertRecipientsSettingType", 1)?;
                s.serialize_field(".tag", "custom_list")?;
                s.end()
            }
            AlertRecipientsSettingType::Invalid => {
                // unit
                let mut s = serializer.serialize_struct("AlertRecipientsSettingType", 1)?;
                s.serialize_field(".tag", "invalid")?;
                s.end()
            }
            AlertRecipientsSettingType::None => {
                // unit
                let mut s = serializer.serialize_struct("AlertRecipientsSettingType", 1)?;
                s.serialize_field(".tag", "none")?;
                s.end()
            }
            AlertRecipientsSettingType::TeamAdmins => {
                // unit
                let mut s = serializer.serialize_struct("AlertRecipientsSettingType", 1)?;
                s.serialize_field(".tag", "team_admins")?;
                s.end()
            }
            AlertRecipientsSettingType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Disabled downloads.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AllowDownloadDisabledDetails {
}

impl Default for AllowDownloadDisabledDetails {
    fn default() -> Self {
        AllowDownloadDisabledDetails {
        }
    }
}

const ALLOW_DOWNLOAD_DISABLED_DETAILS_FIELDS: &[&str] = &[];
impl AllowDownloadDisabledDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<AllowDownloadDisabledDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(AllowDownloadDisabledDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AllowDownloadDisabledDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AllowDownloadDisabledDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AllowDownloadDisabledDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AllowDownloadDisabledDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AllowDownloadDisabledDetails", ALLOW_DOWNLOAD_DISABLED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AllowDownloadDisabledDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("AllowDownloadDisabledDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AllowDownloadDisabledType {
    pub description: String,
}

impl AllowDownloadDisabledType {
    pub fn new(description: String) -> Self {
        AllowDownloadDisabledType {
            description,
        }
    }
}

const ALLOW_DOWNLOAD_DISABLED_TYPE_FIELDS: &[&str] = &["description"];
impl AllowDownloadDisabledType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AllowDownloadDisabledType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AllowDownloadDisabledType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AllowDownloadDisabledType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AllowDownloadDisabledType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AllowDownloadDisabledType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AllowDownloadDisabledType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AllowDownloadDisabledType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AllowDownloadDisabledType", ALLOW_DOWNLOAD_DISABLED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AllowDownloadDisabledType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AllowDownloadDisabledType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enabled downloads.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AllowDownloadEnabledDetails {
}

impl Default for AllowDownloadEnabledDetails {
    fn default() -> Self {
        AllowDownloadEnabledDetails {
        }
    }
}

const ALLOW_DOWNLOAD_ENABLED_DETAILS_FIELDS: &[&str] = &[];
impl AllowDownloadEnabledDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<AllowDownloadEnabledDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(AllowDownloadEnabledDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AllowDownloadEnabledDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AllowDownloadEnabledDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AllowDownloadEnabledDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AllowDownloadEnabledDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AllowDownloadEnabledDetails", ALLOW_DOWNLOAD_ENABLED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AllowDownloadEnabledDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("AllowDownloadEnabledDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AllowDownloadEnabledType {
    pub description: String,
}

impl AllowDownloadEnabledType {
    pub fn new(description: String) -> Self {
        AllowDownloadEnabledType {
            description,
        }
    }
}

const ALLOW_DOWNLOAD_ENABLED_TYPE_FIELDS: &[&str] = &["description"];
impl AllowDownloadEnabledType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AllowDownloadEnabledType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AllowDownloadEnabledType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AllowDownloadEnabledType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AllowDownloadEnabledType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AllowDownloadEnabledType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AllowDownloadEnabledType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AllowDownloadEnabledType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AllowDownloadEnabledType", ALLOW_DOWNLOAD_ENABLED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AllowDownloadEnabledType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AllowDownloadEnabledType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Api session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ApiSessionLogInfo {
    /// Api request ID.
    pub request_id: RequestId,
}

impl ApiSessionLogInfo {
    pub fn new(request_id: RequestId) -> Self {
        ApiSessionLogInfo {
            request_id,
        }
    }
}

const API_SESSION_LOG_INFO_FIELDS: &[&str] = &["request_id"];
impl ApiSessionLogInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ApiSessionLogInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ApiSessionLogInfo>, V::Error> {
        let mut field_request_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "request_id" => {
                    if field_request_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("request_id"));
                    }
                    field_request_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ApiSessionLogInfo {
            request_id: field_request_id.ok_or_else(|| ::serde::de::Error::missing_field("request_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("request_id", &self.request_id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ApiSessionLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ApiSessionLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ApiSessionLogInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ApiSessionLogInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ApiSessionLogInfo", API_SESSION_LOG_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ApiSessionLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ApiSessionLogInfo", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Failed to connect app for member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppBlockedByPermissionsDetails {
    /// Relevant application details.
    pub app_info: AppLogInfo,
}

impl AppBlockedByPermissionsDetails {
    pub fn new(app_info: AppLogInfo) -> Self {
        AppBlockedByPermissionsDetails {
            app_info,
        }
    }
}

const APP_BLOCKED_BY_PERMISSIONS_DETAILS_FIELDS: &[&str] = &["app_info"];
impl AppBlockedByPermissionsDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppBlockedByPermissionsDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppBlockedByPermissionsDetails>, V::Error> {
        let mut field_app_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_info" => {
                    if field_app_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_info"));
                    }
                    field_app_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppBlockedByPermissionsDetails {
            app_info: field_app_info.ok_or_else(|| ::serde::de::Error::missing_field("app_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_info", &self.app_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppBlockedByPermissionsDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppBlockedByPermissionsDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppBlockedByPermissionsDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppBlockedByPermissionsDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppBlockedByPermissionsDetails", APP_BLOCKED_BY_PERMISSIONS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppBlockedByPermissionsDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppBlockedByPermissionsDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppBlockedByPermissionsType {
    pub description: String,
}

impl AppBlockedByPermissionsType {
    pub fn new(description: String) -> Self {
        AppBlockedByPermissionsType {
            description,
        }
    }
}

const APP_BLOCKED_BY_PERMISSIONS_TYPE_FIELDS: &[&str] = &["description"];
impl AppBlockedByPermissionsType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppBlockedByPermissionsType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppBlockedByPermissionsType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppBlockedByPermissionsType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppBlockedByPermissionsType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppBlockedByPermissionsType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppBlockedByPermissionsType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppBlockedByPermissionsType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppBlockedByPermissionsType", APP_BLOCKED_BY_PERMISSIONS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppBlockedByPermissionsType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppBlockedByPermissionsType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Linked app for team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppLinkTeamDetails {
    /// Relevant application details.
    pub app_info: AppLogInfo,
}

impl AppLinkTeamDetails {
    pub fn new(app_info: AppLogInfo) -> Self {
        AppLinkTeamDetails {
            app_info,
        }
    }
}

const APP_LINK_TEAM_DETAILS_FIELDS: &[&str] = &["app_info"];
impl AppLinkTeamDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppLinkTeamDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppLinkTeamDetails>, V::Error> {
        let mut field_app_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_info" => {
                    if field_app_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_info"));
                    }
                    field_app_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppLinkTeamDetails {
            app_info: field_app_info.ok_or_else(|| ::serde::de::Error::missing_field("app_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_info", &self.app_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppLinkTeamDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppLinkTeamDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppLinkTeamDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppLinkTeamDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppLinkTeamDetails", APP_LINK_TEAM_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppLinkTeamDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppLinkTeamDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppLinkTeamType {
    pub description: String,
}

impl AppLinkTeamType {
    pub fn new(description: String) -> Self {
        AppLinkTeamType {
            description,
        }
    }
}

const APP_LINK_TEAM_TYPE_FIELDS: &[&str] = &["description"];
impl AppLinkTeamType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppLinkTeamType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppLinkTeamType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppLinkTeamType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppLinkTeamType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppLinkTeamType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppLinkTeamType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppLinkTeamType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppLinkTeamType", APP_LINK_TEAM_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppLinkTeamType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppLinkTeamType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Linked app for member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppLinkUserDetails {
    /// Relevant application details.
    pub app_info: AppLogInfo,
}

impl AppLinkUserDetails {
    pub fn new(app_info: AppLogInfo) -> Self {
        AppLinkUserDetails {
            app_info,
        }
    }
}

const APP_LINK_USER_DETAILS_FIELDS: &[&str] = &["app_info"];
impl AppLinkUserDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppLinkUserDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppLinkUserDetails>, V::Error> {
        let mut field_app_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_info" => {
                    if field_app_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_info"));
                    }
                    field_app_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppLinkUserDetails {
            app_info: field_app_info.ok_or_else(|| ::serde::de::Error::missing_field("app_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_info", &self.app_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppLinkUserDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppLinkUserDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppLinkUserDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppLinkUserDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppLinkUserDetails", APP_LINK_USER_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppLinkUserDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppLinkUserDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppLinkUserType {
    pub description: String,
}

impl AppLinkUserType {
    pub fn new(description: String) -> Self {
        AppLinkUserType {
            description,
        }
    }
}

const APP_LINK_USER_TYPE_FIELDS: &[&str] = &["description"];
impl AppLinkUserType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppLinkUserType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppLinkUserType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppLinkUserType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppLinkUserType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppLinkUserType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppLinkUserType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppLinkUserType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppLinkUserType", APP_LINK_USER_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppLinkUserType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppLinkUserType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// App's logged information.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AppLogInfo {
    UserOrTeamLinkedApp(UserOrTeamLinkedAppLogInfo),
    UserLinkedApp(UserLinkedAppLogInfo),
    TeamLinkedApp(TeamLinkedAppLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AppLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AppLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "user_or_team_linked_app" => Ok(AppLogInfo::UserOrTeamLinkedApp(UserOrTeamLinkedAppLogInfo::internal_deserialize(map)?)),
                    "user_linked_app" => Ok(AppLogInfo::UserLinkedApp(UserLinkedAppLogInfo::internal_deserialize(map)?)),
                    "team_linked_app" => Ok(AppLogInfo::TeamLinkedApp(TeamLinkedAppLogInfo::internal_deserialize(map)?)),
                    _ => {
                        crate::eat_json_fields(&mut map)?;
                        Ok(AppLogInfo::Other)
                    }
                }
            }
        }
        const VARIANTS: &[&str] = &["user_or_team_linked_app",
                                    "user_linked_app",
                                    "team_linked_app"];
        deserializer.deserialize_struct("AppLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AppLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            AppLogInfo::UserOrTeamLinkedApp(ref x) => {
                let mut s = serializer.serialize_struct("AppLogInfo", 3)?;
                s.serialize_field(".tag", "user_or_team_linked_app")?;
                s.serialize_field("app_id", &x.app_id)?;
                s.serialize_field("display_name", &x.display_name)?;
                s.end()
            }
            AppLogInfo::UserLinkedApp(ref x) => {
                let mut s = serializer.serialize_struct("AppLogInfo", 3)?;
                s.serialize_field(".tag", "user_linked_app")?;
                s.serialize_field("app_id", &x.app_id)?;
                s.serialize_field("display_name", &x.display_name)?;
                s.end()
            }
            AppLogInfo::TeamLinkedApp(ref x) => {
                let mut s = serializer.serialize_struct("AppLogInfo", 3)?;
                s.serialize_field(".tag", "team_linked_app")?;
                s.serialize_field("app_id", &x.app_id)?;
                s.serialize_field("display_name", &x.display_name)?;
                s.end()
            }
            AppLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize unknown variant"))
        }
    }
}

/// Changed app permissions.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppPermissionsChangedDetails {
    /// Previous policy.
    pub previous_value: AdminConsoleAppPolicy,
    /// New policy.
    pub new_value: AdminConsoleAppPolicy,
    /// Name of the app.
    pub app_name: Option<String>,
    /// Permission that was changed.
    pub permission: Option<AdminConsoleAppPermission>,
}

impl AppPermissionsChangedDetails {
    pub fn new(previous_value: AdminConsoleAppPolicy, new_value: AdminConsoleAppPolicy) -> Self {
        AppPermissionsChangedDetails {
            previous_value,
            new_value,
            app_name: None,
            permission: None,
        }
    }

    pub fn with_app_name(mut self, value: String) -> Self {
        self.app_name = Some(value);
        self
    }

    pub fn with_permission(mut self, value: AdminConsoleAppPermission) -> Self {
        self.permission = Some(value);
        self
    }
}

const APP_PERMISSIONS_CHANGED_DETAILS_FIELDS: &[&str] = &["previous_value",
                                                          "new_value",
                                                          "app_name",
                                                          "permission"];
impl AppPermissionsChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppPermissionsChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppPermissionsChangedDetails>, V::Error> {
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut field_app_name = None;
        let mut field_permission = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "app_name" => {
                    if field_app_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_name"));
                    }
                    field_app_name = Some(map.next_value()?);
                }
                "permission" => {
                    if field_permission.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permission"));
                    }
                    field_permission = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppPermissionsChangedDetails {
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            app_name: field_app_name,
            permission: field_permission,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        if let Some(val) = &self.app_name {
            s.serialize_field("app_name", val)?;
        }
        if let Some(val) = &self.permission {
            s.serialize_field("permission", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppPermissionsChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppPermissionsChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppPermissionsChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppPermissionsChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppPermissionsChangedDetails", APP_PERMISSIONS_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppPermissionsChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppPermissionsChangedDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppPermissionsChangedType {
    pub description: String,
}

impl AppPermissionsChangedType {
    pub fn new(description: String) -> Self {
        AppPermissionsChangedType {
            description,
        }
    }
}

const APP_PERMISSIONS_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl AppPermissionsChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppPermissionsChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppPermissionsChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppPermissionsChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppPermissionsChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppPermissionsChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppPermissionsChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppPermissionsChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppPermissionsChangedType", APP_PERMISSIONS_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppPermissionsChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppPermissionsChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Unlinked app for team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppUnlinkTeamDetails {
    /// Relevant application details.
    pub app_info: AppLogInfo,
}

impl AppUnlinkTeamDetails {
    pub fn new(app_info: AppLogInfo) -> Self {
        AppUnlinkTeamDetails {
            app_info,
        }
    }
}

const APP_UNLINK_TEAM_DETAILS_FIELDS: &[&str] = &["app_info"];
impl AppUnlinkTeamDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppUnlinkTeamDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppUnlinkTeamDetails>, V::Error> {
        let mut field_app_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_info" => {
                    if field_app_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_info"));
                    }
                    field_app_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppUnlinkTeamDetails {
            app_info: field_app_info.ok_or_else(|| ::serde::de::Error::missing_field("app_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_info", &self.app_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppUnlinkTeamDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppUnlinkTeamDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppUnlinkTeamDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppUnlinkTeamDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppUnlinkTeamDetails", APP_UNLINK_TEAM_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppUnlinkTeamDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppUnlinkTeamDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppUnlinkTeamType {
    pub description: String,
}

impl AppUnlinkTeamType {
    pub fn new(description: String) -> Self {
        AppUnlinkTeamType {
            description,
        }
    }
}

const APP_UNLINK_TEAM_TYPE_FIELDS: &[&str] = &["description"];
impl AppUnlinkTeamType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppUnlinkTeamType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppUnlinkTeamType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppUnlinkTeamType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppUnlinkTeamType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppUnlinkTeamType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppUnlinkTeamType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppUnlinkTeamType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppUnlinkTeamType", APP_UNLINK_TEAM_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppUnlinkTeamType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppUnlinkTeamType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Unlinked app for member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppUnlinkUserDetails {
    /// Relevant application details.
    pub app_info: AppLogInfo,
}

impl AppUnlinkUserDetails {
    pub fn new(app_info: AppLogInfo) -> Self {
        AppUnlinkUserDetails {
            app_info,
        }
    }
}

const APP_UNLINK_USER_DETAILS_FIELDS: &[&str] = &["app_info"];
impl AppUnlinkUserDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppUnlinkUserDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppUnlinkUserDetails>, V::Error> {
        let mut field_app_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "app_info" => {
                    if field_app_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("app_info"));
                    }
                    field_app_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppUnlinkUserDetails {
            app_info: field_app_info.ok_or_else(|| ::serde::de::Error::missing_field("app_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("app_info", &self.app_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppUnlinkUserDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppUnlinkUserDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppUnlinkUserDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppUnlinkUserDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppUnlinkUserDetails", APP_UNLINK_USER_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppUnlinkUserDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppUnlinkUserDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AppUnlinkUserType {
    pub description: String,
}

impl AppUnlinkUserType {
    pub fn new(description: String) -> Self {
        AppUnlinkUserType {
            description,
        }
    }
}

const APP_UNLINK_USER_TYPE_FIELDS: &[&str] = &["description"];
impl AppUnlinkUserType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AppUnlinkUserType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AppUnlinkUserType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AppUnlinkUserType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AppUnlinkUserType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AppUnlinkUserType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AppUnlinkUserType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AppUnlinkUserType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AppUnlinkUserType", APP_UNLINK_USER_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AppUnlinkUserType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AppUnlinkUserType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Applied a Naming Convention rule.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ApplyNamingConventionDetails {
}

impl Default for ApplyNamingConventionDetails {
    fn default() -> Self {
        ApplyNamingConventionDetails {
        }
    }
}

const APPLY_NAMING_CONVENTION_DETAILS_FIELDS: &[&str] = &[];
impl ApplyNamingConventionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ApplyNamingConventionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(ApplyNamingConventionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ApplyNamingConventionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ApplyNamingConventionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ApplyNamingConventionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ApplyNamingConventionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ApplyNamingConventionDetails", APPLY_NAMING_CONVENTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ApplyNamingConventionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("ApplyNamingConventionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ApplyNamingConventionType {
    pub description: String,
}

impl ApplyNamingConventionType {
    pub fn new(description: String) -> Self {
        ApplyNamingConventionType {
            description,
        }
    }
}

const APPLY_NAMING_CONVENTION_TYPE_FIELDS: &[&str] = &["description"];
impl ApplyNamingConventionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ApplyNamingConventionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ApplyNamingConventionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ApplyNamingConventionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ApplyNamingConventionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ApplyNamingConventionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ApplyNamingConventionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ApplyNamingConventionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ApplyNamingConventionType", APPLY_NAMING_CONVENTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ApplyNamingConventionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ApplyNamingConventionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Asset details.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AssetLogInfo {
    /// File's details.
    File(FileLogInfo),
    /// Folder's details.
    Folder(FolderLogInfo),
    /// Paper document's details.
    PaperDocument(PaperDocumentLogInfo),
    /// Paper folder's details.
    PaperFolder(PaperFolderLogInfo),
    /// Showcase document's details.
    ShowcaseDocument(ShowcaseDocumentLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AssetLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AssetLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AssetLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "file" => AssetLogInfo::File(FileLogInfo::internal_deserialize(&mut map)?),
                    "folder" => AssetLogInfo::Folder(FolderLogInfo::internal_deserialize(&mut map)?),
                    "paper_document" => AssetLogInfo::PaperDocument(PaperDocumentLogInfo::internal_deserialize(&mut map)?),
                    "paper_folder" => AssetLogInfo::PaperFolder(PaperFolderLogInfo::internal_deserialize(&mut map)?),
                    "showcase_document" => AssetLogInfo::ShowcaseDocument(ShowcaseDocumentLogInfo::internal_deserialize(&mut map)?),
                    _ => AssetLogInfo::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["file",
                                    "folder",
                                    "paper_document",
                                    "paper_folder",
                                    "showcase_document",
                                    "other"];
        deserializer.deserialize_struct("AssetLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AssetLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AssetLogInfo::File(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AssetLogInfo", 5)?;
                s.serialize_field(".tag", "file")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AssetLogInfo::Folder(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AssetLogInfo", 6)?;
                s.serialize_field(".tag", "folder")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AssetLogInfo::PaperDocument(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AssetLogInfo", 3)?;
                s.serialize_field(".tag", "paper_document")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AssetLogInfo::PaperFolder(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AssetLogInfo", 3)?;
                s.serialize_field(".tag", "paper_folder")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AssetLogInfo::ShowcaseDocument(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("AssetLogInfo", 3)?;
                s.serialize_field(".tag", "showcase_document")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            AssetLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Backup status
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum BackupStatus {
    Disabled,
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for BackupStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = BackupStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BackupStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => BackupStatus::Disabled,
                    "enabled" => BackupStatus::Enabled,
                    _ => BackupStatus::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("BackupStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for BackupStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            BackupStatus::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("BackupStatus", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            BackupStatus::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("BackupStatus", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            BackupStatus::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Added Binder page.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderAddPageDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderAddPageDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderAddPageDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_ADD_PAGE_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                  "doc_title",
                                                  "binder_item_name"];
impl BinderAddPageDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderAddPageDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderAddPageDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderAddPageDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderAddPageDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderAddPageDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderAddPageDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderAddPageDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderAddPageDetails", BINDER_ADD_PAGE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderAddPageDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderAddPageDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderAddPageType {
    pub description: String,
}

impl BinderAddPageType {
    pub fn new(description: String) -> Self {
        BinderAddPageType {
            description,
        }
    }
}

const BINDER_ADD_PAGE_TYPE_FIELDS: &[&str] = &["description"];
impl BinderAddPageType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderAddPageType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderAddPageType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderAddPageType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderAddPageType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderAddPageType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderAddPageType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderAddPageType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderAddPageType", BINDER_ADD_PAGE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderAddPageType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderAddPageType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Added Binder section.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderAddSectionDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderAddSectionDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderAddSectionDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_ADD_SECTION_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                     "doc_title",
                                                     "binder_item_name"];
impl BinderAddSectionDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderAddSectionDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderAddSectionDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderAddSectionDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderAddSectionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderAddSectionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderAddSectionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderAddSectionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderAddSectionDetails", BINDER_ADD_SECTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderAddSectionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderAddSectionDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderAddSectionType {
    pub description: String,
}

impl BinderAddSectionType {
    pub fn new(description: String) -> Self {
        BinderAddSectionType {
            description,
        }
    }
}

const BINDER_ADD_SECTION_TYPE_FIELDS: &[&str] = &["description"];
impl BinderAddSectionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderAddSectionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderAddSectionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderAddSectionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderAddSectionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderAddSectionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderAddSectionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderAddSectionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderAddSectionType", BINDER_ADD_SECTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderAddSectionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderAddSectionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Removed Binder page.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRemovePageDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderRemovePageDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderRemovePageDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_REMOVE_PAGE_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                     "doc_title",
                                                     "binder_item_name"];
impl BinderRemovePageDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRemovePageDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRemovePageDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRemovePageDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRemovePageDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRemovePageDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRemovePageDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRemovePageDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRemovePageDetails", BINDER_REMOVE_PAGE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRemovePageDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRemovePageDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRemovePageType {
    pub description: String,
}

impl BinderRemovePageType {
    pub fn new(description: String) -> Self {
        BinderRemovePageType {
            description,
        }
    }
}

const BINDER_REMOVE_PAGE_TYPE_FIELDS: &[&str] = &["description"];
impl BinderRemovePageType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRemovePageType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRemovePageType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRemovePageType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRemovePageType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRemovePageType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRemovePageType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRemovePageType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRemovePageType", BINDER_REMOVE_PAGE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRemovePageType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRemovePageType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Removed Binder section.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRemoveSectionDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderRemoveSectionDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderRemoveSectionDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_REMOVE_SECTION_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                        "doc_title",
                                                        "binder_item_name"];
impl BinderRemoveSectionDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRemoveSectionDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRemoveSectionDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRemoveSectionDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRemoveSectionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRemoveSectionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRemoveSectionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRemoveSectionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRemoveSectionDetails", BINDER_REMOVE_SECTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRemoveSectionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRemoveSectionDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRemoveSectionType {
    pub description: String,
}

impl BinderRemoveSectionType {
    pub fn new(description: String) -> Self {
        BinderRemoveSectionType {
            description,
        }
    }
}

const BINDER_REMOVE_SECTION_TYPE_FIELDS: &[&str] = &["description"];
impl BinderRemoveSectionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRemoveSectionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRemoveSectionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRemoveSectionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRemoveSectionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRemoveSectionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRemoveSectionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRemoveSectionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRemoveSectionType", BINDER_REMOVE_SECTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRemoveSectionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRemoveSectionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Renamed Binder page.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRenamePageDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
    /// Previous name of the Binder page/section.
    pub previous_binder_item_name: Option<String>,
}

impl BinderRenamePageDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderRenamePageDetails {
            event_uuid,
            doc_title,
            binder_item_name,
            previous_binder_item_name: None,
        }
    }

    pub fn with_previous_binder_item_name(mut self, value: String) -> Self {
        self.previous_binder_item_name = Some(value);
        self
    }
}

const BINDER_RENAME_PAGE_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                     "doc_title",
                                                     "binder_item_name",
                                                     "previous_binder_item_name"];
impl BinderRenamePageDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRenamePageDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRenamePageDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut field_previous_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                "previous_binder_item_name" => {
                    if field_previous_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_binder_item_name"));
                    }
                    field_previous_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRenamePageDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
            previous_binder_item_name: field_previous_binder_item_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        if let Some(val) = &self.previous_binder_item_name {
            s.serialize_field("previous_binder_item_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRenamePageDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRenamePageDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRenamePageDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRenamePageDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRenamePageDetails", BINDER_RENAME_PAGE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRenamePageDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRenamePageDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRenamePageType {
    pub description: String,
}

impl BinderRenamePageType {
    pub fn new(description: String) -> Self {
        BinderRenamePageType {
            description,
        }
    }
}

const BINDER_RENAME_PAGE_TYPE_FIELDS: &[&str] = &["description"];
impl BinderRenamePageType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRenamePageType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRenamePageType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRenamePageType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRenamePageType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRenamePageType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRenamePageType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRenamePageType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRenamePageType", BINDER_RENAME_PAGE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRenamePageType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRenamePageType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Renamed Binder section.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRenameSectionDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
    /// Previous name of the Binder page/section.
    pub previous_binder_item_name: Option<String>,
}

impl BinderRenameSectionDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderRenameSectionDetails {
            event_uuid,
            doc_title,
            binder_item_name,
            previous_binder_item_name: None,
        }
    }

    pub fn with_previous_binder_item_name(mut self, value: String) -> Self {
        self.previous_binder_item_name = Some(value);
        self
    }
}

const BINDER_RENAME_SECTION_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                        "doc_title",
                                                        "binder_item_name",
                                                        "previous_binder_item_name"];
impl BinderRenameSectionDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRenameSectionDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRenameSectionDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut field_previous_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                "previous_binder_item_name" => {
                    if field_previous_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_binder_item_name"));
                    }
                    field_previous_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRenameSectionDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
            previous_binder_item_name: field_previous_binder_item_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        if let Some(val) = &self.previous_binder_item_name {
            s.serialize_field("previous_binder_item_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRenameSectionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRenameSectionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRenameSectionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRenameSectionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRenameSectionDetails", BINDER_RENAME_SECTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRenameSectionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRenameSectionDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderRenameSectionType {
    pub description: String,
}

impl BinderRenameSectionType {
    pub fn new(description: String) -> Self {
        BinderRenameSectionType {
            description,
        }
    }
}

const BINDER_RENAME_SECTION_TYPE_FIELDS: &[&str] = &["description"];
impl BinderRenameSectionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderRenameSectionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderRenameSectionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderRenameSectionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderRenameSectionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderRenameSectionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderRenameSectionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderRenameSectionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderRenameSectionType", BINDER_RENAME_SECTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderRenameSectionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderRenameSectionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Reordered Binder page.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderReorderPageDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderReorderPageDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderReorderPageDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_REORDER_PAGE_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                      "doc_title",
                                                      "binder_item_name"];
impl BinderReorderPageDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderReorderPageDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderReorderPageDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderReorderPageDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderReorderPageDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderReorderPageDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderReorderPageDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderReorderPageDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderReorderPageDetails", BINDER_REORDER_PAGE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderReorderPageDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderReorderPageDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderReorderPageType {
    pub description: String,
}

impl BinderReorderPageType {
    pub fn new(description: String) -> Self {
        BinderReorderPageType {
            description,
        }
    }
}

const BINDER_REORDER_PAGE_TYPE_FIELDS: &[&str] = &["description"];
impl BinderReorderPageType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderReorderPageType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderReorderPageType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderReorderPageType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderReorderPageType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderReorderPageType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderReorderPageType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderReorderPageType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderReorderPageType", BINDER_REORDER_PAGE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderReorderPageType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderReorderPageType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Reordered Binder section.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderReorderSectionDetails {
    /// Event unique identifier.
    pub event_uuid: String,
    /// Title of the Binder doc.
    pub doc_title: String,
    /// Name of the Binder page/section.
    pub binder_item_name: String,
}

impl BinderReorderSectionDetails {
    pub fn new(event_uuid: String, doc_title: String, binder_item_name: String) -> Self {
        BinderReorderSectionDetails {
            event_uuid,
            doc_title,
            binder_item_name,
        }
    }
}

const BINDER_REORDER_SECTION_DETAILS_FIELDS: &[&str] = &["event_uuid",
                                                         "doc_title",
                                                         "binder_item_name"];
impl BinderReorderSectionDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderReorderSectionDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderReorderSectionDetails>, V::Error> {
        let mut field_event_uuid = None;
        let mut field_doc_title = None;
        let mut field_binder_item_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "event_uuid" => {
                    if field_event_uuid.is_some() {
                        return Err(::serde::de::Error::duplicate_field("event_uuid"));
                    }
                    field_event_uuid = Some(map.next_value()?);
                }
                "doc_title" => {
                    if field_doc_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("doc_title"));
                    }
                    field_doc_title = Some(map.next_value()?);
                }
                "binder_item_name" => {
                    if field_binder_item_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("binder_item_name"));
                    }
                    field_binder_item_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderReorderSectionDetails {
            event_uuid: field_event_uuid.ok_or_else(|| ::serde::de::Error::missing_field("event_uuid"))?,
            doc_title: field_doc_title.ok_or_else(|| ::serde::de::Error::missing_field("doc_title"))?,
            binder_item_name: field_binder_item_name.ok_or_else(|| ::serde::de::Error::missing_field("binder_item_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("event_uuid", &self.event_uuid)?;
        s.serialize_field("doc_title", &self.doc_title)?;
        s.serialize_field("binder_item_name", &self.binder_item_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderReorderSectionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderReorderSectionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderReorderSectionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderReorderSectionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderReorderSectionDetails", BINDER_REORDER_SECTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderReorderSectionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderReorderSectionDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BinderReorderSectionType {
    pub description: String,
}

impl BinderReorderSectionType {
    pub fn new(description: String) -> Self {
        BinderReorderSectionType {
            description,
        }
    }
}

const BINDER_REORDER_SECTION_TYPE_FIELDS: &[&str] = &["description"];
impl BinderReorderSectionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BinderReorderSectionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BinderReorderSectionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BinderReorderSectionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BinderReorderSectionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BinderReorderSectionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BinderReorderSectionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BinderReorderSectionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BinderReorderSectionType", BINDER_REORDER_SECTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BinderReorderSectionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BinderReorderSectionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for controlling if team members can activate camera uploads
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CameraUploadsPolicy {
    Disabled,
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CameraUploadsPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CameraUploadsPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CameraUploadsPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => CameraUploadsPolicy::Disabled,
                    "enabled" => CameraUploadsPolicy::Enabled,
                    _ => CameraUploadsPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("CameraUploadsPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CameraUploadsPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CameraUploadsPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("CameraUploadsPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            CameraUploadsPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("CameraUploadsPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            CameraUploadsPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed camera uploads setting for team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CameraUploadsPolicyChangedDetails {
    /// New camera uploads setting.
    pub new_value: CameraUploadsPolicy,
    /// Previous camera uploads setting.
    pub previous_value: CameraUploadsPolicy,
}

impl CameraUploadsPolicyChangedDetails {
    pub fn new(new_value: CameraUploadsPolicy, previous_value: CameraUploadsPolicy) -> Self {
        CameraUploadsPolicyChangedDetails {
            new_value,
            previous_value,
        }
    }
}

const CAMERA_UPLOADS_POLICY_CHANGED_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                "previous_value"];
impl CameraUploadsPolicyChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CameraUploadsPolicyChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CameraUploadsPolicyChangedDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CameraUploadsPolicyChangedDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CameraUploadsPolicyChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CameraUploadsPolicyChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CameraUploadsPolicyChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CameraUploadsPolicyChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CameraUploadsPolicyChangedDetails", CAMERA_UPLOADS_POLICY_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CameraUploadsPolicyChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CameraUploadsPolicyChangedDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CameraUploadsPolicyChangedType {
    pub description: String,
}

impl CameraUploadsPolicyChangedType {
    pub fn new(description: String) -> Self {
        CameraUploadsPolicyChangedType {
            description,
        }
    }
}

const CAMERA_UPLOADS_POLICY_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl CameraUploadsPolicyChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CameraUploadsPolicyChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CameraUploadsPolicyChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CameraUploadsPolicyChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CameraUploadsPolicyChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CameraUploadsPolicyChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CameraUploadsPolicyChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CameraUploadsPolicyChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CameraUploadsPolicyChangedType", CAMERA_UPLOADS_POLICY_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CameraUploadsPolicyChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CameraUploadsPolicyChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Certificate details.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Certificate {
    /// Certificate subject.
    pub subject: String,
    /// Certificate issuer.
    pub issuer: String,
    /// Certificate issue date.
    pub issue_date: String,
    /// Certificate expiration date.
    pub expiration_date: String,
    /// Certificate serial number.
    pub serial_number: String,
    /// Certificate sha1 fingerprint.
    pub sha1_fingerprint: String,
    /// Certificate common name.
    pub common_name: Option<String>,
}

impl Certificate {
    pub fn new(
        subject: String,
        issuer: String,
        issue_date: String,
        expiration_date: String,
        serial_number: String,
        sha1_fingerprint: String,
    ) -> Self {
        Certificate {
            subject,
            issuer,
            issue_date,
            expiration_date,
            serial_number,
            sha1_fingerprint,
            common_name: None,
        }
    }

    pub fn with_common_name(mut self, value: String) -> Self {
        self.common_name = Some(value);
        self
    }
}

const CERTIFICATE_FIELDS: &[&str] = &["subject",
                                      "issuer",
                                      "issue_date",
                                      "expiration_date",
                                      "serial_number",
                                      "sha1_fingerprint",
                                      "common_name"];
impl Certificate {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Certificate, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Certificate>, V::Error> {
        let mut field_subject = None;
        let mut field_issuer = None;
        let mut field_issue_date = None;
        let mut field_expiration_date = None;
        let mut field_serial_number = None;
        let mut field_sha1_fingerprint = None;
        let mut field_common_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "subject" => {
                    if field_subject.is_some() {
                        return Err(::serde::de::Error::duplicate_field("subject"));
                    }
                    field_subject = Some(map.next_value()?);
                }
                "issuer" => {
                    if field_issuer.is_some() {
                        return Err(::serde::de::Error::duplicate_field("issuer"));
                    }
                    field_issuer = Some(map.next_value()?);
                }
                "issue_date" => {
                    if field_issue_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("issue_date"));
                    }
                    field_issue_date = Some(map.next_value()?);
                }
                "expiration_date" => {
                    if field_expiration_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiration_date"));
                    }
                    field_expiration_date = Some(map.next_value()?);
                }
                "serial_number" => {
                    if field_serial_number.is_some() {
                        return Err(::serde::de::Error::duplicate_field("serial_number"));
                    }
                    field_serial_number = Some(map.next_value()?);
                }
                "sha1_fingerprint" => {
                    if field_sha1_fingerprint.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sha1_fingerprint"));
                    }
                    field_sha1_fingerprint = Some(map.next_value()?);
                }
                "common_name" => {
                    if field_common_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("common_name"));
                    }
                    field_common_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Certificate {
            subject: field_subject.ok_or_else(|| ::serde::de::Error::missing_field("subject"))?,
            issuer: field_issuer.ok_or_else(|| ::serde::de::Error::missing_field("issuer"))?,
            issue_date: field_issue_date.ok_or_else(|| ::serde::de::Error::missing_field("issue_date"))?,
            expiration_date: field_expiration_date.ok_or_else(|| ::serde::de::Error::missing_field("expiration_date"))?,
            serial_number: field_serial_number.ok_or_else(|| ::serde::de::Error::missing_field("serial_number"))?,
            sha1_fingerprint: field_sha1_fingerprint.ok_or_else(|| ::serde::de::Error::missing_field("sha1_fingerprint"))?,
            common_name: field_common_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("subject", &self.subject)?;
        s.serialize_field("issuer", &self.issuer)?;
        s.serialize_field("issue_date", &self.issue_date)?;
        s.serialize_field("expiration_date", &self.expiration_date)?;
        s.serialize_field("serial_number", &self.serial_number)?;
        s.serialize_field("sha1_fingerprint", &self.sha1_fingerprint)?;
        if let Some(val) = &self.common_name {
            s.serialize_field("common_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Certificate {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Certificate;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Certificate struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Certificate::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Certificate", CERTIFICATE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Certificate {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Certificate", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for deciding whether the team's default expiration days policy must be enforced when an
/// externally shared is updated
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ChangeLinkExpirationPolicy {
    Allowed,
    NotAllowed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ChangeLinkExpirationPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ChangeLinkExpirationPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangeLinkExpirationPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "allowed" => ChangeLinkExpirationPolicy::Allowed,
                    "not_allowed" => ChangeLinkExpirationPolicy::NotAllowed,
                    _ => ChangeLinkExpirationPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["allowed",
                                    "not_allowed",
                                    "other"];
        deserializer.deserialize_struct("ChangeLinkExpirationPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ChangeLinkExpirationPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ChangeLinkExpirationPolicy::Allowed => {
                // unit
                let mut s = serializer.serialize_struct("ChangeLinkExpirationPolicy", 1)?;
                s.serialize_field(".tag", "allowed")?;
                s.end()
            }
            ChangeLinkExpirationPolicy::NotAllowed => {
                // unit
                let mut s = serializer.serialize_struct("ChangeLinkExpirationPolicy", 1)?;
                s.serialize_field(".tag", "not_allowed")?;
                s.end()
            }
            ChangeLinkExpirationPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed enterprise admin role.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ChangedEnterpriseAdminRoleDetails {
    /// The member&#x2019s previous enterprise admin role.
    pub previous_value: FedAdminRole,
    /// The member&#x2019s new enterprise admin role.
    pub new_value: FedAdminRole,
    /// The name of the member&#x2019s team.
    pub team_name: String,
}

impl ChangedEnterpriseAdminRoleDetails {
    pub fn new(previous_value: FedAdminRole, new_value: FedAdminRole, team_name: String) -> Self {
        ChangedEnterpriseAdminRoleDetails {
            previous_value,
            new_value,
            team_name,
        }
    }
}

const CHANGED_ENTERPRISE_ADMIN_ROLE_DETAILS_FIELDS: &[&str] = &["previous_value",
                                                                "new_value",
                                                                "team_name"];
impl ChangedEnterpriseAdminRoleDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ChangedEnterpriseAdminRoleDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ChangedEnterpriseAdminRoleDetails>, V::Error> {
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut field_team_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "team_name" => {
                    if field_team_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_name"));
                    }
                    field_team_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ChangedEnterpriseAdminRoleDetails {
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            team_name: field_team_name.ok_or_else(|| ::serde::de::Error::missing_field("team_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        s.serialize_field("team_name", &self.team_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ChangedEnterpriseAdminRoleDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ChangedEnterpriseAdminRoleDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangedEnterpriseAdminRoleDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ChangedEnterpriseAdminRoleDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ChangedEnterpriseAdminRoleDetails", CHANGED_ENTERPRISE_ADMIN_ROLE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ChangedEnterpriseAdminRoleDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ChangedEnterpriseAdminRoleDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ChangedEnterpriseAdminRoleType {
    pub description: String,
}

impl ChangedEnterpriseAdminRoleType {
    pub fn new(description: String) -> Self {
        ChangedEnterpriseAdminRoleType {
            description,
        }
    }
}

const CHANGED_ENTERPRISE_ADMIN_ROLE_TYPE_FIELDS: &[&str] = &["description"];
impl ChangedEnterpriseAdminRoleType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ChangedEnterpriseAdminRoleType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ChangedEnterpriseAdminRoleType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ChangedEnterpriseAdminRoleType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ChangedEnterpriseAdminRoleType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ChangedEnterpriseAdminRoleType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangedEnterpriseAdminRoleType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ChangedEnterpriseAdminRoleType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ChangedEnterpriseAdminRoleType", CHANGED_ENTERPRISE_ADMIN_ROLE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ChangedEnterpriseAdminRoleType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ChangedEnterpriseAdminRoleType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed enterprise-connected team status.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ChangedEnterpriseConnectedTeamStatusDetails {
    /// The preformed change in the team&#x2019s connection status.
    pub action: FedHandshakeAction,
    /// Additional information about the organization or team.
    pub additional_info: FederationStatusChangeAdditionalInfo,
    /// Previous request state.
    pub previous_value: TrustedTeamsRequestState,
    /// New request state.
    pub new_value: TrustedTeamsRequestState,
}

impl ChangedEnterpriseConnectedTeamStatusDetails {
    pub fn new(
        action: FedHandshakeAction,
        additional_info: FederationStatusChangeAdditionalInfo,
        previous_value: TrustedTeamsRequestState,
        new_value: TrustedTeamsRequestState,
    ) -> Self {
        ChangedEnterpriseConnectedTeamStatusDetails {
            action,
            additional_info,
            previous_value,
            new_value,
        }
    }
}

const CHANGED_ENTERPRISE_CONNECTED_TEAM_STATUS_DETAILS_FIELDS: &[&str] = &["action",
                                                                           "additional_info",
                                                                           "previous_value",
                                                                           "new_value"];
impl ChangedEnterpriseConnectedTeamStatusDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ChangedEnterpriseConnectedTeamStatusDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ChangedEnterpriseConnectedTeamStatusDetails>, V::Error> {
        let mut field_action = None;
        let mut field_additional_info = None;
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "action" => {
                    if field_action.is_some() {
                        return Err(::serde::de::Error::duplicate_field("action"));
                    }
                    field_action = Some(map.next_value()?);
                }
                "additional_info" => {
                    if field_additional_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("additional_info"));
                    }
                    field_additional_info = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ChangedEnterpriseConnectedTeamStatusDetails {
            action: field_action.ok_or_else(|| ::serde::de::Error::missing_field("action"))?,
            additional_info: field_additional_info.ok_or_else(|| ::serde::de::Error::missing_field("additional_info"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("action", &self.action)?;
        s.serialize_field("additional_info", &self.additional_info)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ChangedEnterpriseConnectedTeamStatusDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ChangedEnterpriseConnectedTeamStatusDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangedEnterpriseConnectedTeamStatusDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ChangedEnterpriseConnectedTeamStatusDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ChangedEnterpriseConnectedTeamStatusDetails", CHANGED_ENTERPRISE_CONNECTED_TEAM_STATUS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ChangedEnterpriseConnectedTeamStatusDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ChangedEnterpriseConnectedTeamStatusDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ChangedEnterpriseConnectedTeamStatusType {
    pub description: String,
}

impl ChangedEnterpriseConnectedTeamStatusType {
    pub fn new(description: String) -> Self {
        ChangedEnterpriseConnectedTeamStatusType {
            description,
        }
    }
}

const CHANGED_ENTERPRISE_CONNECTED_TEAM_STATUS_TYPE_FIELDS: &[&str] = &["description"];
impl ChangedEnterpriseConnectedTeamStatusType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ChangedEnterpriseConnectedTeamStatusType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ChangedEnterpriseConnectedTeamStatusType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ChangedEnterpriseConnectedTeamStatusType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ChangedEnterpriseConnectedTeamStatusType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ChangedEnterpriseConnectedTeamStatusType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangedEnterpriseConnectedTeamStatusType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ChangedEnterpriseConnectedTeamStatusType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ChangedEnterpriseConnectedTeamStatusType", CHANGED_ENTERPRISE_CONNECTED_TEAM_STATUS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ChangedEnterpriseConnectedTeamStatusType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ChangedEnterpriseConnectedTeamStatusType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed classification policy for team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationChangePolicyDetails {
    /// Previous classification policy.
    pub previous_value: ClassificationPolicyEnumWrapper,
    /// New classification policy.
    pub new_value: ClassificationPolicyEnumWrapper,
    /// Policy type.
    pub classification_type: ClassificationType,
}

impl ClassificationChangePolicyDetails {
    pub fn new(
        previous_value: ClassificationPolicyEnumWrapper,
        new_value: ClassificationPolicyEnumWrapper,
        classification_type: ClassificationType,
    ) -> Self {
        ClassificationChangePolicyDetails {
            previous_value,
            new_value,
            classification_type,
        }
    }
}

const CLASSIFICATION_CHANGE_POLICY_DETAILS_FIELDS: &[&str] = &["previous_value",
                                                               "new_value",
                                                               "classification_type"];
impl ClassificationChangePolicyDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ClassificationChangePolicyDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ClassificationChangePolicyDetails>, V::Error> {
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut field_classification_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "classification_type" => {
                    if field_classification_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("classification_type"));
                    }
                    field_classification_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ClassificationChangePolicyDetails {
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            classification_type: field_classification_type.ok_or_else(|| ::serde::de::Error::missing_field("classification_type"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        s.serialize_field("classification_type", &self.classification_type)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationChangePolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationChangePolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationChangePolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationChangePolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationChangePolicyDetails", CLASSIFICATION_CHANGE_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationChangePolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ClassificationChangePolicyDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationChangePolicyType {
    pub description: String,
}

impl ClassificationChangePolicyType {
    pub fn new(description: String) -> Self {
        ClassificationChangePolicyType {
            description,
        }
    }
}

const CLASSIFICATION_CHANGE_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl ClassificationChangePolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ClassificationChangePolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ClassificationChangePolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ClassificationChangePolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationChangePolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationChangePolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationChangePolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationChangePolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationChangePolicyType", CLASSIFICATION_CHANGE_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationChangePolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ClassificationChangePolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Created Classification report.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationCreateReportDetails {
}

impl Default for ClassificationCreateReportDetails {
    fn default() -> Self {
        ClassificationCreateReportDetails {
        }
    }
}

const CLASSIFICATION_CREATE_REPORT_DETAILS_FIELDS: &[&str] = &[];
impl ClassificationCreateReportDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ClassificationCreateReportDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(ClassificationCreateReportDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationCreateReportDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationCreateReportDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationCreateReportDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationCreateReportDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationCreateReportDetails", CLASSIFICATION_CREATE_REPORT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationCreateReportDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("ClassificationCreateReportDetails", 0)?.end()
    }
}

/// Couldn't create Classification report.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationCreateReportFailDetails {
    /// Failure reason.
    pub failure_reason: super::team::TeamReportFailureReason,
}

impl ClassificationCreateReportFailDetails {
    pub fn new(failure_reason: super::team::TeamReportFailureReason) -> Self {
        ClassificationCreateReportFailDetails {
            failure_reason,
        }
    }
}

const CLASSIFICATION_CREATE_REPORT_FAIL_DETAILS_FIELDS: &[&str] = &["failure_reason"];
impl ClassificationCreateReportFailDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ClassificationCreateReportFailDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ClassificationCreateReportFailDetails>, V::Error> {
        let mut field_failure_reason = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "failure_reason" => {
                    if field_failure_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("failure_reason"));
                    }
                    field_failure_reason = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ClassificationCreateReportFailDetails {
            failure_reason: field_failure_reason.ok_or_else(|| ::serde::de::Error::missing_field("failure_reason"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("failure_reason", &self.failure_reason)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationCreateReportFailDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationCreateReportFailDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationCreateReportFailDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationCreateReportFailDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationCreateReportFailDetails", CLASSIFICATION_CREATE_REPORT_FAIL_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationCreateReportFailDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ClassificationCreateReportFailDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationCreateReportFailType {
    pub description: String,
}

impl ClassificationCreateReportFailType {
    pub fn new(description: String) -> Self {
        ClassificationCreateReportFailType {
            description,
        }
    }
}

const CLASSIFICATION_CREATE_REPORT_FAIL_TYPE_FIELDS: &[&str] = &["description"];
impl ClassificationCreateReportFailType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ClassificationCreateReportFailType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ClassificationCreateReportFailType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ClassificationCreateReportFailType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationCreateReportFailType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationCreateReportFailType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationCreateReportFailType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationCreateReportFailType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationCreateReportFailType", CLASSIFICATION_CREATE_REPORT_FAIL_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationCreateReportFailType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ClassificationCreateReportFailType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ClassificationCreateReportType {
    pub description: String,
}

impl ClassificationCreateReportType {
    pub fn new(description: String) -> Self {
        ClassificationCreateReportType {
            description,
        }
    }
}

const CLASSIFICATION_CREATE_REPORT_TYPE_FIELDS: &[&str] = &["description"];
impl ClassificationCreateReportType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ClassificationCreateReportType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ClassificationCreateReportType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ClassificationCreateReportType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationCreateReportType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ClassificationCreateReportType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationCreateReportType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ClassificationCreateReportType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ClassificationCreateReportType", CLASSIFICATION_CREATE_REPORT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationCreateReportType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ClassificationCreateReportType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for controlling team access to the classification feature
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ClassificationPolicyEnumWrapper {
    Disabled,
    Enabled,
    MemberAndTeamFolders,
    TeamFolders,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationPolicyEnumWrapper {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ClassificationPolicyEnumWrapper;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationPolicyEnumWrapper structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ClassificationPolicyEnumWrapper::Disabled,
                    "enabled" => ClassificationPolicyEnumWrapper::Enabled,
                    "member_and_team_folders" => ClassificationPolicyEnumWrapper::MemberAndTeamFolders,
                    "team_folders" => ClassificationPolicyEnumWrapper::TeamFolders,
                    _ => ClassificationPolicyEnumWrapper::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "member_and_team_folders",
                                    "team_folders",
                                    "other"];
        deserializer.deserialize_struct("ClassificationPolicyEnumWrapper", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationPolicyEnumWrapper {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ClassificationPolicyEnumWrapper::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationPolicyEnumWrapper", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ClassificationPolicyEnumWrapper::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationPolicyEnumWrapper", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ClassificationPolicyEnumWrapper::MemberAndTeamFolders => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationPolicyEnumWrapper", 1)?;
                s.serialize_field(".tag", "member_and_team_folders")?;
                s.end()
            }
            ClassificationPolicyEnumWrapper::TeamFolders => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationPolicyEnumWrapper", 1)?;
                s.serialize_field(".tag", "team_folders")?;
                s.end()
            }
            ClassificationPolicyEnumWrapper::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The type of classification (currently only personal information)
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ClassificationType {
    PersonalInformation,
    Pii,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ClassificationType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ClassificationType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ClassificationType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "personal_information" => ClassificationType::PersonalInformation,
                    "pii" => ClassificationType::Pii,
                    _ => ClassificationType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["personal_information",
                                    "pii",
                                    "other"];
        deserializer.deserialize_struct("ClassificationType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ClassificationType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ClassificationType::PersonalInformation => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationType", 1)?;
                s.serialize_field(".tag", "personal_information")?;
                s.end()
            }
            ClassificationType::Pii => {
                // unit
                let mut s = serializer.serialize_struct("ClassificationType", 1)?;
                s.serialize_field(".tag", "pii")?;
                s.end()
            }
            ClassificationType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Shared album.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CollectionShareDetails {
    /// Album name.
    pub album_name: String,
}

impl CollectionShareDetails {
    pub fn new(album_name: String) -> Self {
        CollectionShareDetails {
            album_name,
        }
    }
}

const COLLECTION_SHARE_DETAILS_FIELDS: &[&str] = &["album_name"];
impl CollectionShareDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CollectionShareDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CollectionShareDetails>, V::Error> {
        let mut field_album_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "album_name" => {
                    if field_album_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("album_name"));
                    }
                    field_album_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CollectionShareDetails {
            album_name: field_album_name.ok_or_else(|| ::serde::de::Error::missing_field("album_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("album_name", &self.album_name)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CollectionShareDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CollectionShareDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CollectionShareDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CollectionShareDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CollectionShareDetails", COLLECTION_SHARE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CollectionShareDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CollectionShareDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CollectionShareType {
    pub description: String,
}

impl CollectionShareType {
    pub fn new(description: String) -> Self {
        CollectionShareType {
            description,
        }
    }
}

const COLLECTION_SHARE_TYPE_FIELDS: &[&str] = &["description"];
impl CollectionShareType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CollectionShareType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CollectionShareType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CollectionShareType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CollectionShareType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CollectionShareType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CollectionShareType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CollectionShareType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CollectionShareType", COLLECTION_SHARE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CollectionShareType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CollectionShareType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for controlling team access to computer backup feature
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ComputerBackupPolicy {
    Default,
    Disabled,
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ComputerBackupPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ComputerBackupPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ComputerBackupPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default" => ComputerBackupPolicy::Default,
                    "disabled" => ComputerBackupPolicy::Disabled,
                    "enabled" => ComputerBackupPolicy::Enabled,
                    _ => ComputerBackupPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default",
                                    "disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("ComputerBackupPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ComputerBackupPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ComputerBackupPolicy::Default => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicy", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            ComputerBackupPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ComputerBackupPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ComputerBackupPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed computer backup policy for team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ComputerBackupPolicyChangedDetails {
    /// New computer backup policy.
    pub new_value: ComputerBackupPolicy,
    /// Previous computer backup policy.
    pub previous_value: ComputerBackupPolicy,
}

impl ComputerBackupPolicyChangedDetails {
    pub fn new(new_value: ComputerBackupPolicy, previous_value: ComputerBackupPolicy) -> Self {
        ComputerBackupPolicyChangedDetails {
            new_value,
            previous_value,
        }
    }
}

const COMPUTER_BACKUP_POLICY_CHANGED_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                 "previous_value"];
impl ComputerBackupPolicyChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ComputerBackupPolicyChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ComputerBackupPolicyChangedDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ComputerBackupPolicyChangedDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ComputerBackupPolicyChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ComputerBackupPolicyChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ComputerBackupPolicyChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ComputerBackupPolicyChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ComputerBackupPolicyChangedDetails", COMPUTER_BACKUP_POLICY_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ComputerBackupPolicyChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ComputerBackupPolicyChangedDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ComputerBackupPolicyChangedType {
    pub description: String,
}

impl ComputerBackupPolicyChangedType {
    pub fn new(description: String) -> Self {
        ComputerBackupPolicyChangedType {
            description,
        }
    }
}

const COMPUTER_BACKUP_POLICY_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl ComputerBackupPolicyChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ComputerBackupPolicyChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ComputerBackupPolicyChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ComputerBackupPolicyChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ComputerBackupPolicyChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ComputerBackupPolicyChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ComputerBackupPolicyChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ComputerBackupPolicyChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ComputerBackupPolicyChangedType", COMPUTER_BACKUP_POLICY_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ComputerBackupPolicyChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ComputerBackupPolicyChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The name of the team
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ConnectedTeamName {
    /// The name of the team.
    pub team: String,
}

impl ConnectedTeamName {
    pub fn new(team: String) -> Self {
        ConnectedTeamName {
            team,
        }
    }
}

const CONNECTED_TEAM_NAME_FIELDS: &[&str] = &["team"];
impl ConnectedTeamName {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ConnectedTeamName, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ConnectedTeamName>, V::Error> {
        let mut field_team = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team" => {
                    if field_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team"));
                    }
                    field_team = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ConnectedTeamName {
            team: field_team.ok_or_else(|| ::serde::de::Error::missing_field("team"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team", &self.team)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ConnectedTeamName {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ConnectedTeamName;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ConnectedTeamName struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ConnectedTeamName::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ConnectedTeamName", CONNECTED_TEAM_NAME_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ConnectedTeamName {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ConnectedTeamName", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed content management setting.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ContentAdministrationPolicyChangedDetails {
    /// New content administration policy.
    pub new_value: String,
    /// Previous content administration policy.
    pub previous_value: String,
}

impl ContentAdministrationPolicyChangedDetails {
    pub fn new(new_value: String, previous_value: String) -> Self {
        ContentAdministrationPolicyChangedDetails {
            new_value,
            previous_value,
        }
    }
}

const CONTENT_ADMINISTRATION_POLICY_CHANGED_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                        "previous_value"];
impl ContentAdministrationPolicyChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ContentAdministrationPolicyChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ContentAdministrationPolicyChangedDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ContentAdministrationPolicyChangedDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ContentAdministrationPolicyChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ContentAdministrationPolicyChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContentAdministrationPolicyChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ContentAdministrationPolicyChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ContentAdministrationPolicyChangedDetails", CONTENT_ADMINISTRATION_POLICY_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ContentAdministrationPolicyChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ContentAdministrationPolicyChangedDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ContentAdministrationPolicyChangedType {
    pub description: String,
}

impl ContentAdministrationPolicyChangedType {
    pub fn new(description: String) -> Self {
        ContentAdministrationPolicyChangedType {
            description,
        }
    }
}

const CONTENT_ADMINISTRATION_POLICY_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl ContentAdministrationPolicyChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ContentAdministrationPolicyChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ContentAdministrationPolicyChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ContentAdministrationPolicyChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ContentAdministrationPolicyChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ContentAdministrationPolicyChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContentAdministrationPolicyChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ContentAdministrationPolicyChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ContentAdministrationPolicyChangedType", CONTENT_ADMINISTRATION_POLICY_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ContentAdministrationPolicyChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ContentAdministrationPolicyChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for pemanent content deletion
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ContentPermanentDeletePolicy {
    Disabled,
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ContentPermanentDeletePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ContentPermanentDeletePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContentPermanentDeletePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ContentPermanentDeletePolicy::Disabled,
                    "enabled" => ContentPermanentDeletePolicy::Enabled,
                    _ => ContentPermanentDeletePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("ContentPermanentDeletePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ContentPermanentDeletePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ContentPermanentDeletePolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ContentPermanentDeletePolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ContentPermanentDeletePolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ContentPermanentDeletePolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ContentPermanentDeletePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The primary entity on which the action was done.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ContextLogInfo {
    /// Anonymous context.
    Anonymous,
    /// Action was done on behalf of a non team member.
    NonTeamMember(NonTeamMemberLogInfo),
    /// Action was done on behalf of a team that's part of an organization.
    OrganizationTeam(TeamLogInfo),
    /// Action was done on behalf of the team.
    Team,
    /// Action was done on behalf of a team member.
    TeamMember(TeamMemberLogInfo),
    /// Action was done on behalf of a trusted non team member.
    TrustedNonTeamMember(TrustedNonTeamMemberLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ContextLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ContextLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ContextLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "anonymous" => ContextLogInfo::Anonymous,
                    "non_team_member" => ContextLogInfo::NonTeamMember(NonTeamMemberLogInfo::internal_deserialize(&mut map)?),
                    "organization_team" => ContextLogInfo::OrganizationTeam(TeamLogInfo::internal_deserialize(&mut map)?),
                    "team" => ContextLogInfo::Team,
                    "team_member" => ContextLogInfo::TeamMember(TeamMemberLogInfo::internal_deserialize(&mut map)?),
                    "trusted_non_team_member" => ContextLogInfo::TrustedNonTeamMember(TrustedNonTeamMemberLogInfo::internal_deserialize(&mut map)?),
                    _ => ContextLogInfo::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["anonymous",
                                    "non_team_member",
                                    "organization_team",
                                    "team",
                                    "team_member",
                                    "trusted_non_team_member",
                                    "other"];
        deserializer.deserialize_struct("ContextLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ContextLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ContextLogInfo::Anonymous => {
                // unit
                let mut s = serializer.serialize_struct("ContextLogInfo", 1)?;
                s.serialize_field(".tag", "anonymous")?;
                s.end()
            }
            ContextLogInfo::NonTeamMember(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ContextLogInfo", 4)?;
                s.serialize_field(".tag", "non_team_member")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ContextLogInfo::OrganizationTeam(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ContextLogInfo", 2)?;
                s.serialize_field(".tag", "organization_team")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ContextLogInfo::Team => {
                // unit
                let mut s = serializer.serialize_struct("ContextLogInfo", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            ContextLogInfo::TeamMember(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ContextLogInfo", 7)?;
                s.serialize_field(".tag", "team_member")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ContextLogInfo::TrustedNonTeamMember(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ContextLogInfo", 6)?;
                s.serialize_field(".tag", "trusted_non_team_member")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ContextLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Created folders.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderDetails {
}

impl Default for CreateFolderDetails {
    fn default() -> Self {
        CreateFolderDetails {
        }
    }
}

const CREATE_FOLDER_DETAILS_FIELDS: &[&str] = &[];
impl CreateFolderDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<CreateFolderDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(CreateFolderDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderDetails", CREATE_FOLDER_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("CreateFolderDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFolderType {
    pub description: String,
}

impl CreateFolderType {
    pub fn new(description: String) -> Self {
        CreateFolderType {
            description,
        }
    }
}

const CREATE_FOLDER_TYPE_FIELDS: &[&str] = &["description"];
impl CreateFolderType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFolderType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFolderType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFolderType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFolderType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFolderType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFolderType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFolderType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFolderType", CREATE_FOLDER_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFolderType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFolderType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Created team invite link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateTeamInviteLinkDetails {
    /// The invite link url that was created.
    pub link_url: String,
    /// The expiration date of the invite link.
    pub expiry_date: String,
}

impl CreateTeamInviteLinkDetails {
    pub fn new(link_url: String, expiry_date: String) -> Self {
        CreateTeamInviteLinkDetails {
            link_url,
            expiry_date,
        }
    }
}

const CREATE_TEAM_INVITE_LINK_DETAILS_FIELDS: &[&str] = &["link_url",
                                                          "expiry_date"];
impl CreateTeamInviteLinkDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateTeamInviteLinkDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateTeamInviteLinkDetails>, V::Error> {
        let mut field_link_url = None;
        let mut field_expiry_date = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "link_url" => {
                    if field_link_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_url"));
                    }
                    field_link_url = Some(map.next_value()?);
                }
                "expiry_date" => {
                    if field_expiry_date.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiry_date"));
                    }
                    field_expiry_date = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateTeamInviteLinkDetails {
            link_url: field_link_url.ok_or_else(|| ::serde::de::Error::missing_field("link_url"))?,
            expiry_date: field_expiry_date.ok_or_else(|| ::serde::de::Error::missing_field("expiry_date"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("link_url", &self.link_url)?;
        s.serialize_field("expiry_date", &self.expiry_date)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateTeamInviteLinkDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateTeamInviteLinkDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateTeamInviteLinkDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateTeamInviteLinkDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateTeamInviteLinkDetails", CREATE_TEAM_INVITE_LINK_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateTeamInviteLinkDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateTeamInviteLinkDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateTeamInviteLinkType {
    pub description: String,
}

impl CreateTeamInviteLinkType {
    pub fn new(description: String) -> Self {
        CreateTeamInviteLinkType {
            description,
        }
    }
}

const CREATE_TEAM_INVITE_LINK_TYPE_FIELDS: &[&str] = &["description"];
impl CreateTeamInviteLinkType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateTeamInviteLinkType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateTeamInviteLinkType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateTeamInviteLinkType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateTeamInviteLinkType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateTeamInviteLinkType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateTeamInviteLinkType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateTeamInviteLinkType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateTeamInviteLinkType", CREATE_TEAM_INVITE_LINK_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateTeamInviteLinkType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateTeamInviteLinkType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Set restrictions on data center locations where team data resides.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DataPlacementRestrictionChangePolicyDetails {
    /// Previous placement restriction.
    pub previous_value: PlacementRestriction,
    /// New placement restriction.
    pub new_value: PlacementRestriction,
}

impl DataPlacementRestrictionChangePolicyDetails {
    pub fn new(previous_value: PlacementRestriction, new_value: PlacementRestriction) -> Self {
        DataPlacementRestrictionChangePolicyDetails {
            previous_value,
            new_value,
        }
    }
}

const DATA_PLACEMENT_RESTRICTION_CHANGE_POLICY_DETAILS_FIELDS: &[&str] = &["previous_value",
                                                                           "new_value"];
impl DataPlacementRestrictionChangePolicyDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DataPlacementRestrictionChangePolicyDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DataPlacementRestrictionChangePolicyDetails>, V::Error> {
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DataPlacementRestrictionChangePolicyDetails {
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DataPlacementRestrictionChangePolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DataPlacementRestrictionChangePolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DataPlacementRestrictionChangePolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DataPlacementRestrictionChangePolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DataPlacementRestrictionChangePolicyDetails", DATA_PLACEMENT_RESTRICTION_CHANGE_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DataPlacementRestrictionChangePolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DataPlacementRestrictionChangePolicyDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DataPlacementRestrictionChangePolicyType {
    pub description: String,
}

impl DataPlacementRestrictionChangePolicyType {
    pub fn new(description: String) -> Self {
        DataPlacementRestrictionChangePolicyType {
            description,
        }
    }
}

const DATA_PLACEMENT_RESTRICTION_CHANGE_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl DataPlacementRestrictionChangePolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DataPlacementRestrictionChangePolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DataPlacementRestrictionChangePolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DataPlacementRestrictionChangePolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DataPlacementRestrictionChangePolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DataPlacementRestrictionChangePolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DataPlacementRestrictionChangePolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DataPlacementRestrictionChangePolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DataPlacementRestrictionChangePolicyType", DATA_PLACEMENT_RESTRICTION_CHANGE_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DataPlacementRestrictionChangePolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DataPlacementRestrictionChangePolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Completed restrictions on data center locations where team data resides.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DataPlacementRestrictionSatisfyPolicyDetails {
    /// Placement restriction.
    pub placement_restriction: PlacementRestriction,
}

impl DataPlacementRestrictionSatisfyPolicyDetails {
    pub fn new(placement_restriction: PlacementRestriction) -> Self {
        DataPlacementRestrictionSatisfyPolicyDetails {
            placement_restriction,
        }
    }
}

const DATA_PLACEMENT_RESTRICTION_SATISFY_POLICY_DETAILS_FIELDS: &[&str] = &["placement_restriction"];
impl DataPlacementRestrictionSatisfyPolicyDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DataPlacementRestrictionSatisfyPolicyDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DataPlacementRestrictionSatisfyPolicyDetails>, V::Error> {
        let mut field_placement_restriction = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "placement_restriction" => {
                    if field_placement_restriction.is_some() {
                        return Err(::serde::de::Error::duplicate_field("placement_restriction"));
                    }
                    field_placement_restriction = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DataPlacementRestrictionSatisfyPolicyDetails {
            placement_restriction: field_placement_restriction.ok_or_else(|| ::serde::de::Error::missing_field("placement_restriction"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("placement_restriction", &self.placement_restriction)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DataPlacementRestrictionSatisfyPolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DataPlacementRestrictionSatisfyPolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DataPlacementRestrictionSatisfyPolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DataPlacementRestrictionSatisfyPolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DataPlacementRestrictionSatisfyPolicyDetails", DATA_PLACEMENT_RESTRICTION_SATISFY_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DataPlacementRestrictionSatisfyPolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DataPlacementRestrictionSatisfyPolicyDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DataPlacementRestrictionSatisfyPolicyType {
    pub description: String,
}

impl DataPlacementRestrictionSatisfyPolicyType {
    pub fn new(description: String) -> Self {
        DataPlacementRestrictionSatisfyPolicyType {
            description,
        }
    }
}

const DATA_PLACEMENT_RESTRICTION_SATISFY_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl DataPlacementRestrictionSatisfyPolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DataPlacementRestrictionSatisfyPolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DataPlacementRestrictionSatisfyPolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DataPlacementRestrictionSatisfyPolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DataPlacementRestrictionSatisfyPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DataPlacementRestrictionSatisfyPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DataPlacementRestrictionSatisfyPolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DataPlacementRestrictionSatisfyPolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DataPlacementRestrictionSatisfyPolicyType", DATA_PLACEMENT_RESTRICTION_SATISFY_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DataPlacementRestrictionSatisfyPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DataPlacementRestrictionSatisfyPolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for the default number of days until an externally shared link expires
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DefaultLinkExpirationDaysPolicy {
    Day1,
    Day180,
    Day3,
    Day30,
    Day7,
    Day90,
    None,
    Year1,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DefaultLinkExpirationDaysPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DefaultLinkExpirationDaysPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DefaultLinkExpirationDaysPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "day_1" => DefaultLinkExpirationDaysPolicy::Day1,
                    "day_180" => DefaultLinkExpirationDaysPolicy::Day180,
                    "day_3" => DefaultLinkExpirationDaysPolicy::Day3,
                    "day_30" => DefaultLinkExpirationDaysPolicy::Day30,
                    "day_7" => DefaultLinkExpirationDaysPolicy::Day7,
                    "day_90" => DefaultLinkExpirationDaysPolicy::Day90,
                    "none" => DefaultLinkExpirationDaysPolicy::None,
                    "year_1" => DefaultLinkExpirationDaysPolicy::Year1,
                    _ => DefaultLinkExpirationDaysPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["day_1",
                                    "day_180",
                                    "day_3",
                                    "day_30",
                                    "day_7",
                                    "day_90",
                                    "none",
                                    "year_1",
                                    "other"];
        deserializer.deserialize_struct("DefaultLinkExpirationDaysPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DefaultLinkExpirationDaysPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DefaultLinkExpirationDaysPolicy::Day1 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_1")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Day180 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_180")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Day3 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_3")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Day30 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_30")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Day7 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_7")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Day90 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "day_90")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::None => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "none")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Year1 => {
                // unit
                let mut s = serializer.serialize_struct("DefaultLinkExpirationDaysPolicy", 1)?;
                s.serialize_field(".tag", "year_1")?;
                s.end()
            }
            DefaultLinkExpirationDaysPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Deleted team invite link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteTeamInviteLinkDetails {
    /// The invite link url that was deleted.
    pub link_url: String,
}

impl DeleteTeamInviteLinkDetails {
    pub fn new(link_url: String) -> Self {
        DeleteTeamInviteLinkDetails {
            link_url,
        }
    }
}

const DELETE_TEAM_INVITE_LINK_DETAILS_FIELDS: &[&str] = &["link_url"];
impl DeleteTeamInviteLinkDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteTeamInviteLinkDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteTeamInviteLinkDetails>, V::Error> {
        let mut field_link_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "link_url" => {
                    if field_link_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_url"));
                    }
                    field_link_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteTeamInviteLinkDetails {
            link_url: field_link_url.ok_or_else(|| ::serde::de::Error::missing_field("link_url"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("link_url", &self.link_url)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteTeamInviteLinkDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteTeamInviteLinkDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteTeamInviteLinkDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteTeamInviteLinkDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteTeamInviteLinkDetails", DELETE_TEAM_INVITE_LINK_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteTeamInviteLinkDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteTeamInviteLinkDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteTeamInviteLinkType {
    pub description: String,
}

impl DeleteTeamInviteLinkType {
    pub fn new(description: String) -> Self {
        DeleteTeamInviteLinkType {
            description,
        }
    }
}

const DELETE_TEAM_INVITE_LINK_TYPE_FIELDS: &[&str] = &["description"];
impl DeleteTeamInviteLinkType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteTeamInviteLinkType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteTeamInviteLinkType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteTeamInviteLinkType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteTeamInviteLinkType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteTeamInviteLinkType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteTeamInviteLinkType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteTeamInviteLinkType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteTeamInviteLinkType", DELETE_TEAM_INVITE_LINK_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteTeamInviteLinkType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteTeamInviteLinkType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information about linked Dropbox desktop client sessions
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DesktopDeviceSessionLogInfo {
    /// Name of the hosting desktop.
    pub host_name: String,
    /// The Dropbox desktop client type.
    pub client_type: super::team::DesktopPlatform,
    /// Information on the hosting platform.
    pub platform: String,
    /// Whether itu2019s possible to delete all of the account files upon unlinking.
    pub is_delete_on_unlink_supported: bool,
    /// The IP address of the last activity from this session.
    pub ip_address: Option<IpAddress>,
    /// The time this session was created.
    pub created: Option<super::common::DropboxTimestamp>,
    /// The time of the last activity from this session.
    pub updated: Option<super::common::DropboxTimestamp>,
    /// Desktop session unique id.
    pub session_info: Option<DesktopSessionLogInfo>,
    /// The Dropbox client version.
    pub client_version: Option<String>,
}

impl DesktopDeviceSessionLogInfo {
    pub fn new(
        host_name: String,
        client_type: super::team::DesktopPlatform,
        platform: String,
        is_delete_on_unlink_supported: bool,
    ) -> Self {
        DesktopDeviceSessionLogInfo {
            host_name,
            client_type,
            platform,
            is_delete_on_unlink_supported,
            ip_address: None,
            created: None,
            updated: None,
            session_info: None,
            client_version: None,
        }
    }

    pub fn with_ip_address(mut self, value: IpAddress) -> Self {
        self.ip_address = Some(value);
        self
    }

    pub fn with_created(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.created = Some(value);
        self
    }

    pub fn with_updated(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.updated = Some(value);
        self
    }

    pub fn with_session_info(mut self, value: DesktopSessionLogInfo) -> Self {
        self.session_info = Some(value);
        self
    }

    pub fn with_client_version(mut self, value: String) -> Self {
        self.client_version = Some(value);
        self
    }
}

const DESKTOP_DEVICE_SESSION_LOG_INFO_FIELDS: &[&str] = &["host_name",
                                                          "client_type",
                                                          "platform",
                                                          "is_delete_on_unlink_supported",
                                                          "ip_address",
                                                          "created",
                                                          "updated",
                                                          "session_info",
                                                          "client_version"];
impl DesktopDeviceSessionLogInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DesktopDeviceSessionLogInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DesktopDeviceSessionLogInfo>, V::Error> {
        let mut field_host_name = None;
        let mut field_client_type = None;
        let mut field_platform = None;
        let mut field_is_delete_on_unlink_supported = None;
        let mut field_ip_address = None;
        let mut field_created = None;
        let mut field_updated = None;
        let mut field_session_info = None;
        let mut field_client_version = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "host_name" => {
                    if field_host_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("host_name"));
                    }
                    field_host_name = Some(map.next_value()?);
                }
                "client_type" => {
                    if field_client_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_type"));
                    }
                    field_client_type = Some(map.next_value()?);
                }
                "platform" => {
                    if field_platform.is_some() {
                        return Err(::serde::de::Error::duplicate_field("platform"));
                    }
                    field_platform = Some(map.next_value()?);
                }
                "is_delete_on_unlink_supported" => {
                    if field_is_delete_on_unlink_supported.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_delete_on_unlink_supported"));
                    }
                    field_is_delete_on_unlink_supported = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "updated" => {
                    if field_updated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("updated"));
                    }
                    field_updated = Some(map.next_value()?);
                }
                "session_info" => {
                    if field_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_info"));
                    }
                    field_session_info = Some(map.next_value()?);
                }
                "client_version" => {
                    if field_client_version.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_version"));
                    }
                    field_client_version = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DesktopDeviceSessionLogInfo {
            host_name: field_host_name.ok_or_else(|| ::serde::de::Error::missing_field("host_name"))?,
            client_type: field_client_type.ok_or_else(|| ::serde::de::Error::missing_field("client_type"))?,
            platform: field_platform.ok_or_else(|| ::serde::de::Error::missing_field("platform"))?,
            is_delete_on_unlink_supported: field_is_delete_on_unlink_supported.ok_or_else(|| ::serde::de::Error::missing_field("is_delete_on_unlink_supported"))?,
            ip_address: field_ip_address,
            created: field_created,
            updated: field_updated,
            session_info: field_session_info,
            client_version: field_client_version,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("host_name", &self.host_name)?;
        s.serialize_field("client_type", &self.client_type)?;
        s.serialize_field("platform", &self.platform)?;
        s.serialize_field("is_delete_on_unlink_supported", &self.is_delete_on_unlink_supported)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        if let Some(val) = &self.created {
            s.serialize_field("created", val)?;
        }
        if let Some(val) = &self.updated {
            s.serialize_field("updated", val)?;
        }
        if let Some(val) = &self.session_info {
            s.serialize_field("session_info", val)?;
        }
        if let Some(val) = &self.client_version {
            s.serialize_field("client_version", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DesktopDeviceSessionLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DesktopDeviceSessionLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DesktopDeviceSessionLogInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DesktopDeviceSessionLogInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DesktopDeviceSessionLogInfo", DESKTOP_DEVICE_SESSION_LOG_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DesktopDeviceSessionLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DesktopDeviceSessionLogInfo", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Desktop session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DesktopSessionLogInfo {
    /// Session ID.
    pub session_id: Option<super::common::SessionId>,
}

impl Default for DesktopSessionLogInfo {
    fn default() -> Self {
        DesktopSessionLogInfo {
            session_id: None,
        }
    }
}

impl DesktopSessionLogInfo {
    pub fn with_session_id(mut self, value: super::common::SessionId) -> Self {
        self.session_id = Some(value);
        self
    }
}

const DESKTOP_SESSION_LOG_INFO_FIELDS: &[&str] = &["session_id"];
impl DesktopSessionLogInfo {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DesktopSessionLogInfo, V::Error> {
        let mut field_session_id = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "session_id" => {
                    if field_session_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_id"));
                    }
                    field_session_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DesktopSessionLogInfo {
            session_id: field_session_id,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.session_id {
            s.serialize_field("session_id", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DesktopSessionLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DesktopSessionLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DesktopSessionLogInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DesktopSessionLogInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DesktopSessionLogInfo", DESKTOP_SESSION_LOG_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DesktopSessionLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DesktopSessionLogInfo", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Added members to device approvals exception list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsAddExceptionDetails {
}

impl Default for DeviceApprovalsAddExceptionDetails {
    fn default() -> Self {
        DeviceApprovalsAddExceptionDetails {
        }
    }
}

const DEVICE_APPROVALS_ADD_EXCEPTION_DETAILS_FIELDS: &[&str] = &[];
impl DeviceApprovalsAddExceptionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsAddExceptionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DeviceApprovalsAddExceptionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsAddExceptionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsAddExceptionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsAddExceptionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsAddExceptionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsAddExceptionDetails", DEVICE_APPROVALS_ADD_EXCEPTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsAddExceptionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DeviceApprovalsAddExceptionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsAddExceptionType {
    pub description: String,
}

impl DeviceApprovalsAddExceptionType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsAddExceptionType {
            description,
        }
    }
}

const DEVICE_APPROVALS_ADD_EXCEPTION_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsAddExceptionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsAddExceptionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsAddExceptionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsAddExceptionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsAddExceptionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsAddExceptionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsAddExceptionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsAddExceptionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsAddExceptionType", DEVICE_APPROVALS_ADD_EXCEPTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsAddExceptionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsAddExceptionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Set/removed limit on number of computers member can link to team Dropbox account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeDesktopPolicyDetails {
    /// New desktop device approvals policy. Might be missing due to historical data gap.
    pub new_value: Option<DeviceApprovalsPolicy>,
    /// Previous desktop device approvals policy. Might be missing due to historical data gap.
    pub previous_value: Option<DeviceApprovalsPolicy>,
}

impl Default for DeviceApprovalsChangeDesktopPolicyDetails {
    fn default() -> Self {
        DeviceApprovalsChangeDesktopPolicyDetails {
            new_value: None,
            previous_value: None,
        }
    }
}

impl DeviceApprovalsChangeDesktopPolicyDetails {
    pub fn with_new_value(mut self, value: DeviceApprovalsPolicy) -> Self {
        self.new_value = Some(value);
        self
    }

    pub fn with_previous_value(mut self, value: DeviceApprovalsPolicy) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const DEVICE_APPROVALS_CHANGE_DESKTOP_POLICY_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                         "previous_value"];
impl DeviceApprovalsChangeDesktopPolicyDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsChangeDesktopPolicyDetails, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceApprovalsChangeDesktopPolicyDetails {
            new_value: field_new_value,
            previous_value: field_previous_value,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.new_value {
            s.serialize_field("new_value", val)?;
        }
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeDesktopPolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeDesktopPolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeDesktopPolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeDesktopPolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeDesktopPolicyDetails", DEVICE_APPROVALS_CHANGE_DESKTOP_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeDesktopPolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeDesktopPolicyDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeDesktopPolicyType {
    pub description: String,
}

impl DeviceApprovalsChangeDesktopPolicyType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsChangeDesktopPolicyType {
            description,
        }
    }
}

const DEVICE_APPROVALS_CHANGE_DESKTOP_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsChangeDesktopPolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsChangeDesktopPolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsChangeDesktopPolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsChangeDesktopPolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeDesktopPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeDesktopPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeDesktopPolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeDesktopPolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeDesktopPolicyType", DEVICE_APPROVALS_CHANGE_DESKTOP_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeDesktopPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeDesktopPolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Set/removed limit on number of mobile devices member can link to team Dropbox account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeMobilePolicyDetails {
    /// New mobile device approvals policy. Might be missing due to historical data gap.
    pub new_value: Option<DeviceApprovalsPolicy>,
    /// Previous mobile device approvals policy. Might be missing due to historical data gap.
    pub previous_value: Option<DeviceApprovalsPolicy>,
}

impl Default for DeviceApprovalsChangeMobilePolicyDetails {
    fn default() -> Self {
        DeviceApprovalsChangeMobilePolicyDetails {
            new_value: None,
            previous_value: None,
        }
    }
}

impl DeviceApprovalsChangeMobilePolicyDetails {
    pub fn with_new_value(mut self, value: DeviceApprovalsPolicy) -> Self {
        self.new_value = Some(value);
        self
    }

    pub fn with_previous_value(mut self, value: DeviceApprovalsPolicy) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const DEVICE_APPROVALS_CHANGE_MOBILE_POLICY_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                        "previous_value"];
impl DeviceApprovalsChangeMobilePolicyDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsChangeMobilePolicyDetails, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceApprovalsChangeMobilePolicyDetails {
            new_value: field_new_value,
            previous_value: field_previous_value,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.new_value {
            s.serialize_field("new_value", val)?;
        }
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeMobilePolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeMobilePolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeMobilePolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeMobilePolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeMobilePolicyDetails", DEVICE_APPROVALS_CHANGE_MOBILE_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeMobilePolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeMobilePolicyDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeMobilePolicyType {
    pub description: String,
}

impl DeviceApprovalsChangeMobilePolicyType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsChangeMobilePolicyType {
            description,
        }
    }
}

const DEVICE_APPROVALS_CHANGE_MOBILE_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsChangeMobilePolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsChangeMobilePolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsChangeMobilePolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsChangeMobilePolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeMobilePolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeMobilePolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeMobilePolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeMobilePolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeMobilePolicyType", DEVICE_APPROVALS_CHANGE_MOBILE_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeMobilePolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeMobilePolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed device approvals setting when member is over limit.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeOverageActionDetails {
    /// New over the limits policy. Might be missing due to historical data gap.
    pub new_value: Option<super::team_policies::RolloutMethod>,
    /// Previous over the limit policy. Might be missing due to historical data gap.
    pub previous_value: Option<super::team_policies::RolloutMethod>,
}

impl Default for DeviceApprovalsChangeOverageActionDetails {
    fn default() -> Self {
        DeviceApprovalsChangeOverageActionDetails {
            new_value: None,
            previous_value: None,
        }
    }
}

impl DeviceApprovalsChangeOverageActionDetails {
    pub fn with_new_value(mut self, value: super::team_policies::RolloutMethod) -> Self {
        self.new_value = Some(value);
        self
    }

    pub fn with_previous_value(mut self, value: super::team_policies::RolloutMethod) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const DEVICE_APPROVALS_CHANGE_OVERAGE_ACTION_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                         "previous_value"];
impl DeviceApprovalsChangeOverageActionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsChangeOverageActionDetails, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceApprovalsChangeOverageActionDetails {
            new_value: field_new_value,
            previous_value: field_previous_value,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.new_value {
            s.serialize_field("new_value", val)?;
        }
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeOverageActionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeOverageActionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeOverageActionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeOverageActionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeOverageActionDetails", DEVICE_APPROVALS_CHANGE_OVERAGE_ACTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeOverageActionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeOverageActionDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeOverageActionType {
    pub description: String,
}

impl DeviceApprovalsChangeOverageActionType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsChangeOverageActionType {
            description,
        }
    }
}

const DEVICE_APPROVALS_CHANGE_OVERAGE_ACTION_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsChangeOverageActionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsChangeOverageActionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsChangeOverageActionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsChangeOverageActionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeOverageActionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeOverageActionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeOverageActionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeOverageActionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeOverageActionType", DEVICE_APPROVALS_CHANGE_OVERAGE_ACTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeOverageActionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeOverageActionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed device approvals setting when member unlinks approved device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeUnlinkActionDetails {
    /// New device unlink policy. Might be missing due to historical data gap.
    pub new_value: Option<DeviceUnlinkPolicy>,
    /// Previous device unlink policy. Might be missing due to historical data gap.
    pub previous_value: Option<DeviceUnlinkPolicy>,
}

impl Default for DeviceApprovalsChangeUnlinkActionDetails {
    fn default() -> Self {
        DeviceApprovalsChangeUnlinkActionDetails {
            new_value: None,
            previous_value: None,
        }
    }
}

impl DeviceApprovalsChangeUnlinkActionDetails {
    pub fn with_new_value(mut self, value: DeviceUnlinkPolicy) -> Self {
        self.new_value = Some(value);
        self
    }

    pub fn with_previous_value(mut self, value: DeviceUnlinkPolicy) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const DEVICE_APPROVALS_CHANGE_UNLINK_ACTION_DETAILS_FIELDS: &[&str] = &["new_value",
                                                                        "previous_value"];
impl DeviceApprovalsChangeUnlinkActionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsChangeUnlinkActionDetails, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceApprovalsChangeUnlinkActionDetails {
            new_value: field_new_value,
            previous_value: field_previous_value,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.new_value {
            s.serialize_field("new_value", val)?;
        }
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeUnlinkActionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeUnlinkActionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeUnlinkActionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeUnlinkActionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeUnlinkActionDetails", DEVICE_APPROVALS_CHANGE_UNLINK_ACTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeUnlinkActionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeUnlinkActionDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsChangeUnlinkActionType {
    pub description: String,
}

impl DeviceApprovalsChangeUnlinkActionType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsChangeUnlinkActionType {
            description,
        }
    }
}

const DEVICE_APPROVALS_CHANGE_UNLINK_ACTION_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsChangeUnlinkActionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsChangeUnlinkActionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsChangeUnlinkActionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsChangeUnlinkActionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsChangeUnlinkActionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsChangeUnlinkActionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsChangeUnlinkActionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsChangeUnlinkActionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsChangeUnlinkActionType", DEVICE_APPROVALS_CHANGE_UNLINK_ACTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsChangeUnlinkActionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsChangeUnlinkActionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeviceApprovalsPolicy {
    Limited,
    Unlimited,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeviceApprovalsPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "limited" => DeviceApprovalsPolicy::Limited,
                    "unlimited" => DeviceApprovalsPolicy::Unlimited,
                    _ => DeviceApprovalsPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["limited",
                                    "unlimited",
                                    "other"];
        deserializer.deserialize_struct("DeviceApprovalsPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeviceApprovalsPolicy::Limited => {
                // unit
                let mut s = serializer.serialize_struct("DeviceApprovalsPolicy", 1)?;
                s.serialize_field(".tag", "limited")?;
                s.end()
            }
            DeviceApprovalsPolicy::Unlimited => {
                // unit
                let mut s = serializer.serialize_struct("DeviceApprovalsPolicy", 1)?;
                s.serialize_field(".tag", "unlimited")?;
                s.end()
            }
            DeviceApprovalsPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Removed members from device approvals exception list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsRemoveExceptionDetails {
}

impl Default for DeviceApprovalsRemoveExceptionDetails {
    fn default() -> Self {
        DeviceApprovalsRemoveExceptionDetails {
        }
    }
}

const DEVICE_APPROVALS_REMOVE_EXCEPTION_DETAILS_FIELDS: &[&str] = &[];
impl DeviceApprovalsRemoveExceptionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceApprovalsRemoveExceptionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DeviceApprovalsRemoveExceptionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsRemoveExceptionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsRemoveExceptionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsRemoveExceptionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsRemoveExceptionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsRemoveExceptionDetails", DEVICE_APPROVALS_REMOVE_EXCEPTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsRemoveExceptionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DeviceApprovalsRemoveExceptionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceApprovalsRemoveExceptionType {
    pub description: String,
}

impl DeviceApprovalsRemoveExceptionType {
    pub fn new(description: String) -> Self {
        DeviceApprovalsRemoveExceptionType {
            description,
        }
    }
}

const DEVICE_APPROVALS_REMOVE_EXCEPTION_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceApprovalsRemoveExceptionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceApprovalsRemoveExceptionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceApprovalsRemoveExceptionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceApprovalsRemoveExceptionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceApprovalsRemoveExceptionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceApprovalsRemoveExceptionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceApprovalsRemoveExceptionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceApprovalsRemoveExceptionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceApprovalsRemoveExceptionType", DEVICE_APPROVALS_REMOVE_EXCEPTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceApprovalsRemoveExceptionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceApprovalsRemoveExceptionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed IP address associated with active desktop session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpDesktopDetails {
    /// Device's session logged information.
    pub device_session_info: DeviceSessionLogInfo,
}

impl DeviceChangeIpDesktopDetails {
    pub fn new(device_session_info: DeviceSessionLogInfo) -> Self {
        DeviceChangeIpDesktopDetails {
            device_session_info,
        }
    }
}

const DEVICE_CHANGE_IP_DESKTOP_DETAILS_FIELDS: &[&str] = &["device_session_info"];
impl DeviceChangeIpDesktopDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceChangeIpDesktopDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceChangeIpDesktopDetails>, V::Error> {
        let mut field_device_session_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "device_session_info" => {
                    if field_device_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("device_session_info"));
                    }
                    field_device_session_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceChangeIpDesktopDetails {
            device_session_info: field_device_session_info.ok_or_else(|| ::serde::de::Error::missing_field("device_session_info"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("device_session_info", &self.device_session_info)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpDesktopDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpDesktopDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpDesktopDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpDesktopDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpDesktopDetails", DEVICE_CHANGE_IP_DESKTOP_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpDesktopDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpDesktopDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpDesktopType {
    pub description: String,
}

impl DeviceChangeIpDesktopType {
    pub fn new(description: String) -> Self {
        DeviceChangeIpDesktopType {
            description,
        }
    }
}

const DEVICE_CHANGE_IP_DESKTOP_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceChangeIpDesktopType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceChangeIpDesktopType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceChangeIpDesktopType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceChangeIpDesktopType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpDesktopType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpDesktopType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpDesktopType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpDesktopType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpDesktopType", DEVICE_CHANGE_IP_DESKTOP_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpDesktopType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpDesktopType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed IP address associated with active mobile session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpMobileDetails {
    /// Device's session logged information.
    pub device_session_info: Option<DeviceSessionLogInfo>,
}

impl Default for DeviceChangeIpMobileDetails {
    fn default() -> Self {
        DeviceChangeIpMobileDetails {
            device_session_info: None,
        }
    }
}

impl DeviceChangeIpMobileDetails {
    pub fn with_device_session_info(mut self, value: DeviceSessionLogInfo) -> Self {
        self.device_session_info = Some(value);
        self
    }
}

const DEVICE_CHANGE_IP_MOBILE_DETAILS_FIELDS: &[&str] = &["device_session_info"];
impl DeviceChangeIpMobileDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceChangeIpMobileDetails, V::Error> {
        let mut field_device_session_info = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "device_session_info" => {
                    if field_device_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("device_session_info"));
                    }
                    field_device_session_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceChangeIpMobileDetails {
            device_session_info: field_device_session_info,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.device_session_info {
            s.serialize_field("device_session_info", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpMobileDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpMobileDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpMobileDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpMobileDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpMobileDetails", DEVICE_CHANGE_IP_MOBILE_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpMobileDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpMobileDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpMobileType {
    pub description: String,
}

impl DeviceChangeIpMobileType {
    pub fn new(description: String) -> Self {
        DeviceChangeIpMobileType {
            description,
        }
    }
}

const DEVICE_CHANGE_IP_MOBILE_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceChangeIpMobileType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceChangeIpMobileType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceChangeIpMobileType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceChangeIpMobileType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpMobileType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpMobileType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpMobileType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpMobileType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpMobileType", DEVICE_CHANGE_IP_MOBILE_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpMobileType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpMobileType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Changed IP address associated with active web session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpWebDetails {
    /// Web browser name.
    pub user_agent: String,
}

impl DeviceChangeIpWebDetails {
    pub fn new(user_agent: String) -> Self {
        DeviceChangeIpWebDetails {
            user_agent,
        }
    }
}

const DEVICE_CHANGE_IP_WEB_DETAILS_FIELDS: &[&str] = &["user_agent"];
impl DeviceChangeIpWebDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceChangeIpWebDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceChangeIpWebDetails>, V::Error> {
        let mut field_user_agent = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "user_agent" => {
                    if field_user_agent.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user_agent"));
                    }
                    field_user_agent = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceChangeIpWebDetails {
            user_agent: field_user_agent.ok_or_else(|| ::serde::de::Error::missing_field("user_agent"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("user_agent", &self.user_agent)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpWebDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpWebDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpWebDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpWebDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpWebDetails", DEVICE_CHANGE_IP_WEB_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpWebDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpWebDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceChangeIpWebType {
    pub description: String,
}

impl DeviceChangeIpWebType {
    pub fn new(description: String) -> Self {
        DeviceChangeIpWebType {
            description,
        }
    }
}

const DEVICE_CHANGE_IP_WEB_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceChangeIpWebType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceChangeIpWebType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceChangeIpWebType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceChangeIpWebType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceChangeIpWebType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceChangeIpWebType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceChangeIpWebType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceChangeIpWebType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceChangeIpWebType", DEVICE_CHANGE_IP_WEB_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceChangeIpWebType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceChangeIpWebType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Failed to delete all files from unlinked device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceDeleteOnUnlinkFailDetails {
    /// The number of times that remote file deletion failed.
    pub num_failures: i64,
    /// Session unique id.
    pub session_info: Option<SessionLogInfo>,
    /// The device name. Might be missing due to historical data gap.
    pub display_name: Option<String>,
}

impl DeviceDeleteOnUnlinkFailDetails {
    pub fn new(num_failures: i64) -> Self {
        DeviceDeleteOnUnlinkFailDetails {
            num_failures,
            session_info: None,
            display_name: None,
        }
    }

    pub fn with_session_info(mut self, value: SessionLogInfo) -> Self {
        self.session_info = Some(value);
        self
    }

    pub fn with_display_name(mut self, value: String) -> Self {
        self.display_name = Some(value);
        self
    }
}

const DEVICE_DELETE_ON_UNLINK_FAIL_DETAILS_FIELDS: &[&str] = &["num_failures",
                                                               "session_info",
                                                               "display_name"];
impl DeviceDeleteOnUnlinkFailDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceDeleteOnUnlinkFailDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceDeleteOnUnlinkFailDetails>, V::Error> {
        let mut field_num_failures = None;
        let mut field_session_info = None;
        let mut field_display_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "num_failures" => {
                    if field_num_failures.is_some() {
                        return Err(::serde::de::Error::duplicate_field("num_failures"));
                    }
                    field_num_failures = Some(map.next_value()?);
                }
                "session_info" => {
                    if field_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_info"));
                    }
                    field_session_info = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceDeleteOnUnlinkFailDetails {
            num_failures: field_num_failures.ok_or_else(|| ::serde::de::Error::missing_field("num_failures"))?,
            session_info: field_session_info,
            display_name: field_display_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("num_failures", &self.num_failures)?;
        if let Some(val) = &self.session_info {
            s.serialize_field("session_info", val)?;
        }
        if let Some(val) = &self.display_name {
            s.serialize_field("display_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceDeleteOnUnlinkFailDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceDeleteOnUnlinkFailDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceDeleteOnUnlinkFailDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceDeleteOnUnlinkFailDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceDeleteOnUnlinkFailDetails", DEVICE_DELETE_ON_UNLINK_FAIL_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceDeleteOnUnlinkFailDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceDeleteOnUnlinkFailDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceDeleteOnUnlinkFailType {
    pub description: String,
}

impl DeviceDeleteOnUnlinkFailType {
    pub fn new(description: String) -> Self {
        DeviceDeleteOnUnlinkFailType {
            description,
        }
    }
}

const DEVICE_DELETE_ON_UNLINK_FAIL_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceDeleteOnUnlinkFailType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceDeleteOnUnlinkFailType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceDeleteOnUnlinkFailType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceDeleteOnUnlinkFailType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceDeleteOnUnlinkFailType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceDeleteOnUnlinkFailType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceDeleteOnUnlinkFailType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceDeleteOnUnlinkFailType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceDeleteOnUnlinkFailType", DEVICE_DELETE_ON_UNLINK_FAIL_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceDeleteOnUnlinkFailType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceDeleteOnUnlinkFailType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Deleted all files from unlinked device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceDeleteOnUnlinkSuccessDetails {
    /// Session unique id.
    pub session_info: Option<SessionLogInfo>,
    /// The device name. Might be missing due to historical data gap.
    pub display_name: Option<String>,
}

impl Default for DeviceDeleteOnUnlinkSuccessDetails {
    fn default() -> Self {
        DeviceDeleteOnUnlinkSuccessDetails {
            session_info: None,
            display_name: None,
        }
    }
}

impl DeviceDeleteOnUnlinkSuccessDetails {
    pub fn with_session_info(mut self, value: SessionLogInfo) -> Self {
        self.session_info = Some(value);
        self
    }

    pub fn with_display_name(mut self, value: String) -> Self {
        self.display_name = Some(value);
        self
    }
}

const DEVICE_DELETE_ON_UNLINK_SUCCESS_DETAILS_FIELDS: &[&str] = &["session_info",
                                                                  "display_name"];
impl DeviceDeleteOnUnlinkSuccessDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceDeleteOnUnlinkSuccessDetails, V::Error> {
        let mut field_session_info = None;
        let mut field_display_name = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "session_info" => {
                    if field_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_info"));
                    }
                    field_session_info = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceDeleteOnUnlinkSuccessDetails {
            session_info: field_session_info,
            display_name: field_display_name,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.session_info {
            s.serialize_field("session_info", val)?;
        }
        if let Some(val) = &self.display_name {
            s.serialize_field("display_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceDeleteOnUnlinkSuccessDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceDeleteOnUnlinkSuccessDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceDeleteOnUnlinkSuccessDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceDeleteOnUnlinkSuccessDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceDeleteOnUnlinkSuccessDetails", DEVICE_DELETE_ON_UNLINK_SUCCESS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceDeleteOnUnlinkSuccessDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceDeleteOnUnlinkSuccessDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceDeleteOnUnlinkSuccessType {
    pub description: String,
}

impl DeviceDeleteOnUnlinkSuccessType {
    pub fn new(description: String) -> Self {
        DeviceDeleteOnUnlinkSuccessType {
            description,
        }
    }
}

const DEVICE_DELETE_ON_UNLINK_SUCCESS_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceDeleteOnUnlinkSuccessType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceDeleteOnUnlinkSuccessType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceDeleteOnUnlinkSuccessType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceDeleteOnUnlinkSuccessType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceDeleteOnUnlinkSuccessType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceDeleteOnUnlinkSuccessType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceDeleteOnUnlinkSuccessType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceDeleteOnUnlinkSuccessType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceDeleteOnUnlinkSuccessType", DEVICE_DELETE_ON_UNLINK_SUCCESS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceDeleteOnUnlinkSuccessType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceDeleteOnUnlinkSuccessType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Failed to link device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceLinkFailDetails {
    /// A description of the device used while user approval blocked.
    pub device_type: DeviceType,
    /// IP address. Might be missing due to historical data gap.
    pub ip_address: Option<IpAddress>,
}

impl DeviceLinkFailDetails {
    pub fn new(device_type: DeviceType) -> Self {
        DeviceLinkFailDetails {
            device_type,
            ip_address: None,
        }
    }

    pub fn with_ip_address(mut self, value: IpAddress) -> Self {
        self.ip_address = Some(value);
        self
    }
}

const DEVICE_LINK_FAIL_DETAILS_FIELDS: &[&str] = &["device_type",
                                                   "ip_address"];
impl DeviceLinkFailDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceLinkFailDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceLinkFailDetails>, V::Error> {
        let mut field_device_type = None;
        let mut field_ip_address = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "device_type" => {
                    if field_device_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("device_type"));
                    }
                    field_device_type = Some(map.next_value()?);
                }
                "ip_address" => {
                    if field_ip_address.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ip_address"));
                    }
                    field_ip_address = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceLinkFailDetails {
            device_type: field_device_type.ok_or_else(|| ::serde::de::Error::missing_field("device_type"))?,
            ip_address: field_ip_address,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("device_type", &self.device_type)?;
        if let Some(val) = &self.ip_address {
            s.serialize_field("ip_address", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceLinkFailDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceLinkFailDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceLinkFailDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceLinkFailDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceLinkFailDetails", DEVICE_LINK_FAIL_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceLinkFailDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceLinkFailDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceLinkFailType {
    pub description: String,
}

impl DeviceLinkFailType {
    pub fn new(description: String) -> Self {
        DeviceLinkFailType {
            description,
        }
    }
}

const DEVICE_LINK_FAIL_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceLinkFailType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceLinkFailType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceLinkFailType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceLinkFailType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceLinkFailType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceLinkFailType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceLinkFailType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceLinkFailType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceLinkFailType", DEVICE_LINK_FAIL_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceLinkFailType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceLinkFailType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Linked device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceLinkSuccessDetails {
    /// Device's session logged information.
    pub device_session_info: Option<DeviceSessionLogInfo>,
}

impl Default for DeviceLinkSuccessDetails {
    fn default() -> Self {
        DeviceLinkSuccessDetails {
            device_session_info: None,
        }
    }
}

impl DeviceLinkSuccessDetails {
    pub fn with_device_session_info(mut self, value: DeviceSessionLogInfo) -> Self {
        self.device_session_info = Some(value);
        self
    }
}

const DEVICE_LINK_SUCCESS_DETAILS_FIELDS: &[&str] = &["device_session_info"];
impl DeviceLinkSuccessDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceLinkSuccessDetails, V::Error> {
        let mut field_device_session_info = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "device_session_info" => {
                    if field_device_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("device_session_info"));
                    }
                    field_device_session_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = DeviceLinkSuccessDetails {
            device_session_info: field_device_session_info,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        if let Some(val) = &self.device_session_info {
            s.serialize_field("device_session_info", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceLinkSuccessDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceLinkSuccessDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceLinkSuccessDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceLinkSuccessDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceLinkSuccessDetails", DEVICE_LINK_SUCCESS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceLinkSuccessDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceLinkSuccessDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceLinkSuccessType {
    pub description: String,
}

impl DeviceLinkSuccessType {
    pub fn new(description: String) -> Self {
        DeviceLinkSuccessType {
            description,
        }
    }
}

const DEVICE_LINK_SUCCESS_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceLinkSuccessType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceLinkSuccessType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceLinkSuccessType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceLinkSuccessType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceLinkSuccessType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceLinkSuccessType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceLinkSuccessType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceLinkSuccessType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceLinkSuccessType", DEVICE_LINK_SUCCESS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceLinkSuccessType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceLinkSuccessType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Disabled device management.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceManagementDisabledDetails {
}

impl Default for DeviceManagementDisabledDetails {
    fn default() -> Self {
        DeviceManagementDisabledDetails {
        }
    }
}

const DEVICE_MANAGEMENT_DISABLED_DETAILS_FIELDS: &[&str] = &[];
impl DeviceManagementDisabledDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceManagementDisabledDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DeviceManagementDisabledDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceManagementDisabledDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceManagementDisabledDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceManagementDisabledDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceManagementDisabledDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceManagementDisabledDetails", DEVICE_MANAGEMENT_DISABLED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceManagementDisabledDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DeviceManagementDisabledDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceManagementDisabledType {
    pub description: String,
}

impl DeviceManagementDisabledType {
    pub fn new(description: String) -> Self {
        DeviceManagementDisabledType {
            description,
        }
    }
}

const DEVICE_MANAGEMENT_DISABLED_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceManagementDisabledType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceManagementDisabledType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceManagementDisabledType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceManagementDisabledType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceManagementDisabledType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceManagementDisabledType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceManagementDisabledType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceManagementDisabledType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceManagementDisabledType", DEVICE_MANAGEMENT_DISABLED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceManagementDisabledType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceManagementDisabledType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enabled device management.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceManagementEnabledDetails {
}

impl Default for DeviceManagementEnabledDetails {
    fn default() -> Self {
        DeviceManagementEnabledDetails {
        }
    }
}

const DEVICE_MANAGEMENT_ENABLED_DETAILS_FIELDS: &[&str] = &[];
impl DeviceManagementEnabledDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DeviceManagementEnabledDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DeviceManagementEnabledDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceManagementEnabledDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceManagementEnabledDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceManagementEnabledDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceManagementEnabledDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceManagementEnabledDetails", DEVICE_MANAGEMENT_ENABLED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceManagementEnabledDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DeviceManagementEnabledDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceManagementEnabledType {
    pub description: String,
}

impl DeviceManagementEnabledType {
    pub fn new(description: String) -> Self {
        DeviceManagementEnabledType {
            description,
        }
    }
}

const DEVICE_MANAGEMENT_ENABLED_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceManagementEnabledType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceManagementEnabledType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceManagementEnabledType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceManagementEnabledType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceManagementEnabledType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceManagementEnabledType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceManagementEnabledType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceManagementEnabledType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceManagementEnabledType", DEVICE_MANAGEMENT_ENABLED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceManagementEnabledType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceManagementEnabledType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Device's session logged information.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeviceSessionLogInfo {
    DesktopDeviceSession(DesktopDeviceSessionLogInfo),
    MobileDeviceSession(MobileDeviceSessionLogInfo),
    WebDeviceSession(WebDeviceSessionLogInfo),
    LegacyDeviceSession(LegacyDeviceSessionLogInfo),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceSessionLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeviceSessionLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceSessionLogInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "desktop_device_session" => Ok(DeviceSessionLogInfo::DesktopDeviceSession(DesktopDeviceSessionLogInfo::internal_deserialize(map)?)),
                    "mobile_device_session" => Ok(DeviceSessionLogInfo::MobileDeviceSession(MobileDeviceSessionLogInfo::internal_deserialize(map)?)),
                    "web_device_session" => Ok(DeviceSessionLogInfo::WebDeviceSession(WebDeviceSessionLogInfo::internal_deserialize(map)?)),
                    "legacy_device_session" => Ok(DeviceSessionLogInfo::LegacyDeviceSession(LegacyDeviceSessionLogInfo::internal_deserialize(map)?)),
                    _ => {
                        crate::eat_json_fields(&mut map)?;
                        Ok(DeviceSessionLogInfo::Other)
                    }
                }
            }
        }
        const VARIANTS: &[&str] = &["desktop_device_session",
                                    "mobile_device_session",
                                    "web_device_session",
                                    "legacy_device_session"];
        deserializer.deserialize_struct("DeviceSessionLogInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceSessionLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeviceSessionLogInfo::DesktopDeviceSession(ref x) => {
                let mut s = serializer.serialize_struct("DeviceSessionLogInfo", 10)?;
                s.serialize_field(".tag", "desktop_device_session")?;
                s.serialize_field("host_name", &x.host_name)?;
                s.serialize_field("client_type", &x.client_type)?;
                s.serialize_field("platform", &x.platform)?;
                s.serialize_field("is_delete_on_unlink_supported", &x.is_delete_on_unlink_supported)?;
                s.serialize_field("ip_address", &x.ip_address)?;
                s.serialize_field("created", &x.created)?;
                s.serialize_field("updated", &x.updated)?;
                s.serialize_field("session_info", &x.session_info)?;
                s.serialize_field("client_version", &x.client_version)?;
                s.end()
            }
            DeviceSessionLogInfo::MobileDeviceSession(ref x) => {
                let mut s = serializer.serialize_struct("DeviceSessionLogInfo", 10)?;
                s.serialize_field(".tag", "mobile_device_session")?;
                s.serialize_field("device_name", &x.device_name)?;
                s.serialize_field("client_type", &x.client_type)?;
                s.serialize_field("ip_address", &x.ip_address)?;
                s.serialize_field("created", &x.created)?;
                s.serialize_field("updated", &x.updated)?;
                s.serialize_field("session_info", &x.session_info)?;
                s.serialize_field("client_version", &x.client_version)?;
                s.serialize_field("os_version", &x.os_version)?;
                s.serialize_field("last_carrier", &x.last_carrier)?;
                s.end()
            }
            DeviceSessionLogInfo::WebDeviceSession(ref x) => {
                let mut s = serializer.serialize_struct("DeviceSessionLogInfo", 8)?;
                s.serialize_field(".tag", "web_device_session")?;
                s.serialize_field("user_agent", &x.user_agent)?;
                s.serialize_field("os", &x.os)?;
                s.serialize_field("browser", &x.browser)?;
                s.serialize_field("ip_address", &x.ip_address)?;
                s.serialize_field("created", &x.created)?;
                s.serialize_field("updated", &x.updated)?;
                s.serialize_field("session_info", &x.session_info)?;
                s.end()
            }
            DeviceSessionLogInfo::LegacyDeviceSession(ref x) => {
                let mut s = serializer.serialize_struct("DeviceSessionLogInfo", 13)?;
                s.serialize_field(".tag", "legacy_device_session")?;
                s.serialize_field("ip_address", &x.ip_address)?;
                s.serialize_field("created", &x.created)?;
                s.serialize_field("updated", &x.updated)?;
                s.serialize_field("session_info", &x.session_info)?;
                s.serialize_field("display_name", &x.display_name)?;
                s.serialize_field("is_emm_managed", &x.is_emm_managed)?;
                s.serialize_field("platform", &x.platform)?;
                s.serialize_field("mac_address", &x.mac_address)?;
                s.serialize_field("os_version", &x.os_version)?;
                s.serialize_field("device_type", &x.device_type)?;
                s.serialize_field("client_version", &x.client_version)?;
                s.serialize_field("legacy_uniq_id", &x.legacy_uniq_id)?;
                s.end()
            }
            DeviceSessionLogInfo::Other => Err(::serde::ser::Error::custom("cannot serialize unknown variant"))
        }
    }
}

/// Enabled/disabled backup for computer.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceSyncBackupStatusChangedDetails {
    /// Device's session logged information.
    pub desktop_device_session_info: DesktopDeviceSessionLogInfo,
    /// Previous status of computer backup on the device.
    pub previous_value: BackupStatus,
    /// Next status of computer backup on the device.
    pub new_value: BackupStatus,
}

impl DeviceSyncBackupStatusChangedDetails {
    pub fn new(
        desktop_device_session_info: DesktopDeviceSessionLogInfo,
        previous_value: BackupStatus,
        new_value: BackupStatus,
    ) -> Self {
        DeviceSyncBackupStatusChangedDetails {
            desktop_device_session_info,
            previous_value,
            new_value,
        }
    }
}

const DEVICE_SYNC_BACKUP_STATUS_CHANGED_DETAILS_FIELDS: &[&str] = &["desktop_device_session_info",
                                                                    "previous_value",
                                                                    "new_value"];
impl DeviceSyncBackupStatusChangedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceSyncBackupStatusChangedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceSyncBackupStatusChangedDetails>, V::Error> {
        let mut field_desktop_device_session_info = None;
        let mut field_previous_value = None;
        let mut field_new_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "desktop_device_session_info" => {
                    if field_desktop_device_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("desktop_device_session_info"));
                    }
                    field_desktop_device_session_info = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceSyncBackupStatusChangedDetails {
            desktop_device_session_info: field_desktop_device_session_info.ok_or_else(|| ::serde::de::Error::missing_field("desktop_device_session_info"))?,
            previous_value: field_previous_value.ok_or_else(|| ::serde::de::Error::missing_field("previous_value"))?,
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("desktop_device_session_info", &self.desktop_device_session_info)?;
        s.serialize_field("previous_value", &self.previous_value)?;
        s.serialize_field("new_value", &self.new_value)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceSyncBackupStatusChangedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceSyncBackupStatusChangedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceSyncBackupStatusChangedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceSyncBackupStatusChangedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceSyncBackupStatusChangedDetails", DEVICE_SYNC_BACKUP_STATUS_CHANGED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceSyncBackupStatusChangedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceSyncBackupStatusChangedDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceSyncBackupStatusChangedType {
    pub description: String,
}

impl DeviceSyncBackupStatusChangedType {
    pub fn new(description: String) -> Self {
        DeviceSyncBackupStatusChangedType {
            description,
        }
    }
}

const DEVICE_SYNC_BACKUP_STATUS_CHANGED_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceSyncBackupStatusChangedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceSyncBackupStatusChangedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceSyncBackupStatusChangedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceSyncBackupStatusChangedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceSyncBackupStatusChangedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceSyncBackupStatusChangedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceSyncBackupStatusChangedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceSyncBackupStatusChangedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceSyncBackupStatusChangedType", DEVICE_SYNC_BACKUP_STATUS_CHANGED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceSyncBackupStatusChangedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceSyncBackupStatusChangedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeviceType {
    Desktop,
    Mobile,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeviceType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "desktop" => DeviceType::Desktop,
                    "mobile" => DeviceType::Mobile,
                    _ => DeviceType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["desktop",
                                    "mobile",
                                    "other"];
        deserializer.deserialize_struct("DeviceType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeviceType::Desktop => {
                // unit
                let mut s = serializer.serialize_struct("DeviceType", 1)?;
                s.serialize_field(".tag", "desktop")?;
                s.end()
            }
            DeviceType::Mobile => {
                // unit
                let mut s = serializer.serialize_struct("DeviceType", 1)?;
                s.serialize_field(".tag", "mobile")?;
                s.end()
            }
            DeviceType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Disconnected device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceUnlinkDetails {
    /// True if the user requested to delete data after device unlink, false otherwise.
    pub delete_data: bool,
    /// Session unique id.
    pub session_info: Option<SessionLogInfo>,
    /// The device name. Might be missing due to historical data gap.
    pub display_name: Option<String>,
}

impl DeviceUnlinkDetails {
    pub fn new(delete_data: bool) -> Self {
        DeviceUnlinkDetails {
            delete_data,
            session_info: None,
            display_name: None,
        }
    }

    pub fn with_session_info(mut self, value: SessionLogInfo) -> Self {
        self.session_info = Some(value);
        self
    }

    pub fn with_display_name(mut self, value: String) -> Self {
        self.display_name = Some(value);
        self
    }
}

const DEVICE_UNLINK_DETAILS_FIELDS: &[&str] = &["delete_data",
                                                "session_info",
                                                "display_name"];
impl DeviceUnlinkDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceUnlinkDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceUnlinkDetails>, V::Error> {
        let mut field_delete_data = None;
        let mut field_session_info = None;
        let mut field_display_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "delete_data" => {
                    if field_delete_data.is_some() {
                        return Err(::serde::de::Error::duplicate_field("delete_data"));
                    }
                    field_delete_data = Some(map.next_value()?);
                }
                "session_info" => {
                    if field_session_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("session_info"));
                    }
                    field_session_info = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceUnlinkDetails {
            delete_data: field_delete_data.ok_or_else(|| ::serde::de::Error::missing_field("delete_data"))?,
            session_info: field_session_info,
            display_name: field_display_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("delete_data", &self.delete_data)?;
        if let Some(val) = &self.session_info {
            s.serialize_field("session_info", val)?;
        }
        if let Some(val) = &self.display_name {
            s.serialize_field("display_name", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceUnlinkDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceUnlinkDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceUnlinkDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceUnlinkDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceUnlinkDetails", DEVICE_UNLINK_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceUnlinkDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceUnlinkDetails", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeviceUnlinkPolicy {
    Keep,
    Remove,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceUnlinkPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeviceUnlinkPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceUnlinkPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "keep" => DeviceUnlinkPolicy::Keep,
                    "remove" => DeviceUnlinkPolicy::Remove,
                    _ => DeviceUnlinkPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["keep",
                                    "remove",
                                    "other"];
        deserializer.deserialize_struct("DeviceUnlinkPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceUnlinkPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeviceUnlinkPolicy::Keep => {
                // unit
                let mut s = serializer.serialize_struct("DeviceUnlinkPolicy", 1)?;
                s.serialize_field(".tag", "keep")?;
                s.end()
            }
            DeviceUnlinkPolicy::Remove => {
                // unit
                let mut s = serializer.serialize_struct("DeviceUnlinkPolicy", 1)?;
                s.serialize_field(".tag", "remove")?;
                s.end()
            }
            DeviceUnlinkPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeviceUnlinkType {
    pub description: String,
}

impl DeviceUnlinkType {
    pub fn new(description: String) -> Self {
        DeviceUnlinkType {
            description,
        }
    }
}

const DEVICE_UNLINK_TYPE_FIELDS: &[&str] = &["description"];
impl DeviceUnlinkType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeviceUnlinkType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeviceUnlinkType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeviceUnlinkType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeviceUnlinkType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeviceUnlinkType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeviceUnlinkType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeviceUnlinkType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeviceUnlinkType", DEVICE_UNLINK_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeviceUnlinkType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeviceUnlinkType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Added members to directory restrictions list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DirectoryRestrictionsAddMembersDetails {
}

impl Default for DirectoryRestrictionsAddMembersDetails {
    fn default() -> Self {
        DirectoryRestrictionsAddMembersDetails {
        }
    }
}

const DIRECTORY_RESTRICTIONS_ADD_MEMBERS_DETAILS_FIELDS: &[&str] = &[];
impl DirectoryRestrictionsAddMembersDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DirectoryRestrictionsAddMembersDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DirectoryRestrictionsAddMembersDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DirectoryRestrictionsAddMembersDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DirectoryRestrictionsAddMembersDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DirectoryRestrictionsAddMembersDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DirectoryRestrictionsAddMembersDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DirectoryRestrictionsAddMembersDetails", DIRECTORY_RESTRICTIONS_ADD_MEMBERS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DirectoryRestrictionsAddMembersDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DirectoryRestrictionsAddMembersDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DirectoryRestrictionsAddMembersType {
    pub description: String,
}

impl DirectoryRestrictionsAddMembersType {
    pub fn new(description: String) -> Self {
        DirectoryRestrictionsAddMembersType {
            description,
        }
    }
}

const DIRECTORY_RESTRICTIONS_ADD_MEMBERS_TYPE_FIELDS: &[&str] = &["description"];
impl DirectoryRestrictionsAddMembersType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DirectoryRestrictionsAddMembersType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DirectoryRestrictionsAddMembersType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DirectoryRestrictionsAddMembersType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DirectoryRestrictionsAddMembersType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DirectoryRestrictionsAddMembersType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DirectoryRestrictionsAddMembersType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DirectoryRestrictionsAddMembersType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DirectoryRestrictionsAddMembersType", DIRECTORY_RESTRICTIONS_ADD_MEMBERS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DirectoryRestrictionsAddMembersType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DirectoryRestrictionsAddMembersType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Removed members from directory restrictions list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DirectoryRestrictionsRemoveMembersDetails {
}

impl Default for DirectoryRestrictionsRemoveMembersDetails {
    fn default() -> Self {
        DirectoryRestrictionsRemoveMembersDetails {
        }
    }
}

const DIRECTORY_RESTRICTIONS_REMOVE_MEMBERS_DETAILS_FIELDS: &[&str] = &[];
impl DirectoryRestrictionsRemoveMembersDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DirectoryRestrictionsRemoveMembersDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DirectoryRestrictionsRemoveMembersDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DirectoryRestrictionsRemoveMembersDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DirectoryRestrictionsRemoveMembersDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DirectoryRestrictionsRemoveMembersDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DirectoryRestrictionsRemoveMembersDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DirectoryRestrictionsRemoveMembersDetails", DIRECTORY_RESTRICTIONS_REMOVE_MEMBERS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DirectoryRestrictionsRemoveMembersDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DirectoryRestrictionsRemoveMembersDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DirectoryRestrictionsRemoveMembersType {
    pub description: String,
}

impl DirectoryRestrictionsRemoveMembersType {
    pub fn new(description: String) -> Self {
        DirectoryRestrictionsRemoveMembersType {
            description,
        }
    }
}

const DIRECTORY_RESTRICTIONS_REMOVE_MEMBERS_TYPE_FIELDS: &[&str] = &["description"];
impl DirectoryRestrictionsRemoveMembersType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DirectoryRestrictionsRemoveMembersType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DirectoryRestrictionsRemoveMembersType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DirectoryRestrictionsRemoveMembersType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DirectoryRestrictionsRemoveMembersType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DirectoryRestrictionsRemoveMembersType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DirectoryRestrictionsRemoveMembersType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DirectoryRestrictionsRemoveMembersType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DirectoryRestrictionsRemoveMembersType", DIRECTORY_RESTRICTIONS_REMOVE_MEMBERS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DirectoryRestrictionsRemoveMembersType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DirectoryRestrictionsRemoveMembersType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Disabled domain invites.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DisabledDomainInvitesDetails {
}

impl Default for DisabledDomainInvitesDetails {
    fn default() -> Self {
        DisabledDomainInvitesDetails {
        }
    }
}

const DISABLED_DOMAIN_INVITES_DETAILS_FIELDS: &[&str] = &[];
impl DisabledDomainInvitesDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DisabledDomainInvitesDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DisabledDomainInvitesDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DisabledDomainInvitesDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DisabledDomainInvitesDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DisabledDomainInvitesDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DisabledDomainInvitesDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DisabledDomainInvitesDetails", DISABLED_DOMAIN_INVITES_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DisabledDomainInvitesDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DisabledDomainInvitesDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DisabledDomainInvitesType {
    pub description: String,
}

impl DisabledDomainInvitesType {
    pub fn new(description: String) -> Self {
        DisabledDomainInvitesType {
            description,
        }
    }
}

const DISABLED_DOMAIN_INVITES_TYPE_FIELDS: &[&str] = &["description"];
impl DisabledDomainInvitesType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DisabledDomainInvitesType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DisabledDomainInvitesType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DisabledDomainInvitesType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DisabledDomainInvitesType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DisabledDomainInvitesType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DisabledDomainInvitesType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DisabledDomainInvitesType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DisabledDomainInvitesType", DISABLED_DOMAIN_INVITES_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DisabledDomainInvitesType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DisabledDomainInvitesType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DispositionActionType {
    AutomaticDelete,
    AutomaticPermanentlyDelete,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DispositionActionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DispositionActionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DispositionActionType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "automatic_delete" => DispositionActionType::AutomaticDelete,
                    "automatic_permanently_delete" => DispositionActionType::AutomaticPermanentlyDelete,
                    _ => DispositionActionType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["automatic_delete",
                                    "automatic_permanently_delete",
                                    "other"];
        deserializer.deserialize_struct("DispositionActionType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DispositionActionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DispositionActionType::AutomaticDelete => {
                // unit
                let mut s = serializer.serialize_struct("DispositionActionType", 1)?;
                s.serialize_field(".tag", "automatic_delete")?;
                s.end()
            }
            DispositionActionType::AutomaticPermanentlyDelete => {
                // unit
                let mut s = serializer.serialize_struct("DispositionActionType", 1)?;
                s.serialize_field(".tag", "automatic_permanently_delete")?;
                s.end()
            }
            DispositionActionType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Approved user's request to join team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesApproveRequestToJoinTeamDetails {
}

impl Default for DomainInvitesApproveRequestToJoinTeamDetails {
    fn default() -> Self {
        DomainInvitesApproveRequestToJoinTeamDetails {
        }
    }
}

const DOMAIN_INVITES_APPROVE_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS: &[&str] = &[];
impl DomainInvitesApproveRequestToJoinTeamDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DomainInvitesApproveRequestToJoinTeamDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DomainInvitesApproveRequestToJoinTeamDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesApproveRequestToJoinTeamDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesApproveRequestToJoinTeamDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesApproveRequestToJoinTeamDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesApproveRequestToJoinTeamDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesApproveRequestToJoinTeamDetails", DOMAIN_INVITES_APPROVE_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesApproveRequestToJoinTeamDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DomainInvitesApproveRequestToJoinTeamDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesApproveRequestToJoinTeamType {
    pub description: String,
}

impl DomainInvitesApproveRequestToJoinTeamType {
    pub fn new(description: String) -> Self {
        DomainInvitesApproveRequestToJoinTeamType {
            description,
        }
    }
}

const DOMAIN_INVITES_APPROVE_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesApproveRequestToJoinTeamType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesApproveRequestToJoinTeamType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesApproveRequestToJoinTeamType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesApproveRequestToJoinTeamType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesApproveRequestToJoinTeamType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesApproveRequestToJoinTeamType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesApproveRequestToJoinTeamType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesApproveRequestToJoinTeamType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesApproveRequestToJoinTeamType", DOMAIN_INVITES_APPROVE_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesApproveRequestToJoinTeamType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesApproveRequestToJoinTeamType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Declined user's request to join team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesDeclineRequestToJoinTeamDetails {
}

impl Default for DomainInvitesDeclineRequestToJoinTeamDetails {
    fn default() -> Self {
        DomainInvitesDeclineRequestToJoinTeamDetails {
        }
    }
}

const DOMAIN_INVITES_DECLINE_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS: &[&str] = &[];
impl DomainInvitesDeclineRequestToJoinTeamDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DomainInvitesDeclineRequestToJoinTeamDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DomainInvitesDeclineRequestToJoinTeamDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesDeclineRequestToJoinTeamDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesDeclineRequestToJoinTeamDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesDeclineRequestToJoinTeamDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesDeclineRequestToJoinTeamDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesDeclineRequestToJoinTeamDetails", DOMAIN_INVITES_DECLINE_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesDeclineRequestToJoinTeamDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DomainInvitesDeclineRequestToJoinTeamDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesDeclineRequestToJoinTeamType {
    pub description: String,
}

impl DomainInvitesDeclineRequestToJoinTeamType {
    pub fn new(description: String) -> Self {
        DomainInvitesDeclineRequestToJoinTeamType {
            description,
        }
    }
}

const DOMAIN_INVITES_DECLINE_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesDeclineRequestToJoinTeamType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesDeclineRequestToJoinTeamType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesDeclineRequestToJoinTeamType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesDeclineRequestToJoinTeamType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesDeclineRequestToJoinTeamType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesDeclineRequestToJoinTeamType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesDeclineRequestToJoinTeamType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesDeclineRequestToJoinTeamType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesDeclineRequestToJoinTeamType", DOMAIN_INVITES_DECLINE_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesDeclineRequestToJoinTeamType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesDeclineRequestToJoinTeamType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sent domain invites to existing domain accounts.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesEmailExistingUsersDetails {
    /// Domain names.
    pub domain_name: String,
    /// Number of recipients.
    pub num_recipients: u64,
}

impl DomainInvitesEmailExistingUsersDetails {
    pub fn new(domain_name: String, num_recipients: u64) -> Self {
        DomainInvitesEmailExistingUsersDetails {
            domain_name,
            num_recipients,
        }
    }
}

const DOMAIN_INVITES_EMAIL_EXISTING_USERS_DETAILS_FIELDS: &[&str] = &["domain_name",
                                                                      "num_recipients"];
impl DomainInvitesEmailExistingUsersDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesEmailExistingUsersDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesEmailExistingUsersDetails>, V::Error> {
        let mut field_domain_name = None;
        let mut field_num_recipients = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_name" => {
                    if field_domain_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_name"));
                    }
                    field_domain_name = Some(map.next_value()?);
                }
                "num_recipients" => {
                    if field_num_recipients.is_some() {
                        return Err(::serde::de::Error::duplicate_field("num_recipients"));
                    }
                    field_num_recipients = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesEmailExistingUsersDetails {
            domain_name: field_domain_name.ok_or_else(|| ::serde::de::Error::missing_field("domain_name"))?,
            num_recipients: field_num_recipients.ok_or_else(|| ::serde::de::Error::missing_field("num_recipients"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_name", &self.domain_name)?;
        s.serialize_field("num_recipients", &self.num_recipients)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesEmailExistingUsersDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesEmailExistingUsersDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesEmailExistingUsersDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesEmailExistingUsersDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesEmailExistingUsersDetails", DOMAIN_INVITES_EMAIL_EXISTING_USERS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesEmailExistingUsersDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesEmailExistingUsersDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesEmailExistingUsersType {
    pub description: String,
}

impl DomainInvitesEmailExistingUsersType {
    pub fn new(description: String) -> Self {
        DomainInvitesEmailExistingUsersType {
            description,
        }
    }
}

const DOMAIN_INVITES_EMAIL_EXISTING_USERS_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesEmailExistingUsersType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesEmailExistingUsersType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesEmailExistingUsersType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesEmailExistingUsersType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesEmailExistingUsersType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesEmailExistingUsersType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesEmailExistingUsersType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesEmailExistingUsersType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesEmailExistingUsersType", DOMAIN_INVITES_EMAIL_EXISTING_USERS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesEmailExistingUsersType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesEmailExistingUsersType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Requested to join team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesRequestToJoinTeamDetails {
}

impl Default for DomainInvitesRequestToJoinTeamDetails {
    fn default() -> Self {
        DomainInvitesRequestToJoinTeamDetails {
        }
    }
}

const DOMAIN_INVITES_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS: &[&str] = &[];
impl DomainInvitesRequestToJoinTeamDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DomainInvitesRequestToJoinTeamDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DomainInvitesRequestToJoinTeamDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesRequestToJoinTeamDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesRequestToJoinTeamDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesRequestToJoinTeamDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesRequestToJoinTeamDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesRequestToJoinTeamDetails", DOMAIN_INVITES_REQUEST_TO_JOIN_TEAM_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesRequestToJoinTeamDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DomainInvitesRequestToJoinTeamDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesRequestToJoinTeamType {
    pub description: String,
}

impl DomainInvitesRequestToJoinTeamType {
    pub fn new(description: String) -> Self {
        DomainInvitesRequestToJoinTeamType {
            description,
        }
    }
}

const DOMAIN_INVITES_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesRequestToJoinTeamType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesRequestToJoinTeamType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesRequestToJoinTeamType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesRequestToJoinTeamType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesRequestToJoinTeamType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesRequestToJoinTeamType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesRequestToJoinTeamType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesRequestToJoinTeamType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesRequestToJoinTeamType", DOMAIN_INVITES_REQUEST_TO_JOIN_TEAM_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesRequestToJoinTeamType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesRequestToJoinTeamType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Disabled "Automatically invite new users".
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesSetInviteNewUserPrefToNoDetails {
}

impl Default for DomainInvitesSetInviteNewUserPrefToNoDetails {
    fn default() -> Self {
        DomainInvitesSetInviteNewUserPrefToNoDetails {
        }
    }
}

const DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_NO_DETAILS_FIELDS: &[&str] = &[];
impl DomainInvitesSetInviteNewUserPrefToNoDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DomainInvitesSetInviteNewUserPrefToNoDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DomainInvitesSetInviteNewUserPrefToNoDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesSetInviteNewUserPrefToNoDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesSetInviteNewUserPrefToNoDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesSetInviteNewUserPrefToNoDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesSetInviteNewUserPrefToNoDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesSetInviteNewUserPrefToNoDetails", DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_NO_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesSetInviteNewUserPrefToNoDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DomainInvitesSetInviteNewUserPrefToNoDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesSetInviteNewUserPrefToNoType {
    pub description: String,
}

impl DomainInvitesSetInviteNewUserPrefToNoType {
    pub fn new(description: String) -> Self {
        DomainInvitesSetInviteNewUserPrefToNoType {
            description,
        }
    }
}

const DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_NO_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesSetInviteNewUserPrefToNoType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesSetInviteNewUserPrefToNoType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesSetInviteNewUserPrefToNoType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesSetInviteNewUserPrefToNoType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesSetInviteNewUserPrefToNoType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesSetInviteNewUserPrefToNoType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesSetInviteNewUserPrefToNoType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesSetInviteNewUserPrefToNoType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesSetInviteNewUserPrefToNoType", DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_NO_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesSetInviteNewUserPrefToNoType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesSetInviteNewUserPrefToNoType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enabled "Automatically invite new users".
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesSetInviteNewUserPrefToYesDetails {
}

impl Default for DomainInvitesSetInviteNewUserPrefToYesDetails {
    fn default() -> Self {
        DomainInvitesSetInviteNewUserPrefToYesDetails {
        }
    }
}

const DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_YES_DETAILS_FIELDS: &[&str] = &[];
impl DomainInvitesSetInviteNewUserPrefToYesDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<DomainInvitesSetInviteNewUserPrefToYesDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(DomainInvitesSetInviteNewUserPrefToYesDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesSetInviteNewUserPrefToYesDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesSetInviteNewUserPrefToYesDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesSetInviteNewUserPrefToYesDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesSetInviteNewUserPrefToYesDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesSetInviteNewUserPrefToYesDetails", DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_YES_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesSetInviteNewUserPrefToYesDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("DomainInvitesSetInviteNewUserPrefToYesDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainInvitesSetInviteNewUserPrefToYesType {
    pub description: String,
}

impl DomainInvitesSetInviteNewUserPrefToYesType {
    pub fn new(description: String) -> Self {
        DomainInvitesSetInviteNewUserPrefToYesType {
            description,
        }
    }
}

const DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_YES_TYPE_FIELDS: &[&str] = &["description"];
impl DomainInvitesSetInviteNewUserPrefToYesType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainInvitesSetInviteNewUserPrefToYesType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainInvitesSetInviteNewUserPrefToYesType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainInvitesSetInviteNewUserPrefToYesType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainInvitesSetInviteNewUserPrefToYesType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainInvitesSetInviteNewUserPrefToYesType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainInvitesSetInviteNewUserPrefToYesType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainInvitesSetInviteNewUserPrefToYesType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainInvitesSetInviteNewUserPrefToYesType", DOMAIN_INVITES_SET_INVITE_NEW_USER_PREF_TO_YES_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainInvitesSetInviteNewUserPrefToYesType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainInvitesSetInviteNewUserPrefToYesType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Failed to verify team domain.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationAddDomainFailDetails {
    /// Domain name.
    pub domain_name: String,
    /// Domain name verification method. Might be missing due to historical data gap.
    pub verification_method: Option<String>,
}

impl DomainVerificationAddDomainFailDetails {
    pub fn new(domain_name: String) -> Self {
        DomainVerificationAddDomainFailDetails {
            domain_name,
            verification_method: None,
        }
    }

    pub fn with_verification_method(mut self, value: String) -> Self {
        self.verification_method = Some(value);
        self
    }
}

const DOMAIN_VERIFICATION_ADD_DOMAIN_FAIL_DETAILS_FIELDS: &[&str] = &["domain_name",
                                                                      "verification_method"];
impl DomainVerificationAddDomainFailDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationAddDomainFailDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationAddDomainFailDetails>, V::Error> {
        let mut field_domain_name = None;
        let mut field_verification_method = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_name" => {
                    if field_domain_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_name"));
                    }
                    field_domain_name = Some(map.next_value()?);
                }
                "verification_method" => {
                    if field_verification_method.is_some() {
                        return Err(::serde::de::Error::duplicate_field("verification_method"));
                    }
                    field_verification_method = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationAddDomainFailDetails {
            domain_name: field_domain_name.ok_or_else(|| ::serde::de::Error::missing_field("domain_name"))?,
            verification_method: field_verification_method,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_name", &self.domain_name)?;
        if let Some(val) = &self.verification_method {
            s.serialize_field("verification_method", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationAddDomainFailDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationAddDomainFailDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationAddDomainFailDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationAddDomainFailDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationAddDomainFailDetails", DOMAIN_VERIFICATION_ADD_DOMAIN_FAIL_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationAddDomainFailDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationAddDomainFailDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationAddDomainFailType {
    pub description: String,
}

impl DomainVerificationAddDomainFailType {
    pub fn new(description: String) -> Self {
        DomainVerificationAddDomainFailType {
            description,
        }
    }
}

const DOMAIN_VERIFICATION_ADD_DOMAIN_FAIL_TYPE_FIELDS: &[&str] = &["description"];
impl DomainVerificationAddDomainFailType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationAddDomainFailType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationAddDomainFailType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationAddDomainFailType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationAddDomainFailType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationAddDomainFailType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationAddDomainFailType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationAddDomainFailType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationAddDomainFailType", DOMAIN_VERIFICATION_ADD_DOMAIN_FAIL_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationAddDomainFailType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationAddDomainFailType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Verified team domain.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationAddDomainSuccessDetails {
    /// Domain names.
    pub domain_names: Vec<String>,
    /// Domain name verification method. Might be missing due to historical data gap.
    pub verification_method: Option<String>,
}

impl DomainVerificationAddDomainSuccessDetails {
    pub fn new(domain_names: Vec<String>) -> Self {
        DomainVerificationAddDomainSuccessDetails {
            domain_names,
            verification_method: None,
        }
    }

    pub fn with_verification_method(mut self, value: String) -> Self {
        self.verification_method = Some(value);
        self
    }
}

const DOMAIN_VERIFICATION_ADD_DOMAIN_SUCCESS_DETAILS_FIELDS: &[&str] = &["domain_names",
                                                                         "verification_method"];
impl DomainVerificationAddDomainSuccessDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationAddDomainSuccessDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationAddDomainSuccessDetails>, V::Error> {
        let mut field_domain_names = None;
        let mut field_verification_method = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_names" => {
                    if field_domain_names.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_names"));
                    }
                    field_domain_names = Some(map.next_value()?);
                }
                "verification_method" => {
                    if field_verification_method.is_some() {
                        return Err(::serde::de::Error::duplicate_field("verification_method"));
                    }
                    field_verification_method = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationAddDomainSuccessDetails {
            domain_names: field_domain_names.ok_or_else(|| ::serde::de::Error::missing_field("domain_names"))?,
            verification_method: field_verification_method,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_names", &self.domain_names)?;
        if let Some(val) = &self.verification_method {
            s.serialize_field("verification_method", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationAddDomainSuccessDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationAddDomainSuccessDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationAddDomainSuccessDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationAddDomainSuccessDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationAddDomainSuccessDetails", DOMAIN_VERIFICATION_ADD_DOMAIN_SUCCESS_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationAddDomainSuccessDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationAddDomainSuccessDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationAddDomainSuccessType {
    pub description: String,
}

impl DomainVerificationAddDomainSuccessType {
    pub fn new(description: String) -> Self {
        DomainVerificationAddDomainSuccessType {
            description,
        }
    }
}

const DOMAIN_VERIFICATION_ADD_DOMAIN_SUCCESS_TYPE_FIELDS: &[&str] = &["description"];
impl DomainVerificationAddDomainSuccessType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationAddDomainSuccessType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationAddDomainSuccessType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationAddDomainSuccessType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationAddDomainSuccessType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationAddDomainSuccessType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationAddDomainSuccessType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationAddDomainSuccessType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationAddDomainSuccessType", DOMAIN_VERIFICATION_ADD_DOMAIN_SUCCESS_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationAddDomainSuccessType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationAddDomainSuccessType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Removed domain from list of verified team domains.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationRemoveDomainDetails {
    /// Domain names.
    pub domain_names: Vec<String>,
}

impl DomainVerificationRemoveDomainDetails {
    pub fn new(domain_names: Vec<String>) -> Self {
        DomainVerificationRemoveDomainDetails {
            domain_names,
        }
    }
}

const DOMAIN_VERIFICATION_REMOVE_DOMAIN_DETAILS_FIELDS: &[&str] = &["domain_names"];
impl DomainVerificationRemoveDomainDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationRemoveDomainDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationRemoveDomainDetails>, V::Error> {
        let mut field_domain_names = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "domain_names" => {
                    if field_domain_names.is_some() {
                        return Err(::serde::de::Error::duplicate_field("domain_names"));
                    }
                    field_domain_names = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationRemoveDomainDetails {
            domain_names: field_domain_names.ok_or_else(|| ::serde::de::Error::missing_field("domain_names"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("domain_names", &self.domain_names)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationRemoveDomainDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationRemoveDomainDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationRemoveDomainDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationRemoveDomainDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationRemoveDomainDetails", DOMAIN_VERIFICATION_REMOVE_DOMAIN_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationRemoveDomainDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationRemoveDomainDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DomainVerificationRemoveDomainType {
    pub description: String,
}

impl DomainVerificationRemoveDomainType {
    pub fn new(description: String) -> Self {
        DomainVerificationRemoveDomainType {
            description,
        }
    }
}

const DOMAIN_VERIFICATION_REMOVE_DOMAIN_TYPE_FIELDS: &[&str] = &["description"];
impl DomainVerificationRemoveDomainType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DomainVerificationRemoveDomainType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DomainVerificationRemoveDomainType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DomainVerificationRemoveDomainType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DomainVerificationRemoveDomainType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DomainVerificationRemoveDomainType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DomainVerificationRemoveDomainType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DomainVerificationRemoveDomainType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DomainVerificationRemoveDomainType", DOMAIN_VERIFICATION_REMOVE_DOMAIN_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DomainVerificationRemoveDomainType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DomainVerificationRemoveDomainType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Shared content downloads policy
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DownloadPolicyType {
    Allow,
    Disallow,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DownloadPolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DownloadPolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DownloadPolicyType structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "allow" => DownloadPolicyType::Allow,
                    "disallow" => DownloadPolicyType::Disallow,
                    _ => DownloadPolicyType::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["allow",
                                    "disallow",
                                    "other"];
        deserializer.deserialize_struct("DownloadPolicyType", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DownloadPolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DownloadPolicyType::Allow => {
                // unit
                let mut s = serializer.serialize_struct("DownloadPolicyType", 1)?;
                s.serialize_field(".tag", "allow")?;
                s.end()
            }
            DownloadPolicyType::Disallow => {
                // unit
                let mut s = serializer.serialize_struct("DownloadPolicyType", 1)?;
                s.serialize_field(".tag", "disallow")?;
                s.end()
            }
            DownloadPolicyType::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Exported passwords.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DropboxPasswordsExportedDetails {
    /// The platform the device runs export.
    pub platform: String,
}

impl DropboxPasswordsExportedDetails {
    pub fn new(platform: String) -> Self {
        DropboxPasswordsExportedDetails {
            platform,
        }
    }
}

const DROPBOX_PASSWORDS_EXPORTED_DETAILS_FIELDS: &[&str] = &["platform"];
impl DropboxPasswordsExportedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DropboxPasswordsExportedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DropboxPasswordsExportedDetails>, V::Error> {
        let mut field_platform = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "platform" => {
                    if field_platform.is_some() {
                        return Err(::serde::de::Error::duplicate_field("platform"));
                    }
                    field_platform = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DropboxPasswordsExportedDetails {
            platform: field_platform.ok_or_else(|| ::serde::de::Error::missing_field("platform"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("platform", &self.platform)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DropboxPasswordsExportedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DropboxPasswordsExportedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DropboxPasswordsExportedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DropboxPasswordsExportedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DropboxPasswordsExportedDetails", DROPBOX_PASSWORDS_EXPORTED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DropboxPasswordsExportedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DropboxPasswordsExportedDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DropboxPasswordsExportedType {
    pub description: String,
}

impl DropboxPasswordsExportedType {
    pub fn new(description: String) -> Self {
        DropboxPasswordsExportedType {
            description,
        }
    }
}

const DROPBOX_PASSWORDS_EXPORTED_TYPE_FIELDS: &[&str] = &["description"];
impl DropboxPasswordsExportedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DropboxPasswordsExportedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DropboxPasswordsExportedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DropboxPasswordsExportedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DropboxPasswordsExportedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DropboxPasswordsExportedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DropboxPasswordsExportedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DropboxPasswordsExportedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DropboxPasswordsExportedType", DROPBOX_PASSWORDS_EXPORTED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DropboxPasswordsExportedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DropboxPasswordsExportedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enrolled new Dropbox Passwords device.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DropboxPasswordsNewDeviceEnrolledDetails {
    /// Whether it's a first device enrolled.
    pub is_first_device: bool,
    /// The platform the device is enrolled.
    pub platform: String,
}

impl DropboxPasswordsNewDeviceEnrolledDetails {
    pub fn new(is_first_device: bool, platform: String) -> Self {
        DropboxPasswordsNewDeviceEnrolledDetails {
            is_first_device,
            platform,
        }
    }
}

const DROPBOX_PASSWORDS_NEW_DEVICE_ENROLLED_DETAILS_FIELDS: &[&str] = &["is_first_device",
                                                                        "platform"];
impl DropboxPasswordsNewDeviceEnrolledDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DropboxPasswordsNewDeviceEnrolledDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DropboxPasswordsNewDeviceEnrolledDetails>, V::Error> {
        let mut field_is_first_device = None;
        let mut field_platform = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "is_first_device" => {
                    if field_is_first_device.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_first_device"));
                    }
                    field_is_first_device = Some(map.next_value()?);
                }
                "platform" => {
                    if field_platform.is_some() {
                        return Err(::serde::de::Error::duplicate_field("platform"));
                    }
                    field_platform = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DropboxPasswordsNewDeviceEnrolledDetails {
            is_first_device: field_is_first_device.ok_or_else(|| ::serde::de::Error::missing_field("is_first_device"))?,
            platform: field_platform.ok_or_else(|| ::serde::de::Error::missing_field("platform"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("is_first_device", &self.is_first_device)?;
        s.serialize_field("platform", &self.platform)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DropboxPasswordsNewDeviceEnrolledDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DropboxPasswordsNewDeviceEnrolledDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DropboxPasswordsNewDeviceEnrolledDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DropboxPasswordsNewDeviceEnrolledDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DropboxPasswordsNewDeviceEnrolledDetails", DROPBOX_PASSWORDS_NEW_DEVICE_ENROLLED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DropboxPasswordsNewDeviceEnrolledDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DropboxPasswordsNewDeviceEnrolledDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DropboxPasswordsNewDeviceEnrolledType {
    pub description: String,
}

impl DropboxPasswordsNewDeviceEnrolledType {
    pub fn new(description: String) -> Self {
        DropboxPasswordsNewDeviceEnrolledType {
            description,
        }
    }
}

const DROPBOX_PASSWORDS_NEW_DEVICE_ENROLLED_TYPE_FIELDS: &[&str] = &["description"];
impl DropboxPasswordsNewDeviceEnrolledType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DropboxPasswordsNewDeviceEnrolledType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DropboxPasswordsNewDeviceEnrolledType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DropboxPasswordsNewDeviceEnrolledType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DropboxPasswordsNewDeviceEnrolledType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DropboxPasswordsNewDeviceEnrolledType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DropboxPasswordsNewDeviceEnrolledType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DropboxPasswordsNewDeviceEnrolledType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DropboxPasswordsNewDeviceEnrolledType", DROPBOX_PASSWORDS_NEW_DEVICE_ENROLLED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DropboxPasswordsNewDeviceEnrolledType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DropboxPasswordsNewDeviceEnrolledType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Represents a time duration: unit and amount
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DurationLogInfo {
    /// Time unit.
    pub unit: TimeUnit,
    /// Amount of time.
    pub amount: u64,
}

impl DurationLogInfo {
    pub fn new(unit: TimeUnit, amount: u64) -> Self {
        DurationLogInfo {
            unit,
            amount,
        }
    }
}

const DURATION_LOG_INFO_FIELDS: &[&str] = &["unit",
                                            "amount"];
impl DurationLogInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DurationLogInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DurationLogInfo>, V::Error> {
        let mut field_unit = None;
        let mut field_amount = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "unit" => {
                    if field_unit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("unit"));
                    }
                    field_unit = Some(map.next_value()?);
                }
                "amount" => {
                    if field_amount.is_some() {
                        return Err(::serde::de::Error::duplicate_field("amount"));
                    }
                    field_amount = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DurationLogInfo {
            unit: field_unit.ok_or_else(|| ::serde::de::Error::missing_field("unit"))?,
            amount: field_amount.ok_or_else(|| ::serde::de::Error::missing_field("amount"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("unit", &self.unit)?;
        s.serialize_field("amount", &self.amount)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DurationLogInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DurationLogInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DurationLogInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DurationLogInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DurationLogInfo", DURATION_LOG_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DurationLogInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DurationLogInfo", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Added members to EMM exception list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmAddExceptionDetails {
}

impl Default for EmmAddExceptionDetails {
    fn default() -> Self {
        EmmAddExceptionDetails {
        }
    }
}

const EMM_ADD_EXCEPTION_DETAILS_FIELDS: &[&str] = &[];
impl EmmAddExceptionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EmmAddExceptionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EmmAddExceptionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmAddExceptionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmAddExceptionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmAddExceptionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmAddExceptionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmAddExceptionDetails", EMM_ADD_EXCEPTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmAddExceptionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EmmAddExceptionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmAddExceptionType {
    pub description: String,
}

impl EmmAddExceptionType {
    pub fn new(description: String) -> Self {
        EmmAddExceptionType {
            description,
        }
    }
}

const EMM_ADD_EXCEPTION_TYPE_FIELDS: &[&str] = &["description"];
impl EmmAddExceptionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmAddExceptionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmAddExceptionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmAddExceptionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmAddExceptionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmAddExceptionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmAddExceptionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmAddExceptionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmAddExceptionType", EMM_ADD_EXCEPTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmAddExceptionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmAddExceptionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enabled/disabled enterprise mobility management for members.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmChangePolicyDetails {
    /// New enterprise mobility management policy.
    pub new_value: super::team_policies::EmmState,
    /// Previous enterprise mobility management policy. Might be missing due to historical data gap.
    pub previous_value: Option<super::team_policies::EmmState>,
}

impl EmmChangePolicyDetails {
    pub fn new(new_value: super::team_policies::EmmState) -> Self {
        EmmChangePolicyDetails {
            new_value,
            previous_value: None,
        }
    }

    pub fn with_previous_value(mut self, value: super::team_policies::EmmState) -> Self {
        self.previous_value = Some(value);
        self
    }
}

const EMM_CHANGE_POLICY_DETAILS_FIELDS: &[&str] = &["new_value",
                                                    "previous_value"];
impl EmmChangePolicyDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmChangePolicyDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmChangePolicyDetails>, V::Error> {
        let mut field_new_value = None;
        let mut field_previous_value = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "new_value" => {
                    if field_new_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_value"));
                    }
                    field_new_value = Some(map.next_value()?);
                }
                "previous_value" => {
                    if field_previous_value.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_value"));
                    }
                    field_previous_value = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmChangePolicyDetails {
            new_value: field_new_value.ok_or_else(|| ::serde::de::Error::missing_field("new_value"))?,
            previous_value: field_previous_value,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("new_value", &self.new_value)?;
        if let Some(val) = &self.previous_value {
            s.serialize_field("previous_value", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmChangePolicyDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmChangePolicyDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmChangePolicyDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmChangePolicyDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmChangePolicyDetails", EMM_CHANGE_POLICY_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmChangePolicyDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmChangePolicyDetails", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmChangePolicyType {
    pub description: String,
}

impl EmmChangePolicyType {
    pub fn new(description: String) -> Self {
        EmmChangePolicyType {
            description,
        }
    }
}

const EMM_CHANGE_POLICY_TYPE_FIELDS: &[&str] = &["description"];
impl EmmChangePolicyType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmChangePolicyType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmChangePolicyType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmChangePolicyType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmChangePolicyType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmChangePolicyType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmChangePolicyType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmChangePolicyType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmChangePolicyType", EMM_CHANGE_POLICY_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmChangePolicyType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmChangePolicyType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Created EMM-excluded users report.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmCreateExceptionsReportDetails {
}

impl Default for EmmCreateExceptionsReportDetails {
    fn default() -> Self {
        EmmCreateExceptionsReportDetails {
        }
    }
}

const EMM_CREATE_EXCEPTIONS_REPORT_DETAILS_FIELDS: &[&str] = &[];
impl EmmCreateExceptionsReportDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EmmCreateExceptionsReportDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EmmCreateExceptionsReportDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmCreateExceptionsReportDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmCreateExceptionsReportDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmCreateExceptionsReportDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmCreateExceptionsReportDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmCreateExceptionsReportDetails", EMM_CREATE_EXCEPTIONS_REPORT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmCreateExceptionsReportDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EmmCreateExceptionsReportDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmCreateExceptionsReportType {
    pub description: String,
}

impl EmmCreateExceptionsReportType {
    pub fn new(description: String) -> Self {
        EmmCreateExceptionsReportType {
            description,
        }
    }
}

const EMM_CREATE_EXCEPTIONS_REPORT_TYPE_FIELDS: &[&str] = &["description"];
impl EmmCreateExceptionsReportType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmCreateExceptionsReportType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmCreateExceptionsReportType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmCreateExceptionsReportType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmCreateExceptionsReportType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmCreateExceptionsReportType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmCreateExceptionsReportType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmCreateExceptionsReportType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmCreateExceptionsReportType", EMM_CREATE_EXCEPTIONS_REPORT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmCreateExceptionsReportType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmCreateExceptionsReportType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Created EMM mobile app usage report.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmCreateUsageReportDetails {
}

impl Default for EmmCreateUsageReportDetails {
    fn default() -> Self {
        EmmCreateUsageReportDetails {
        }
    }
}

const EMM_CREATE_USAGE_REPORT_DETAILS_FIELDS: &[&str] = &[];
impl EmmCreateUsageReportDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EmmCreateUsageReportDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EmmCreateUsageReportDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmCreateUsageReportDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmCreateUsageReportDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmCreateUsageReportDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmCreateUsageReportDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmCreateUsageReportDetails", EMM_CREATE_USAGE_REPORT_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmCreateUsageReportDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EmmCreateUsageReportDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmCreateUsageReportType {
    pub description: String,
}

impl EmmCreateUsageReportType {
    pub fn new(description: String) -> Self {
        EmmCreateUsageReportType {
            description,
        }
    }
}

const EMM_CREATE_USAGE_REPORT_TYPE_FIELDS: &[&str] = &["description"];
impl EmmCreateUsageReportType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmCreateUsageReportType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmCreateUsageReportType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmCreateUsageReportType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmCreateUsageReportType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmCreateUsageReportType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmCreateUsageReportType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmCreateUsageReportType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmCreateUsageReportType", EMM_CREATE_USAGE_REPORT_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmCreateUsageReportType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmCreateUsageReportType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Failed to sign in via EMM.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmErrorDetails {
    /// Error details.
    pub error_details: FailureDetailsLogInfo,
}

impl EmmErrorDetails {
    pub fn new(error_details: FailureDetailsLogInfo) -> Self {
        EmmErrorDetails {
            error_details,
        }
    }
}

const EMM_ERROR_DETAILS_FIELDS: &[&str] = &["error_details"];
impl EmmErrorDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmErrorDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmErrorDetails>, V::Error> {
        let mut field_error_details = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "error_details" => {
                    if field_error_details.is_some() {
                        return Err(::serde::de::Error::duplicate_field("error_details"));
                    }
                    field_error_details = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmErrorDetails {
            error_details: field_error_details.ok_or_else(|| ::serde::de::Error::missing_field("error_details"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("error_details", &self.error_details)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmErrorDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmErrorDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmErrorDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmErrorDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmErrorDetails", EMM_ERROR_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmErrorDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmErrorDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmErrorType {
    pub description: String,
}

impl EmmErrorType {
    pub fn new(description: String) -> Self {
        EmmErrorType {
            description,
        }
    }
}

const EMM_ERROR_TYPE_FIELDS: &[&str] = &["description"];
impl EmmErrorType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmErrorType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmErrorType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmErrorType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmErrorType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmErrorType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmErrorType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmErrorType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmErrorType", EMM_ERROR_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmErrorType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmErrorType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Refreshed auth token used for setting up EMM.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmRefreshAuthTokenDetails {
}

impl Default for EmmRefreshAuthTokenDetails {
    fn default() -> Self {
        EmmRefreshAuthTokenDetails {
        }
    }
}

const EMM_REFRESH_AUTH_TOKEN_DETAILS_FIELDS: &[&str] = &[];
impl EmmRefreshAuthTokenDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EmmRefreshAuthTokenDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EmmRefreshAuthTokenDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmRefreshAuthTokenDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmRefreshAuthTokenDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmRefreshAuthTokenDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmRefreshAuthTokenDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmRefreshAuthTokenDetails", EMM_REFRESH_AUTH_TOKEN_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmRefreshAuthTokenDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EmmRefreshAuthTokenDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmRefreshAuthTokenType {
    pub description: String,
}

impl EmmRefreshAuthTokenType {
    pub fn new(description: String) -> Self {
        EmmRefreshAuthTokenType {
            description,
        }
    }
}

const EMM_REFRESH_AUTH_TOKEN_TYPE_FIELDS: &[&str] = &["description"];
impl EmmRefreshAuthTokenType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmRefreshAuthTokenType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmRefreshAuthTokenType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmRefreshAuthTokenType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmRefreshAuthTokenType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmRefreshAuthTokenType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmRefreshAuthTokenType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmRefreshAuthTokenType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmRefreshAuthTokenType", EMM_REFRESH_AUTH_TOKEN_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmRefreshAuthTokenType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmRefreshAuthTokenType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Removed members from EMM exception list.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmRemoveExceptionDetails {
}

impl Default for EmmRemoveExceptionDetails {
    fn default() -> Self {
        EmmRemoveExceptionDetails {
        }
    }
}

const EMM_REMOVE_EXCEPTION_DETAILS_FIELDS: &[&str] = &[];
impl EmmRemoveExceptionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EmmRemoveExceptionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EmmRemoveExceptionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmRemoveExceptionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmRemoveExceptionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmRemoveExceptionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmRemoveExceptionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmRemoveExceptionDetails", EMM_REMOVE_EXCEPTION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmRemoveExceptionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EmmRemoveExceptionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EmmRemoveExceptionType {
    pub description: String,
}

impl EmmRemoveExceptionType {
    pub fn new(description: String) -> Self {
        EmmRemoveExceptionType {
            description,
        }
    }
}

const EMM_REMOVE_EXCEPTION_TYPE_FIELDS: &[&str] = &["description"];
impl EmmRemoveExceptionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EmmRemoveExceptionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EmmRemoveExceptionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EmmRemoveExceptionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EmmRemoveExceptionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EmmRemoveExceptionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmRemoveExceptionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EmmRemoveExceptionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EmmRemoveExceptionType", EMM_REMOVE_EXCEPTION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EmmRemoveExceptionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EmmRemoveExceptionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Enabled domain invites.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EnabledDomainInvitesDetails {
}

impl Default for EnabledDomainInvitesDetails {
    fn default() -> Self {
        EnabledDomainInvitesDetails {
        }
    }
}

const ENABLED_DOMAIN_INVITES_DETAILS_FIELDS: &[&str] = &[];
impl EnabledDomainInvitesDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EnabledDomainInvitesDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EnabledDomainInvitesDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EnabledDomainInvitesDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EnabledDomainInvitesDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EnabledDomainInvitesDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EnabledDomainInvitesDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EnabledDomainInvitesDetails", ENABLED_DOMAIN_INVITES_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EnabledDomainInvitesDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EnabledDomainInvitesDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EnabledDomainInvitesType {
    pub description: String,
}

impl EnabledDomainInvitesType {
    pub fn new(description: String) -> Self {
        EnabledDomainInvitesType {
            description,
        }
    }
}

const ENABLED_DOMAIN_INVITES_TYPE_FIELDS: &[&str] = &["description"];
impl EnabledDomainInvitesType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EnabledDomainInvitesType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EnabledDomainInvitesType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EnabledDomainInvitesType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EnabledDomainInvitesType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EnabledDomainInvitesType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EnabledDomainInvitesType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EnabledDomainInvitesType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EnabledDomainInvitesType", ENABLED_DOMAIN_INVITES_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EnabledDomainInvitesType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EnabledDomainInvitesType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Ended enterprise admin session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EndedEnterpriseAdminSessionDeprecatedDetails {
    /// More information about the organization or team.
    pub federation_extra_details: FedExtraDetails,
}

impl EndedEnterpriseAdminSessionDeprecatedDetails {
    pub fn new(federation_extra_details: FedExtraDetails) -> Self {
        EndedEnterpriseAdminSessionDeprecatedDetails {
            federation_extra_details,
        }
    }
}

const ENDED_ENTERPRISE_ADMIN_SESSION_DEPRECATED_DETAILS_FIELDS: &[&str] = &["federation_extra_details"];
impl EndedEnterpriseAdminSessionDeprecatedDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EndedEnterpriseAdminSessionDeprecatedDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EndedEnterpriseAdminSessionDeprecatedDetails>, V::Error> {
        let mut field_federation_extra_details = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "federation_extra_details" => {
                    if field_federation_extra_details.is_some() {
                        return Err(::serde::de::Error::duplicate_field("federation_extra_details"));
                    }
                    field_federation_extra_details = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EndedEnterpriseAdminSessionDeprecatedDetails {
            federation_extra_details: field_federation_extra_details.ok_or_else(|| ::serde::de::Error::missing_field("federation_extra_details"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("federation_extra_details", &self.federation_extra_details)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EndedEnterpriseAdminSessionDeprecatedDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EndedEnterpriseAdminSessionDeprecatedDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EndedEnterpriseAdminSessionDeprecatedDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EndedEnterpriseAdminSessionDeprecatedDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EndedEnterpriseAdminSessionDeprecatedDetails", ENDED_ENTERPRISE_ADMIN_SESSION_DEPRECATED_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EndedEnterpriseAdminSessionDeprecatedDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EndedEnterpriseAdminSessionDeprecatedDetails", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EndedEnterpriseAdminSessionDeprecatedType {
    pub description: String,
}

impl EndedEnterpriseAdminSessionDeprecatedType {
    pub fn new(description: String) -> Self {
        EndedEnterpriseAdminSessionDeprecatedType {
            description,
        }
    }
}

const ENDED_ENTERPRISE_ADMIN_SESSION_DEPRECATED_TYPE_FIELDS: &[&str] = &["description"];
impl EndedEnterpriseAdminSessionDeprecatedType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EndedEnterpriseAdminSessionDeprecatedType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EndedEnterpriseAdminSessionDeprecatedType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EndedEnterpriseAdminSessionDeprecatedType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EndedEnterpriseAdminSessionDeprecatedType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EndedEnterpriseAdminSessionDeprecatedType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EndedEnterpriseAdminSessionDeprecatedType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EndedEnterpriseAdminSessionDeprecatedType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EndedEnterpriseAdminSessionDeprecatedType", ENDED_ENTERPRISE_ADMIN_SESSION_DEPRECATED_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EndedEnterpriseAdminSessionDeprecatedType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EndedEnterpriseAdminSessionDeprecatedType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Ended enterprise admin session.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EndedEnterpriseAdminSessionDetails {
}

impl Default for EndedEnterpriseAdminSessionDetails {
    fn default() -> Self {
        EndedEnterpriseAdminSessionDetails {
        }
    }
}

const ENDED_ENTERPRISE_ADMIN_SESSION_DETAILS_FIELDS: &[&str] = &[];
impl EndedEnterpriseAdminSessionDetails {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EndedEnterpriseAdminSessionDetails, V::Error> {
        // ignore any fields found; none are presently recognized
        crate::eat_json_fields(&mut map)?;
        Ok(EndedEnterpriseAdminSessionDetails {})
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EndedEnterpriseAdminSessionDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EndedEnterpriseAdminSessionDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EndedEnterpriseAdminSessionDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EndedEnterpriseAdminSessionDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EndedEnterpriseAdminSessionDetails", ENDED_ENTERPRISE_ADMIN_SESSION_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EndedEnterpriseAdminSessionDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        serializer.serialize_struct("EndedEnterpriseAdminSessionDetails", 0)?.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EndedEnterpriseAdminSessionType {
    pub description: String,
}

impl EndedEnterpriseAdminSessionType {
    pub fn new(description: String) -> Self {
        EndedEnterpriseAdminSessionType {
            description,
        }
    }
}

const ENDED_ENTERPRISE_ADMIN_SESSION_TYPE_FIELDS: &[&str] = &["description"];
impl EndedEnterpriseAdminSessionType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EndedEnterpriseAdminSessionType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EndedEnterpriseAdminSessionType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EndedEnterpriseAdminSessionType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EndedEnterpriseAdminSessionType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EndedEnterpriseAdminSessionType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EndedEnterpriseAdminSessionType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EndedEnterpriseAdminSessionType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EndedEnterpriseAdminSessionType", ENDED_ENTERPRISE_ADMIN_SESSION_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EndedEnterpriseAdminSessionType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EndedEnterpriseAdminSessionType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy for deciding whether password must be enforced when an externally shared link is updated
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum EnforceLinkPasswordPolicy {
    Optional,
    Required,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for EnforceLinkPasswordPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = EnforceLinkPasswordPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EnforceLinkPasswordPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "optional" => EnforceLinkPasswordPolicy::Optional,
                    "required" => EnforceLinkPasswordPolicy::Required,
                    _ => EnforceLinkPasswordPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["optional",
                                    "required",
                                    "other"];
        deserializer.deserialize_struct("EnforceLinkPasswordPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for EnforceLinkPasswordPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            EnforceLinkPasswordPolicy::Optional => {
                // unit
                let mut s = serializer.serialize_struct("EnforceLinkPasswordPolicy", 1)?;
                s.serialize_field(".tag", "optional")?;
                s.end()
            }
            EnforceLinkPasswordPolicy::Required => {
                // unit
                let mut s = serializer.serialize_struct("EnforceLinkPasswordPolicy", 1)?;
                s.serialize_field(".tag", "required")?;
                s.end()
            }
            EnforceLinkPasswordPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Changed who can update a setting.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EnterpriseSettingsLockingDetails {
    /// The secondary team name.
    pub team_name: String,
    /// Settings page name.
    pub settings_page_name: String,
    /// Previous locked settings page state.
    pub previous_settings_page_locking_state: String,
    /// New locked settings page state.
    pub new_settings_page_locking_state: String,
}

impl EnterpriseSettingsLockingDetails {
    pub fn new(
        team_name: String,
        settings_page_name: String,
        previous_settings_page_locking_state: String,
        new_settings_page_locking_state: String,
    ) -> Self {
        EnterpriseSettingsLockingDetails {
            team_name,
            settings_page_name,
            previous_settings_page_locking_state,
            new_settings_page_locking_state,
        }
    }
}

const ENTERPRISE_SETTINGS_LOCKING_DETAILS_FIELDS: &[&str] = &["team_name",
                                                              "settings_page_name",
                                                              "previous_settings_page_locking_state",
                                                              "new_settings_page_locking_state"];
impl EnterpriseSettingsLockingDetails {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EnterpriseSettingsLockingDetails, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EnterpriseSettingsLockingDetails>, V::Error> {
        let mut field_team_name = None;
        let mut field_settings_page_name = None;
        let mut field_previous_settings_page_locking_state = None;
        let mut field_new_settings_page_locking_state = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_name" => {
                    if field_team_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_name"));
                    }
                    field_team_name = Some(map.next_value()?);
                }
                "settings_page_name" => {
                    if field_settings_page_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("settings_page_name"));
                    }
                    field_settings_page_name = Some(map.next_value()?);
                }
                "previous_settings_page_locking_state" => {
                    if field_previous_settings_page_locking_state.is_some() {
                        return Err(::serde::de::Error::duplicate_field("previous_settings_page_locking_state"));
                    }
                    field_previous_settings_page_locking_state = Some(map.next_value()?);
                }
                "new_settings_page_locking_state" => {
                    if field_new_settings_page_locking_state.is_some() {
                        return Err(::serde::de::Error::duplicate_field("new_settings_page_locking_state"));
                    }
                    field_new_settings_page_locking_state = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EnterpriseSettingsLockingDetails {
            team_name: field_team_name.ok_or_else(|| ::serde::de::Error::missing_field("team_name"))?,
            settings_page_name: field_settings_page_name.ok_or_else(|| ::serde::de::Error::missing_field("settings_page_name"))?,
            previous_settings_page_locking_state: field_previous_settings_page_locking_state.ok_or_else(|| ::serde::de::Error::missing_field("previous_settings_page_locking_state"))?,
            new_settings_page_locking_state: field_new_settings_page_locking_state.ok_or_else(|| ::serde::de::Error::missing_field("new_settings_page_locking_state"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_name", &self.team_name)?;
        s.serialize_field("settings_page_name", &self.settings_page_name)?;
        s.serialize_field("previous_settings_page_locking_state", &self.previous_settings_page_locking_state)?;
        s.serialize_field("new_settings_page_locking_state", &self.new_settings_page_locking_state)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EnterpriseSettingsLockingDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EnterpriseSettingsLockingDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EnterpriseSettingsLockingDetails struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EnterpriseSettingsLockingDetails::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EnterpriseSettingsLockingDetails", ENTERPRISE_SETTINGS_LOCKING_DETAILS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EnterpriseSettingsLockingDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EnterpriseSettingsLockingDetails", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EnterpriseSettingsLockingType {
    pub description: String,
}

impl EnterpriseSettingsLockingType {
    pub fn new(description: String) -> Self {
        EnterpriseSettingsLockingType {
            description,
        }
    }
}

const ENTERPRISE_SETTINGS_LOCKING_TYPE_FIELDS: &[&str] = &["description"];
impl EnterpriseSettingsLockingType {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<EnterpriseSettingsLockingType, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<EnterpriseSettingsLockingType>, V::Error> {
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = EnterpriseSettingsLockingType {
            description: field_description.ok_or_else(|| ::serde::de::Error::missing_field("description"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("description", &self.description)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EnterpriseSettingsLockingType {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EnterpriseSettingsLockingType;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EnterpriseSettingsLockingType struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EnterpriseSettingsLockingType::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EnterpriseSettingsLockingType", ENTERPRISE_SETTINGS_LOCKING_TYPE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EnterpriseSettingsLockingType {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EnterpriseSettingsLockingType", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Category of events in event audit log.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum EventCategory {
    /// Events that involve team related alerts.
    AdminAlerting,
    /// Events that apply to management of linked apps.
    Apps,
    /// Events that have to do with comments on files and Paper documents.
    Comments,
    /// Events that involve data governance actions
    DataGovernance,
    /// Events that apply to linked devices on mobile, desktop and Web platforms.
    Devices,
    /// Events that involve domain management feature: domain verification, invite enforcement and
    /// account capture.
    Domains,
    /// Events that have to do with filesystem operations on files and folders: copy, move, delete,
    /// etc.
    FileOperations,
    /// Events that apply to the file requests feature.
    FileRequests,
    /// Events that involve group management.
    Groups,
    /// Events that involve users signing in to or out of Dropbox.
    Logins,
    /// Events that involve team member management.
    Members,
    /// Events that apply to Dropbox Paper.
    Paper,
    /// Events that involve using, changing or resetting passwords.
    Passwords,
    /// Events that concern generation of admin reports, including team activity and device usage.
    Reports,
    /// Events that apply to all types of sharing and collaboration.
    Sharing,
    /// Events that apply to Dropbox Showcase.
    Showcase,
    /// Events that involve using or configuring single sign-on as well as administrative policies
    /// concerning single sign-on.
    Sso,
    /// Events that involve team folder management.
    TeamFolders,
    /// Events that involve a change in team-wide policies.
    TeamPolicies,
    /// Events that involve a change in the team profile.
    TeamProfile,
    /// Events that involve using or configuring two factor authentication as well as administrative
    /// policies concerning two factor authentication.
    Tfa,
    /// Events that apply to cross-team trust establishment.
    TrustedTeams,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for EventCategory {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = EventCategory;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EventCategory structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "admin_alerting" => EventCategory::AdminAlerting,
                    "apps" => EventCategory::Apps,
                    "comments" => EventCategory::Comments,
                    "data_governance" => EventCategory::DataGovernance,
                    "devices" => EventCategory::Devices,
                    "domains" => EventCategory::Domains,
                    "file_operations" => EventCategory::FileOperations,
                    "file_requests" => EventCategory::FileRequests,
                    "groups" => EventCategory::Groups,
                    "logins" => EventCategory::Logins,
                    "members" => EventCategory::Members,
                    "paper" => EventCategory::Paper,
                    "passwords" => EventCategory::Passwords,
                    "reports" => EventCategory::Reports,
                    "sharing" => EventCategory::Sharing,
                    "showcase" => EventCategory::Showcase,
                    "sso" => EventCategory::Sso,
                    "team_folders" => EventCategory::TeamFolders,
                    "team_policies" => EventCategory::TeamPolicies,
                    "team_profile" => EventCategory::TeamProfile,
                    "tfa" => EventCategory::Tfa,
                    "trusted_teams" => EventCategory::TrustedTeams,
                    _ => EventCategory::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["admin_alerting",
                                    "apps",
                                    "comments",
                                    "data_governance",
                                    "devices",
                                    "domains",
                                    "file_operations",
                                    "file_requests",
                                    "groups",
                                    "logins",
                                    "members",
                                    "paper",
                                    "passwords",
                                    "reports",
                                    "sharing",
                                    "showcase",
                                    "sso",
                                    "team_folders",
                                    "team_policies",
                                    "team_profile",
                                    "tfa",
                                    "trusted_teams",
                                    "other"];
        deserializer.deserialize_struct("EventCategory", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for EventCategory {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            EventCategory::AdminAlerting => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "admin_alerting")?;
                s.end()
            }
            EventCategory::Apps => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "apps")?;
                s.end()
            }
            EventCategory::Comments => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "comments")?;
                s.end()
            }
            EventCategory::DataGovernance => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "data_governance")?;
                s.end()
            }
            EventCategory::Devices => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "devices")?;
                s.end()
            }
            EventCategory::Domains => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "domains")?;
                s.end()
            }
            EventCategory::FileOperations => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "file_operations")?;
                s.end()
            }
            EventCategory::FileRequests => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "file_requests")?;
                s.end()
            }
            EventCategory::Groups => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "groups")?;
                s.end()
            }
            EventCategory::Logins => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "logins")?;
                s.end()
            }
            EventCategory::Members => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "members")?;
                s.end()
            }
            EventCategory::Paper => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "paper")?;
                s.end()
            }
            EventCategory::Passwords => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "passwords")?;
                s.end()
            }
            EventCategory::Reports => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "reports")?;
                s.end()
            }
            EventCategory::Sharing => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "sharing")?;
                s.end()
            }
            EventCategory::Showcase => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "showcase")?;
                s.end()
            }
            EventCategory::Sso => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "sso")?;
                s.end()
            }
            EventCategory::TeamFolders => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "team_folders")?;
                s.end()
            }
            EventCategory::TeamPolicies => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "team_policies")?;
                s.end()
            }
            EventCategory::TeamProfile => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "team_profile")?;
                s.end()
            }
            EventCategory::Tfa => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "tfa")?;
                s.end()
            }
            EventCategory::TrustedTeams => {
                // unit
                let mut s = serializer.serialize_struct("EventCategory", 1)?;
                s.serialize_field(".tag", "trusted_teams")?;
                s.end()
            }
            EventCategory::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Additional fields depending on the event type.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum EventDetails {
    AdminAlertingAlertStateChangedDetails(AdminAlertingAlertStateChangedDetails),
    AdminAlertingChangedAlertConfigDetails(AdminAlertingChangedAlertConfigDetails),
    AdminAlertingTriggeredAlertDetails(AdminAlertingTriggeredAlertDetails),
    AppBlockedByPermissionsDetails(AppBlockedByPermissionsDetails),
    AppLinkTeamDetails(AppLinkTeamDetails),
    AppLinkUserDetails(AppLinkUserDetails),
    AppUnlinkTeamDetails(AppUnlinkTeamDetails),
    AppUnlinkUserDetails(AppUnlinkUserDetails),
    IntegrationConnectedDetails(IntegrationConnectedDetails),
    IntegrationDisconnectedDetails(IntegrationDisconnectedDetails),
    FileAddCommentDetails(FileAddCommentDetails),
    FileChangeCommentSubscriptionDetails(FileChangeCommentSubscriptionDetails),
    FileDeleteCommentDetails(FileDeleteCommentDetails),
    FileEditCommentDetails(FileEditCommentDetails),
    FileLikeCommentDetails(FileLikeCommentDetails),
    FileResolveCommentDetails(FileResolveCommentDetails),
    FileUnlikeCommentDetails(FileUnlikeCommentDetails),
    FileUnresolveCommentDetails(FileUnresolveCommentDetails),
    GovernancePolicyAddFoldersDetails(GovernancePolicyAddFoldersDetails),
    GovernancePolicyAddFolderFailedDetails(GovernancePolicyAddFolderFailedDetails),
    GovernancePolicyContentDisposedDetails(GovernancePolicyContentDisposedDetails),
    GovernancePolicyCreateDetails(GovernancePolicyCreateDetails),
    GovernancePolicyDeleteDetails(GovernancePolicyDeleteDetails),
    GovernancePolicyEditDetailsDetails(GovernancePolicyEditDetailsDetails),
    GovernancePolicyEditDurationDetails(GovernancePolicyEditDurationDetails),
    GovernancePolicyExportCreatedDetails(GovernancePolicyExportCreatedDetails),
    GovernancePolicyExportRemovedDetails(GovernancePolicyExportRemovedDetails),
    GovernancePolicyRemoveFoldersDetails(GovernancePolicyRemoveFoldersDetails),
    GovernancePolicyReportCreatedDetails(GovernancePolicyReportCreatedDetails),
    GovernancePolicyZipPartDownloadedDetails(GovernancePolicyZipPartDownloadedDetails),
    LegalHoldsActivateAHoldDetails(LegalHoldsActivateAHoldDetails),
    LegalHoldsAddMembersDetails(LegalHoldsAddMembersDetails),
    LegalHoldsChangeHoldDetailsDetails(LegalHoldsChangeHoldDetailsDetails),
    LegalHoldsChangeHoldNameDetails(LegalHoldsChangeHoldNameDetails),
    LegalHoldsExportAHoldDetails(LegalHoldsExportAHoldDetails),
    LegalHoldsExportCancelledDetails(LegalHoldsExportCancelledDetails),
    LegalHoldsExportDownloadedDetails(LegalHoldsExportDownloadedDetails),
    LegalHoldsExportRemovedDetails(LegalHoldsExportRemovedDetails),
    LegalHoldsReleaseAHoldDetails(LegalHoldsReleaseAHoldDetails),
    LegalHoldsRemoveMembersDetails(LegalHoldsRemoveMembersDetails),
    LegalHoldsReportAHoldDetails(LegalHoldsReportAHoldDetails),
    DeviceChangeIpDesktopDetails(DeviceChangeIpDesktopDetails),
    DeviceChangeIpMobileDetails(DeviceChangeIpMobileDetails),
    DeviceChangeIpWebDetails(DeviceChangeIpWebDetails),
    DeviceDeleteOnUnlinkFailDetails(DeviceDeleteOnUnlinkFailDetails),
    DeviceDeleteOnUnlinkSuccessDetails(DeviceDeleteOnUnlinkSuccessDetails),
    DeviceLinkFailDetails(DeviceLinkFailDetails),
    DeviceLinkSuccessDetails(DeviceLinkSuccessDetails),
    DeviceManagementDisabledDetails(DeviceManagementDisabledDetails),
    DeviceManagementEnabledDetails(DeviceManagementEnabledDetails),
    DeviceSyncBackupStatusChangedDetails(DeviceSyncBackupStatusChangedDetails),
    DeviceUnlinkDetails(DeviceUnlinkDetails),
    DropboxPasswordsExportedDetails(DropboxPasswordsExportedDetails),
    DropboxPasswordsNewDeviceEnrolledDetails(DropboxPasswordsNewDeviceEnrolledDetails),
    EmmRefreshAuthTokenDetails(EmmRefreshAuthTokenDetails),
    AccountCaptureChangeAvailabilityDetails(AccountCaptureChangeAvailabilityDetails),
    AccountCaptureMigrateAccountDetails(AccountCaptureMigrateAccountDetails),
    AccountCaptureNotificationEmailsSentDetails(AccountCaptureNotificationEmailsSentDetails),
    AccountCaptureRelinquishAccountDetails(AccountCaptureRelinquishAccountDetails),
    DisabledDomainInvitesDetails(DisabledDomainInvitesDetails),
    DomainInvitesApproveRequestToJoinTeamDetails(DomainInvitesApproveRequestToJoinTeamDetails),
    DomainInvitesDeclineRequestToJoinTeamDetails(DomainInvitesDeclineRequestToJoinTeamDetails),
    DomainInvitesEmailExistingUsersDetails(DomainInvitesEmailExistingUsersDetails),
    DomainInvitesRequestToJoinTeamDetails(DomainInvitesRequestToJoinTeamDetails),
    DomainInvitesSetInviteNewUserPrefToNoDetails(DomainInvitesSetInviteNewUserPrefToNoDetails),
    DomainInvitesSetInviteNewUserPrefToYesDetails(DomainInvitesSetInviteNewUserPrefToYesDetails),
    DomainVerificationAddDomainFailDetails(DomainVerificationAddDomainFailDetails),
    DomainVerificationAddDomainSuccessDetails(DomainVerificationAddDomainSuccessDetails),
    DomainVerificationRemoveDomainDetails(DomainVerificationRemoveDomainDetails),
    EnabledDomainInvitesDetails(EnabledDomainInvitesDetails),
    ApplyNamingConventionDetails(ApplyNamingConventionDetails),
    CreateFolderDetails(CreateFolderDetails),
    FileAddDetails(FileAddDetails),
    FileCopyDetails(FileCopyDetails),
    FileDeleteDetails(FileDeleteDetails),
    FileDownloadDetails(FileDownloadDetails),
    FileEditDetails(FileEditDetails),
    FileGetCopyReferenceDetails(FileGetCopyReferenceDetails),
    FileLockingLockStatusChangedDetails(FileLockingLockStatusChangedDetails),
    FileMoveDetails(FileMoveDetails),
    FilePermanentlyDeleteDetails(FilePermanentlyDeleteDetails),
    FilePreviewDetails(FilePreviewDetails),
    FileRenameDetails(FileRenameDetails),
    FileRestoreDetails(FileRestoreDetails),
    FileRevertDetails(FileRevertDetails),
    FileRollbackChangesDetails(FileRollbackChangesDetails),
    FileSaveCopyReferenceDetails(FileSaveCopyReferenceDetails),
    FolderOverviewDescriptionChangedDetails(FolderOverviewDescriptionChangedDetails),
    FolderOverviewItemPinnedDetails(FolderOverviewItemPinnedDetails),
    FolderOverviewItemUnpinnedDetails(FolderOverviewItemUnpinnedDetails),
    ObjectLabelAddedDetails(ObjectLabelAddedDetails),
    ObjectLabelRemovedDetails(ObjectLabelRemovedDetails),
    ObjectLabelUpdatedValueDetails(ObjectLabelUpdatedValueDetails),
    OrganizeFolderWithTidyDetails(OrganizeFolderWithTidyDetails),
    RewindFolderDetails(RewindFolderDetails),
    UserTagsAddedDetails(UserTagsAddedDetails),
    UserTagsRemovedDetails(UserTagsRemovedDetails),
    FileRequestChangeDetails(FileRequestChangeDetails),
    FileRequestCloseDetails(FileRequestCloseDetails),
    FileRequestCreateDetails(FileRequestCreateDetails),
    FileRequestDeleteDetails(FileRequestDeleteDetails),
    FileRequestReceiveFileDetails(FileRequestReceiveFileDetails),
    GroupAddExternalIdDetails(GroupAddExternalIdDetails),
    GroupAddMemberDetails(GroupAddMemberDetails),
    GroupChangeExternalIdDetails(GroupChangeExternalIdDetails),
    GroupChangeManagementTypeDetails(GroupChangeManagementTypeDetails),
    GroupChangeMemberRoleDetails(GroupChangeMemberRoleDetails),
    GroupCreateDetails(GroupCreateDetails),
    GroupDeleteDetails(GroupDeleteDetails),
    GroupDescriptionUpdatedDetails(GroupDescriptionUpdatedDetails),
    GroupJoinPolicyUpdatedDetails(GroupJoinPolicyUpdatedDetails),
    GroupMovedDetails(GroupMovedDetails),
    GroupRemoveExternalIdDetails(GroupRemoveExternalIdDetails),
    GroupRemoveMemberDetails(GroupRemoveMemberDetails),
    GroupRenameDetails(GroupRenameDetails),
    AccountLockOrUnlockedDetails(AccountLockOrUnlockedDetails),
    EmmErrorDetails(EmmErrorDetails),
    GuestAdminSignedInViaTrustedTeamsDetails(GuestAdminSignedInViaTrustedTeamsDetails),
    GuestAdminSignedOutViaTrustedTeamsDetails(GuestAdminSignedOutViaTrustedTeamsDetails),
    LoginFailDetails(LoginFailDetails),
    LoginSuccessDetails(LoginSuccessDetails),
    LogoutDetails(LogoutDetails),
    ResellerSupportSessionEndDetails(ResellerSupportSessionEndDetails),
    ResellerSupportSessionStartDetails(ResellerSupportSessionStartDetails),
    SignInAsSessionEndDetails(SignInAsSessionEndDetails),
    SignInAsSessionStartDetails(SignInAsSessionStartDetails),
    SsoErrorDetails(SsoErrorDetails),
    CreateTeamInviteLinkDetails(CreateTeamInviteLinkDetails),
    DeleteTeamInviteLinkDetails(DeleteTeamInviteLinkDetails),
    MemberAddExternalIdDetails(MemberAddExternalIdDetails),
    MemberAddNameDetails(MemberAddNameDetails),
    MemberChangeAdminRoleDetails(MemberChangeAdminRoleDetails),
    MemberChangeEmailDetails(MemberChangeEmailDetails),
    MemberChangeExternalIdDetails(MemberChangeExternalIdDetails),
    MemberChangeMembershipTypeDetails(MemberChangeMembershipTypeDetails),
    MemberChangeNameDetails(MemberChangeNameDetails),
    MemberChangeResellerRoleDetails(MemberChangeResellerRoleDetails),
    MemberChangeStatusDetails(MemberChangeStatusDetails),
    MemberDeleteManualContactsDetails(MemberDeleteManualContactsDetails),
    MemberDeleteProfilePhotoDetails(MemberDeleteProfilePhotoDetails),
    MemberPermanentlyDeleteAccountContentsDetails(MemberPermanentlyDeleteAccountContentsDetails),
    MemberRemoveExternalIdDetails(MemberRemoveExternalIdDetails),
    MemberSetProfilePhotoDetails(MemberSetProfilePhotoDetails),
    MemberSpaceLimitsAddCustomQuotaDetails(MemberSpaceLimitsAddCustomQuotaDetails),
    MemberSpaceLimitsChangeCustomQuotaDetails(MemberSpaceLimitsChangeCustomQuotaDetails),
    MemberSpaceLimitsChangeStatusDetails(MemberSpaceLimitsChangeStatusDetails),
    MemberSpaceLimitsRemoveCustomQuotaDetails(MemberSpaceLimitsRemoveCustomQuotaDetails),
    MemberSuggestDetails(MemberSuggestDetails),
    MemberTransferAccountContentsDetails(MemberTransferAccountContentsDetails),
    PendingSecondaryEmailAddedDetails(PendingSecondaryEmailAddedDetails),
    SecondaryEmailDeletedDetails(SecondaryEmailDeletedDetails),
    SecondaryEmailVerifiedDetails(SecondaryEmailVerifiedDetails),
    SecondaryMailsPolicyChangedDetails(SecondaryMailsPolicyChangedDetails),
    BinderAddPageDetails(BinderAddPageDetails),
    BinderAddSectionDetails(BinderAddSectionDetails),
    BinderRemovePageDetails(BinderRemovePageDetails),
    BinderRemoveSectionDetails(BinderRemoveSectionDetails),
    BinderRenamePageDetails(BinderRenamePageDetails),
    BinderRenameSectionDetails(BinderRenameSectionDetails),
    BinderReorderPageDetails(BinderReorderPageDetails),
    BinderReorderSectionDetails(BinderReorderSectionDetails),
    PaperContentAddMemberDetails(PaperContentAddMemberDetails),
    PaperContentAddToFolderDetails(PaperContentAddToFolderDetails),
    PaperContentArchiveDetails(PaperContentArchiveDetails),
    PaperContentCreateDetails(PaperContentCreateDetails),
    PaperContentPermanentlyDeleteDetails(PaperContentPermanentlyDeleteDetails),
    PaperContentRemoveFromFolderDetails(PaperContentRemoveFromFolderDetails),
    PaperContentRemoveMemberDetails(PaperContentRemoveMemberDetails),
    PaperContentRenameDetails(PaperContentRenameDetails),
    PaperContentRestoreDetails(PaperContentRestoreDetails),
    PaperDocAddCommentDetails(PaperDocAddCommentDetails),
    PaperDocChangeMemberRoleDetails(PaperDocChangeMemberRoleDetails),
    PaperDocChangeSharingPolicyDetails(PaperDocChangeSharingPolicyDetails),
    PaperDocChangeSubscriptionDetails(PaperDocChangeSubscriptionDetails),
    PaperDocDeletedDetails(PaperDocDeletedDetails),
    PaperDocDeleteCommentDetails(PaperDocDeleteCommentDetails),
    PaperDocDownloadDetails(PaperDocDownloadDetails),
    PaperDocEditDetails(PaperDocEditDetails),
    PaperDocEditCommentDetails(PaperDocEditCommentDetails),
    PaperDocFollowedDetails(PaperDocFollowedDetails),
    PaperDocMentionDetails(PaperDocMentionDetails),
    PaperDocOwnershipChangedDetails(PaperDocOwnershipChangedDetails),
    PaperDocRequestAccessDetails(PaperDocRequestAccessDetails),
    PaperDocResolveCommentDetails(PaperDocResolveCommentDetails),
    PaperDocRevertDetails(PaperDocRevertDetails),
    PaperDocSlackShareDetails(PaperDocSlackShareDetails),
    PaperDocTeamInviteDetails(PaperDocTeamInviteDetails),
    PaperDocTrashedDetails(PaperDocTrashedDetails),
    PaperDocUnresolveCommentDetails(PaperDocUnresolveCommentDetails),
    PaperDocUntrashedDetails(PaperDocUntrashedDetails),
    PaperDocViewDetails(PaperDocViewDetails),
    PaperExternalViewAllowDetails(PaperExternalViewAllowDetails),
    PaperExternalViewDefaultTeamDetails(PaperExternalViewDefaultTeamDetails),
    PaperExternalViewForbidDetails(PaperExternalViewForbidDetails),
    PaperFolderChangeSubscriptionDetails(PaperFolderChangeSubscriptionDetails),
    PaperFolderDeletedDetails(PaperFolderDeletedDetails),
    PaperFolderFollowedDetails(PaperFolderFollowedDetails),
    PaperFolderTeamInviteDetails(PaperFolderTeamInviteDetails),
    PaperPublishedLinkChangePermissionDetails(PaperPublishedLinkChangePermissionDetails),
    PaperPublishedLinkCreateDetails(PaperPublishedLinkCreateDetails),
    PaperPublishedLinkDisabledDetails(PaperPublishedLinkDisabledDetails),
    PaperPublishedLinkViewDetails(PaperPublishedLinkViewDetails),
    PasswordChangeDetails(PasswordChangeDetails),
    PasswordResetDetails(PasswordResetDetails),
    PasswordResetAllDetails(PasswordResetAllDetails),
    ClassificationCreateReportDetails(ClassificationCreateReportDetails),
    ClassificationCreateReportFailDetails(ClassificationCreateReportFailDetails),
    EmmCreateExceptionsReportDetails(EmmCreateExceptionsReportDetails),
    EmmCreateUsageReportDetails(EmmCreateUsageReportDetails),
    ExportMembersReportDetails(ExportMembersReportDetails),
    ExportMembersReportFailDetails(ExportMembersReportFailDetails),
    ExternalSharingCreateReportDetails(ExternalSharingCreateReportDetails),
    ExternalSharingReportFailedDetails(ExternalSharingReportFailedDetails),
    NoExpirationLinkGenCreateReportDetails(NoExpirationLinkGenCreateReportDetails),
    NoExpirationLinkGenReportFailedDetails(NoExpirationLinkGenReportFailedDetails),
    NoPasswordLinkGenCreateReportDetails(NoPasswordLinkGenCreateReportDetails),
    NoPasswordLinkGenReportFailedDetails(NoPasswordLinkGenReportFailedDetails),
    NoPasswordLinkViewCreateReportDetails(NoPasswordLinkViewCreateReportDetails),
    NoPasswordLinkViewReportFailedDetails(NoPasswordLinkViewReportFailedDetails),
    OutdatedLinkViewCreateReportDetails(OutdatedLinkViewCreateReportDetails),
    OutdatedLinkViewReportFailedDetails(OutdatedLinkViewReportFailedDetails),
    PaperAdminExportStartDetails(PaperAdminExportStartDetails),
    SmartSyncCreateAdminPrivilegeReportDetails(SmartSyncCreateAdminPrivilegeReportDetails),
    TeamActivityCreateReportDetails(TeamActivityCreateReportDetails),
    TeamActivityCreateReportFailDetails(TeamActivityCreateReportFailDetails),
    CollectionShareDetails(CollectionShareDetails),
    FileTransfersFileAddDetails(FileTransfersFileAddDetails),
    FileTransfersTransferDeleteDetails(FileTransfersTransferDeleteDetails),
    FileTransfersTransferDownloadDetails(FileTransfersTransferDownloadDetails),
    FileTransfersTransferSendDetails(FileTransfersTransferSendDetails),
    FileTransfersTransferViewDetails(FileTransfersTransferViewDetails),
    NoteAclInviteOnlyDetails(NoteAclInviteOnlyDetails),
    NoteAclLinkDetails(NoteAclLinkDetails),
    NoteAclTeamLinkDetails(NoteAclTeamLinkDetails),
    NoteSharedDetails(NoteSharedDetails),
    NoteShareReceiveDetails(NoteShareReceiveDetails),
    OpenNoteSharedDetails(OpenNoteSharedDetails),
    SfAddGroupDetails(SfAddGroupDetails),
    SfAllowNonMembersToViewSharedLinksDetails(SfAllowNonMembersToViewSharedLinksDetails),
    SfExternalInviteWarnDetails(SfExternalInviteWarnDetails),
    SfFbInviteDetails(SfFbInviteDetails),
    SfFbInviteChangeRoleDetails(SfFbInviteChangeRoleDetails),
    SfFbUninviteDetails(SfFbUninviteDetails),
    SfInviteGroupDetails(SfInviteGroupDetails),
    SfTeamGrantAccessDetails(SfTeamGrantAccessDetails),
    SfTeamInviteDetails(SfTeamInviteDetails),
    SfTeamInviteChangeRoleDetails(SfTeamInviteChangeRoleDetails),
    SfTeamJoinDetails(SfTeamJoinDetails),
    SfTeamJoinFromOobLinkDetails(SfTeamJoinFromOobLinkDetails),
    SfTeamUninviteDetails(SfTeamUninviteDetails),
    SharedContentAddInviteesDetails(SharedContentAddInviteesDetails),
    SharedContentAddLinkExpiryDetails(SharedContentAddLinkExpiryDetails),
    SharedContentAddLinkPasswordDetails(SharedContentAddLinkPasswordDetails),
    SharedContentAddMemberDetails(SharedContentAddMemberDetails),
    SharedContentChangeDownloadsPolicyDetails(SharedContentChangeDownloadsPolicyDetails),
    SharedContentChangeInviteeRoleDetails(SharedContentChangeInviteeRoleDetails),
    SharedContentChangeLinkAudienceDetails(SharedContentChangeLinkAudienceDetails),
    SharedContentChangeLinkExpiryDetails(SharedContentChangeLinkExpiryDetails),
    SharedContentChangeLinkPasswordDetails(SharedContentChangeLinkPasswordDetails),
    SharedContentChangeMemberRoleDetails(SharedContentChangeMemberRoleDetails),
    SharedContentChangeViewerInfoPolicyDetails(SharedContentChangeViewerInfoPolicyDetails),
    SharedContentClaimInvitationDetails(SharedContentClaimInvitationDetails),
    SharedContentCopyDetails(SharedContentCopyDetails),
    SharedContentDownloadDetails(SharedContentDownloadDetails),
    SharedContentRelinquishMembershipDetails(SharedContentRelinquishMembershipDetails),
    SharedContentRemoveInviteesDetails(SharedContentRemoveInviteesDetails),
    SharedContentRemoveLinkExpiryDetails(SharedContentRemoveLinkExpiryDetails),
    SharedContentRemoveLinkPasswordDetails(SharedContentRemoveLinkPasswordDetails),
    SharedContentRemoveMemberDetails(SharedContentRemoveMemberDetails),
    SharedContentRequestAccessDetails(SharedContentRequestAccessDetails),
    SharedContentRestoreInviteesDetails(SharedContentRestoreInviteesDetails),
    SharedContentRestoreMemberDetails(SharedContentRestoreMemberDetails),
    SharedContentUnshareDetails(SharedContentUnshareDetails),
    SharedContentViewDetails(SharedContentViewDetails),
    SharedFolderChangeLinkPolicyDetails(SharedFolderChangeLinkPolicyDetails),
    SharedFolderChangeMembersInheritancePolicyDetails(SharedFolderChangeMembersInheritancePolicyDetails),
    SharedFolderChangeMembersManagementPolicyDetails(SharedFolderChangeMembersManagementPolicyDetails),
    SharedFolderChangeMembersPolicyDetails(SharedFolderChangeMembersPolicyDetails),
    SharedFolderCreateDetails(SharedFolderCreateDetails),
    SharedFolderDeclineInvitationDetails(SharedFolderDeclineInvitationDetails),
    SharedFolderMountDetails(SharedFolderMountDetails),
    SharedFolderNestDetails(SharedFolderNestDetails),
    SharedFolderTransferOwnershipDetails(SharedFolderTransferOwnershipDetails),
    SharedFolderUnmountDetails(SharedFolderUnmountDetails),
    SharedLinkAddExpiryDetails(SharedLinkAddExpiryDetails),
    SharedLinkChangeExpiryDetails(SharedLinkChangeExpiryDetails),
    SharedLinkChangeVisibilityDetails(SharedLinkChangeVisibilityDetails),
    SharedLinkCopyDetails(SharedLinkCopyDetails),
    SharedLinkCreateDetails(SharedLinkCreateDetails),
    SharedLinkDisableDetails(SharedLinkDisableDetails),
    SharedLinkDownloadDetails(SharedLinkDownloadDetails),
    SharedLinkRemoveExpiryDetails(SharedLinkRemoveExpiryDetails),
    SharedLinkSettingsAddExpirationDetails(SharedLinkSettingsAddExpirationDetails),
    SharedLinkSettingsAddPasswordDetails(SharedLinkSettingsAddPasswordDetails),
    SharedLinkSettingsAllowDownloadDisabledDetails(SharedLinkSettingsAllowDownloadDisabledDetails),
    SharedLinkSettingsAllowDownloadEnabledDetails(SharedLinkSettingsAllowDownloadEnabledDetails),
    SharedLinkSettingsChangeAudienceDetails(SharedLinkSettingsChangeAudienceDetails),
    SharedLinkSettingsChangeExpirationDetails(SharedLinkSettingsChangeExpirationDetails),
    SharedLinkSettingsChangePasswordDetails(SharedLinkSettingsChangePasswordDetails),
    SharedLinkSettingsRemoveExpirationDetails(SharedLinkSettingsRemoveExpirationDetails),
    SharedLinkSettingsRemovePasswordDetails(SharedLinkSettingsRemovePasswordDetails),
    SharedLinkShareDetails(SharedLinkShareDetails),
    SharedLinkViewDetails(SharedLinkViewDetails),
    SharedNoteOpenedDetails(SharedNoteOpenedDetails),
    ShmodelDisableDownloadsDetails(ShmodelDisableDownloadsDetails),
    ShmodelEnableDownloadsDetails(ShmodelEnableDownloadsDetails),
    ShmodelGroupShareDetails(ShmodelGroupShareDetails),
    ShowcaseAccessGrantedDetails(ShowcaseAccessGrantedDetails),
    ShowcaseAddMemberDetails(ShowcaseAddMemberDetails),
    ShowcaseArchivedDetails(ShowcaseArchivedDetails),
    ShowcaseCreatedDetails(ShowcaseCreatedDetails),
    ShowcaseDeleteCommentDetails(ShowcaseDeleteCommentDetails),
    ShowcaseEditedDetails(ShowcaseEditedDetails),
    ShowcaseEditCommentDetails(ShowcaseEditCommentDetails),
    ShowcaseFileAddedDetails(ShowcaseFileAddedDetails),
    ShowcaseFileDownloadDetails(ShowcaseFileDownloadDetails),
    ShowcaseFileRemovedDetails(ShowcaseFileRemovedDetails),
    ShowcaseFileViewDetails(ShowcaseFileViewDetails),
    ShowcasePermanentlyDeletedDetails(ShowcasePermanentlyDeletedDetails),
    ShowcasePostCommentDetails(ShowcasePostCommentDetails),
    ShowcaseRemoveMemberDetails(ShowcaseRemoveMemberDetails),
    ShowcaseRenamedDetails(ShowcaseRenamedDetails),
    ShowcaseRequestAccessDetails(ShowcaseRequestAccessDetails),
    ShowcaseResolveCommentDetails(ShowcaseResolveCommentDetails),
    ShowcaseRestoredDetails(ShowcaseRestoredDetails),
    ShowcaseTrashedDetails(ShowcaseTrashedDetails),
    ShowcaseTrashedDeprecatedDetails(ShowcaseTrashedDeprecatedDetails),
    ShowcaseUnresolveCommentDetails(ShowcaseUnresolveCommentDetails),
    ShowcaseUntrashedDetails(ShowcaseUntrashedDetails),
    ShowcaseUntrashedDeprecatedDetails(ShowcaseUntrashedDeprecatedDetails),
    ShowcaseViewDetails(ShowcaseViewDetails),
    SsoAddCertDetails(SsoAddCertDetails),
    SsoAddLoginUrlDetails(SsoAddLoginUrlDetails),
    SsoAddLogoutUrlDetails(SsoAddLogoutUrlDetails),
    SsoChangeCertDetails(SsoChangeCertDetails),
    SsoChangeLoginUrlDetails(SsoChangeLoginUrlDetails),
    SsoChangeLogoutUrlDetails(SsoChangeLogoutUrlDetails),
    SsoChangeSamlIdentityModeDetails(SsoChangeSamlIdentityModeDetails),
    SsoRemoveCertDetails(SsoRemoveCertDetails),
    SsoRemoveLoginUrlDetails(SsoRemoveLoginUrlDetails),
    SsoRemoveLogoutUrlDetails(SsoRemoveLogoutUrlDetails),
    TeamFolderChangeStatusDetails(TeamFolderChangeStatusDetails),
    TeamFolderCreateDetails(TeamFolderCreateDetails),
    TeamFolderDowngradeDetails(TeamFolderDowngradeDetails),
    TeamFolderPermanentlyDeleteDetails(TeamFolderPermanentlyDeleteDetails),
    TeamFolderRenameDetails(TeamFolderRenameDetails),
    TeamSelectiveSyncSettingsChangedDetails(TeamSelectiveSyncSettingsChangedDetails),
    AccountCaptureChangePolicyDetails(AccountCaptureChangePolicyDetails),
    AllowDownloadDisabledDetails(AllowDownloadDisabledDetails),
    AllowDownloadEnabledDetails(AllowDownloadEnabledDetails),
    AppPermissionsChangedDetails(AppPermissionsChangedDetails),
    CameraUploadsPolicyChangedDetails(CameraUploadsPolicyChangedDetails),
    ClassificationChangePolicyDetails(ClassificationChangePolicyDetails),
    ComputerBackupPolicyChangedDetails(ComputerBackupPolicyChangedDetails),
    ContentAdministrationPolicyChangedDetails(ContentAdministrationPolicyChangedDetails),
    DataPlacementRestrictionChangePolicyDetails(DataPlacementRestrictionChangePolicyDetails),
    DataPlacementRestrictionSatisfyPolicyDetails(DataPlacementRestrictionSatisfyPolicyDetails),
    DeviceApprovalsAddExceptionDetails(DeviceApprovalsAddExceptionDetails),
    DeviceApprovalsChangeDesktopPolicyDetails(DeviceApprovalsChangeDesktopPolicyDetails),
    DeviceApprovalsChangeMobilePolicyDetails(DeviceApprovalsChangeMobilePolicyDetails),
    DeviceApprovalsChangeOverageActionDetails(DeviceApprovalsChangeOverageActionDetails),
    DeviceApprovalsChangeUnlinkActionDetails(DeviceApprovalsChangeUnlinkActionDetails),
    DeviceApprovalsRemoveExceptionDetails(DeviceApprovalsRemoveExceptionDetails),
    DirectoryRestrictionsAddMembersDetails(DirectoryRestrictionsAddMembersDetails),
    DirectoryRestrictionsRemoveMembersDetails(DirectoryRestrictionsRemoveMembersDetails),
    EmmAddExceptionDetails(EmmAddExceptionDetails),
    EmmChangePolicyDetails(EmmChangePolicyDetails),
    EmmRemoveExceptionDetails(EmmRemoveExceptionDetails),
    ExtendedVersionHistoryChangePolicyDetails(ExtendedVersionHistoryChangePolicyDetails),
    FileCommentsChangePolicyDetails(FileCommentsChangePolicyDetails),
    FileLockingPolicyChangedDetails(FileLockingPolicyChangedDetails),
    FileRequestsChangePolicyDetails(FileRequestsChangePolicyDetails),
    FileRequestsEmailsEnabledDetails(FileRequestsEmailsEnabledDetails),
    FileRequestsEmailsRestrictedToTeamOnlyDetails(FileRequestsEmailsRestrictedToTeamOnlyDetails),
    FileTransfersPolicyChangedDetails(FileTransfersPolicyChangedDetails),
    GoogleSsoChangePolicyDetails(GoogleSsoChangePolicyDetails),
    GroupUserManagementChangePolicyDetails(GroupUserManagementChangePolicyDetails),
    IntegrationPolicyChangedDetails(IntegrationPolicyChangedDetails),
    InviteAcceptanceEmailPolicyChangedDetails(InviteAcceptanceEmailPolicyChangedDetails),
    MemberRequestsChangePolicyDetails(MemberRequestsChangePolicyDetails),
    MemberSendInvitePolicyChangedDetails(MemberSendInvitePolicyChangedDetails),
    MemberSpaceLimitsAddExceptionDetails(MemberSpaceLimitsAddExceptionDetails),
    MemberSpaceLimitsChangeCapsTypePolicyDetails(MemberSpaceLimitsChangeCapsTypePolicyDetails),
    MemberSpaceLimitsChangePolicyDetails(MemberSpaceLimitsChangePolicyDetails),
    MemberSpaceLimitsRemoveExceptionDetails(MemberSpaceLimitsRemoveExceptionDetails),
    MemberSuggestionsChangePolicyDetails(MemberSuggestionsChangePolicyDetails),
    MicrosoftOfficeAddinChangePolicyDetails(MicrosoftOfficeAddinChangePolicyDetails),
    NetworkControlChangePolicyDetails(NetworkControlChangePolicyDetails),
    PaperChangeDeploymentPolicyDetails(PaperChangeDeploymentPolicyDetails),
    PaperChangeMemberLinkPolicyDetails(PaperChangeMemberLinkPolicyDetails),
    PaperChangeMemberPolicyDetails(PaperChangeMemberPolicyDetails),
    PaperChangePolicyDetails(PaperChangePolicyDetails),
    PaperDefaultFolderPolicyChangedDetails(PaperDefaultFolderPolicyChangedDetails),
    PaperDesktopPolicyChangedDetails(PaperDesktopPolicyChangedDetails),
    PaperEnabledUsersGroupAdditionDetails(PaperEnabledUsersGroupAdditionDetails),
    PaperEnabledUsersGroupRemovalDetails(PaperEnabledUsersGroupRemovalDetails),
    PasswordStrengthRequirementsChangePolicyDetails(PasswordStrengthRequirementsChangePolicyDetails),
    PermanentDeleteChangePolicyDetails(PermanentDeleteChangePolicyDetails),
    ResellerSupportChangePolicyDetails(ResellerSupportChangePolicyDetails),
    RewindPolicyChangedDetails(RewindPolicyChangedDetails),
    SendForSignaturePolicyChangedDetails(SendForSignaturePolicyChangedDetails),
    SharingChangeFolderJoinPolicyDetails(SharingChangeFolderJoinPolicyDetails),
    SharingChangeLinkAllowChangeExpirationPolicyDetails(SharingChangeLinkAllowChangeExpirationPolicyDetails),
    SharingChangeLinkDefaultExpirationPolicyDetails(SharingChangeLinkDefaultExpirationPolicyDetails),
    SharingChangeLinkEnforcePasswordPolicyDetails(SharingChangeLinkEnforcePasswordPolicyDetails),
    SharingChangeLinkPolicyDetails(SharingChangeLinkPolicyDetails),
    SharingChangeMemberPolicyDetails(SharingChangeMemberPolicyDetails),
    ShowcaseChangeDownloadPolicyDetails(ShowcaseChangeDownloadPolicyDetails),
    ShowcaseChangeEnabledPolicyDetails(ShowcaseChangeEnabledPolicyDetails),
    ShowcaseChangeExternalSharingPolicyDetails(ShowcaseChangeExternalSharingPolicyDetails),
    SmarterSmartSyncPolicyChangedDetails(SmarterSmartSyncPolicyChangedDetails),
    SmartSyncChangePolicyDetails(SmartSyncChangePolicyDetails),
    SmartSyncNotOptOutDetails(SmartSyncNotOptOutDetails),
    SmartSyncOptOutDetails(SmartSyncOptOutDetails),
    SsoChangePolicyDetails(SsoChangePolicyDetails),
    TeamBrandingPolicyChangedDetails(TeamBrandingPolicyChangedDetails),
    TeamExtensionsPolicyChangedDetails(TeamExtensionsPolicyChangedDetails),
    TeamSelectiveSyncPolicyChangedDetails(TeamSelectiveSyncPolicyChangedDetails),
    TeamSharingWhitelistSubjectsChangedDetails(TeamSharingWhitelistSubjectsChangedDetails),
    TfaAddExceptionDetails(TfaAddExceptionDetails),
    TfaChangePolicyDetails(TfaChangePolicyDetails),
    TfaRemoveExceptionDetails(TfaRemoveExceptionDetails),
    TwoAccountChangePolicyDetails(TwoAccountChangePolicyDetails),
    ViewerInfoPolicyChangedDetails(ViewerInfoPolicyChangedDetails),
    WatermarkingPolicyChangedDetails(WatermarkingPolicyChangedDetails),
    WebSessionsChangeActiveSessionLimitDetails(WebSessionsChangeActiveSessionLimitDetails),
    WebSessionsChangeFixedLengthPolicyDetails(WebSessionsChangeFixedLengthPolicyDetails),
    WebSessionsChangeIdleLengthPolicyDetails(WebSessionsChangeIdleLengthPolicyDetails),
    TeamMergeFromDetails(TeamMergeFromDetails),
    TeamMergeToDetails(TeamMergeToDetails),
    TeamProfileAddBackgroundDetails(TeamProfileAddBackgroundDetails),
    TeamProfileAddLogoDetails(TeamProfileAddLogoDetails),
    TeamProfileChangeBackgroundDetails(TeamProfileChangeBackgroundDetails),
    TeamProfileChangeDefaultLanguageDetails(TeamProfileChangeDefaultLanguageDetails),
    TeamProfileChangeLogoDetails(TeamProfileChangeLogoDetails),
    TeamProfileChangeNameDetails(TeamProfileChangeNameDetails),
    TeamProfileRemoveBackgroundDetails(TeamProfileRemoveBackgroundDetails),
    TeamProfileRemoveLogoDetails(TeamProfileRemoveLogoDetails),
    TfaAddBackupPhoneDetails(TfaAddBackupPhoneDetails),
    TfaAddSecurityKeyDetails(TfaAddSecurityKeyDetails),
    TfaChangeBackupPhoneDetails(TfaChangeBackupPhoneDetails),
    TfaChangeStatusDetails(TfaChangeStatusDetails),
    TfaRemoveBackupPhoneDetails(TfaRemoveBackupPhoneDetails),
    TfaRemoveSecurityKeyDetails(TfaRemoveSecurityKeyDetails),
    TfaResetDetails(TfaResetDetails),
    ChangedEnterpriseAdminRoleDetails(ChangedEnterpriseAdminRoleDetails),
    ChangedEnterpriseConnectedTeamStatusDetails(ChangedEnterpriseConnectedTeamStatusDetails),
    EndedEnterpriseAdminSessionDetails(EndedEnterpriseAdminSessionDetails),
    EndedEnterpriseAdminSessionDeprecatedDetails(EndedEnterpriseAdminSessionDeprecatedDetails),
    EnterpriseSettingsLockingDetails(EnterpriseSettingsLockingDetails),
    GuestAdminChangeStatusDetails(GuestAdminChangeStatusDetails),
    StartedEnterpriseAdminSessionDetails(StartedEnterpriseAdminSessionDetails),
    TeamMergeRequestAcceptedDetails(TeamMergeRequestAcceptedDetails),
    TeamMergeRequestAcceptedShownToPrimaryTeamDetails(TeamMergeRequestAcceptedShownToPrimaryTeamDetails),
    TeamMergeRequestAcceptedShownToSecondaryTeamDetails(TeamMergeRequestAcceptedShownToSecondaryTeamDetails),
    TeamMergeRequestAutoCanceledDetails(TeamMergeRequestAutoCanceledDetails),
    TeamMergeRequestCanceledDetails(TeamMergeRequestCanceledDetails),
    TeamMergeRequestCanceledShownToPrimaryTeamDetails(TeamMergeRequestCanceledShownToPrimaryTeamDetails),
    TeamMergeRequestCanceledShownToSecondaryTeamDetails(TeamMergeRequestCanceledShownToSecondaryTeamDetails),
    TeamMergeRequestExpiredDetails(TeamMergeRequestExpiredDetails),
    TeamMergeRequestExpiredShownToPrimaryTeamDetails(TeamMergeRequestExpiredShownToPrimaryTeamDetails),
    TeamMergeRequestExpiredShownToSecondaryTeamDetails(TeamMergeRequestExpiredShownToSecondaryTeamDetails),
    TeamMergeRequestRejectedShownToPrimaryTeamDetails(TeamMergeRequestRejectedShownToPrimaryTeamDetails),
    TeamMergeRequestRejectedShownToSecondaryTeamDetails(TeamMergeRequestRejectedShownToSecondaryTeamDetails),
    TeamMergeRequestReminderDetails(TeamMergeRequestReminderDetails),
    TeamMergeRequestReminderShownToPrimaryTeamDetails(TeamMergeRequestReminderShownToPrimaryTeamDetails),
    TeamMergeRequestReminderShownToSecondaryTeamDetails(TeamMergeRequestReminderShownToSecondaryTeamDetails),
    TeamMergeRequestRevokedDetails(TeamMergeRequestRevokedDetails),
    TeamMergeRequestSentShownToPrimaryTeamDetails(TeamMergeRequestSentShownToPrimaryTeamDetails),
    TeamMergeRequestSentShownToSecondaryTeamDetails(TeamMergeRequestSentShownToSecondaryTeamDetails),
    /// Hints that this event was returned with missing details due to an internal error.
    MissingDetails(MissingDetails),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for EventDetails {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = EventDetails;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EventDetails structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "admin_alerting_alert_state_changed_details" => EventDetails::AdminAlertingAlertStateChangedDetails(AdminAlertingAlertStateChangedDetails::internal_deserialize(&mut map)?),
                    "admin_alerting_changed_alert_config_details" => EventDetails::AdminAlertingChangedAlertConfigDetails(AdminAlertingChangedAlertConfigDetails::internal_deserialize(&mut map)?),
                    "admin_alerting_triggered_alert_details" => EventDetails::AdminAlertingTriggeredAlertDetails(AdminAlertingTriggeredAlertDetails::internal_deserialize(&mut map)?),
                    "app_blocked_by_permissions_details" => EventDetails::AppBlockedByPermissionsDetails(AppBlockedByPermissionsDetails::internal_deserialize(&mut map)?),
                    "app_link_team_details" => EventDetails::AppLinkTeamDetails(AppLinkTeamDetails::internal_deserialize(&mut map)?),
                    "app_link_user_details" => EventDetails::AppLinkUserDetails(AppLinkUserDetails::internal_deserialize(&mut map)?),
                    "app_unlink_team_details" => EventDetails::AppUnlinkTeamDetails(AppUnlinkTeamDetails::internal_deserialize(&mut map)?),
                    "app_unlink_user_details" => EventDetails::AppUnlinkUserDetails(AppUnlinkUserDetails::internal_deserialize(&mut map)?),
                    "integration_connected_details" => EventDetails::IntegrationConnectedDetails(IntegrationConnectedDetails::internal_deserialize(&mut map)?),
                    "integration_disconnected_details" => EventDetails::IntegrationDisconnectedDetails(IntegrationDisconnectedDetails::internal_deserialize(&mut map)?),
                    "file_add_comment_details" => EventDetails::FileAddCommentDetails(FileAddCommentDetails::internal_deserialize(&mut map)?),
                    "file_change_comment_subscription_details" => EventDetails::FileChangeCommentSubscriptionDetails(FileChangeCommentSubscriptionDetails::internal_deserialize(&mut map)?),
                    "file_delete_comment_details" => EventDetails::FileDeleteCommentDetails(FileDeleteCommentDetails::internal_deserialize(&mut map)?),
                    "file_edit_comment_details" => EventDetails::FileEditCommentDetails(FileEditCommentDetails::internal_deserialize(&mut map)?),
                    "file_like_comment_details" => EventDetails::FileLikeCommentDetails(FileLikeCommentDetails::internal_deserialize(&mut map)?),
                    "file_resolve_comment_details" => EventDetails::FileResolveCommentDetails(FileResolveCommentDetails::internal_deserialize(&mut map)?),
                    "file_unlike_comment_details" => EventDetails::FileUnlikeCommentDetails(FileUnlikeCommentDetails::internal_deserialize(&mut map)?),
                    "file_unresolve_comment_details" => EventDetails::FileUnresolveCommentDetails(FileUnresolveCommentDetails::internal_deserialize(&mut map)?),
                    "governance_policy_add_folders_details" => EventDetails::GovernancePolicyAddFoldersDetails(GovernancePolicyAddFoldersDetails::internal_deserialize(&mut map)?),
                    "governance_policy_add_folder_failed_details" => EventDetails::GovernancePolicyAddFolderFailedDetails(GovernancePolicyAddFolderFailedDetails::internal_deserialize(&mut map)?),
                    "governance_policy_content_disposed_details" => EventDetails::GovernancePolicyContentDisposedDetails(GovernancePolicyContentDisposedDetails::internal_deserialize(&mut map)?),
                    "governance_policy_create_details" => EventDetails::GovernancePolicyCreateDetails(GovernancePolicyCreateDetails::internal_deserialize(&mut map)?),
                    "governance_policy_delete_details" => EventDetails::GovernancePolicyDeleteDetails(GovernancePolicyDeleteDetails::internal_deserialize(&mut map)?),
                    "governance_policy_edit_details_details" => EventDetails::GovernancePolicyEditDetailsDetails(GovernancePolicyEditDetailsDetails::internal_deserialize(&mut map)?),
                    "governance_policy_edit_duration_details" => EventDetails::GovernancePolicyEditDurationDetails(GovernancePolicyEditDurationDetails::internal_deserialize(&mut map)?),
                    "governance_policy_export_created_details" => EventDetails::GovernancePolicyExportCreatedDetails(GovernancePolicyExportCreatedDetails::internal_deserialize(&mut map)?),
                    "governance_policy_export_removed_details" => EventDetails::GovernancePolicyExportRemovedDetails(GovernancePolicyExportRemovedDetails::internal_deserialize(&mut map)?),
                    "governance_policy_remove_folders_details" => EventDetails::GovernancePolicyRemoveFoldersDetails(GovernancePolicyRemoveFoldersDetails::internal_deserialize(&mut map)?),
                    "governance_policy_report_created_details" => EventDetails::GovernancePolicyReportCreatedDetails(GovernancePolicyReportCreatedDetails::internal_deserialize(&mut map)?),
                    "governance_policy_zip_part_downloaded_details" => EventDetails::GovernancePolicyZipPartDownloadedDetails(GovernancePolicyZipPartDownloadedDetails::internal_deserialize(&mut map)?),
                    "legal_holds_activate_a_hold_details" => EventDetails::LegalHoldsActivateAHoldDetails(LegalHoldsActivateAHoldDetails::internal_deserialize(&mut map)?),
                    "legal_holds_add_members_details" => EventDetails::LegalHoldsAddMembersDetails(LegalHoldsAddMembersDetails::internal_deserialize(&mut map)?),
                    "legal_holds_change_hold_details_details" => EventDetails::LegalHoldsChangeHoldDetailsDetails(LegalHoldsChangeHoldDetailsDetails::internal_deserialize(&mut map)?),
                    "legal_holds_change_hold_name_details" => EventDetails::LegalHoldsChangeHoldNameDetails(LegalHoldsChangeHoldNameDetails::internal_deserialize(&mut map)?),
                    "legal_holds_export_a_hold_details" => EventDetails::LegalHoldsExportAHoldDetails(LegalHoldsExportAHoldDetails::internal_deserialize(&mut map)?),
                    "legal_holds_export_cancelled_details" => EventDetails::LegalHoldsExportCancelledDetails(LegalHoldsExportCancelledDetails::internal_deserialize(&mut map)?),
                    "legal_holds_export_downloaded_details" => EventDetails::LegalHoldsExportDownloadedDetails(LegalHoldsExportDownloadedDetails::internal_deserialize(&mut map)?),
                    "legal_holds_export_removed_details" => EventDetails::LegalHoldsExportRemovedDetails(LegalHoldsExportRemovedDetails::internal_deserialize(&mut map)?),
                    "legal_holds_release_a_hold_details" => EventDetails::LegalHoldsReleaseAHoldDetails(LegalHoldsReleaseAHoldDetails::internal_deserialize(&mut map)?),
                    "legal_holds_remove_members_details" => EventDetails::LegalHoldsRemoveMembersDetails(LegalHoldsRemoveMembersDetails::internal_deserialize(&mut map)?),
                    "legal_holds_report_a_hold_details" => EventDetails::LegalHoldsReportAHoldDetails(LegalHoldsReportAHoldDetails::internal_deserialize(&mut map)?),
                    "device_change_ip_desktop_details" => EventDetails::DeviceChangeIpDesktopDetails(DeviceChangeIpDesktopDetails::internal_deserialize(&mut map)?),
                    "device_change_ip_mobile_details" => EventDetails::DeviceChangeIpMobileDetails(DeviceChangeIpMobileDetails::internal_deserialize(&mut map)?),
                    "device_change_ip_web_details" => EventDetails::DeviceChangeIpWebDetails(DeviceChangeIpWebDetails::internal_deserialize(&mut map)?),
                    "device_delete_on_unlink_fail_details" => EventDetails::DeviceDeleteOnUnlinkFailDetails(DeviceDeleteOnUnlinkFailDetails::internal_deserialize(&mut map)?),
                    "device_delete_on_unlink_success_details" => EventDetails::DeviceDeleteOnUnlinkSuccessDetails(DeviceDeleteOnUnlinkSuccessDetails::internal_deserialize(&mut map)?),
                    "device_link_fail_details" => EventDetails::DeviceLinkFailDetails(DeviceLinkFailDetails::internal_deserialize(&mut map)?),
                    "device_link_success_details" => EventDetails::DeviceLinkSuccessDetails(DeviceLinkSuccessDetails::internal_deserialize(&mut map)?),
                    "device_management_disabled_details" => EventDetails::DeviceManagementDisabledDetails(DeviceManagementDisabledDetails::internal_deserialize(&mut map)?),
                    "device_management_enabled_details" => EventDetails::DeviceManagementEnabledDetails(DeviceManagementEnabledDetails::internal_deserialize(&mut map)?),
                    "device_sync_backup_status_changed_details" => EventDetails::DeviceSyncBackupStatusChangedDetails(DeviceSyncBackupStatusChangedDetails::internal_deserialize(&mut map)?),
                    "device_unlink_details" => EventDetails::DeviceUnlinkDetails(DeviceUnlinkDetails::internal_deserialize(&mut map)?),
                    "dropbox_passwords_exported_details" => EventDetails::DropboxPasswordsExportedDetails(DropboxPasswordsExportedDetails::internal_deserialize(&mut map)?),
                    "dropbox_passwords_new_device_enrolled_details" => EventDetails::DropboxPasswordsNewDeviceEnrolledDetails(DropboxPasswordsNewDeviceEnrolledDetails::internal_deserialize(&mut map)?),
                    "emm_refresh_auth_token_details" => EventDetails::EmmRefreshAuthTokenDetails(EmmRefreshAuthTokenDetails::internal_deserialize(&mut map)?),
                    "account_capture_change_availability_details" => EventDetails::AccountCaptureChangeAvailabilityDetails(AccountCaptureChangeAvailabilityDetails::internal_deserialize(&mut map)?),
                    "account_capture_migrate_account_details" => EventDetails::AccountCaptureMigrateAccountDetails(AccountCaptureMigrateAccountDetails::internal_deserialize(&mut map)?),
                    "account_capture_notification_emails_sent_details" => EventDetails::AccountCaptureNotificationEmailsSentDetails(AccountCaptureNotificationEmailsSentDetails::internal_deserialize(&mut map)?),
                    "account_capture_relinquish_account_details" => EventDetails::AccountCaptureRelinquishAccountDetails(AccountCaptureRelinquishAccountDetails::internal_deserialize(&mut map)?),
                    "disabled_domain_invites_details" => EventDetails::DisabledDomainInvitesDetails(DisabledDomainInvitesDetails::internal_deserialize(&mut map)?),
                    "domain_invites_approve_request_to_join_team_details" => EventDetails::DomainInvitesApproveRequestToJoinTeamDetails(DomainInvitesApproveRequestToJoinTeamDetails::internal_deserialize(&mut map)?),
                    "domain_invites_decline_request_to_join_team_details" => EventDetails::DomainInvitesDeclineRequestToJoinTeamDetails(DomainInvitesDeclineRequestToJoinTeamDetails::internal_deserialize(&mut map)?),
                    "domain_invites_email_existing_users_details" => EventDetails::DomainInvitesEmailExistingUsersDetails(DomainInvitesEmailExistingUsersDetails::internal_deserialize(&mut map)?),
                    "domain_invites_request_to_join_team_details" => EventDetails::DomainInvitesRequestToJoinTeamDetails(DomainInvitesRequestToJoinTeamDetails::internal_deserialize(&mut map)?),
                    "domain_invites_set_invite_new_user_pref_to_no_details" => EventDetails::DomainInvitesSetInviteNewUserPrefToNoDetails(DomainInvitesSetInviteNewUserPrefToNoDetails::internal_deserialize(&mut map)?),
                    "domain_invites_set_invite_new_user_pref_to_yes_details" => EventDetails::DomainInvitesSetInviteNewUserPrefToYesDetails(DomainInvitesSetInviteNewUserPrefToYesDetails::internal_deserialize(&mut map)?),
                    "domain_verification_add_domain_fail_details" => EventDetails::DomainVerificationAddDomainFailDetails(DomainVerificationAddDomainFailDetails::internal_deserialize(&mut map)?),
                    "domain_verification_add_domain_success_details" => EventDetails::DomainVerificationAddDomainSuccessDetails(DomainVerificationAddDomainSuccessDetails::internal_deserialize(&mut map)?),
                    "domain_verification_remove_domain_details" => EventDetails::DomainVerificationRemoveDomainDetails(DomainVerificationRemoveDomainDetails::internal_deserialize(&mut map)?),
                    "enabled_domain_invites_details" => EventDetails::EnabledDomainInvitesDetails(EnabledDomainInvitesDetails::internal_deserialize(&mut map)?),
                    "apply_naming_convention_details" => EventDetails::ApplyNamingConventionDetails(ApplyNamingConventionDetails::internal_deserialize(&mut map)?),
                    "create_folder_details" => EventDetails::CreateFolderDetails(CreateFolderDetails::internal_deserialize(&mut map)?),
                    "file_add_details" => EventDetails::FileAddDetails(FileAddDetails::internal_deserialize(&mut map)?),
                    "file_copy_details" => EventDetails::FileCopyDetails(FileCopyDetails::internal_deserialize(&mut map)?),
                    "file_delete_details" => EventDetails::FileDeleteDetails(FileDeleteDetails::internal_deserialize(&mut map)?),
                    "file_download_details" => EventDetails::FileDownloadDetails(FileDownloadDetails::internal_deserialize(&mut map)?),
                    "file_edit_details" => EventDetails::FileEditDetails(FileEditDetails::internal_deserialize(&mut map)?),
                    "file_get_copy_reference_details" => EventDetails::FileGetCopyReferenceDetails(FileGetCopyReferenceDetails::internal_deserialize(&mut map)?),
                    "file_locking_lock_status_changed_details" => EventDetails::FileLockingLockStatusChangedDetails(FileLockingLockStatusChangedDetails::internal_deserialize(&mut map)?),
                    "file_move_details" => EventDetails::FileMoveDetails(FileMoveDetails::internal_deserialize(&mut map)?),
                    "file_permanently_delete_details" => EventDetails::FilePermanentlyDeleteDetails(FilePermanentlyDeleteDetails::internal_deserialize(&mut map)?),
                    "file_preview_details" => EventDetails::FilePreviewDetails(FilePreviewDetails::internal_deserialize(&mut map)?),
                    "file_rename_details" => EventDetails::FileRenameDetails(FileRenameDetails::internal_deserialize(&mut map)?),
                    "file_restore_details" => EventDetails::FileRestoreDetails(FileRestoreDetails::internal_deserialize(&mut map)?),
                    "file_revert_details" => EventDetails::FileRevertDetails(FileRevertDetails::internal_deserialize(&mut map)?),
                    "file_rollback_changes_details" => EventDetails::FileRollbackChangesDetails(FileRollbackChangesDetails::internal_deserialize(&mut map)?),
                    "file_save_copy_reference_details" => EventDetails::FileSaveCopyReferenceDetails(FileSaveCopyReferenceDetails::internal_deserialize(&mut map)?),
                    "folder_overview_description_changed_details" => EventDetails::FolderOverviewDescriptionChangedDetails(FolderOverviewDescriptionChangedDetails::internal_deserialize(&mut map)?),
                    "folder_overview_item_pinned_details" => EventDetails::FolderOverviewItemPinnedDetails(FolderOverviewItemPinnedDetails::internal_deserialize(&mut map)?),
                    "folder_overview_item_unpinned_details" => EventDetails::FolderOverviewItemUnpinnedDetails(FolderOverviewItemUnpinnedDetails::internal_deserialize(&mut map)?),
                    "object_label_added_details" => EventDetails::ObjectLabelAddedDetails(ObjectLabelAddedDetails::internal_deserialize(&mut map)?),
                    "object_label_removed_details" => EventDetails::ObjectLabelRemovedDetails(ObjectLabelRemovedDetails::internal_deserialize(&mut map)?),
                    "object_label_updated_value_details" => EventDetails::ObjectLabelUpdatedValueDetails(ObjectLabelUpdatedValueDetails::internal_deserialize(&mut map)?),
                    "organize_folder_with_tidy_details" => EventDetails::OrganizeFolderWithTidyDetails(OrganizeFolderWithTidyDetails::internal_deserialize(&mut map)?),
                    "rewind_folder_details" => EventDetails::RewindFolderDetails(RewindFolderDetails::internal_deserialize(&mut map)?),
                    "user_tags_added_details" => EventDetails::UserTagsAddedDetails(UserTagsAddedDetails::internal_deserialize(&mut map)?),
                    "user_tags_removed_details" => EventDetails::UserTagsRemovedDetails(UserTagsRemovedDetails::internal_deserialize(&mut map)?),
                    "file_request_change_details" => EventDetails::FileRequestChangeDetails(FileRequestChangeDetails::internal_deserialize(&mut map)?),
                    "file_request_close_details" => EventDetails::FileRequestCloseDetails(FileRequestCloseDetails::internal_deserialize(&mut map)?),
                    "file_request_create_details" => EventDetails::FileRequestCreateDetails(FileRequestCreateDetails::internal_deserialize(&mut map)?),
                    "file_request_delete_details" => EventDetails::FileRequestDeleteDetails(FileRequestDeleteDetails::internal_deserialize(&mut map)?),
                    "file_request_receive_file_details" => EventDetails::FileRequestReceiveFileDetails(FileRequestReceiveFileDetails::internal_deserialize(&mut map)?),
                    "group_add_external_id_details" => EventDetails::GroupAddExternalIdDetails(GroupAddExternalIdDetails::internal_deserialize(&mut map)?),
                    "group_add_member_details" => EventDetails::GroupAddMemberDetails(GroupAddMemberDetails::internal_deserialize(&mut map)?),
                    "group_change_external_id_details" => EventDetails::GroupChangeExternalIdDetails(GroupChangeExternalIdDetails::internal_deserialize(&mut map)?),
                    "group_change_management_type_details" => EventDetails::GroupChangeManagementTypeDetails(GroupChangeManagementTypeDetails::internal_deserialize(&mut map)?),
                    "group_change_member_role_details" => EventDetails::GroupChangeMemberRoleDetails(GroupChangeMemberRoleDetails::internal_deserialize(&mut map)?),
                    "group_create_details" => EventDetails::GroupCreateDetails(GroupCreateDetails::internal_deserialize(&mut map)?),
                    "group_delete_details" => EventDetails::GroupDeleteDetails(GroupDeleteDetails::internal_deserialize(&mut map)?),
                    "group_description_updated_details" => EventDetails::GroupDescriptionUpdatedDetails(GroupDescriptionUpdatedDetails::internal_deserialize(&mut map)?),
                    "group_join_policy_updated_details" => EventDetails::GroupJoinPolicyUpdatedDetails(GroupJoinPolicyUpdatedDetails::internal_deserialize(&mut map)?),
                    "group_moved_details" => EventDetails::GroupMovedDetails(GroupMovedDetails::internal_deserialize(&mut map)?),
                    "group_remove_external_id_details" => EventDetails::GroupRemoveExternalIdDetails(GroupRemoveExternalIdDetails::internal_deserialize(&mut map)?),
                    "group_remove_member_details" => EventDetails::GroupRemoveMemberDetails(GroupRemoveMemberDetails::internal_deserialize(&mut map)?),
                    "group_rename_details" => EventDetails::GroupRenameDetails(GroupRenameDetails::internal_deserialize(&mut map)?),
                    "account_lock_or_unlocked_details" => EventDetails::AccountLockOrUnlockedDetails(AccountLockOrUnlockedDetails::internal_deserialize(&mut map)?),
                    "emm_error_details" => EventDetails::EmmErrorDetails(EmmErrorDetails::internal_deserialize(&mut map)?),
                    "guest_admin_signed_in_via_trusted_teams_details" => EventDetails::GuestAdminSignedInViaTrustedTeamsDetails(GuestAdminSignedInViaTrustedTeamsDetails::internal_deserialize(&mut map)?),
                    "guest_admin_signed_out_via_trusted_teams_details" => EventDetails::GuestAdminSignedOutViaTrustedTeamsDetails(GuestAdminSignedOutViaTrustedTeamsDetails::internal_deserialize(&mut map)?),
                    "login_fail_details" => EventDetails::LoginFailDetails(LoginFailDetails::internal_deserialize(&mut map)?),
                    "login_success_details" => EventDetails::LoginSuccessDetails(LoginSuccessDetails::internal_deserialize(&mut map)?),
                    "logout_details" => EventDetails::LogoutDetails(LogoutDetails::internal_deserialize(&mut map)?),
                    "reseller_support_session_end_details" => EventDetails::ResellerSupportSessionEndDetails(ResellerSupportSessionEndDetails::internal_deserialize(&mut map)?),
                    "reseller_support_session_start_details" => EventDetails::ResellerSupportSessionStartDetails(ResellerSupportSessionStartDetails::internal_deserialize(&mut map)?),
                    "sign_in_as_session_end_details" => EventDetails::SignInAsSessionEndDetails(SignInAsSessionEndDetails::internal_deserialize(&mut map)?),
                    "sign_in_as_session_start_details" => EventDetails::SignInAsSessionStartDetails(SignInAsSessionStartDetails::internal_deserialize(&mut map)?),
                    "sso_error_details" => EventDetails::SsoErrorDetails(SsoErrorDetails::internal_deserialize(&mut map)?),
                    "create_team_invite_link_details" => EventDetails::CreateTeamInviteLinkDetails(CreateTeamInviteLinkDetails::internal_deserialize(&mut map)?),
                    "delete_team_invite_link_details" => EventDetails::DeleteTeamInviteLinkDetails(DeleteTeamInviteLinkDetails::internal_deserialize(&mut map)?),
                    "member_add_external_id_details" => EventDetails::MemberAddExternalIdDetails(MemberAddExternalIdDetails::internal_deserialize(&mut map)?),
                    "member_add_name_details" => EventDetails::MemberAddNameDetails(MemberAddNameDetails::internal_deserialize(&mut map)?),
                    "member_change_admin_role_details" => EventDetails::MemberChangeAdminRoleDetails(MemberChangeAdminRoleDetails::internal_deserialize(&mut map)?),
                    "member_change_email_details" => EventDetails::MemberChangeEmailDetails(MemberChangeEmailDetails::internal_deserialize(&mut map)?),
                    "member_change_external_id_details" => EventDetails::MemberChangeExternalIdDetails(MemberChangeExternalIdDetails::internal_deserialize(&mut map)?),
                    "member_change_membership_type_details" => EventDetails::MemberChangeMembershipTypeDetails(MemberChangeMembershipTypeDetails::internal_deserialize(&mut map)?),
                    "member_change_name_details" => EventDetails::MemberChangeNameDetails(MemberChangeNameDetails::internal_deserialize(&mut map)?),
                    "member_change_reseller_role_details" => EventDetails::MemberChangeResellerRoleDetails(MemberChangeResellerRoleDetails::internal_deserialize(&mut map)?),
                    "member_change_status_details" => EventDetails::MemberChangeStatusDetails(MemberChangeStatusDetails::internal_deserialize(&mut map)?),
                    "member_delete_manual_contacts_details" => EventDetails::MemberDeleteManualContactsDetails(MemberDeleteManualContactsDetails::internal_deserialize(&mut map)?),
                    "member_delete_profile_photo_details" => EventDetails::MemberDeleteProfilePhotoDetails(MemberDeleteProfilePhotoDetails::internal_deserialize(&mut map)?),
                    "member_permanently_delete_account_contents_details" => EventDetails::MemberPermanentlyDeleteAccountContentsDetails(MemberPermanentlyDeleteAccountContentsDetails::internal_deserialize(&mut map)?),
                    "member_remove_external_id_details" => EventDetails::MemberRemoveExternalIdDetails(MemberRemoveExternalIdDetails::internal_deserialize(&mut map)?),
                    "member_set_profile_photo_details" => EventDetails::MemberSetProfilePhotoDetails(MemberSetProfilePhotoDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_add_custom_quota_details" => EventDetails::MemberSpaceLimitsAddCustomQuotaDetails(MemberSpaceLimitsAddCustomQuotaDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_change_custom_quota_details" => EventDetails::MemberSpaceLimitsChangeCustomQuotaDetails(MemberSpaceLimitsChangeCustomQuotaDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_change_status_details" => EventDetails::MemberSpaceLimitsChangeStatusDetails(MemberSpaceLimitsChangeStatusDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_remove_custom_quota_details" => EventDetails::MemberSpaceLimitsRemoveCustomQuotaDetails(MemberSpaceLimitsRemoveCustomQuotaDetails::internal_deserialize(&mut map)?),
                    "member_suggest_details" => EventDetails::MemberSuggestDetails(MemberSuggestDetails::internal_deserialize(&mut map)?),
                    "member_transfer_account_contents_details" => EventDetails::MemberTransferAccountContentsDetails(MemberTransferAccountContentsDetails::internal_deserialize(&mut map)?),
                    "pending_secondary_email_added_details" => EventDetails::PendingSecondaryEmailAddedDetails(PendingSecondaryEmailAddedDetails::internal_deserialize(&mut map)?),
                    "secondary_email_deleted_details" => EventDetails::SecondaryEmailDeletedDetails(SecondaryEmailDeletedDetails::internal_deserialize(&mut map)?),
                    "secondary_email_verified_details" => EventDetails::SecondaryEmailVerifiedDetails(SecondaryEmailVerifiedDetails::internal_deserialize(&mut map)?),
                    "secondary_mails_policy_changed_details" => EventDetails::SecondaryMailsPolicyChangedDetails(SecondaryMailsPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "binder_add_page_details" => EventDetails::BinderAddPageDetails(BinderAddPageDetails::internal_deserialize(&mut map)?),
                    "binder_add_section_details" => EventDetails::BinderAddSectionDetails(BinderAddSectionDetails::internal_deserialize(&mut map)?),
                    "binder_remove_page_details" => EventDetails::BinderRemovePageDetails(BinderRemovePageDetails::internal_deserialize(&mut map)?),
                    "binder_remove_section_details" => EventDetails::BinderRemoveSectionDetails(BinderRemoveSectionDetails::internal_deserialize(&mut map)?),
                    "binder_rename_page_details" => EventDetails::BinderRenamePageDetails(BinderRenamePageDetails::internal_deserialize(&mut map)?),
                    "binder_rename_section_details" => EventDetails::BinderRenameSectionDetails(BinderRenameSectionDetails::internal_deserialize(&mut map)?),
                    "binder_reorder_page_details" => EventDetails::BinderReorderPageDetails(BinderReorderPageDetails::internal_deserialize(&mut map)?),
                    "binder_reorder_section_details" => EventDetails::BinderReorderSectionDetails(BinderReorderSectionDetails::internal_deserialize(&mut map)?),
                    "paper_content_add_member_details" => EventDetails::PaperContentAddMemberDetails(PaperContentAddMemberDetails::internal_deserialize(&mut map)?),
                    "paper_content_add_to_folder_details" => EventDetails::PaperContentAddToFolderDetails(PaperContentAddToFolderDetails::internal_deserialize(&mut map)?),
                    "paper_content_archive_details" => EventDetails::PaperContentArchiveDetails(PaperContentArchiveDetails::internal_deserialize(&mut map)?),
                    "paper_content_create_details" => EventDetails::PaperContentCreateDetails(PaperContentCreateDetails::internal_deserialize(&mut map)?),
                    "paper_content_permanently_delete_details" => EventDetails::PaperContentPermanentlyDeleteDetails(PaperContentPermanentlyDeleteDetails::internal_deserialize(&mut map)?),
                    "paper_content_remove_from_folder_details" => EventDetails::PaperContentRemoveFromFolderDetails(PaperContentRemoveFromFolderDetails::internal_deserialize(&mut map)?),
                    "paper_content_remove_member_details" => EventDetails::PaperContentRemoveMemberDetails(PaperContentRemoveMemberDetails::internal_deserialize(&mut map)?),
                    "paper_content_rename_details" => EventDetails::PaperContentRenameDetails(PaperContentRenameDetails::internal_deserialize(&mut map)?),
                    "paper_content_restore_details" => EventDetails::PaperContentRestoreDetails(PaperContentRestoreDetails::internal_deserialize(&mut map)?),
                    "paper_doc_add_comment_details" => EventDetails::PaperDocAddCommentDetails(PaperDocAddCommentDetails::internal_deserialize(&mut map)?),
                    "paper_doc_change_member_role_details" => EventDetails::PaperDocChangeMemberRoleDetails(PaperDocChangeMemberRoleDetails::internal_deserialize(&mut map)?),
                    "paper_doc_change_sharing_policy_details" => EventDetails::PaperDocChangeSharingPolicyDetails(PaperDocChangeSharingPolicyDetails::internal_deserialize(&mut map)?),
                    "paper_doc_change_subscription_details" => EventDetails::PaperDocChangeSubscriptionDetails(PaperDocChangeSubscriptionDetails::internal_deserialize(&mut map)?),
                    "paper_doc_deleted_details" => EventDetails::PaperDocDeletedDetails(PaperDocDeletedDetails::internal_deserialize(&mut map)?),
                    "paper_doc_delete_comment_details" => EventDetails::PaperDocDeleteCommentDetails(PaperDocDeleteCommentDetails::internal_deserialize(&mut map)?),
                    "paper_doc_download_details" => EventDetails::PaperDocDownloadDetails(PaperDocDownloadDetails::internal_deserialize(&mut map)?),
                    "paper_doc_edit_details" => EventDetails::PaperDocEditDetails(PaperDocEditDetails::internal_deserialize(&mut map)?),
                    "paper_doc_edit_comment_details" => EventDetails::PaperDocEditCommentDetails(PaperDocEditCommentDetails::internal_deserialize(&mut map)?),
                    "paper_doc_followed_details" => EventDetails::PaperDocFollowedDetails(PaperDocFollowedDetails::internal_deserialize(&mut map)?),
                    "paper_doc_mention_details" => EventDetails::PaperDocMentionDetails(PaperDocMentionDetails::internal_deserialize(&mut map)?),
                    "paper_doc_ownership_changed_details" => EventDetails::PaperDocOwnershipChangedDetails(PaperDocOwnershipChangedDetails::internal_deserialize(&mut map)?),
                    "paper_doc_request_access_details" => EventDetails::PaperDocRequestAccessDetails(PaperDocRequestAccessDetails::internal_deserialize(&mut map)?),
                    "paper_doc_resolve_comment_details" => EventDetails::PaperDocResolveCommentDetails(PaperDocResolveCommentDetails::internal_deserialize(&mut map)?),
                    "paper_doc_revert_details" => EventDetails::PaperDocRevertDetails(PaperDocRevertDetails::internal_deserialize(&mut map)?),
                    "paper_doc_slack_share_details" => EventDetails::PaperDocSlackShareDetails(PaperDocSlackShareDetails::internal_deserialize(&mut map)?),
                    "paper_doc_team_invite_details" => EventDetails::PaperDocTeamInviteDetails(PaperDocTeamInviteDetails::internal_deserialize(&mut map)?),
                    "paper_doc_trashed_details" => EventDetails::PaperDocTrashedDetails(PaperDocTrashedDetails::internal_deserialize(&mut map)?),
                    "paper_doc_unresolve_comment_details" => EventDetails::PaperDocUnresolveCommentDetails(PaperDocUnresolveCommentDetails::internal_deserialize(&mut map)?),
                    "paper_doc_untrashed_details" => EventDetails::PaperDocUntrashedDetails(PaperDocUntrashedDetails::internal_deserialize(&mut map)?),
                    "paper_doc_view_details" => EventDetails::PaperDocViewDetails(PaperDocViewDetails::internal_deserialize(&mut map)?),
                    "paper_external_view_allow_details" => EventDetails::PaperExternalViewAllowDetails(PaperExternalViewAllowDetails::internal_deserialize(&mut map)?),
                    "paper_external_view_default_team_details" => EventDetails::PaperExternalViewDefaultTeamDetails(PaperExternalViewDefaultTeamDetails::internal_deserialize(&mut map)?),
                    "paper_external_view_forbid_details" => EventDetails::PaperExternalViewForbidDetails(PaperExternalViewForbidDetails::internal_deserialize(&mut map)?),
                    "paper_folder_change_subscription_details" => EventDetails::PaperFolderChangeSubscriptionDetails(PaperFolderChangeSubscriptionDetails::internal_deserialize(&mut map)?),
                    "paper_folder_deleted_details" => EventDetails::PaperFolderDeletedDetails(PaperFolderDeletedDetails::internal_deserialize(&mut map)?),
                    "paper_folder_followed_details" => EventDetails::PaperFolderFollowedDetails(PaperFolderFollowedDetails::internal_deserialize(&mut map)?),
                    "paper_folder_team_invite_details" => EventDetails::PaperFolderTeamInviteDetails(PaperFolderTeamInviteDetails::internal_deserialize(&mut map)?),
                    "paper_published_link_change_permission_details" => EventDetails::PaperPublishedLinkChangePermissionDetails(PaperPublishedLinkChangePermissionDetails::internal_deserialize(&mut map)?),
                    "paper_published_link_create_details" => EventDetails::PaperPublishedLinkCreateDetails(PaperPublishedLinkCreateDetails::internal_deserialize(&mut map)?),
                    "paper_published_link_disabled_details" => EventDetails::PaperPublishedLinkDisabledDetails(PaperPublishedLinkDisabledDetails::internal_deserialize(&mut map)?),
                    "paper_published_link_view_details" => EventDetails::PaperPublishedLinkViewDetails(PaperPublishedLinkViewDetails::internal_deserialize(&mut map)?),
                    "password_change_details" => EventDetails::PasswordChangeDetails(PasswordChangeDetails::internal_deserialize(&mut map)?),
                    "password_reset_details" => EventDetails::PasswordResetDetails(PasswordResetDetails::internal_deserialize(&mut map)?),
                    "password_reset_all_details" => EventDetails::PasswordResetAllDetails(PasswordResetAllDetails::internal_deserialize(&mut map)?),
                    "classification_create_report_details" => EventDetails::ClassificationCreateReportDetails(ClassificationCreateReportDetails::internal_deserialize(&mut map)?),
                    "classification_create_report_fail_details" => EventDetails::ClassificationCreateReportFailDetails(ClassificationCreateReportFailDetails::internal_deserialize(&mut map)?),
                    "emm_create_exceptions_report_details" => EventDetails::EmmCreateExceptionsReportDetails(EmmCreateExceptionsReportDetails::internal_deserialize(&mut map)?),
                    "emm_create_usage_report_details" => EventDetails::EmmCreateUsageReportDetails(EmmCreateUsageReportDetails::internal_deserialize(&mut map)?),
                    "export_members_report_details" => EventDetails::ExportMembersReportDetails(ExportMembersReportDetails::internal_deserialize(&mut map)?),
                    "export_members_report_fail_details" => EventDetails::ExportMembersReportFailDetails(ExportMembersReportFailDetails::internal_deserialize(&mut map)?),
                    "external_sharing_create_report_details" => EventDetails::ExternalSharingCreateReportDetails(ExternalSharingCreateReportDetails::internal_deserialize(&mut map)?),
                    "external_sharing_report_failed_details" => EventDetails::ExternalSharingReportFailedDetails(ExternalSharingReportFailedDetails::internal_deserialize(&mut map)?),
                    "no_expiration_link_gen_create_report_details" => EventDetails::NoExpirationLinkGenCreateReportDetails(NoExpirationLinkGenCreateReportDetails::internal_deserialize(&mut map)?),
                    "no_expiration_link_gen_report_failed_details" => EventDetails::NoExpirationLinkGenReportFailedDetails(NoExpirationLinkGenReportFailedDetails::internal_deserialize(&mut map)?),
                    "no_password_link_gen_create_report_details" => EventDetails::NoPasswordLinkGenCreateReportDetails(NoPasswordLinkGenCreateReportDetails::internal_deserialize(&mut map)?),
                    "no_password_link_gen_report_failed_details" => EventDetails::NoPasswordLinkGenReportFailedDetails(NoPasswordLinkGenReportFailedDetails::internal_deserialize(&mut map)?),
                    "no_password_link_view_create_report_details" => EventDetails::NoPasswordLinkViewCreateReportDetails(NoPasswordLinkViewCreateReportDetails::internal_deserialize(&mut map)?),
                    "no_password_link_view_report_failed_details" => EventDetails::NoPasswordLinkViewReportFailedDetails(NoPasswordLinkViewReportFailedDetails::internal_deserialize(&mut map)?),
                    "outdated_link_view_create_report_details" => EventDetails::OutdatedLinkViewCreateReportDetails(OutdatedLinkViewCreateReportDetails::internal_deserialize(&mut map)?),
                    "outdated_link_view_report_failed_details" => EventDetails::OutdatedLinkViewReportFailedDetails(OutdatedLinkViewReportFailedDetails::internal_deserialize(&mut map)?),
                    "paper_admin_export_start_details" => EventDetails::PaperAdminExportStartDetails(PaperAdminExportStartDetails::internal_deserialize(&mut map)?),
                    "smart_sync_create_admin_privilege_report_details" => EventDetails::SmartSyncCreateAdminPrivilegeReportDetails(SmartSyncCreateAdminPrivilegeReportDetails::internal_deserialize(&mut map)?),
                    "team_activity_create_report_details" => EventDetails::TeamActivityCreateReportDetails(TeamActivityCreateReportDetails::internal_deserialize(&mut map)?),
                    "team_activity_create_report_fail_details" => EventDetails::TeamActivityCreateReportFailDetails(TeamActivityCreateReportFailDetails::internal_deserialize(&mut map)?),
                    "collection_share_details" => EventDetails::CollectionShareDetails(CollectionShareDetails::internal_deserialize(&mut map)?),
                    "file_transfers_file_add_details" => EventDetails::FileTransfersFileAddDetails(FileTransfersFileAddDetails::internal_deserialize(&mut map)?),
                    "file_transfers_transfer_delete_details" => EventDetails::FileTransfersTransferDeleteDetails(FileTransfersTransferDeleteDetails::internal_deserialize(&mut map)?),
                    "file_transfers_transfer_download_details" => EventDetails::FileTransfersTransferDownloadDetails(FileTransfersTransferDownloadDetails::internal_deserialize(&mut map)?),
                    "file_transfers_transfer_send_details" => EventDetails::FileTransfersTransferSendDetails(FileTransfersTransferSendDetails::internal_deserialize(&mut map)?),
                    "file_transfers_transfer_view_details" => EventDetails::FileTransfersTransferViewDetails(FileTransfersTransferViewDetails::internal_deserialize(&mut map)?),
                    "note_acl_invite_only_details" => EventDetails::NoteAclInviteOnlyDetails(NoteAclInviteOnlyDetails::internal_deserialize(&mut map)?),
                    "note_acl_link_details" => EventDetails::NoteAclLinkDetails(NoteAclLinkDetails::internal_deserialize(&mut map)?),
                    "note_acl_team_link_details" => EventDetails::NoteAclTeamLinkDetails(NoteAclTeamLinkDetails::internal_deserialize(&mut map)?),
                    "note_shared_details" => EventDetails::NoteSharedDetails(NoteSharedDetails::internal_deserialize(&mut map)?),
                    "note_share_receive_details" => EventDetails::NoteShareReceiveDetails(NoteShareReceiveDetails::internal_deserialize(&mut map)?),
                    "open_note_shared_details" => EventDetails::OpenNoteSharedDetails(OpenNoteSharedDetails::internal_deserialize(&mut map)?),
                    "sf_add_group_details" => EventDetails::SfAddGroupDetails(SfAddGroupDetails::internal_deserialize(&mut map)?),
                    "sf_allow_non_members_to_view_shared_links_details" => EventDetails::SfAllowNonMembersToViewSharedLinksDetails(SfAllowNonMembersToViewSharedLinksDetails::internal_deserialize(&mut map)?),
                    "sf_external_invite_warn_details" => EventDetails::SfExternalInviteWarnDetails(SfExternalInviteWarnDetails::internal_deserialize(&mut map)?),
                    "sf_fb_invite_details" => EventDetails::SfFbInviteDetails(SfFbInviteDetails::internal_deserialize(&mut map)?),
                    "sf_fb_invite_change_role_details" => EventDetails::SfFbInviteChangeRoleDetails(SfFbInviteChangeRoleDetails::internal_deserialize(&mut map)?),
                    "sf_fb_uninvite_details" => EventDetails::SfFbUninviteDetails(SfFbUninviteDetails::internal_deserialize(&mut map)?),
                    "sf_invite_group_details" => EventDetails::SfInviteGroupDetails(SfInviteGroupDetails::internal_deserialize(&mut map)?),
                    "sf_team_grant_access_details" => EventDetails::SfTeamGrantAccessDetails(SfTeamGrantAccessDetails::internal_deserialize(&mut map)?),
                    "sf_team_invite_details" => EventDetails::SfTeamInviteDetails(SfTeamInviteDetails::internal_deserialize(&mut map)?),
                    "sf_team_invite_change_role_details" => EventDetails::SfTeamInviteChangeRoleDetails(SfTeamInviteChangeRoleDetails::internal_deserialize(&mut map)?),
                    "sf_team_join_details" => EventDetails::SfTeamJoinDetails(SfTeamJoinDetails::internal_deserialize(&mut map)?),
                    "sf_team_join_from_oob_link_details" => EventDetails::SfTeamJoinFromOobLinkDetails(SfTeamJoinFromOobLinkDetails::internal_deserialize(&mut map)?),
                    "sf_team_uninvite_details" => EventDetails::SfTeamUninviteDetails(SfTeamUninviteDetails::internal_deserialize(&mut map)?),
                    "shared_content_add_invitees_details" => EventDetails::SharedContentAddInviteesDetails(SharedContentAddInviteesDetails::internal_deserialize(&mut map)?),
                    "shared_content_add_link_expiry_details" => EventDetails::SharedContentAddLinkExpiryDetails(SharedContentAddLinkExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_content_add_link_password_details" => EventDetails::SharedContentAddLinkPasswordDetails(SharedContentAddLinkPasswordDetails::internal_deserialize(&mut map)?),
                    "shared_content_add_member_details" => EventDetails::SharedContentAddMemberDetails(SharedContentAddMemberDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_downloads_policy_details" => EventDetails::SharedContentChangeDownloadsPolicyDetails(SharedContentChangeDownloadsPolicyDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_invitee_role_details" => EventDetails::SharedContentChangeInviteeRoleDetails(SharedContentChangeInviteeRoleDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_link_audience_details" => EventDetails::SharedContentChangeLinkAudienceDetails(SharedContentChangeLinkAudienceDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_link_expiry_details" => EventDetails::SharedContentChangeLinkExpiryDetails(SharedContentChangeLinkExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_link_password_details" => EventDetails::SharedContentChangeLinkPasswordDetails(SharedContentChangeLinkPasswordDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_member_role_details" => EventDetails::SharedContentChangeMemberRoleDetails(SharedContentChangeMemberRoleDetails::internal_deserialize(&mut map)?),
                    "shared_content_change_viewer_info_policy_details" => EventDetails::SharedContentChangeViewerInfoPolicyDetails(SharedContentChangeViewerInfoPolicyDetails::internal_deserialize(&mut map)?),
                    "shared_content_claim_invitation_details" => EventDetails::SharedContentClaimInvitationDetails(SharedContentClaimInvitationDetails::internal_deserialize(&mut map)?),
                    "shared_content_copy_details" => EventDetails::SharedContentCopyDetails(SharedContentCopyDetails::internal_deserialize(&mut map)?),
                    "shared_content_download_details" => EventDetails::SharedContentDownloadDetails(SharedContentDownloadDetails::internal_deserialize(&mut map)?),
                    "shared_content_relinquish_membership_details" => EventDetails::SharedContentRelinquishMembershipDetails(SharedContentRelinquishMembershipDetails::internal_deserialize(&mut map)?),
                    "shared_content_remove_invitees_details" => EventDetails::SharedContentRemoveInviteesDetails(SharedContentRemoveInviteesDetails::internal_deserialize(&mut map)?),
                    "shared_content_remove_link_expiry_details" => EventDetails::SharedContentRemoveLinkExpiryDetails(SharedContentRemoveLinkExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_content_remove_link_password_details" => EventDetails::SharedContentRemoveLinkPasswordDetails(SharedContentRemoveLinkPasswordDetails::internal_deserialize(&mut map)?),
                    "shared_content_remove_member_details" => EventDetails::SharedContentRemoveMemberDetails(SharedContentRemoveMemberDetails::internal_deserialize(&mut map)?),
                    "shared_content_request_access_details" => EventDetails::SharedContentRequestAccessDetails(SharedContentRequestAccessDetails::internal_deserialize(&mut map)?),
                    "shared_content_restore_invitees_details" => EventDetails::SharedContentRestoreInviteesDetails(SharedContentRestoreInviteesDetails::internal_deserialize(&mut map)?),
                    "shared_content_restore_member_details" => EventDetails::SharedContentRestoreMemberDetails(SharedContentRestoreMemberDetails::internal_deserialize(&mut map)?),
                    "shared_content_unshare_details" => EventDetails::SharedContentUnshareDetails(SharedContentUnshareDetails::internal_deserialize(&mut map)?),
                    "shared_content_view_details" => EventDetails::SharedContentViewDetails(SharedContentViewDetails::internal_deserialize(&mut map)?),
                    "shared_folder_change_link_policy_details" => EventDetails::SharedFolderChangeLinkPolicyDetails(SharedFolderChangeLinkPolicyDetails::internal_deserialize(&mut map)?),
                    "shared_folder_change_members_inheritance_policy_details" => EventDetails::SharedFolderChangeMembersInheritancePolicyDetails(SharedFolderChangeMembersInheritancePolicyDetails::internal_deserialize(&mut map)?),
                    "shared_folder_change_members_management_policy_details" => EventDetails::SharedFolderChangeMembersManagementPolicyDetails(SharedFolderChangeMembersManagementPolicyDetails::internal_deserialize(&mut map)?),
                    "shared_folder_change_members_policy_details" => EventDetails::SharedFolderChangeMembersPolicyDetails(SharedFolderChangeMembersPolicyDetails::internal_deserialize(&mut map)?),
                    "shared_folder_create_details" => EventDetails::SharedFolderCreateDetails(SharedFolderCreateDetails::internal_deserialize(&mut map)?),
                    "shared_folder_decline_invitation_details" => EventDetails::SharedFolderDeclineInvitationDetails(SharedFolderDeclineInvitationDetails::internal_deserialize(&mut map)?),
                    "shared_folder_mount_details" => EventDetails::SharedFolderMountDetails(SharedFolderMountDetails::internal_deserialize(&mut map)?),
                    "shared_folder_nest_details" => EventDetails::SharedFolderNestDetails(SharedFolderNestDetails::internal_deserialize(&mut map)?),
                    "shared_folder_transfer_ownership_details" => EventDetails::SharedFolderTransferOwnershipDetails(SharedFolderTransferOwnershipDetails::internal_deserialize(&mut map)?),
                    "shared_folder_unmount_details" => EventDetails::SharedFolderUnmountDetails(SharedFolderUnmountDetails::internal_deserialize(&mut map)?),
                    "shared_link_add_expiry_details" => EventDetails::SharedLinkAddExpiryDetails(SharedLinkAddExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_link_change_expiry_details" => EventDetails::SharedLinkChangeExpiryDetails(SharedLinkChangeExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_link_change_visibility_details" => EventDetails::SharedLinkChangeVisibilityDetails(SharedLinkChangeVisibilityDetails::internal_deserialize(&mut map)?),
                    "shared_link_copy_details" => EventDetails::SharedLinkCopyDetails(SharedLinkCopyDetails::internal_deserialize(&mut map)?),
                    "shared_link_create_details" => EventDetails::SharedLinkCreateDetails(SharedLinkCreateDetails::internal_deserialize(&mut map)?),
                    "shared_link_disable_details" => EventDetails::SharedLinkDisableDetails(SharedLinkDisableDetails::internal_deserialize(&mut map)?),
                    "shared_link_download_details" => EventDetails::SharedLinkDownloadDetails(SharedLinkDownloadDetails::internal_deserialize(&mut map)?),
                    "shared_link_remove_expiry_details" => EventDetails::SharedLinkRemoveExpiryDetails(SharedLinkRemoveExpiryDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_add_expiration_details" => EventDetails::SharedLinkSettingsAddExpirationDetails(SharedLinkSettingsAddExpirationDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_add_password_details" => EventDetails::SharedLinkSettingsAddPasswordDetails(SharedLinkSettingsAddPasswordDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_allow_download_disabled_details" => EventDetails::SharedLinkSettingsAllowDownloadDisabledDetails(SharedLinkSettingsAllowDownloadDisabledDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_allow_download_enabled_details" => EventDetails::SharedLinkSettingsAllowDownloadEnabledDetails(SharedLinkSettingsAllowDownloadEnabledDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_change_audience_details" => EventDetails::SharedLinkSettingsChangeAudienceDetails(SharedLinkSettingsChangeAudienceDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_change_expiration_details" => EventDetails::SharedLinkSettingsChangeExpirationDetails(SharedLinkSettingsChangeExpirationDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_change_password_details" => EventDetails::SharedLinkSettingsChangePasswordDetails(SharedLinkSettingsChangePasswordDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_remove_expiration_details" => EventDetails::SharedLinkSettingsRemoveExpirationDetails(SharedLinkSettingsRemoveExpirationDetails::internal_deserialize(&mut map)?),
                    "shared_link_settings_remove_password_details" => EventDetails::SharedLinkSettingsRemovePasswordDetails(SharedLinkSettingsRemovePasswordDetails::internal_deserialize(&mut map)?),
                    "shared_link_share_details" => EventDetails::SharedLinkShareDetails(SharedLinkShareDetails::internal_deserialize(&mut map)?),
                    "shared_link_view_details" => EventDetails::SharedLinkViewDetails(SharedLinkViewDetails::internal_deserialize(&mut map)?),
                    "shared_note_opened_details" => EventDetails::SharedNoteOpenedDetails(SharedNoteOpenedDetails::internal_deserialize(&mut map)?),
                    "shmodel_disable_downloads_details" => EventDetails::ShmodelDisableDownloadsDetails(ShmodelDisableDownloadsDetails::internal_deserialize(&mut map)?),
                    "shmodel_enable_downloads_details" => EventDetails::ShmodelEnableDownloadsDetails(ShmodelEnableDownloadsDetails::internal_deserialize(&mut map)?),
                    "shmodel_group_share_details" => EventDetails::ShmodelGroupShareDetails(ShmodelGroupShareDetails::internal_deserialize(&mut map)?),
                    "showcase_access_granted_details" => EventDetails::ShowcaseAccessGrantedDetails(ShowcaseAccessGrantedDetails::internal_deserialize(&mut map)?),
                    "showcase_add_member_details" => EventDetails::ShowcaseAddMemberDetails(ShowcaseAddMemberDetails::internal_deserialize(&mut map)?),
                    "showcase_archived_details" => EventDetails::ShowcaseArchivedDetails(ShowcaseArchivedDetails::internal_deserialize(&mut map)?),
                    "showcase_created_details" => EventDetails::ShowcaseCreatedDetails(ShowcaseCreatedDetails::internal_deserialize(&mut map)?),
                    "showcase_delete_comment_details" => EventDetails::ShowcaseDeleteCommentDetails(ShowcaseDeleteCommentDetails::internal_deserialize(&mut map)?),
                    "showcase_edited_details" => EventDetails::ShowcaseEditedDetails(ShowcaseEditedDetails::internal_deserialize(&mut map)?),
                    "showcase_edit_comment_details" => EventDetails::ShowcaseEditCommentDetails(ShowcaseEditCommentDetails::internal_deserialize(&mut map)?),
                    "showcase_file_added_details" => EventDetails::ShowcaseFileAddedDetails(ShowcaseFileAddedDetails::internal_deserialize(&mut map)?),
                    "showcase_file_download_details" => EventDetails::ShowcaseFileDownloadDetails(ShowcaseFileDownloadDetails::internal_deserialize(&mut map)?),
                    "showcase_file_removed_details" => EventDetails::ShowcaseFileRemovedDetails(ShowcaseFileRemovedDetails::internal_deserialize(&mut map)?),
                    "showcase_file_view_details" => EventDetails::ShowcaseFileViewDetails(ShowcaseFileViewDetails::internal_deserialize(&mut map)?),
                    "showcase_permanently_deleted_details" => EventDetails::ShowcasePermanentlyDeletedDetails(ShowcasePermanentlyDeletedDetails::internal_deserialize(&mut map)?),
                    "showcase_post_comment_details" => EventDetails::ShowcasePostCommentDetails(ShowcasePostCommentDetails::internal_deserialize(&mut map)?),
                    "showcase_remove_member_details" => EventDetails::ShowcaseRemoveMemberDetails(ShowcaseRemoveMemberDetails::internal_deserialize(&mut map)?),
                    "showcase_renamed_details" => EventDetails::ShowcaseRenamedDetails(ShowcaseRenamedDetails::internal_deserialize(&mut map)?),
                    "showcase_request_access_details" => EventDetails::ShowcaseRequestAccessDetails(ShowcaseRequestAccessDetails::internal_deserialize(&mut map)?),
                    "showcase_resolve_comment_details" => EventDetails::ShowcaseResolveCommentDetails(ShowcaseResolveCommentDetails::internal_deserialize(&mut map)?),
                    "showcase_restored_details" => EventDetails::ShowcaseRestoredDetails(ShowcaseRestoredDetails::internal_deserialize(&mut map)?),
                    "showcase_trashed_details" => EventDetails::ShowcaseTrashedDetails(ShowcaseTrashedDetails::internal_deserialize(&mut map)?),
                    "showcase_trashed_deprecated_details" => EventDetails::ShowcaseTrashedDeprecatedDetails(ShowcaseTrashedDeprecatedDetails::internal_deserialize(&mut map)?),
                    "showcase_unresolve_comment_details" => EventDetails::ShowcaseUnresolveCommentDetails(ShowcaseUnresolveCommentDetails::internal_deserialize(&mut map)?),
                    "showcase_untrashed_details" => EventDetails::ShowcaseUntrashedDetails(ShowcaseUntrashedDetails::internal_deserialize(&mut map)?),
                    "showcase_untrashed_deprecated_details" => EventDetails::ShowcaseUntrashedDeprecatedDetails(ShowcaseUntrashedDeprecatedDetails::internal_deserialize(&mut map)?),
                    "showcase_view_details" => EventDetails::ShowcaseViewDetails(ShowcaseViewDetails::internal_deserialize(&mut map)?),
                    "sso_add_cert_details" => EventDetails::SsoAddCertDetails(SsoAddCertDetails::internal_deserialize(&mut map)?),
                    "sso_add_login_url_details" => EventDetails::SsoAddLoginUrlDetails(SsoAddLoginUrlDetails::internal_deserialize(&mut map)?),
                    "sso_add_logout_url_details" => EventDetails::SsoAddLogoutUrlDetails(SsoAddLogoutUrlDetails::internal_deserialize(&mut map)?),
                    "sso_change_cert_details" => EventDetails::SsoChangeCertDetails(SsoChangeCertDetails::internal_deserialize(&mut map)?),
                    "sso_change_login_url_details" => EventDetails::SsoChangeLoginUrlDetails(SsoChangeLoginUrlDetails::internal_deserialize(&mut map)?),
                    "sso_change_logout_url_details" => EventDetails::SsoChangeLogoutUrlDetails(SsoChangeLogoutUrlDetails::internal_deserialize(&mut map)?),
                    "sso_change_saml_identity_mode_details" => EventDetails::SsoChangeSamlIdentityModeDetails(SsoChangeSamlIdentityModeDetails::internal_deserialize(&mut map)?),
                    "sso_remove_cert_details" => EventDetails::SsoRemoveCertDetails(SsoRemoveCertDetails::internal_deserialize(&mut map)?),
                    "sso_remove_login_url_details" => EventDetails::SsoRemoveLoginUrlDetails(SsoRemoveLoginUrlDetails::internal_deserialize(&mut map)?),
                    "sso_remove_logout_url_details" => EventDetails::SsoRemoveLogoutUrlDetails(SsoRemoveLogoutUrlDetails::internal_deserialize(&mut map)?),
                    "team_folder_change_status_details" => EventDetails::TeamFolderChangeStatusDetails(TeamFolderChangeStatusDetails::internal_deserialize(&mut map)?),
                    "team_folder_create_details" => EventDetails::TeamFolderCreateDetails(TeamFolderCreateDetails::internal_deserialize(&mut map)?),
                    "team_folder_downgrade_details" => EventDetails::TeamFolderDowngradeDetails(TeamFolderDowngradeDetails::internal_deserialize(&mut map)?),
                    "team_folder_permanently_delete_details" => EventDetails::TeamFolderPermanentlyDeleteDetails(TeamFolderPermanentlyDeleteDetails::internal_deserialize(&mut map)?),
                    "team_folder_rename_details" => EventDetails::TeamFolderRenameDetails(TeamFolderRenameDetails::internal_deserialize(&mut map)?),
                    "team_selective_sync_settings_changed_details" => EventDetails::TeamSelectiveSyncSettingsChangedDetails(TeamSelectiveSyncSettingsChangedDetails::internal_deserialize(&mut map)?),
                    "account_capture_change_policy_details" => EventDetails::AccountCaptureChangePolicyDetails(AccountCaptureChangePolicyDetails::internal_deserialize(&mut map)?),
                    "allow_download_disabled_details" => EventDetails::AllowDownloadDisabledDetails(AllowDownloadDisabledDetails::internal_deserialize(&mut map)?),
                    "allow_download_enabled_details" => EventDetails::AllowDownloadEnabledDetails(AllowDownloadEnabledDetails::internal_deserialize(&mut map)?),
                    "app_permissions_changed_details" => EventDetails::AppPermissionsChangedDetails(AppPermissionsChangedDetails::internal_deserialize(&mut map)?),
                    "camera_uploads_policy_changed_details" => EventDetails::CameraUploadsPolicyChangedDetails(CameraUploadsPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "classification_change_policy_details" => EventDetails::ClassificationChangePolicyDetails(ClassificationChangePolicyDetails::internal_deserialize(&mut map)?),
                    "computer_backup_policy_changed_details" => EventDetails::ComputerBackupPolicyChangedDetails(ComputerBackupPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "content_administration_policy_changed_details" => EventDetails::ContentAdministrationPolicyChangedDetails(ContentAdministrationPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "data_placement_restriction_change_policy_details" => EventDetails::DataPlacementRestrictionChangePolicyDetails(DataPlacementRestrictionChangePolicyDetails::internal_deserialize(&mut map)?),
                    "data_placement_restriction_satisfy_policy_details" => EventDetails::DataPlacementRestrictionSatisfyPolicyDetails(DataPlacementRestrictionSatisfyPolicyDetails::internal_deserialize(&mut map)?),
                    "device_approvals_add_exception_details" => EventDetails::DeviceApprovalsAddExceptionDetails(DeviceApprovalsAddExceptionDetails::internal_deserialize(&mut map)?),
                    "device_approvals_change_desktop_policy_details" => EventDetails::DeviceApprovalsChangeDesktopPolicyDetails(DeviceApprovalsChangeDesktopPolicyDetails::internal_deserialize(&mut map)?),
                    "device_approvals_change_mobile_policy_details" => EventDetails::DeviceApprovalsChangeMobilePolicyDetails(DeviceApprovalsChangeMobilePolicyDetails::internal_deserialize(&mut map)?),
                    "device_approvals_change_overage_action_details" => EventDetails::DeviceApprovalsChangeOverageActionDetails(DeviceApprovalsChangeOverageActionDetails::internal_deserialize(&mut map)?),
                    "device_approvals_change_unlink_action_details" => EventDetails::DeviceApprovalsChangeUnlinkActionDetails(DeviceApprovalsChangeUnlinkActionDetails::internal_deserialize(&mut map)?),
                    "device_approvals_remove_exception_details" => EventDetails::DeviceApprovalsRemoveExceptionDetails(DeviceApprovalsRemoveExceptionDetails::internal_deserialize(&mut map)?),
                    "directory_restrictions_add_members_details" => EventDetails::DirectoryRestrictionsAddMembersDetails(DirectoryRestrictionsAddMembersDetails::internal_deserialize(&mut map)?),
                    "directory_restrictions_remove_members_details" => EventDetails::DirectoryRestrictionsRemoveMembersDetails(DirectoryRestrictionsRemoveMembersDetails::internal_deserialize(&mut map)?),
                    "emm_add_exception_details" => EventDetails::EmmAddExceptionDetails(EmmAddExceptionDetails::internal_deserialize(&mut map)?),
                    "emm_change_policy_details" => EventDetails::EmmChangePolicyDetails(EmmChangePolicyDetails::internal_deserialize(&mut map)?),
                    "emm_remove_exception_details" => EventDetails::EmmRemoveExceptionDetails(EmmRemoveExceptionDetails::internal_deserialize(&mut map)?),
                    "extended_version_history_change_policy_details" => EventDetails::ExtendedVersionHistoryChangePolicyDetails(ExtendedVersionHistoryChangePolicyDetails::internal_deserialize(&mut map)?),
                    "file_comments_change_policy_details" => EventDetails::FileCommentsChangePolicyDetails(FileCommentsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "file_locking_policy_changed_details" => EventDetails::FileLockingPolicyChangedDetails(FileLockingPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "file_requests_change_policy_details" => EventDetails::FileRequestsChangePolicyDetails(FileRequestsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "file_requests_emails_enabled_details" => EventDetails::FileRequestsEmailsEnabledDetails(FileRequestsEmailsEnabledDetails::internal_deserialize(&mut map)?),
                    "file_requests_emails_restricted_to_team_only_details" => EventDetails::FileRequestsEmailsRestrictedToTeamOnlyDetails(FileRequestsEmailsRestrictedToTeamOnlyDetails::internal_deserialize(&mut map)?),
                    "file_transfers_policy_changed_details" => EventDetails::FileTransfersPolicyChangedDetails(FileTransfersPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "google_sso_change_policy_details" => EventDetails::GoogleSsoChangePolicyDetails(GoogleSsoChangePolicyDetails::internal_deserialize(&mut map)?),
                    "group_user_management_change_policy_details" => EventDetails::GroupUserManagementChangePolicyDetails(GroupUserManagementChangePolicyDetails::internal_deserialize(&mut map)?),
                    "integration_policy_changed_details" => EventDetails::IntegrationPolicyChangedDetails(IntegrationPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "invite_acceptance_email_policy_changed_details" => EventDetails::InviteAcceptanceEmailPolicyChangedDetails(InviteAcceptanceEmailPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "member_requests_change_policy_details" => EventDetails::MemberRequestsChangePolicyDetails(MemberRequestsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "member_send_invite_policy_changed_details" => EventDetails::MemberSendInvitePolicyChangedDetails(MemberSendInvitePolicyChangedDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_add_exception_details" => EventDetails::MemberSpaceLimitsAddExceptionDetails(MemberSpaceLimitsAddExceptionDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_change_caps_type_policy_details" => EventDetails::MemberSpaceLimitsChangeCapsTypePolicyDetails(MemberSpaceLimitsChangeCapsTypePolicyDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_change_policy_details" => EventDetails::MemberSpaceLimitsChangePolicyDetails(MemberSpaceLimitsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "member_space_limits_remove_exception_details" => EventDetails::MemberSpaceLimitsRemoveExceptionDetails(MemberSpaceLimitsRemoveExceptionDetails::internal_deserialize(&mut map)?),
                    "member_suggestions_change_policy_details" => EventDetails::MemberSuggestionsChangePolicyDetails(MemberSuggestionsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "microsoft_office_addin_change_policy_details" => EventDetails::MicrosoftOfficeAddinChangePolicyDetails(MicrosoftOfficeAddinChangePolicyDetails::internal_deserialize(&mut map)?),
                    "network_control_change_policy_details" => EventDetails::NetworkControlChangePolicyDetails(NetworkControlChangePolicyDetails::internal_deserialize(&mut map)?),
                    "paper_change_deployment_policy_details" => EventDetails::PaperChangeDeploymentPolicyDetails(PaperChangeDeploymentPolicyDetails::internal_deserialize(&mut map)?),
                    "paper_change_member_link_policy_details" => EventDetails::PaperChangeMemberLinkPolicyDetails(PaperChangeMemberLinkPolicyDetails::internal_deserialize(&mut map)?),
                    "paper_change_member_policy_details" => EventDetails::PaperChangeMemberPolicyDetails(PaperChangeMemberPolicyDetails::internal_deserialize(&mut map)?),
                    "paper_change_policy_details" => EventDetails::PaperChangePolicyDetails(PaperChangePolicyDetails::internal_deserialize(&mut map)?),
                    "paper_default_folder_policy_changed_details" => EventDetails::PaperDefaultFolderPolicyChangedDetails(PaperDefaultFolderPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "paper_desktop_policy_changed_details" => EventDetails::PaperDesktopPolicyChangedDetails(PaperDesktopPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "paper_enabled_users_group_addition_details" => EventDetails::PaperEnabledUsersGroupAdditionDetails(PaperEnabledUsersGroupAdditionDetails::internal_deserialize(&mut map)?),
                    "paper_enabled_users_group_removal_details" => EventDetails::PaperEnabledUsersGroupRemovalDetails(PaperEnabledUsersGroupRemovalDetails::internal_deserialize(&mut map)?),
                    "password_strength_requirements_change_policy_details" => EventDetails::PasswordStrengthRequirementsChangePolicyDetails(PasswordStrengthRequirementsChangePolicyDetails::internal_deserialize(&mut map)?),
                    "permanent_delete_change_policy_details" => EventDetails::PermanentDeleteChangePolicyDetails(PermanentDeleteChangePolicyDetails::internal_deserialize(&mut map)?),
                    "reseller_support_change_policy_details" => EventDetails::ResellerSupportChangePolicyDetails(ResellerSupportChangePolicyDetails::internal_deserialize(&mut map)?),
                    "rewind_policy_changed_details" => EventDetails::RewindPolicyChangedDetails(RewindPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "send_for_signature_policy_changed_details" => EventDetails::SendForSignaturePolicyChangedDetails(SendForSignaturePolicyChangedDetails::internal_deserialize(&mut map)?),
                    "sharing_change_folder_join_policy_details" => EventDetails::SharingChangeFolderJoinPolicyDetails(SharingChangeFolderJoinPolicyDetails::internal_deserialize(&mut map)?),
                    "sharing_change_link_allow_change_expiration_policy_details" => EventDetails::SharingChangeLinkAllowChangeExpirationPolicyDetails(SharingChangeLinkAllowChangeExpirationPolicyDetails::internal_deserialize(&mut map)?),
                    "sharing_change_link_default_expiration_policy_details" => EventDetails::SharingChangeLinkDefaultExpirationPolicyDetails(SharingChangeLinkDefaultExpirationPolicyDetails::internal_deserialize(&mut map)?),
                    "sharing_change_link_enforce_password_policy_details" => EventDetails::SharingChangeLinkEnforcePasswordPolicyDetails(SharingChangeLinkEnforcePasswordPolicyDetails::internal_deserialize(&mut map)?),
                    "sharing_change_link_policy_details" => EventDetails::SharingChangeLinkPolicyDetails(SharingChangeLinkPolicyDetails::internal_deserialize(&mut map)?),
                    "sharing_change_member_policy_details" => EventDetails::SharingChangeMemberPolicyDetails(SharingChangeMemberPolicyDetails::internal_deserialize(&mut map)?),
                    "showcase_change_download_policy_details" => EventDetails::ShowcaseChangeDownloadPolicyDetails(ShowcaseChangeDownloadPolicyDetails::internal_deserialize(&mut map)?),
                    "showcase_change_enabled_policy_details" => EventDetails::ShowcaseChangeEnabledPolicyDetails(ShowcaseChangeEnabledPolicyDetails::internal_deserialize(&mut map)?),
                    "showcase_change_external_sharing_policy_details" => EventDetails::ShowcaseChangeExternalSharingPolicyDetails(ShowcaseChangeExternalSharingPolicyDetails::internal_deserialize(&mut map)?),
                    "smarter_smart_sync_policy_changed_details" => EventDetails::SmarterSmartSyncPolicyChangedDetails(SmarterSmartSyncPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "smart_sync_change_policy_details" => EventDetails::SmartSyncChangePolicyDetails(SmartSyncChangePolicyDetails::internal_deserialize(&mut map)?),
                    "smart_sync_not_opt_out_details" => EventDetails::SmartSyncNotOptOutDetails(SmartSyncNotOptOutDetails::internal_deserialize(&mut map)?),
                    "smart_sync_opt_out_details" => EventDetails::SmartSyncOptOutDetails(SmartSyncOptOutDetails::internal_deserialize(&mut map)?),
                    "sso_change_policy_details" => EventDetails::SsoChangePolicyDetails(SsoChangePolicyDetails::internal_deserialize(&mut map)?),
                    "team_branding_policy_changed_details" => EventDetails::TeamBrandingPolicyChangedDetails(TeamBrandingPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "team_extensions_policy_changed_details" => EventDetails::TeamExtensionsPolicyChangedDetails(TeamExtensionsPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "team_selective_sync_policy_changed_details" => EventDetails::TeamSelectiveSyncPolicyChangedDetails(TeamSelectiveSyncPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "team_sharing_whitelist_subjects_changed_details" => EventDetails::TeamSharingWhitelistSubjectsChangedDetails(TeamSharingWhitelistSubjectsChangedDetails::internal_deserialize(&mut map)?),
                    "tfa_add_exception_details" => EventDetails::TfaAddExceptionDetails(TfaAddExceptionDetails::internal_deserialize(&mut map)?),
                    "tfa_change_policy_details" => EventDetails::TfaChangePolicyDetails(TfaChangePolicyDetails::internal_deserialize(&mut map)?),
                    "tfa_remove_exception_details" => EventDetails::TfaRemoveExceptionDetails(TfaRemoveExceptionDetails::internal_deserialize(&mut map)?),
                    "two_account_change_policy_details" => EventDetails::TwoAccountChangePolicyDetails(TwoAccountChangePolicyDetails::internal_deserialize(&mut map)?),
                    "viewer_info_policy_changed_details" => EventDetails::ViewerInfoPolicyChangedDetails(ViewerInfoPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "watermarking_policy_changed_details" => EventDetails::WatermarkingPolicyChangedDetails(WatermarkingPolicyChangedDetails::internal_deserialize(&mut map)?),
                    "web_sessions_change_active_session_limit_details" => EventDetails::WebSessionsChangeActiveSessionLimitDetails(WebSessionsChangeActiveSessionLimitDetails::internal_deserialize(&mut map)?),
                    "web_sessions_change_fixed_length_policy_details" => EventDetails::WebSessionsChangeFixedLengthPolicyDetails(WebSessionsChangeFixedLengthPolicyDetails::internal_deserialize(&mut map)?),
                    "web_sessions_change_idle_length_policy_details" => EventDetails::WebSessionsChangeIdleLengthPolicyDetails(WebSessionsChangeIdleLengthPolicyDetails::internal_deserialize(&mut map)?),
                    "team_merge_from_details" => EventDetails::TeamMergeFromDetails(TeamMergeFromDetails::internal_deserialize(&mut map)?),
                    "team_merge_to_details" => EventDetails::TeamMergeToDetails(TeamMergeToDetails::internal_deserialize(&mut map)?),
                    "team_profile_add_background_details" => EventDetails::TeamProfileAddBackgroundDetails(TeamProfileAddBackgroundDetails::internal_deserialize(&mut map)?),
                    "team_profile_add_logo_details" => EventDetails::TeamProfileAddLogoDetails(TeamProfileAddLogoDetails::internal_deserialize(&mut map)?),
                    "team_profile_change_background_details" => EventDetails::TeamProfileChangeBackgroundDetails(TeamProfileChangeBackgroundDetails::internal_deserialize(&mut map)?),
                    "team_profile_change_default_language_details" => EventDetails::TeamProfileChangeDefaultLanguageDetails(TeamProfileChangeDefaultLanguageDetails::internal_deserialize(&mut map)?),
                    "team_profile_change_logo_details" => EventDetails::TeamProfileChangeLogoDetails(TeamProfileChangeLogoDetails::internal_deserialize(&mut map)?),
                    "team_profile_change_name_details" => EventDetails::TeamProfileChangeNameDetails(TeamProfileChangeNameDetails::internal_deserialize(&mut map)?),
                    "team_profile_remove_background_details" => EventDetails::TeamProfileRemoveBackgroundDetails(TeamProfileRemoveBackgroundDetails::internal_deserialize(&mut map)?),
                    "team_profile_remove_logo_details" => EventDetails::TeamProfileRemoveLogoDetails(TeamProfileRemoveLogoDetails::internal_deserialize(&mut map)?),
                    "tfa_add_backup_phone_details" => EventDetails::TfaAddBackupPhoneDetails(TfaAddBackupPhoneDetails::internal_deserialize(&mut map)?),
                    "tfa_add_security_key_details" => EventDetails::TfaAddSecurityKeyDetails(TfaAddSecurityKeyDetails::internal_deserialize(&mut map)?),
                    "tfa_change_backup_phone_details" => EventDetails::TfaChangeBackupPhoneDetails(TfaChangeBackupPhoneDetails::internal_deserialize(&mut map)?),
                    "tfa_change_status_details" => EventDetails::TfaChangeStatusDetails(TfaChangeStatusDetails::internal_deserialize(&mut map)?),
                    "tfa_remove_backup_phone_details" => EventDetails::TfaRemoveBackupPhoneDetails(TfaRemoveBackupPhoneDetails::internal_deserialize(&mut map)?),
                    "tfa_remove_security_key_details" => EventDetails::TfaRemoveSecurityKeyDetails(TfaRemoveSecurityKeyDetails::internal_deserialize(&mut map)?),
                    "tfa_reset_details" => EventDetails::TfaResetDetails(TfaResetDetails::internal_deserialize(&mut map)?),
                    "changed_enterprise_admin_role_details" => EventDetails::ChangedEnterpriseAdminRoleDetails(ChangedEnterpriseAdminRoleDetails::internal_deserialize(&mut map)?),
                    "changed_enterprise_connected_team_status_details" => EventDetails::ChangedEnterpriseConnectedTeamStatusDetails(ChangedEnterpriseConnectedTeamStatusDetails::internal_deserialize(&mut map)?),
                    "ended_enterprise_admin_session_details" => EventDetails::EndedEnterpriseAdminSessionDetails(EndedEnterpriseAdminSessionDetails::internal_deserialize(&mut map)?),
                    "ended_enterprise_admin_session_deprecated_details" => EventDetails::EndedEnterpriseAdminSessionDeprecatedDetails(EndedEnterpriseAdminSessionDeprecatedDetails::internal_deserialize(&mut map)?),
                    "enterprise_settings_locking_details" => EventDetails::EnterpriseSettingsLockingDetails(EnterpriseSettingsLockingDetails::internal_deserialize(&mut map)?),
                    "guest_admin_change_status_details" => EventDetails::GuestAdminChangeStatusDetails(GuestAdminChangeStatusDetails::internal_deserialize(&mut map)?),
                    "started_enterprise_admin_session_details" => EventDetails::StartedEnterpriseAdminSessionDetails(StartedEnterpriseAdminSessionDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_accepted_details" => EventDetails::TeamMergeRequestAcceptedDetails(TeamMergeRequestAcceptedDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_accepted_shown_to_primary_team_details" => EventDetails::TeamMergeRequestAcceptedShownToPrimaryTeamDetails(TeamMergeRequestAcceptedShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_accepted_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestAcceptedShownToSecondaryTeamDetails(TeamMergeRequestAcceptedShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_auto_canceled_details" => EventDetails::TeamMergeRequestAutoCanceledDetails(TeamMergeRequestAutoCanceledDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_canceled_details" => EventDetails::TeamMergeRequestCanceledDetails(TeamMergeRequestCanceledDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_canceled_shown_to_primary_team_details" => EventDetails::TeamMergeRequestCanceledShownToPrimaryTeamDetails(TeamMergeRequestCanceledShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_canceled_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestCanceledShownToSecondaryTeamDetails(TeamMergeRequestCanceledShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_expired_details" => EventDetails::TeamMergeRequestExpiredDetails(TeamMergeRequestExpiredDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_expired_shown_to_primary_team_details" => EventDetails::TeamMergeRequestExpiredShownToPrimaryTeamDetails(TeamMergeRequestExpiredShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_expired_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestExpiredShownToSecondaryTeamDetails(TeamMergeRequestExpiredShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_rejected_shown_to_primary_team_details" => EventDetails::TeamMergeRequestRejectedShownToPrimaryTeamDetails(TeamMergeRequestRejectedShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_rejected_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestRejectedShownToSecondaryTeamDetails(TeamMergeRequestRejectedShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_reminder_details" => EventDetails::TeamMergeRequestReminderDetails(TeamMergeRequestReminderDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_reminder_shown_to_primary_team_details" => EventDetails::TeamMergeRequestReminderShownToPrimaryTeamDetails(TeamMergeRequestReminderShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_reminder_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestReminderShownToSecondaryTeamDetails(TeamMergeRequestReminderShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_revoked_details" => EventDetails::TeamMergeRequestRevokedDetails(TeamMergeRequestRevokedDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_sent_shown_to_primary_team_details" => EventDetails::TeamMergeRequestSentShownToPrimaryTeamDetails(TeamMergeRequestSentShownToPrimaryTeamDetails::internal_deserialize(&mut map)?),
                    "team_merge_request_sent_shown_to_secondary_team_details" => EventDetails::TeamMergeRequestSentShownToSecondaryTeamDetails(TeamMergeRequestSentShownToSecondaryTeamDetails::internal_deserialize(&mut map)?),
                    "missing_details" => EventDetails::MissingDetails(MissingDetails::internal_deserialize(&mut map)?),
                    _ => EventDetails::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["admin_alerting_alert_state_changed_details",
                                    "admin_alerting_changed_alert_config_details",
                                    "admin_alerting_triggered_alert_details",
                                    "app_blocked_by_permissions_details",
                                    "app_link_team_details",
                                    "app_link_user_details",
                                    "app_unlink_team_details",
                                    "app_unlink_user_details",
                                    "integration_connected_details",
                                    "integration_disconnected_details",
                                    "file_add_comment_details",
                                    "file_change_comment_subscription_details",
                                    "file_delete_comment_details",
                                    "file_edit_comment_details",
                                    "file_like_comment_details",
                                    "file_resolve_comment_details",
                                    "file_unlike_comment_details",
                                    "file_unresolve_comment_details",
                                    "governance_policy_add_folders_details",
                                    "governance_policy_add_folder_failed_details",
                                    "governance_policy_content_disposed_details",
                                    "governance_policy_create_details",
                                    "governance_policy_delete_details",
                                    "governance_policy_edit_details_details",
                                    "governance_policy_edit_duration_details",
                                    "governance_policy_export_created_details",
                                    "governance_policy_export_removed_details",
                                    "governance_policy_remove_folders_details",
                                    "governance_policy_report_created_details",
                                    "governance_policy_zip_part_downloaded_details",
                                    "legal_holds_activate_a_hold_details",
                                    "legal_holds_add_members_details",
                                    "legal_holds_change_hold_details_details",
                                    "legal_holds_change_hold_name_details",
                                    "legal_holds_export_a_hold_details",
                                    "legal_holds_export_cancelled_details",
                                    "legal_holds_export_downloaded_details",
                                    "legal_holds_export_removed_details",
                                    "legal_holds_release_a_hold_details",
                                    "legal_holds_remove_members_details",
                                    "legal_holds_report_a_hold_details",
                                    "device_change_ip_desktop_details",
                                    "device_change_ip_mobile_details",
                                    "device_change_ip_web_details",
                                    "device_delete_on_unlink_fail_details",
                                    "device_delete_on_unlink_success_details",
                                    "device_link_fail_details",
                                    "device_link_success_details",
                                    "device_management_disabled_details",
                                    "device_management_enabled_details",
                                    "device_sync_backup_status_changed_details",
                                    "device_unlink_details",
                                    "dropbox_passwords_exported_details",
                                    "dropbox_passwords_new_device_enrolled_details",
                                    "emm_refresh_auth_token_details",
                                    "account_capture_change_availability_details",
                                    "account_capture_migrate_account_details",
                                    "account_capture_notification_emails_sent_details",
                                    "account_capture_relinquish_account_details",
                                    "disabled_domain_invites_details",
                                    "domain_invites_approve_request_to_join_team_details",
                                    "domain_invites_decline_request_to_join_team_details",
                                    "domain_invites_email_existing_users_details",
                                    "domain_invites_request_to_join_team_details",
                                    "domain_invites_set_invite_new_user_pref_to_no_details",
                                    "domain_invites_set_invite_new_user_pref_to_yes_details",
                                    "domain_verification_add_domain_fail_details",
                                    "domain_verification_add_domain_success_details",
                                    "domain_verification_remove_domain_details",
                                    "enabled_domain_invites_details",
                                    "apply_naming_convention_details",
                                    "create_folder_details",
                                    "file_add_details",
                                    "file_copy_details",
                                    "file_delete_details",
                                    "file_download_details",
                                    "file_edit_details",
                                    "file_get_copy_reference_details",
                                    "file_locking_lock_status_changed_details",
                                    "file_move_details",
                                    "file_permanently_delete_details",
                                    "file_preview_details",
                                    "file_rename_details",
                                    "file_restore_details",
                                    "file_revert_details",
                                    "file_rollback_changes_details",
                                    "file_save_copy_reference_details",
                                    "folder_overview_description_changed_details",
                                    "folder_overview_item_pinned_details",
                                    "folder_overview_item_unpinned_details",
                                    "object_label_added_details",
                                    "object_label_removed_details",
                                    "object_label_updated_value_details",
                                    "organize_folder_with_tidy_details",
                                    "rewind_folder_details",
                                    "user_tags_added_details",
                                    "user_tags_removed_details",
                                    "file_request_change_details",
                                    "file_request_close_details",
                                    "file_request_create_details",
                                    "file_request_delete_details",
                                    "file_request_receive_file_details",
                                    "group_add_external_id_details",
                                    "group_add_member_details",
                                    "group_change_external_id_details",
                                    "group_change_management_type_details",
                                    "group_change_member_role_details",
                                    "group_create_details",
                                    "group_delete_details",
                                    "group_description_updated_details",
                                    "group_join_policy_updated_details",
                                    "group_moved_details",
                                    "group_remove_external_id_details",
                                    "group_remove_member_details",
                                    "group_rename_details",
                                    "account_lock_or_unlocked_details",
                                    "emm_error_details",
                                    "guest_admin_signed_in_via_trusted_teams_details",
                                    "guest_admin_signed_out_via_trusted_teams_details",
                                    "login_fail_details",
                                    "login_success_details",
                                    "logout_details",
                                    "reseller_support_session_end_details",
                                    "reseller_support_session_start_details",
                                    "sign_in_as_session_end_details",
                                    "sign_in_as_session_start_details",
                                    "sso_error_details",
                                    "create_team_invite_link_details",
                                    "delete_team_invite_link_details",
                                    "member_add_external_id_details",
                                    "member_add_name_details",
                                    "member_change_admin_role_details",
                                    "member_change_email_details",
                                    "member_change_external_id_details",
                                    "member_change_membership_type_details",
                                    "member_change_name_details",
                                    "member_change_reseller_role_details",
                                    "member_change_status_details",
                                    "member_delete_manual_contacts_details",
                                    "member_delete_profile_photo_details",
                                    "member_permanently_delete_account_contents_details",
                                    "member_remove_external_id_details",
                                    "member_set_profile_photo_details",
                                    "member_space_limits_add_custom_quota_details",
                                    "member_space_limits_change_custom_quota_details",
                                    "member_space_limits_change_status_details",
                                    "member_space_limits_remove_custom_quota_details",
                                    "member_suggest_details",
                                    "member_transfer_account_contents_details",
                                    "pending_secondary_email_added_details",
                                    "secondary_email_deleted_details",
                                    "secondary_email_verified_details",
                                    "secondary_mails_policy_changed_details",
                                    "binder_add_page_details",
                                    "binder_add_section_details",
                                    "binder_remove_page_details",
                                    "binder_remove_section_details",
                                    "binder_rename_page_details",
                                    "binder_rename_section_details",
                                    "binder_reorder_page_details",
                                    "binder_reorder_section_details",
                                    "paper_content_add_member_details",
                                    "paper_content_add_to_folder_details",
                                    "paper_content_archive_details",
                                    "paper_content_create_details",
                                    "paper_content_permanently_delete_details",
                                    "paper_content_remove_from_folder_details",
                                    "paper_content_remove_member_details",
                                    "paper_content_rename_details",
                                    "paper_content_restore_details",
                                    "paper_doc_add_comment_details",
                                    "paper_doc_change_member_role_details",
                                    "paper_doc_change_sharing_policy_details",
                                    "paper_doc_change_subscription_details",
                                    "paper_doc_deleted_details",
                                    "paper_doc_delete_comment_details",
                                    "paper_doc_download_details",
                                    "paper_doc_edit_details",
                                    "paper_doc_edit_comment_details",
                                    "paper_doc_followed_details",
                                    "paper_doc_mention_details",
                                    "paper_doc_ownership_changed_details",
                                    "paper_doc_request_access_details",
                                    "paper_doc_resolve_comment_details",
                                    "paper_doc_revert_details",
                                    "paper_doc_slack_share_details",
                                    "paper_doc_team_invite_details",
                                    "paper_doc_trashed_details",
                                    "paper_doc_unresolve_comment_details",
                                    "paper_doc_untrashed_details",
                                    "paper_doc_view_details",
                                    "paper_external_view_allow_details",
                                    "paper_external_view_default_team_details",
                                    "paper_external_view_forbid_details",
                                    "paper_folder_change_subscription_details",
                                    "paper_folder_deleted_details",
                                    "paper_folder_followed_details",
                                    "paper_folder_team_invite_details",
                                    "paper_published_link_change_permission_details",
                                    "paper_published_link_create_details",
                                    "paper_published_link_disabled_details",
                                    "paper_published_link_view_details",
                                    "password_change_details",
                                    "password_reset_details",
                                    "password_reset_all_details",
                                    "classification_create_report_details",
                                    "classification_create_report_fail_details",
                                    "emm_create_exceptions_report_details",
                                    "emm_create_usage_report_details",
                                    "export_members_report_details",
                                    "export_members_report_fail_details",
                                    "external_sharing_create_report_details",
                                    "external_sharing_report_failed_details",
                                    "no_expiration_link_gen_create_report_details",
                                    "no_expiration_link_gen_report_failed_details",
                                    "no_password_link_gen_create_report_details",
                                    "no_password_link_gen_report_failed_details",
                                    "no_password_link_view_create_report_details",
                                    "no_password_link_view_report_failed_details",
                                    "outdated_link_view_create_report_details",
                                    "outdated_link_view_report_failed_details",
                                    "paper_admin_export_start_details",
                                    "smart_sync_create_admin_privilege_report_details",
                                    "team_activity_create_report_details",
                                    "team_activity_create_report_fail_details",
                                    "collection_share_details",
                                    "file_transfers_file_add_details",
                                    "file_transfers_transfer_delete_details",
                                    "file_transfers_transfer_download_details",
                                    "file_transfers_transfer_send_details",
                                    "file_transfers_transfer_view_details",
                                    "note_acl_invite_only_details",
                                    "note_acl_link_details",
                                    "note_acl_team_link_details",
                                    "note_shared_details",
                                    "note_share_receive_details",
                                    "open_note_shared_details",
                                    "sf_add_group_details",
                                    "sf_allow_non_members_to_view_shared_links_details",
                                    "sf_external_invite_warn_details",
                                    "sf_fb_invite_details",
                                    "sf_fb_invite_change_role_details",
                                    "sf_fb_uninvite_details",
                                    "sf_invite_group_details",
                                    "sf_team_grant_access_details",
                                    "sf_team_invite_details",
                                    "sf_team_invite_change_role_details",
                                    "sf_team_join_details",
                                    "sf_team_join_from_oob_link_details",
                                    "sf_team_uninvite_details",
                                    "shared_content_add_invitees_details",
                                    "shared_content_add_link_expiry_details",
                                    "shared_content_add_link_password_details",
                                    "shared_content_add_member_details",
                                    "shared_content_change_downloads_policy_details",
                                    "shared_content_change_invitee_role_details",
                                    "shared_content_change_link_audience_details",
                                    "shared_content_change_link_expiry_details",
                                    "shared_content_change_link_password_details",
                                    "shared_content_change_member_role_details",
                                    "shared_content_change_viewer_info_policy_details",
                                    "shared_content_claim_invitation_details",
                                    "shared_content_copy_details",
                                    "shared_content_download_details",
                                    "shared_content_relinquish_membership_details",
                                    "shared_content_remove_invitees_details",
                                    "shared_content_remove_link_expiry_details",
                                    "shared_content_remove_link_password_details",
                                    "shared_content_remove_member_details",
                                    "shared_content_request_access_details",
                                    "shared_content_restore_invitees_details",
                                    "shared_content_restore_member_details",
                                    "shared_content_unshare_details",
                                    "shared_content_view_details",
                                    "shared_folder_change_link_policy_details",
                                    "shared_folder_change_members_inheritance_policy_details",
                                    "shared_folder_change_members_management_policy_details",
                                    "shared_folder_change_members_policy_details",
                                    "shared_folder_create_details",
                                    "shared_folder_decline_invitation_details",
                                    "shared_folder_mount_details",
                                    "shared_folder_nest_details",
                                    "shared_folder_transfer_ownership_details",
                                    "shared_folder_unmount_details",
                                    "shared_link_add_expiry_details",
                                    "shared_link_change_expiry_details",
                                    "shared_link_change_visibility_details",
                                    "shared_link_copy_details",
                                    "shared_link_create_details",
                                    "shared_link_disable_details",
                                    "shared_link_download_details",
                                    "shared_link_remove_expiry_details",
                                    "shared_link_settings_add_expiration_details",
                                    "shared_link_settings_add_password_details",
                                    "shared_link_settings_allow_download_disabled_details",
                                    "shared_link_settings_allow_download_enabled_details",
                                    "shared_link_settings_change_audience_details",
                                    "shared_link_settings_change_expiration_details",
                                    "shared_link_settings_change_password_details",
                                    "shared_link_settings_remove_expiration_details",
                                    "shared_link_settings_remove_password_details",
                                    "shared_link_share_details",
                                    "shared_link_view_details",
                                    "shared_note_opened_details",
                                    "shmodel_disable_downloads_details",
                                    "shmodel_enable_downloads_details",
                                    "shmodel_group_share_details",
                                    "showcase_access_granted_details",
                                    "showcase_add_member_details",
                                    "showcase_archived_details",
                                    "showcase_created_details",
                                    "showcase_delete_comment_details",
                                    "showcase_edited_details",
                                    "showcase_edit_comment_details",
                                    "showcase_file_added_details",
                                    "showcase_file_download_details",
                                    "showcase_file_removed_details",
                                    "showcase_file_view_details",
                                    "showcase_permanently_deleted_details",
                                    "showcase_post_comment_details",
                                    "showcase_remove_member_details",
                                    "showcase_renamed_details",
                                    "showcase_request_access_details",
                                    "showcase_resolve_comment_details",
                                    "showcase_restored_details",
                                    "showcase_trashed_details",
                                    "showcase_trashed_deprecated_details",
                                    "showcase_unresolve_comment_details",
                                    "showcase_untrashed_details",
                                    "showcase_untrashed_deprecated_details",
                                    "showcase_view_details",
                                    "sso_add_cert_details",
                                    "sso_add_login_url_details",
                                    "sso_add_logout_url_details",
                                    "sso_change_cert_details",
                                    "sso_change_login_url_details",
                                    "sso_change_logout_url_details",
                                    "sso_change_saml_identity_mode_details",
                                    "sso_remove_cert_details",
                                    "sso_remove_login_url_details",
                                    "sso_remove_logout_url_details",
                                    "team_folder_change_status_details",
                                    "team_folder_create_details",
                                    "team_folder_downgrade_details",
                                    "team_folder_permanently_delete_details",
                                    "team_folder_rename_details",
                                    "team_selective_sync_settings_changed_details",
                                    "account_capture_change_policy_details",
                                    "allow_download_disabled_details",
                                    "allow_download_enabled_details",
                                    "app_permissions_changed_details",
                                    "camera_uploads_policy_changed_details",
                                    "classification_change_policy_details",
                                    "computer_backup_policy_changed_details",
                                    "content_administration_policy_changed_details",
                                    "data_placement_restriction_change_policy_details",
                                    "data_placement_restriction_satisfy_policy_details",
                                    "device_approvals_add_exception_details",
                                    "device_approvals_change_desktop_policy_details",
                                    "device_approvals_change_mobile_policy_details",
                                    "device_approvals_change_overage_action_details",
                                    "device_approvals_change_unlink_action_details",
                                    "device_approvals_remove_exception_details",
                                    "directory_restrictions_add_members_details",
                                    "directory_restrictions_remove_members_details",
                                    "emm_add_exception_details",
                                    "emm_change_policy_details",
                                    "emm_remove_exception_details",
                                    "extended_version_history_change_policy_details",
                                    "file_comments_change_policy_details",
                                    "file_locking_policy_changed_details",
                                    "file_requests_change_policy_details",
                                    "file_requests_emails_enabled_details",
                                    "file_requests_emails_restricted_to_team_only_details",
                                    "file_transfers_policy_changed_details",
                                    "google_sso_change_policy_details",
                                    "group_user_management_change_policy_details",
                                    "integration_policy_changed_details",
                                    "invite_acceptance_email_policy_changed_details",
                                    "member_requests_change_policy_details",
                                    "member_send_invite_policy_changed_details",
                                    "member_space_limits_add_exception_details",
                                    "member_space_limits_change_caps_type_policy_details",
                                    "member_space_limits_change_policy_details",
                                    "member_space_limits_remove_exception_details",
                                    "member_suggestions_change_policy_details",
                                    "microsoft_office_addin_change_policy_details",
                                    "network_control_change_policy_details",
                                    "paper_change_deployment_policy_details",
                                    "paper_change_member_link_policy_details",
                                    "paper_change_member_policy_details",
                                    "paper_change_policy_details",
                                    "paper_default_folder_policy_changed_details",
                                    "paper_desktop_policy_changed_details",
                                    "paper_enabled_users_group_addition_details",
                                    "paper_enabled_users_group_removal_details",
                                    "password_strength_requirements_change_policy_details",
                                    "permanent_delete_change_policy_details",
                                    "reseller_support_change_policy_details",
                                    "rewind_policy_changed_details",
                                    "send_for_signature_policy_changed_details",
                                    "sharing_change_folder_join_policy_details",
                                    "sharing_change_link_allow_change_expiration_policy_details",
                                    "sharing_change_link_default_expiration_policy_details",
                                    "sharing_change_link_enforce_password_policy_details",
                                    "sharing_change_link_policy_details",
                                    "sharing_change_member_policy_details",
                                    "showcase_change_download_policy_details",
                                    "showcase_change_enabled_policy_details",
                                    "showcase_change_external_sharing_policy_details",
                                    "smarter_smart_sync_policy_changed_details",
                                    "smart_sync_change_policy_details",
                                    "smart_sync_not_opt_out_details",
                                    "smart_sync_opt_out_details",
                                    "sso_change_policy_details",
                                    "team_branding_policy_changed_details",
                                    "team_extensions_policy_changed_details",
                                    "team_selective_sync_policy_changed_details",
                                    "team_sharing_whitelist_subjects_changed_details",
                                    "tfa_add_exception_details",
                                    "tfa_change_policy_details",
                                    "tfa_remove_exception_details",
                                    "two_account_change_policy_details",
                                    "viewer_info_policy_changed_details",
                                    "watermarking_policy_changed_details",
                                    "web_sessions_change_active_session_limit_details",
                                    "web_sessions_change_fixed_length_policy_details",
                                    "web_sessions_change_idle_length_policy_details",
                                    "team_merge_from_details",
                                    "team_merge_to_details",
                                    "team_profile_add_background_details",
                                    "team_profile_add_logo_details",
                                    "team_profile_change_background_details",
                                    "team_profile_change_default_language_details",
                                    "team_profile_change_logo_details",
                                    "team_profile_change_name_details",
                                    "team_profile_remove_background_details",
                                    "team_profile_remove_logo_details",
                                    "tfa_add_backup_phone_details",
                                    "tfa_add_security_key_details",
                                    "tfa_change_backup_phone_details",
                                    "tfa_change_status_details",
                                    "tfa_remove_backup_phone_details",
                                    "tfa_remove_security_key_details",
                                    "tfa_reset_details",
                                    "changed_enterprise_admin_role_details",
                                    "changed_enterprise_connected_team_status_details",
                                    "ended_enterprise_admin_session_details",
                                    "ended_enterprise_admin_session_deprecated_details",
                                    "enterprise_settings_locking_details",
                                    "guest_admin_change_status_details",
                                    "started_enterprise_admin_session_details",
                                    "team_merge_request_accepted_details",
                                    "team_merge_request_accepted_shown_to_primary_team_details",
                                    "team_merge_request_accepted_shown_to_secondary_team_details",
                                    "team_merge_request_auto_canceled_details",
                                    "team_merge_request_canceled_details",
                                    "team_merge_request_canceled_shown_to_primary_team_details",
                                    "team_merge_request_canceled_shown_to_secondary_team_details",
                                    "team_merge_request_expired_details",
                                    "team_merge_request_expired_shown_to_primary_team_details",
                                    "team_merge_request_expired_shown_to_secondary_team_details",
                                    "team_merge_request_rejected_shown_to_primary_team_details",
                                    "team_merge_request_rejected_shown_to_secondary_team_details",
                                    "team_merge_request_reminder_details",
                                    "team_merge_request_reminder_shown_to_primary_team_details",
                                    "team_merge_request_reminder_shown_to_secondary_team_details",
                                    "team_merge_request_revoked_details",
                                    "team_merge_request_sent_shown_to_primary_team_details",
                                    "team_merge_request_sent_shown_to_secondary_team_details",
                                    "missing_details",
                                    "other"];
        deserializer.deserialize_struct("EventDetails", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for EventDetails {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            EventDetails::AdminAlertingAlertStateChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 7)?;
                s.serialize_field(".tag", "admin_alerting_alert_state_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AdminAlertingChangedAlertConfigDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "admin_alerting_changed_alert_config_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AdminAlertingTriggeredAlertDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "admin_alerting_triggered_alert_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AppBlockedByPermissionsDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "app_blocked_by_permissions_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AppLinkTeamDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "app_link_team_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AppLinkUserDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "app_link_user_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AppUnlinkTeamDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "app_unlink_team_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AppUnlinkUserDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "app_unlink_user_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::IntegrationConnectedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "integration_connected_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::IntegrationDisconnectedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "integration_disconnected_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileAddCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_add_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileChangeCommentSubscriptionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_change_comment_subscription_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileDeleteCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_delete_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileEditCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_edit_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileLikeCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_like_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileResolveCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_resolve_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileUnlikeCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_unlike_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileUnresolveCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_unresolve_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyAddFoldersDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "governance_policy_add_folders_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyAddFolderFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "governance_policy_add_folder_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyContentDisposedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "governance_policy_content_disposed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "governance_policy_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyDeleteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "governance_policy_delete_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyEditDetailsDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 7)?;
                s.serialize_field(".tag", "governance_policy_edit_details_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyEditDurationDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "governance_policy_edit_duration_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyExportCreatedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "governance_policy_export_created_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyExportRemovedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "governance_policy_export_removed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyRemoveFoldersDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "governance_policy_remove_folders_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyReportCreatedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "governance_policy_report_created_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GovernancePolicyZipPartDownloadedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "governance_policy_zip_part_downloaded_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsActivateAHoldDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "legal_holds_activate_a_hold_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsAddMembersDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "legal_holds_add_members_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsChangeHoldDetailsDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "legal_holds_change_hold_details_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsChangeHoldNameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "legal_holds_change_hold_name_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsExportAHoldDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "legal_holds_export_a_hold_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsExportCancelledDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "legal_holds_export_cancelled_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsExportDownloadedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "legal_holds_export_downloaded_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsExportRemovedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "legal_holds_export_removed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsReleaseAHoldDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "legal_holds_release_a_hold_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsRemoveMembersDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "legal_holds_remove_members_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LegalHoldsReportAHoldDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "legal_holds_report_a_hold_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceChangeIpDesktopDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "device_change_ip_desktop_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceChangeIpMobileDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "device_change_ip_mobile_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceChangeIpWebDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "device_change_ip_web_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceDeleteOnUnlinkFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "device_delete_on_unlink_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceDeleteOnUnlinkSuccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "device_delete_on_unlink_success_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceLinkFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "device_link_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceLinkSuccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "device_link_success_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceManagementDisabledDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "device_management_disabled_details")?;
                s.end()
            }
            EventDetails::DeviceManagementEnabledDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "device_management_enabled_details")?;
                s.end()
            }
            EventDetails::DeviceSyncBackupStatusChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "device_sync_backup_status_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeviceUnlinkDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "device_unlink_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DropboxPasswordsExportedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "dropbox_passwords_exported_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DropboxPasswordsNewDeviceEnrolledDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "dropbox_passwords_new_device_enrolled_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::EmmRefreshAuthTokenDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "emm_refresh_auth_token_details")?;
                s.end()
            }
            EventDetails::AccountCaptureChangeAvailabilityDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "account_capture_change_availability_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AccountCaptureMigrateAccountDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "account_capture_migrate_account_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AccountCaptureNotificationEmailsSentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "account_capture_notification_emails_sent_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AccountCaptureRelinquishAccountDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "account_capture_relinquish_account_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DisabledDomainInvitesDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "disabled_domain_invites_details")?;
                s.end()
            }
            EventDetails::DomainInvitesApproveRequestToJoinTeamDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "domain_invites_approve_request_to_join_team_details")?;
                s.end()
            }
            EventDetails::DomainInvitesDeclineRequestToJoinTeamDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "domain_invites_decline_request_to_join_team_details")?;
                s.end()
            }
            EventDetails::DomainInvitesEmailExistingUsersDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "domain_invites_email_existing_users_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DomainInvitesRequestToJoinTeamDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "domain_invites_request_to_join_team_details")?;
                s.end()
            }
            EventDetails::DomainInvitesSetInviteNewUserPrefToNoDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "domain_invites_set_invite_new_user_pref_to_no_details")?;
                s.end()
            }
            EventDetails::DomainInvitesSetInviteNewUserPrefToYesDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "domain_invites_set_invite_new_user_pref_to_yes_details")?;
                s.end()
            }
            EventDetails::DomainVerificationAddDomainFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "domain_verification_add_domain_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DomainVerificationAddDomainSuccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "domain_verification_add_domain_success_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DomainVerificationRemoveDomainDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "domain_verification_remove_domain_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::EnabledDomainInvitesDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "enabled_domain_invites_details")?;
                s.end()
            }
            EventDetails::ApplyNamingConventionDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "apply_naming_convention_details")?;
                s.end()
            }
            EventDetails::CreateFolderDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "create_folder_details")?;
                s.end()
            }
            EventDetails::FileAddDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_add_details")?;
                s.end()
            }
            EventDetails::FileCopyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_copy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileDeleteDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_delete_details")?;
                s.end()
            }
            EventDetails::FileDownloadDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_download_details")?;
                s.end()
            }
            EventDetails::FileEditDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_edit_details")?;
                s.end()
            }
            EventDetails::FileGetCopyReferenceDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_get_copy_reference_details")?;
                s.end()
            }
            EventDetails::FileLockingLockStatusChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_locking_lock_status_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileMoveDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_move_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FilePermanentlyDeleteDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_permanently_delete_details")?;
                s.end()
            }
            EventDetails::FilePreviewDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_preview_details")?;
                s.end()
            }
            EventDetails::FileRenameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_rename_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRestoreDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_restore_details")?;
                s.end()
            }
            EventDetails::FileRevertDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_revert_details")?;
                s.end()
            }
            EventDetails::FileRollbackChangesDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "file_rollback_changes_details")?;
                s.end()
            }
            EventDetails::FileSaveCopyReferenceDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_save_copy_reference_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FolderOverviewDescriptionChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "folder_overview_description_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FolderOverviewItemPinnedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "folder_overview_item_pinned_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FolderOverviewItemUnpinnedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "folder_overview_item_unpinned_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::ObjectLabelAddedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "object_label_added_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::ObjectLabelRemovedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "object_label_removed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::ObjectLabelUpdatedValueDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "object_label_updated_value_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::OrganizeFolderWithTidyDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "organize_folder_with_tidy_details")?;
                s.end()
            }
            EventDetails::RewindFolderDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "rewind_folder_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::UserTagsAddedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "user_tags_added_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::UserTagsRemovedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "user_tags_removed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRequestChangeDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "file_request_change_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRequestCloseDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_request_close_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRequestCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_request_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRequestDeleteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "file_request_delete_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileRequestReceiveFileDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "file_request_receive_file_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupAddExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "group_add_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupAddMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "group_add_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupChangeExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "group_change_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupChangeManagementTypeDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "group_change_management_type_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupChangeMemberRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "group_change_member_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "group_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupDeleteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "group_delete_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupDescriptionUpdatedDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "group_description_updated_details")?;
                s.end()
            }
            EventDetails::GroupJoinPolicyUpdatedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "group_join_policy_updated_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupMovedDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "group_moved_details")?;
                s.end()
            }
            EventDetails::GroupRemoveExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "group_remove_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GroupRemoveMemberDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "group_remove_member_details")?;
                s.end()
            }
            EventDetails::GroupRenameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "group_rename_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::AccountLockOrUnlockedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "account_lock_or_unlocked_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::EmmErrorDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "emm_error_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GuestAdminSignedInViaTrustedTeamsDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "guest_admin_signed_in_via_trusted_teams_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::GuestAdminSignedOutViaTrustedTeamsDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "guest_admin_signed_out_via_trusted_teams_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LoginFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "login_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LoginSuccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "login_success_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::LogoutDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "logout_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::ResellerSupportSessionEndDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "reseller_support_session_end_details")?;
                s.end()
            }
            EventDetails::ResellerSupportSessionStartDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "reseller_support_session_start_details")?;
                s.end()
            }
            EventDetails::SignInAsSessionEndDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "sign_in_as_session_end_details")?;
                s.end()
            }
            EventDetails::SignInAsSessionStartDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "sign_in_as_session_start_details")?;
                s.end()
            }
            EventDetails::SsoErrorDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "sso_error_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::CreateTeamInviteLinkDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "create_team_invite_link_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::DeleteTeamInviteLinkDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "delete_team_invite_link_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberAddExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "member_add_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberAddNameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "member_add_name_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeAdminRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_admin_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeEmailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_email_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeMembershipTypeDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_membership_type_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeNameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_name_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeResellerRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_change_reseller_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberChangeStatusDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 6)?;
                s.serialize_field(".tag", "member_change_status_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberDeleteManualContactsDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_delete_manual_contacts_details")?;
                s.end()
            }
            EventDetails::MemberDeleteProfilePhotoDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_delete_profile_photo_details")?;
                s.end()
            }
            EventDetails::MemberPermanentlyDeleteAccountContentsDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_permanently_delete_account_contents_details")?;
                s.end()
            }
            EventDetails::MemberRemoveExternalIdDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "member_remove_external_id_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberSetProfilePhotoDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_set_profile_photo_details")?;
                s.end()
            }
            EventDetails::MemberSpaceLimitsAddCustomQuotaDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "member_space_limits_add_custom_quota_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberSpaceLimitsChangeCustomQuotaDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_space_limits_change_custom_quota_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberSpaceLimitsChangeStatusDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "member_space_limits_change_status_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberSpaceLimitsRemoveCustomQuotaDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_space_limits_remove_custom_quota_details")?;
                s.end()
            }
            EventDetails::MemberSuggestDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "member_suggest_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::MemberTransferAccountContentsDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "member_transfer_account_contents_details")?;
                s.end()
            }
            EventDetails::PendingSecondaryEmailAddedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "pending_secondary_email_added_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SecondaryEmailDeletedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "secondary_email_deleted_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SecondaryEmailVerifiedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "secondary_email_verified_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SecondaryMailsPolicyChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "secondary_mails_policy_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderAddPageDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_add_page_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderAddSectionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_add_section_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderRemovePageDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_remove_page_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderRemoveSectionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_remove_section_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderRenamePageDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "binder_rename_page_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderRenameSectionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "binder_rename_section_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderReorderPageDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_reorder_page_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::BinderReorderSectionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "binder_reorder_section_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentAddMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_add_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentAddToFolderDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_content_add_to_folder_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentArchiveDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_archive_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentPermanentlyDeleteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_permanently_delete_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentRemoveFromFolderDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_content_remove_from_folder_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentRemoveMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_remove_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentRenameDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_rename_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperContentRestoreDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_content_restore_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocAddCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_add_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocChangeMemberRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_change_member_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocChangeSharingPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_doc_change_sharing_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocChangeSubscriptionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_doc_change_subscription_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocDeletedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_deleted_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocDeleteCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_delete_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocDownloadDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_download_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocEditDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_edit_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocEditCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_edit_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocFollowedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_followed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocMentionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_mention_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocOwnershipChangedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_doc_ownership_changed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocRequestAccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_request_access_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocResolveCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_resolve_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocRevertDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_revert_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocSlackShareDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_slack_share_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocTeamInviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_team_invite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocTrashedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_trashed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocUnresolveCommentDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "paper_doc_unresolve_comment_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocUntrashedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_untrashed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperDocViewDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_doc_view_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperExternalViewAllowDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_external_view_allow_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperExternalViewDefaultTeamDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_external_view_default_team_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperExternalViewForbidDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_external_view_forbid_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperFolderChangeSubscriptionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_folder_change_subscription_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperFolderDeletedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_folder_deleted_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperFolderFollowedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_folder_followed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperFolderTeamInviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_folder_team_invite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperPublishedLinkChangePermissionDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "paper_published_link_change_permission_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperPublishedLinkCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_published_link_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperPublishedLinkDisabledDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_published_link_disabled_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperPublishedLinkViewDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "paper_published_link_view_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PasswordChangeDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "password_change_details")?;
                s.end()
            }
            EventDetails::PasswordResetDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "password_reset_details")?;
                s.end()
            }
            EventDetails::PasswordResetAllDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "password_reset_all_details")?;
                s.end()
            }
            EventDetails::ClassificationCreateReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "classification_create_report_details")?;
                s.end()
            }
            EventDetails::ClassificationCreateReportFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "classification_create_report_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::EmmCreateExceptionsReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "emm_create_exceptions_report_details")?;
                s.end()
            }
            EventDetails::EmmCreateUsageReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "emm_create_usage_report_details")?;
                s.end()
            }
            EventDetails::ExportMembersReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "export_members_report_details")?;
                s.end()
            }
            EventDetails::ExportMembersReportFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "export_members_report_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::ExternalSharingCreateReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "external_sharing_create_report_details")?;
                s.end()
            }
            EventDetails::ExternalSharingReportFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "external_sharing_report_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoExpirationLinkGenCreateReportDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "no_expiration_link_gen_create_report_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoExpirationLinkGenReportFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "no_expiration_link_gen_report_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoPasswordLinkGenCreateReportDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "no_password_link_gen_create_report_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoPasswordLinkGenReportFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "no_password_link_gen_report_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoPasswordLinkViewCreateReportDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "no_password_link_view_create_report_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoPasswordLinkViewReportFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "no_password_link_view_report_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::OutdatedLinkViewCreateReportDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "outdated_link_view_create_report_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::OutdatedLinkViewReportFailedDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "outdated_link_view_report_failed_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::PaperAdminExportStartDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "paper_admin_export_start_details")?;
                s.end()
            }
            EventDetails::SmartSyncCreateAdminPrivilegeReportDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "smart_sync_create_admin_privilege_report_details")?;
                s.end()
            }
            EventDetails::TeamActivityCreateReportDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "team_activity_create_report_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::TeamActivityCreateReportFailDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "team_activity_create_report_fail_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::CollectionShareDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "collection_share_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileTransfersFileAddDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_transfers_file_add_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileTransfersTransferDeleteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_transfers_transfer_delete_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileTransfersTransferDownloadDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_transfers_transfer_download_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileTransfersTransferSendDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_transfers_transfer_send_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::FileTransfersTransferViewDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "file_transfers_transfer_view_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::NoteAclInviteOnlyDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "note_acl_invite_only_details")?;
                s.end()
            }
            EventDetails::NoteAclLinkDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "note_acl_link_details")?;
                s.end()
            }
            EventDetails::NoteAclTeamLinkDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "note_acl_team_link_details")?;
                s.end()
            }
            EventDetails::NoteSharedDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "note_shared_details")?;
                s.end()
            }
            EventDetails::NoteShareReceiveDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "note_share_receive_details")?;
                s.end()
            }
            EventDetails::OpenNoteSharedDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "open_note_shared_details")?;
                s.end()
            }
            EventDetails::SfAddGroupDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "sf_add_group_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfAllowNonMembersToViewSharedLinksDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "sf_allow_non_members_to_view_shared_links_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfExternalInviteWarnDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "sf_external_invite_warn_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfFbInviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "sf_fb_invite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfFbInviteChangeRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "sf_fb_invite_change_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfFbUninviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "sf_fb_uninvite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfInviteGroupDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "sf_invite_group_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamGrantAccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "sf_team_grant_access_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamInviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "sf_team_invite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamInviteChangeRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "sf_team_invite_change_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamJoinDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "sf_team_join_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamJoinFromOobLinkDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "sf_team_join_from_oob_link_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SfTeamUninviteDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "sf_team_uninvite_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentAddInviteesDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_add_invitees_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentAddLinkExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_add_link_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentAddLinkPasswordDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_content_add_link_password_details")?;
                s.end()
            }
            EventDetails::SharedContentAddMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_add_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeDownloadsPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_change_downloads_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeInviteeRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "shared_content_change_invitee_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeLinkAudienceDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_change_link_audience_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeLinkExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_change_link_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeLinkPasswordDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_content_change_link_password_details")?;
                s.end()
            }
            EventDetails::SharedContentChangeMemberRoleDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_change_member_role_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentChangeViewerInfoPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_change_viewer_info_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentClaimInvitationDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_claim_invitation_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentCopyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "shared_content_copy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentDownloadDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "shared_content_download_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRelinquishMembershipDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_content_relinquish_membership_details")?;
                s.end()
            }
            EventDetails::SharedContentRemoveInviteesDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_remove_invitees_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRemoveLinkExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_remove_link_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRemoveLinkPasswordDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_content_remove_link_password_details")?;
                s.end()
            }
            EventDetails::SharedContentRemoveMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_remove_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRequestAccessDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_request_access_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRestoreInviteesDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_content_restore_invitees_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentRestoreMemberDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_content_restore_member_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedContentUnshareDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_content_unshare_details")?;
                s.end()
            }
            EventDetails::SharedContentViewDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "shared_content_view_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderChangeLinkPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_folder_change_link_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderChangeMembersInheritancePolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_folder_change_members_inheritance_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderChangeMembersManagementPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_folder_change_members_management_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderChangeMembersPolicyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_folder_change_members_policy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_folder_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderDeclineInvitationDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_folder_decline_invitation_details")?;
                s.end()
            }
            EventDetails::SharedFolderMountDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_folder_mount_details")?;
                s.end()
            }
            EventDetails::SharedFolderNestDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "shared_folder_nest_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderTransferOwnershipDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_folder_transfer_ownership_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedFolderUnmountDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_folder_unmount_details")?;
                s.end()
            }
            EventDetails::SharedLinkAddExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_add_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkChangeExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_change_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkChangeVisibilityDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_change_visibility_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkCopyDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_copy_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkCreateDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_create_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkDisableDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_disable_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkDownloadDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_download_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkRemoveExpiryDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_remove_expiry_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsAddExpirationDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "shared_link_settings_add_expiration_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsAddPasswordDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_settings_add_password_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsAllowDownloadDisabledDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_settings_allow_download_disabled_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsAllowDownloadEnabledDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_settings_allow_download_enabled_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsChangeAudienceDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "shared_link_settings_change_audience_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsChangeExpirationDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 5)?;
                s.serialize_field(".tag", "shared_link_settings_change_expiration_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsChangePasswordDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_settings_change_password_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsRemoveExpirationDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 4)?;
                s.serialize_field(".tag", "shared_link_settings_remove_expiration_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkSettingsRemovePasswordDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_settings_remove_password_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkShareDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 3)?;
                s.serialize_field(".tag", "shared_link_share_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedLinkViewDetails(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 2)?;
                s.serialize_field(".tag", "shared_link_view_details")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            EventDetails::SharedNoteOpenedDetails(_) => {
                // struct
                let mut s = serializer.serialize_struct("EventDetails", 1)?;
                s.serialize_field(".tag", "shared_note_opened_details")?;
                s.end()
            }
            EventDetails::ShmodelDisableDownloadsDetails(ref x) =