// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

//! This namespace contains endpoints and data types for file request operations.

pub type FileRequestId = String;
pub type FileRequestValidationError = Option<String>;

/// Returns the total number of file requests owned by this user. Includes both open and closed file
/// requests.
pub fn count(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<CountFileRequestsResult, CountFileRequestsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/count",
        &(),
        None)
}

/// Creates a file request for this user.
pub fn create(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateFileRequestArgs,
) -> crate::Result<Result<FileRequest, CreateFileRequestError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/create",
        arg,
        None)
}

/// Delete a batch of closed file requests.
pub fn delete(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &DeleteFileRequestArgs,
) -> crate::Result<Result<DeleteFileRequestsResult, DeleteFileRequestError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/delete",
        arg,
        None)
}

/// Delete all closed file requests owned by this user.
pub fn delete_all_closed(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<DeleteAllClosedFileRequestsResult, DeleteAllClosedFileRequestsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/delete_all_closed",
        &(),
        None)
}

/// Returns the specified file request.
pub fn get(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetFileRequestArgs,
) -> crate::Result<Result<FileRequest, GetFileRequestError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/get",
        arg,
        None)
}

/// Returns a list of file requests owned by this user. For apps with the app folder permission,
/// this will only return file requests with destinations in the app folder.
pub fn list_v2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFileRequestsArg,
) -> crate::Result<Result<ListFileRequestsV2Result, ListFileRequestsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/list_v2",
        arg,
        None)
}

/// Returns a list of file requests owned by this user. For apps with the app folder permission,
/// this will only return file requests with destinations in the app folder.
pub fn list(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<ListFileRequestsResult, ListFileRequestsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/list",
        &(),
        None)
}

/// Once a cursor has been retrieved from [`list_v2()`](list_v2), use this to paginate through all
/// file requests. The cursor must come from a previous call to [`list_v2()`](list_v2) or
/// [`list_continue()`](list_continue).
pub fn list_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFileRequestsContinueArg,
) -> crate::Result<Result<ListFileRequestsV2Result, ListFileRequestsContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/list/continue",
        arg,
        None)
}

/// Update a file request.
pub fn update(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UpdateFileRequestArgs,
) -> crate::Result<Result<FileRequest, UpdateFileRequestError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "file_requests/update",
        arg,
        None)
}

/// There was an error counting the file requests.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CountFileRequestsError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CountFileRequestsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CountFileRequestsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CountFileRequestsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => CountFileRequestsError::DisabledForTeam,
                    _ => CountFileRequestsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other"];
        deserializer.deserialize_struct("CountFileRequestsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CountFileRequestsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CountFileRequestsError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("CountFileRequestsError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            CountFileRequestsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CountFileRequestsError {
}

impl ::std::fmt::Display for CountFileRequestsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CountFileRequestsError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result for [`count()`](count).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CountFileRequestsResult {
    /// The number file requests owner by this user.
    pub file_request_count: u64,
}

impl CountFileRequestsResult {
    pub fn new(file_request_count: u64) -> Self {
        CountFileRequestsResult {
            file_request_count,
        }
    }
}

const COUNT_FILE_REQUESTS_RESULT_FIELDS: &[&str] = &["file_request_count"];
impl CountFileRequestsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CountFileRequestsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CountFileRequestsResult>, V::Error> {
        let mut field_file_request_count = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file_request_count" => {
                    if field_file_request_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_request_count"));
                    }
                    field_file_request_count = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CountFileRequestsResult {
            file_request_count: field_file_request_count.ok_or_else(|| ::serde::de::Error::missing_field("file_request_count"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file_request_count", &self.file_request_count)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CountFileRequestsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CountFileRequestsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CountFileRequestsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CountFileRequestsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CountFileRequestsResult", COUNT_FILE_REQUESTS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CountFileRequestsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CountFileRequestsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`create()`](create).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateFileRequestArgs {
    /// The title of the file request. Must not be empty.
    pub title: String,
    /// The path of the folder in the Dropbox where uploaded files will be sent. For apps with the
    /// app folder permission, this will be relative to the app folder.
    pub destination: super::files::Path,
    /// The deadline for the file request. Deadlines can only be set by Professional and Business
    /// accounts.
    pub deadline: Option<FileRequestDeadline>,
    /// Whether or not the file request should be open. If the file request is closed, it will not
    /// accept any file submissions, but it can be opened later.
    pub open: bool,
    /// A description of the file request.
    pub description: Option<String>,
}

impl CreateFileRequestArgs {
    pub fn new(title: String, destination: super::files::Path) -> Self {
        CreateFileRequestArgs {
            title,
            destination,
            deadline: None,
            open: true,
            description: None,
        }
    }

    pub fn with_deadline(mut self, value: FileRequestDeadline) -> Self {
        self.deadline = Some(value);
        self
    }

    pub fn with_open(mut self, value: bool) -> Self {
        self.open = value;
        self
    }

    pub fn with_description(mut self, value: String) -> Self {
        self.description = Some(value);
        self
    }
}

const CREATE_FILE_REQUEST_ARGS_FIELDS: &[&str] = &["title",
                                                   "destination",
                                                   "deadline",
                                                   "open",
                                                   "description"];
impl CreateFileRequestArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateFileRequestArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateFileRequestArgs>, V::Error> {
        let mut field_title = None;
        let mut field_destination = None;
        let mut field_deadline = None;
        let mut field_open = None;
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "title" => {
                    if field_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("title"));
                    }
                    field_title = Some(map.next_value()?);
                }
                "destination" => {
                    if field_destination.is_some() {
                        return Err(::serde::de::Error::duplicate_field("destination"));
                    }
                    field_destination = Some(map.next_value()?);
                }
                "deadline" => {
                    if field_deadline.is_some() {
                        return Err(::serde::de::Error::duplicate_field("deadline"));
                    }
                    field_deadline = Some(map.next_value()?);
                }
                "open" => {
                    if field_open.is_some() {
                        return Err(::serde::de::Error::duplicate_field("open"));
                    }
                    field_open = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateFileRequestArgs {
            title: field_title.ok_or_else(|| ::serde::de::Error::missing_field("title"))?,
            destination: field_destination.ok_or_else(|| ::serde::de::Error::missing_field("destination"))?,
            deadline: field_deadline,
            open: field_open.unwrap_or(true),
            description: field_description,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("title", &self.title)?;
        s.serialize_field("destination", &self.destination)?;
        if let Some(val) = &self.deadline {
            s.serialize_field("deadline", val)?;
        }
        s.serialize_field("open", &self.open)?;
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFileRequestArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateFileRequestArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFileRequestArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateFileRequestArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateFileRequestArgs", CREATE_FILE_REQUEST_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFileRequestArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateFileRequestArgs", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There was an error creating the file request.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateFileRequestError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// File requests are not available on the specified folder.
    InvalidLocation,
    /// The user has reached the rate limit for creating file requests. The limit is currently 4000
    /// file requests total.
    RateLimit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateFileRequestError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateFileRequestError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateFileRequestError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => CreateFileRequestError::DisabledForTeam,
                    "not_found" => CreateFileRequestError::NotFound,
                    "not_a_folder" => CreateFileRequestError::NotAFolder,
                    "app_lacks_access" => CreateFileRequestError::AppLacksAccess,
                    "no_permission" => CreateFileRequestError::NoPermission,
                    "email_unverified" => CreateFileRequestError::EmailUnverified,
                    "validation_error" => CreateFileRequestError::ValidationError,
                    "invalid_location" => CreateFileRequestError::InvalidLocation,
                    "rate_limit" => CreateFileRequestError::RateLimit,
                    _ => CreateFileRequestError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error",
                                    "invalid_location",
                                    "rate_limit"];
        deserializer.deserialize_struct("CreateFileRequestError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateFileRequestError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateFileRequestError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            CreateFileRequestError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            CreateFileRequestError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            CreateFileRequestError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            CreateFileRequestError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            CreateFileRequestError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            CreateFileRequestError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            CreateFileRequestError::InvalidLocation => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "invalid_location")?;
                s.end()
            }
            CreateFileRequestError::RateLimit => {
                // unit
                let mut s = serializer.serialize_struct("CreateFileRequestError", 1)?;
                s.serialize_field(".tag", "rate_limit")?;
                s.end()
            }
            CreateFileRequestError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CreateFileRequestError {
}

impl ::std::fmt::Display for CreateFileRequestError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateFileRequestError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            CreateFileRequestError::NotFound => f.write_str("This file request ID was not found."),
            CreateFileRequestError::NotAFolder => f.write_str("The specified path is not a folder."),
            CreateFileRequestError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            CreateFileRequestError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            CreateFileRequestError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            CreateFileRequestError::InvalidLocation => f.write_str("File requests are not available on the specified folder."),
            CreateFileRequestError::RateLimit => f.write_str("The user has reached the rate limit for creating file requests. The limit is currently 4000 file requests total."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// There was an error deleting all closed file requests.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteAllClosedFileRequestsError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteAllClosedFileRequestsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteAllClosedFileRequestsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteAllClosedFileRequestsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => DeleteAllClosedFileRequestsError::DisabledForTeam,
                    "not_found" => DeleteAllClosedFileRequestsError::NotFound,
                    "not_a_folder" => DeleteAllClosedFileRequestsError::NotAFolder,
                    "app_lacks_access" => DeleteAllClosedFileRequestsError::AppLacksAccess,
                    "no_permission" => DeleteAllClosedFileRequestsError::NoPermission,
                    "email_unverified" => DeleteAllClosedFileRequestsError::EmailUnverified,
                    "validation_error" => DeleteAllClosedFileRequestsError::ValidationError,
                    _ => DeleteAllClosedFileRequestsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error"];
        deserializer.deserialize_struct("DeleteAllClosedFileRequestsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteAllClosedFileRequestsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteAllClosedFileRequestsError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            DeleteAllClosedFileRequestsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DeleteAllClosedFileRequestsError {
}

impl ::std::fmt::Display for DeleteAllClosedFileRequestsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DeleteAllClosedFileRequestsError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            DeleteAllClosedFileRequestsError::NotFound => f.write_str("This file request ID was not found."),
            DeleteAllClosedFileRequestsError::NotAFolder => f.write_str("The specified path is not a folder."),
            DeleteAllClosedFileRequestsError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            DeleteAllClosedFileRequestsError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            DeleteAllClosedFileRequestsError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result for [`delete_all_closed()`](delete_all_closed).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteAllClosedFileRequestsResult {
    /// The file requests deleted for this user.
    pub file_requests: Vec<FileRequest>,
}

impl DeleteAllClosedFileRequestsResult {
    pub fn new(file_requests: Vec<FileRequest>) -> Self {
        DeleteAllClosedFileRequestsResult {
            file_requests,
        }
    }
}

const DELETE_ALL_CLOSED_FILE_REQUESTS_RESULT_FIELDS: &[&str] = &["file_requests"];
impl DeleteAllClosedFileRequestsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteAllClosedFileRequestsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteAllClosedFileRequestsResult>, V::Error> {
        let mut field_file_requests = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file_requests" => {
                    if field_file_requests.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_requests"));
                    }
                    field_file_requests = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteAllClosedFileRequestsResult {
            file_requests: field_file_requests.ok_or_else(|| ::serde::de::Error::missing_field("file_requests"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file_requests", &self.file_requests)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteAllClosedFileRequestsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteAllClosedFileRequestsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteAllClosedFileRequestsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteAllClosedFileRequestsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteAllClosedFileRequestsResult", DELETE_ALL_CLOSED_FILE_REQUESTS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteAllClosedFileRequestsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteAllClosedFileRequestsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`delete()`](delete).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteFileRequestArgs {
    /// List IDs of the file requests to delete.
    pub ids: Vec<FileRequestId>,
}

impl DeleteFileRequestArgs {
    pub fn new(ids: Vec<FileRequestId>) -> Self {
        DeleteFileRequestArgs {
            ids,
        }
    }
}

const DELETE_FILE_REQUEST_ARGS_FIELDS: &[&str] = &["ids"];
impl DeleteFileRequestArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteFileRequestArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteFileRequestArgs>, V::Error> {
        let mut field_ids = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "ids" => {
                    if field_ids.is_some() {
                        return Err(::serde::de::Error::duplicate_field("ids"));
                    }
                    field_ids = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteFileRequestArgs {
            ids: field_ids.ok_or_else(|| ::serde::de::Error::missing_field("ids"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("ids", &self.ids)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteFileRequestArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteFileRequestArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteFileRequestArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteFileRequestArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteFileRequestArgs", DELETE_FILE_REQUEST_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteFileRequestArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteFileRequestArgs", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There was an error deleting these file requests.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum DeleteFileRequestError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// One or more file requests currently open.
    FileRequestOpen,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteFileRequestError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = DeleteFileRequestError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteFileRequestError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => DeleteFileRequestError::DisabledForTeam,
                    "not_found" => DeleteFileRequestError::NotFound,
                    "not_a_folder" => DeleteFileRequestError::NotAFolder,
                    "app_lacks_access" => DeleteFileRequestError::AppLacksAccess,
                    "no_permission" => DeleteFileRequestError::NoPermission,
                    "email_unverified" => DeleteFileRequestError::EmailUnverified,
                    "validation_error" => DeleteFileRequestError::ValidationError,
                    "file_request_open" => DeleteFileRequestError::FileRequestOpen,
                    _ => DeleteFileRequestError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error",
                                    "file_request_open"];
        deserializer.deserialize_struct("DeleteFileRequestError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteFileRequestError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            DeleteFileRequestError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            DeleteFileRequestError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            DeleteFileRequestError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            DeleteFileRequestError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            DeleteFileRequestError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            DeleteFileRequestError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            DeleteFileRequestError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            DeleteFileRequestError::FileRequestOpen => {
                // unit
                let mut s = serializer.serialize_struct("DeleteFileRequestError", 1)?;
                s.serialize_field(".tag", "file_request_open")?;
                s.end()
            }
            DeleteFileRequestError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for DeleteFileRequestError {
}

impl ::std::fmt::Display for DeleteFileRequestError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            DeleteFileRequestError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            DeleteFileRequestError::NotFound => f.write_str("This file request ID was not found."),
            DeleteFileRequestError::NotAFolder => f.write_str("The specified path is not a folder."),
            DeleteFileRequestError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            DeleteFileRequestError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            DeleteFileRequestError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            DeleteFileRequestError::FileRequestOpen => f.write_str("One or more file requests currently open."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result for [`delete()`](delete).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct DeleteFileRequestsResult {
    /// The file requests deleted by the request.
    pub file_requests: Vec<FileRequest>,
}

impl DeleteFileRequestsResult {
    pub fn new(file_requests: Vec<FileRequest>) -> Self {
        DeleteFileRequestsResult {
            file_requests,
        }
    }
}

const DELETE_FILE_REQUESTS_RESULT_FIELDS: &[&str] = &["file_requests"];
impl DeleteFileRequestsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<DeleteFileRequestsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<DeleteFileRequestsResult>, V::Error> {
        let mut field_file_requests = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file_requests" => {
                    if field_file_requests.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_requests"));
                    }
                    field_file_requests = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = DeleteFileRequestsResult {
            file_requests: field_file_requests.ok_or_else(|| ::serde::de::Error::missing_field("file_requests"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file_requests", &self.file_requests)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for DeleteFileRequestsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = DeleteFileRequestsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a DeleteFileRequestsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                DeleteFileRequestsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("DeleteFileRequestsResult", DELETE_FILE_REQUESTS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for DeleteFileRequestsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("DeleteFileRequestsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// A [file request](https://www.dropbox.com/help/9090) for receiving files into the user's Dropbox
/// account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileRequest {
    /// The ID of the file request.
    pub id: FileRequestId,
    /// The URL of the file request.
    pub url: String,
    /// The title of the file request.
    pub title: String,
    /// When this file request was created.
    pub created: super::common::DropboxTimestamp,
    /// Whether or not the file request is open. If the file request is closed, it will not accept
    /// any more file submissions.
    pub is_open: bool,
    /// The number of files this file request has received.
    pub file_count: i64,
    /// The path of the folder in the Dropbox where uploaded files will be sent. This can be `None`
    /// if the destination was removed. For apps with the app folder permission, this will be
    /// relative to the app folder.
    pub destination: Option<super::files::Path>,
    /// The deadline for this file request. Only set if the request has a deadline.
    pub deadline: Option<FileRequestDeadline>,
    /// A description of the file request.
    pub description: Option<String>,
}

impl FileRequest {
    pub fn new(
        id: FileRequestId,
        url: String,
        title: String,
        created: super::common::DropboxTimestamp,
        is_open: bool,
        file_count: i64,
    ) -> Self {
        FileRequest {
            id,
            url,
            title,
            created,
            is_open,
            file_count,
            destination: None,
            deadline: None,
            description: None,
        }
    }

    pub fn with_destination(mut self, value: super::files::Path) -> Self {
        self.destination = Some(value);
        self
    }

    pub fn with_deadline(mut self, value: FileRequestDeadline) -> Self {
        self.deadline = Some(value);
        self
    }

    pub fn with_description(mut self, value: String) -> Self {
        self.description = Some(value);
        self
    }
}

const FILE_REQUEST_FIELDS: &[&str] = &["id",
                                       "url",
                                       "title",
                                       "created",
                                       "is_open",
                                       "file_count",
                                       "destination",
                                       "deadline",
                                       "description"];
impl FileRequest {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileRequest, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileRequest>, V::Error> {
        let mut field_id = None;
        let mut field_url = None;
        let mut field_title = None;
        let mut field_created = None;
        let mut field_is_open = None;
        let mut field_file_count = None;
        let mut field_destination = None;
        let mut field_deadline = None;
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "title" => {
                    if field_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("title"));
                    }
                    field_title = Some(map.next_value()?);
                }
                "created" => {
                    if field_created.is_some() {
                        return Err(::serde::de::Error::duplicate_field("created"));
                    }
                    field_created = Some(map.next_value()?);
                }
                "is_open" => {
                    if field_is_open.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_open"));
                    }
                    field_is_open = Some(map.next_value()?);
                }
                "file_count" => {
                    if field_file_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_count"));
                    }
                    field_file_count = Some(map.next_value()?);
                }
                "destination" => {
                    if field_destination.is_some() {
                        return Err(::serde::de::Error::duplicate_field("destination"));
                    }
                    field_destination = Some(map.next_value()?);
                }
                "deadline" => {
                    if field_deadline.is_some() {
                        return Err(::serde::de::Error::duplicate_field("deadline"));
                    }
                    field_deadline = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileRequest {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            title: field_title.ok_or_else(|| ::serde::de::Error::missing_field("title"))?,
            created: field_created.ok_or_else(|| ::serde::de::Error::missing_field("created"))?,
            is_open: field_is_open.ok_or_else(|| ::serde::de::Error::missing_field("is_open"))?,
            file_count: field_file_count.ok_or_else(|| ::serde::de::Error::missing_field("file_count"))?,
            destination: field_destination,
            deadline: field_deadline,
            description: field_description,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("title", &self.title)?;
        s.serialize_field("created", &self.created)?;
        s.serialize_field("is_open", &self.is_open)?;
        s.serialize_field("file_count", &self.file_count)?;
        if let Some(val) = &self.destination {
            s.serialize_field("destination", val)?;
        }
        if let Some(val) = &self.deadline {
            s.serialize_field("deadline", val)?;
        }
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileRequest {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileRequest;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileRequest struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileRequest::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileRequest", FILE_REQUEST_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileRequest {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileRequest", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileRequestDeadline {
    /// The deadline for this file request.
    pub deadline: super::common::DropboxTimestamp,
    /// If set, allow uploads after the deadline has passed. These     uploads will be marked
    /// overdue.
    pub allow_late_uploads: Option<GracePeriod>,
}

impl FileRequestDeadline {
    pub fn new(deadline: super::common::DropboxTimestamp) -> Self {
        FileRequestDeadline {
            deadline,
            allow_late_uploads: None,
        }
    }

    pub fn with_allow_late_uploads(mut self, value: GracePeriod) -> Self {
        self.allow_late_uploads = Some(value);
        self
    }
}

const FILE_REQUEST_DEADLINE_FIELDS: &[&str] = &["deadline",
                                                "allow_late_uploads"];
impl FileRequestDeadline {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileRequestDeadline, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileRequestDeadline>, V::Error> {
        let mut field_deadline = None;
        let mut field_allow_late_uploads = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "deadline" => {
                    if field_deadline.is_some() {
                        return Err(::serde::de::Error::duplicate_field("deadline"));
                    }
                    field_deadline = Some(map.next_value()?);
                }
                "allow_late_uploads" => {
                    if field_allow_late_uploads.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow_late_uploads"));
                    }
                    field_allow_late_uploads = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileRequestDeadline {
            deadline: field_deadline.ok_or_else(|| ::serde::de::Error::missing_field("deadline"))?,
            allow_late_uploads: field_allow_late_uploads,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("deadline", &self.deadline)?;
        if let Some(val) = &self.allow_late_uploads {
            s.serialize_field("allow_late_uploads", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileRequestDeadline {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileRequestDeadline;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileRequestDeadline struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileRequestDeadline::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileRequestDeadline", FILE_REQUEST_DEADLINE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileRequestDeadline {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileRequestDeadline", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There is an error with the file request.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileRequestError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileRequestError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileRequestError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileRequestError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => FileRequestError::DisabledForTeam,
                    "not_found" => FileRequestError::NotFound,
                    "not_a_folder" => FileRequestError::NotAFolder,
                    "app_lacks_access" => FileRequestError::AppLacksAccess,
                    "no_permission" => FileRequestError::NoPermission,
                    "email_unverified" => FileRequestError::EmailUnverified,
                    "validation_error" => FileRequestError::ValidationError,
                    _ => FileRequestError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error"];
        deserializer.deserialize_struct("FileRequestError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileRequestError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileRequestError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            FileRequestError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            FileRequestError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            FileRequestError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            FileRequestError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            FileRequestError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            FileRequestError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("FileRequestError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            FileRequestError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for FileRequestError {
}

impl ::std::fmt::Display for FileRequestError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            FileRequestError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            FileRequestError::NotFound => f.write_str("This file request ID was not found."),
            FileRequestError::NotAFolder => f.write_str("The specified path is not a folder."),
            FileRequestError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            FileRequestError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            FileRequestError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// There is an error accessing the file requests functionality.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GeneralFileRequestsError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GeneralFileRequestsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GeneralFileRequestsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GeneralFileRequestsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => GeneralFileRequestsError::DisabledForTeam,
                    _ => GeneralFileRequestsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other"];
        deserializer.deserialize_struct("GeneralFileRequestsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GeneralFileRequestsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GeneralFileRequestsError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("GeneralFileRequestsError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            GeneralFileRequestsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GeneralFileRequestsError {
}

impl ::std::fmt::Display for GeneralFileRequestsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GeneralFileRequestsError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Arguments for [`get()`](get).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetFileRequestArgs {
    /// The ID of the file request to retrieve.
    pub id: FileRequestId,
}

impl GetFileRequestArgs {
    pub fn new(id: FileRequestId) -> Self {
        GetFileRequestArgs {
            id,
        }
    }
}

const GET_FILE_REQUEST_ARGS_FIELDS: &[&str] = &["id"];
impl GetFileRequestArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetFileRequestArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetFileRequestArgs>, V::Error> {
        let mut field_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetFileRequestArgs {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileRequestArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetFileRequestArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileRequestArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetFileRequestArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetFileRequestArgs", GET_FILE_REQUEST_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileRequestArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetFileRequestArgs", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There was an error retrieving the specified file request.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetFileRequestError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileRequestError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetFileRequestError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileRequestError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => GetFileRequestError::DisabledForTeam,
                    "not_found" => GetFileRequestError::NotFound,
                    "not_a_folder" => GetFileRequestError::NotAFolder,
                    "app_lacks_access" => GetFileRequestError::AppLacksAccess,
                    "no_permission" => GetFileRequestError::NoPermission,
                    "email_unverified" => GetFileRequestError::EmailUnverified,
                    "validation_error" => GetFileRequestError::ValidationError,
                    _ => GetFileRequestError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error"];
        deserializer.deserialize_struct("GetFileRequestError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileRequestError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetFileRequestError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            GetFileRequestError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            GetFileRequestError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            GetFileRequestError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            GetFileRequestError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            GetFileRequestError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            GetFileRequestError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("GetFileRequestError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            GetFileRequestError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetFileRequestError {
}

impl ::std::fmt::Display for GetFileRequestError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetFileRequestError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            GetFileRequestError::NotFound => f.write_str("This file request ID was not found."),
            GetFileRequestError::NotAFolder => f.write_str("The specified path is not a folder."),
            GetFileRequestError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            GetFileRequestError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            GetFileRequestError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GracePeriod {
    OneDay,
    TwoDays,
    SevenDays,
    ThirtyDays,
    Always,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GracePeriod {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GracePeriod;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GracePeriod structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "one_day" => GracePeriod::OneDay,
                    "two_days" => GracePeriod::TwoDays,
                    "seven_days" => GracePeriod::SevenDays,
                    "thirty_days" => GracePeriod::ThirtyDays,
                    "always" => GracePeriod::Always,
                    _ => GracePeriod::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["one_day",
                                    "two_days",
                                    "seven_days",
                                    "thirty_days",
                                    "always",
                                    "other"];
        deserializer.deserialize_struct("GracePeriod", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GracePeriod {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GracePeriod::OneDay => {
                // unit
                let mut s = serializer.serialize_struct("GracePeriod", 1)?;
                s.serialize_field(".tag", "one_day")?;
                s.end()
            }
            GracePeriod::TwoDays => {
                // unit
                let mut s = serializer.serialize_struct("GracePeriod", 1)?;
                s.serialize_field(".tag", "two_days")?;
                s.end()
            }
            GracePeriod::SevenDays => {
                // unit
                let mut s = serializer.serialize_struct("GracePeriod", 1)?;
                s.serialize_field(".tag", "seven_days")?;
                s.end()
            }
            GracePeriod::ThirtyDays => {
                // unit
                let mut s = serializer.serialize_struct("GracePeriod", 1)?;
                s.serialize_field(".tag", "thirty_days")?;
                s.end()
            }
            GracePeriod::Always => {
                // unit
                let mut s = serializer.serialize_struct("GracePeriod", 1)?;
                s.serialize_field(".tag", "always")?;
                s.end()
            }
            GracePeriod::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Arguments for [`list_v2()`](list_v2).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileRequestsArg {
    /// The maximum number of file requests that should be returned per request.
    pub limit: u64,
}

impl Default for ListFileRequestsArg {
    fn default() -> Self {
        ListFileRequestsArg {
            limit: 1000,
        }
    }
}

impl ListFileRequestsArg {
    pub fn with_limit(mut self, value: u64) -> Self {
        self.limit = value;
        self
    }
}

const LIST_FILE_REQUESTS_ARG_FIELDS: &[&str] = &["limit"];
impl ListFileRequestsArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListFileRequestsArg, V::Error> {
        let mut field_limit = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListFileRequestsArg {
            limit: field_limit.unwrap_or(1000),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileRequestsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileRequestsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileRequestsArg", LIST_FILE_REQUESTS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileRequestsArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileRequestsContinueArg {
    /// The cursor returned by the previous API call specified in the endpoint description.
    pub cursor: String,
}

impl ListFileRequestsContinueArg {
    pub fn new(cursor: String) -> Self {
        ListFileRequestsContinueArg {
            cursor,
        }
    }
}

const LIST_FILE_REQUESTS_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFileRequestsContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileRequestsContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileRequestsContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileRequestsContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileRequestsContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileRequestsContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileRequestsContinueArg", LIST_FILE_REQUESTS_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileRequestsContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There was an error retrieving the file requests.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFileRequestsContinueError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// The cursor is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFileRequestsContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => ListFileRequestsContinueError::DisabledForTeam,
                    "invalid_cursor" => ListFileRequestsContinueError::InvalidCursor,
                    _ => ListFileRequestsContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "invalid_cursor"];
        deserializer.deserialize_struct("ListFileRequestsContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFileRequestsContinueError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("ListFileRequestsContinueError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            ListFileRequestsContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ListFileRequestsContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ListFileRequestsContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFileRequestsContinueError {
}

impl ::std::fmt::Display for ListFileRequestsContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFileRequestsContinueError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            ListFileRequestsContinueError::InvalidCursor => f.write_str("The cursor is invalid."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// There was an error retrieving the file requests.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFileRequestsError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFileRequestsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => ListFileRequestsError::DisabledForTeam,
                    _ => ListFileRequestsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other"];
        deserializer.deserialize_struct("ListFileRequestsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFileRequestsError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("ListFileRequestsError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            ListFileRequestsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFileRequestsError {
}

impl ::std::fmt::Display for ListFileRequestsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFileRequestsError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Result for [`list()`](list).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileRequestsResult {
    /// The file requests owned by this user. Apps with the app folder permission will only see file
    /// requests in their app folder.
    pub file_requests: Vec<FileRequest>,
}

impl ListFileRequestsResult {
    pub fn new(file_requests: Vec<FileRequest>) -> Self {
        ListFileRequestsResult {
            file_requests,
        }
    }
}

const LIST_FILE_REQUESTS_RESULT_FIELDS: &[&str] = &["file_requests"];
impl ListFileRequestsResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileRequestsResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileRequestsResult>, V::Error> {
        let mut field_file_requests = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file_requests" => {
                    if field_file_requests.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_requests"));
                    }
                    field_file_requests = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileRequestsResult {
            file_requests: field_file_requests.ok_or_else(|| ::serde::de::Error::missing_field("file_requests"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file_requests", &self.file_requests)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileRequestsResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileRequestsResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileRequestsResult", LIST_FILE_REQUESTS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileRequestsResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Result for [`list_v2()`](list_v2) and [`list_continue()`](list_continue).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileRequestsV2Result {
    /// The file requests owned by this user. Apps with the app folder permission will only see file
    /// requests in their app folder.
    pub file_requests: Vec<FileRequest>,
    /// Pass the cursor into [`list_continue()`](list_continue) to obtain additional file requests.
    pub cursor: String,
    /// Is true if there are additional file requests that have not been returned yet. An additional
    /// call to :route:list/continue` can retrieve them.
    pub has_more: bool,
}

impl ListFileRequestsV2Result {
    pub fn new(file_requests: Vec<FileRequest>, cursor: String, has_more: bool) -> Self {
        ListFileRequestsV2Result {
            file_requests,
            cursor,
            has_more,
        }
    }
}

const LIST_FILE_REQUESTS_V2_RESULT_FIELDS: &[&str] = &["file_requests",
                                                       "cursor",
                                                       "has_more"];
impl ListFileRequestsV2Result {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileRequestsV2Result, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileRequestsV2Result>, V::Error> {
        let mut field_file_requests = None;
        let mut field_cursor = None;
        let mut field_has_more = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file_requests" => {
                    if field_file_requests.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file_requests"));
                    }
                    field_file_requests = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileRequestsV2Result {
            file_requests: field_file_requests.ok_or_else(|| ::serde::de::Error::missing_field("file_requests"))?,
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file_requests", &self.file_requests)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("has_more", &self.has_more)?;
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileRequestsV2Result {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileRequestsV2Result;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileRequestsV2Result struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileRequestsV2Result::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileRequestsV2Result", LIST_FILE_REQUESTS_V2_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileRequestsV2Result {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileRequestsV2Result", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`update()`](update).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UpdateFileRequestArgs {
    /// The ID of the file request to update.
    pub id: FileRequestId,
    /// The new title of the file request. Must not be empty.
    pub title: Option<String>,
    /// The new path of the folder in the Dropbox where uploaded files will be sent. For apps with
    /// the app folder permission, this will be relative to the app folder.
    pub destination: Option<super::files::Path>,
    /// The new deadline for the file request. Deadlines can only be set by Professional and
    /// Business accounts.
    pub deadline: UpdateFileRequestDeadline,
    /// Whether to set this file request as open or closed.
    pub open: Option<bool>,
    /// The description of the file request.
    pub description: Option<String>,
}

impl UpdateFileRequestArgs {
    pub fn new(id: FileRequestId) -> Self {
        UpdateFileRequestArgs {
            id,
            title: None,
            destination: None,
            deadline: UpdateFileRequestDeadline::NoUpdate,
            open: None,
            description: None,
        }
    }

    pub fn with_title(mut self, value: String) -> Self {
        self.title = Some(value);
        self
    }

    pub fn with_destination(mut self, value: super::files::Path) -> Self {
        self.destination = Some(value);
        self
    }

    pub fn with_deadline(mut self, value: UpdateFileRequestDeadline) -> Self {
        self.deadline = value;
        self
    }

    pub fn with_open(mut self, value: bool) -> Self {
        self.open = Some(value);
        self
    }

    pub fn with_description(mut self, value: String) -> Self {
        self.description = Some(value);
        self
    }
}

const UPDATE_FILE_REQUEST_ARGS_FIELDS: &[&str] = &["id",
                                                   "title",
                                                   "destination",
                                                   "deadline",
                                                   "open",
                                                   "description"];
impl UpdateFileRequestArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UpdateFileRequestArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UpdateFileRequestArgs>, V::Error> {
        let mut field_id = None;
        let mut field_title = None;
        let mut field_destination = None;
        let mut field_deadline = None;
        let mut field_open = None;
        let mut field_description = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "title" => {
                    if field_title.is_some() {
                        return Err(::serde::de::Error::duplicate_field("title"));
                    }
                    field_title = Some(map.next_value()?);
                }
                "destination" => {
                    if field_destination.is_some() {
                        return Err(::serde::de::Error::duplicate_field("destination"));
                    }
                    field_destination = Some(map.next_value()?);
                }
                "deadline" => {
                    if field_deadline.is_some() {
                        return Err(::serde::de::Error::duplicate_field("deadline"));
                    }
                    field_deadline = Some(map.next_value()?);
                }
                "open" => {
                    if field_open.is_some() {
                        return Err(::serde::de::Error::duplicate_field("open"));
                    }
                    field_open = Some(map.next_value()?);
                }
                "description" => {
                    if field_description.is_some() {
                        return Err(::serde::de::Error::duplicate_field("description"));
                    }
                    field_description = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UpdateFileRequestArgs {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            title: field_title,
            destination: field_destination,
            deadline: field_deadline.unwrap_or(UpdateFileRequestDeadline::NoUpdate),
            open: field_open,
            description: field_description,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        if let Some(val) = &self.title {
            s.serialize_field("title", val)?;
        }
        if let Some(val) = &self.destination {
            s.serialize_field("destination", val)?;
        }
        s.serialize_field("deadline", &self.deadline)?;
        if let Some(val) = &self.open {
            s.serialize_field("open", val)?;
        }
        if let Some(val) = &self.description {
            s.serialize_field("description", val)?;
        }
        Ok(())
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFileRequestArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UpdateFileRequestArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFileRequestArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UpdateFileRequestArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UpdateFileRequestArgs", UPDATE_FILE_REQUEST_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFileRequestArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UpdateFileRequestArgs", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UpdateFileRequestDeadline {
    /// Do not change the file request's deadline.
    NoUpdate,
    /// If `None`, the file request's deadline is cleared.
    Update(Option<FileRequestDeadline>),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFileRequestDeadline {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UpdateFileRequestDeadline;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFileRequestDeadline structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "no_update" => UpdateFileRequestDeadline::NoUpdate,
                    "update" => UpdateFileRequestDeadline::Update(FileRequestDeadline::internal_deserialize_opt(&mut map, true)?),
                    _ => UpdateFileRequestDeadline::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["no_update",
                                    "update",
                                    "other"];
        deserializer.deserialize_struct("UpdateFileRequestDeadline", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFileRequestDeadline {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UpdateFileRequestDeadline::NoUpdate => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestDeadline", 1)?;
                s.serialize_field(".tag", "no_update")?;
                s.end()
            }
            UpdateFileRequestDeadline::Update(ref x) => {
                // nullable (struct or primitive)
                let n = if x.is_some() { 4 } else { 1 };
                let mut s = serializer.serialize_struct("UpdateFileRequestDeadline", n)?;
                s.serialize_field(".tag", "update")?;
                if let Some(ref x) = x {
                    x.internal_serialize::<S>(&mut s)?;
                }
                s.end()
            }
            UpdateFileRequestDeadline::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// There is an error updating the file request.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UpdateFileRequestError {
    /// This user's Dropbox Business team doesn't allow file requests.
    DisabledForTeam,
    /// This file request ID was not found.
    NotFound,
    /// The specified path is not a folder.
    NotAFolder,
    /// This file request is not accessible to this app. Apps with the app folder permission can
    /// only access file requests in their app folder.
    AppLacksAccess,
    /// This user doesn't have permission to access or modify this file request.
    NoPermission,
    /// This user's email address is not verified. File requests are only available on accounts with
    /// a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// There was an error validating the request. For example, the title was invalid, or there were
    /// disallowed characters in the destination path.
    ValidationError,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFileRequestError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UpdateFileRequestError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFileRequestError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled_for_team" => UpdateFileRequestError::DisabledForTeam,
                    "not_found" => UpdateFileRequestError::NotFound,
                    "not_a_folder" => UpdateFileRequestError::NotAFolder,
                    "app_lacks_access" => UpdateFileRequestError::AppLacksAccess,
                    "no_permission" => UpdateFileRequestError::NoPermission,
                    "email_unverified" => UpdateFileRequestError::EmailUnverified,
                    "validation_error" => UpdateFileRequestError::ValidationError,
                    _ => UpdateFileRequestError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled_for_team",
                                    "other",
                                    "not_found",
                                    "not_a_folder",
                                    "app_lacks_access",
                                    "no_permission",
                                    "email_unverified",
                                    "validation_error"];
        deserializer.deserialize_struct("UpdateFileRequestError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFileRequestError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UpdateFileRequestError::DisabledForTeam => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "disabled_for_team")?;
                s.end()
            }
            UpdateFileRequestError::NotFound => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "not_found")?;
                s.end()
            }
            UpdateFileRequestError::NotAFolder => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "not_a_folder")?;
                s.end()
            }
            UpdateFileRequestError::AppLacksAccess => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "app_lacks_access")?;
                s.end()
            }
            UpdateFileRequestError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            UpdateFileRequestError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            UpdateFileRequestError::ValidationError => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFileRequestError", 1)?;
                s.serialize_field(".tag", "validation_error")?;
                s.end()
            }
            UpdateFileRequestError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UpdateFileRequestError {
}

impl ::std::fmt::Display for UpdateFileRequestError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UpdateFileRequestError::DisabledForTeam => f.write_str("This user's Dropbox Business team doesn't allow file requests."),
            UpdateFileRequestError::NotFound => f.write_str("This file request ID was not found."),
            UpdateFileRequestError::NotAFolder => f.write_str("The specified path is not a folder."),
            UpdateFileRequestError::AppLacksAccess => f.write_str("This file request is not accessible to this app. Apps with the app folder permission can only access file requests in their app folder."),
            UpdateFileRequestError::NoPermission => f.write_str("This user doesn't have permission to access or modify this file request."),
            UpdateFileRequestError::ValidationError => f.write_str("There was an error validating the request. For example, the title was invalid, or there were disallowed characters in the destination path."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

