// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

//! This namespace contains endpoints and data types for user management.

pub type GetAccountBatchResult = Vec<BasicAccount>;

/// Get a list of feature values that may be configured for the current account.
pub fn features_get_values(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UserFeaturesGetValuesBatchArg,
) -> crate::Result<Result<UserFeaturesGetValuesBatchResult, UserFeaturesGetValuesBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "users/features/get_values",
        arg,
        None)
}

/// Get information about a user's account.
pub fn get_account(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetAccountArg,
) -> crate::Result<Result<BasicAccount, GetAccountError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "users/get_account",
        arg,
        None)
}

/// Get information about multiple user accounts.  At most 300 accounts may be queried per request.
pub fn get_account_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetAccountBatchArg,
) -> crate::Result<Result<GetAccountBatchResult, GetAccountBatchError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "users/get_account_batch",
        arg,
        None)
}

/// Get information about the current user's account.
pub fn get_current_account(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<FullAccount, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "users/get_current_account",
        &(),
        None)
}

/// Get the space usage information for the current user's account.
pub fn get_space_usage(
    client: &impl crate::client_trait::UserAuthClient,
) -> crate::Result<Result<SpaceUsage, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "users/get_space_usage",
        &(),
        None)
}

/// The amount of detail revealed about an account depends on the user being queried and the user
/// making the query.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Account {
    /// The user's unique Dropbox ID.
    pub account_id: super::users_common::AccountId,
    /// Details of a user's name.
    pub name: Name,
    /// The user's email address. Do not rely on this without checking the `email_verified` field.
    /// Even then, it's possible that the user has since lost access to their email.
    pub email: String,
    /// Whether the user has verified their email address.
    pub email_verified: bool,
    /// Whether the user has been disabled.
    pub disabled: bool,
    /// URL for the photo representing the user, if one is set.
    pub profile_photo_url: Option<String>,
}

impl Account {
    pub fn new(
        account_id: super::users_common::AccountId,
        name: Name,
        email: String,
        email_verified: bool,
        disabled: bool,
    ) -> Self {
        Account {
            account_id,
            name,
            email,
            email_verified,
            disabled,
            profile_photo_url: None,
        }
    }

    pub fn with_profile_photo_url(mut self, value: String) -> Self {
        self.profile_photo_url = Some(value);
        self
    }
}

const ACCOUNT_FIELDS: &[&str] = &["account_id",
                                  "name",
                                  "email",
                                  "email_verified",
                                  "disabled",
                                  "profile_photo_url"];
impl Account {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Account, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Account>, V::Error> {
        let mut field_account_id = None;
        let mut field_name = None;
        let mut field_email = None;
        let mut field_email_verified = None;
        let mut field_disabled = None;
        let mut field_profile_photo_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "email" => {
                    if field_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email"));
                    }
                    field_email = Some(map.next_value()?);
                }
                "email_verified" => {
                    if field_email_verified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email_verified"));
                    }
                    field_email_verified = Some(map.next_value()?);
                }
                "disabled" => {
                    if field_disabled.is_some() {
                        return Err(::serde::de::Error::duplicate_field("disabled"));
                    }
                    field_disabled = Some(map.next_value()?);
                }
                "profile_photo_url" => {
                    if field_profile_photo_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("profile_photo_url"));
                    }
                    field_profile_photo_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Account {
            account_id: field_account_id.ok_or_else(|| ::serde::de::Error::missing_field("account_id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            email: field_email.ok_or_else(|| ::serde::de::Error::missing_field("email"))?,
            email_verified: field_email_verified.ok_or_else(|| ::serde::de::Error::missing_field("email_verified"))?,
            disabled: field_disabled.ok_or_else(|| ::serde::de::Error::missing_field("disabled"))?,
            profile_photo_url: field_profile_photo_url,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_id", &self.account_id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("email", &self.email)?;
        s.serialize_field("email_verified", &self.email_verified)?;
        s.serialize_field("disabled", &self.disabled)?;
        s.serialize_field("profile_photo_url", &self.profile_photo_url)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Account {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Account;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Account struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Account::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Account", ACCOUNT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Account {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Account", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Basic information about any account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct BasicAccount {
    /// The user's unique Dropbox ID.
    pub account_id: super::users_common::AccountId,
    /// Details of a user's name.
    pub name: Name,
    /// The user's email address. Do not rely on this without checking the `email_verified` field.
    /// Even then, it's possible that the user has since lost access to their email.
    pub email: String,
    /// Whether the user has verified their email address.
    pub email_verified: bool,
    /// Whether the user has been disabled.
    pub disabled: bool,
    /// Whether this user is a teammate of the current user. If this account is the current user's
    /// account, then this will be `true`.
    pub is_teammate: bool,
    /// URL for the photo representing the user, if one is set.
    pub profile_photo_url: Option<String>,
    /// The user's unique team member id. This field will only be present if the user is part of a
    /// team and `is_teammate` is `true`.
    pub team_member_id: Option<String>,
}

impl BasicAccount {
    pub fn new(
        account_id: super::users_common::AccountId,
        name: Name,
        email: String,
        email_verified: bool,
        disabled: bool,
        is_teammate: bool,
    ) -> Self {
        BasicAccount {
            account_id,
            name,
            email,
            email_verified,
            disabled,
            is_teammate,
            profile_photo_url: None,
            team_member_id: None,
        }
    }

    pub fn with_profile_photo_url(mut self, value: String) -> Self {
        self.profile_photo_url = Some(value);
        self
    }

    pub fn with_team_member_id(mut self, value: String) -> Self {
        self.team_member_id = Some(value);
        self
    }
}

const BASIC_ACCOUNT_FIELDS: &[&str] = &["account_id",
                                        "name",
                                        "email",
                                        "email_verified",
                                        "disabled",
                                        "is_teammate",
                                        "profile_photo_url",
                                        "team_member_id"];
impl BasicAccount {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<BasicAccount, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<BasicAccount>, V::Error> {
        let mut field_account_id = None;
        let mut field_name = None;
        let mut field_email = None;
        let mut field_email_verified = None;
        let mut field_disabled = None;
        let mut field_is_teammate = None;
        let mut field_profile_photo_url = None;
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "email" => {
                    if field_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email"));
                    }
                    field_email = Some(map.next_value()?);
                }
                "email_verified" => {
                    if field_email_verified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email_verified"));
                    }
                    field_email_verified = Some(map.next_value()?);
                }
                "disabled" => {
                    if field_disabled.is_some() {
                        return Err(::serde::de::Error::duplicate_field("disabled"));
                    }
                    field_disabled = Some(map.next_value()?);
                }
                "is_teammate" => {
                    if field_is_teammate.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_teammate"));
                    }
                    field_is_teammate = Some(map.next_value()?);
                }
                "profile_photo_url" => {
                    if field_profile_photo_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("profile_photo_url"));
                    }
                    field_profile_photo_url = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = BasicAccount {
            account_id: field_account_id.ok_or_else(|| ::serde::de::Error::missing_field("account_id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            email: field_email.ok_or_else(|| ::serde::de::Error::missing_field("email"))?,
            email_verified: field_email_verified.ok_or_else(|| ::serde::de::Error::missing_field("email_verified"))?,
            disabled: field_disabled.ok_or_else(|| ::serde::de::Error::missing_field("disabled"))?,
            is_teammate: field_is_teammate.ok_or_else(|| ::serde::de::Error::missing_field("is_teammate"))?,
            profile_photo_url: field_profile_photo_url,
            team_member_id: field_team_member_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_id", &self.account_id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("email", &self.email)?;
        s.serialize_field("email_verified", &self.email_verified)?;
        s.serialize_field("disabled", &self.disabled)?;
        s.serialize_field("is_teammate", &self.is_teammate)?;
        s.serialize_field("profile_photo_url", &self.profile_photo_url)?;
        s.serialize_field("team_member_id", &self.team_member_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for BasicAccount {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = BasicAccount;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a BasicAccount struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                BasicAccount::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("BasicAccount", BASIC_ACCOUNT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for BasicAccount {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("BasicAccount", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The value for [`UserFeature::FileLocking`](UserFeature::FileLocking).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileLockingValue {
    /// When this value is True, the user can lock files in shared directories. When the value is
    /// False the user can unlock the files they have locked or request to unlock files locked by
    /// others.
    Enabled(bool),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileLockingValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileLockingValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLockingValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "enabled" => {
                        match map.next_key()? {
                            Some("enabled") => FileLockingValue::Enabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("enabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => FileLockingValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["enabled",
                                    "other"];
        deserializer.deserialize_struct("FileLockingValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileLockingValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileLockingValue::Enabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("FileLockingValue", 2)?;
                s.serialize_field(".tag", "enabled")?;
                s.serialize_field("enabled", x)?;
                s.end()
            }
            FileLockingValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Detailed information about the current user's account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FullAccount {
    /// The user's unique Dropbox ID.
    pub account_id: super::users_common::AccountId,
    /// Details of a user's name.
    pub name: Name,
    /// The user's email address. Do not rely on this without checking the `email_verified` field.
    /// Even then, it's possible that the user has since lost access to their email.
    pub email: String,
    /// Whether the user has verified their email address.
    pub email_verified: bool,
    /// Whether the user has been disabled.
    pub disabled: bool,
    /// The language that the user specified. Locale tags will be [IETF language
    /// tags](http://en.wikipedia.org/wiki/IETF_language_tag).
    pub locale: String,
    /// The user's [referral link](https://www.dropbox.com/referrals).
    pub referral_link: String,
    /// Whether the user has a personal and work account. If the current account is personal, then
    /// `team` will always be `None`, but `is_paired` will indicate if a work account is linked.
    pub is_paired: bool,
    /// What type of account this user has.
    pub account_type: super::users_common::AccountType,
    /// The root info for this account.
    pub root_info: super::common::RootInfo,
    /// URL for the photo representing the user, if one is set.
    pub profile_photo_url: Option<String>,
    /// The user's two-letter country code, if available. Country codes are based on [ISO
    /// 3166-1](http://en.wikipedia.org/wiki/ISO_3166-1).
    pub country: Option<String>,
    /// If this account is a member of a team, information about that team.
    pub team: Option<FullTeam>,
    /// This account's unique team member id. This field will only be present if `team` is present.
    pub team_member_id: Option<String>,
}

impl FullAccount {
    pub fn new(
        account_id: super::users_common::AccountId,
        name: Name,
        email: String,
        email_verified: bool,
        disabled: bool,
        locale: String,
        referral_link: String,
        is_paired: bool,
        account_type: super::users_common::AccountType,
        root_info: super::common::RootInfo,
    ) -> Self {
        FullAccount {
            account_id,
            name,
            email,
            email_verified,
            disabled,
            locale,
            referral_link,
            is_paired,
            account_type,
            root_info,
            profile_photo_url: None,
            country: None,
            team: None,
            team_member_id: None,
        }
    }

    pub fn with_profile_photo_url(mut self, value: String) -> Self {
        self.profile_photo_url = Some(value);
        self
    }

    pub fn with_country(mut self, value: String) -> Self {
        self.country = Some(value);
        self
    }

    pub fn with_team(mut self, value: FullTeam) -> Self {
        self.team = Some(value);
        self
    }

    pub fn with_team_member_id(mut self, value: String) -> Self {
        self.team_member_id = Some(value);
        self
    }
}

const FULL_ACCOUNT_FIELDS: &[&str] = &["account_id",
                                       "name",
                                       "email",
                                       "email_verified",
                                       "disabled",
                                       "locale",
                                       "referral_link",
                                       "is_paired",
                                       "account_type",
                                       "root_info",
                                       "profile_photo_url",
                                       "country",
                                       "team",
                                       "team_member_id"];
impl FullAccount {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FullAccount, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FullAccount>, V::Error> {
        let mut field_account_id = None;
        let mut field_name = None;
        let mut field_email = None;
        let mut field_email_verified = None;
        let mut field_disabled = None;
        let mut field_locale = None;
        let mut field_referral_link = None;
        let mut field_is_paired = None;
        let mut field_account_type = None;
        let mut field_root_info = None;
        let mut field_profile_photo_url = None;
        let mut field_country = None;
        let mut field_team = None;
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "email" => {
                    if field_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email"));
                    }
                    field_email = Some(map.next_value()?);
                }
                "email_verified" => {
                    if field_email_verified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email_verified"));
                    }
                    field_email_verified = Some(map.next_value()?);
                }
                "disabled" => {
                    if field_disabled.is_some() {
                        return Err(::serde::de::Error::duplicate_field("disabled"));
                    }
                    field_disabled = Some(map.next_value()?);
                }
                "locale" => {
                    if field_locale.is_some() {
                        return Err(::serde::de::Error::duplicate_field("locale"));
                    }
                    field_locale = Some(map.next_value()?);
                }
                "referral_link" => {
                    if field_referral_link.is_some() {
                        return Err(::serde::de::Error::duplicate_field("referral_link"));
                    }
                    field_referral_link = Some(map.next_value()?);
                }
                "is_paired" => {
                    if field_is_paired.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_paired"));
                    }
                    field_is_paired = Some(map.next_value()?);
                }
                "account_type" => {
                    if field_account_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_type"));
                    }
                    field_account_type = Some(map.next_value()?);
                }
                "root_info" => {
                    if field_root_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("root_info"));
                    }
                    field_root_info = Some(map.next_value()?);
                }
                "profile_photo_url" => {
                    if field_profile_photo_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("profile_photo_url"));
                    }
                    field_profile_photo_url = Some(map.next_value()?);
                }
                "country" => {
                    if field_country.is_some() {
                        return Err(::serde::de::Error::duplicate_field("country"));
                    }
                    field_country = Some(map.next_value()?);
                }
                "team" => {
                    if field_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team"));
                    }
                    field_team = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FullAccount {
            account_id: field_account_id.ok_or_else(|| ::serde::de::Error::missing_field("account_id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            email: field_email.ok_or_else(|| ::serde::de::Error::missing_field("email"))?,
            email_verified: field_email_verified.ok_or_else(|| ::serde::de::Error::missing_field("email_verified"))?,
            disabled: field_disabled.ok_or_else(|| ::serde::de::Error::missing_field("disabled"))?,
            locale: field_locale.ok_or_else(|| ::serde::de::Error::missing_field("locale"))?,
            referral_link: field_referral_link.ok_or_else(|| ::serde::de::Error::missing_field("referral_link"))?,
            is_paired: field_is_paired.ok_or_else(|| ::serde::de::Error::missing_field("is_paired"))?,
            account_type: field_account_type.ok_or_else(|| ::serde::de::Error::missing_field("account_type"))?,
            root_info: field_root_info.ok_or_else(|| ::serde::de::Error::missing_field("root_info"))?,
            profile_photo_url: field_profile_photo_url,
            country: field_country,
            team: field_team,
            team_member_id: field_team_member_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_id", &self.account_id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("email", &self.email)?;
        s.serialize_field("email_verified", &self.email_verified)?;
        s.serialize_field("disabled", &self.disabled)?;
        s.serialize_field("locale", &self.locale)?;
        s.serialize_field("referral_link", &self.referral_link)?;
        s.serialize_field("is_paired", &self.is_paired)?;
        s.serialize_field("account_type", &self.account_type)?;
        s.serialize_field("root_info", &self.root_info)?;
        s.serialize_field("profile_photo_url", &self.profile_photo_url)?;
        s.serialize_field("country", &self.country)?;
        s.serialize_field("team", &self.team)?;
        s.serialize_field("team_member_id", &self.team_member_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FullAccount {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FullAccount;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FullAccount struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FullAccount::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FullAccount", FULL_ACCOUNT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FullAccount {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FullAccount", 14)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Detailed information about a team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FullTeam {
    /// The team's unique ID.
    pub id: String,
    /// The name of the team.
    pub name: String,
    /// Team policies governing sharing.
    pub sharing_policies: super::team_policies::TeamSharingPolicies,
    /// Team policy governing the use of the Office Add-In.
    pub office_addin_policy: super::team_policies::OfficeAddInPolicy,
}

impl FullTeam {
    pub fn new(
        id: String,
        name: String,
        sharing_policies: super::team_policies::TeamSharingPolicies,
        office_addin_policy: super::team_policies::OfficeAddInPolicy,
    ) -> Self {
        FullTeam {
            id,
            name,
            sharing_policies,
            office_addin_policy,
        }
    }
}

const FULL_TEAM_FIELDS: &[&str] = &["id",
                                    "name",
                                    "sharing_policies",
                                    "office_addin_policy"];
impl FullTeam {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FullTeam, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FullTeam>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut field_sharing_policies = None;
        let mut field_office_addin_policy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "sharing_policies" => {
                    if field_sharing_policies.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sharing_policies"));
                    }
                    field_sharing_policies = Some(map.next_value()?);
                }
                "office_addin_policy" => {
                    if field_office_addin_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("office_addin_policy"));
                    }
                    field_office_addin_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FullTeam {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            sharing_policies: field_sharing_policies.ok_or_else(|| ::serde::de::Error::missing_field("sharing_policies"))?,
            office_addin_policy: field_office_addin_policy.ok_or_else(|| ::serde::de::Error::missing_field("office_addin_policy"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("sharing_policies", &self.sharing_policies)?;
        s.serialize_field("office_addin_policy", &self.office_addin_policy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FullTeam {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FullTeam;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FullTeam struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FullTeam::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FullTeam", FULL_TEAM_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FullTeam {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FullTeam", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetAccountArg {
    /// A user's account identifier.
    pub account_id: super::users_common::AccountId,
}

impl GetAccountArg {
    pub fn new(account_id: super::users_common::AccountId) -> Self {
        GetAccountArg {
            account_id,
        }
    }
}

const GET_ACCOUNT_ARG_FIELDS: &[&str] = &["account_id"];
impl GetAccountArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetAccountArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetAccountArg>, V::Error> {
        let mut field_account_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetAccountArg {
            account_id: field_account_id.ok_or_else(|| ::serde::de::Error::missing_field("account_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_id", &self.account_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetAccountArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetAccountArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetAccountArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetAccountArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetAccountArg", GET_ACCOUNT_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetAccountArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetAccountArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetAccountBatchArg {
    /// List of user account identifiers.  Should not contain any duplicate account IDs.
    pub account_ids: Vec<super::users_common::AccountId>,
}

impl GetAccountBatchArg {
    pub fn new(account_ids: Vec<super::users_common::AccountId>) -> Self {
        GetAccountBatchArg {
            account_ids,
        }
    }
}

const GET_ACCOUNT_BATCH_ARG_FIELDS: &[&str] = &["account_ids"];
impl GetAccountBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetAccountBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetAccountBatchArg>, V::Error> {
        let mut field_account_ids = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_ids" => {
                    if field_account_ids.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_ids"));
                    }
                    field_account_ids = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetAccountBatchArg {
            account_ids: field_account_ids.ok_or_else(|| ::serde::de::Error::missing_field("account_ids"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_ids", &self.account_ids)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetAccountBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetAccountBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetAccountBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetAccountBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetAccountBatchArg", GET_ACCOUNT_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetAccountBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetAccountBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetAccountBatchError {
    /// The value is an account ID specified in
    /// [`GetAccountBatchArg::account_ids`](GetAccountBatchArg) that does not exist.
    NoAccount(super::users_common::AccountId),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetAccountBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetAccountBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetAccountBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "no_account" => {
                        match map.next_key()? {
                            Some("no_account") => GetAccountBatchError::NoAccount(map.next_value()?),
                            None => return Err(de::Error::missing_field("no_account")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetAccountBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["no_account",
                                    "other"];
        deserializer.deserialize_struct("GetAccountBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetAccountBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetAccountBatchError::NoAccount(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("GetAccountBatchError", 2)?;
                s.serialize_field(".tag", "no_account")?;
                s.serialize_field("no_account", x)?;
                s.end()
            }
            GetAccountBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetAccountBatchError {
}

impl ::std::fmt::Display for GetAccountBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetAccountBatchError::NoAccount(inner) => write!(f, "no_account: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetAccountError {
    /// The specified [`GetAccountArg::account_id`](GetAccountArg) does not exist.
    NoAccount,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetAccountError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetAccountError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetAccountError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "no_account" => GetAccountError::NoAccount,
                    _ => GetAccountError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["no_account",
                                    "other"];
        deserializer.deserialize_struct("GetAccountError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetAccountError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetAccountError::NoAccount => {
                // unit
                let mut s = serializer.serialize_struct("GetAccountError", 1)?;
                s.serialize_field(".tag", "no_account")?;
                s.end()
            }
            GetAccountError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetAccountError {
}

impl ::std::fmt::Display for GetAccountError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct IndividualSpaceAllocation {
    /// The total space allocated to the user's account (bytes).
    pub allocated: u64,
}

impl IndividualSpaceAllocation {
    pub fn new(allocated: u64) -> Self {
        IndividualSpaceAllocation {
            allocated,
        }
    }
}

const INDIVIDUAL_SPACE_ALLOCATION_FIELDS: &[&str] = &["allocated"];
impl IndividualSpaceAllocation {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<IndividualSpaceAllocation, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<IndividualSpaceAllocation>, V::Error> {
        let mut field_allocated = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "allocated" => {
                    if field_allocated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allocated"));
                    }
                    field_allocated = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = IndividualSpaceAllocation {
            allocated: field_allocated.ok_or_else(|| ::serde::de::Error::missing_field("allocated"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("allocated", &self.allocated)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for IndividualSpaceAllocation {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = IndividualSpaceAllocation;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a IndividualSpaceAllocation struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                IndividualSpaceAllocation::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("IndividualSpaceAllocation", INDIVIDUAL_SPACE_ALLOCATION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for IndividualSpaceAllocation {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("IndividualSpaceAllocation", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Representations for a person's name to assist with internationalization.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Name {
    /// Also known as a first name.
    pub given_name: String,
    /// Also known as a last name or family name.
    pub surname: String,
    /// Locale-dependent name. In the US, a person's familiar name is their `given_name`, but
    /// elsewhere, it could be any combination of a person's `given_name` and `surname`.
    pub familiar_name: String,
    /// A name that can be used directly to represent the name of a user's Dropbox account.
    pub display_name: String,
    /// An abbreviated form of the person's name. Their initials in most locales.
    pub abbreviated_name: String,
}

impl Name {
    pub fn new(
        given_name: String,
        surname: String,
        familiar_name: String,
        display_name: String,
        abbreviated_name: String,
    ) -> Self {
        Name {
            given_name,
            surname,
            familiar_name,
            display_name,
            abbreviated_name,
        }
    }
}

const NAME_FIELDS: &[&str] = &["given_name",
                               "surname",
                               "familiar_name",
                               "display_name",
                               "abbreviated_name"];
impl Name {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Name, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Name>, V::Error> {
        let mut field_given_name = None;
        let mut field_surname = None;
        let mut field_familiar_name = None;
        let mut field_display_name = None;
        let mut field_abbreviated_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "given_name" => {
                    if field_given_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("given_name"));
                    }
                    field_given_name = Some(map.next_value()?);
                }
                "surname" => {
                    if field_surname.is_some() {
                        return Err(::serde::de::Error::duplicate_field("surname"));
                    }
                    field_surname = Some(map.next_value()?);
                }
                "familiar_name" => {
                    if field_familiar_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("familiar_name"));
                    }
                    field_familiar_name = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                "abbreviated_name" => {
                    if field_abbreviated_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("abbreviated_name"));
                    }
                    field_abbreviated_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Name {
            given_name: field_given_name.ok_or_else(|| ::serde::de::Error::missing_field("given_name"))?,
            surname: field_surname.ok_or_else(|| ::serde::de::Error::missing_field("surname"))?,
            familiar_name: field_familiar_name.ok_or_else(|| ::serde::de::Error::missing_field("familiar_name"))?,
            display_name: field_display_name.ok_or_else(|| ::serde::de::Error::missing_field("display_name"))?,
            abbreviated_name: field_abbreviated_name.ok_or_else(|| ::serde::de::Error::missing_field("abbreviated_name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("given_name", &self.given_name)?;
        s.serialize_field("surname", &self.surname)?;
        s.serialize_field("familiar_name", &self.familiar_name)?;
        s.serialize_field("display_name", &self.display_name)?;
        s.serialize_field("abbreviated_name", &self.abbreviated_name)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Name {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Name;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Name struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Name::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Name", NAME_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Name {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Name", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The value for [`UserFeature::PaperAsFiles`](UserFeature::PaperAsFiles).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperAsFilesValue {
    /// When this value is true, the user's Paper docs are accessible in Dropbox with the .paper
    /// extension and must be accessed via the /files endpoints.  When this value is false, the
    /// user's Paper docs are stored separate from Dropbox files and folders and should be accessed
    /// via the /paper endpoints.
    Enabled(bool),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperAsFilesValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperAsFilesValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperAsFilesValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "enabled" => {
                        match map.next_key()? {
                            Some("enabled") => PaperAsFilesValue::Enabled(map.next_value()?),
                            None => return Err(de::Error::missing_field("enabled")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => PaperAsFilesValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["enabled",
                                    "other"];
        deserializer.deserialize_struct("PaperAsFilesValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperAsFilesValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperAsFilesValue::Enabled(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("PaperAsFilesValue", 2)?;
                s.serialize_field(".tag", "enabled")?;
                s.serialize_field("enabled", x)?;
                s.end()
            }
            PaperAsFilesValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Space is allocated differently based on the type of account.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SpaceAllocation {
    /// The user's space allocation applies only to their individual account.
    Individual(IndividualSpaceAllocation),
    /// The user shares space with other members of their team.
    Team(TeamSpaceAllocation),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SpaceAllocation {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SpaceAllocation;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SpaceAllocation structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "individual" => SpaceAllocation::Individual(IndividualSpaceAllocation::internal_deserialize(&mut map)?),
                    "team" => SpaceAllocation::Team(TeamSpaceAllocation::internal_deserialize(&mut map)?),
                    _ => SpaceAllocation::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["individual",
                                    "team",
                                    "other"];
        deserializer.deserialize_struct("SpaceAllocation", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SpaceAllocation {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SpaceAllocation::Individual(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SpaceAllocation", 2)?;
                s.serialize_field(".tag", "individual")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            SpaceAllocation::Team(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SpaceAllocation", 6)?;
                s.serialize_field(".tag", "team")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            SpaceAllocation::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Information about a user's space usage and quota.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SpaceUsage {
    /// The user's total space usage (bytes).
    pub used: u64,
    /// The user's space allocation.
    pub allocation: SpaceAllocation,
}

impl SpaceUsage {
    pub fn new(used: u64, allocation: SpaceAllocation) -> Self {
        SpaceUsage {
            used,
            allocation,
        }
    }
}

const SPACE_USAGE_FIELDS: &[&str] = &["used",
                                      "allocation"];
impl SpaceUsage {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SpaceUsage, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SpaceUsage>, V::Error> {
        let mut field_used = None;
        let mut field_allocation = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "used" => {
                    if field_used.is_some() {
                        return Err(::serde::de::Error::duplicate_field("used"));
                    }
                    field_used = Some(map.next_value()?);
                }
                "allocation" => {
                    if field_allocation.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allocation"));
                    }
                    field_allocation = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SpaceUsage {
            used: field_used.ok_or_else(|| ::serde::de::Error::missing_field("used"))?,
            allocation: field_allocation.ok_or_else(|| ::serde::de::Error::missing_field("allocation"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("used", &self.used)?;
        s.serialize_field("allocation", &self.allocation)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SpaceUsage {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SpaceUsage;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SpaceUsage struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SpaceUsage::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SpaceUsage", SPACE_USAGE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SpaceUsage {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SpaceUsage", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information about a team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct Team {
    /// The team's unique ID.
    pub id: String,
    /// The name of the team.
    pub name: String,
}

impl Team {
    pub fn new(id: String, name: String) -> Self {
        Team {
            id,
            name,
        }
    }
}

const TEAM_FIELDS: &[&str] = &["id",
                               "name"];
impl Team {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<Team, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<Team>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = Team {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("name", &self.name)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for Team {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = Team;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Team struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                Team::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("Team", TEAM_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for Team {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("Team", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct TeamSpaceAllocation {
    /// The total space currently used by the user's team (bytes).
    pub used: u64,
    /// The total space allocated to the user's team (bytes).
    pub allocated: u64,
    /// The total space allocated to the user within its team allocated space (0 means that no
    /// restriction is imposed on the user's quota within its team).
    pub user_within_team_space_allocated: u64,
    /// The type of the space limit imposed on the team member (off, alert_only, stop_sync).
    pub user_within_team_space_limit_type: super::team_common::MemberSpaceLimitType,
    /// An accurate cached calculation of a team member's total space usage (bytes).
    pub user_within_team_space_used_cached: u64,
}

impl TeamSpaceAllocation {
    pub fn new(
        used: u64,
        allocated: u64,
        user_within_team_space_allocated: u64,
        user_within_team_space_limit_type: super::team_common::MemberSpaceLimitType,
        user_within_team_space_used_cached: u64,
    ) -> Self {
        TeamSpaceAllocation {
            used,
            allocated,
            user_within_team_space_allocated,
            user_within_team_space_limit_type,
            user_within_team_space_used_cached,
        }
    }
}

const TEAM_SPACE_ALLOCATION_FIELDS: &[&str] = &["used",
                                                "allocated",
                                                "user_within_team_space_allocated",
                                                "user_within_team_space_limit_type",
                                                "user_within_team_space_used_cached"];
impl TeamSpaceAllocation {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<TeamSpaceAllocation, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<TeamSpaceAllocation>, V::Error> {
        let mut field_used = None;
        let mut field_allocated = None;
        let mut field_user_within_team_space_allocated = None;
        let mut field_user_within_team_space_limit_type = None;
        let mut field_user_within_team_space_used_cached = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "used" => {
                    if field_used.is_some() {
                        return Err(::serde::de::Error::duplicate_field("used"));
                    }
                    field_used = Some(map.next_value()?);
                }
                "allocated" => {
                    if field_allocated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allocated"));
                    }
                    field_allocated = Some(map.next_value()?);
                }
                "user_within_team_space_allocated" => {
                    if field_user_within_team_space_allocated.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user_within_team_space_allocated"));
                    }
                    field_user_within_team_space_allocated = Some(map.next_value()?);
                }
                "user_within_team_space_limit_type" => {
                    if field_user_within_team_space_limit_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user_within_team_space_limit_type"));
                    }
                    field_user_within_team_space_limit_type = Some(map.next_value()?);
                }
                "user_within_team_space_used_cached" => {
                    if field_user_within_team_space_used_cached.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user_within_team_space_used_cached"));
                    }
                    field_user_within_team_space_used_cached = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = TeamSpaceAllocation {
            used: field_used.ok_or_else(|| ::serde::de::Error::missing_field("used"))?,
            allocated: field_allocated.ok_or_else(|| ::serde::de::Error::missing_field("allocated"))?,
            user_within_team_space_allocated: field_user_within_team_space_allocated.ok_or_else(|| ::serde::de::Error::missing_field("user_within_team_space_allocated"))?,
            user_within_team_space_limit_type: field_user_within_team_space_limit_type.ok_or_else(|| ::serde::de::Error::missing_field("user_within_team_space_limit_type"))?,
            user_within_team_space_used_cached: field_user_within_team_space_used_cached.ok_or_else(|| ::serde::de::Error::missing_field("user_within_team_space_used_cached"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("used", &self.used)?;
        s.serialize_field("allocated", &self.allocated)?;
        s.serialize_field("user_within_team_space_allocated", &self.user_within_team_space_allocated)?;
        s.serialize_field("user_within_team_space_limit_type", &self.user_within_team_space_limit_type)?;
        s.serialize_field("user_within_team_space_used_cached", &self.user_within_team_space_used_cached)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for TeamSpaceAllocation {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = TeamSpaceAllocation;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TeamSpaceAllocation struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                TeamSpaceAllocation::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("TeamSpaceAllocation", TEAM_SPACE_ALLOCATION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for TeamSpaceAllocation {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("TeamSpaceAllocation", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// A set of features that a Dropbox User account may have configured.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UserFeature {
    /// This feature contains information about how the user's Paper files are stored.
    PaperAsFiles,
    /// This feature allows users to lock files in order to restrict other users from editing them.
    FileLocking,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UserFeature {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UserFeature;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFeature structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "paper_as_files" => UserFeature::PaperAsFiles,
                    "file_locking" => UserFeature::FileLocking,
                    _ => UserFeature::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["paper_as_files",
                                    "file_locking",
                                    "other"];
        deserializer.deserialize_struct("UserFeature", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UserFeature {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UserFeature::PaperAsFiles => {
                // unit
                let mut s = serializer.serialize_struct("UserFeature", 1)?;
                s.serialize_field(".tag", "paper_as_files")?;
                s.end()
            }
            UserFeature::FileLocking => {
                // unit
                let mut s = serializer.serialize_struct("UserFeature", 1)?;
                s.serialize_field(".tag", "file_locking")?;
                s.end()
            }
            UserFeature::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Values that correspond to entries in [`UserFeature`](UserFeature).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UserFeatureValue {
    PaperAsFiles(PaperAsFilesValue),
    FileLocking(FileLockingValue),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UserFeatureValue {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UserFeatureValue;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFeatureValue structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "paper_as_files" => {
                        match map.next_key()? {
                            Some("paper_as_files") => UserFeatureValue::PaperAsFiles(map.next_value()?),
                            None => return Err(de::Error::missing_field("paper_as_files")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "file_locking" => {
                        match map.next_key()? {
                            Some("file_locking") => UserFeatureValue::FileLocking(map.next_value()?),
                            None => return Err(de::Error::missing_field("file_locking")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => UserFeatureValue::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["paper_as_files",
                                    "file_locking",
                                    "other"];
        deserializer.deserialize_struct("UserFeatureValue", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UserFeatureValue {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UserFeatureValue::PaperAsFiles(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UserFeatureValue", 2)?;
                s.serialize_field(".tag", "paper_as_files")?;
                s.serialize_field("paper_as_files", x)?;
                s.end()
            }
            UserFeatureValue::FileLocking(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UserFeatureValue", 2)?;
                s.serialize_field(".tag", "file_locking")?;
                s.serialize_field("file_locking", x)?;
                s.end()
            }
            UserFeatureValue::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserFeaturesGetValuesBatchArg {
    /// A list of features in [`UserFeature`](UserFeature). If the list is empty, this route will
    /// return [`UserFeaturesGetValuesBatchError`](UserFeaturesGetValuesBatchError).
    pub features: Vec<UserFeature>,
}

impl UserFeaturesGetValuesBatchArg {
    pub fn new(features: Vec<UserFeature>) -> Self {
        UserFeaturesGetValuesBatchArg {
            features,
        }
    }
}

const USER_FEATURES_GET_VALUES_BATCH_ARG_FIELDS: &[&str] = &["features"];
impl UserFeaturesGetValuesBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserFeaturesGetValuesBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserFeaturesGetValuesBatchArg>, V::Error> {
        let mut field_features = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "features" => {
                    if field_features.is_some() {
                        return Err(::serde::de::Error::duplicate_field("features"));
                    }
                    field_features = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserFeaturesGetValuesBatchArg {
            features: field_features.ok_or_else(|| ::serde::de::Error::missing_field("features"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("features", &self.features)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserFeaturesGetValuesBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserFeaturesGetValuesBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFeaturesGetValuesBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserFeaturesGetValuesBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserFeaturesGetValuesBatchArg", USER_FEATURES_GET_VALUES_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserFeaturesGetValuesBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserFeaturesGetValuesBatchArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UserFeaturesGetValuesBatchError {
    /// At least one [`UserFeature`](UserFeature) must be included in the
    /// [`UserFeaturesGetValuesBatchArg`](UserFeaturesGetValuesBatchArg).features list.
    EmptyFeaturesList,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UserFeaturesGetValuesBatchError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UserFeaturesGetValuesBatchError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFeaturesGetValuesBatchError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "empty_features_list" => UserFeaturesGetValuesBatchError::EmptyFeaturesList,
                    _ => UserFeaturesGetValuesBatchError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["empty_features_list",
                                    "other"];
        deserializer.deserialize_struct("UserFeaturesGetValuesBatchError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UserFeaturesGetValuesBatchError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UserFeaturesGetValuesBatchError::EmptyFeaturesList => {
                // unit
                let mut s = serializer.serialize_struct("UserFeaturesGetValuesBatchError", 1)?;
                s.serialize_field(".tag", "empty_features_list")?;
                s.end()
            }
            UserFeaturesGetValuesBatchError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UserFeaturesGetValuesBatchError {
}

impl ::std::fmt::Display for UserFeaturesGetValuesBatchError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserFeaturesGetValuesBatchResult {
    pub values: Vec<UserFeatureValue>,
}

impl UserFeaturesGetValuesBatchResult {
    pub fn new(values: Vec<UserFeatureValue>) -> Self {
        UserFeaturesGetValuesBatchResult {
            values,
        }
    }
}

const USER_FEATURES_GET_VALUES_BATCH_RESULT_FIELDS: &[&str] = &["values"];
impl UserFeaturesGetValuesBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserFeaturesGetValuesBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserFeaturesGetValuesBatchResult>, V::Error> {
        let mut field_values = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "values" => {
                    if field_values.is_some() {
                        return Err(::serde::de::Error::duplicate_field("values"));
                    }
                    field_values = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserFeaturesGetValuesBatchResult {
            values: field_values.ok_or_else(|| ::serde::de::Error::missing_field("values"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("values", &self.values)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserFeaturesGetValuesBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserFeaturesGetValuesBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFeaturesGetValuesBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserFeaturesGetValuesBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserFeaturesGetValuesBatchResult", USER_FEATURES_GET_VALUES_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserFeaturesGetValuesBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserFeaturesGetValuesBatchResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

