// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CameraUploadsPolicyState {
    /// Background camera uploads are disabled.
    Disabled,
    /// Background camera uploads are allowed.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CameraUploadsPolicyState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CameraUploadsPolicyState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CameraUploadsPolicyState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => CameraUploadsPolicyState::Disabled,
                    "enabled" => CameraUploadsPolicyState::Enabled,
                    _ => CameraUploadsPolicyState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("CameraUploadsPolicyState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CameraUploadsPolicyState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CameraUploadsPolicyState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("CameraUploadsPolicyState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            CameraUploadsPolicyState::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("CameraUploadsPolicyState", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            CameraUploadsPolicyState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ComputerBackupPolicyState {
    /// Computer Backup feature is disabled.
    Disabled,
    /// Computer Backup feature is enabled.
    Enabled,
    /// Computer Backup defaults to ON for SSB teams, and OFF for Enterprise teams.
    Default,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ComputerBackupPolicyState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ComputerBackupPolicyState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ComputerBackupPolicyState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ComputerBackupPolicyState::Disabled,
                    "enabled" => ComputerBackupPolicyState::Enabled,
                    "default" => ComputerBackupPolicyState::Default,
                    _ => ComputerBackupPolicyState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "default",
                                    "other"];
        deserializer.deserialize_struct("ComputerBackupPolicyState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ComputerBackupPolicyState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ComputerBackupPolicyState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicyState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ComputerBackupPolicyState::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicyState", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ComputerBackupPolicyState::Default => {
                // unit
                let mut s = serializer.serialize_struct("ComputerBackupPolicyState", 1)?;
                s.serialize_field(".tag", "default")?;
                s.end()
            }
            ComputerBackupPolicyState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum EmmState {
    /// Emm token is disabled.
    Disabled,
    /// Emm token is optional.
    Optional,
    /// Emm token is required.
    Required,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for EmmState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = EmmState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EmmState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => EmmState::Disabled,
                    "optional" => EmmState::Optional,
                    "required" => EmmState::Required,
                    _ => EmmState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "optional",
                                    "required",
                                    "other"];
        deserializer.deserialize_struct("EmmState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for EmmState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            EmmState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("EmmState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            EmmState::Optional => {
                // unit
                let mut s = serializer.serialize_struct("EmmState", 1)?;
                s.serialize_field(".tag", "optional")?;
                s.end()
            }
            EmmState::Required => {
                // unit
                let mut s = serializer.serialize_struct("EmmState", 1)?;
                s.serialize_field(".tag", "required")?;
                s.end()
            }
            EmmState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileLockingPolicyState {
    /// File locking feature is disabled.
    Disabled,
    /// File locking feature is allowed.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileLockingPolicyState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileLockingPolicyState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLockingPolicyState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => FileLockingPolicyState::Disabled,
                    "enabled" => FileLockingPolicyState::Enabled,
                    _ => FileLockingPolicyState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("FileLockingPolicyState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileLockingPolicyState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileLockingPolicyState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("FileLockingPolicyState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            FileLockingPolicyState::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("FileLockingPolicyState", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            FileLockingPolicyState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum GroupCreation {
    /// Team admins and members can create groups.
    AdminsAndMembers,
    /// Only team admins can create groups.
    AdminsOnly,
}

impl<'de> ::serde::de::Deserialize<'de> for GroupCreation {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GroupCreation;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupCreation structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "admins_and_members" => GroupCreation::AdminsAndMembers,
                    "admins_only" => GroupCreation::AdminsOnly,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["admins_and_members",
                                    "admins_only"];
        deserializer.deserialize_struct("GroupCreation", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GroupCreation {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GroupCreation::AdminsAndMembers => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreation", 1)?;
                s.serialize_field(".tag", "admins_and_members")?;
                s.end()
            }
            GroupCreation::AdminsOnly => {
                // unit
                let mut s = serializer.serialize_struct("GroupCreation", 1)?;
                s.serialize_field(".tag", "admins_only")?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum OfficeAddInPolicy {
    /// Office Add-In is disabled.
    Disabled,
    /// Office Add-In is enabled.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for OfficeAddInPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = OfficeAddInPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a OfficeAddInPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => OfficeAddInPolicy::Disabled,
                    "enabled" => OfficeAddInPolicy::Enabled,
                    _ => OfficeAddInPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("OfficeAddInPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for OfficeAddInPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            OfficeAddInPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("OfficeAddInPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            OfficeAddInPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("OfficeAddInPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            OfficeAddInPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDefaultFolderPolicy {
    /// Everyone in team will be the default option when creating a folder in Paper.
    EveryoneInTeam,
    /// Invite only will be the default option when creating a folder in Paper.
    InviteOnly,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDefaultFolderPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDefaultFolderPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDefaultFolderPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "everyone_in_team" => PaperDefaultFolderPolicy::EveryoneInTeam,
                    "invite_only" => PaperDefaultFolderPolicy::InviteOnly,
                    _ => PaperDefaultFolderPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["everyone_in_team",
                                    "invite_only",
                                    "other"];
        deserializer.deserialize_struct("PaperDefaultFolderPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDefaultFolderPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDefaultFolderPolicy::EveryoneInTeam => {
                // unit
                let mut s = serializer.serialize_struct("PaperDefaultFolderPolicy", 1)?;
                s.serialize_field(".tag", "everyone_in_team")?;
                s.end()
            }
            PaperDefaultFolderPolicy::InviteOnly => {
                // unit
                let mut s = serializer.serialize_struct("PaperDefaultFolderPolicy", 1)?;
                s.serialize_field(".tag", "invite_only")?;
                s.end()
            }
            PaperDefaultFolderPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDeploymentPolicy {
    /// All team members have access to Paper.
    Full,
    /// Only whitelisted team members can access Paper. To see which user is whitelisted, check
    /// 'is_paper_whitelisted' on 'account/info'.
    Partial,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDeploymentPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDeploymentPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDeploymentPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "full" => PaperDeploymentPolicy::Full,
                    "partial" => PaperDeploymentPolicy::Partial,
                    _ => PaperDeploymentPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["full",
                                    "partial",
                                    "other"];
        deserializer.deserialize_struct("PaperDeploymentPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDeploymentPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDeploymentPolicy::Full => {
                // unit
                let mut s = serializer.serialize_struct("PaperDeploymentPolicy", 1)?;
                s.serialize_field(".tag", "full")?;
                s.end()
            }
            PaperDeploymentPolicy::Partial => {
                // unit
                let mut s = serializer.serialize_struct("PaperDeploymentPolicy", 1)?;
                s.serialize_field(".tag", "partial")?;
                s.end()
            }
            PaperDeploymentPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperDesktopPolicy {
    /// Do not allow team members to use Paper Desktop.
    Disabled,
    /// Allow team members to use Paper Desktop.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperDesktopPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperDesktopPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperDesktopPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => PaperDesktopPolicy::Disabled,
                    "enabled" => PaperDesktopPolicy::Enabled,
                    _ => PaperDesktopPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("PaperDesktopPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperDesktopPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperDesktopPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("PaperDesktopPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            PaperDesktopPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("PaperDesktopPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            PaperDesktopPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PaperEnabledPolicy {
    /// Paper is disabled.
    Disabled,
    /// Paper is enabled.
    Enabled,
    /// Unspecified policy.
    Unspecified,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PaperEnabledPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PaperEnabledPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PaperEnabledPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => PaperEnabledPolicy::Disabled,
                    "enabled" => PaperEnabledPolicy::Enabled,
                    "unspecified" => PaperEnabledPolicy::Unspecified,
                    _ => PaperEnabledPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "unspecified",
                                    "other"];
        deserializer.deserialize_struct("PaperEnabledPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PaperEnabledPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PaperEnabledPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("PaperEnabledPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            PaperEnabledPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("PaperEnabledPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            PaperEnabledPolicy::Unspecified => {
                // unit
                let mut s = serializer.serialize_struct("PaperEnabledPolicy", 1)?;
                s.serialize_field(".tag", "unspecified")?;
                s.end()
            }
            PaperEnabledPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PasswordControlMode {
    /// Password is disabled.
    Disabled,
    /// Password is enabled.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PasswordControlMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PasswordControlMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PasswordControlMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => PasswordControlMode::Disabled,
                    "enabled" => PasswordControlMode::Enabled,
                    _ => PasswordControlMode::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("PasswordControlMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PasswordControlMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PasswordControlMode::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("PasswordControlMode", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            PasswordControlMode::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("PasswordControlMode", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            PasswordControlMode::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PasswordStrengthPolicy {
    /// User passwords will adhere to the minimal password strength policy.
    MinimalRequirements,
    /// User passwords will adhere to the moderate password strength policy.
    ModeratePassword,
    /// User passwords will adhere to the very strong password strength policy.
    StrongPassword,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PasswordStrengthPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PasswordStrengthPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PasswordStrengthPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "minimal_requirements" => PasswordStrengthPolicy::MinimalRequirements,
                    "moderate_password" => PasswordStrengthPolicy::ModeratePassword,
                    "strong_password" => PasswordStrengthPolicy::StrongPassword,
                    _ => PasswordStrengthPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["minimal_requirements",
                                    "moderate_password",
                                    "strong_password",
                                    "other"];
        deserializer.deserialize_struct("PasswordStrengthPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PasswordStrengthPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PasswordStrengthPolicy::MinimalRequirements => {
                // unit
                let mut s = serializer.serialize_struct("PasswordStrengthPolicy", 1)?;
                s.serialize_field(".tag", "minimal_requirements")?;
                s.end()
            }
            PasswordStrengthPolicy::ModeratePassword => {
                // unit
                let mut s = serializer.serialize_struct("PasswordStrengthPolicy", 1)?;
                s.serialize_field(".tag", "moderate_password")?;
                s.end()
            }
            PasswordStrengthPolicy::StrongPassword => {
                // unit
                let mut s = serializer.serialize_struct("PasswordStrengthPolicy", 1)?;
                s.serialize_field(".tag", "strong_password")?;
                s.end()
            }
            PasswordStrengthPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum RolloutMethod {
    /// Unlink all.
    UnlinkAll,
    /// Unlink devices with the most inactivity.
    UnlinkMostInactive,
    /// Add member to Exceptions.
    AddMemberToExceptions,
}

impl<'de> ::serde::de::Deserialize<'de> for RolloutMethod {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RolloutMethod;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RolloutMethod structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unlink_all" => RolloutMethod::UnlinkAll,
                    "unlink_most_inactive" => RolloutMethod::UnlinkMostInactive,
                    "add_member_to_exceptions" => RolloutMethod::AddMemberToExceptions,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unlink_all",
                                    "unlink_most_inactive",
                                    "add_member_to_exceptions"];
        deserializer.deserialize_struct("RolloutMethod", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RolloutMethod {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RolloutMethod::UnlinkAll => {
                // unit
                let mut s = serializer.serialize_struct("RolloutMethod", 1)?;
                s.serialize_field(".tag", "unlink_all")?;
                s.end()
            }
            RolloutMethod::UnlinkMostInactive => {
                // unit
                let mut s = serializer.serialize_struct("RolloutMethod", 1)?;
                s.serialize_field(".tag", "unlink_most_inactive")?;
                s.end()
            }
            RolloutMethod::AddMemberToExceptions => {
                // unit
                let mut s = serializer.serialize_struct("RolloutMethod", 1)?;
                s.serialize_field(".tag", "add_member_to_exceptions")?;
                s.end()
            }
        }
    }
}

/// Policy governing which shared folders a team member can join.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedFolderJoinPolicy {
    /// Team members can only join folders shared by teammates.
    FromTeamOnly,
    /// Team members can join any shared folder, including those shared by users outside the team.
    FromAnyone,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderJoinPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedFolderJoinPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderJoinPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "from_team_only" => SharedFolderJoinPolicy::FromTeamOnly,
                    "from_anyone" => SharedFolderJoinPolicy::FromAnyone,
                    _ => SharedFolderJoinPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["from_team_only",
                                    "from_anyone",
                                    "other"];
        deserializer.deserialize_struct("SharedFolderJoinPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderJoinPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedFolderJoinPolicy::FromTeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderJoinPolicy", 1)?;
                s.serialize_field(".tag", "from_team_only")?;
                s.end()
            }
            SharedFolderJoinPolicy::FromAnyone => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderJoinPolicy", 1)?;
                s.serialize_field(".tag", "from_anyone")?;
                s.end()
            }
            SharedFolderJoinPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Policy governing who can be a member of a folder shared by a team member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedFolderMemberPolicy {
    /// Only a teammate can be a member of a folder shared by a team member.
    Team,
    /// Anyone can be a member of a folder shared by a team member.
    Anyone,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderMemberPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedFolderMemberPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderMemberPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team" => SharedFolderMemberPolicy::Team,
                    "anyone" => SharedFolderMemberPolicy::Anyone,
                    _ => SharedFolderMemberPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team",
                                    "anyone",
                                    "other"];
        deserializer.deserialize_struct("SharedFolderMemberPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderMemberPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedFolderMemberPolicy::Team => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderMemberPolicy", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            SharedFolderMemberPolicy::Anyone => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderMemberPolicy", 1)?;
                s.serialize_field(".tag", "anyone")?;
                s.end()
            }
            SharedFolderMemberPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Policy governing the visibility of shared links. This policy can apply to newly created shared
/// links, or all shared links.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkCreatePolicy {
    /// By default, anyone can access newly created shared links. No login will be required to
    /// access the shared links unless overridden.
    DefaultPublic,
    /// By default, only members of the same team can access newly created shared links. Login will
    /// be required to access the shared links unless overridden.
    DefaultTeamOnly,
    /// Only members of the same team can access all shared links. Login will be required to access
    /// all shared links.
    TeamOnly,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkCreatePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkCreatePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkCreatePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "default_public" => SharedLinkCreatePolicy::DefaultPublic,
                    "default_team_only" => SharedLinkCreatePolicy::DefaultTeamOnly,
                    "team_only" => SharedLinkCreatePolicy::TeamOnly,
                    _ => SharedLinkCreatePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["default_public",
                                    "default_team_only",
                                    "team_only",
                                    "other"];
        deserializer.deserialize_struct("SharedLinkCreatePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkCreatePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkCreatePolicy::DefaultPublic => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkCreatePolicy", 1)?;
                s.serialize_field(".tag", "default_public")?;
                s.end()
            }
            SharedLinkCreatePolicy::DefaultTeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkCreatePolicy", 1)?;
                s.serialize_field(".tag", "default_team_only")?;
                s.end()
            }
            SharedLinkCreatePolicy::TeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkCreatePolicy", 1)?;
                s.serialize_field(".tag", "team_only")?;
                s.end()
            }
            SharedLinkCreatePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ShowcaseDownloadPolicy {
    /// Do not allow files to be downloaded from Showcases.
    Disabled,
    /// Allow files to be downloaded from Showcases.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ShowcaseDownloadPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShowcaseDownloadPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShowcaseDownloadPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ShowcaseDownloadPolicy::Disabled,
                    "enabled" => ShowcaseDownloadPolicy::Enabled,
                    _ => ShowcaseDownloadPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("ShowcaseDownloadPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShowcaseDownloadPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShowcaseDownloadPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseDownloadPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ShowcaseDownloadPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseDownloadPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ShowcaseDownloadPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ShowcaseEnabledPolicy {
    /// Showcase is disabled.
    Disabled,
    /// Showcase is enabled.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ShowcaseEnabledPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShowcaseEnabledPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShowcaseEnabledPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ShowcaseEnabledPolicy::Disabled,
                    "enabled" => ShowcaseEnabledPolicy::Enabled,
                    _ => ShowcaseEnabledPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("ShowcaseEnabledPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShowcaseEnabledPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShowcaseEnabledPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseEnabledPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ShowcaseEnabledPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseEnabledPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ShowcaseEnabledPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ShowcaseExternalSharingPolicy {
    /// Do not allow showcases to be shared with people not on the team.
    Disabled,
    /// Allow showcases to be shared with people not on the team.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ShowcaseExternalSharingPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShowcaseExternalSharingPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShowcaseExternalSharingPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => ShowcaseExternalSharingPolicy::Disabled,
                    "enabled" => ShowcaseExternalSharingPolicy::Enabled,
                    _ => ShowcaseExternalSharingPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("ShowcaseExternalSharingPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShowcaseExternalSharingPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShowcaseExternalSharingPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseExternalSharingPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ShowcaseExternalSharingPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ShowcaseExternalSharingPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ShowcaseExternalSharingPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SmartSyncPolicy {
    /// The specified content will be synced as local files by default.
    Local,
    /// The specified content will be synced as on-demand files by default.
    OnDemand,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SmartSyncPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SmartSyncPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SmartSyncPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "local" => SmartSyncPolicy::Local,
                    "on_demand" => SmartSyncPolicy::OnDemand,
                    _ => SmartSyncPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["local",
                                    "on_demand",
                                    "other"];
        deserializer.deserialize_struct("SmartSyncPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SmartSyncPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SmartSyncPolicy::Local => {
                // unit
                let mut s = serializer.serialize_struct("SmartSyncPolicy", 1)?;
                s.serialize_field(".tag", "local")?;
                s.end()
            }
            SmartSyncPolicy::OnDemand => {
                // unit
                let mut s = serializer.serialize_struct("SmartSyncPolicy", 1)?;
                s.serialize_field(".tag", "on_demand")?;
                s.end()
            }
            SmartSyncPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SmarterSmartSyncPolicyState {
    /// Smarter Smart Sync feature is disabled.
    Disabled,
    /// Smarter Smart Sync feature is enabled.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SmarterSmartSyncPolicyState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SmarterSmartSyncPolicyState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SmarterSmartSyncPolicyState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => SmarterSmartSyncPolicyState::Disabled,
                    "enabled" => SmarterSmartSyncPolicyState::Enabled,
                    _ => SmarterSmartSyncPolicyState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("SmarterSmartSyncPolicyState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SmarterSmartSyncPolicyState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SmarterSmartSyncPolicyState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("SmarterSmartSyncPolicyState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            SmarterSmartSyncPolicyState::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("SmarterSmartSyncPolicyState", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            SmarterSmartSyncPolicyState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SsoPolicy {
    /// Users will be able to sign in with their Dropbox credentials.
    Disabled,
    /// Users will be able to sign in with either their Dropbox or single sign-on credentials.
    Optional,
    /// Users will be required to sign in with their single sign-on credentials.
    Required,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SsoPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SsoPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SsoPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => SsoPolicy::Disabled,
                    "optional" => SsoPolicy::Optional,
                    "required" => SsoPolicy::Required,
                    _ => SsoPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "optional",
                                    "required",
                                    "other"];
        deserializer.deserialize_struct("SsoPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SsoPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SsoPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("SsoPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            SsoPolicy::Optional => {
                // unit
                let mut s = serializer.serialize_struct("SsoPolicy", 1)?;
                s.serialize_field(".tag", "optional")?;
                s.end()
            }
            SsoPolicy::Required => {
                // unit
                let mut s = serializer.serialize_struct("SsoPolicy", 1)?;
                s.serialize_field(".tag", "required")?;
                s.end()
            }
            SsoPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SuggestMembersPolicy {
    /// Suggest members is disabled.
    Disabled,
    /// Suggest members is enabled.
    Enabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SuggestMembersPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SuggestMembersPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SuggestMembersPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disabled" => SuggestMembersPolicy::Disabled,
                    "enabled" => SuggestMembersPolicy::Enabled,
                    _ => SuggestMembersPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disabled",
                                    "enabled",
                                    "other"];
        deserializer.deserialize_struct("SuggestMembersPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SuggestMembersPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SuggestMembersPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("SuggestMembersPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            SuggestMembersPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("SuggestMembersPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            SuggestMembersPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Policies governing team members.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct TeamMemberPolicies {
    /// Policies governing sharing.
    pub sharing: TeamSharingPolicies,
    /// This describes the Enterprise Mobility Management (EMM) state for this team. This
    /// information can be used to understand if an organization is integrating with a third-party
    /// EMM vendor to further manage and apply restrictions upon the team's Dropbox usage on mobile
    /// devices. This is a new feature and in the future we'll be adding more new fields and
    /// additional documentation.
    pub emm_state: EmmState,
    /// The admin policy around the Dropbox Office Add-In for this team.
    pub office_addin: OfficeAddInPolicy,
    /// The team policy on if teammembers are allowed to suggest users for admins to invite to the
    /// team.
    pub suggest_members_policy: SuggestMembersPolicy,
}

impl TeamMemberPolicies {
    pub fn new(
        sharing: TeamSharingPolicies,
        emm_state: EmmState,
        office_addin: OfficeAddInPolicy,
        suggest_members_policy: SuggestMembersPolicy,
    ) -> Self {
        TeamMemberPolicies {
            sharing,
            emm_state,
            office_addin,
            suggest_members_policy,
        }
    }
}

const TEAM_MEMBER_POLICIES_FIELDS: &[&str] = &["sharing",
                                               "emm_state",
                                               "office_addin",
                                               "suggest_members_policy"];
impl TeamMemberPolicies {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<TeamMemberPolicies, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<TeamMemberPolicies>, V::Error> {
        let mut field_sharing = None;
        let mut field_emm_state = None;
        let mut field_office_addin = None;
        let mut field_suggest_members_policy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "sharing" => {
                    if field_sharing.is_some() {
                        return Err(::serde::de::Error::duplicate_field("sharing"));
                    }
                    field_sharing = Some(map.next_value()?);
                }
                "emm_state" => {
                    if field_emm_state.is_some() {
                        return Err(::serde::de::Error::duplicate_field("emm_state"));
                    }
                    field_emm_state = Some(map.next_value()?);
                }
                "office_addin" => {
                    if field_office_addin.is_some() {
                        return Err(::serde::de::Error::duplicate_field("office_addin"));
                    }
                    field_office_addin = Some(map.next_value()?);
                }
                "suggest_members_policy" => {
                    if field_suggest_members_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("suggest_members_policy"));
                    }
                    field_suggest_members_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = TeamMemberPolicies {
            sharing: field_sharing.ok_or_else(|| ::serde::de::Error::missing_field("sharing"))?,
            emm_state: field_emm_state.ok_or_else(|| ::serde::de::Error::missing_field("emm_state"))?,
            office_addin: field_office_addin.ok_or_else(|| ::serde::de::Error::missing_field("office_addin"))?,
            suggest_members_policy: field_suggest_members_policy.ok_or_else(|| ::serde::de::Error::missing_field("suggest_members_policy"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("sharing", &self.sharing)?;
        s.serialize_field("emm_state", &self.emm_state)?;
        s.serialize_field("office_addin", &self.office_addin)?;
        s.serialize_field("suggest_members_policy", &self.suggest_members_policy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for TeamMemberPolicies {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = TeamMemberPolicies;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TeamMemberPolicies struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                TeamMemberPolicies::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("TeamMemberPolicies", TEAM_MEMBER_POLICIES_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for TeamMemberPolicies {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("TeamMemberPolicies", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policies governing sharing within and outside of the team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct TeamSharingPolicies {
    /// Who can join folders shared by team members.
    pub shared_folder_member_policy: SharedFolderMemberPolicy,
    /// Which shared folders team members can join.
    pub shared_folder_join_policy: SharedFolderJoinPolicy,
    /// Who can view shared links owned by team members.
    pub shared_link_create_policy: SharedLinkCreatePolicy,
}

impl TeamSharingPolicies {
    pub fn new(
        shared_folder_member_policy: SharedFolderMemberPolicy,
        shared_folder_join_policy: SharedFolderJoinPolicy,
        shared_link_create_policy: SharedLinkCreatePolicy,
    ) -> Self {
        TeamSharingPolicies {
            shared_folder_member_policy,
            shared_folder_join_policy,
            shared_link_create_policy,
        }
    }
}

const TEAM_SHARING_POLICIES_FIELDS: &[&str] = &["shared_folder_member_policy",
                                                "shared_folder_join_policy",
                                                "shared_link_create_policy"];
impl TeamSharingPolicies {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<TeamSharingPolicies, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<TeamSharingPolicies>, V::Error> {
        let mut field_shared_folder_member_policy = None;
        let mut field_shared_folder_join_policy = None;
        let mut field_shared_link_create_policy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_member_policy" => {
                    if field_shared_folder_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_member_policy"));
                    }
                    field_shared_folder_member_policy = Some(map.next_value()?);
                }
                "shared_folder_join_policy" => {
                    if field_shared_folder_join_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_join_policy"));
                    }
                    field_shared_folder_join_policy = Some(map.next_value()?);
                }
                "shared_link_create_policy" => {
                    if field_shared_link_create_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link_create_policy"));
                    }
                    field_shared_link_create_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = TeamSharingPolicies {
            shared_folder_member_policy: field_shared_folder_member_policy.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_member_policy"))?,
            shared_folder_join_policy: field_shared_folder_join_policy.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_join_policy"))?,
            shared_link_create_policy: field_shared_link_create_policy.ok_or_else(|| ::serde::de::Error::missing_field("shared_link_create_policy"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_member_policy", &self.shared_folder_member_policy)?;
        s.serialize_field("shared_folder_join_policy", &self.shared_folder_join_policy)?;
        s.serialize_field("shared_link_create_policy", &self.shared_link_create_policy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for TeamSharingPolicies {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = TeamSharingPolicies;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TeamSharingPolicies struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                TeamSharingPolicies::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("TeamSharingPolicies", TEAM_SHARING_POLICIES_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for TeamSharingPolicies {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("TeamSharingPolicies", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum TwoStepVerificationPolicy {
    /// Enabled require two factor authorization.
    RequireTfaEnable,
    /// Disabled require two factor authorization.
    RequireTfaDisable,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for TwoStepVerificationPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = TwoStepVerificationPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TwoStepVerificationPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "require_tfa_enable" => TwoStepVerificationPolicy::RequireTfaEnable,
                    "require_tfa_disable" => TwoStepVerificationPolicy::RequireTfaDisable,
                    _ => TwoStepVerificationPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["require_tfa_enable",
                                    "require_tfa_disable",
                                    "other"];
        deserializer.deserialize_struct("TwoStepVerificationPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for TwoStepVerificationPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            TwoStepVerificationPolicy::RequireTfaEnable => {
                // unit
                let mut s = serializer.serialize_struct("TwoStepVerificationPolicy", 1)?;
                s.serialize_field(".tag", "require_tfa_enable")?;
                s.end()
            }
            TwoStepVerificationPolicy::RequireTfaDisable => {
                // unit
                let mut s = serializer.serialize_struct("TwoStepVerificationPolicy", 1)?;
                s.serialize_field(".tag", "require_tfa_disable")?;
                s.end()
            }
            TwoStepVerificationPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum TwoStepVerificationState {
    /// Enabled require two factor authorization.
    Required,
    /// Optional require two factor authorization.
    Optional,
    /// Disabled require two factor authorization.
    Disabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for TwoStepVerificationState {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = TwoStepVerificationState;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TwoStepVerificationState structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "required" => TwoStepVerificationState::Required,
                    "optional" => TwoStepVerificationState::Optional,
                    "disabled" => TwoStepVerificationState::Disabled,
                    _ => TwoStepVerificationState::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["required",
                                    "optional",
                                    "disabled",
                                    "other"];
        deserializer.deserialize_struct("TwoStepVerificationState", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for TwoStepVerificationState {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            TwoStepVerificationState::Required => {
                // unit
                let mut s = serializer.serialize_struct("TwoStepVerificationState", 1)?;
                s.serialize_field(".tag", "required")?;
                s.end()
            }
            TwoStepVerificationState::Optional => {
                // unit
                let mut s = serializer.serialize_struct("TwoStepVerificationState", 1)?;
                s.serialize_field(".tag", "optional")?;
                s.end()
            }
            TwoStepVerificationState::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("TwoStepVerificationState", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            TwoStepVerificationState::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

