// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

//! This namespace contains endpoints and data types for creating and managing shared links and
//! shared folders.

pub type DropboxId = String;
pub type GetSharedLinkFileArg = GetSharedLinkMetadataArg;
pub type Id = super::files::Id;
pub type Path = super::files::Path;
pub type PathOrId = String;
pub type ReadPath = super::files::ReadPath;
pub type Rev = super::files::Rev;
pub type TeamInfo = super::users::Team;

/// Adds specified members to a file.
pub fn add_file_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &AddFileMemberArgs,
) -> crate::Result<Result<Vec<FileMemberActionResult>, AddFileMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/add_file_member",
        arg,
        None)
}

/// Allows an owner or editor (if the ACL update policy allows) of a shared folder to add another
/// member. For the new member to get access to all the functionality for this folder, you will need
/// to call [`mount_folder()`](mount_folder) on their behalf.
pub fn add_folder_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &AddFolderMemberArg,
) -> crate::Result<Result<(), AddFolderMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/add_folder_member",
        arg,
        None)
}

/// Identical to update_file_member but with less information returned.
#[deprecated(note = "replaced by update_file_member")]
pub fn change_file_member_access(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ChangeFileMemberAccessArgs,
) -> crate::Result<Result<FileMemberActionResult, FileMemberActionError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/change_file_member_access",
        arg,
        None)
}

/// Returns the status of an asynchronous job.
pub fn check_job_status(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<JobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/check_job_status",
        arg,
        None)
}

/// Returns the status of an asynchronous job for sharing a folder.
pub fn check_remove_member_job_status(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<RemoveMemberJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/check_remove_member_job_status",
        arg,
        None)
}

/// Returns the status of an asynchronous job for sharing a folder.
pub fn check_share_job_status(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &super::dbx_async::PollArg,
) -> crate::Result<Result<ShareFolderJobStatus, super::dbx_async::PollError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/check_share_job_status",
        arg,
        None)
}

/// Create a shared link. If a shared link already exists for the given path, that link is returned.
/// Note that in the returned [`PathLinkMetadata`](PathLinkMetadata), the
/// [`PathLinkMetadata::url`](PathLinkMetadata) field is the shortened URL if
/// [`CreateSharedLinkArg::short_url`](CreateSharedLinkArg) argument is set to `true`. Previously,
/// it was technically possible to break a shared link by moving or renaming the corresponding file
/// or folder. In the future, this will no longer be the case, so your app shouldn't rely on this
/// behavior. Instead, if your app needs to revoke a shared link, use
/// [`revoke_shared_link()`](revoke_shared_link).
#[deprecated(note = "replaced by create_shared_link_with_settings")]
pub fn create_shared_link(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateSharedLinkArg,
) -> crate::Result<Result<PathLinkMetadata, CreateSharedLinkError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/create_shared_link",
        arg,
        None)
}

/// Create a shared link with custom settings. If no settings are given then the default visibility
/// is [`RequestedVisibility::Public`](RequestedVisibility::Public) (The resolved visibility,
/// though, may depend on other aspects such as team and shared folder settings).
pub fn create_shared_link_with_settings(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &CreateSharedLinkWithSettingsArg,
) -> crate::Result<Result<SharedLinkMetadata, CreateSharedLinkWithSettingsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/create_shared_link_with_settings",
        arg,
        None)
}

/// Returns shared file metadata.
pub fn get_file_metadata(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetFileMetadataArg,
) -> crate::Result<Result<SharedFileMetadata, GetFileMetadataError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/get_file_metadata",
        arg,
        None)
}

/// Returns shared file metadata.
pub fn get_file_metadata_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetFileMetadataBatchArg,
) -> crate::Result<Result<Vec<GetFileMetadataBatchResult>, SharingUserError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/get_file_metadata/batch",
        arg,
        None)
}

/// Returns shared folder metadata by its folder ID.
pub fn get_folder_metadata(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetMetadataArgs,
) -> crate::Result<Result<SharedFolderMetadata, SharedFolderAccessError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/get_folder_metadata",
        arg,
        None)
}

/// Download the shared link's file from a user's Dropbox.
pub fn get_shared_link_file(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetSharedLinkFileArg,
    range_start: Option<u64>,
    range_end: Option<u64>,
) -> crate::Result<Result<crate::client_trait::HttpRequestResult<SharedLinkMetadata>, GetSharedLinkFileError>> {
    crate::client_helpers::request_with_body(
        client,
        crate::client_trait::Endpoint::Content,
        crate::client_trait::Style::Download,
        "sharing/get_shared_link_file",
        arg,
        None,
        range_start,
        range_end)
}

/// Get the shared link's metadata.
pub fn get_shared_link_metadata(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetSharedLinkMetadataArg,
) -> crate::Result<Result<SharedLinkMetadata, SharedLinkError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/get_shared_link_metadata",
        arg,
        None)
}

/// Returns a list of [`LinkMetadata`](LinkMetadata) objects for this user, including collection
/// links. If no path is given, returns a list of all shared links for the current user, including
/// collection links, up to a maximum of 1000 links. If a non-empty path is given, returns a list of
/// all shared links that allow access to the given path.  Collection links are never returned in
/// this case. Note that the url field in the response is never the shortened URL.
#[deprecated(note = "replaced by list_shared_links")]
pub fn get_shared_links(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &GetSharedLinksArg,
) -> crate::Result<Result<GetSharedLinksResult, GetSharedLinksError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/get_shared_links",
        arg,
        None)
}

/// Use to obtain the members who have been invited to a file, both inherited and uninherited
/// members.
pub fn list_file_members(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFileMembersArg,
) -> crate::Result<Result<SharedFileMembers, ListFileMembersError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_file_members",
        arg,
        None)
}

/// Get members of multiple files at once. The arguments to this route are more limited, and the
/// limit on query result size per file is more strict. To customize the results more, use the
/// individual file endpoint. Inherited users and groups are not included in the result, and
/// permissions are not returned for this endpoint.
pub fn list_file_members_batch(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFileMembersBatchArg,
) -> crate::Result<Result<Vec<ListFileMembersBatchResult>, SharingUserError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_file_members/batch",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`list_file_members()`](list_file_members) or
/// [`list_file_members_batch()`](list_file_members_batch), use this to paginate through all shared
/// file members.
pub fn list_file_members_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFileMembersContinueArg,
) -> crate::Result<Result<SharedFileMembers, ListFileMembersContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_file_members/continue",
        arg,
        None)
}

/// Returns shared folder membership by its folder ID.
pub fn list_folder_members(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFolderMembersArgs,
) -> crate::Result<Result<SharedFolderMembers, SharedFolderAccessError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_folder_members",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`list_folder_members()`](list_folder_members), use this
/// to paginate through all shared folder members.
pub fn list_folder_members_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFolderMembersContinueArg,
) -> crate::Result<Result<SharedFolderMembers, ListFolderMembersContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_folder_members/continue",
        arg,
        None)
}

/// Return the list of all shared folders the current user has access to.
pub fn list_folders(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFoldersArgs,
) -> crate::Result<Result<ListFoldersResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_folders",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`list_folders()`](list_folders), use this to paginate
/// through all shared folders. The cursor must come from a previous call to
/// [`list_folders()`](list_folders) or [`list_folders_continue()`](list_folders_continue).
pub fn list_folders_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFoldersContinueArg,
) -> crate::Result<Result<ListFoldersResult, ListFoldersContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_folders/continue",
        arg,
        None)
}

/// Return the list of all shared folders the current user can mount or unmount.
pub fn list_mountable_folders(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFoldersArgs,
) -> crate::Result<Result<ListFoldersResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_mountable_folders",
        arg,
        None)
}

/// Once a cursor has been retrieved from [`list_mountable_folders()`](list_mountable_folders), use
/// this to paginate through all mountable shared folders. The cursor must come from a previous call
/// to [`list_mountable_folders()`](list_mountable_folders) or
/// [`list_mountable_folders_continue()`](list_mountable_folders_continue).
pub fn list_mountable_folders_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFoldersContinueArg,
) -> crate::Result<Result<ListFoldersResult, ListFoldersContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_mountable_folders/continue",
        arg,
        None)
}

/// Returns a list of all files shared with current user.  Does not include files the user has
/// received via shared folders, and does  not include unclaimed invitations.
pub fn list_received_files(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFilesArg,
) -> crate::Result<Result<ListFilesResult, SharingUserError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_received_files",
        arg,
        None)
}

/// Get more results with a cursor from [`list_received_files()`](list_received_files).
pub fn list_received_files_continue(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListFilesContinueArg,
) -> crate::Result<Result<ListFilesResult, ListFilesContinueError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_received_files/continue",
        arg,
        None)
}

/// List shared links of this user. If no path is given, returns a list of all shared links for the
/// current user. For members of business teams using team space and member folders, returns all
/// shared links in the team member's home folder unless the team space ID is specified in the
/// request header. For more information, refer to the [Namespace
/// Guide](https://www.dropbox.com/developers/reference/namespace-guide). If a non-empty path is
/// given, returns a list of all shared links that allow access to the given path - direct links to
/// the given path and links to parent folders of the given path. Links to parent folders can be
/// suppressed by setting direct_only to true.
pub fn list_shared_links(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ListSharedLinksArg,
) -> crate::Result<Result<ListSharedLinksResult, ListSharedLinksError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/list_shared_links",
        arg,
        None)
}

/// Modify the shared link's settings. If the requested visibility conflict with the shared links
/// policy of the team or the shared folder (in case the linked file is part of a shared folder)
/// then the [`LinkPermissions::resolved_visibility`](LinkPermissions) of the returned
/// [`SharedLinkMetadata`](SharedLinkMetadata) will reflect the actual visibility of the shared link
/// and the [`LinkPermissions::requested_visibility`](LinkPermissions) will reflect the requested
/// visibility.
pub fn modify_shared_link_settings(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ModifySharedLinkSettingsArgs,
) -> crate::Result<Result<SharedLinkMetadata, ModifySharedLinkSettingsError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/modify_shared_link_settings",
        arg,
        None)
}

/// The current user mounts the designated folder. Mount a shared folder for a user after they have
/// been added as a member. Once mounted, the shared folder will appear in their Dropbox.
pub fn mount_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &MountFolderArg,
) -> crate::Result<Result<SharedFolderMetadata, MountFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/mount_folder",
        arg,
        None)
}

/// The current user relinquishes their membership in the designated file. Note that the current
/// user may still have inherited access to this file through the parent folder.
pub fn relinquish_file_membership(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelinquishFileMembershipArg,
) -> crate::Result<Result<(), RelinquishFileMembershipError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/relinquish_file_membership",
        arg,
        None)
}

/// The current user relinquishes their membership in the designated shared folder and will no
/// longer have access to the folder.  A folder owner cannot relinquish membership in their own
/// folder. This will run synchronously if leave_a_copy is false, and asynchronously if leave_a_copy
/// is true.
pub fn relinquish_folder_membership(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RelinquishFolderMembershipArg,
) -> crate::Result<Result<super::dbx_async::LaunchEmptyResult, RelinquishFolderMembershipError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/relinquish_folder_membership",
        arg,
        None)
}

/// Identical to remove_file_member_2 but with less information returned.
#[deprecated(note = "replaced by remove_file_member_2")]
pub fn remove_file_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RemoveFileMemberArg,
) -> crate::Result<Result<FileMemberActionIndividualResult, RemoveFileMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/remove_file_member",
        arg,
        None)
}

/// Removes a specified member from the file.
pub fn remove_file_member_2(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RemoveFileMemberArg,
) -> crate::Result<Result<FileMemberRemoveActionResult, RemoveFileMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/remove_file_member_2",
        arg,
        None)
}

/// Allows an owner or editor (if the ACL update policy allows) of a shared folder to remove another
/// member.
pub fn remove_folder_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RemoveFolderMemberArg,
) -> crate::Result<Result<super::dbx_async::LaunchResultBase, RemoveFolderMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/remove_folder_member",
        arg,
        None)
}

/// Revoke a shared link. Note that even after revoking a shared link to a file, the file may be
/// accessible if there are shared links leading to any of the file parent folders. To list all
/// shared links that enable access to a specific file, you can use the
/// [`list_shared_links()`](list_shared_links) with the file as the
/// [`ListSharedLinksArg::path`](ListSharedLinksArg) argument.
pub fn revoke_shared_link(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &RevokeSharedLinkArg,
) -> crate::Result<Result<(), RevokeSharedLinkError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/revoke_shared_link",
        arg,
        None)
}

/// Change the inheritance policy of an existing Shared Folder. Only permitted for shared folders in
/// a shared team root. If a [`ShareFolderLaunch::AsyncJobId`](ShareFolderLaunch::AsyncJobId) is
/// returned, you'll need to call [`check_share_job_status()`](check_share_job_status) until the
/// action completes to get the metadata for the folder.
pub fn set_access_inheritance(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &SetAccessInheritanceArg,
) -> crate::Result<Result<ShareFolderLaunch, SetAccessInheritanceError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/set_access_inheritance",
        arg,
        None)
}

/// Share a folder with collaborators. Most sharing will be completed synchronously. Large folders
/// will be completed asynchronously. To make testing the async case repeatable, set
/// `ShareFolderArg.force_async`. If a
/// [`ShareFolderLaunch::AsyncJobId`](ShareFolderLaunch::AsyncJobId) is returned, you'll need to
/// call [`check_share_job_status()`](check_share_job_status) until the action completes to get the
/// metadata for the folder.
pub fn share_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &ShareFolderArg,
) -> crate::Result<Result<ShareFolderLaunch, ShareFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/share_folder",
        arg,
        None)
}

/// Transfer ownership of a shared folder to a member of the shared folder. User must have
/// [`AccessLevel::Owner`](AccessLevel::Owner) access to the shared folder to perform a transfer.
pub fn transfer_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &TransferFolderArg,
) -> crate::Result<Result<(), TransferFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/transfer_folder",
        arg,
        None)
}

/// The current user unmounts the designated folder. They can re-mount the folder at a later time
/// using [`mount_folder()`](mount_folder).
pub fn unmount_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UnmountFolderArg,
) -> crate::Result<Result<(), UnmountFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/unmount_folder",
        arg,
        None)
}

/// Remove all members from this file. Does not remove inherited members.
pub fn unshare_file(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UnshareFileArg,
) -> crate::Result<Result<(), UnshareFileError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/unshare_file",
        arg,
        None)
}

/// Allows a shared folder owner to unshare the folder. You'll need to call
/// [`check_job_status()`](check_job_status) to determine if the action has completed successfully.
pub fn unshare_folder(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UnshareFolderArg,
) -> crate::Result<Result<super::dbx_async::LaunchEmptyResult, UnshareFolderError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/unshare_folder",
        arg,
        None)
}

/// Changes a member's access on a shared file.
pub fn update_file_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UpdateFileMemberArgs,
) -> crate::Result<Result<MemberAccessLevelResult, FileMemberActionError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/update_file_member",
        arg,
        None)
}

/// Allows an owner or editor of a shared folder to update another member's permissions.
pub fn update_folder_member(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UpdateFolderMemberArg,
) -> crate::Result<Result<MemberAccessLevelResult, UpdateFolderMemberError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/update_folder_member",
        arg,
        None)
}

/// Update the sharing policies for a shared folder. User must have
/// [`AccessLevel::Owner`](AccessLevel::Owner) access to the shared folder to update its policies.
pub fn update_folder_policy(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &UpdateFolderPolicyArg,
) -> crate::Result<Result<SharedFolderMetadata, UpdateFolderPolicyError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "sharing/update_folder_policy",
        arg,
        None)
}

/// Information about the inheritance policy of a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccessInheritance {
    /// The shared folder inherits its members from the parent folder.
    Inherit,
    /// The shared folder does not inherit its members from the parent folder.
    NoInherit,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccessInheritance {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccessInheritance;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccessInheritance structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "inherit" => AccessInheritance::Inherit,
                    "no_inherit" => AccessInheritance::NoInherit,
                    _ => AccessInheritance::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["inherit",
                                    "no_inherit",
                                    "other"];
        deserializer.deserialize_struct("AccessInheritance", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccessInheritance {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccessInheritance::Inherit => {
                // unit
                let mut s = serializer.serialize_struct("AccessInheritance", 1)?;
                s.serialize_field(".tag", "inherit")?;
                s.end()
            }
            AccessInheritance::NoInherit => {
                // unit
                let mut s = serializer.serialize_struct("AccessInheritance", 1)?;
                s.serialize_field(".tag", "no_inherit")?;
                s.end()
            }
            AccessInheritance::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Defines the access levels for collaborators.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AccessLevel {
    /// The collaborator is the owner of the shared folder. Owners can view and edit the shared
    /// folder as well as set the folder's policies using
    /// [`update_folder_policy()`](update_folder_policy).
    Owner,
    /// The collaborator can both view and edit the shared folder.
    Editor,
    /// The collaborator can only view the shared folder.
    Viewer,
    /// The collaborator can only view the shared folder and does not have any access to comments.
    ViewerNoComment,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AccessLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AccessLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AccessLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "owner" => AccessLevel::Owner,
                    "editor" => AccessLevel::Editor,
                    "viewer" => AccessLevel::Viewer,
                    "viewer_no_comment" => AccessLevel::ViewerNoComment,
                    _ => AccessLevel::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["owner",
                                    "editor",
                                    "viewer",
                                    "viewer_no_comment",
                                    "other"];
        deserializer.deserialize_struct("AccessLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AccessLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AccessLevel::Owner => {
                // unit
                let mut s = serializer.serialize_struct("AccessLevel", 1)?;
                s.serialize_field(".tag", "owner")?;
                s.end()
            }
            AccessLevel::Editor => {
                // unit
                let mut s = serializer.serialize_struct("AccessLevel", 1)?;
                s.serialize_field(".tag", "editor")?;
                s.end()
            }
            AccessLevel::Viewer => {
                // unit
                let mut s = serializer.serialize_struct("AccessLevel", 1)?;
                s.serialize_field(".tag", "viewer")?;
                s.end()
            }
            AccessLevel::ViewerNoComment => {
                // unit
                let mut s = serializer.serialize_struct("AccessLevel", 1)?;
                s.serialize_field(".tag", "viewer_no_comment")?;
                s.end()
            }
            AccessLevel::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Who can change a shared folder's access control list (ACL). In other words, who can add, remove,
/// or change the privileges of members.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AclUpdatePolicy {
    /// Only the owner can update the ACL.
    Owner,
    /// Any editor can update the ACL. This may be further restricted to editors on the same team.
    Editors,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AclUpdatePolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AclUpdatePolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AclUpdatePolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "owner" => AclUpdatePolicy::Owner,
                    "editors" => AclUpdatePolicy::Editors,
                    _ => AclUpdatePolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["owner",
                                    "editors",
                                    "other"];
        deserializer.deserialize_struct("AclUpdatePolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AclUpdatePolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AclUpdatePolicy::Owner => {
                // unit
                let mut s = serializer.serialize_struct("AclUpdatePolicy", 1)?;
                s.serialize_field(".tag", "owner")?;
                s.end()
            }
            AclUpdatePolicy::Editors => {
                // unit
                let mut s = serializer.serialize_struct("AclUpdatePolicy", 1)?;
                s.serialize_field(".tag", "editors")?;
                s.end()
            }
            AclUpdatePolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Arguments for [`add_file_member()`](add_file_member).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddFileMemberArgs {
    /// File to which to add members.
    pub file: PathOrId,
    /// Members to add. Note that even an email address is given, this may result in a user being
    /// directy added to the membership if that email is the user's main account email.
    pub members: Vec<MemberSelector>,
    /// Message to send to added members in their invitation.
    pub custom_message: Option<String>,
    /// Whether added members should be notified via device notifications of their invitation.
    pub quiet: bool,
    /// AccessLevel union object, describing what access level we want to give new members.
    pub access_level: AccessLevel,
    /// If the custom message should be added as a comment on the file.
    pub add_message_as_comment: bool,
}

impl AddFileMemberArgs {
    pub fn new(file: PathOrId, members: Vec<MemberSelector>) -> Self {
        AddFileMemberArgs {
            file,
            members,
            custom_message: None,
            quiet: false,
            access_level: AccessLevel::Viewer,
            add_message_as_comment: false,
        }
    }

    pub fn with_custom_message(mut self, value: String) -> Self {
        self.custom_message = Some(value);
        self
    }

    pub fn with_quiet(mut self, value: bool) -> Self {
        self.quiet = value;
        self
    }

    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = value;
        self
    }

    pub fn with_add_message_as_comment(mut self, value: bool) -> Self {
        self.add_message_as_comment = value;
        self
    }
}

const ADD_FILE_MEMBER_ARGS_FIELDS: &[&str] = &["file",
                                               "members",
                                               "custom_message",
                                               "quiet",
                                               "access_level",
                                               "add_message_as_comment"];
impl AddFileMemberArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddFileMemberArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddFileMemberArgs>, V::Error> {
        let mut field_file = None;
        let mut field_members = None;
        let mut field_custom_message = None;
        let mut field_quiet = None;
        let mut field_access_level = None;
        let mut field_add_message_as_comment = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "custom_message" => {
                    if field_custom_message.is_some() {
                        return Err(::serde::de::Error::duplicate_field("custom_message"));
                    }
                    field_custom_message = Some(map.next_value()?);
                }
                "quiet" => {
                    if field_quiet.is_some() {
                        return Err(::serde::de::Error::duplicate_field("quiet"));
                    }
                    field_quiet = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "add_message_as_comment" => {
                    if field_add_message_as_comment.is_some() {
                        return Err(::serde::de::Error::duplicate_field("add_message_as_comment"));
                    }
                    field_add_message_as_comment = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddFileMemberArgs {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            custom_message: field_custom_message,
            quiet: field_quiet.unwrap_or(false),
            access_level: field_access_level.unwrap_or(AccessLevel::Viewer),
            add_message_as_comment: field_add_message_as_comment.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("custom_message", &self.custom_message)?;
        s.serialize_field("quiet", &self.quiet)?;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("add_message_as_comment", &self.add_message_as_comment)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddFileMemberArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddFileMemberArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddFileMemberArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddFileMemberArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddFileMemberArgs", ADD_FILE_MEMBER_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddFileMemberArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddFileMemberArgs", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Errors for [`add_file_member()`](add_file_member).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddFileMemberError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// The user has reached the rate limit for invitations.
    RateLimit,
    /// The custom message did not pass comment permissions checks.
    InvalidComment,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddFileMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddFileMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddFileMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => AddFileMemberError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => AddFileMemberError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "rate_limit" => AddFileMemberError::RateLimit,
                    "invalid_comment" => AddFileMemberError::InvalidComment,
                    _ => AddFileMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "rate_limit",
                                    "invalid_comment",
                                    "other"];
        deserializer.deserialize_struct("AddFileMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddFileMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddFileMemberError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AddFileMemberError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            AddFileMemberError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AddFileMemberError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            AddFileMemberError::RateLimit => {
                // unit
                let mut s = serializer.serialize_struct("AddFileMemberError", 1)?;
                s.serialize_field(".tag", "rate_limit")?;
                s.end()
            }
            AddFileMemberError::InvalidComment => {
                // unit
                let mut s = serializer.serialize_struct("AddFileMemberError", 1)?;
                s.serialize_field(".tag", "invalid_comment")?;
                s.end()
            }
            AddFileMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for AddFileMemberError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            AddFileMemberError::UserError(inner) => Some(inner),
            AddFileMemberError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for AddFileMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            AddFileMemberError::UserError(inner) => write!(f, "{}", inner),
            AddFileMemberError::AccessError(inner) => write!(f, "{}", inner),
            AddFileMemberError::RateLimit => f.write_str("The user has reached the rate limit for invitations."),
            AddFileMemberError::InvalidComment => f.write_str("The custom message did not pass comment permissions checks."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddFolderMemberArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The intended list of members to add.  Added members will receive invites to join the shared
    /// folder.
    pub members: Vec<AddMember>,
    /// Whether added members should be notified via email and device notifications of their invite.
    pub quiet: bool,
    /// Optional message to display to added members in their invitation.
    pub custom_message: Option<String>,
}

impl AddFolderMemberArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId, members: Vec<AddMember>) -> Self {
        AddFolderMemberArg {
            shared_folder_id,
            members,
            quiet: false,
            custom_message: None,
        }
    }

    pub fn with_quiet(mut self, value: bool) -> Self {
        self.quiet = value;
        self
    }

    pub fn with_custom_message(mut self, value: String) -> Self {
        self.custom_message = Some(value);
        self
    }
}

const ADD_FOLDER_MEMBER_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                "members",
                                                "quiet",
                                                "custom_message"];
impl AddFolderMemberArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddFolderMemberArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddFolderMemberArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_members = None;
        let mut field_quiet = None;
        let mut field_custom_message = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "quiet" => {
                    if field_quiet.is_some() {
                        return Err(::serde::de::Error::duplicate_field("quiet"));
                    }
                    field_quiet = Some(map.next_value()?);
                }
                "custom_message" => {
                    if field_custom_message.is_some() {
                        return Err(::serde::de::Error::duplicate_field("custom_message"));
                    }
                    field_custom_message = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddFolderMemberArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            quiet: field_quiet.unwrap_or(false),
            custom_message: field_custom_message,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("quiet", &self.quiet)?;
        s.serialize_field("custom_message", &self.custom_message)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddFolderMemberArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddFolderMemberArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddFolderMemberArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddFolderMemberArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddFolderMemberArg", ADD_FOLDER_MEMBER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddFolderMemberArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddFolderMemberArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddFolderMemberError {
    /// Unable to access shared folder.
    AccessError(SharedFolderAccessError),
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// The current user has been banned.
    BannedMember,
    /// [`AddFolderMemberArg::members`](AddFolderMemberArg) contains a bad invitation recipient.
    BadMember(AddMemberSelectorError),
    /// Your team policy does not allow sharing outside of the team.
    CantShareOutsideTeam,
    /// The value is the member limit that was reached.
    TooManyMembers(u64),
    /// The value is the pending invite limit that was reached.
    TooManyPendingInvites(u64),
    /// The current user has hit the limit of invites they can send per day. Try again in 24 hours.
    RateLimit,
    /// The current user is trying to share with too many people at once.
    TooManyInvitees,
    /// The current user's account doesn't support this action. An example of this is when adding a
    /// read-only member. This action can only be performed by users that have upgraded to a Pro or
    /// Business plan.
    InsufficientPlan,
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Invalid shared folder error will be returned as an access_error.
    InvalidSharedFolder,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddFolderMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddFolderMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddFolderMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => AddFolderMemberError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "email_unverified" => AddFolderMemberError::EmailUnverified,
                    "banned_member" => AddFolderMemberError::BannedMember,
                    "bad_member" => {
                        match map.next_key()? {
                            Some("bad_member") => AddFolderMemberError::BadMember(map.next_value()?),
                            None => return Err(de::Error::missing_field("bad_member")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "cant_share_outside_team" => AddFolderMemberError::CantShareOutsideTeam,
                    "too_many_members" => {
                        match map.next_key()? {
                            Some("too_many_members") => AddFolderMemberError::TooManyMembers(map.next_value()?),
                            None => return Err(de::Error::missing_field("too_many_members")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "too_many_pending_invites" => {
                        match map.next_key()? {
                            Some("too_many_pending_invites") => AddFolderMemberError::TooManyPendingInvites(map.next_value()?),
                            None => return Err(de::Error::missing_field("too_many_pending_invites")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "rate_limit" => AddFolderMemberError::RateLimit,
                    "too_many_invitees" => AddFolderMemberError::TooManyInvitees,
                    "insufficient_plan" => AddFolderMemberError::InsufficientPlan,
                    "team_folder" => AddFolderMemberError::TeamFolder,
                    "no_permission" => AddFolderMemberError::NoPermission,
                    "invalid_shared_folder" => AddFolderMemberError::InvalidSharedFolder,
                    _ => AddFolderMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "email_unverified",
                                    "banned_member",
                                    "bad_member",
                                    "cant_share_outside_team",
                                    "too_many_members",
                                    "too_many_pending_invites",
                                    "rate_limit",
                                    "too_many_invitees",
                                    "insufficient_plan",
                                    "team_folder",
                                    "no_permission",
                                    "invalid_shared_folder",
                                    "other"];
        deserializer.deserialize_struct("AddFolderMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddFolderMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddFolderMemberError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AddFolderMemberError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            AddFolderMemberError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            AddFolderMemberError::BannedMember => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "banned_member")?;
                s.end()
            }
            AddFolderMemberError::BadMember(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("AddFolderMemberError", 2)?;
                s.serialize_field(".tag", "bad_member")?;
                s.serialize_field("bad_member", x)?;
                s.end()
            }
            AddFolderMemberError::CantShareOutsideTeam => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "cant_share_outside_team")?;
                s.end()
            }
            AddFolderMemberError::TooManyMembers(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddFolderMemberError", 2)?;
                s.serialize_field(".tag", "too_many_members")?;
                s.serialize_field("too_many_members", x)?;
                s.end()
            }
            AddFolderMemberError::TooManyPendingInvites(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddFolderMemberError", 2)?;
                s.serialize_field(".tag", "too_many_pending_invites")?;
                s.serialize_field("too_many_pending_invites", x)?;
                s.end()
            }
            AddFolderMemberError::RateLimit => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "rate_limit")?;
                s.end()
            }
            AddFolderMemberError::TooManyInvitees => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "too_many_invitees")?;
                s.end()
            }
            AddFolderMemberError::InsufficientPlan => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "insufficient_plan")?;
                s.end()
            }
            AddFolderMemberError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            AddFolderMemberError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            AddFolderMemberError::InvalidSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("AddFolderMemberError", 1)?;
                s.serialize_field(".tag", "invalid_shared_folder")?;
                s.end()
            }
            AddFolderMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for AddFolderMemberError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            AddFolderMemberError::AccessError(inner) => Some(inner),
            AddFolderMemberError::BadMember(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for AddFolderMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            AddFolderMemberError::AccessError(inner) => write!(f, "Unable to access shared folder: {}", inner),
            AddFolderMemberError::BannedMember => f.write_str("The current user has been banned."),
            AddFolderMemberError::BadMember(inner) => write!(f, "{}", inner),
            AddFolderMemberError::CantShareOutsideTeam => f.write_str("Your team policy does not allow sharing outside of the team."),
            AddFolderMemberError::TooManyMembers(inner) => write!(f, "The value is the member limit that was reached: {:?}", inner),
            AddFolderMemberError::TooManyPendingInvites(inner) => write!(f, "The value is the pending invite limit that was reached: {:?}", inner),
            AddFolderMemberError::RateLimit => f.write_str("The current user has hit the limit of invites they can send per day. Try again in 24 hours."),
            AddFolderMemberError::TooManyInvitees => f.write_str("The current user is trying to share with too many people at once."),
            AddFolderMemberError::InsufficientPlan => f.write_str("The current user's account doesn't support this action. An example of this is when adding a read-only member. This action can only be performed by users that have upgraded to a Pro or Business plan."),
            AddFolderMemberError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            AddFolderMemberError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            AddFolderMemberError::InvalidSharedFolder => f.write_str("Invalid shared folder error will be returned as an access_error."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// The member and type of access the member should have when added to a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AddMember {
    /// The member to add to the shared folder.
    pub member: MemberSelector,
    /// The access level to grant `member` to the shared folder.
    /// [`AccessLevel::Owner`](AccessLevel::Owner) is disallowed.
    pub access_level: AccessLevel,
}

impl AddMember {
    pub fn new(member: MemberSelector) -> Self {
        AddMember {
            member,
            access_level: AccessLevel::Viewer,
        }
    }

    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = value;
        self
    }
}

const ADD_MEMBER_FIELDS: &[&str] = &["member",
                                     "access_level"];
impl AddMember {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AddMember, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AddMember>, V::Error> {
        let mut field_member = None;
        let mut field_access_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AddMember {
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            access_level: field_access_level.unwrap_or(AccessLevel::Viewer),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("access_level", &self.access_level)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AddMember {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AddMember;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddMember struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AddMember::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AddMember", ADD_MEMBER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AddMember {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AddMember", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum AddMemberSelectorError {
    /// Automatically created groups can only be added to team folders.
    AutomaticGroup,
    /// The value is the ID that could not be identified.
    InvalidDropboxId(DropboxId),
    /// The value is the e-email address that is malformed.
    InvalidEmail(super::common::EmailAddress),
    /// The value is the ID of the Dropbox user with an unverified email address. Invite unverified
    /// users by email address instead of by their Dropbox ID.
    UnverifiedDropboxId(DropboxId),
    /// At least one of the specified groups in [`AddFolderMemberArg::members`](AddFolderMemberArg)
    /// is deleted.
    GroupDeleted,
    /// Sharing to a group that is not on the current user's team.
    GroupNotOnTeam,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for AddMemberSelectorError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = AddMemberSelectorError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AddMemberSelectorError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "automatic_group" => AddMemberSelectorError::AutomaticGroup,
                    "invalid_dropbox_id" => {
                        match map.next_key()? {
                            Some("invalid_dropbox_id") => AddMemberSelectorError::InvalidDropboxId(map.next_value()?),
                            None => return Err(de::Error::missing_field("invalid_dropbox_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_email" => {
                        match map.next_key()? {
                            Some("invalid_email") => AddMemberSelectorError::InvalidEmail(map.next_value()?),
                            None => return Err(de::Error::missing_field("invalid_email")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "unverified_dropbox_id" => {
                        match map.next_key()? {
                            Some("unverified_dropbox_id") => AddMemberSelectorError::UnverifiedDropboxId(map.next_value()?),
                            None => return Err(de::Error::missing_field("unverified_dropbox_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "group_deleted" => AddMemberSelectorError::GroupDeleted,
                    "group_not_on_team" => AddMemberSelectorError::GroupNotOnTeam,
                    _ => AddMemberSelectorError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["automatic_group",
                                    "invalid_dropbox_id",
                                    "invalid_email",
                                    "unverified_dropbox_id",
                                    "group_deleted",
                                    "group_not_on_team",
                                    "other"];
        deserializer.deserialize_struct("AddMemberSelectorError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for AddMemberSelectorError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            AddMemberSelectorError::AutomaticGroup => {
                // unit
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 1)?;
                s.serialize_field(".tag", "automatic_group")?;
                s.end()
            }
            AddMemberSelectorError::InvalidDropboxId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 2)?;
                s.serialize_field(".tag", "invalid_dropbox_id")?;
                s.serialize_field("invalid_dropbox_id", x)?;
                s.end()
            }
            AddMemberSelectorError::InvalidEmail(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 2)?;
                s.serialize_field(".tag", "invalid_email")?;
                s.serialize_field("invalid_email", x)?;
                s.end()
            }
            AddMemberSelectorError::UnverifiedDropboxId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 2)?;
                s.serialize_field(".tag", "unverified_dropbox_id")?;
                s.serialize_field("unverified_dropbox_id", x)?;
                s.end()
            }
            AddMemberSelectorError::GroupDeleted => {
                // unit
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 1)?;
                s.serialize_field(".tag", "group_deleted")?;
                s.end()
            }
            AddMemberSelectorError::GroupNotOnTeam => {
                // unit
                let mut s = serializer.serialize_struct("AddMemberSelectorError", 1)?;
                s.serialize_field(".tag", "group_not_on_team")?;
                s.end()
            }
            AddMemberSelectorError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for AddMemberSelectorError {
}

impl ::std::fmt::Display for AddMemberSelectorError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            AddMemberSelectorError::AutomaticGroup => f.write_str("Automatically created groups can only be added to team folders."),
            AddMemberSelectorError::InvalidDropboxId(inner) => write!(f, "The value is the ID that could not be identified: {:?}", inner),
            AddMemberSelectorError::InvalidEmail(inner) => write!(f, "The value is the e-email address that is malformed: {:?}", inner),
            AddMemberSelectorError::UnverifiedDropboxId(inner) => write!(f, "The value is the ID of the Dropbox user with an unverified email address. Invite unverified users by email address instead of by their Dropbox ID: {:?}", inner),
            AddMemberSelectorError::GroupNotOnTeam => f.write_str("Sharing to a group that is not on the current user's team."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Information about the content that has a link audience different than that of this folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AudienceExceptionContentInfo {
    /// The name of the content, which is either a file or a folder.
    pub name: String,
}

impl AudienceExceptionContentInfo {
    pub fn new(name: String) -> Self {
        AudienceExceptionContentInfo {
            name,
        }
    }
}

const AUDIENCE_EXCEPTION_CONTENT_INFO_FIELDS: &[&str] = &["name"];
impl AudienceExceptionContentInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AudienceExceptionContentInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AudienceExceptionContentInfo>, V::Error> {
        let mut field_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AudienceExceptionContentInfo {
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("name", &self.name)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AudienceExceptionContentInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AudienceExceptionContentInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AudienceExceptionContentInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AudienceExceptionContentInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AudienceExceptionContentInfo", AUDIENCE_EXCEPTION_CONTENT_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AudienceExceptionContentInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AudienceExceptionContentInfo", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The total count and truncated list of information of content inside this folder that has a
/// different audience than the link on this folder. This is only returned for folders.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AudienceExceptions {
    pub count: u32,
    /// A truncated list of some of the content that is an exception. The length of this list could
    /// be smaller than the count since it is only a sample but will not be empty as long as count
    /// is not 0.
    pub exceptions: Vec<AudienceExceptionContentInfo>,
}

impl AudienceExceptions {
    pub fn new(count: u32, exceptions: Vec<AudienceExceptionContentInfo>) -> Self {
        AudienceExceptions {
            count,
            exceptions,
        }
    }
}

const AUDIENCE_EXCEPTIONS_FIELDS: &[&str] = &["count",
                                              "exceptions"];
impl AudienceExceptions {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AudienceExceptions, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AudienceExceptions>, V::Error> {
        let mut field_count = None;
        let mut field_exceptions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "count" => {
                    if field_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("count"));
                    }
                    field_count = Some(map.next_value()?);
                }
                "exceptions" => {
                    if field_exceptions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("exceptions"));
                    }
                    field_exceptions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AudienceExceptions {
            count: field_count.ok_or_else(|| ::serde::de::Error::missing_field("count"))?,
            exceptions: field_exceptions.ok_or_else(|| ::serde::de::Error::missing_field("exceptions"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("count", &self.count)?;
        s.serialize_field("exceptions", &self.exceptions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AudienceExceptions {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AudienceExceptions;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AudienceExceptions struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AudienceExceptions::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AudienceExceptions", AUDIENCE_EXCEPTIONS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AudienceExceptions {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AudienceExceptions", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information about the shared folder that prevents the link audience for this link from being
/// more restrictive.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct AudienceRestrictingSharedFolder {
    /// The ID of the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The name of the shared folder.
    pub name: String,
    /// The link audience of the shared folder.
    pub audience: LinkAudience,
}

impl AudienceRestrictingSharedFolder {
    pub fn new(
        shared_folder_id: super::common::SharedFolderId,
        name: String,
        audience: LinkAudience,
    ) -> Self {
        AudienceRestrictingSharedFolder {
            shared_folder_id,
            name,
            audience,
        }
    }
}

const AUDIENCE_RESTRICTING_SHARED_FOLDER_FIELDS: &[&str] = &["shared_folder_id",
                                                             "name",
                                                             "audience"];
impl AudienceRestrictingSharedFolder {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<AudienceRestrictingSharedFolder, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<AudienceRestrictingSharedFolder>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_name = None;
        let mut field_audience = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "audience" => {
                    if field_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience"));
                    }
                    field_audience = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = AudienceRestrictingSharedFolder {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            audience: field_audience.ok_or_else(|| ::serde::de::Error::missing_field("audience"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("audience", &self.audience)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for AudienceRestrictingSharedFolder {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = AudienceRestrictingSharedFolder;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a AudienceRestrictingSharedFolder struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                AudienceRestrictingSharedFolder::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("AudienceRestrictingSharedFolder", AUDIENCE_RESTRICTING_SHARED_FOLDER_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for AudienceRestrictingSharedFolder {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("AudienceRestrictingSharedFolder", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`change_file_member_access()`](change_file_member_access).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ChangeFileMemberAccessArgs {
    /// File for which we are changing a member's access.
    pub file: PathOrId,
    /// The member whose access we are changing.
    pub member: MemberSelector,
    /// The new access level for the member.
    pub access_level: AccessLevel,
}

impl ChangeFileMemberAccessArgs {
    pub fn new(file: PathOrId, member: MemberSelector, access_level: AccessLevel) -> Self {
        ChangeFileMemberAccessArgs {
            file,
            member,
            access_level,
        }
    }
}

const CHANGE_FILE_MEMBER_ACCESS_ARGS_FIELDS: &[&str] = &["file",
                                                         "member",
                                                         "access_level"];
impl ChangeFileMemberAccessArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ChangeFileMemberAccessArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ChangeFileMemberAccessArgs>, V::Error> {
        let mut field_file = None;
        let mut field_member = None;
        let mut field_access_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ChangeFileMemberAccessArgs {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            access_level: field_access_level.ok_or_else(|| ::serde::de::Error::missing_field("access_level"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("access_level", &self.access_level)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ChangeFileMemberAccessArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ChangeFileMemberAccessArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ChangeFileMemberAccessArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ChangeFileMemberAccessArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ChangeFileMemberAccessArgs", CHANGE_FILE_MEMBER_ACCESS_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ChangeFileMemberAccessArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ChangeFileMemberAccessArgs", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Metadata for a collection-based shared link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CollectionLinkMetadata {
    /// URL of the shared link.
    pub url: String,
    /// Who can access the link.
    pub visibility: Visibility,
    /// Expiration time, if set. By default the link won't expire.
    pub expires: Option<super::common::DropboxTimestamp>,
}

impl CollectionLinkMetadata {
    pub fn new(url: String, visibility: Visibility) -> Self {
        CollectionLinkMetadata {
            url,
            visibility,
            expires: None,
        }
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }
}

const COLLECTION_LINK_METADATA_FIELDS: &[&str] = &["url",
                                                   "visibility",
                                                   "expires"];
impl CollectionLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CollectionLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CollectionLinkMetadata>, V::Error> {
        let mut field_url = None;
        let mut field_visibility = None;
        let mut field_expires = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "visibility" => {
                    if field_visibility.is_some() {
                        return Err(::serde::de::Error::duplicate_field("visibility"));
                    }
                    field_visibility = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CollectionLinkMetadata {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            visibility: field_visibility.ok_or_else(|| ::serde::de::Error::missing_field("visibility"))?,
            expires: field_expires,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("visibility", &self.visibility)?;
        s.serialize_field("expires", &self.expires)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CollectionLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CollectionLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CollectionLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CollectionLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CollectionLinkMetadata", COLLECTION_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CollectionLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CollectionLinkMetadata", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateSharedLinkArg {
    /// The path to share.
    pub path: String,
    /// Whether to return a shortened URL.
    pub short_url: bool,
    /// If it's okay to share a path that does not yet exist, set this to either
    /// [`PendingUploadMode::File`](PendingUploadMode::File) or
    /// [`PendingUploadMode::Folder`](PendingUploadMode::Folder) to indicate whether to assume it's
    /// a file or folder.
    pub pending_upload: Option<PendingUploadMode>,
}

impl CreateSharedLinkArg {
    pub fn new(path: String) -> Self {
        CreateSharedLinkArg {
            path,
            short_url: false,
            pending_upload: None,
        }
    }

    pub fn with_short_url(mut self, value: bool) -> Self {
        self.short_url = value;
        self
    }

    pub fn with_pending_upload(mut self, value: PendingUploadMode) -> Self {
        self.pending_upload = Some(value);
        self
    }
}

const CREATE_SHARED_LINK_ARG_FIELDS: &[&str] = &["path",
                                                 "short_url",
                                                 "pending_upload"];
impl CreateSharedLinkArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateSharedLinkArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateSharedLinkArg>, V::Error> {
        let mut field_path = None;
        let mut field_short_url = None;
        let mut field_pending_upload = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "short_url" => {
                    if field_short_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("short_url"));
                    }
                    field_short_url = Some(map.next_value()?);
                }
                "pending_upload" => {
                    if field_pending_upload.is_some() {
                        return Err(::serde::de::Error::duplicate_field("pending_upload"));
                    }
                    field_pending_upload = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateSharedLinkArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            short_url: field_short_url.unwrap_or(false),
            pending_upload: field_pending_upload,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("short_url", &self.short_url)?;
        s.serialize_field("pending_upload", &self.pending_upload)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateSharedLinkArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateSharedLinkArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateSharedLinkArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateSharedLinkArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateSharedLinkArg", CREATE_SHARED_LINK_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateSharedLinkArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateSharedLinkArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum CreateSharedLinkError {
    Path(super::files::LookupError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateSharedLinkError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateSharedLinkError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateSharedLinkError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => CreateSharedLinkError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => CreateSharedLinkError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "other"];
        deserializer.deserialize_struct("CreateSharedLinkError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateSharedLinkError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateSharedLinkError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateSharedLinkError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            CreateSharedLinkError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for CreateSharedLinkError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            CreateSharedLinkError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for CreateSharedLinkError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateSharedLinkError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct CreateSharedLinkWithSettingsArg {
    /// The path to be shared by the shared link.
    pub path: ReadPath,
    /// The requested settings for the newly created shared link.
    pub settings: Option<SharedLinkSettings>,
}

impl CreateSharedLinkWithSettingsArg {
    pub fn new(path: ReadPath) -> Self {
        CreateSharedLinkWithSettingsArg {
            path,
            settings: None,
        }
    }

    pub fn with_settings(mut self, value: SharedLinkSettings) -> Self {
        self.settings = Some(value);
        self
    }
}

const CREATE_SHARED_LINK_WITH_SETTINGS_ARG_FIELDS: &[&str] = &["path",
                                                               "settings"];
impl CreateSharedLinkWithSettingsArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<CreateSharedLinkWithSettingsArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<CreateSharedLinkWithSettingsArg>, V::Error> {
        let mut field_path = None;
        let mut field_settings = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "settings" => {
                    if field_settings.is_some() {
                        return Err(::serde::de::Error::duplicate_field("settings"));
                    }
                    field_settings = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = CreateSharedLinkWithSettingsArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            settings: field_settings,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("settings", &self.settings)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for CreateSharedLinkWithSettingsArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = CreateSharedLinkWithSettingsArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateSharedLinkWithSettingsArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                CreateSharedLinkWithSettingsArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("CreateSharedLinkWithSettingsArg", CREATE_SHARED_LINK_WITH_SETTINGS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for CreateSharedLinkWithSettingsArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum CreateSharedLinkWithSettingsError {
    Path(super::files::LookupError),
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailNotVerified,
    /// The shared link already exists. You can call [`list_shared_links()`](list_shared_links) to
    /// get the  existing link, or use the provided metadata if it is returned.
    SharedLinkAlreadyExists(Option<SharedLinkAlreadyExistsMetadata>),
    /// There is an error with the given settings.
    SettingsError(SharedLinkSettingsError),
    /// The user is not allowed to create a shared link to the specified file. For  example, this
    /// can occur if the file is restricted or if the user's links are
    /// [banned](https://help.dropbox.com/files-folders/share/banned-links).
    AccessDenied,
}

impl<'de> ::serde::de::Deserialize<'de> for CreateSharedLinkWithSettingsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = CreateSharedLinkWithSettingsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a CreateSharedLinkWithSettingsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => CreateSharedLinkWithSettingsError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "email_not_verified" => CreateSharedLinkWithSettingsError::EmailNotVerified,
                    "shared_link_already_exists" => {
                        match map.next_key()? {
                            Some("shared_link_already_exists") => CreateSharedLinkWithSettingsError::SharedLinkAlreadyExists(map.next_value()?),
                            None => CreateSharedLinkWithSettingsError::SharedLinkAlreadyExists(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "settings_error" => {
                        match map.next_key()? {
                            Some("settings_error") => CreateSharedLinkWithSettingsError::SettingsError(map.next_value()?),
                            None => return Err(de::Error::missing_field("settings_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_denied" => CreateSharedLinkWithSettingsError::AccessDenied,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "email_not_verified",
                                    "shared_link_already_exists",
                                    "settings_error",
                                    "access_denied"];
        deserializer.deserialize_struct("CreateSharedLinkWithSettingsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for CreateSharedLinkWithSettingsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            CreateSharedLinkWithSettingsError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            CreateSharedLinkWithSettingsError::EmailNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsError", 1)?;
                s.serialize_field(".tag", "email_not_verified")?;
                s.end()
            }
            CreateSharedLinkWithSettingsError::SharedLinkAlreadyExists(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsError", 2)?;
                s.serialize_field(".tag", "shared_link_already_exists")?;
                s.serialize_field("shared_link_already_exists", x)?;
                s.end()
            }
            CreateSharedLinkWithSettingsError::SettingsError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsError", 2)?;
                s.serialize_field(".tag", "settings_error")?;
                s.serialize_field("settings_error", x)?;
                s.end()
            }
            CreateSharedLinkWithSettingsError::AccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("CreateSharedLinkWithSettingsError", 1)?;
                s.serialize_field(".tag", "access_denied")?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for CreateSharedLinkWithSettingsError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            CreateSharedLinkWithSettingsError::Path(inner) => Some(inner),
            CreateSharedLinkWithSettingsError::SettingsError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for CreateSharedLinkWithSettingsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            CreateSharedLinkWithSettingsError::Path(inner) => write!(f, "{}", inner),
            CreateSharedLinkWithSettingsError::SharedLinkAlreadyExists(None) => f.write_str("shared_link_already_exists"),
            CreateSharedLinkWithSettingsError::SharedLinkAlreadyExists(Some(inner)) => write!(f, "shared_link_already_exists: {:?}", inner),
            CreateSharedLinkWithSettingsError::SettingsError(inner) => write!(f, "There is an error with the given settings: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// The expected metadata of a shared link for a file or folder when a link is first created for the
/// content. Absent if the link already exists.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ExpectedSharedContentLinkMetadata {
    /// The audience options that are available for the content. Some audience options may be
    /// unavailable. For example, team_only may be unavailable if the content is not owned by a user
    /// on a team. The 'default' audience option is always available if the user can modify link
    /// settings.
    pub audience_options: Vec<LinkAudience>,
    /// The current audience of the link.
    pub current_audience: LinkAudience,
    /// A list of permissions for actions you can perform on the link.
    pub link_permissions: Vec<LinkPermission>,
    /// Whether the link is protected by a password.
    pub password_protected: bool,
    /// The access level on the link for this file.
    pub access_level: Option<AccessLevel>,
    /// The shared folder that prevents the link audience for this link from being more restrictive.
    pub audience_restricting_shared_folder: Option<AudienceRestrictingSharedFolder>,
    /// Whether the link has an expiry set on it. A link with an expiry will have its  audience
    /// changed to members when the expiry is reached.
    pub expiry: Option<super::common::DropboxTimestamp>,
}

impl ExpectedSharedContentLinkMetadata {
    pub fn new(
        audience_options: Vec<LinkAudience>,
        current_audience: LinkAudience,
        link_permissions: Vec<LinkPermission>,
        password_protected: bool,
    ) -> Self {
        ExpectedSharedContentLinkMetadata {
            audience_options,
            current_audience,
            link_permissions,
            password_protected,
            access_level: None,
            audience_restricting_shared_folder: None,
            expiry: None,
        }
    }

    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = Some(value);
        self
    }

    pub fn with_audience_restricting_shared_folder(
        mut self,
        value: AudienceRestrictingSharedFolder,
    ) -> Self {
        self.audience_restricting_shared_folder = Some(value);
        self
    }

    pub fn with_expiry(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expiry = Some(value);
        self
    }
}

const EXPECTED_SHARED_CONTENT_LINK_METADATA_FIELDS: &[&str] = &["audience_options",
                                                                "current_audience",
                                                                "link_permissions",
                                                                "password_protected",
                                                                "access_level",
                                                                "audience_restricting_shared_folder",
                                                                "expiry"];
impl ExpectedSharedContentLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ExpectedSharedContentLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ExpectedSharedContentLinkMetadata>, V::Error> {
        let mut field_audience_options = None;
        let mut field_current_audience = None;
        let mut field_link_permissions = None;
        let mut field_password_protected = None;
        let mut field_access_level = None;
        let mut field_audience_restricting_shared_folder = None;
        let mut field_expiry = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "audience_options" => {
                    if field_audience_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_options"));
                    }
                    field_audience_options = Some(map.next_value()?);
                }
                "current_audience" => {
                    if field_current_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("current_audience"));
                    }
                    field_current_audience = Some(map.next_value()?);
                }
                "link_permissions" => {
                    if field_link_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_permissions"));
                    }
                    field_link_permissions = Some(map.next_value()?);
                }
                "password_protected" => {
                    if field_password_protected.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password_protected"));
                    }
                    field_password_protected = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "audience_restricting_shared_folder" => {
                    if field_audience_restricting_shared_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_restricting_shared_folder"));
                    }
                    field_audience_restricting_shared_folder = Some(map.next_value()?);
                }
                "expiry" => {
                    if field_expiry.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiry"));
                    }
                    field_expiry = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ExpectedSharedContentLinkMetadata {
            audience_options: field_audience_options.ok_or_else(|| ::serde::de::Error::missing_field("audience_options"))?,
            current_audience: field_current_audience.ok_or_else(|| ::serde::de::Error::missing_field("current_audience"))?,
            link_permissions: field_link_permissions.ok_or_else(|| ::serde::de::Error::missing_field("link_permissions"))?,
            password_protected: field_password_protected.ok_or_else(|| ::serde::de::Error::missing_field("password_protected"))?,
            access_level: field_access_level,
            audience_restricting_shared_folder: field_audience_restricting_shared_folder,
            expiry: field_expiry,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("audience_options", &self.audience_options)?;
        s.serialize_field("current_audience", &self.current_audience)?;
        s.serialize_field("link_permissions", &self.link_permissions)?;
        s.serialize_field("password_protected", &self.password_protected)?;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("audience_restricting_shared_folder", &self.audience_restricting_shared_folder)?;
        s.serialize_field("expiry", &self.expiry)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ExpectedSharedContentLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ExpectedSharedContentLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ExpectedSharedContentLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ExpectedSharedContentLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ExpectedSharedContentLinkMetadata", EXPECTED_SHARED_CONTENT_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ExpectedSharedContentLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ExpectedSharedContentLinkMetadata", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Sharing actions that may be taken on files.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileAction {
    /// Disable viewer information on the file.
    DisableViewerInfo,
    /// Change or edit contents of the file.
    EditContents,
    /// Enable viewer information on the file.
    EnableViewerInfo,
    /// Add a member with view permissions.
    InviteViewer,
    /// Add a member with view permissions but no comment permissions.
    InviteViewerNoComment,
    /// Add a member with edit permissions.
    InviteEditor,
    /// Stop sharing this file.
    Unshare,
    /// Relinquish one's own membership to the file.
    RelinquishMembership,
    /// Use create_view_link and create_edit_link instead.
    ShareLink,
    /// Use create_view_link and create_edit_link instead.
    CreateLink,
    /// Create a shared link to a file that only allows users to view the content.
    CreateViewLink,
    /// Create a shared link to a file that allows users to edit the content.
    CreateEditLink,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileAction {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileAction;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileAction structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "disable_viewer_info" => FileAction::DisableViewerInfo,
                    "edit_contents" => FileAction::EditContents,
                    "enable_viewer_info" => FileAction::EnableViewerInfo,
                    "invite_viewer" => FileAction::InviteViewer,
                    "invite_viewer_no_comment" => FileAction::InviteViewerNoComment,
                    "invite_editor" => FileAction::InviteEditor,
                    "unshare" => FileAction::Unshare,
                    "relinquish_membership" => FileAction::RelinquishMembership,
                    "share_link" => FileAction::ShareLink,
                    "create_link" => FileAction::CreateLink,
                    "create_view_link" => FileAction::CreateViewLink,
                    "create_edit_link" => FileAction::CreateEditLink,
                    _ => FileAction::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["disable_viewer_info",
                                    "edit_contents",
                                    "enable_viewer_info",
                                    "invite_viewer",
                                    "invite_viewer_no_comment",
                                    "invite_editor",
                                    "unshare",
                                    "relinquish_membership",
                                    "share_link",
                                    "create_link",
                                    "create_view_link",
                                    "create_edit_link",
                                    "other"];
        deserializer.deserialize_struct("FileAction", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileAction {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileAction::DisableViewerInfo => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "disable_viewer_info")?;
                s.end()
            }
            FileAction::EditContents => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "edit_contents")?;
                s.end()
            }
            FileAction::EnableViewerInfo => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "enable_viewer_info")?;
                s.end()
            }
            FileAction::InviteViewer => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "invite_viewer")?;
                s.end()
            }
            FileAction::InviteViewerNoComment => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "invite_viewer_no_comment")?;
                s.end()
            }
            FileAction::InviteEditor => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "invite_editor")?;
                s.end()
            }
            FileAction::Unshare => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "unshare")?;
                s.end()
            }
            FileAction::RelinquishMembership => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "relinquish_membership")?;
                s.end()
            }
            FileAction::ShareLink => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "share_link")?;
                s.end()
            }
            FileAction::CreateLink => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "create_link")?;
                s.end()
            }
            FileAction::CreateViewLink => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "create_view_link")?;
                s.end()
            }
            FileAction::CreateEditLink => {
                // unit
                let mut s = serializer.serialize_struct("FileAction", 1)?;
                s.serialize_field(".tag", "create_edit_link")?;
                s.end()
            }
            FileAction::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileErrorResult {
    /// File specified by id was not found.
    FileNotFoundError(super::files::Id),
    /// User does not have permission to take the specified action on the file.
    InvalidFileActionError(super::files::Id),
    /// User does not have permission to access file specified by file.Id.
    PermissionDeniedError(super::files::Id),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileErrorResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileErrorResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileErrorResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "file_not_found_error" => {
                        match map.next_key()? {
                            Some("file_not_found_error") => FileErrorResult::FileNotFoundError(map.next_value()?),
                            None => return Err(de::Error::missing_field("file_not_found_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_file_action_error" => {
                        match map.next_key()? {
                            Some("invalid_file_action_error") => FileErrorResult::InvalidFileActionError(map.next_value()?),
                            None => return Err(de::Error::missing_field("invalid_file_action_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "permission_denied_error" => {
                        match map.next_key()? {
                            Some("permission_denied_error") => FileErrorResult::PermissionDeniedError(map.next_value()?),
                            None => return Err(de::Error::missing_field("permission_denied_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => FileErrorResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["file_not_found_error",
                                    "invalid_file_action_error",
                                    "permission_denied_error",
                                    "other"];
        deserializer.deserialize_struct("FileErrorResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileErrorResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileErrorResult::FileNotFoundError(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("FileErrorResult", 2)?;
                s.serialize_field(".tag", "file_not_found_error")?;
                s.serialize_field("file_not_found_error", x)?;
                s.end()
            }
            FileErrorResult::InvalidFileActionError(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("FileErrorResult", 2)?;
                s.serialize_field(".tag", "invalid_file_action_error")?;
                s.serialize_field("invalid_file_action_error", x)?;
                s.end()
            }
            FileErrorResult::PermissionDeniedError(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("FileErrorResult", 2)?;
                s.serialize_field(".tag", "permission_denied_error")?;
                s.serialize_field("permission_denied_error", x)?;
                s.end()
            }
            FileErrorResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The metadata of a file shared link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileLinkMetadata {
    /// URL of the shared link.
    pub url: String,
    /// The linked file name (including extension). This never contains a slash.
    pub name: String,
    /// The link's access permissions.
    pub link_permissions: LinkPermissions,
    /// The modification time set by the desktop client when the file was added to Dropbox. Since
    /// this time is not verified (the Dropbox server stores whatever the desktop client sends up),
    /// this should only be used for display purposes (such as sorting) and not, for example, to
    /// determine if a file has changed or not.
    pub client_modified: super::common::DropboxTimestamp,
    /// The last time the file was modified on Dropbox.
    pub server_modified: super::common::DropboxTimestamp,
    /// A unique identifier for the current revision of a file. This field is the same rev as
    /// elsewhere in the API and can be used to detect changes and avoid conflicts.
    pub rev: Rev,
    /// The file size in bytes.
    pub size: u64,
    /// A unique identifier for the linked file.
    pub id: Option<Id>,
    /// Expiration time, if set. By default the link won't expire.
    pub expires: Option<super::common::DropboxTimestamp>,
    /// The lowercased full path in the user's Dropbox. This always starts with a slash. This field
    /// will only be present only if the linked file is in the authenticated user's  dropbox.
    pub path_lower: Option<String>,
    /// The team membership information of the link's owner.  This field will only be present  if
    /// the link's owner is a team member.
    pub team_member_info: Option<TeamMemberInfo>,
    /// The team information of the content's owner. This field will only be present if the
    /// content's owner is a team member and the content's owner team is different from the link's
    /// owner team.
    pub content_owner_team_info: Option<TeamInfo>,
}

impl FileLinkMetadata {
    pub fn new(
        url: String,
        name: String,
        link_permissions: LinkPermissions,
        client_modified: super::common::DropboxTimestamp,
        server_modified: super::common::DropboxTimestamp,
        rev: Rev,
        size: u64,
    ) -> Self {
        FileLinkMetadata {
            url,
            name,
            link_permissions,
            client_modified,
            server_modified,
            rev,
            size,
            id: None,
            expires: None,
            path_lower: None,
            team_member_info: None,
            content_owner_team_info: None,
        }
    }

    pub fn with_id(mut self, value: Id) -> Self {
        self.id = Some(value);
        self
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_team_member_info(mut self, value: TeamMemberInfo) -> Self {
        self.team_member_info = Some(value);
        self
    }

    pub fn with_content_owner_team_info(mut self, value: TeamInfo) -> Self {
        self.content_owner_team_info = Some(value);
        self
    }
}

const FILE_LINK_METADATA_FIELDS: &[&str] = &["url",
                                             "name",
                                             "link_permissions",
                                             "client_modified",
                                             "server_modified",
                                             "rev",
                                             "size",
                                             "id",
                                             "expires",
                                             "path_lower",
                                             "team_member_info",
                                             "content_owner_team_info"];
impl FileLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileLinkMetadata>, V::Error> {
        let mut field_url = None;
        let mut field_name = None;
        let mut field_link_permissions = None;
        let mut field_client_modified = None;
        let mut field_server_modified = None;
        let mut field_rev = None;
        let mut field_size = None;
        let mut field_id = None;
        let mut field_expires = None;
        let mut field_path_lower = None;
        let mut field_team_member_info = None;
        let mut field_content_owner_team_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "link_permissions" => {
                    if field_link_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_permissions"));
                    }
                    field_link_permissions = Some(map.next_value()?);
                }
                "client_modified" => {
                    if field_client_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("client_modified"));
                    }
                    field_client_modified = Some(map.next_value()?);
                }
                "server_modified" => {
                    if field_server_modified.is_some() {
                        return Err(::serde::de::Error::duplicate_field("server_modified"));
                    }
                    field_server_modified = Some(map.next_value()?);
                }
                "rev" => {
                    if field_rev.is_some() {
                        return Err(::serde::de::Error::duplicate_field("rev"));
                    }
                    field_rev = Some(map.next_value()?);
                }
                "size" => {
                    if field_size.is_some() {
                        return Err(::serde::de::Error::duplicate_field("size"));
                    }
                    field_size = Some(map.next_value()?);
                }
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "team_member_info" => {
                    if field_team_member_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_info"));
                    }
                    field_team_member_info = Some(map.next_value()?);
                }
                "content_owner_team_info" => {
                    if field_content_owner_team_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("content_owner_team_info"));
                    }
                    field_content_owner_team_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileLinkMetadata {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            link_permissions: field_link_permissions.ok_or_else(|| ::serde::de::Error::missing_field("link_permissions"))?,
            client_modified: field_client_modified.ok_or_else(|| ::serde::de::Error::missing_field("client_modified"))?,
            server_modified: field_server_modified.ok_or_else(|| ::serde::de::Error::missing_field("server_modified"))?,
            rev: field_rev.ok_or_else(|| ::serde::de::Error::missing_field("rev"))?,
            size: field_size.ok_or_else(|| ::serde::de::Error::missing_field("size"))?,
            id: field_id,
            expires: field_expires,
            path_lower: field_path_lower,
            team_member_info: field_team_member_info,
            content_owner_team_info: field_content_owner_team_info,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("link_permissions", &self.link_permissions)?;
        s.serialize_field("client_modified", &self.client_modified)?;
        s.serialize_field("server_modified", &self.server_modified)?;
        s.serialize_field("rev", &self.rev)?;
        s.serialize_field("size", &self.size)?;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("expires", &self.expires)?;
        s.serialize_field("path_lower", &self.path_lower)?;
        s.serialize_field("team_member_info", &self.team_member_info)?;
        s.serialize_field("content_owner_team_info", &self.content_owner_team_info)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileLinkMetadata", FILE_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileLinkMetadata", 12)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileMemberActionError {
    /// Specified member was not found.
    InvalidMember,
    /// User does not have permission to perform this action on this member.
    NoPermission,
    /// Specified file was invalid or user does not have access.
    AccessError(SharingFileAccessError),
    /// The action cannot be completed because the target member does not have explicit access to
    /// the file. The return value is the access that the member has to the file from a parent
    /// folder.
    NoExplicitAccess(MemberAccessLevelResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileMemberActionError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileMemberActionError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileMemberActionError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_member" => FileMemberActionError::InvalidMember,
                    "no_permission" => FileMemberActionError::NoPermission,
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => FileMemberActionError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_explicit_access" => FileMemberActionError::NoExplicitAccess(MemberAccessLevelResult::internal_deserialize(&mut map)?),
                    _ => FileMemberActionError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_member",
                                    "no_permission",
                                    "access_error",
                                    "no_explicit_access",
                                    "other"];
        deserializer.deserialize_struct("FileMemberActionError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileMemberActionError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileMemberActionError::InvalidMember => {
                // unit
                let mut s = serializer.serialize_struct("FileMemberActionError", 1)?;
                s.serialize_field(".tag", "invalid_member")?;
                s.end()
            }
            FileMemberActionError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("FileMemberActionError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            FileMemberActionError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FileMemberActionError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            FileMemberActionError::NoExplicitAccess(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("FileMemberActionError", 4)?;
                s.serialize_field(".tag", "no_explicit_access")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            FileMemberActionError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for FileMemberActionError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            FileMemberActionError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for FileMemberActionError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            FileMemberActionError::InvalidMember => f.write_str("Specified member was not found."),
            FileMemberActionError::NoPermission => f.write_str("User does not have permission to perform this action on this member."),
            FileMemberActionError::AccessError(inner) => write!(f, "Specified file was invalid or user does not have access: {}", inner),
            FileMemberActionError::NoExplicitAccess(inner) => write!(f, "The action cannot be completed because the target member does not have explicit access to the file. The return value is the access that the member has to the file from a parent folder: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum FileMemberActionIndividualResult {
    /// Member was successfully removed from this file. If AccessLevel is given, the member still
    /// has access via a parent shared folder.
    Success(Option<AccessLevel>),
    /// User was not able to perform this action.
    MemberError(FileMemberActionError),
}

impl<'de> ::serde::de::Deserialize<'de> for FileMemberActionIndividualResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileMemberActionIndividualResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileMemberActionIndividualResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => {
                        match map.next_key()? {
                            Some("success") => FileMemberActionIndividualResult::Success(map.next_value()?),
                            None => FileMemberActionIndividualResult::Success(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "member_error" => {
                        match map.next_key()? {
                            Some("member_error") => FileMemberActionIndividualResult::MemberError(map.next_value()?),
                            None => return Err(de::Error::missing_field("member_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "member_error"];
        deserializer.deserialize_struct("FileMemberActionIndividualResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileMemberActionIndividualResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileMemberActionIndividualResult::Success(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FileMemberActionIndividualResult", 2)?;
                s.serialize_field(".tag", "success")?;
                s.serialize_field("success", x)?;
                s.end()
            }
            FileMemberActionIndividualResult::MemberError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FileMemberActionIndividualResult", 2)?;
                s.serialize_field(".tag", "member_error")?;
                s.serialize_field("member_error", x)?;
                s.end()
            }
        }
    }
}

/// Per-member result for [`add_file_member()`](add_file_member) or
/// [`change_file_member_access()`](change_file_member_access).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FileMemberActionResult {
    /// One of specified input members.
    pub member: MemberSelector,
    /// The outcome of the action on this member.
    pub result: FileMemberActionIndividualResult,
}

impl FileMemberActionResult {
    pub fn new(member: MemberSelector, result: FileMemberActionIndividualResult) -> Self {
        FileMemberActionResult {
            member,
            result,
        }
    }
}

const FILE_MEMBER_ACTION_RESULT_FIELDS: &[&str] = &["member",
                                                    "result"];
impl FileMemberActionResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FileMemberActionResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FileMemberActionResult>, V::Error> {
        let mut field_member = None;
        let mut field_result = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "result" => {
                    if field_result.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result"));
                    }
                    field_result = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FileMemberActionResult {
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            result: field_result.ok_or_else(|| ::serde::de::Error::missing_field("result"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("result", &self.result)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FileMemberActionResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FileMemberActionResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileMemberActionResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FileMemberActionResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FileMemberActionResult", FILE_MEMBER_ACTION_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FileMemberActionResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FileMemberActionResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FileMemberRemoveActionResult {
    /// Member was successfully removed from this file.
    Success(MemberAccessLevelResult),
    /// User was not able to remove this member.
    MemberError(FileMemberActionError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FileMemberRemoveActionResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FileMemberRemoveActionResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FileMemberRemoveActionResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "success" => FileMemberRemoveActionResult::Success(MemberAccessLevelResult::internal_deserialize(&mut map)?),
                    "member_error" => {
                        match map.next_key()? {
                            Some("member_error") => FileMemberRemoveActionResult::MemberError(map.next_value()?),
                            None => return Err(de::Error::missing_field("member_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => FileMemberRemoveActionResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["success",
                                    "member_error",
                                    "other"];
        deserializer.deserialize_struct("FileMemberRemoveActionResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FileMemberRemoveActionResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FileMemberRemoveActionResult::Success(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("FileMemberRemoveActionResult", 4)?;
                s.serialize_field(".tag", "success")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            FileMemberRemoveActionResult::MemberError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("FileMemberRemoveActionResult", 2)?;
                s.serialize_field(".tag", "member_error")?;
                s.serialize_field("member_error", x)?;
                s.end()
            }
            FileMemberRemoveActionResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Whether the user is allowed to take the sharing action on the file.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FilePermission {
    /// The action that the user may wish to take on the file.
    pub action: FileAction,
    /// True if the user is allowed to take the action.
    pub allow: bool,
    /// The reason why the user is denied the permission. Not present if the action is allowed.
    pub reason: Option<PermissionDeniedReason>,
}

impl FilePermission {
    pub fn new(action: FileAction, allow: bool) -> Self {
        FilePermission {
            action,
            allow,
            reason: None,
        }
    }

    pub fn with_reason(mut self, value: PermissionDeniedReason) -> Self {
        self.reason = Some(value);
        self
    }
}

const FILE_PERMISSION_FIELDS: &[&str] = &["action",
                                          "allow",
                                          "reason"];
impl FilePermission {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FilePermission, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FilePermission>, V::Error> {
        let mut field_action = None;
        let mut field_allow = None;
        let mut field_reason = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "action" => {
                    if field_action.is_some() {
                        return Err(::serde::de::Error::duplicate_field("action"));
                    }
                    field_action = Some(map.next_value()?);
                }
                "allow" => {
                    if field_allow.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow"));
                    }
                    field_allow = Some(map.next_value()?);
                }
                "reason" => {
                    if field_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("reason"));
                    }
                    field_reason = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FilePermission {
            action: field_action.ok_or_else(|| ::serde::de::Error::missing_field("action"))?,
            allow: field_allow.ok_or_else(|| ::serde::de::Error::missing_field("allow"))?,
            reason: field_reason,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("action", &self.action)?;
        s.serialize_field("allow", &self.allow)?;
        s.serialize_field("reason", &self.reason)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FilePermission {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FilePermission;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FilePermission struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FilePermission::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FilePermission", FILE_PERMISSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FilePermission {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FilePermission", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Actions that may be taken on shared folders.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum FolderAction {
    /// Change folder options, such as who can be invited to join the folder.
    ChangeOptions,
    /// Disable viewer information for this folder.
    DisableViewerInfo,
    /// Change or edit contents of the folder.
    EditContents,
    /// Enable viewer information on the folder.
    EnableViewerInfo,
    /// Invite a user or group to join the folder with read and write permission.
    InviteEditor,
    /// Invite a user or group to join the folder with read permission.
    InviteViewer,
    /// Invite a user or group to join the folder with read permission but no comment permissions.
    InviteViewerNoComment,
    /// Relinquish one's own membership in the folder.
    RelinquishMembership,
    /// Unmount the folder.
    Unmount,
    /// Stop sharing this folder.
    Unshare,
    /// Keep a copy of the contents upon leaving or being kicked from the folder.
    LeaveACopy,
    /// Use create_link instead.
    ShareLink,
    /// Create a shared link for folder.
    CreateLink,
    /// Set whether the folder inherits permissions from its parent.
    SetAccessInheritance,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for FolderAction {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = FolderAction;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderAction structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "change_options" => FolderAction::ChangeOptions,
                    "disable_viewer_info" => FolderAction::DisableViewerInfo,
                    "edit_contents" => FolderAction::EditContents,
                    "enable_viewer_info" => FolderAction::EnableViewerInfo,
                    "invite_editor" => FolderAction::InviteEditor,
                    "invite_viewer" => FolderAction::InviteViewer,
                    "invite_viewer_no_comment" => FolderAction::InviteViewerNoComment,
                    "relinquish_membership" => FolderAction::RelinquishMembership,
                    "unmount" => FolderAction::Unmount,
                    "unshare" => FolderAction::Unshare,
                    "leave_a_copy" => FolderAction::LeaveACopy,
                    "share_link" => FolderAction::ShareLink,
                    "create_link" => FolderAction::CreateLink,
                    "set_access_inheritance" => FolderAction::SetAccessInheritance,
                    _ => FolderAction::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["change_options",
                                    "disable_viewer_info",
                                    "edit_contents",
                                    "enable_viewer_info",
                                    "invite_editor",
                                    "invite_viewer",
                                    "invite_viewer_no_comment",
                                    "relinquish_membership",
                                    "unmount",
                                    "unshare",
                                    "leave_a_copy",
                                    "share_link",
                                    "create_link",
                                    "set_access_inheritance",
                                    "other"];
        deserializer.deserialize_struct("FolderAction", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for FolderAction {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            FolderAction::ChangeOptions => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "change_options")?;
                s.end()
            }
            FolderAction::DisableViewerInfo => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "disable_viewer_info")?;
                s.end()
            }
            FolderAction::EditContents => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "edit_contents")?;
                s.end()
            }
            FolderAction::EnableViewerInfo => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "enable_viewer_info")?;
                s.end()
            }
            FolderAction::InviteEditor => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "invite_editor")?;
                s.end()
            }
            FolderAction::InviteViewer => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "invite_viewer")?;
                s.end()
            }
            FolderAction::InviteViewerNoComment => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "invite_viewer_no_comment")?;
                s.end()
            }
            FolderAction::RelinquishMembership => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "relinquish_membership")?;
                s.end()
            }
            FolderAction::Unmount => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "unmount")?;
                s.end()
            }
            FolderAction::Unshare => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "unshare")?;
                s.end()
            }
            FolderAction::LeaveACopy => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "leave_a_copy")?;
                s.end()
            }
            FolderAction::ShareLink => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "share_link")?;
                s.end()
            }
            FolderAction::CreateLink => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "create_link")?;
                s.end()
            }
            FolderAction::SetAccessInheritance => {
                // unit
                let mut s = serializer.serialize_struct("FolderAction", 1)?;
                s.serialize_field(".tag", "set_access_inheritance")?;
                s.end()
            }
            FolderAction::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The metadata of a folder shared link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FolderLinkMetadata {
    /// URL of the shared link.
    pub url: String,
    /// The linked file name (including extension). This never contains a slash.
    pub name: String,
    /// The link's access permissions.
    pub link_permissions: LinkPermissions,
    /// A unique identifier for the linked file.
    pub id: Option<Id>,
    /// Expiration time, if set. By default the link won't expire.
    pub expires: Option<super::common::DropboxTimestamp>,
    /// The lowercased full path in the user's Dropbox. This always starts with a slash. This field
    /// will only be present only if the linked file is in the authenticated user's  dropbox.
    pub path_lower: Option<String>,
    /// The team membership information of the link's owner.  This field will only be present  if
    /// the link's owner is a team member.
    pub team_member_info: Option<TeamMemberInfo>,
    /// The team information of the content's owner. This field will only be present if the
    /// content's owner is a team member and the content's owner team is different from the link's
    /// owner team.
    pub content_owner_team_info: Option<TeamInfo>,
}

impl FolderLinkMetadata {
    pub fn new(url: String, name: String, link_permissions: LinkPermissions) -> Self {
        FolderLinkMetadata {
            url,
            name,
            link_permissions,
            id: None,
            expires: None,
            path_lower: None,
            team_member_info: None,
            content_owner_team_info: None,
        }
    }

    pub fn with_id(mut self, value: Id) -> Self {
        self.id = Some(value);
        self
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_team_member_info(mut self, value: TeamMemberInfo) -> Self {
        self.team_member_info = Some(value);
        self
    }

    pub fn with_content_owner_team_info(mut self, value: TeamInfo) -> Self {
        self.content_owner_team_info = Some(value);
        self
    }
}

const FOLDER_LINK_METADATA_FIELDS: &[&str] = &["url",
                                               "name",
                                               "link_permissions",
                                               "id",
                                               "expires",
                                               "path_lower",
                                               "team_member_info",
                                               "content_owner_team_info"];
impl FolderLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FolderLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FolderLinkMetadata>, V::Error> {
        let mut field_url = None;
        let mut field_name = None;
        let mut field_link_permissions = None;
        let mut field_id = None;
        let mut field_expires = None;
        let mut field_path_lower = None;
        let mut field_team_member_info = None;
        let mut field_content_owner_team_info = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "link_permissions" => {
                    if field_link_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_permissions"));
                    }
                    field_link_permissions = Some(map.next_value()?);
                }
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "team_member_info" => {
                    if field_team_member_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_info"));
                    }
                    field_team_member_info = Some(map.next_value()?);
                }
                "content_owner_team_info" => {
                    if field_content_owner_team_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("content_owner_team_info"));
                    }
                    field_content_owner_team_info = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FolderLinkMetadata {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            link_permissions: field_link_permissions.ok_or_else(|| ::serde::de::Error::missing_field("link_permissions"))?,
            id: field_id,
            expires: field_expires,
            path_lower: field_path_lower,
            team_member_info: field_team_member_info,
            content_owner_team_info: field_content_owner_team_info,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("link_permissions", &self.link_permissions)?;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("expires", &self.expires)?;
        s.serialize_field("path_lower", &self.path_lower)?;
        s.serialize_field("team_member_info", &self.team_member_info)?;
        s.serialize_field("content_owner_team_info", &self.content_owner_team_info)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FolderLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FolderLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FolderLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FolderLinkMetadata", FOLDER_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FolderLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FolderLinkMetadata", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Whether the user is allowed to take the action on the shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FolderPermission {
    /// The action that the user may wish to take on the folder.
    pub action: FolderAction,
    /// True if the user is allowed to take the action.
    pub allow: bool,
    /// The reason why the user is denied the permission. Not present if the action is allowed, or
    /// if no reason is available.
    pub reason: Option<PermissionDeniedReason>,
}

impl FolderPermission {
    pub fn new(action: FolderAction, allow: bool) -> Self {
        FolderPermission {
            action,
            allow,
            reason: None,
        }
    }

    pub fn with_reason(mut self, value: PermissionDeniedReason) -> Self {
        self.reason = Some(value);
        self
    }
}

const FOLDER_PERMISSION_FIELDS: &[&str] = &["action",
                                            "allow",
                                            "reason"];
impl FolderPermission {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FolderPermission, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FolderPermission>, V::Error> {
        let mut field_action = None;
        let mut field_allow = None;
        let mut field_reason = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "action" => {
                    if field_action.is_some() {
                        return Err(::serde::de::Error::duplicate_field("action"));
                    }
                    field_action = Some(map.next_value()?);
                }
                "allow" => {
                    if field_allow.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow"));
                    }
                    field_allow = Some(map.next_value()?);
                }
                "reason" => {
                    if field_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("reason"));
                    }
                    field_reason = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FolderPermission {
            action: field_action.ok_or_else(|| ::serde::de::Error::missing_field("action"))?,
            allow: field_allow.ok_or_else(|| ::serde::de::Error::missing_field("allow"))?,
            reason: field_reason,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("action", &self.action)?;
        s.serialize_field("allow", &self.allow)?;
        s.serialize_field("reason", &self.reason)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FolderPermission {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FolderPermission;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderPermission struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FolderPermission::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FolderPermission", FOLDER_PERMISSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FolderPermission {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FolderPermission", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// A set of policies governing membership and privileges for a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct FolderPolicy {
    /// Who can add and remove members from this shared folder.
    pub acl_update_policy: AclUpdatePolicy,
    /// Who links can be shared with.
    pub shared_link_policy: SharedLinkPolicy,
    /// Who can be a member of this shared folder, as set on the folder itself. The effective policy
    /// may differ from this value if the team-wide policy is more restrictive. Present only if the
    /// folder is owned by a team.
    pub member_policy: Option<MemberPolicy>,
    /// Who can be a member of this shared folder, taking into account both the folder and the
    /// team-wide policy. This value may differ from that of member_policy if the team-wide policy
    /// is more restrictive than the folder policy. Present only if the folder is owned by a team.
    pub resolved_member_policy: Option<MemberPolicy>,
    /// Who can enable/disable viewer info for this shared folder.
    pub viewer_info_policy: Option<ViewerInfoPolicy>,
}

impl FolderPolicy {
    pub fn new(acl_update_policy: AclUpdatePolicy, shared_link_policy: SharedLinkPolicy) -> Self {
        FolderPolicy {
            acl_update_policy,
            shared_link_policy,
            member_policy: None,
            resolved_member_policy: None,
            viewer_info_policy: None,
        }
    }

    pub fn with_member_policy(mut self, value: MemberPolicy) -> Self {
        self.member_policy = Some(value);
        self
    }

    pub fn with_resolved_member_policy(mut self, value: MemberPolicy) -> Self {
        self.resolved_member_policy = Some(value);
        self
    }

    pub fn with_viewer_info_policy(mut self, value: ViewerInfoPolicy) -> Self {
        self.viewer_info_policy = Some(value);
        self
    }
}

const FOLDER_POLICY_FIELDS: &[&str] = &["acl_update_policy",
                                        "shared_link_policy",
                                        "member_policy",
                                        "resolved_member_policy",
                                        "viewer_info_policy"];
impl FolderPolicy {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<FolderPolicy, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<FolderPolicy>, V::Error> {
        let mut field_acl_update_policy = None;
        let mut field_shared_link_policy = None;
        let mut field_member_policy = None;
        let mut field_resolved_member_policy = None;
        let mut field_viewer_info_policy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "acl_update_policy" => {
                    if field_acl_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("acl_update_policy"));
                    }
                    field_acl_update_policy = Some(map.next_value()?);
                }
                "shared_link_policy" => {
                    if field_shared_link_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link_policy"));
                    }
                    field_shared_link_policy = Some(map.next_value()?);
                }
                "member_policy" => {
                    if field_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_policy"));
                    }
                    field_member_policy = Some(map.next_value()?);
                }
                "resolved_member_policy" => {
                    if field_resolved_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("resolved_member_policy"));
                    }
                    field_resolved_member_policy = Some(map.next_value()?);
                }
                "viewer_info_policy" => {
                    if field_viewer_info_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("viewer_info_policy"));
                    }
                    field_viewer_info_policy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = FolderPolicy {
            acl_update_policy: field_acl_update_policy.ok_or_else(|| ::serde::de::Error::missing_field("acl_update_policy"))?,
            shared_link_policy: field_shared_link_policy.ok_or_else(|| ::serde::de::Error::missing_field("shared_link_policy"))?,
            member_policy: field_member_policy,
            resolved_member_policy: field_resolved_member_policy,
            viewer_info_policy: field_viewer_info_policy,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("acl_update_policy", &self.acl_update_policy)?;
        s.serialize_field("shared_link_policy", &self.shared_link_policy)?;
        s.serialize_field("member_policy", &self.member_policy)?;
        s.serialize_field("resolved_member_policy", &self.resolved_member_policy)?;
        s.serialize_field("viewer_info_policy", &self.viewer_info_policy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for FolderPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = FolderPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a FolderPolicy struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                FolderPolicy::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("FolderPolicy", FOLDER_POLICY_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for FolderPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("FolderPolicy", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments of [`get_file_metadata()`](get_file_metadata).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetFileMetadataArg {
    /// The file to query.
    pub file: PathOrId,
    /// A list of `FileAction`s corresponding to `FilePermission`s that should appear in the
    /// response's [`SharedFileMetadata::permissions`](SharedFileMetadata) field describing the
    /// actions the  authenticated user can perform on the file.
    pub actions: Option<Vec<FileAction>>,
}

impl GetFileMetadataArg {
    pub fn new(file: PathOrId) -> Self {
        GetFileMetadataArg {
            file,
            actions: None,
        }
    }

    pub fn with_actions(mut self, value: Vec<FileAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const GET_FILE_METADATA_ARG_FIELDS: &[&str] = &["file",
                                                "actions"];
impl GetFileMetadataArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetFileMetadataArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetFileMetadataArg>, V::Error> {
        let mut field_file = None;
        let mut field_actions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetFileMetadataArg {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            actions: field_actions,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileMetadataArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetFileMetadataArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileMetadataArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetFileMetadataArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetFileMetadataArg", GET_FILE_METADATA_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileMetadataArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetFileMetadataArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments of [`get_file_metadata_batch()`](get_file_metadata_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetFileMetadataBatchArg {
    /// The files to query.
    pub files: Vec<PathOrId>,
    /// A list of `FileAction`s corresponding to `FilePermission`s that should appear in the
    /// response's [`SharedFileMetadata::permissions`](SharedFileMetadata) field describing the
    /// actions the  authenticated user can perform on the file.
    pub actions: Option<Vec<FileAction>>,
}

impl GetFileMetadataBatchArg {
    pub fn new(files: Vec<PathOrId>) -> Self {
        GetFileMetadataBatchArg {
            files,
            actions: None,
        }
    }

    pub fn with_actions(mut self, value: Vec<FileAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const GET_FILE_METADATA_BATCH_ARG_FIELDS: &[&str] = &["files",
                                                      "actions"];
impl GetFileMetadataBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetFileMetadataBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetFileMetadataBatchArg>, V::Error> {
        let mut field_files = None;
        let mut field_actions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "files" => {
                    if field_files.is_some() {
                        return Err(::serde::de::Error::duplicate_field("files"));
                    }
                    field_files = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetFileMetadataBatchArg {
            files: field_files.ok_or_else(|| ::serde::de::Error::missing_field("files"))?,
            actions: field_actions,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("files", &self.files)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileMetadataBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetFileMetadataBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileMetadataBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetFileMetadataBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetFileMetadataBatchArg", GET_FILE_METADATA_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileMetadataBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetFileMetadataBatchArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Per file results of [`get_file_metadata_batch()`](get_file_metadata_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetFileMetadataBatchResult {
    /// This is the input file identifier corresponding to one of
    /// [`GetFileMetadataBatchArg::files`](GetFileMetadataBatchArg).
    pub file: PathOrId,
    /// The result for this particular file.
    pub result: GetFileMetadataIndividualResult,
}

impl GetFileMetadataBatchResult {
    pub fn new(file: PathOrId, result: GetFileMetadataIndividualResult) -> Self {
        GetFileMetadataBatchResult {
            file,
            result,
        }
    }
}

const GET_FILE_METADATA_BATCH_RESULT_FIELDS: &[&str] = &["file",
                                                         "result"];
impl GetFileMetadataBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetFileMetadataBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetFileMetadataBatchResult>, V::Error> {
        let mut field_file = None;
        let mut field_result = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "result" => {
                    if field_result.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result"));
                    }
                    field_result = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetFileMetadataBatchResult {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            result: field_result.ok_or_else(|| ::serde::de::Error::missing_field("result"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("result", &self.result)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileMetadataBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetFileMetadataBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileMetadataBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetFileMetadataBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetFileMetadataBatchResult", GET_FILE_METADATA_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileMetadataBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetFileMetadataBatchResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error result for [`get_file_metadata()`](get_file_metadata).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetFileMetadataError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileMetadataError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetFileMetadataError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileMetadataError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => GetFileMetadataError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => GetFileMetadataError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetFileMetadataError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "other"];
        deserializer.deserialize_struct("GetFileMetadataError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileMetadataError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetFileMetadataError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetFileMetadataError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            GetFileMetadataError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetFileMetadataError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            GetFileMetadataError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetFileMetadataError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            GetFileMetadataError::UserError(inner) => Some(inner),
            GetFileMetadataError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for GetFileMetadataError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetFileMetadataError::UserError(inner) => write!(f, "{}", inner),
            GetFileMetadataError::AccessError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetFileMetadataIndividualResult {
    /// The result for this file if it was successful.
    Metadata(SharedFileMetadata),
    /// The result for this file if it was an error.
    AccessError(SharingFileAccessError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetFileMetadataIndividualResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetFileMetadataIndividualResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetFileMetadataIndividualResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "metadata" => GetFileMetadataIndividualResult::Metadata(SharedFileMetadata::internal_deserialize(&mut map)?),
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => GetFileMetadataIndividualResult::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetFileMetadataIndividualResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["metadata",
                                    "access_error",
                                    "other"];
        deserializer.deserialize_struct("GetFileMetadataIndividualResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetFileMetadataIndividualResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetFileMetadataIndividualResult::Metadata(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("GetFileMetadataIndividualResult", 15)?;
                s.serialize_field(".tag", "metadata")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            GetFileMetadataIndividualResult::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("GetFileMetadataIndividualResult", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            GetFileMetadataIndividualResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetMetadataArgs {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the
    /// response's [`SharedFolderMetadata::permissions`](SharedFolderMetadata) field describing the
    /// actions the  authenticated user can perform on the folder.
    pub actions: Option<Vec<FolderAction>>,
}

impl GetMetadataArgs {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        GetMetadataArgs {
            shared_folder_id,
            actions: None,
        }
    }

    pub fn with_actions(mut self, value: Vec<FolderAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const GET_METADATA_ARGS_FIELDS: &[&str] = &["shared_folder_id",
                                            "actions"];
impl GetMetadataArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetMetadataArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetMetadataArgs>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_actions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetMetadataArgs {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            actions: field_actions,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetMetadataArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetMetadataArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetMetadataArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetMetadataArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetMetadataArgs", GET_METADATA_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetMetadataArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetMetadataArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetSharedLinkFileError {
    /// The shared link wasn't found.
    SharedLinkNotFound,
    /// The caller is not allowed to access this shared link.
    SharedLinkAccessDenied,
    /// This type of link is not supported; use [`files::export()`](super::files::export) instead.
    UnsupportedLinkType,
    /// Directories cannot be retrieved by this endpoint.
    SharedLinkIsDirectory,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetSharedLinkFileError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetSharedLinkFileError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetSharedLinkFileError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "shared_link_not_found" => GetSharedLinkFileError::SharedLinkNotFound,
                    "shared_link_access_denied" => GetSharedLinkFileError::SharedLinkAccessDenied,
                    "unsupported_link_type" => GetSharedLinkFileError::UnsupportedLinkType,
                    "shared_link_is_directory" => GetSharedLinkFileError::SharedLinkIsDirectory,
                    _ => GetSharedLinkFileError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["shared_link_not_found",
                                    "shared_link_access_denied",
                                    "unsupported_link_type",
                                    "other",
                                    "shared_link_is_directory"];
        deserializer.deserialize_struct("GetSharedLinkFileError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetSharedLinkFileError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetSharedLinkFileError::SharedLinkNotFound => {
                // unit
                let mut s = serializer.serialize_struct("GetSharedLinkFileError", 1)?;
                s.serialize_field(".tag", "shared_link_not_found")?;
                s.end()
            }
            GetSharedLinkFileError::SharedLinkAccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("GetSharedLinkFileError", 1)?;
                s.serialize_field(".tag", "shared_link_access_denied")?;
                s.end()
            }
            GetSharedLinkFileError::UnsupportedLinkType => {
                // unit
                let mut s = serializer.serialize_struct("GetSharedLinkFileError", 1)?;
                s.serialize_field(".tag", "unsupported_link_type")?;
                s.end()
            }
            GetSharedLinkFileError::SharedLinkIsDirectory => {
                // unit
                let mut s = serializer.serialize_struct("GetSharedLinkFileError", 1)?;
                s.serialize_field(".tag", "shared_link_is_directory")?;
                s.end()
            }
            GetSharedLinkFileError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetSharedLinkFileError {
}

impl ::std::fmt::Display for GetSharedLinkFileError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetSharedLinkFileError::SharedLinkNotFound => f.write_str("The shared link wasn't found."),
            GetSharedLinkFileError::SharedLinkAccessDenied => f.write_str("The caller is not allowed to access this shared link."),
            GetSharedLinkFileError::SharedLinkIsDirectory => f.write_str("Directories cannot be retrieved by this endpoint."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetSharedLinkMetadataArg {
    /// URL of the shared link.
    pub url: String,
    /// If the shared link is to a folder, this parameter can be used to retrieve the metadata for a
    /// specific file or sub-folder in this folder. A relative path should be used.
    pub path: Option<Path>,
    /// If the shared link has a password, this parameter can be used.
    pub link_password: Option<String>,
}

impl GetSharedLinkMetadataArg {
    pub fn new(url: String) -> Self {
        GetSharedLinkMetadataArg {
            url,
            path: None,
            link_password: None,
        }
    }

    pub fn with_path(mut self, value: Path) -> Self {
        self.path = Some(value);
        self
    }

    pub fn with_link_password(mut self, value: String) -> Self {
        self.link_password = Some(value);
        self
    }
}

const GET_SHARED_LINK_METADATA_ARG_FIELDS: &[&str] = &["url",
                                                       "path",
                                                       "link_password"];
impl GetSharedLinkMetadataArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetSharedLinkMetadataArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetSharedLinkMetadataArg>, V::Error> {
        let mut field_url = None;
        let mut field_path = None;
        let mut field_link_password = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "link_password" => {
                    if field_link_password.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_password"));
                    }
                    field_link_password = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetSharedLinkMetadataArg {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            path: field_path,
            link_password: field_link_password,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("link_password", &self.link_password)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetSharedLinkMetadataArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetSharedLinkMetadataArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetSharedLinkMetadataArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetSharedLinkMetadataArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetSharedLinkMetadataArg", GET_SHARED_LINK_METADATA_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetSharedLinkMetadataArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetSharedLinkMetadataArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetSharedLinksArg {
    /// See [`get_shared_links()`](get_shared_links) description.
    pub path: Option<String>,
}

impl Default for GetSharedLinksArg {
    fn default() -> Self {
        GetSharedLinksArg {
            path: None,
        }
    }
}

impl GetSharedLinksArg {
    pub fn with_path(mut self, value: String) -> Self {
        self.path = Some(value);
        self
    }
}

const GET_SHARED_LINKS_ARG_FIELDS: &[&str] = &["path"];
impl GetSharedLinksArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<GetSharedLinksArg, V::Error> {
        let mut field_path = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = GetSharedLinksArg {
            path: field_path,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetSharedLinksArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetSharedLinksArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetSharedLinksArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetSharedLinksArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetSharedLinksArg", GET_SHARED_LINKS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetSharedLinksArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetSharedLinksArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum GetSharedLinksError {
    Path(super::files::MalformedPathError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for GetSharedLinksError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = GetSharedLinksError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetSharedLinksError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => GetSharedLinksError::Path(map.next_value()?),
                            None => GetSharedLinksError::Path(None),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => GetSharedLinksError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "other"];
        deserializer.deserialize_struct("GetSharedLinksError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for GetSharedLinksError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            GetSharedLinksError::Path(ref x) => {
                // nullable (struct or primitive)
                let n = if x.is_some() { 2 } else { 1 };
                let mut s = serializer.serialize_struct("GetSharedLinksError", n)?;
                s.serialize_field(".tag", "path")?;
                if let Some(ref x) = x {
                    s.serialize_field("path", &x)?;
                }
                s.end()
            }
            GetSharedLinksError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for GetSharedLinksError {
}

impl ::std::fmt::Display for GetSharedLinksError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GetSharedLinksError::Path(inner) => write!(f, "path: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GetSharedLinksResult {
    /// Shared links applicable to the path argument.
    pub links: Vec<LinkMetadata>,
}

impl GetSharedLinksResult {
    pub fn new(links: Vec<LinkMetadata>) -> Self {
        GetSharedLinksResult {
            links,
        }
    }
}

const GET_SHARED_LINKS_RESULT_FIELDS: &[&str] = &["links"];
impl GetSharedLinksResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GetSharedLinksResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GetSharedLinksResult>, V::Error> {
        let mut field_links = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "links" => {
                    if field_links.is_some() {
                        return Err(::serde::de::Error::duplicate_field("links"));
                    }
                    field_links = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GetSharedLinksResult {
            links: field_links.ok_or_else(|| ::serde::de::Error::missing_field("links"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("links", &self.links)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GetSharedLinksResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GetSharedLinksResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GetSharedLinksResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GetSharedLinksResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GetSharedLinksResult", GET_SHARED_LINKS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GetSharedLinksResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GetSharedLinksResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The information about a group. Groups is a way to manage a list of users  who need same access
/// permission to the shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupInfo {
    pub group_name: String,
    pub group_id: super::team_common::GroupId,
    /// Who is allowed to manage the group.
    pub group_management_type: super::team_common::GroupManagementType,
    /// The type of group.
    pub group_type: super::team_common::GroupType,
    /// If the current user is a member of the group.
    pub is_member: bool,
    /// If the current user is an owner of the group.
    pub is_owner: bool,
    /// If the group is owned by the current user's team.
    pub same_team: bool,
    /// External ID of group. This is an arbitrary ID that an admin can attach to a group.
    pub group_external_id: Option<super::team_common::GroupExternalId>,
    /// The number of members in the group.
    pub member_count: Option<u32>,
}

impl GroupInfo {
    pub fn new(
        group_name: String,
        group_id: super::team_common::GroupId,
        group_management_type: super::team_common::GroupManagementType,
        group_type: super::team_common::GroupType,
        is_member: bool,
        is_owner: bool,
        same_team: bool,
    ) -> Self {
        GroupInfo {
            group_name,
            group_id,
            group_management_type,
            group_type,
            is_member,
            is_owner,
            same_team,
            group_external_id: None,
            member_count: None,
        }
    }

    pub fn with_group_external_id(mut self, value: super::team_common::GroupExternalId) -> Self {
        self.group_external_id = Some(value);
        self
    }

    pub fn with_member_count(mut self, value: u32) -> Self {
        self.member_count = Some(value);
        self
    }
}

const GROUP_INFO_FIELDS: &[&str] = &["group_name",
                                     "group_id",
                                     "group_management_type",
                                     "group_type",
                                     "is_member",
                                     "is_owner",
                                     "same_team",
                                     "group_external_id",
                                     "member_count"];
impl GroupInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupInfo>, V::Error> {
        let mut field_group_name = None;
        let mut field_group_id = None;
        let mut field_group_management_type = None;
        let mut field_group_type = None;
        let mut field_is_member = None;
        let mut field_is_owner = None;
        let mut field_same_team = None;
        let mut field_group_external_id = None;
        let mut field_member_count = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "group_name" => {
                    if field_group_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_name"));
                    }
                    field_group_name = Some(map.next_value()?);
                }
                "group_id" => {
                    if field_group_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_id"));
                    }
                    field_group_id = Some(map.next_value()?);
                }
                "group_management_type" => {
                    if field_group_management_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_management_type"));
                    }
                    field_group_management_type = Some(map.next_value()?);
                }
                "group_type" => {
                    if field_group_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_type"));
                    }
                    field_group_type = Some(map.next_value()?);
                }
                "is_member" => {
                    if field_is_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_member"));
                    }
                    field_is_member = Some(map.next_value()?);
                }
                "is_owner" => {
                    if field_is_owner.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_owner"));
                    }
                    field_is_owner = Some(map.next_value()?);
                }
                "same_team" => {
                    if field_same_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("same_team"));
                    }
                    field_same_team = Some(map.next_value()?);
                }
                "group_external_id" => {
                    if field_group_external_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group_external_id"));
                    }
                    field_group_external_id = Some(map.next_value()?);
                }
                "member_count" => {
                    if field_member_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_count"));
                    }
                    field_member_count = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupInfo {
            group_name: field_group_name.ok_or_else(|| ::serde::de::Error::missing_field("group_name"))?,
            group_id: field_group_id.ok_or_else(|| ::serde::de::Error::missing_field("group_id"))?,
            group_management_type: field_group_management_type.ok_or_else(|| ::serde::de::Error::missing_field("group_management_type"))?,
            group_type: field_group_type.ok_or_else(|| ::serde::de::Error::missing_field("group_type"))?,
            is_member: field_is_member.ok_or_else(|| ::serde::de::Error::missing_field("is_member"))?,
            is_owner: field_is_owner.ok_or_else(|| ::serde::de::Error::missing_field("is_owner"))?,
            same_team: field_same_team.ok_or_else(|| ::serde::de::Error::missing_field("same_team"))?,
            group_external_id: field_group_external_id,
            member_count: field_member_count,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("group_name", &self.group_name)?;
        s.serialize_field("group_id", &self.group_id)?;
        s.serialize_field("group_management_type", &self.group_management_type)?;
        s.serialize_field("group_type", &self.group_type)?;
        s.serialize_field("is_member", &self.is_member)?;
        s.serialize_field("is_owner", &self.is_owner)?;
        s.serialize_field("same_team", &self.same_team)?;
        s.serialize_field("group_external_id", &self.group_external_id)?;
        s.serialize_field("member_count", &self.member_count)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupInfo", GROUP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupInfo", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The information about a group member of the shared content.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct GroupMembershipInfo {
    /// The access type for this member. It contains inherited access type from parent folder, and
    /// acquired access type from this folder.
    pub access_type: AccessLevel,
    /// The information about the membership group.
    pub group: GroupInfo,
    /// The permissions that requesting user has on this member. The set of permissions corresponds
    /// to the MemberActions in the request.
    pub permissions: Option<Vec<MemberPermission>>,
    /// Never set.
    pub initials: Option<String>,
    /// True if the member has access from a parent folder.
    pub is_inherited: bool,
}

impl GroupMembershipInfo {
    pub fn new(access_type: AccessLevel, group: GroupInfo) -> Self {
        GroupMembershipInfo {
            access_type,
            group,
            permissions: None,
            initials: None,
            is_inherited: false,
        }
    }

    pub fn with_permissions(mut self, value: Vec<MemberPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_initials(mut self, value: String) -> Self {
        self.initials = Some(value);
        self
    }

    pub fn with_is_inherited(mut self, value: bool) -> Self {
        self.is_inherited = value;
        self
    }
}

const GROUP_MEMBERSHIP_INFO_FIELDS: &[&str] = &["access_type",
                                                "group",
                                                "permissions",
                                                "initials",
                                                "is_inherited"];
impl GroupMembershipInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<GroupMembershipInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<GroupMembershipInfo>, V::Error> {
        let mut field_access_type = None;
        let mut field_group = None;
        let mut field_permissions = None;
        let mut field_initials = None;
        let mut field_is_inherited = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "group" => {
                    if field_group.is_some() {
                        return Err(::serde::de::Error::duplicate_field("group"));
                    }
                    field_group = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "initials" => {
                    if field_initials.is_some() {
                        return Err(::serde::de::Error::duplicate_field("initials"));
                    }
                    field_initials = Some(map.next_value()?);
                }
                "is_inherited" => {
                    if field_is_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inherited"));
                    }
                    field_is_inherited = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = GroupMembershipInfo {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            group: field_group.ok_or_else(|| ::serde::de::Error::missing_field("group"))?,
            permissions: field_permissions,
            initials: field_initials,
            is_inherited: field_is_inherited.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("group", &self.group)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("initials", &self.initials)?;
        s.serialize_field("is_inherited", &self.is_inherited)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for GroupMembershipInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = GroupMembershipInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a GroupMembershipInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                GroupMembershipInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("GroupMembershipInfo", GROUP_MEMBERSHIP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for GroupMembershipInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("GroupMembershipInfo", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct InsufficientPlan {
    /// A message to tell the user to upgrade in order to support expected action.
    pub message: String,
    /// A URL to send the user to in order to obtain the account type they need, e.g. upgrading.
    /// Absent if there is no action the user can take to upgrade.
    pub upsell_url: Option<String>,
}

impl InsufficientPlan {
    pub fn new(message: String) -> Self {
        InsufficientPlan {
            message,
            upsell_url: None,
        }
    }

    pub fn with_upsell_url(mut self, value: String) -> Self {
        self.upsell_url = Some(value);
        self
    }
}

const INSUFFICIENT_PLAN_FIELDS: &[&str] = &["message",
                                            "upsell_url"];
impl InsufficientPlan {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<InsufficientPlan, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<InsufficientPlan>, V::Error> {
        let mut field_message = None;
        let mut field_upsell_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "message" => {
                    if field_message.is_some() {
                        return Err(::serde::de::Error::duplicate_field("message"));
                    }
                    field_message = Some(map.next_value()?);
                }
                "upsell_url" => {
                    if field_upsell_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("upsell_url"));
                    }
                    field_upsell_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = InsufficientPlan {
            message: field_message.ok_or_else(|| ::serde::de::Error::missing_field("message"))?,
            upsell_url: field_upsell_url,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("message", &self.message)?;
        s.serialize_field("upsell_url", &self.upsell_url)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for InsufficientPlan {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = InsufficientPlan;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a InsufficientPlan struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                InsufficientPlan::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("InsufficientPlan", INSUFFICIENT_PLAN_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for InsufficientPlan {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("InsufficientPlan", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct InsufficientQuotaAmounts {
    /// The amount of space needed to add the item (the size of the item).
    pub space_needed: u64,
    /// The amount of extra space needed to add the item.
    pub space_shortage: u64,
    /// The amount of space left in the user's Dropbox, less than space_needed.
    pub space_left: u64,
}

impl InsufficientQuotaAmounts {
    pub fn new(space_needed: u64, space_shortage: u64, space_left: u64) -> Self {
        InsufficientQuotaAmounts {
            space_needed,
            space_shortage,
            space_left,
        }
    }
}

const INSUFFICIENT_QUOTA_AMOUNTS_FIELDS: &[&str] = &["space_needed",
                                                     "space_shortage",
                                                     "space_left"];
impl InsufficientQuotaAmounts {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<InsufficientQuotaAmounts, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<InsufficientQuotaAmounts>, V::Error> {
        let mut field_space_needed = None;
        let mut field_space_shortage = None;
        let mut field_space_left = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "space_needed" => {
                    if field_space_needed.is_some() {
                        return Err(::serde::de::Error::duplicate_field("space_needed"));
                    }
                    field_space_needed = Some(map.next_value()?);
                }
                "space_shortage" => {
                    if field_space_shortage.is_some() {
                        return Err(::serde::de::Error::duplicate_field("space_shortage"));
                    }
                    field_space_shortage = Some(map.next_value()?);
                }
                "space_left" => {
                    if field_space_left.is_some() {
                        return Err(::serde::de::Error::duplicate_field("space_left"));
                    }
                    field_space_left = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = InsufficientQuotaAmounts {
            space_needed: field_space_needed.ok_or_else(|| ::serde::de::Error::missing_field("space_needed"))?,
            space_shortage: field_space_shortage.ok_or_else(|| ::serde::de::Error::missing_field("space_shortage"))?,
            space_left: field_space_left.ok_or_else(|| ::serde::de::Error::missing_field("space_left"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("space_needed", &self.space_needed)?;
        s.serialize_field("space_shortage", &self.space_shortage)?;
        s.serialize_field("space_left", &self.space_left)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for InsufficientQuotaAmounts {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = InsufficientQuotaAmounts;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a InsufficientQuotaAmounts struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                InsufficientQuotaAmounts::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("InsufficientQuotaAmounts", INSUFFICIENT_QUOTA_AMOUNTS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for InsufficientQuotaAmounts {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("InsufficientQuotaAmounts", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Information about the recipient of a shared content invitation.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum InviteeInfo {
    /// Email address of invited user.
    Email(super::common::EmailAddress),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for InviteeInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = InviteeInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a InviteeInfo structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "email" => {
                        match map.next_key()? {
                            Some("email") => InviteeInfo::Email(map.next_value()?),
                            None => return Err(de::Error::missing_field("email")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => InviteeInfo::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["email",
                                    "other"];
        deserializer.deserialize_struct("InviteeInfo", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for InviteeInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            InviteeInfo::Email(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("InviteeInfo", 2)?;
                s.serialize_field(".tag", "email")?;
                s.serialize_field("email", x)?;
                s.end()
            }
            InviteeInfo::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Information about an invited member of a shared content.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct InviteeMembershipInfo {
    /// The access type for this member. It contains inherited access type from parent folder, and
    /// acquired access type from this folder.
    pub access_type: AccessLevel,
    /// Recipient of the invitation.
    pub invitee: InviteeInfo,
    /// The permissions that requesting user has on this member. The set of permissions corresponds
    /// to the MemberActions in the request.
    pub permissions: Option<Vec<MemberPermission>>,
    /// Never set.
    pub initials: Option<String>,
    /// True if the member has access from a parent folder.
    pub is_inherited: bool,
    /// The user this invitation is tied to, if available.
    pub user: Option<UserInfo>,
}

impl InviteeMembershipInfo {
    pub fn new(access_type: AccessLevel, invitee: InviteeInfo) -> Self {
        InviteeMembershipInfo {
            access_type,
            invitee,
            permissions: None,
            initials: None,
            is_inherited: false,
            user: None,
        }
    }

    pub fn with_permissions(mut self, value: Vec<MemberPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_initials(mut self, value: String) -> Self {
        self.initials = Some(value);
        self
    }

    pub fn with_is_inherited(mut self, value: bool) -> Self {
        self.is_inherited = value;
        self
    }

    pub fn with_user(mut self, value: UserInfo) -> Self {
        self.user = Some(value);
        self
    }
}

const INVITEE_MEMBERSHIP_INFO_FIELDS: &[&str] = &["access_type",
                                                  "invitee",
                                                  "permissions",
                                                  "initials",
                                                  "is_inherited",
                                                  "user"];
impl InviteeMembershipInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<InviteeMembershipInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<InviteeMembershipInfo>, V::Error> {
        let mut field_access_type = None;
        let mut field_invitee = None;
        let mut field_permissions = None;
        let mut field_initials = None;
        let mut field_is_inherited = None;
        let mut field_user = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "invitee" => {
                    if field_invitee.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitee"));
                    }
                    field_invitee = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "initials" => {
                    if field_initials.is_some() {
                        return Err(::serde::de::Error::duplicate_field("initials"));
                    }
                    field_initials = Some(map.next_value()?);
                }
                "is_inherited" => {
                    if field_is_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inherited"));
                    }
                    field_is_inherited = Some(map.next_value()?);
                }
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = InviteeMembershipInfo {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            invitee: field_invitee.ok_or_else(|| ::serde::de::Error::missing_field("invitee"))?,
            permissions: field_permissions,
            initials: field_initials,
            is_inherited: field_is_inherited.unwrap_or(false),
            user: field_user,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("invitee", &self.invitee)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("initials", &self.initials)?;
        s.serialize_field("is_inherited", &self.is_inherited)?;
        s.serialize_field("user", &self.user)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for InviteeMembershipInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = InviteeMembershipInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a InviteeMembershipInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                InviteeMembershipInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("InviteeMembershipInfo", INVITEE_MEMBERSHIP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for InviteeMembershipInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("InviteeMembershipInfo", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error occurred while performing an asynchronous job from [`unshare_folder()`](unshare_folder) or
/// [`remove_folder_member()`](remove_folder_member).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum JobError {
    /// Error occurred while performing [`unshare_folder()`](unshare_folder) action.
    UnshareFolderError(UnshareFolderError),
    /// Error occurred while performing [`remove_folder_member()`](remove_folder_member) action.
    RemoveFolderMemberError(RemoveFolderMemberError),
    /// Error occurred while performing
    /// [`relinquish_folder_membership()`](relinquish_folder_membership) action.
    RelinquishFolderMembershipError(RelinquishFolderMembershipError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for JobError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = JobError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a JobError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "unshare_folder_error" => {
                        match map.next_key()? {
                            Some("unshare_folder_error") => JobError::UnshareFolderError(map.next_value()?),
                            None => return Err(de::Error::missing_field("unshare_folder_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "remove_folder_member_error" => {
                        match map.next_key()? {
                            Some("remove_folder_member_error") => JobError::RemoveFolderMemberError(map.next_value()?),
                            None => return Err(de::Error::missing_field("remove_folder_member_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "relinquish_folder_membership_error" => {
                        match map.next_key()? {
                            Some("relinquish_folder_membership_error") => JobError::RelinquishFolderMembershipError(map.next_value()?),
                            None => return Err(de::Error::missing_field("relinquish_folder_membership_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => JobError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["unshare_folder_error",
                                    "remove_folder_member_error",
                                    "relinquish_folder_membership_error",
                                    "other"];
        deserializer.deserialize_struct("JobError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for JobError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            JobError::UnshareFolderError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("JobError", 2)?;
                s.serialize_field(".tag", "unshare_folder_error")?;
                s.serialize_field("unshare_folder_error", x)?;
                s.end()
            }
            JobError::RemoveFolderMemberError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("JobError", 2)?;
                s.serialize_field(".tag", "remove_folder_member_error")?;
                s.serialize_field("remove_folder_member_error", x)?;
                s.end()
            }
            JobError::RelinquishFolderMembershipError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("JobError", 2)?;
                s.serialize_field(".tag", "relinquish_folder_membership_error")?;
                s.serialize_field("relinquish_folder_membership_error", x)?;
                s.end()
            }
            JobError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for JobError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            JobError::UnshareFolderError(inner) => Some(inner),
            JobError::RemoveFolderMemberError(inner) => Some(inner),
            JobError::RelinquishFolderMembershipError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for JobError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            JobError::UnshareFolderError(inner) => write!(f, "{}", inner),
            JobError::RemoveFolderMemberError(inner) => write!(f, "{}", inner),
            JobError::RelinquishFolderMembershipError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum JobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The asynchronous job has finished.
    Complete,
    /// The asynchronous job returned an error.
    Failed(JobError),
}

impl<'de> ::serde::de::Deserialize<'de> for JobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = JobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a JobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => JobStatus::InProgress,
                    "complete" => JobStatus::Complete,
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => JobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("JobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for JobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            JobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("JobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            JobStatus::Complete => {
                // unit
                let mut s = serializer.serialize_struct("JobStatus", 1)?;
                s.serialize_field(".tag", "complete")?;
                s.end()
            }
            JobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("JobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkAccessLevel {
    /// Users who use the link can view and comment on the content.
    Viewer,
    /// Users who use the link can edit, view and comment on the content.
    Editor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkAccessLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkAccessLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkAccessLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "viewer" => LinkAccessLevel::Viewer,
                    "editor" => LinkAccessLevel::Editor,
                    _ => LinkAccessLevel::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["viewer",
                                    "editor",
                                    "other"];
        deserializer.deserialize_struct("LinkAccessLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkAccessLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkAccessLevel::Viewer => {
                // unit
                let mut s = serializer.serialize_struct("LinkAccessLevel", 1)?;
                s.serialize_field(".tag", "viewer")?;
                s.end()
            }
            LinkAccessLevel::Editor => {
                // unit
                let mut s = serializer.serialize_struct("LinkAccessLevel", 1)?;
                s.serialize_field(".tag", "editor")?;
                s.end()
            }
            LinkAccessLevel::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Actions that can be performed on a link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkAction {
    /// Change the access level of the link.
    ChangeAccessLevel,
    /// Change the audience of the link.
    ChangeAudience,
    /// Remove the expiry date of the link.
    RemoveExpiry,
    /// Remove the password of the link.
    RemovePassword,
    /// Create or modify the expiry date of the link.
    SetExpiry,
    /// Create or modify the password of the link.
    SetPassword,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkAction {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkAction;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkAction structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "change_access_level" => LinkAction::ChangeAccessLevel,
                    "change_audience" => LinkAction::ChangeAudience,
                    "remove_expiry" => LinkAction::RemoveExpiry,
                    "remove_password" => LinkAction::RemovePassword,
                    "set_expiry" => LinkAction::SetExpiry,
                    "set_password" => LinkAction::SetPassword,
                    _ => LinkAction::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["change_access_level",
                                    "change_audience",
                                    "remove_expiry",
                                    "remove_password",
                                    "set_expiry",
                                    "set_password",
                                    "other"];
        deserializer.deserialize_struct("LinkAction", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkAction {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkAction::ChangeAccessLevel => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "change_access_level")?;
                s.end()
            }
            LinkAction::ChangeAudience => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "change_audience")?;
                s.end()
            }
            LinkAction::RemoveExpiry => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "remove_expiry")?;
                s.end()
            }
            LinkAction::RemovePassword => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "remove_password")?;
                s.end()
            }
            LinkAction::SetExpiry => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "set_expiry")?;
                s.end()
            }
            LinkAction::SetPassword => {
                // unit
                let mut s = serializer.serialize_struct("LinkAction", 1)?;
                s.serialize_field(".tag", "set_password")?;
                s.end()
            }
            LinkAction::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkAudience {
    /// Link is accessible by anyone.
    Public,
    /// Link is accessible only by team members.
    Team,
    /// The link can be used by no one. The link merely points the user to the content, and does not
    /// grant additional rights to the user. Members of the content who use this link can only
    /// access the content with their pre-existing access rights.
    NoOne,
    /// A link-specific password is required to access the link. Login is not required.
    Password,
    /// Link is accessible only by members of the content.
    Members,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkAudience {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkAudience;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkAudience structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "public" => LinkAudience::Public,
                    "team" => LinkAudience::Team,
                    "no_one" => LinkAudience::NoOne,
                    "password" => LinkAudience::Password,
                    "members" => LinkAudience::Members,
                    _ => LinkAudience::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["public",
                                    "team",
                                    "no_one",
                                    "password",
                                    "members",
                                    "other"];
        deserializer.deserialize_struct("LinkAudience", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkAudience {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkAudience::Public => {
                // unit
                let mut s = serializer.serialize_struct("LinkAudience", 1)?;
                s.serialize_field(".tag", "public")?;
                s.end()
            }
            LinkAudience::Team => {
                // unit
                let mut s = serializer.serialize_struct("LinkAudience", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            LinkAudience::NoOne => {
                // unit
                let mut s = serializer.serialize_struct("LinkAudience", 1)?;
                s.serialize_field(".tag", "no_one")?;
                s.end()
            }
            LinkAudience::Password => {
                // unit
                let mut s = serializer.serialize_struct("LinkAudience", 1)?;
                s.serialize_field(".tag", "password")?;
                s.end()
            }
            LinkAudience::Members => {
                // unit
                let mut s = serializer.serialize_struct("LinkAudience", 1)?;
                s.serialize_field(".tag", "members")?;
                s.end()
            }
            LinkAudience::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkExpiry {
    /// Remove the currently set expiry for the link.
    RemoveExpiry,
    /// Set a new expiry or change an existing expiry.
    SetExpiry(super::common::DropboxTimestamp),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkExpiry {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkExpiry;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkExpiry structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "remove_expiry" => LinkExpiry::RemoveExpiry,
                    "set_expiry" => {
                        match map.next_key()? {
                            Some("set_expiry") => LinkExpiry::SetExpiry(map.next_value()?),
                            None => return Err(de::Error::missing_field("set_expiry")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => LinkExpiry::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["remove_expiry",
                                    "set_expiry",
                                    "other"];
        deserializer.deserialize_struct("LinkExpiry", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkExpiry {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkExpiry::RemoveExpiry => {
                // unit
                let mut s = serializer.serialize_struct("LinkExpiry", 1)?;
                s.serialize_field(".tag", "remove_expiry")?;
                s.end()
            }
            LinkExpiry::SetExpiry(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("LinkExpiry", 2)?;
                s.serialize_field(".tag", "set_expiry")?;
                s.serialize_field("set_expiry", x)?;
                s.end()
            }
            LinkExpiry::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Metadata for a shared link. This can be either a [`PathLinkMetadata`](PathLinkMetadata) or
/// [`CollectionLinkMetadata`](CollectionLinkMetadata).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkMetadata {
    Path(PathLinkMetadata),
    Collection(CollectionLinkMetadata),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkMetadata structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "path" => Ok(LinkMetadata::Path(PathLinkMetadata::internal_deserialize(map)?)),
                    "collection" => Ok(LinkMetadata::Collection(CollectionLinkMetadata::internal_deserialize(map)?)),
                    _ => {
                        crate::eat_json_fields(&mut map)?;
                        Ok(LinkMetadata::Other)
                    }
                }
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "collection"];
        deserializer.deserialize_struct("LinkMetadata", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkMetadata::Path(ref x) => {
                let mut s = serializer.serialize_struct("LinkMetadata", 5)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("url", &x.url)?;
                s.serialize_field("visibility", &x.visibility)?;
                s.serialize_field("path", &x.path)?;
                s.serialize_field("expires", &x.expires)?;
                s.end()
            }
            LinkMetadata::Collection(ref x) => {
                let mut s = serializer.serialize_struct("LinkMetadata", 4)?;
                s.serialize_field(".tag", "collection")?;
                s.serialize_field("url", &x.url)?;
                s.serialize_field("visibility", &x.visibility)?;
                s.serialize_field("expires", &x.expires)?;
                s.end()
            }
            LinkMetadata::Other => Err(::serde::ser::Error::custom("cannot serialize unknown variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum LinkPassword {
    /// Remove the currently set password for the link.
    RemovePassword,
    /// Set a new password or change an existing password.
    SetPassword(String),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for LinkPassword {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = LinkPassword;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkPassword structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "remove_password" => LinkPassword::RemovePassword,
                    "set_password" => {
                        match map.next_key()? {
                            Some("set_password") => LinkPassword::SetPassword(map.next_value()?),
                            None => return Err(de::Error::missing_field("set_password")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => LinkPassword::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["remove_password",
                                    "set_password",
                                    "other"];
        deserializer.deserialize_struct("LinkPassword", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for LinkPassword {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            LinkPassword::RemovePassword => {
                // unit
                let mut s = serializer.serialize_struct("LinkPassword", 1)?;
                s.serialize_field(".tag", "remove_password")?;
                s.end()
            }
            LinkPassword::SetPassword(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("LinkPassword", 2)?;
                s.serialize_field(".tag", "set_password")?;
                s.serialize_field("set_password", x)?;
                s.end()
            }
            LinkPassword::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Permissions for actions that can be performed on a link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LinkPermission {
    pub action: LinkAction,
    pub allow: bool,
    pub reason: Option<PermissionDeniedReason>,
}

impl LinkPermission {
    pub fn new(action: LinkAction, allow: bool) -> Self {
        LinkPermission {
            action,
            allow,
            reason: None,
        }
    }

    pub fn with_reason(mut self, value: PermissionDeniedReason) -> Self {
        self.reason = Some(value);
        self
    }
}

const LINK_PERMISSION_FIELDS: &[&str] = &["action",
                                          "allow",
                                          "reason"];
impl LinkPermission {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LinkPermission, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LinkPermission>, V::Error> {
        let mut field_action = None;
        let mut field_allow = None;
        let mut field_reason = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "action" => {
                    if field_action.is_some() {
                        return Err(::serde::de::Error::duplicate_field("action"));
                    }
                    field_action = Some(map.next_value()?);
                }
                "allow" => {
                    if field_allow.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow"));
                    }
                    field_allow = Some(map.next_value()?);
                }
                "reason" => {
                    if field_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("reason"));
                    }
                    field_reason = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LinkPermission {
            action: field_action.ok_or_else(|| ::serde::de::Error::missing_field("action"))?,
            allow: field_allow.ok_or_else(|| ::serde::de::Error::missing_field("allow"))?,
            reason: field_reason,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("action", &self.action)?;
        s.serialize_field("allow", &self.allow)?;
        s.serialize_field("reason", &self.reason)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LinkPermission {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LinkPermission;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkPermission struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LinkPermission::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LinkPermission", LINK_PERMISSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LinkPermission {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LinkPermission", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LinkPermissions {
    /// Whether the caller can revoke the shared link.
    pub can_revoke: bool,
    /// The current visibility of the link after considering the shared links policies of the the
    /// team (in case the link's owner is part of a team) and the shared folder (in case the linked
    /// file is part of a shared folder). This field is shown only if the caller has access to this
    /// info (the link's owner always has access to this data). For some links, an
    /// effective_audience value is returned instead.
    pub resolved_visibility: Option<ResolvedVisibility>,
    /// The shared link's requested visibility. This can be overridden by the team and shared folder
    /// policies. The final visibility, after considering these policies, can be found in
    /// `resolved_visibility`. This is shown only if the caller is the link's owner and
    /// resolved_visibility is returned instead of effective_audience.
    pub requested_visibility: Option<RequestedVisibility>,
    /// The failure reason for revoking the link. This field will only be present if the
    /// `can_revoke` is `false`.
    pub revoke_failure_reason: Option<SharedLinkAccessFailureReason>,
    /// The type of audience who can benefit from the access level specified by the
    /// `link_access_level` field.
    pub effective_audience: Option<LinkAudience>,
    /// The access level that the link will grant to its users. A link can grant additional rights
    /// to a user beyond their current access level. For example, if a user was invited as a viewer
    /// to a file, and then opens a link with `link_access_level` set to `editor`, then they will
    /// gain editor privileges. The `link_access_level` is a property of the link, and does not
    /// depend on who is calling this API. In particular, `link_access_level` does not take into
    /// account the API caller's current permissions to the content.
    pub link_access_level: Option<LinkAccessLevel>,
}

impl LinkPermissions {
    pub fn new(can_revoke: bool) -> Self {
        LinkPermissions {
            can_revoke,
            resolved_visibility: None,
            requested_visibility: None,
            revoke_failure_reason: None,
            effective_audience: None,
            link_access_level: None,
        }
    }

    pub fn with_resolved_visibility(mut self, value: ResolvedVisibility) -> Self {
        self.resolved_visibility = Some(value);
        self
    }

    pub fn with_requested_visibility(mut self, value: RequestedVisibility) -> Self {
        self.requested_visibility = Some(value);
        self
    }

    pub fn with_revoke_failure_reason(mut self, value: SharedLinkAccessFailureReason) -> Self {
        self.revoke_failure_reason = Some(value);
        self
    }

    pub fn with_effective_audience(mut self, value: LinkAudience) -> Self {
        self.effective_audience = Some(value);
        self
    }

    pub fn with_link_access_level(mut self, value: LinkAccessLevel) -> Self {
        self.link_access_level = Some(value);
        self
    }
}

const LINK_PERMISSIONS_FIELDS: &[&str] = &["can_revoke",
                                           "resolved_visibility",
                                           "requested_visibility",
                                           "revoke_failure_reason",
                                           "effective_audience",
                                           "link_access_level"];
impl LinkPermissions {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<LinkPermissions, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<LinkPermissions>, V::Error> {
        let mut field_can_revoke = None;
        let mut field_resolved_visibility = None;
        let mut field_requested_visibility = None;
        let mut field_revoke_failure_reason = None;
        let mut field_effective_audience = None;
        let mut field_link_access_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "can_revoke" => {
                    if field_can_revoke.is_some() {
                        return Err(::serde::de::Error::duplicate_field("can_revoke"));
                    }
                    field_can_revoke = Some(map.next_value()?);
                }
                "resolved_visibility" => {
                    if field_resolved_visibility.is_some() {
                        return Err(::serde::de::Error::duplicate_field("resolved_visibility"));
                    }
                    field_resolved_visibility = Some(map.next_value()?);
                }
                "requested_visibility" => {
                    if field_requested_visibility.is_some() {
                        return Err(::serde::de::Error::duplicate_field("requested_visibility"));
                    }
                    field_requested_visibility = Some(map.next_value()?);
                }
                "revoke_failure_reason" => {
                    if field_revoke_failure_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("revoke_failure_reason"));
                    }
                    field_revoke_failure_reason = Some(map.next_value()?);
                }
                "effective_audience" => {
                    if field_effective_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("effective_audience"));
                    }
                    field_effective_audience = Some(map.next_value()?);
                }
                "link_access_level" => {
                    if field_link_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_access_level"));
                    }
                    field_link_access_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = LinkPermissions {
            can_revoke: field_can_revoke.ok_or_else(|| ::serde::de::Error::missing_field("can_revoke"))?,
            resolved_visibility: field_resolved_visibility,
            requested_visibility: field_requested_visibility,
            revoke_failure_reason: field_revoke_failure_reason,
            effective_audience: field_effective_audience,
            link_access_level: field_link_access_level,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("can_revoke", &self.can_revoke)?;
        s.serialize_field("resolved_visibility", &self.resolved_visibility)?;
        s.serialize_field("requested_visibility", &self.requested_visibility)?;
        s.serialize_field("revoke_failure_reason", &self.revoke_failure_reason)?;
        s.serialize_field("effective_audience", &self.effective_audience)?;
        s.serialize_field("link_access_level", &self.link_access_level)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LinkPermissions {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LinkPermissions;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkPermissions struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LinkPermissions::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LinkPermissions", LINK_PERMISSIONS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LinkPermissions {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LinkPermissions", 6)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Settings that apply to a link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct LinkSettings {
    /// The access level on the link for this file. Currently, it only accepts 'viewer' and
    /// 'viewer_no_comment'.
    pub access_level: Option<AccessLevel>,
    /// The type of audience on the link for this file.
    pub audience: Option<LinkAudience>,
    /// An expiry timestamp to set on a link.
    pub expiry: Option<LinkExpiry>,
    /// The password for the link.
    pub password: Option<LinkPassword>,
}

impl Default for LinkSettings {
    fn default() -> Self {
        LinkSettings {
            access_level: None,
            audience: None,
            expiry: None,
            password: None,
        }
    }
}

impl LinkSettings {
    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = Some(value);
        self
    }

    pub fn with_audience(mut self, value: LinkAudience) -> Self {
        self.audience = Some(value);
        self
    }

    pub fn with_expiry(mut self, value: LinkExpiry) -> Self {
        self.expiry = Some(value);
        self
    }

    pub fn with_password(mut self, value: LinkPassword) -> Self {
        self.password = Some(value);
        self
    }
}

const LINK_SETTINGS_FIELDS: &[&str] = &["access_level",
                                        "audience",
                                        "expiry",
                                        "password"];
impl LinkSettings {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<LinkSettings, V::Error> {
        let mut field_access_level = None;
        let mut field_audience = None;
        let mut field_expiry = None;
        let mut field_password = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "audience" => {
                    if field_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience"));
                    }
                    field_audience = Some(map.next_value()?);
                }
                "expiry" => {
                    if field_expiry.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiry"));
                    }
                    field_expiry = Some(map.next_value()?);
                }
                "password" => {
                    if field_password.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password"));
                    }
                    field_password = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = LinkSettings {
            access_level: field_access_level,
            audience: field_audience,
            expiry: field_expiry,
            password: field_password,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("audience", &self.audience)?;
        s.serialize_field("expiry", &self.expiry)?;
        s.serialize_field("password", &self.password)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for LinkSettings {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = LinkSettings;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a LinkSettings struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                LinkSettings::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("LinkSettings", LINK_SETTINGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for LinkSettings {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("LinkSettings", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`list_file_members()`](list_file_members).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileMembersArg {
    /// The file for which you want to see members.
    pub file: PathOrId,
    /// The actions for which to return permissions on a member.
    pub actions: Option<Vec<MemberAction>>,
    /// Whether to include members who only have access from a parent shared folder.
    pub include_inherited: bool,
    /// Number of members to return max per query. Defaults to 100 if no limit is specified.
    pub limit: u32,
}

impl ListFileMembersArg {
    pub fn new(file: PathOrId) -> Self {
        ListFileMembersArg {
            file,
            actions: None,
            include_inherited: true,
            limit: 100,
        }
    }

    pub fn with_actions(mut self, value: Vec<MemberAction>) -> Self {
        self.actions = Some(value);
        self
    }

    pub fn with_include_inherited(mut self, value: bool) -> Self {
        self.include_inherited = value;
        self
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_FILE_MEMBERS_ARG_FIELDS: &[&str] = &["file",
                                                "actions",
                                                "include_inherited",
                                                "limit"];
impl ListFileMembersArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileMembersArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileMembersArg>, V::Error> {
        let mut field_file = None;
        let mut field_actions = None;
        let mut field_include_inherited = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                "include_inherited" => {
                    if field_include_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("include_inherited"));
                    }
                    field_include_inherited = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileMembersArg {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            actions: field_actions,
            include_inherited: field_include_inherited.unwrap_or(true),
            limit: field_limit.unwrap_or(100),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("actions", &self.actions)?;
        s.serialize_field("include_inherited", &self.include_inherited)?;
        s.serialize_field("limit", &self.limit)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileMembersArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileMembersArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileMembersArg", LIST_FILE_MEMBERS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileMembersArg", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`list_file_members_batch()`](list_file_members_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileMembersBatchArg {
    /// Files for which to return members.
    pub files: Vec<PathOrId>,
    /// Number of members to return max per query. Defaults to 10 if no limit is specified.
    pub limit: u32,
}

impl ListFileMembersBatchArg {
    pub fn new(files: Vec<PathOrId>) -> Self {
        ListFileMembersBatchArg {
            files,
            limit: 10,
        }
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_FILE_MEMBERS_BATCH_ARG_FIELDS: &[&str] = &["files",
                                                      "limit"];
impl ListFileMembersBatchArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileMembersBatchArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileMembersBatchArg>, V::Error> {
        let mut field_files = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "files" => {
                    if field_files.is_some() {
                        return Err(::serde::de::Error::duplicate_field("files"));
                    }
                    field_files = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileMembersBatchArg {
            files: field_files.ok_or_else(|| ::serde::de::Error::missing_field("files"))?,
            limit: field_limit.unwrap_or(10),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("files", &self.files)?;
        s.serialize_field("limit", &self.limit)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersBatchArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileMembersBatchArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersBatchArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileMembersBatchArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileMembersBatchArg", LIST_FILE_MEMBERS_BATCH_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersBatchArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileMembersBatchArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Per-file result for [`list_file_members_batch()`](list_file_members_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileMembersBatchResult {
    /// This is the input file identifier, whether an ID or a path.
    pub file: PathOrId,
    /// The result for this particular file.
    pub result: ListFileMembersIndividualResult,
}

impl ListFileMembersBatchResult {
    pub fn new(file: PathOrId, result: ListFileMembersIndividualResult) -> Self {
        ListFileMembersBatchResult {
            file,
            result,
        }
    }
}

const LIST_FILE_MEMBERS_BATCH_RESULT_FIELDS: &[&str] = &["file",
                                                         "result"];
impl ListFileMembersBatchResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileMembersBatchResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileMembersBatchResult>, V::Error> {
        let mut field_file = None;
        let mut field_result = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "result" => {
                    if field_result.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result"));
                    }
                    field_result = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileMembersBatchResult {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            result: field_result.ok_or_else(|| ::serde::de::Error::missing_field("result"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("result", &self.result)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersBatchResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileMembersBatchResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersBatchResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileMembersBatchResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileMembersBatchResult", LIST_FILE_MEMBERS_BATCH_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersBatchResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileMembersBatchResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`list_file_members_continue()`](list_file_members_continue).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileMembersContinueArg {
    /// The cursor returned by your last call to [`list_file_members()`](list_file_members),
    /// [`list_file_members_continue()`](list_file_members_continue), or
    /// [`list_file_members_batch()`](list_file_members_batch).
    pub cursor: String,
}

impl ListFileMembersContinueArg {
    pub fn new(cursor: String) -> Self {
        ListFileMembersContinueArg {
            cursor,
        }
    }
}

const LIST_FILE_MEMBERS_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFileMembersContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileMembersContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileMembersContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileMembersContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileMembersContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileMembersContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileMembersContinueArg", LIST_FILE_MEMBERS_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileMembersContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error for [`list_file_members_continue()`](list_file_members_continue).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFileMembersContinueError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// [`ListFileMembersContinueArg::cursor`](ListFileMembersContinueArg) is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFileMembersContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => ListFileMembersContinueError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => ListFileMembersContinueError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_cursor" => ListFileMembersContinueError::InvalidCursor,
                    _ => ListFileMembersContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("ListFileMembersContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFileMembersContinueError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFileMembersContinueError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            ListFileMembersContinueError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFileMembersContinueError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            ListFileMembersContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ListFileMembersContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ListFileMembersContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFileMembersContinueError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFileMembersContinueError::UserError(inner) => Some(inner),
            ListFileMembersContinueError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFileMembersContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFileMembersContinueError::UserError(inner) => write!(f, "{}", inner),
            ListFileMembersContinueError::AccessError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFileMembersCountResult {
    /// A list of members on this file.
    pub members: SharedFileMembers,
    /// The number of members on this file. This does not include inherited members.
    pub member_count: u32,
}

impl ListFileMembersCountResult {
    pub fn new(members: SharedFileMembers, member_count: u32) -> Self {
        ListFileMembersCountResult {
            members,
            member_count,
        }
    }
}

const LIST_FILE_MEMBERS_COUNT_RESULT_FIELDS: &[&str] = &["members",
                                                         "member_count"];
impl ListFileMembersCountResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFileMembersCountResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFileMembersCountResult>, V::Error> {
        let mut field_members = None;
        let mut field_member_count = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "members" => {
                    if field_members.is_some() {
                        return Err(::serde::de::Error::duplicate_field("members"));
                    }
                    field_members = Some(map.next_value()?);
                }
                "member_count" => {
                    if field_member_count.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_count"));
                    }
                    field_member_count = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFileMembersCountResult {
            members: field_members.ok_or_else(|| ::serde::de::Error::missing_field("members"))?,
            member_count: field_member_count.ok_or_else(|| ::serde::de::Error::missing_field("member_count"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("members", &self.members)?;
        s.serialize_field("member_count", &self.member_count)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersCountResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFileMembersCountResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersCountResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFileMembersCountResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFileMembersCountResult", LIST_FILE_MEMBERS_COUNT_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersCountResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFileMembersCountResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error for [`list_file_members()`](list_file_members).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFileMembersError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFileMembersError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => ListFileMembersError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => ListFileMembersError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListFileMembersError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "other"];
        deserializer.deserialize_struct("ListFileMembersError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFileMembersError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFileMembersError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            ListFileMembersError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFileMembersError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            ListFileMembersError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFileMembersError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFileMembersError::UserError(inner) => Some(inner),
            ListFileMembersError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFileMembersError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFileMembersError::UserError(inner) => write!(f, "{}", inner),
            ListFileMembersError::AccessError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFileMembersIndividualResult {
    /// The results of the query for this file if it was successful.
    Result(ListFileMembersCountResult),
    /// The result of the query for this file if it was an error.
    AccessError(SharingFileAccessError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFileMembersIndividualResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFileMembersIndividualResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFileMembersIndividualResult structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "result" => ListFileMembersIndividualResult::Result(ListFileMembersCountResult::internal_deserialize(&mut map)?),
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => ListFileMembersIndividualResult::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => ListFileMembersIndividualResult::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["result",
                                    "access_error",
                                    "other"];
        deserializer.deserialize_struct("ListFileMembersIndividualResult", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFileMembersIndividualResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFileMembersIndividualResult::Result(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ListFileMembersIndividualResult", 3)?;
                s.serialize_field(".tag", "result")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ListFileMembersIndividualResult::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFileMembersIndividualResult", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            ListFileMembersIndividualResult::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Arguments for [`list_received_files()`](list_received_files).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFilesArg {
    /// Number of files to return max per query. Defaults to 100 if no limit is specified.
    pub limit: u32,
    /// A list of `FileAction`s corresponding to `FilePermission`s that should appear in the
    /// response's [`SharedFileMetadata::permissions`](SharedFileMetadata) field describing the
    /// actions the  authenticated user can perform on the file.
    pub actions: Option<Vec<FileAction>>,
}

impl Default for ListFilesArg {
    fn default() -> Self {
        ListFilesArg {
            limit: 100,
            actions: None,
        }
    }
}

impl ListFilesArg {
    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }

    pub fn with_actions(mut self, value: Vec<FileAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const LIST_FILES_ARG_FIELDS: &[&str] = &["limit",
                                         "actions"];
impl ListFilesArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListFilesArg, V::Error> {
        let mut field_limit = None;
        let mut field_actions = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListFilesArg {
            limit: field_limit.unwrap_or(100),
            actions: field_actions,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFilesArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFilesArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFilesArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFilesArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFilesArg", LIST_FILES_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFilesArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFilesArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Arguments for [`list_received_files_continue()`](list_received_files_continue).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFilesContinueArg {
    /// Cursor in [`ListFilesResult::cursor`](ListFilesResult).
    pub cursor: String,
}

impl ListFilesContinueArg {
    pub fn new(cursor: String) -> Self {
        ListFilesContinueArg {
            cursor,
        }
    }
}

const LIST_FILES_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFilesContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFilesContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFilesContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFilesContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFilesContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFilesContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFilesContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFilesContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFilesContinueArg", LIST_FILES_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFilesContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFilesContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error results for [`list_received_files_continue()`](list_received_files_continue).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFilesContinueError {
    /// User account had a problem.
    UserError(SharingUserError),
    /// [`ListFilesContinueArg::cursor`](ListFilesContinueArg) is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFilesContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFilesContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFilesContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => ListFilesContinueError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_cursor" => ListFilesContinueError::InvalidCursor,
                    _ => ListFilesContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("ListFilesContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFilesContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFilesContinueError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFilesContinueError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            ListFilesContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ListFilesContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ListFilesContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFilesContinueError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFilesContinueError::UserError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFilesContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFilesContinueError::UserError(inner) => write!(f, "User account had a problem: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Success results for [`list_received_files()`](list_received_files).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFilesResult {
    /// Information about the files shared with current user.
    pub entries: Vec<SharedFileMetadata>,
    /// Cursor used to obtain additional shared files.
    pub cursor: Option<String>,
}

impl ListFilesResult {
    pub fn new(entries: Vec<SharedFileMetadata>) -> Self {
        ListFilesResult {
            entries,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_FILES_RESULT_FIELDS: &[&str] = &["entries",
                                            "cursor"];
impl ListFilesResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFilesResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFilesResult>, V::Error> {
        let mut field_entries = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFilesResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFilesResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFilesResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFilesResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFilesResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFilesResult", LIST_FILES_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFilesResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFilesResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderMembersArgs {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// This is a list indicating whether each returned member will include a boolean value
    /// [`MemberPermission::allow`](MemberPermission) that describes whether the current user can
    /// perform the MemberAction on the member.
    pub actions: Option<Vec<MemberAction>>,
    /// The maximum number of results that include members, groups and invitees to return per
    /// request.
    pub limit: u32,
}

impl ListFolderMembersArgs {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        ListFolderMembersArgs {
            shared_folder_id,
            actions: None,
            limit: 1000,
        }
    }

    pub fn with_actions(mut self, value: Vec<MemberAction>) -> Self {
        self.actions = Some(value);
        self
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_FOLDER_MEMBERS_ARGS_FIELDS: &[&str] = &["shared_folder_id",
                                                   "actions",
                                                   "limit"];
impl ListFolderMembersArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderMembersArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderMembersArgs>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_actions = None;
        let mut field_limit = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderMembersArgs {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            actions: field_actions,
            limit: field_limit.unwrap_or(1000),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("actions", &self.actions)?;
        s.serialize_field("limit", &self.limit)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderMembersArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderMembersArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderMembersArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderMembersArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderMembersArgs", LIST_FOLDER_MEMBERS_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderMembersArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderMembersArgs", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderMembersContinueArg {
    /// The cursor returned by your last call to [`list_folder_members()`](list_folder_members) or
    /// [`list_folder_members_continue()`](list_folder_members_continue).
    pub cursor: String,
}

impl ListFolderMembersContinueArg {
    pub fn new(cursor: String) -> Self {
        ListFolderMembersContinueArg {
            cursor,
        }
    }
}

const LIST_FOLDER_MEMBERS_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFolderMembersContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFolderMembersContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFolderMembersContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFolderMembersContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderMembersContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderMembersContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderMembersContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderMembersContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderMembersContinueArg", LIST_FOLDER_MEMBERS_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderMembersContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderMembersContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFolderMembersContinueError {
    AccessError(SharedFolderAccessError),
    /// [`ListFolderMembersContinueArg::cursor`](ListFolderMembersContinueArg) is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderMembersContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFolderMembersContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderMembersContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => ListFolderMembersContinueError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_cursor" => ListFolderMembersContinueError::InvalidCursor,
                    _ => ListFolderMembersContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("ListFolderMembersContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderMembersContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFolderMembersContinueError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListFolderMembersContinueError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            ListFolderMembersContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ListFolderMembersContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ListFolderMembersContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFolderMembersContinueError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListFolderMembersContinueError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListFolderMembersContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListFolderMembersContinueError::AccessError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFolderMembersCursorArg {
    /// This is a list indicating whether each returned member will include a boolean value
    /// [`MemberPermission::allow`](MemberPermission) that describes whether the current user can
    /// perform the MemberAction on the member.
    pub actions: Option<Vec<MemberAction>>,
    /// The maximum number of results that include members, groups and invitees to return per
    /// request.
    pub limit: u32,
}

impl Default for ListFolderMembersCursorArg {
    fn default() -> Self {
        ListFolderMembersCursorArg {
            actions: None,
            limit: 1000,
        }
    }
}

impl ListFolderMembersCursorArg {
    pub fn with_actions(mut self, value: Vec<MemberAction>) -> Self {
        self.actions = Some(value);
        self
    }

    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }
}

const LIST_FOLDER_MEMBERS_CURSOR_ARG_FIELDS: &[&str] = &["actions",
                                                         "limit"];
impl ListFolderMembersCursorArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListFolderMembersCursorArg, V::Error> {
        let mut field_actions = None;
        let mut field_limit = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListFolderMembersCursorArg {
            actions: field_actions,
            limit: field_limit.unwrap_or(1000),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("actions", &self.actions)?;
        s.serialize_field("limit", &self.limit)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFolderMembersCursorArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFolderMembersCursorArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFolderMembersCursorArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFolderMembersCursorArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFolderMembersCursorArg", LIST_FOLDER_MEMBERS_CURSOR_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFolderMembersCursorArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFolderMembersCursorArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFoldersArgs {
    /// The maximum number of results to return per request.
    pub limit: u32,
    /// A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the
    /// response's [`SharedFolderMetadata::permissions`](SharedFolderMetadata) field describing the
    /// actions the  authenticated user can perform on the folder.
    pub actions: Option<Vec<FolderAction>>,
}

impl Default for ListFoldersArgs {
    fn default() -> Self {
        ListFoldersArgs {
            limit: 1000,
            actions: None,
        }
    }
}

impl ListFoldersArgs {
    pub fn with_limit(mut self, value: u32) -> Self {
        self.limit = value;
        self
    }

    pub fn with_actions(mut self, value: Vec<FolderAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const LIST_FOLDERS_ARGS_FIELDS: &[&str] = &["limit",
                                            "actions"];
impl ListFoldersArgs {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListFoldersArgs, V::Error> {
        let mut field_limit = None;
        let mut field_actions = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "limit" => {
                    if field_limit.is_some() {
                        return Err(::serde::de::Error::duplicate_field("limit"));
                    }
                    field_limit = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListFoldersArgs {
            limit: field_limit.unwrap_or(1000),
            actions: field_actions,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("limit", &self.limit)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFoldersArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFoldersArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFoldersArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFoldersArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFoldersArgs", LIST_FOLDERS_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFoldersArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFoldersArgs", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFoldersContinueArg {
    /// The cursor returned by the previous API call specified in the endpoint description.
    pub cursor: String,
}

impl ListFoldersContinueArg {
    pub fn new(cursor: String) -> Self {
        ListFoldersContinueArg {
            cursor,
        }
    }
}

const LIST_FOLDERS_CONTINUE_ARG_FIELDS: &[&str] = &["cursor"];
impl ListFoldersContinueArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFoldersContinueArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFoldersContinueArg>, V::Error> {
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFoldersContinueArg {
            cursor: field_cursor.ok_or_else(|| ::serde::de::Error::missing_field("cursor"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFoldersContinueArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFoldersContinueArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFoldersContinueArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFoldersContinueArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFoldersContinueArg", LIST_FOLDERS_CONTINUE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFoldersContinueArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFoldersContinueArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListFoldersContinueError {
    /// [`ListFoldersContinueArg::cursor`](ListFoldersContinueArg) is invalid.
    InvalidCursor,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListFoldersContinueError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListFoldersContinueError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFoldersContinueError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_cursor" => ListFoldersContinueError::InvalidCursor,
                    _ => ListFoldersContinueError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_cursor",
                                    "other"];
        deserializer.deserialize_struct("ListFoldersContinueError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListFoldersContinueError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListFoldersContinueError::InvalidCursor => {
                // unit
                let mut s = serializer.serialize_struct("ListFoldersContinueError", 1)?;
                s.serialize_field(".tag", "invalid_cursor")?;
                s.end()
            }
            ListFoldersContinueError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListFoldersContinueError {
}

impl ::std::fmt::Display for ListFoldersContinueError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Result for [`list_folders()`](list_folders) or
/// [`list_mountable_folders()`](list_mountable_folders), depending on which endpoint was requested.
/// Unmounted shared folders can be identified by the absence of
/// [`SharedFolderMetadata::path_lower`](SharedFolderMetadata).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListFoldersResult {
    /// List of all shared folders the authenticated user has access to.
    pub entries: Vec<SharedFolderMetadata>,
    /// Present if there are additional shared folders that have not been returned yet. Pass the
    /// cursor into the corresponding continue endpoint (either
    /// [`list_folders_continue()`](list_folders_continue) or
    /// [`list_mountable_folders_continue()`](list_mountable_folders_continue)) to list additional
    /// folders.
    pub cursor: Option<String>,
}

impl ListFoldersResult {
    pub fn new(entries: Vec<SharedFolderMetadata>) -> Self {
        ListFoldersResult {
            entries,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_FOLDERS_RESULT_FIELDS: &[&str] = &["entries",
                                              "cursor"];
impl ListFoldersResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListFoldersResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListFoldersResult>, V::Error> {
        let mut field_entries = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "entries" => {
                    if field_entries.is_some() {
                        return Err(::serde::de::Error::duplicate_field("entries"));
                    }
                    field_entries = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListFoldersResult {
            entries: field_entries.ok_or_else(|| ::serde::de::Error::missing_field("entries"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("entries", &self.entries)?;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListFoldersResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListFoldersResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListFoldersResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListFoldersResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListFoldersResult", LIST_FOLDERS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListFoldersResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListFoldersResult", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListSharedLinksArg {
    /// See [`list_shared_links()`](list_shared_links) description.
    pub path: Option<ReadPath>,
    /// The cursor returned by your last call to [`list_shared_links()`](list_shared_links).
    pub cursor: Option<String>,
    /// See [`list_shared_links()`](list_shared_links) description.
    pub direct_only: Option<bool>,
}

impl Default for ListSharedLinksArg {
    fn default() -> Self {
        ListSharedLinksArg {
            path: None,
            cursor: None,
            direct_only: None,
        }
    }
}

impl ListSharedLinksArg {
    pub fn with_path(mut self, value: ReadPath) -> Self {
        self.path = Some(value);
        self
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }

    pub fn with_direct_only(mut self, value: bool) -> Self {
        self.direct_only = Some(value);
        self
    }
}

const LIST_SHARED_LINKS_ARG_FIELDS: &[&str] = &["path",
                                                "cursor",
                                                "direct_only"];
impl ListSharedLinksArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<ListSharedLinksArg, V::Error> {
        let mut field_path = None;
        let mut field_cursor = None;
        let mut field_direct_only = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                "direct_only" => {
                    if field_direct_only.is_some() {
                        return Err(::serde::de::Error::duplicate_field("direct_only"));
                    }
                    field_direct_only = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = ListSharedLinksArg {
            path: field_path,
            cursor: field_cursor,
            direct_only: field_direct_only,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("cursor", &self.cursor)?;
        s.serialize_field("direct_only", &self.direct_only)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListSharedLinksArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListSharedLinksArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListSharedLinksArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListSharedLinksArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListSharedLinksArg", LIST_SHARED_LINKS_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListSharedLinksArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListSharedLinksArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ListSharedLinksError {
    Path(super::files::LookupError),
    /// Indicates that the cursor has been invalidated. Call
    /// [`list_shared_links()`](list_shared_links) to obtain a new cursor.
    Reset,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ListSharedLinksError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ListSharedLinksError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListSharedLinksError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "path" => {
                        match map.next_key()? {
                            Some("path") => ListSharedLinksError::Path(map.next_value()?),
                            None => return Err(de::Error::missing_field("path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "reset" => ListSharedLinksError::Reset,
                    _ => ListSharedLinksError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["path",
                                    "reset",
                                    "other"];
        deserializer.deserialize_struct("ListSharedLinksError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ListSharedLinksError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ListSharedLinksError::Path(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ListSharedLinksError", 2)?;
                s.serialize_field(".tag", "path")?;
                s.serialize_field("path", x)?;
                s.end()
            }
            ListSharedLinksError::Reset => {
                // unit
                let mut s = serializer.serialize_struct("ListSharedLinksError", 1)?;
                s.serialize_field(".tag", "reset")?;
                s.end()
            }
            ListSharedLinksError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ListSharedLinksError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ListSharedLinksError::Path(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ListSharedLinksError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ListSharedLinksError::Path(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ListSharedLinksResult {
    /// Shared links applicable to the path argument.
    pub links: Vec<SharedLinkMetadata>,
    /// Is true if there are additional shared links that have not been returned yet. Pass the
    /// cursor into [`list_shared_links()`](list_shared_links) to retrieve them.
    pub has_more: bool,
    /// Pass the cursor into [`list_shared_links()`](list_shared_links) to obtain the additional
    /// links. Cursor is returned only if no path is given.
    pub cursor: Option<String>,
}

impl ListSharedLinksResult {
    pub fn new(links: Vec<SharedLinkMetadata>, has_more: bool) -> Self {
        ListSharedLinksResult {
            links,
            has_more,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const LIST_SHARED_LINKS_RESULT_FIELDS: &[&str] = &["links",
                                                   "has_more",
                                                   "cursor"];
impl ListSharedLinksResult {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ListSharedLinksResult, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ListSharedLinksResult>, V::Error> {
        let mut field_links = None;
        let mut field_has_more = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "links" => {
                    if field_links.is_some() {
                        return Err(::serde::de::Error::duplicate_field("links"));
                    }
                    field_links = Some(map.next_value()?);
                }
                "has_more" => {
                    if field_has_more.is_some() {
                        return Err(::serde::de::Error::duplicate_field("has_more"));
                    }
                    field_has_more = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ListSharedLinksResult {
            links: field_links.ok_or_else(|| ::serde::de::Error::missing_field("links"))?,
            has_more: field_has_more.ok_or_else(|| ::serde::de::Error::missing_field("has_more"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("links", &self.links)?;
        s.serialize_field("has_more", &self.has_more)?;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ListSharedLinksResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ListSharedLinksResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ListSharedLinksResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ListSharedLinksResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ListSharedLinksResult", LIST_SHARED_LINKS_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ListSharedLinksResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ListSharedLinksResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Contains information about a member's access level to content after an operation.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberAccessLevelResult {
    /// The member still has this level of access to the content through a parent folder.
    pub access_level: Option<AccessLevel>,
    /// A localized string with additional information about why the user has this access level to
    /// the content.
    pub warning: Option<String>,
    /// The parent folders that a member has access to. The field is present if the user has access
    /// to the first parent folder where the member gains access.
    pub access_details: Option<Vec<ParentFolderAccessInfo>>,
}

impl Default for MemberAccessLevelResult {
    fn default() -> Self {
        MemberAccessLevelResult {
            access_level: None,
            warning: None,
            access_details: None,
        }
    }
}

impl MemberAccessLevelResult {
    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = Some(value);
        self
    }

    pub fn with_warning(mut self, value: String) -> Self {
        self.warning = Some(value);
        self
    }

    pub fn with_access_details(mut self, value: Vec<ParentFolderAccessInfo>) -> Self {
        self.access_details = Some(value);
        self
    }
}

const MEMBER_ACCESS_LEVEL_RESULT_FIELDS: &[&str] = &["access_level",
                                                     "warning",
                                                     "access_details"];
impl MemberAccessLevelResult {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<MemberAccessLevelResult, V::Error> {
        let mut field_access_level = None;
        let mut field_warning = None;
        let mut field_access_details = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "warning" => {
                    if field_warning.is_some() {
                        return Err(::serde::de::Error::duplicate_field("warning"));
                    }
                    field_warning = Some(map.next_value()?);
                }
                "access_details" => {
                    if field_access_details.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_details"));
                    }
                    field_access_details = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = MemberAccessLevelResult {
            access_level: field_access_level,
            warning: field_warning,
            access_details: field_access_details,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("warning", &self.warning)?;
        s.serialize_field("access_details", &self.access_details)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAccessLevelResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberAccessLevelResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAccessLevelResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberAccessLevelResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberAccessLevelResult", MEMBER_ACCESS_LEVEL_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAccessLevelResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberAccessLevelResult", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Actions that may be taken on members of a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MemberAction {
    /// Allow the member to keep a copy of the folder when removing.
    LeaveACopy,
    /// Make the member an editor of the folder.
    MakeEditor,
    /// Make the member an owner of the folder.
    MakeOwner,
    /// Make the member a viewer of the folder.
    MakeViewer,
    /// Make the member a viewer of the folder without commenting permissions.
    MakeViewerNoComment,
    /// Remove the member from the folder.
    Remove,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MemberAction {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberAction;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberAction structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "leave_a_copy" => MemberAction::LeaveACopy,
                    "make_editor" => MemberAction::MakeEditor,
                    "make_owner" => MemberAction::MakeOwner,
                    "make_viewer" => MemberAction::MakeViewer,
                    "make_viewer_no_comment" => MemberAction::MakeViewerNoComment,
                    "remove" => MemberAction::Remove,
                    _ => MemberAction::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["leave_a_copy",
                                    "make_editor",
                                    "make_owner",
                                    "make_viewer",
                                    "make_viewer_no_comment",
                                    "remove",
                                    "other"];
        deserializer.deserialize_struct("MemberAction", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberAction {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberAction::LeaveACopy => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "leave_a_copy")?;
                s.end()
            }
            MemberAction::MakeEditor => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "make_editor")?;
                s.end()
            }
            MemberAction::MakeOwner => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "make_owner")?;
                s.end()
            }
            MemberAction::MakeViewer => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "make_viewer")?;
                s.end()
            }
            MemberAction::MakeViewerNoComment => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "make_viewer_no_comment")?;
                s.end()
            }
            MemberAction::Remove => {
                // unit
                let mut s = serializer.serialize_struct("MemberAction", 1)?;
                s.serialize_field(".tag", "remove")?;
                s.end()
            }
            MemberAction::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Whether the user is allowed to take the action on the associated member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MemberPermission {
    /// The action that the user may wish to take on the member.
    pub action: MemberAction,
    /// True if the user is allowed to take the action.
    pub allow: bool,
    /// The reason why the user is denied the permission. Not present if the action is allowed.
    pub reason: Option<PermissionDeniedReason>,
}

impl MemberPermission {
    pub fn new(action: MemberAction, allow: bool) -> Self {
        MemberPermission {
            action,
            allow,
            reason: None,
        }
    }

    pub fn with_reason(mut self, value: PermissionDeniedReason) -> Self {
        self.reason = Some(value);
        self
    }
}

const MEMBER_PERMISSION_FIELDS: &[&str] = &["action",
                                            "allow",
                                            "reason"];
impl MemberPermission {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MemberPermission, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MemberPermission>, V::Error> {
        let mut field_action = None;
        let mut field_allow = None;
        let mut field_reason = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "action" => {
                    if field_action.is_some() {
                        return Err(::serde::de::Error::duplicate_field("action"));
                    }
                    field_action = Some(map.next_value()?);
                }
                "allow" => {
                    if field_allow.is_some() {
                        return Err(::serde::de::Error::duplicate_field("allow"));
                    }
                    field_allow = Some(map.next_value()?);
                }
                "reason" => {
                    if field_reason.is_some() {
                        return Err(::serde::de::Error::duplicate_field("reason"));
                    }
                    field_reason = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MemberPermission {
            action: field_action.ok_or_else(|| ::serde::de::Error::missing_field("action"))?,
            allow: field_allow.ok_or_else(|| ::serde::de::Error::missing_field("allow"))?,
            reason: field_reason,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("action", &self.action)?;
        s.serialize_field("allow", &self.allow)?;
        s.serialize_field("reason", &self.reason)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MemberPermission {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MemberPermission;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberPermission struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MemberPermission::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MemberPermission", MEMBER_PERMISSION_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MemberPermission {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MemberPermission", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Policy governing who can be a member of a shared folder. Only applicable to folders owned by a
/// user on a team.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MemberPolicy {
    /// Only a teammate can become a member.
    Team,
    /// Anyone can become a member.
    Anyone,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MemberPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "team" => MemberPolicy::Team,
                    "anyone" => MemberPolicy::Anyone,
                    _ => MemberPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["team",
                                    "anyone",
                                    "other"];
        deserializer.deserialize_struct("MemberPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberPolicy::Team => {
                // unit
                let mut s = serializer.serialize_struct("MemberPolicy", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            MemberPolicy::Anyone => {
                // unit
                let mut s = serializer.serialize_struct("MemberPolicy", 1)?;
                s.serialize_field(".tag", "anyone")?;
                s.end()
            }
            MemberPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Includes different ways to identify a member of a shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MemberSelector {
    /// Dropbox account, team member, or group ID of member.
    DropboxId(DropboxId),
    /// Email address of member.
    Email(super::common::EmailAddress),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MemberSelector {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MemberSelector;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MemberSelector structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "dropbox_id" => {
                        match map.next_key()? {
                            Some("dropbox_id") => MemberSelector::DropboxId(map.next_value()?),
                            None => return Err(de::Error::missing_field("dropbox_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "email" => {
                        match map.next_key()? {
                            Some("email") => MemberSelector::Email(map.next_value()?),
                            None => return Err(de::Error::missing_field("email")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => MemberSelector::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["dropbox_id",
                                    "email",
                                    "other"];
        deserializer.deserialize_struct("MemberSelector", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MemberSelector {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MemberSelector::DropboxId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberSelector", 2)?;
                s.serialize_field(".tag", "dropbox_id")?;
                s.serialize_field("dropbox_id", x)?;
                s.end()
            }
            MemberSelector::Email(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("MemberSelector", 2)?;
                s.serialize_field(".tag", "email")?;
                s.serialize_field("email", x)?;
                s.end()
            }
            MemberSelector::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The information about a member of the shared content.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MembershipInfo {
    /// The access type for this member. It contains inherited access type from parent folder, and
    /// acquired access type from this folder.
    pub access_type: AccessLevel,
    /// The permissions that requesting user has on this member. The set of permissions corresponds
    /// to the MemberActions in the request.
    pub permissions: Option<Vec<MemberPermission>>,
    /// Never set.
    pub initials: Option<String>,
    /// True if the member has access from a parent folder.
    pub is_inherited: bool,
}

impl MembershipInfo {
    pub fn new(access_type: AccessLevel) -> Self {
        MembershipInfo {
            access_type,
            permissions: None,
            initials: None,
            is_inherited: false,
        }
    }

    pub fn with_permissions(mut self, value: Vec<MemberPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_initials(mut self, value: String) -> Self {
        self.initials = Some(value);
        self
    }

    pub fn with_is_inherited(mut self, value: bool) -> Self {
        self.is_inherited = value;
        self
    }
}

const MEMBERSHIP_INFO_FIELDS: &[&str] = &["access_type",
                                          "permissions",
                                          "initials",
                                          "is_inherited"];
impl MembershipInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MembershipInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MembershipInfo>, V::Error> {
        let mut field_access_type = None;
        let mut field_permissions = None;
        let mut field_initials = None;
        let mut field_is_inherited = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "initials" => {
                    if field_initials.is_some() {
                        return Err(::serde::de::Error::duplicate_field("initials"));
                    }
                    field_initials = Some(map.next_value()?);
                }
                "is_inherited" => {
                    if field_is_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inherited"));
                    }
                    field_is_inherited = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MembershipInfo {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            permissions: field_permissions,
            initials: field_initials,
            is_inherited: field_is_inherited.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("initials", &self.initials)?;
        s.serialize_field("is_inherited", &self.is_inherited)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MembershipInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MembershipInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MembershipInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MembershipInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MembershipInfo", MEMBERSHIP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MembershipInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MembershipInfo", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ModifySharedLinkSettingsArgs {
    /// URL of the shared link to change its settings.
    pub url: String,
    /// Set of settings for the shared link.
    pub settings: SharedLinkSettings,
    /// If set to true, removes the expiration of the shared link.
    pub remove_expiration: bool,
}

impl ModifySharedLinkSettingsArgs {
    pub fn new(url: String, settings: SharedLinkSettings) -> Self {
        ModifySharedLinkSettingsArgs {
            url,
            settings,
            remove_expiration: false,
        }
    }

    pub fn with_remove_expiration(mut self, value: bool) -> Self {
        self.remove_expiration = value;
        self
    }
}

const MODIFY_SHARED_LINK_SETTINGS_ARGS_FIELDS: &[&str] = &["url",
                                                           "settings",
                                                           "remove_expiration"];
impl ModifySharedLinkSettingsArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ModifySharedLinkSettingsArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ModifySharedLinkSettingsArgs>, V::Error> {
        let mut field_url = None;
        let mut field_settings = None;
        let mut field_remove_expiration = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "settings" => {
                    if field_settings.is_some() {
                        return Err(::serde::de::Error::duplicate_field("settings"));
                    }
                    field_settings = Some(map.next_value()?);
                }
                "remove_expiration" => {
                    if field_remove_expiration.is_some() {
                        return Err(::serde::de::Error::duplicate_field("remove_expiration"));
                    }
                    field_remove_expiration = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ModifySharedLinkSettingsArgs {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            settings: field_settings.ok_or_else(|| ::serde::de::Error::missing_field("settings"))?,
            remove_expiration: field_remove_expiration.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("settings", &self.settings)?;
        s.serialize_field("remove_expiration", &self.remove_expiration)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ModifySharedLinkSettingsArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ModifySharedLinkSettingsArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ModifySharedLinkSettingsArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ModifySharedLinkSettingsArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ModifySharedLinkSettingsArgs", MODIFY_SHARED_LINK_SETTINGS_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ModifySharedLinkSettingsArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ModifySharedLinkSettingsArgs", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ModifySharedLinkSettingsError {
    /// The shared link wasn't found.
    SharedLinkNotFound,
    /// The caller is not allowed to access this shared link.
    SharedLinkAccessDenied,
    /// This type of link is not supported; use [`files::export()`](super::files::export) instead.
    UnsupportedLinkType,
    /// There is an error with the given settings.
    SettingsError(SharedLinkSettingsError),
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailNotVerified,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ModifySharedLinkSettingsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ModifySharedLinkSettingsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ModifySharedLinkSettingsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "shared_link_not_found" => ModifySharedLinkSettingsError::SharedLinkNotFound,
                    "shared_link_access_denied" => ModifySharedLinkSettingsError::SharedLinkAccessDenied,
                    "unsupported_link_type" => ModifySharedLinkSettingsError::UnsupportedLinkType,
                    "settings_error" => {
                        match map.next_key()? {
                            Some("settings_error") => ModifySharedLinkSettingsError::SettingsError(map.next_value()?),
                            None => return Err(de::Error::missing_field("settings_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "email_not_verified" => ModifySharedLinkSettingsError::EmailNotVerified,
                    _ => ModifySharedLinkSettingsError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["shared_link_not_found",
                                    "shared_link_access_denied",
                                    "unsupported_link_type",
                                    "other",
                                    "settings_error",
                                    "email_not_verified"];
        deserializer.deserialize_struct("ModifySharedLinkSettingsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ModifySharedLinkSettingsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ModifySharedLinkSettingsError::SharedLinkNotFound => {
                // unit
                let mut s = serializer.serialize_struct("ModifySharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "shared_link_not_found")?;
                s.end()
            }
            ModifySharedLinkSettingsError::SharedLinkAccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("ModifySharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "shared_link_access_denied")?;
                s.end()
            }
            ModifySharedLinkSettingsError::UnsupportedLinkType => {
                // unit
                let mut s = serializer.serialize_struct("ModifySharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "unsupported_link_type")?;
                s.end()
            }
            ModifySharedLinkSettingsError::SettingsError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ModifySharedLinkSettingsError", 2)?;
                s.serialize_field(".tag", "settings_error")?;
                s.serialize_field("settings_error", x)?;
                s.end()
            }
            ModifySharedLinkSettingsError::EmailNotVerified => {
                // unit
                let mut s = serializer.serialize_struct("ModifySharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "email_not_verified")?;
                s.end()
            }
            ModifySharedLinkSettingsError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ModifySharedLinkSettingsError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ModifySharedLinkSettingsError::SettingsError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ModifySharedLinkSettingsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ModifySharedLinkSettingsError::SharedLinkNotFound => f.write_str("The shared link wasn't found."),
            ModifySharedLinkSettingsError::SharedLinkAccessDenied => f.write_str("The caller is not allowed to access this shared link."),
            ModifySharedLinkSettingsError::SettingsError(inner) => write!(f, "There is an error with the given settings: {}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct MountFolderArg {
    /// The ID of the shared folder to mount.
    pub shared_folder_id: super::common::SharedFolderId,
}

impl MountFolderArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        MountFolderArg {
            shared_folder_id,
        }
    }
}

const MOUNT_FOLDER_ARG_FIELDS: &[&str] = &["shared_folder_id"];
impl MountFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<MountFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<MountFolderArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = MountFolderArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for MountFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = MountFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MountFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                MountFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("MountFolderArg", MOUNT_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for MountFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("MountFolderArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum MountFolderError {
    AccessError(SharedFolderAccessError),
    /// Mounting would cause a shared folder to be inside another, which is disallowed.
    InsideSharedFolder,
    /// The current user does not have enough space to mount the shared folder.
    InsufficientQuota(InsufficientQuotaAmounts),
    /// The shared folder is already mounted.
    AlreadyMounted,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// The shared folder is not mountable. One example where this can occur is when the shared
    /// folder belongs within a team folder in the user's Dropbox.
    NotMountable,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for MountFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = MountFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a MountFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => MountFolderError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "inside_shared_folder" => MountFolderError::InsideSharedFolder,
                    "insufficient_quota" => MountFolderError::InsufficientQuota(InsufficientQuotaAmounts::internal_deserialize(&mut map)?),
                    "already_mounted" => MountFolderError::AlreadyMounted,
                    "no_permission" => MountFolderError::NoPermission,
                    "not_mountable" => MountFolderError::NotMountable,
                    _ => MountFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "inside_shared_folder",
                                    "insufficient_quota",
                                    "already_mounted",
                                    "no_permission",
                                    "not_mountable",
                                    "other"];
        deserializer.deserialize_struct("MountFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for MountFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            MountFolderError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("MountFolderError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            MountFolderError::InsideSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("MountFolderError", 1)?;
                s.serialize_field(".tag", "inside_shared_folder")?;
                s.end()
            }
            MountFolderError::InsufficientQuota(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("MountFolderError", 4)?;
                s.serialize_field(".tag", "insufficient_quota")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            MountFolderError::AlreadyMounted => {
                // unit
                let mut s = serializer.serialize_struct("MountFolderError", 1)?;
                s.serialize_field(".tag", "already_mounted")?;
                s.end()
            }
            MountFolderError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("MountFolderError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            MountFolderError::NotMountable => {
                // unit
                let mut s = serializer.serialize_struct("MountFolderError", 1)?;
                s.serialize_field(".tag", "not_mountable")?;
                s.end()
            }
            MountFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for MountFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            MountFolderError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for MountFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            MountFolderError::AccessError(inner) => write!(f, "{}", inner),
            MountFolderError::InsideSharedFolder => f.write_str("Mounting would cause a shared folder to be inside another, which is disallowed."),
            MountFolderError::InsufficientQuota(inner) => write!(f, "The current user does not have enough space to mount the shared folder: {:?}", inner),
            MountFolderError::AlreadyMounted => f.write_str("The shared folder is already mounted."),
            MountFolderError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            MountFolderError::NotMountable => f.write_str("The shared folder is not mountable. One example where this can occur is when the shared folder belongs within a team folder in the user's Dropbox."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Contains information about a parent folder that a member has access to.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ParentFolderAccessInfo {
    /// Display name for the folder.
    pub folder_name: String,
    /// The identifier of the parent shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The user's permissions for the parent shared folder.
    pub permissions: Vec<MemberPermission>,
    /// The full path to the parent shared folder relative to the acting user's root.
    pub path: String,
}

impl ParentFolderAccessInfo {
    pub fn new(
        folder_name: String,
        shared_folder_id: super::common::SharedFolderId,
        permissions: Vec<MemberPermission>,
        path: String,
    ) -> Self {
        ParentFolderAccessInfo {
            folder_name,
            shared_folder_id,
            permissions,
            path,
        }
    }
}

const PARENT_FOLDER_ACCESS_INFO_FIELDS: &[&str] = &["folder_name",
                                                    "shared_folder_id",
                                                    "permissions",
                                                    "path"];
impl ParentFolderAccessInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ParentFolderAccessInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ParentFolderAccessInfo>, V::Error> {
        let mut field_folder_name = None;
        let mut field_shared_folder_id = None;
        let mut field_permissions = None;
        let mut field_path = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "folder_name" => {
                    if field_folder_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("folder_name"));
                    }
                    field_folder_name = Some(map.next_value()?);
                }
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ParentFolderAccessInfo {
            folder_name: field_folder_name.ok_or_else(|| ::serde::de::Error::missing_field("folder_name"))?,
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            permissions: field_permissions.ok_or_else(|| ::serde::de::Error::missing_field("permissions"))?,
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("folder_name", &self.folder_name)?;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("path", &self.path)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ParentFolderAccessInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ParentFolderAccessInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ParentFolderAccessInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ParentFolderAccessInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ParentFolderAccessInfo", PARENT_FOLDER_ACCESS_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ParentFolderAccessInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ParentFolderAccessInfo", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Metadata for a path-based shared link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct PathLinkMetadata {
    /// URL of the shared link.
    pub url: String,
    /// Who can access the link.
    pub visibility: Visibility,
    /// Path in user's Dropbox.
    pub path: String,
    /// Expiration time, if set. By default the link won't expire.
    pub expires: Option<super::common::DropboxTimestamp>,
}

impl PathLinkMetadata {
    pub fn new(url: String, visibility: Visibility, path: String) -> Self {
        PathLinkMetadata {
            url,
            visibility,
            path,
            expires: None,
        }
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }
}

const PATH_LINK_METADATA_FIELDS: &[&str] = &["url",
                                             "visibility",
                                             "path",
                                             "expires"];
impl PathLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<PathLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<PathLinkMetadata>, V::Error> {
        let mut field_url = None;
        let mut field_visibility = None;
        let mut field_path = None;
        let mut field_expires = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "visibility" => {
                    if field_visibility.is_some() {
                        return Err(::serde::de::Error::duplicate_field("visibility"));
                    }
                    field_visibility = Some(map.next_value()?);
                }
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = PathLinkMetadata {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            visibility: field_visibility.ok_or_else(|| ::serde::de::Error::missing_field("visibility"))?,
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            expires: field_expires,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("visibility", &self.visibility)?;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("expires", &self.expires)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for PathLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = PathLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PathLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                PathLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("PathLinkMetadata", PATH_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for PathLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("PathLinkMetadata", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Flag to indicate pending upload default (for linking to not-yet-existing paths).
#[derive(Debug, Clone, PartialEq)]
pub enum PendingUploadMode {
    /// Assume pending uploads are files.
    File,
    /// Assume pending uploads are folders.
    Folder,
}

impl<'de> ::serde::de::Deserialize<'de> for PendingUploadMode {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PendingUploadMode;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PendingUploadMode structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "file" => PendingUploadMode::File,
                    "folder" => PendingUploadMode::Folder,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["file",
                                    "folder"];
        deserializer.deserialize_struct("PendingUploadMode", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PendingUploadMode {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PendingUploadMode::File => {
                // unit
                let mut s = serializer.serialize_struct("PendingUploadMode", 1)?;
                s.serialize_field(".tag", "file")?;
                s.end()
            }
            PendingUploadMode::Folder => {
                // unit
                let mut s = serializer.serialize_struct("PendingUploadMode", 1)?;
                s.serialize_field(".tag", "folder")?;
                s.end()
            }
        }
    }
}

/// Possible reasons the user is denied a permission.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum PermissionDeniedReason {
    /// User is not on the same team as the folder owner.
    UserNotSameTeamAsOwner,
    /// User is prohibited by the owner from taking the action.
    UserNotAllowedByOwner,
    /// Target is indirectly a member of the folder, for example by being part of a group.
    TargetIsIndirectMember,
    /// Target is the owner of the folder.
    TargetIsOwner,
    /// Target is the user itself.
    TargetIsSelf,
    /// Target is not an active member of the team.
    TargetNotActive,
    /// Folder is team folder for a limited team.
    FolderIsLimitedTeamFolder,
    /// The content owner needs to be on a Dropbox team to perform this action.
    OwnerNotOnTeam,
    /// The user does not have permission to perform this action on the link.
    PermissionDenied,
    /// The user's team policy prevents performing this action on the link.
    RestrictedByTeam,
    /// The user's account type does not support this action.
    UserAccountType,
    /// The user needs to be on a Dropbox team to perform this action.
    UserNotOnTeam,
    /// Folder is inside of another shared folder.
    FolderIsInsideSharedFolder,
    /// Policy cannot be changed due to restrictions from parent folder.
    RestrictedByParentFolder,
    InsufficientPlan(InsufficientPlan),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for PermissionDeniedReason {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = PermissionDeniedReason;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a PermissionDeniedReason structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_not_same_team_as_owner" => PermissionDeniedReason::UserNotSameTeamAsOwner,
                    "user_not_allowed_by_owner" => PermissionDeniedReason::UserNotAllowedByOwner,
                    "target_is_indirect_member" => PermissionDeniedReason::TargetIsIndirectMember,
                    "target_is_owner" => PermissionDeniedReason::TargetIsOwner,
                    "target_is_self" => PermissionDeniedReason::TargetIsSelf,
                    "target_not_active" => PermissionDeniedReason::TargetNotActive,
                    "folder_is_limited_team_folder" => PermissionDeniedReason::FolderIsLimitedTeamFolder,
                    "owner_not_on_team" => PermissionDeniedReason::OwnerNotOnTeam,
                    "permission_denied" => PermissionDeniedReason::PermissionDenied,
                    "restricted_by_team" => PermissionDeniedReason::RestrictedByTeam,
                    "user_account_type" => PermissionDeniedReason::UserAccountType,
                    "user_not_on_team" => PermissionDeniedReason::UserNotOnTeam,
                    "folder_is_inside_shared_folder" => PermissionDeniedReason::FolderIsInsideSharedFolder,
                    "restricted_by_parent_folder" => PermissionDeniedReason::RestrictedByParentFolder,
                    "insufficient_plan" => PermissionDeniedReason::InsufficientPlan(InsufficientPlan::internal_deserialize(&mut map)?),
                    _ => PermissionDeniedReason::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_not_same_team_as_owner",
                                    "user_not_allowed_by_owner",
                                    "target_is_indirect_member",
                                    "target_is_owner",
                                    "target_is_self",
                                    "target_not_active",
                                    "folder_is_limited_team_folder",
                                    "owner_not_on_team",
                                    "permission_denied",
                                    "restricted_by_team",
                                    "user_account_type",
                                    "user_not_on_team",
                                    "folder_is_inside_shared_folder",
                                    "restricted_by_parent_folder",
                                    "insufficient_plan",
                                    "other"];
        deserializer.deserialize_struct("PermissionDeniedReason", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for PermissionDeniedReason {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            PermissionDeniedReason::UserNotSameTeamAsOwner => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "user_not_same_team_as_owner")?;
                s.end()
            }
            PermissionDeniedReason::UserNotAllowedByOwner => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "user_not_allowed_by_owner")?;
                s.end()
            }
            PermissionDeniedReason::TargetIsIndirectMember => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "target_is_indirect_member")?;
                s.end()
            }
            PermissionDeniedReason::TargetIsOwner => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "target_is_owner")?;
                s.end()
            }
            PermissionDeniedReason::TargetIsSelf => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "target_is_self")?;
                s.end()
            }
            PermissionDeniedReason::TargetNotActive => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "target_not_active")?;
                s.end()
            }
            PermissionDeniedReason::FolderIsLimitedTeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "folder_is_limited_team_folder")?;
                s.end()
            }
            PermissionDeniedReason::OwnerNotOnTeam => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "owner_not_on_team")?;
                s.end()
            }
            PermissionDeniedReason::PermissionDenied => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "permission_denied")?;
                s.end()
            }
            PermissionDeniedReason::RestrictedByTeam => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "restricted_by_team")?;
                s.end()
            }
            PermissionDeniedReason::UserAccountType => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "user_account_type")?;
                s.end()
            }
            PermissionDeniedReason::UserNotOnTeam => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "user_not_on_team")?;
                s.end()
            }
            PermissionDeniedReason::FolderIsInsideSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "folder_is_inside_shared_folder")?;
                s.end()
            }
            PermissionDeniedReason::RestrictedByParentFolder => {
                // unit
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 1)?;
                s.serialize_field(".tag", "restricted_by_parent_folder")?;
                s.end()
            }
            PermissionDeniedReason::InsufficientPlan(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("PermissionDeniedReason", 3)?;
                s.serialize_field(".tag", "insufficient_plan")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            PermissionDeniedReason::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelinquishFileMembershipArg {
    /// The path or id for the file.
    pub file: PathOrId,
}

impl RelinquishFileMembershipArg {
    pub fn new(file: PathOrId) -> Self {
        RelinquishFileMembershipArg {
            file,
        }
    }
}

const RELINQUISH_FILE_MEMBERSHIP_ARG_FIELDS: &[&str] = &["file"];
impl RelinquishFileMembershipArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelinquishFileMembershipArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelinquishFileMembershipArg>, V::Error> {
        let mut field_file = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelinquishFileMembershipArg {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelinquishFileMembershipArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelinquishFileMembershipArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelinquishFileMembershipArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelinquishFileMembershipArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelinquishFileMembershipArg", RELINQUISH_FILE_MEMBERSHIP_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelinquishFileMembershipArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelinquishFileMembershipArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelinquishFileMembershipError {
    AccessError(SharingFileAccessError),
    /// The current user has access to the shared file via a group.  You can't relinquish membership
    /// to a file shared via groups.
    GroupAccess,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelinquishFileMembershipError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelinquishFileMembershipError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelinquishFileMembershipError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => RelinquishFileMembershipError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "group_access" => RelinquishFileMembershipError::GroupAccess,
                    "no_permission" => RelinquishFileMembershipError::NoPermission,
                    _ => RelinquishFileMembershipError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "group_access",
                                    "no_permission",
                                    "other"];
        deserializer.deserialize_struct("RelinquishFileMembershipError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelinquishFileMembershipError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelinquishFileMembershipError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelinquishFileMembershipError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            RelinquishFileMembershipError::GroupAccess => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFileMembershipError", 1)?;
                s.serialize_field(".tag", "group_access")?;
                s.end()
            }
            RelinquishFileMembershipError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFileMembershipError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            RelinquishFileMembershipError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RelinquishFileMembershipError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RelinquishFileMembershipError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RelinquishFileMembershipError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RelinquishFileMembershipError::AccessError(inner) => write!(f, "{}", inner),
            RelinquishFileMembershipError::GroupAccess => f.write_str("The current user has access to the shared file via a group.  You can't relinquish membership to a file shared via groups."),
            RelinquishFileMembershipError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RelinquishFolderMembershipArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// Keep a copy of the folder's contents upon relinquishing membership.
    pub leave_a_copy: bool,
}

impl RelinquishFolderMembershipArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        RelinquishFolderMembershipArg {
            shared_folder_id,
            leave_a_copy: false,
        }
    }

    pub fn with_leave_a_copy(mut self, value: bool) -> Self {
        self.leave_a_copy = value;
        self
    }
}

const RELINQUISH_FOLDER_MEMBERSHIP_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                           "leave_a_copy"];
impl RelinquishFolderMembershipArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RelinquishFolderMembershipArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RelinquishFolderMembershipArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_leave_a_copy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "leave_a_copy" => {
                    if field_leave_a_copy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("leave_a_copy"));
                    }
                    field_leave_a_copy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RelinquishFolderMembershipArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            leave_a_copy: field_leave_a_copy.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("leave_a_copy", &self.leave_a_copy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RelinquishFolderMembershipArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RelinquishFolderMembershipArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelinquishFolderMembershipArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RelinquishFolderMembershipArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RelinquishFolderMembershipArg", RELINQUISH_FOLDER_MEMBERSHIP_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RelinquishFolderMembershipArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RelinquishFolderMembershipArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RelinquishFolderMembershipError {
    AccessError(SharedFolderAccessError),
    /// The current user is the owner of the shared folder. Owners cannot relinquish membership to
    /// their own folders. Try unsharing or transferring ownership first.
    FolderOwner,
    /// The shared folder is currently mounted.  Unmount the shared folder before relinquishing
    /// membership.
    Mounted,
    /// The current user has access to the shared folder via a group.  You can't relinquish
    /// membership to folders shared via groups.
    GroupAccess,
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// The current user only has inherited access to the shared folder.  You can't relinquish
    /// inherited membership to folders.
    NoExplicitAccess,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RelinquishFolderMembershipError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RelinquishFolderMembershipError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RelinquishFolderMembershipError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => RelinquishFolderMembershipError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "folder_owner" => RelinquishFolderMembershipError::FolderOwner,
                    "mounted" => RelinquishFolderMembershipError::Mounted,
                    "group_access" => RelinquishFolderMembershipError::GroupAccess,
                    "team_folder" => RelinquishFolderMembershipError::TeamFolder,
                    "no_permission" => RelinquishFolderMembershipError::NoPermission,
                    "no_explicit_access" => RelinquishFolderMembershipError::NoExplicitAccess,
                    _ => RelinquishFolderMembershipError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "folder_owner",
                                    "mounted",
                                    "group_access",
                                    "team_folder",
                                    "no_permission",
                                    "no_explicit_access",
                                    "other"];
        deserializer.deserialize_struct("RelinquishFolderMembershipError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RelinquishFolderMembershipError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RelinquishFolderMembershipError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            RelinquishFolderMembershipError::FolderOwner => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "folder_owner")?;
                s.end()
            }
            RelinquishFolderMembershipError::Mounted => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "mounted")?;
                s.end()
            }
            RelinquishFolderMembershipError::GroupAccess => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "group_access")?;
                s.end()
            }
            RelinquishFolderMembershipError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            RelinquishFolderMembershipError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            RelinquishFolderMembershipError::NoExplicitAccess => {
                // unit
                let mut s = serializer.serialize_struct("RelinquishFolderMembershipError", 1)?;
                s.serialize_field(".tag", "no_explicit_access")?;
                s.end()
            }
            RelinquishFolderMembershipError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RelinquishFolderMembershipError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RelinquishFolderMembershipError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RelinquishFolderMembershipError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RelinquishFolderMembershipError::AccessError(inner) => write!(f, "{}", inner),
            RelinquishFolderMembershipError::FolderOwner => f.write_str("The current user is the owner of the shared folder. Owners cannot relinquish membership to their own folders. Try unsharing or transferring ownership first."),
            RelinquishFolderMembershipError::Mounted => f.write_str("The shared folder is currently mounted.  Unmount the shared folder before relinquishing membership."),
            RelinquishFolderMembershipError::GroupAccess => f.write_str("The current user has access to the shared folder via a group.  You can't relinquish membership to folders shared via groups."),
            RelinquishFolderMembershipError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            RelinquishFolderMembershipError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            RelinquishFolderMembershipError::NoExplicitAccess => f.write_str("The current user only has inherited access to the shared folder.  You can't relinquish inherited membership to folders."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Arguments for [`remove_file_member_2()`](remove_file_member_2).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RemoveFileMemberArg {
    /// File from which to remove members.
    pub file: PathOrId,
    /// Member to remove from this file. Note that even if an email is specified, it may result in
    /// the removal of a user (not an invitee) if the user's main account corresponds to that email
    /// address.
    pub member: MemberSelector,
}

impl RemoveFileMemberArg {
    pub fn new(file: PathOrId, member: MemberSelector) -> Self {
        RemoveFileMemberArg {
            file,
            member,
        }
    }
}

const REMOVE_FILE_MEMBER_ARG_FIELDS: &[&str] = &["file",
                                                 "member"];
impl RemoveFileMemberArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RemoveFileMemberArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RemoveFileMemberArg>, V::Error> {
        let mut field_file = None;
        let mut field_member = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RemoveFileMemberArg {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("member", &self.member)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveFileMemberArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RemoveFileMemberArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveFileMemberArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RemoveFileMemberArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RemoveFileMemberArg", REMOVE_FILE_MEMBER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveFileMemberArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RemoveFileMemberArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Errors for [`remove_file_member_2()`](remove_file_member_2).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RemoveFileMemberError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// This member does not have explicit access to the file and therefore cannot be removed. The
    /// return value is the access that a user might have to the file from a parent folder.
    NoExplicitAccess(MemberAccessLevelResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveFileMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RemoveFileMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveFileMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => RemoveFileMemberError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => RemoveFileMemberError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_explicit_access" => RemoveFileMemberError::NoExplicitAccess(MemberAccessLevelResult::internal_deserialize(&mut map)?),
                    _ => RemoveFileMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "no_explicit_access",
                                    "other"];
        deserializer.deserialize_struct("RemoveFileMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveFileMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RemoveFileMemberError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveFileMemberError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            RemoveFileMemberError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveFileMemberError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            RemoveFileMemberError::NoExplicitAccess(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RemoveFileMemberError", 4)?;
                s.serialize_field(".tag", "no_explicit_access")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RemoveFileMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RemoveFileMemberError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RemoveFileMemberError::UserError(inner) => Some(inner),
            RemoveFileMemberError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RemoveFileMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RemoveFileMemberError::UserError(inner) => write!(f, "{}", inner),
            RemoveFileMemberError::AccessError(inner) => write!(f, "{}", inner),
            RemoveFileMemberError::NoExplicitAccess(inner) => write!(f, "This member does not have explicit access to the file and therefore cannot be removed. The return value is the access that a user might have to the file from a parent folder: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RemoveFolderMemberArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The member to remove from the folder.
    pub member: MemberSelector,
    /// If true, the removed user will keep their copy of the folder after it's unshared, assuming
    /// it was mounted. Otherwise, it will be removed from their Dropbox. Also, this must be set to
    /// false when kicking a group.
    pub leave_a_copy: bool,
}

impl RemoveFolderMemberArg {
    pub fn new(
        shared_folder_id: super::common::SharedFolderId,
        member: MemberSelector,
        leave_a_copy: bool,
    ) -> Self {
        RemoveFolderMemberArg {
            shared_folder_id,
            member,
            leave_a_copy,
        }
    }
}

const REMOVE_FOLDER_MEMBER_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                   "member",
                                                   "leave_a_copy"];
impl RemoveFolderMemberArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RemoveFolderMemberArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RemoveFolderMemberArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_member = None;
        let mut field_leave_a_copy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "leave_a_copy" => {
                    if field_leave_a_copy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("leave_a_copy"));
                    }
                    field_leave_a_copy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RemoveFolderMemberArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            leave_a_copy: field_leave_a_copy.ok_or_else(|| ::serde::de::Error::missing_field("leave_a_copy"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("leave_a_copy", &self.leave_a_copy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveFolderMemberArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RemoveFolderMemberArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveFolderMemberArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RemoveFolderMemberArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RemoveFolderMemberArg", REMOVE_FOLDER_MEMBER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveFolderMemberArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RemoveFolderMemberArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RemoveFolderMemberError {
    AccessError(SharedFolderAccessError),
    MemberError(SharedFolderMemberError),
    /// The target user is the owner of the shared folder. You can't remove this user until
    /// ownership has been transferred to another member.
    FolderOwner,
    /// The target user has access to the shared folder via a group.
    GroupAccess,
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// This shared folder has too many files for leaving a copy. You can still remove this user
    /// without leaving a copy.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveFolderMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RemoveFolderMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveFolderMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => RemoveFolderMemberError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "member_error" => {
                        match map.next_key()? {
                            Some("member_error") => RemoveFolderMemberError::MemberError(map.next_value()?),
                            None => return Err(de::Error::missing_field("member_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "folder_owner" => RemoveFolderMemberError::FolderOwner,
                    "group_access" => RemoveFolderMemberError::GroupAccess,
                    "team_folder" => RemoveFolderMemberError::TeamFolder,
                    "no_permission" => RemoveFolderMemberError::NoPermission,
                    "too_many_files" => RemoveFolderMemberError::TooManyFiles,
                    _ => RemoveFolderMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "member_error",
                                    "folder_owner",
                                    "group_access",
                                    "team_folder",
                                    "no_permission",
                                    "too_many_files",
                                    "other"];
        deserializer.deserialize_struct("RemoveFolderMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveFolderMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RemoveFolderMemberError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            RemoveFolderMemberError::MemberError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 2)?;
                s.serialize_field(".tag", "member_error")?;
                s.serialize_field("member_error", x)?;
                s.end()
            }
            RemoveFolderMemberError::FolderOwner => {
                // unit
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 1)?;
                s.serialize_field(".tag", "folder_owner")?;
                s.end()
            }
            RemoveFolderMemberError::GroupAccess => {
                // unit
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 1)?;
                s.serialize_field(".tag", "group_access")?;
                s.end()
            }
            RemoveFolderMemberError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            RemoveFolderMemberError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            RemoveFolderMemberError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("RemoveFolderMemberError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            RemoveFolderMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RemoveFolderMemberError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            RemoveFolderMemberError::AccessError(inner) => Some(inner),
            RemoveFolderMemberError::MemberError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for RemoveFolderMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RemoveFolderMemberError::AccessError(inner) => write!(f, "{}", inner),
            RemoveFolderMemberError::MemberError(inner) => write!(f, "{}", inner),
            RemoveFolderMemberError::FolderOwner => f.write_str("The target user is the owner of the shared folder. You can't remove this user until ownership has been transferred to another member."),
            RemoveFolderMemberError::GroupAccess => f.write_str("The target user has access to the shared folder via a group."),
            RemoveFolderMemberError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            RemoveFolderMemberError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            RemoveFolderMemberError::TooManyFiles => f.write_str("This shared folder has too many files for leaving a copy. You can still remove this user without leaving a copy."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum RemoveMemberJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// Removing the folder member has finished. The value is information about whether the member
    /// has another form of access.
    Complete(MemberAccessLevelResult),
    Failed(RemoveFolderMemberError),
}

impl<'de> ::serde::de::Deserialize<'de> for RemoveMemberJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RemoveMemberJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RemoveMemberJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => RemoveMemberJobStatus::InProgress,
                    "complete" => RemoveMemberJobStatus::Complete(MemberAccessLevelResult::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => RemoveMemberJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("RemoveMemberJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RemoveMemberJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RemoveMemberJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("RemoveMemberJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            RemoveMemberJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("RemoveMemberJobStatus", 4)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            RemoveMemberJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("RemoveMemberJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RequestedLinkAccessLevel {
    /// Users who use the link can view and comment on the content.
    Viewer,
    /// Users who use the link can edit, view and comment on the content. Note not all file types
    /// support edit links yet.
    Editor,
    /// Request for the maximum access level you can set the link to.
    Max,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RequestedLinkAccessLevel {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RequestedLinkAccessLevel;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RequestedLinkAccessLevel structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "viewer" => RequestedLinkAccessLevel::Viewer,
                    "editor" => RequestedLinkAccessLevel::Editor,
                    "max" => RequestedLinkAccessLevel::Max,
                    _ => RequestedLinkAccessLevel::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["viewer",
                                    "editor",
                                    "max",
                                    "other"];
        deserializer.deserialize_struct("RequestedLinkAccessLevel", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RequestedLinkAccessLevel {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RequestedLinkAccessLevel::Viewer => {
                // unit
                let mut s = serializer.serialize_struct("RequestedLinkAccessLevel", 1)?;
                s.serialize_field(".tag", "viewer")?;
                s.end()
            }
            RequestedLinkAccessLevel::Editor => {
                // unit
                let mut s = serializer.serialize_struct("RequestedLinkAccessLevel", 1)?;
                s.serialize_field(".tag", "editor")?;
                s.end()
            }
            RequestedLinkAccessLevel::Max => {
                // unit
                let mut s = serializer.serialize_struct("RequestedLinkAccessLevel", 1)?;
                s.serialize_field(".tag", "max")?;
                s.end()
            }
            RequestedLinkAccessLevel::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// The access permission that can be requested by the caller for the shared link. Note that the
/// final resolved visibility of the shared link takes into account other aspects, such as team and
/// shared folder settings. Check the [`ResolvedVisibility`](ResolvedVisibility) for more info on
/// the possible resolved visibility values of shared links.
#[derive(Debug, Clone, PartialEq)]
pub enum RequestedVisibility {
    /// Anyone who has received the link can access it. No login required.
    Public,
    /// Only members of the same team can access the link. Login is required.
    TeamOnly,
    /// A link-specific password is required to access the link. Login is not required.
    Password,
}

impl<'de> ::serde::de::Deserialize<'de> for RequestedVisibility {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RequestedVisibility;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RequestedVisibility structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "public" => RequestedVisibility::Public,
                    "team_only" => RequestedVisibility::TeamOnly,
                    "password" => RequestedVisibility::Password,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["public",
                                    "team_only",
                                    "password"];
        deserializer.deserialize_struct("RequestedVisibility", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RequestedVisibility {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RequestedVisibility::Public => {
                // unit
                let mut s = serializer.serialize_struct("RequestedVisibility", 1)?;
                s.serialize_field(".tag", "public")?;
                s.end()
            }
            RequestedVisibility::TeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("RequestedVisibility", 1)?;
                s.serialize_field(".tag", "team_only")?;
                s.end()
            }
            RequestedVisibility::Password => {
                // unit
                let mut s = serializer.serialize_struct("RequestedVisibility", 1)?;
                s.serialize_field(".tag", "password")?;
                s.end()
            }
        }
    }
}

/// The actual access permissions values of shared links after taking into account user preferences
/// and the team and shared folder settings. Check the [`RequestedVisibility`](RequestedVisibility)
/// for more info on the possible visibility values that can be set by the shared link's owner.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ResolvedVisibility {
    /// Anyone who has received the link can access it. No login required.
    Public,
    /// Only members of the same team can access the link. Login is required.
    TeamOnly,
    /// A link-specific password is required to access the link. Login is not required.
    Password,
    /// Only members of the same team who have the link-specific password can access the link. Login
    /// is required.
    TeamAndPassword,
    /// Only members of the shared folder containing the linked file can access the link. Login is
    /// required.
    SharedFolderOnly,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ResolvedVisibility {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ResolvedVisibility;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ResolvedVisibility structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "public" => ResolvedVisibility::Public,
                    "team_only" => ResolvedVisibility::TeamOnly,
                    "password" => ResolvedVisibility::Password,
                    "team_and_password" => ResolvedVisibility::TeamAndPassword,
                    "shared_folder_only" => ResolvedVisibility::SharedFolderOnly,
                    _ => ResolvedVisibility::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["public",
                                    "team_only",
                                    "password",
                                    "team_and_password",
                                    "shared_folder_only",
                                    "other"];
        deserializer.deserialize_struct("ResolvedVisibility", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ResolvedVisibility {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ResolvedVisibility::Public => {
                // unit
                let mut s = serializer.serialize_struct("ResolvedVisibility", 1)?;
                s.serialize_field(".tag", "public")?;
                s.end()
            }
            ResolvedVisibility::TeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("ResolvedVisibility", 1)?;
                s.serialize_field(".tag", "team_only")?;
                s.end()
            }
            ResolvedVisibility::Password => {
                // unit
                let mut s = serializer.serialize_struct("ResolvedVisibility", 1)?;
                s.serialize_field(".tag", "password")?;
                s.end()
            }
            ResolvedVisibility::TeamAndPassword => {
                // unit
                let mut s = serializer.serialize_struct("ResolvedVisibility", 1)?;
                s.serialize_field(".tag", "team_and_password")?;
                s.end()
            }
            ResolvedVisibility::SharedFolderOnly => {
                // unit
                let mut s = serializer.serialize_struct("ResolvedVisibility", 1)?;
                s.serialize_field(".tag", "shared_folder_only")?;
                s.end()
            }
            ResolvedVisibility::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct RevokeSharedLinkArg {
    /// URL of the shared link.
    pub url: String,
}

impl RevokeSharedLinkArg {
    pub fn new(url: String) -> Self {
        RevokeSharedLinkArg {
            url,
        }
    }
}

const REVOKE_SHARED_LINK_ARG_FIELDS: &[&str] = &["url"];
impl RevokeSharedLinkArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<RevokeSharedLinkArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<RevokeSharedLinkArg>, V::Error> {
        let mut field_url = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = RevokeSharedLinkArg {
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("url", &self.url)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeSharedLinkArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = RevokeSharedLinkArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeSharedLinkArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                RevokeSharedLinkArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("RevokeSharedLinkArg", REVOKE_SHARED_LINK_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeSharedLinkArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("RevokeSharedLinkArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum RevokeSharedLinkError {
    /// The shared link wasn't found.
    SharedLinkNotFound,
    /// The caller is not allowed to access this shared link.
    SharedLinkAccessDenied,
    /// This type of link is not supported; use [`files::export()`](super::files::export) instead.
    UnsupportedLinkType,
    /// Shared link is malformed.
    SharedLinkMalformed,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for RevokeSharedLinkError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = RevokeSharedLinkError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a RevokeSharedLinkError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "shared_link_not_found" => RevokeSharedLinkError::SharedLinkNotFound,
                    "shared_link_access_denied" => RevokeSharedLinkError::SharedLinkAccessDenied,
                    "unsupported_link_type" => RevokeSharedLinkError::UnsupportedLinkType,
                    "shared_link_malformed" => RevokeSharedLinkError::SharedLinkMalformed,
                    _ => RevokeSharedLinkError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["shared_link_not_found",
                                    "shared_link_access_denied",
                                    "unsupported_link_type",
                                    "other",
                                    "shared_link_malformed"];
        deserializer.deserialize_struct("RevokeSharedLinkError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for RevokeSharedLinkError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            RevokeSharedLinkError::SharedLinkNotFound => {
                // unit
                let mut s = serializer.serialize_struct("RevokeSharedLinkError", 1)?;
                s.serialize_field(".tag", "shared_link_not_found")?;
                s.end()
            }
            RevokeSharedLinkError::SharedLinkAccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("RevokeSharedLinkError", 1)?;
                s.serialize_field(".tag", "shared_link_access_denied")?;
                s.end()
            }
            RevokeSharedLinkError::UnsupportedLinkType => {
                // unit
                let mut s = serializer.serialize_struct("RevokeSharedLinkError", 1)?;
                s.serialize_field(".tag", "unsupported_link_type")?;
                s.end()
            }
            RevokeSharedLinkError::SharedLinkMalformed => {
                // unit
                let mut s = serializer.serialize_struct("RevokeSharedLinkError", 1)?;
                s.serialize_field(".tag", "shared_link_malformed")?;
                s.end()
            }
            RevokeSharedLinkError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for RevokeSharedLinkError {
}

impl ::std::fmt::Display for RevokeSharedLinkError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            RevokeSharedLinkError::SharedLinkNotFound => f.write_str("The shared link wasn't found."),
            RevokeSharedLinkError::SharedLinkAccessDenied => f.write_str("The caller is not allowed to access this shared link."),
            RevokeSharedLinkError::SharedLinkMalformed => f.write_str("Shared link is malformed."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SetAccessInheritanceArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The access inheritance settings for the folder.
    pub access_inheritance: AccessInheritance,
}

impl SetAccessInheritanceArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        SetAccessInheritanceArg {
            shared_folder_id,
            access_inheritance: AccessInheritance::Inherit,
        }
    }

    pub fn with_access_inheritance(mut self, value: AccessInheritance) -> Self {
        self.access_inheritance = value;
        self
    }
}

const SET_ACCESS_INHERITANCE_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                     "access_inheritance"];
impl SetAccessInheritanceArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SetAccessInheritanceArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SetAccessInheritanceArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_access_inheritance = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "access_inheritance" => {
                    if field_access_inheritance.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_inheritance"));
                    }
                    field_access_inheritance = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SetAccessInheritanceArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            access_inheritance: field_access_inheritance.unwrap_or(AccessInheritance::Inherit),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("access_inheritance", &self.access_inheritance)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SetAccessInheritanceArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SetAccessInheritanceArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SetAccessInheritanceArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SetAccessInheritanceArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SetAccessInheritanceArg", SET_ACCESS_INHERITANCE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SetAccessInheritanceArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SetAccessInheritanceArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SetAccessInheritanceError {
    /// Unable to access shared folder.
    AccessError(SharedFolderAccessError),
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SetAccessInheritanceError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SetAccessInheritanceError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SetAccessInheritanceError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => SetAccessInheritanceError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_permission" => SetAccessInheritanceError::NoPermission,
                    _ => SetAccessInheritanceError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "no_permission",
                                    "other"];
        deserializer.deserialize_struct("SetAccessInheritanceError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SetAccessInheritanceError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SetAccessInheritanceError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SetAccessInheritanceError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            SetAccessInheritanceError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("SetAccessInheritanceError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            SetAccessInheritanceError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SetAccessInheritanceError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            SetAccessInheritanceError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for SetAccessInheritanceError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SetAccessInheritanceError::AccessError(inner) => write!(f, "Unable to access shared folder: {}", inner),
            SetAccessInheritanceError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ShareFolderArg {
    /// The path to the folder to share. If it does not exist, then a new one is created.
    pub path: super::files::WritePath,
    /// Who can add and remove members of this shared folder.
    pub acl_update_policy: Option<AclUpdatePolicy>,
    /// Whether to force the share to happen asynchronously.
    pub force_async: bool,
    /// Who can be a member of this shared folder. Only applicable if the current user is on a team.
    pub member_policy: Option<MemberPolicy>,
    /// The policy to apply to shared links created for content inside this shared folder.  The
    /// current user must be on a team to set this policy to
    /// [`SharedLinkPolicy::Members`](SharedLinkPolicy::Members).
    pub shared_link_policy: Option<SharedLinkPolicy>,
    /// Who can enable/disable viewer info for this shared folder.
    pub viewer_info_policy: Option<ViewerInfoPolicy>,
    /// The access inheritance settings for the folder.
    pub access_inheritance: AccessInheritance,
    /// A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the
    /// response's [`SharedFolderMetadata::permissions`](SharedFolderMetadata) field describing the
    /// actions the  authenticated user can perform on the folder.
    pub actions: Option<Vec<FolderAction>>,
    /// Settings on the link for this folder.
    pub link_settings: Option<LinkSettings>,
}

impl ShareFolderArg {
    pub fn new(path: super::files::WritePath) -> Self {
        ShareFolderArg {
            path,
            acl_update_policy: None,
            force_async: false,
            member_policy: None,
            shared_link_policy: None,
            viewer_info_policy: None,
            access_inheritance: AccessInheritance::Inherit,
            actions: None,
            link_settings: None,
        }
    }

    pub fn with_acl_update_policy(mut self, value: AclUpdatePolicy) -> Self {
        self.acl_update_policy = Some(value);
        self
    }

    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }

    pub fn with_member_policy(mut self, value: MemberPolicy) -> Self {
        self.member_policy = Some(value);
        self
    }

    pub fn with_shared_link_policy(mut self, value: SharedLinkPolicy) -> Self {
        self.shared_link_policy = Some(value);
        self
    }

    pub fn with_viewer_info_policy(mut self, value: ViewerInfoPolicy) -> Self {
        self.viewer_info_policy = Some(value);
        self
    }

    pub fn with_access_inheritance(mut self, value: AccessInheritance) -> Self {
        self.access_inheritance = value;
        self
    }

    pub fn with_actions(mut self, value: Vec<FolderAction>) -> Self {
        self.actions = Some(value);
        self
    }

    pub fn with_link_settings(mut self, value: LinkSettings) -> Self {
        self.link_settings = Some(value);
        self
    }
}

const SHARE_FOLDER_ARG_FIELDS: &[&str] = &["path",
                                           "acl_update_policy",
                                           "force_async",
                                           "member_policy",
                                           "shared_link_policy",
                                           "viewer_info_policy",
                                           "access_inheritance",
                                           "actions",
                                           "link_settings"];
impl ShareFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ShareFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ShareFolderArg>, V::Error> {
        let mut field_path = None;
        let mut field_acl_update_policy = None;
        let mut field_force_async = None;
        let mut field_member_policy = None;
        let mut field_shared_link_policy = None;
        let mut field_viewer_info_policy = None;
        let mut field_access_inheritance = None;
        let mut field_actions = None;
        let mut field_link_settings = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "acl_update_policy" => {
                    if field_acl_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("acl_update_policy"));
                    }
                    field_acl_update_policy = Some(map.next_value()?);
                }
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                "member_policy" => {
                    if field_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_policy"));
                    }
                    field_member_policy = Some(map.next_value()?);
                }
                "shared_link_policy" => {
                    if field_shared_link_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link_policy"));
                    }
                    field_shared_link_policy = Some(map.next_value()?);
                }
                "viewer_info_policy" => {
                    if field_viewer_info_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("viewer_info_policy"));
                    }
                    field_viewer_info_policy = Some(map.next_value()?);
                }
                "access_inheritance" => {
                    if field_access_inheritance.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_inheritance"));
                    }
                    field_access_inheritance = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                "link_settings" => {
                    if field_link_settings.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_settings"));
                    }
                    field_link_settings = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ShareFolderArg {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            acl_update_policy: field_acl_update_policy,
            force_async: field_force_async.unwrap_or(false),
            member_policy: field_member_policy,
            shared_link_policy: field_shared_link_policy,
            viewer_info_policy: field_viewer_info_policy,
            access_inheritance: field_access_inheritance.unwrap_or(AccessInheritance::Inherit),
            actions: field_actions,
            link_settings: field_link_settings,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("acl_update_policy", &self.acl_update_policy)?;
        s.serialize_field("force_async", &self.force_async)?;
        s.serialize_field("member_policy", &self.member_policy)?;
        s.serialize_field("shared_link_policy", &self.shared_link_policy)?;
        s.serialize_field("viewer_info_policy", &self.viewer_info_policy)?;
        s.serialize_field("access_inheritance", &self.access_inheritance)?;
        s.serialize_field("actions", &self.actions)?;
        s.serialize_field("link_settings", &self.link_settings)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ShareFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ShareFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ShareFolderArg", SHARE_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ShareFolderArg", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct ShareFolderArgBase {
    /// The path to the folder to share. If it does not exist, then a new one is created.
    pub path: super::files::WritePath,
    /// Who can add and remove members of this shared folder.
    pub acl_update_policy: Option<AclUpdatePolicy>,
    /// Whether to force the share to happen asynchronously.
    pub force_async: bool,
    /// Who can be a member of this shared folder. Only applicable if the current user is on a team.
    pub member_policy: Option<MemberPolicy>,
    /// The policy to apply to shared links created for content inside this shared folder.  The
    /// current user must be on a team to set this policy to
    /// [`SharedLinkPolicy::Members`](SharedLinkPolicy::Members).
    pub shared_link_policy: Option<SharedLinkPolicy>,
    /// Who can enable/disable viewer info for this shared folder.
    pub viewer_info_policy: Option<ViewerInfoPolicy>,
    /// The access inheritance settings for the folder.
    pub access_inheritance: AccessInheritance,
}

impl ShareFolderArgBase {
    pub fn new(path: super::files::WritePath) -> Self {
        ShareFolderArgBase {
            path,
            acl_update_policy: None,
            force_async: false,
            member_policy: None,
            shared_link_policy: None,
            viewer_info_policy: None,
            access_inheritance: AccessInheritance::Inherit,
        }
    }

    pub fn with_acl_update_policy(mut self, value: AclUpdatePolicy) -> Self {
        self.acl_update_policy = Some(value);
        self
    }

    pub fn with_force_async(mut self, value: bool) -> Self {
        self.force_async = value;
        self
    }

    pub fn with_member_policy(mut self, value: MemberPolicy) -> Self {
        self.member_policy = Some(value);
        self
    }

    pub fn with_shared_link_policy(mut self, value: SharedLinkPolicy) -> Self {
        self.shared_link_policy = Some(value);
        self
    }

    pub fn with_viewer_info_policy(mut self, value: ViewerInfoPolicy) -> Self {
        self.viewer_info_policy = Some(value);
        self
    }

    pub fn with_access_inheritance(mut self, value: AccessInheritance) -> Self {
        self.access_inheritance = value;
        self
    }
}

const SHARE_FOLDER_ARG_BASE_FIELDS: &[&str] = &["path",
                                                "acl_update_policy",
                                                "force_async",
                                                "member_policy",
                                                "shared_link_policy",
                                                "viewer_info_policy",
                                                "access_inheritance"];
impl ShareFolderArgBase {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<ShareFolderArgBase, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<ShareFolderArgBase>, V::Error> {
        let mut field_path = None;
        let mut field_acl_update_policy = None;
        let mut field_force_async = None;
        let mut field_member_policy = None;
        let mut field_shared_link_policy = None;
        let mut field_viewer_info_policy = None;
        let mut field_access_inheritance = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "path" => {
                    if field_path.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path"));
                    }
                    field_path = Some(map.next_value()?);
                }
                "acl_update_policy" => {
                    if field_acl_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("acl_update_policy"));
                    }
                    field_acl_update_policy = Some(map.next_value()?);
                }
                "force_async" => {
                    if field_force_async.is_some() {
                        return Err(::serde::de::Error::duplicate_field("force_async"));
                    }
                    field_force_async = Some(map.next_value()?);
                }
                "member_policy" => {
                    if field_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_policy"));
                    }
                    field_member_policy = Some(map.next_value()?);
                }
                "shared_link_policy" => {
                    if field_shared_link_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link_policy"));
                    }
                    field_shared_link_policy = Some(map.next_value()?);
                }
                "viewer_info_policy" => {
                    if field_viewer_info_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("viewer_info_policy"));
                    }
                    field_viewer_info_policy = Some(map.next_value()?);
                }
                "access_inheritance" => {
                    if field_access_inheritance.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_inheritance"));
                    }
                    field_access_inheritance = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = ShareFolderArgBase {
            path: field_path.ok_or_else(|| ::serde::de::Error::missing_field("path"))?,
            acl_update_policy: field_acl_update_policy,
            force_async: field_force_async.unwrap_or(false),
            member_policy: field_member_policy,
            shared_link_policy: field_shared_link_policy,
            viewer_info_policy: field_viewer_info_policy,
            access_inheritance: field_access_inheritance.unwrap_or(AccessInheritance::Inherit),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("path", &self.path)?;
        s.serialize_field("acl_update_policy", &self.acl_update_policy)?;
        s.serialize_field("force_async", &self.force_async)?;
        s.serialize_field("member_policy", &self.member_policy)?;
        s.serialize_field("shared_link_policy", &self.shared_link_policy)?;
        s.serialize_field("viewer_info_policy", &self.viewer_info_policy)?;
        s.serialize_field("access_inheritance", &self.access_inheritance)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderArgBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = ShareFolderArgBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderArgBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                ShareFolderArgBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("ShareFolderArgBase", SHARE_FOLDER_ARG_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderArgBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("ShareFolderArgBase", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ShareFolderError {
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// [`ShareFolderArg::path`](ShareFolderArg) is invalid.
    BadPath(SharePathError),
    /// Team policy is more restrictive than [`ShareFolderArg::member_policy`](ShareFolderArg).
    TeamPolicyDisallowsMemberPolicy,
    /// The current user's account is not allowed to select the specified
    /// [`ShareFolderArg::shared_link_policy`](ShareFolderArg).
    DisallowedSharedLinkPolicy,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShareFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "email_unverified" => ShareFolderError::EmailUnverified,
                    "bad_path" => {
                        match map.next_key()? {
                            Some("bad_path") => ShareFolderError::BadPath(map.next_value()?),
                            None => return Err(de::Error::missing_field("bad_path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "team_policy_disallows_member_policy" => ShareFolderError::TeamPolicyDisallowsMemberPolicy,
                    "disallowed_shared_link_policy" => ShareFolderError::DisallowedSharedLinkPolicy,
                    "no_permission" => ShareFolderError::NoPermission,
                    _ => ShareFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["email_unverified",
                                    "bad_path",
                                    "team_policy_disallows_member_policy",
                                    "disallowed_shared_link_policy",
                                    "other",
                                    "no_permission"];
        deserializer.deserialize_struct("ShareFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShareFolderError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            ShareFolderError::BadPath(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ShareFolderError", 2)?;
                s.serialize_field(".tag", "bad_path")?;
                s.serialize_field("bad_path", x)?;
                s.end()
            }
            ShareFolderError::TeamPolicyDisallowsMemberPolicy => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderError", 1)?;
                s.serialize_field(".tag", "team_policy_disallows_member_policy")?;
                s.end()
            }
            ShareFolderError::DisallowedSharedLinkPolicy => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderError", 1)?;
                s.serialize_field(".tag", "disallowed_shared_link_policy")?;
                s.end()
            }
            ShareFolderError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            ShareFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for ShareFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            ShareFolderError::BadPath(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for ShareFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ShareFolderError::BadPath(inner) => write!(f, "{}", inner),
            ShareFolderError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ShareFolderErrorBase {
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// [`ShareFolderArg::path`](ShareFolderArg) is invalid.
    BadPath(SharePathError),
    /// Team policy is more restrictive than [`ShareFolderArg::member_policy`](ShareFolderArg).
    TeamPolicyDisallowsMemberPolicy,
    /// The current user's account is not allowed to select the specified
    /// [`ShareFolderArg::shared_link_policy`](ShareFolderArg).
    DisallowedSharedLinkPolicy,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderErrorBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShareFolderErrorBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderErrorBase structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "email_unverified" => ShareFolderErrorBase::EmailUnverified,
                    "bad_path" => {
                        match map.next_key()? {
                            Some("bad_path") => ShareFolderErrorBase::BadPath(map.next_value()?),
                            None => return Err(de::Error::missing_field("bad_path")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "team_policy_disallows_member_policy" => ShareFolderErrorBase::TeamPolicyDisallowsMemberPolicy,
                    "disallowed_shared_link_policy" => ShareFolderErrorBase::DisallowedSharedLinkPolicy,
                    _ => ShareFolderErrorBase::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["email_unverified",
                                    "bad_path",
                                    "team_policy_disallows_member_policy",
                                    "disallowed_shared_link_policy",
                                    "other"];
        deserializer.deserialize_struct("ShareFolderErrorBase", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderErrorBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShareFolderErrorBase::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderErrorBase", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            ShareFolderErrorBase::BadPath(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ShareFolderErrorBase", 2)?;
                s.serialize_field(".tag", "bad_path")?;
                s.serialize_field("bad_path", x)?;
                s.end()
            }
            ShareFolderErrorBase::TeamPolicyDisallowsMemberPolicy => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderErrorBase", 1)?;
                s.serialize_field(".tag", "team_policy_disallows_member_policy")?;
                s.end()
            }
            ShareFolderErrorBase::DisallowedSharedLinkPolicy => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderErrorBase", 1)?;
                s.serialize_field(".tag", "disallowed_shared_link_policy")?;
                s.end()
            }
            ShareFolderErrorBase::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ShareFolderJobStatus {
    /// The asynchronous job is still in progress.
    InProgress,
    /// The share job has finished. The value is the metadata for the folder.
    Complete(SharedFolderMetadata),
    Failed(ShareFolderError),
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderJobStatus {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShareFolderJobStatus;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderJobStatus structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "in_progress" => ShareFolderJobStatus::InProgress,
                    "complete" => ShareFolderJobStatus::Complete(SharedFolderMetadata::internal_deserialize(&mut map)?),
                    "failed" => {
                        match map.next_key()? {
                            Some("failed") => ShareFolderJobStatus::Failed(map.next_value()?),
                            None => return Err(de::Error::missing_field("failed")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["in_progress",
                                    "complete",
                                    "failed"];
        deserializer.deserialize_struct("ShareFolderJobStatus", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderJobStatus {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShareFolderJobStatus::InProgress => {
                // unit
                let mut s = serializer.serialize_struct("ShareFolderJobStatus", 1)?;
                s.serialize_field(".tag", "in_progress")?;
                s.end()
            }
            ShareFolderJobStatus::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ShareFolderJobStatus", 17)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            ShareFolderJobStatus::Failed(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("ShareFolderJobStatus", 2)?;
                s.serialize_field(".tag", "failed")?;
                s.serialize_field("failed", x)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum ShareFolderLaunch {
    /// This response indicates that the processing is asynchronous. The string is an id that can be
    /// used to obtain the status of the asynchronous job.
    AsyncJobId(super::dbx_async::AsyncJobId),
    Complete(SharedFolderMetadata),
}

impl<'de> ::serde::de::Deserialize<'de> for ShareFolderLaunch {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ShareFolderLaunch;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ShareFolderLaunch structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "async_job_id" => {
                        match map.next_key()? {
                            Some("async_job_id") => ShareFolderLaunch::AsyncJobId(map.next_value()?),
                            None => return Err(de::Error::missing_field("async_job_id")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "complete" => ShareFolderLaunch::Complete(SharedFolderMetadata::internal_deserialize(&mut map)?),
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["async_job_id",
                                    "complete"];
        deserializer.deserialize_struct("ShareFolderLaunch", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ShareFolderLaunch {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ShareFolderLaunch::AsyncJobId(ref x) => {
                // primitive
                let mut s = serializer.serialize_struct("ShareFolderLaunch", 2)?;
                s.serialize_field(".tag", "async_job_id")?;
                s.serialize_field("async_job_id", x)?;
                s.end()
            }
            ShareFolderLaunch::Complete(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("ShareFolderLaunch", 17)?;
                s.serialize_field(".tag", "complete")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharePathError {
    /// A file is at the specified path.
    IsFile,
    /// We do not support sharing a folder inside a shared folder.
    InsideSharedFolder,
    /// We do not support shared folders that contain shared folders.
    ContainsSharedFolder,
    /// We do not support shared folders that contain app folders.
    ContainsAppFolder,
    /// We do not support shared folders that contain team folders.
    ContainsTeamFolder,
    /// We do not support sharing an app folder.
    IsAppFolder,
    /// We do not support sharing a folder inside an app folder.
    InsideAppFolder,
    /// A public folder can't be shared this way. Use a public link instead.
    IsPublicFolder,
    /// A folder inside a public folder can't be shared this way. Use a public link instead.
    InsidePublicFolder,
    /// Folder is already shared. Contains metadata about the existing shared folder.
    AlreadyShared(SharedFolderMetadata),
    /// Path is not valid.
    InvalidPath,
    /// We do not support sharing a Mac OS X package.
    IsOsxPackage,
    /// We do not support sharing a folder inside a Mac OS X package.
    InsideOsxPackage,
    /// We do not support sharing the Vault folder.
    IsVault,
    /// We do not support sharing the Family folder.
    IsFamily,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharePathError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharePathError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharePathError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "is_file" => SharePathError::IsFile,
                    "inside_shared_folder" => SharePathError::InsideSharedFolder,
                    "contains_shared_folder" => SharePathError::ContainsSharedFolder,
                    "contains_app_folder" => SharePathError::ContainsAppFolder,
                    "contains_team_folder" => SharePathError::ContainsTeamFolder,
                    "is_app_folder" => SharePathError::IsAppFolder,
                    "inside_app_folder" => SharePathError::InsideAppFolder,
                    "is_public_folder" => SharePathError::IsPublicFolder,
                    "inside_public_folder" => SharePathError::InsidePublicFolder,
                    "already_shared" => SharePathError::AlreadyShared(SharedFolderMetadata::internal_deserialize(&mut map)?),
                    "invalid_path" => SharePathError::InvalidPath,
                    "is_osx_package" => SharePathError::IsOsxPackage,
                    "inside_osx_package" => SharePathError::InsideOsxPackage,
                    "is_vault" => SharePathError::IsVault,
                    "is_family" => SharePathError::IsFamily,
                    _ => SharePathError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["is_file",
                                    "inside_shared_folder",
                                    "contains_shared_folder",
                                    "contains_app_folder",
                                    "contains_team_folder",
                                    "is_app_folder",
                                    "inside_app_folder",
                                    "is_public_folder",
                                    "inside_public_folder",
                                    "already_shared",
                                    "invalid_path",
                                    "is_osx_package",
                                    "inside_osx_package",
                                    "is_vault",
                                    "is_family",
                                    "other"];
        deserializer.deserialize_struct("SharePathError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharePathError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharePathError::IsFile => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_file")?;
                s.end()
            }
            SharePathError::InsideSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "inside_shared_folder")?;
                s.end()
            }
            SharePathError::ContainsSharedFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "contains_shared_folder")?;
                s.end()
            }
            SharePathError::ContainsAppFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "contains_app_folder")?;
                s.end()
            }
            SharePathError::ContainsTeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "contains_team_folder")?;
                s.end()
            }
            SharePathError::IsAppFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_app_folder")?;
                s.end()
            }
            SharePathError::InsideAppFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "inside_app_folder")?;
                s.end()
            }
            SharePathError::IsPublicFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_public_folder")?;
                s.end()
            }
            SharePathError::InsidePublicFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "inside_public_folder")?;
                s.end()
            }
            SharePathError::AlreadyShared(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SharePathError", 17)?;
                s.serialize_field(".tag", "already_shared")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            SharePathError::InvalidPath => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "invalid_path")?;
                s.end()
            }
            SharePathError::IsOsxPackage => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_osx_package")?;
                s.end()
            }
            SharePathError::InsideOsxPackage => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "inside_osx_package")?;
                s.end()
            }
            SharePathError::IsVault => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_vault")?;
                s.end()
            }
            SharePathError::IsFamily => {
                // unit
                let mut s = serializer.serialize_struct("SharePathError", 1)?;
                s.serialize_field(".tag", "is_family")?;
                s.end()
            }
            SharePathError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharePathError {
}

impl ::std::fmt::Display for SharePathError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SharePathError::IsFile => f.write_str("A file is at the specified path."),
            SharePathError::InsideSharedFolder => f.write_str("We do not support sharing a folder inside a shared folder."),
            SharePathError::ContainsSharedFolder => f.write_str("We do not support shared folders that contain shared folders."),
            SharePathError::ContainsAppFolder => f.write_str("We do not support shared folders that contain app folders."),
            SharePathError::ContainsTeamFolder => f.write_str("We do not support shared folders that contain team folders."),
            SharePathError::IsAppFolder => f.write_str("We do not support sharing an app folder."),
            SharePathError::InsideAppFolder => f.write_str("We do not support sharing a folder inside an app folder."),
            SharePathError::IsPublicFolder => f.write_str("A public folder can't be shared this way. Use a public link instead."),
            SharePathError::InsidePublicFolder => f.write_str("A folder inside a public folder can't be shared this way. Use a public link instead."),
            SharePathError::AlreadyShared(inner) => write!(f, "Folder is already shared. Contains metadata about the existing shared folder: {:?}", inner),
            SharePathError::InvalidPath => f.write_str("Path is not valid."),
            SharePathError::IsOsxPackage => f.write_str("We do not support sharing a Mac OS X package."),
            SharePathError::InsideOsxPackage => f.write_str("We do not support sharing a folder inside a Mac OS X package."),
            SharePathError::IsVault => f.write_str("We do not support sharing the Vault folder."),
            SharePathError::IsFamily => f.write_str("We do not support sharing the Family folder."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Metadata of a shared link for a file or folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedContentLinkMetadata {
    /// The audience options that are available for the content. Some audience options may be
    /// unavailable. For example, team_only may be unavailable if the content is not owned by a user
    /// on a team. The 'default' audience option is always available if the user can modify link
    /// settings.
    pub audience_options: Vec<LinkAudience>,
    /// The current audience of the link.
    pub current_audience: LinkAudience,
    /// A list of permissions for actions you can perform on the link.
    pub link_permissions: Vec<LinkPermission>,
    /// Whether the link is protected by a password.
    pub password_protected: bool,
    /// The URL of the link.
    pub url: String,
    /// The access level on the link for this file.
    pub access_level: Option<AccessLevel>,
    /// The shared folder that prevents the link audience for this link from being more restrictive.
    pub audience_restricting_shared_folder: Option<AudienceRestrictingSharedFolder>,
    /// Whether the link has an expiry set on it. A link with an expiry will have its  audience
    /// changed to members when the expiry is reached.
    pub expiry: Option<super::common::DropboxTimestamp>,
    /// The content inside this folder with link audience different than this folder's. This is only
    /// returned when an endpoint that returns metadata for a single shared folder is called, e.g.
    /// /get_folder_metadata.
    pub audience_exceptions: Option<AudienceExceptions>,
}

impl SharedContentLinkMetadata {
    pub fn new(
        audience_options: Vec<LinkAudience>,
        current_audience: LinkAudience,
        link_permissions: Vec<LinkPermission>,
        password_protected: bool,
        url: String,
    ) -> Self {
        SharedContentLinkMetadata {
            audience_options,
            current_audience,
            link_permissions,
            password_protected,
            url,
            access_level: None,
            audience_restricting_shared_folder: None,
            expiry: None,
            audience_exceptions: None,
        }
    }

    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = Some(value);
        self
    }

    pub fn with_audience_restricting_shared_folder(
        mut self,
        value: AudienceRestrictingSharedFolder,
    ) -> Self {
        self.audience_restricting_shared_folder = Some(value);
        self
    }

    pub fn with_expiry(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expiry = Some(value);
        self
    }

    pub fn with_audience_exceptions(mut self, value: AudienceExceptions) -> Self {
        self.audience_exceptions = Some(value);
        self
    }
}

const SHARED_CONTENT_LINK_METADATA_FIELDS: &[&str] = &["audience_options",
                                                       "current_audience",
                                                       "link_permissions",
                                                       "password_protected",
                                                       "url",
                                                       "access_level",
                                                       "audience_restricting_shared_folder",
                                                       "expiry",
                                                       "audience_exceptions"];
impl SharedContentLinkMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedContentLinkMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedContentLinkMetadata>, V::Error> {
        let mut field_audience_options = None;
        let mut field_current_audience = None;
        let mut field_link_permissions = None;
        let mut field_password_protected = None;
        let mut field_url = None;
        let mut field_access_level = None;
        let mut field_audience_restricting_shared_folder = None;
        let mut field_expiry = None;
        let mut field_audience_exceptions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "audience_options" => {
                    if field_audience_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_options"));
                    }
                    field_audience_options = Some(map.next_value()?);
                }
                "current_audience" => {
                    if field_current_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("current_audience"));
                    }
                    field_current_audience = Some(map.next_value()?);
                }
                "link_permissions" => {
                    if field_link_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_permissions"));
                    }
                    field_link_permissions = Some(map.next_value()?);
                }
                "password_protected" => {
                    if field_password_protected.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password_protected"));
                    }
                    field_password_protected = Some(map.next_value()?);
                }
                "url" => {
                    if field_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("url"));
                    }
                    field_url = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "audience_restricting_shared_folder" => {
                    if field_audience_restricting_shared_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_restricting_shared_folder"));
                    }
                    field_audience_restricting_shared_folder = Some(map.next_value()?);
                }
                "expiry" => {
                    if field_expiry.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiry"));
                    }
                    field_expiry = Some(map.next_value()?);
                }
                "audience_exceptions" => {
                    if field_audience_exceptions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_exceptions"));
                    }
                    field_audience_exceptions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedContentLinkMetadata {
            audience_options: field_audience_options.ok_or_else(|| ::serde::de::Error::missing_field("audience_options"))?,
            current_audience: field_current_audience.ok_or_else(|| ::serde::de::Error::missing_field("current_audience"))?,
            link_permissions: field_link_permissions.ok_or_else(|| ::serde::de::Error::missing_field("link_permissions"))?,
            password_protected: field_password_protected.ok_or_else(|| ::serde::de::Error::missing_field("password_protected"))?,
            url: field_url.ok_or_else(|| ::serde::de::Error::missing_field("url"))?,
            access_level: field_access_level,
            audience_restricting_shared_folder: field_audience_restricting_shared_folder,
            expiry: field_expiry,
            audience_exceptions: field_audience_exceptions,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("audience_options", &self.audience_options)?;
        s.serialize_field("current_audience", &self.current_audience)?;
        s.serialize_field("link_permissions", &self.link_permissions)?;
        s.serialize_field("password_protected", &self.password_protected)?;
        s.serialize_field("url", &self.url)?;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("audience_restricting_shared_folder", &self.audience_restricting_shared_folder)?;
        s.serialize_field("expiry", &self.expiry)?;
        s.serialize_field("audience_exceptions", &self.audience_exceptions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedContentLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedContentLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedContentLinkMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedContentLinkMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedContentLinkMetadata", SHARED_CONTENT_LINK_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedContentLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedContentLinkMetadata", 9)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedContentLinkMetadataBase {
    /// The audience options that are available for the content. Some audience options may be
    /// unavailable. For example, team_only may be unavailable if the content is not owned by a user
    /// on a team. The 'default' audience option is always available if the user can modify link
    /// settings.
    pub audience_options: Vec<LinkAudience>,
    /// The current audience of the link.
    pub current_audience: LinkAudience,
    /// A list of permissions for actions you can perform on the link.
    pub link_permissions: Vec<LinkPermission>,
    /// Whether the link is protected by a password.
    pub password_protected: bool,
    /// The access level on the link for this file.
    pub access_level: Option<AccessLevel>,
    /// The shared folder that prevents the link audience for this link from being more restrictive.
    pub audience_restricting_shared_folder: Option<AudienceRestrictingSharedFolder>,
    /// Whether the link has an expiry set on it. A link with an expiry will have its  audience
    /// changed to members when the expiry is reached.
    pub expiry: Option<super::common::DropboxTimestamp>,
}

impl SharedContentLinkMetadataBase {
    pub fn new(
        audience_options: Vec<LinkAudience>,
        current_audience: LinkAudience,
        link_permissions: Vec<LinkPermission>,
        password_protected: bool,
    ) -> Self {
        SharedContentLinkMetadataBase {
            audience_options,
            current_audience,
            link_permissions,
            password_protected,
            access_level: None,
            audience_restricting_shared_folder: None,
            expiry: None,
        }
    }

    pub fn with_access_level(mut self, value: AccessLevel) -> Self {
        self.access_level = Some(value);
        self
    }

    pub fn with_audience_restricting_shared_folder(
        mut self,
        value: AudienceRestrictingSharedFolder,
    ) -> Self {
        self.audience_restricting_shared_folder = Some(value);
        self
    }

    pub fn with_expiry(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expiry = Some(value);
        self
    }
}

const SHARED_CONTENT_LINK_METADATA_BASE_FIELDS: &[&str] = &["audience_options",
                                                            "current_audience",
                                                            "link_permissions",
                                                            "password_protected",
                                                            "access_level",
                                                            "audience_restricting_shared_folder",
                                                            "expiry"];
impl SharedContentLinkMetadataBase {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedContentLinkMetadataBase, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedContentLinkMetadataBase>, V::Error> {
        let mut field_audience_options = None;
        let mut field_current_audience = None;
        let mut field_link_permissions = None;
        let mut field_password_protected = None;
        let mut field_access_level = None;
        let mut field_audience_restricting_shared_folder = None;
        let mut field_expiry = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "audience_options" => {
                    if field_audience_options.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_options"));
                    }
                    field_audience_options = Some(map.next_value()?);
                }
                "current_audience" => {
                    if field_current_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("current_audience"));
                    }
                    field_current_audience = Some(map.next_value()?);
                }
                "link_permissions" => {
                    if field_link_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_permissions"));
                    }
                    field_link_permissions = Some(map.next_value()?);
                }
                "password_protected" => {
                    if field_password_protected.is_some() {
                        return Err(::serde::de::Error::duplicate_field("password_protected"));
                    }
                    field_password_protected = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                "audience_restricting_shared_folder" => {
                    if field_audience_restricting_shared_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience_restricting_shared_folder"));
                    }
                    field_audience_restricting_shared_folder = Some(map.next_value()?);
                }
                "expiry" => {
                    if field_expiry.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expiry"));
                    }
                    field_expiry = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedContentLinkMetadataBase {
            audience_options: field_audience_options.ok_or_else(|| ::serde::de::Error::missing_field("audience_options"))?,
            current_audience: field_current_audience.ok_or_else(|| ::serde::de::Error::missing_field("current_audience"))?,
            link_permissions: field_link_permissions.ok_or_else(|| ::serde::de::Error::missing_field("link_permissions"))?,
            password_protected: field_password_protected.ok_or_else(|| ::serde::de::Error::missing_field("password_protected"))?,
            access_level: field_access_level,
            audience_restricting_shared_folder: field_audience_restricting_shared_folder,
            expiry: field_expiry,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("audience_options", &self.audience_options)?;
        s.serialize_field("current_audience", &self.current_audience)?;
        s.serialize_field("link_permissions", &self.link_permissions)?;
        s.serialize_field("password_protected", &self.password_protected)?;
        s.serialize_field("access_level", &self.access_level)?;
        s.serialize_field("audience_restricting_shared_folder", &self.audience_restricting_shared_folder)?;
        s.serialize_field("expiry", &self.expiry)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedContentLinkMetadataBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedContentLinkMetadataBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedContentLinkMetadataBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedContentLinkMetadataBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedContentLinkMetadataBase", SHARED_CONTENT_LINK_METADATA_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedContentLinkMetadataBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedContentLinkMetadataBase", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Shared file user, group, and invitee membership. Used for the results of
/// [`list_file_members()`](list_file_members) and
/// [`list_file_members_continue()`](list_file_members_continue), and used as part of the results
/// for [`list_file_members_batch()`](list_file_members_batch).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedFileMembers {
    /// The list of user members of the shared file.
    pub users: Vec<UserFileMembershipInfo>,
    /// The list of group members of the shared file.
    pub groups: Vec<GroupMembershipInfo>,
    /// The list of invited members of a file, but have not logged in and claimed this.
    pub invitees: Vec<InviteeMembershipInfo>,
    /// Present if there are additional shared file members that have not been returned yet. Pass
    /// the cursor into [`list_file_members_continue()`](list_file_members_continue) to list
    /// additional members.
    pub cursor: Option<String>,
}

impl SharedFileMembers {
    pub fn new(
        users: Vec<UserFileMembershipInfo>,
        groups: Vec<GroupMembershipInfo>,
        invitees: Vec<InviteeMembershipInfo>,
    ) -> Self {
        SharedFileMembers {
            users,
            groups,
            invitees,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const SHARED_FILE_MEMBERS_FIELDS: &[&str] = &["users",
                                              "groups",
                                              "invitees",
                                              "cursor"];
impl SharedFileMembers {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedFileMembers, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedFileMembers>, V::Error> {
        let mut field_users = None;
        let mut field_groups = None;
        let mut field_invitees = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "groups" => {
                    if field_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("groups"));
                    }
                    field_groups = Some(map.next_value()?);
                }
                "invitees" => {
                    if field_invitees.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitees"));
                    }
                    field_invitees = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedFileMembers {
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            groups: field_groups.ok_or_else(|| ::serde::de::Error::missing_field("groups"))?,
            invitees: field_invitees.ok_or_else(|| ::serde::de::Error::missing_field("invitees"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("groups", &self.groups)?;
        s.serialize_field("invitees", &self.invitees)?;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFileMembers {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedFileMembers;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFileMembers struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedFileMembers::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedFileMembers", SHARED_FILE_MEMBERS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFileMembers {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedFileMembers", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Properties of the shared file.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedFileMetadata {
    /// The ID of the file.
    pub id: super::files::FileId,
    /// The name of this file.
    pub name: String,
    /// Policies governing this shared file.
    pub policy: FolderPolicy,
    /// URL for displaying a web preview of the shared file.
    pub preview_url: String,
    /// The current user's access level for this shared file.
    pub access_type: Option<AccessLevel>,
    /// The expected metadata of the link associated for the file when it is first shared. Absent if
    /// the link already exists. This is for an unreleased feature so it may not be returned yet.
    pub expected_link_metadata: Option<ExpectedSharedContentLinkMetadata>,
    /// The metadata of the link associated for the file. This is for an unreleased feature so it
    /// may not be returned yet.
    pub link_metadata: Option<SharedContentLinkMetadata>,
    /// The display names of the users that own the file. If the file is part of a team folder, the
    /// display names of the team admins are also included. Absent if the owner display names cannot
    /// be fetched.
    pub owner_display_names: Option<Vec<String>>,
    /// The team that owns the file. This field is not present if the file is not owned by a team.
    pub owner_team: Option<super::users::Team>,
    /// The ID of the parent shared folder. This field is present only if the file is contained
    /// within a shared folder.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// The cased path to be used for display purposes only. In rare instances the casing will not
    /// correctly match the user's filesystem, but this behavior will match the path provided in the
    /// Core API v1. Absent for unmounted files.
    pub path_display: Option<String>,
    /// The lower-case full path of this file. Absent for unmounted files.
    pub path_lower: Option<String>,
    /// The sharing permissions that requesting user has on this file. This corresponds to the
    /// entries given in [`GetFileMetadataBatchArg::actions`](GetFileMetadataBatchArg) or
    /// [`GetFileMetadataArg::actions`](GetFileMetadataArg).
    pub permissions: Option<Vec<FilePermission>>,
    /// Timestamp indicating when the current user was invited to this shared file. If the user was
    /// not invited to the shared file, the timestamp will indicate when the user was invited to the
    /// parent shared folder. This value may be absent.
    pub time_invited: Option<super::common::DropboxTimestamp>,
}

impl SharedFileMetadata {
    pub fn new(
        id: super::files::FileId,
        name: String,
        policy: FolderPolicy,
        preview_url: String,
    ) -> Self {
        SharedFileMetadata {
            id,
            name,
            policy,
            preview_url,
            access_type: None,
            expected_link_metadata: None,
            link_metadata: None,
            owner_display_names: None,
            owner_team: None,
            parent_shared_folder_id: None,
            path_display: None,
            path_lower: None,
            permissions: None,
            time_invited: None,
        }
    }

    pub fn with_access_type(mut self, value: AccessLevel) -> Self {
        self.access_type = Some(value);
        self
    }

    pub fn with_expected_link_metadata(
        mut self,
        value: ExpectedSharedContentLinkMetadata,
    ) -> Self {
        self.expected_link_metadata = Some(value);
        self
    }

    pub fn with_link_metadata(mut self, value: SharedContentLinkMetadata) -> Self {
        self.link_metadata = Some(value);
        self
    }

    pub fn with_owner_display_names(mut self, value: Vec<String>) -> Self {
        self.owner_display_names = Some(value);
        self
    }

    pub fn with_owner_team(mut self, value: super::users::Team) -> Self {
        self.owner_team = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_path_display(mut self, value: String) -> Self {
        self.path_display = Some(value);
        self
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_permissions(mut self, value: Vec<FilePermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_time_invited(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.time_invited = Some(value);
        self
    }
}

const SHARED_FILE_METADATA_FIELDS: &[&str] = &["id",
                                               "name",
                                               "policy",
                                               "preview_url",
                                               "access_type",
                                               "expected_link_metadata",
                                               "link_metadata",
                                               "owner_display_names",
                                               "owner_team",
                                               "parent_shared_folder_id",
                                               "path_display",
                                               "path_lower",
                                               "permissions",
                                               "time_invited"];
impl SharedFileMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedFileMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedFileMetadata>, V::Error> {
        let mut field_id = None;
        let mut field_name = None;
        let mut field_policy = None;
        let mut field_preview_url = None;
        let mut field_access_type = None;
        let mut field_expected_link_metadata = None;
        let mut field_link_metadata = None;
        let mut field_owner_display_names = None;
        let mut field_owner_team = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_path_display = None;
        let mut field_path_lower = None;
        let mut field_permissions = None;
        let mut field_time_invited = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "id" => {
                    if field_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("id"));
                    }
                    field_id = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "policy" => {
                    if field_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("policy"));
                    }
                    field_policy = Some(map.next_value()?);
                }
                "preview_url" => {
                    if field_preview_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("preview_url"));
                    }
                    field_preview_url = Some(map.next_value()?);
                }
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "expected_link_metadata" => {
                    if field_expected_link_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expected_link_metadata"));
                    }
                    field_expected_link_metadata = Some(map.next_value()?);
                }
                "link_metadata" => {
                    if field_link_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_metadata"));
                    }
                    field_link_metadata = Some(map.next_value()?);
                }
                "owner_display_names" => {
                    if field_owner_display_names.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_display_names"));
                    }
                    field_owner_display_names = Some(map.next_value()?);
                }
                "owner_team" => {
                    if field_owner_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_team"));
                    }
                    field_owner_team = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "path_display" => {
                    if field_path_display.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_display"));
                    }
                    field_path_display = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "time_invited" => {
                    if field_time_invited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("time_invited"));
                    }
                    field_time_invited = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedFileMetadata {
            id: field_id.ok_or_else(|| ::serde::de::Error::missing_field("id"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            policy: field_policy.ok_or_else(|| ::serde::de::Error::missing_field("policy"))?,
            preview_url: field_preview_url.ok_or_else(|| ::serde::de::Error::missing_field("preview_url"))?,
            access_type: field_access_type,
            expected_link_metadata: field_expected_link_metadata,
            link_metadata: field_link_metadata,
            owner_display_names: field_owner_display_names,
            owner_team: field_owner_team,
            parent_shared_folder_id: field_parent_shared_folder_id,
            path_display: field_path_display,
            path_lower: field_path_lower,
            permissions: field_permissions,
            time_invited: field_time_invited,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("id", &self.id)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("policy", &self.policy)?;
        s.serialize_field("preview_url", &self.preview_url)?;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("expected_link_metadata", &self.expected_link_metadata)?;
        s.serialize_field("link_metadata", &self.link_metadata)?;
        s.serialize_field("owner_display_names", &self.owner_display_names)?;
        s.serialize_field("owner_team", &self.owner_team)?;
        s.serialize_field("parent_shared_folder_id", &self.parent_shared_folder_id)?;
        s.serialize_field("path_display", &self.path_display)?;
        s.serialize_field("path_lower", &self.path_lower)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("time_invited", &self.time_invited)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFileMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedFileMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFileMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedFileMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedFileMetadata", SHARED_FILE_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFileMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedFileMetadata", 14)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// There is an error accessing the shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedFolderAccessError {
    /// This shared folder ID is invalid.
    InvalidId,
    /// The user is not a member of the shared folder thus cannot access it.
    NotAMember,
    /// Never set.
    EmailUnverified,
    /// The shared folder is unmounted.
    Unmounted,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderAccessError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedFolderAccessError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderAccessError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_id" => SharedFolderAccessError::InvalidId,
                    "not_a_member" => SharedFolderAccessError::NotAMember,
                    "email_unverified" => SharedFolderAccessError::EmailUnverified,
                    "unmounted" => SharedFolderAccessError::Unmounted,
                    _ => SharedFolderAccessError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_id",
                                    "not_a_member",
                                    "email_unverified",
                                    "unmounted",
                                    "other"];
        deserializer.deserialize_struct("SharedFolderAccessError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderAccessError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedFolderAccessError::InvalidId => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderAccessError", 1)?;
                s.serialize_field(".tag", "invalid_id")?;
                s.end()
            }
            SharedFolderAccessError::NotAMember => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderAccessError", 1)?;
                s.serialize_field(".tag", "not_a_member")?;
                s.end()
            }
            SharedFolderAccessError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderAccessError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            SharedFolderAccessError::Unmounted => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderAccessError", 1)?;
                s.serialize_field(".tag", "unmounted")?;
                s.end()
            }
            SharedFolderAccessError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharedFolderAccessError {
}

impl ::std::fmt::Display for SharedFolderAccessError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SharedFolderAccessError::InvalidId => f.write_str("This shared folder ID is invalid."),
            SharedFolderAccessError::NotAMember => f.write_str("The user is not a member of the shared folder thus cannot access it."),
            SharedFolderAccessError::EmailUnverified => f.write_str("Never set."),
            SharedFolderAccessError::Unmounted => f.write_str("The shared folder is unmounted."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedFolderMemberError {
    /// The target dropbox_id is invalid.
    InvalidDropboxId,
    /// The target dropbox_id is not a member of the shared folder.
    NotAMember,
    /// The target member only has inherited access to the shared folder.
    NoExplicitAccess(MemberAccessLevelResult),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedFolderMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_dropbox_id" => SharedFolderMemberError::InvalidDropboxId,
                    "not_a_member" => SharedFolderMemberError::NotAMember,
                    "no_explicit_access" => SharedFolderMemberError::NoExplicitAccess(MemberAccessLevelResult::internal_deserialize(&mut map)?),
                    _ => SharedFolderMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_dropbox_id",
                                    "not_a_member",
                                    "no_explicit_access",
                                    "other"];
        deserializer.deserialize_struct("SharedFolderMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedFolderMemberError::InvalidDropboxId => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderMemberError", 1)?;
                s.serialize_field(".tag", "invalid_dropbox_id")?;
                s.end()
            }
            SharedFolderMemberError::NotAMember => {
                // unit
                let mut s = serializer.serialize_struct("SharedFolderMemberError", 1)?;
                s.serialize_field(".tag", "not_a_member")?;
                s.end()
            }
            SharedFolderMemberError::NoExplicitAccess(ref x) => {
                // struct
                let mut s = serializer.serialize_struct("SharedFolderMemberError", 4)?;
                s.serialize_field(".tag", "no_explicit_access")?;
                x.internal_serialize::<S>(&mut s)?;
                s.end()
            }
            SharedFolderMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharedFolderMemberError {
}

impl ::std::fmt::Display for SharedFolderMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SharedFolderMemberError::InvalidDropboxId => f.write_str("The target dropbox_id is invalid."),
            SharedFolderMemberError::NotAMember => f.write_str("The target dropbox_id is not a member of the shared folder."),
            SharedFolderMemberError::NoExplicitAccess(inner) => write!(f, "The target member only has inherited access to the shared folder: {:?}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Shared folder user and group membership.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedFolderMembers {
    /// The list of user members of the shared folder.
    pub users: Vec<UserMembershipInfo>,
    /// The list of group members of the shared folder.
    pub groups: Vec<GroupMembershipInfo>,
    /// The list of invitees to the shared folder.
    pub invitees: Vec<InviteeMembershipInfo>,
    /// Present if there are additional shared folder members that have not been returned yet. Pass
    /// the cursor into [`list_folder_members_continue()`](list_folder_members_continue) to list
    /// additional members.
    pub cursor: Option<String>,
}

impl SharedFolderMembers {
    pub fn new(
        users: Vec<UserMembershipInfo>,
        groups: Vec<GroupMembershipInfo>,
        invitees: Vec<InviteeMembershipInfo>,
    ) -> Self {
        SharedFolderMembers {
            users,
            groups,
            invitees,
            cursor: None,
        }
    }

    pub fn with_cursor(mut self, value: String) -> Self {
        self.cursor = Some(value);
        self
    }
}

const SHARED_FOLDER_MEMBERS_FIELDS: &[&str] = &["users",
                                                "groups",
                                                "invitees",
                                                "cursor"];
impl SharedFolderMembers {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedFolderMembers, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedFolderMembers>, V::Error> {
        let mut field_users = None;
        let mut field_groups = None;
        let mut field_invitees = None;
        let mut field_cursor = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "users" => {
                    if field_users.is_some() {
                        return Err(::serde::de::Error::duplicate_field("users"));
                    }
                    field_users = Some(map.next_value()?);
                }
                "groups" => {
                    if field_groups.is_some() {
                        return Err(::serde::de::Error::duplicate_field("groups"));
                    }
                    field_groups = Some(map.next_value()?);
                }
                "invitees" => {
                    if field_invitees.is_some() {
                        return Err(::serde::de::Error::duplicate_field("invitees"));
                    }
                    field_invitees = Some(map.next_value()?);
                }
                "cursor" => {
                    if field_cursor.is_some() {
                        return Err(::serde::de::Error::duplicate_field("cursor"));
                    }
                    field_cursor = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedFolderMembers {
            users: field_users.ok_or_else(|| ::serde::de::Error::missing_field("users"))?,
            groups: field_groups.ok_or_else(|| ::serde::de::Error::missing_field("groups"))?,
            invitees: field_invitees.ok_or_else(|| ::serde::de::Error::missing_field("invitees"))?,
            cursor: field_cursor,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("users", &self.users)?;
        s.serialize_field("groups", &self.groups)?;
        s.serialize_field("invitees", &self.invitees)?;
        s.serialize_field("cursor", &self.cursor)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderMembers {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedFolderMembers;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderMembers struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedFolderMembers::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedFolderMembers", SHARED_FOLDER_MEMBERS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderMembers {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedFolderMembers", 4)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The metadata which includes basic information about the shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedFolderMetadata {
    /// The current user's access level for this shared folder.
    pub access_type: AccessLevel,
    /// Whether this folder is inside of a team folder.
    pub is_inside_team_folder: bool,
    /// Whether this folder is a [team folder](https://www.dropbox.com/en/help/986).
    pub is_team_folder: bool,
    /// The name of the this shared folder.
    pub name: String,
    /// Policies governing this shared folder.
    pub policy: FolderPolicy,
    /// URL for displaying a web preview of the shared folder.
    pub preview_url: String,
    /// The ID of the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// Timestamp indicating when the current user was invited to this shared folder.
    pub time_invited: super::common::DropboxTimestamp,
    /// The display names of the users that own the folder. If the folder is part of a team folder,
    /// the display names of the team admins are also included. Absent if the owner display names
    /// cannot be fetched.
    pub owner_display_names: Option<Vec<String>>,
    /// The team that owns the folder. This field is not present if the folder is not owned by a
    /// team.
    pub owner_team: Option<super::users::Team>,
    /// The ID of the parent shared folder. This field is present only if the folder is contained
    /// within another shared folder.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// The lower-cased full path of this shared folder. Absent for unmounted folders.
    pub path_lower: Option<String>,
    /// Display name for the parent folder.
    pub parent_folder_name: Option<String>,
    /// The metadata of the shared content link to this shared folder. Absent if there is no link on
    /// the folder. This is for an unreleased feature so it may not be returned yet.
    pub link_metadata: Option<SharedContentLinkMetadata>,
    /// Actions the current user may perform on the folder and its contents. The set of permissions
    /// corresponds to the FolderActions in the request.
    pub permissions: Option<Vec<FolderPermission>>,
    /// Whether the folder inherits its members from its parent.
    pub access_inheritance: AccessInheritance,
}

impl SharedFolderMetadata {
    pub fn new(
        access_type: AccessLevel,
        is_inside_team_folder: bool,
        is_team_folder: bool,
        name: String,
        policy: FolderPolicy,
        preview_url: String,
        shared_folder_id: super::common::SharedFolderId,
        time_invited: super::common::DropboxTimestamp,
    ) -> Self {
        SharedFolderMetadata {
            access_type,
            is_inside_team_folder,
            is_team_folder,
            name,
            policy,
            preview_url,
            shared_folder_id,
            time_invited,
            owner_display_names: None,
            owner_team: None,
            parent_shared_folder_id: None,
            path_lower: None,
            parent_folder_name: None,
            link_metadata: None,
            permissions: None,
            access_inheritance: AccessInheritance::Inherit,
        }
    }

    pub fn with_owner_display_names(mut self, value: Vec<String>) -> Self {
        self.owner_display_names = Some(value);
        self
    }

    pub fn with_owner_team(mut self, value: super::users::Team) -> Self {
        self.owner_team = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_parent_folder_name(mut self, value: String) -> Self {
        self.parent_folder_name = Some(value);
        self
    }

    pub fn with_link_metadata(mut self, value: SharedContentLinkMetadata) -> Self {
        self.link_metadata = Some(value);
        self
    }

    pub fn with_permissions(mut self, value: Vec<FolderPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_access_inheritance(mut self, value: AccessInheritance) -> Self {
        self.access_inheritance = value;
        self
    }
}

const SHARED_FOLDER_METADATA_FIELDS: &[&str] = &["access_type",
                                                 "is_inside_team_folder",
                                                 "is_team_folder",
                                                 "name",
                                                 "policy",
                                                 "preview_url",
                                                 "shared_folder_id",
                                                 "time_invited",
                                                 "owner_display_names",
                                                 "owner_team",
                                                 "parent_shared_folder_id",
                                                 "path_lower",
                                                 "parent_folder_name",
                                                 "link_metadata",
                                                 "permissions",
                                                 "access_inheritance"];
impl SharedFolderMetadata {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedFolderMetadata, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedFolderMetadata>, V::Error> {
        let mut field_access_type = None;
        let mut field_is_inside_team_folder = None;
        let mut field_is_team_folder = None;
        let mut field_name = None;
        let mut field_policy = None;
        let mut field_preview_url = None;
        let mut field_shared_folder_id = None;
        let mut field_time_invited = None;
        let mut field_owner_display_names = None;
        let mut field_owner_team = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_path_lower = None;
        let mut field_parent_folder_name = None;
        let mut field_link_metadata = None;
        let mut field_permissions = None;
        let mut field_access_inheritance = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "is_inside_team_folder" => {
                    if field_is_inside_team_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inside_team_folder"));
                    }
                    field_is_inside_team_folder = Some(map.next_value()?);
                }
                "is_team_folder" => {
                    if field_is_team_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_team_folder"));
                    }
                    field_is_team_folder = Some(map.next_value()?);
                }
                "name" => {
                    if field_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("name"));
                    }
                    field_name = Some(map.next_value()?);
                }
                "policy" => {
                    if field_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("policy"));
                    }
                    field_policy = Some(map.next_value()?);
                }
                "preview_url" => {
                    if field_preview_url.is_some() {
                        return Err(::serde::de::Error::duplicate_field("preview_url"));
                    }
                    field_preview_url = Some(map.next_value()?);
                }
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "time_invited" => {
                    if field_time_invited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("time_invited"));
                    }
                    field_time_invited = Some(map.next_value()?);
                }
                "owner_display_names" => {
                    if field_owner_display_names.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_display_names"));
                    }
                    field_owner_display_names = Some(map.next_value()?);
                }
                "owner_team" => {
                    if field_owner_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_team"));
                    }
                    field_owner_team = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "parent_folder_name" => {
                    if field_parent_folder_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_folder_name"));
                    }
                    field_parent_folder_name = Some(map.next_value()?);
                }
                "link_metadata" => {
                    if field_link_metadata.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_metadata"));
                    }
                    field_link_metadata = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "access_inheritance" => {
                    if field_access_inheritance.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_inheritance"));
                    }
                    field_access_inheritance = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedFolderMetadata {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            is_inside_team_folder: field_is_inside_team_folder.ok_or_else(|| ::serde::de::Error::missing_field("is_inside_team_folder"))?,
            is_team_folder: field_is_team_folder.ok_or_else(|| ::serde::de::Error::missing_field("is_team_folder"))?,
            name: field_name.ok_or_else(|| ::serde::de::Error::missing_field("name"))?,
            policy: field_policy.ok_or_else(|| ::serde::de::Error::missing_field("policy"))?,
            preview_url: field_preview_url.ok_or_else(|| ::serde::de::Error::missing_field("preview_url"))?,
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            time_invited: field_time_invited.ok_or_else(|| ::serde::de::Error::missing_field("time_invited"))?,
            owner_display_names: field_owner_display_names,
            owner_team: field_owner_team,
            parent_shared_folder_id: field_parent_shared_folder_id,
            path_lower: field_path_lower,
            parent_folder_name: field_parent_folder_name,
            link_metadata: field_link_metadata,
            permissions: field_permissions,
            access_inheritance: field_access_inheritance.unwrap_or(AccessInheritance::Inherit),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("is_inside_team_folder", &self.is_inside_team_folder)?;
        s.serialize_field("is_team_folder", &self.is_team_folder)?;
        s.serialize_field("name", &self.name)?;
        s.serialize_field("policy", &self.policy)?;
        s.serialize_field("preview_url", &self.preview_url)?;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("time_invited", &self.time_invited)?;
        s.serialize_field("owner_display_names", &self.owner_display_names)?;
        s.serialize_field("owner_team", &self.owner_team)?;
        s.serialize_field("parent_shared_folder_id", &self.parent_shared_folder_id)?;
        s.serialize_field("path_lower", &self.path_lower)?;
        s.serialize_field("parent_folder_name", &self.parent_folder_name)?;
        s.serialize_field("link_metadata", &self.link_metadata)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("access_inheritance", &self.access_inheritance)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedFolderMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderMetadata struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedFolderMetadata::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedFolderMetadata", SHARED_FOLDER_METADATA_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedFolderMetadata", 16)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Properties of the shared folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedFolderMetadataBase {
    /// The current user's access level for this shared folder.
    pub access_type: AccessLevel,
    /// Whether this folder is inside of a team folder.
    pub is_inside_team_folder: bool,
    /// Whether this folder is a [team folder](https://www.dropbox.com/en/help/986).
    pub is_team_folder: bool,
    /// The display names of the users that own the folder. If the folder is part of a team folder,
    /// the display names of the team admins are also included. Absent if the owner display names
    /// cannot be fetched.
    pub owner_display_names: Option<Vec<String>>,
    /// The team that owns the folder. This field is not present if the folder is not owned by a
    /// team.
    pub owner_team: Option<super::users::Team>,
    /// The ID of the parent shared folder. This field is present only if the folder is contained
    /// within another shared folder.
    pub parent_shared_folder_id: Option<super::common::SharedFolderId>,
    /// The lower-cased full path of this shared folder. Absent for unmounted folders.
    pub path_lower: Option<String>,
    /// Display name for the parent folder.
    pub parent_folder_name: Option<String>,
}

impl SharedFolderMetadataBase {
    pub fn new(
        access_type: AccessLevel,
        is_inside_team_folder: bool,
        is_team_folder: bool,
    ) -> Self {
        SharedFolderMetadataBase {
            access_type,
            is_inside_team_folder,
            is_team_folder,
            owner_display_names: None,
            owner_team: None,
            parent_shared_folder_id: None,
            path_lower: None,
            parent_folder_name: None,
        }
    }

    pub fn with_owner_display_names(mut self, value: Vec<String>) -> Self {
        self.owner_display_names = Some(value);
        self
    }

    pub fn with_owner_team(mut self, value: super::users::Team) -> Self {
        self.owner_team = Some(value);
        self
    }

    pub fn with_parent_shared_folder_id(mut self, value: super::common::SharedFolderId) -> Self {
        self.parent_shared_folder_id = Some(value);
        self
    }

    pub fn with_path_lower(mut self, value: String) -> Self {
        self.path_lower = Some(value);
        self
    }

    pub fn with_parent_folder_name(mut self, value: String) -> Self {
        self.parent_folder_name = Some(value);
        self
    }
}

const SHARED_FOLDER_METADATA_BASE_FIELDS: &[&str] = &["access_type",
                                                      "is_inside_team_folder",
                                                      "is_team_folder",
                                                      "owner_display_names",
                                                      "owner_team",
                                                      "parent_shared_folder_id",
                                                      "path_lower",
                                                      "parent_folder_name"];
impl SharedFolderMetadataBase {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<SharedFolderMetadataBase, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<SharedFolderMetadataBase>, V::Error> {
        let mut field_access_type = None;
        let mut field_is_inside_team_folder = None;
        let mut field_is_team_folder = None;
        let mut field_owner_display_names = None;
        let mut field_owner_team = None;
        let mut field_parent_shared_folder_id = None;
        let mut field_path_lower = None;
        let mut field_parent_folder_name = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "is_inside_team_folder" => {
                    if field_is_inside_team_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inside_team_folder"));
                    }
                    field_is_inside_team_folder = Some(map.next_value()?);
                }
                "is_team_folder" => {
                    if field_is_team_folder.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_team_folder"));
                    }
                    field_is_team_folder = Some(map.next_value()?);
                }
                "owner_display_names" => {
                    if field_owner_display_names.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_display_names"));
                    }
                    field_owner_display_names = Some(map.next_value()?);
                }
                "owner_team" => {
                    if field_owner_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("owner_team"));
                    }
                    field_owner_team = Some(map.next_value()?);
                }
                "parent_shared_folder_id" => {
                    if field_parent_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_shared_folder_id"));
                    }
                    field_parent_shared_folder_id = Some(map.next_value()?);
                }
                "path_lower" => {
                    if field_path_lower.is_some() {
                        return Err(::serde::de::Error::duplicate_field("path_lower"));
                    }
                    field_path_lower = Some(map.next_value()?);
                }
                "parent_folder_name" => {
                    if field_parent_folder_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("parent_folder_name"));
                    }
                    field_parent_folder_name = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = SharedFolderMetadataBase {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            is_inside_team_folder: field_is_inside_team_folder.ok_or_else(|| ::serde::de::Error::missing_field("is_inside_team_folder"))?,
            is_team_folder: field_is_team_folder.ok_or_else(|| ::serde::de::Error::missing_field("is_team_folder"))?,
            owner_display_names: field_owner_display_names,
            owner_team: field_owner_team,
            parent_shared_folder_id: field_parent_shared_folder_id,
            path_lower: field_path_lower,
            parent_folder_name: field_parent_folder_name,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("is_inside_team_folder", &self.is_inside_team_folder)?;
        s.serialize_field("is_team_folder", &self.is_team_folder)?;
        s.serialize_field("owner_display_names", &self.owner_display_names)?;
        s.serialize_field("owner_team", &self.owner_team)?;
        s.serialize_field("parent_shared_folder_id", &self.parent_shared_folder_id)?;
        s.serialize_field("path_lower", &self.path_lower)?;
        s.serialize_field("parent_folder_name", &self.parent_folder_name)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedFolderMetadataBase {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedFolderMetadataBase;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedFolderMetadataBase struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedFolderMetadataBase::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedFolderMetadataBase", SHARED_FOLDER_METADATA_BASE_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedFolderMetadataBase {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedFolderMetadataBase", 8)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkAccessFailureReason {
    /// User is not logged in.
    LoginRequired,
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailVerifyRequired,
    /// The link is password protected.
    PasswordRequired,
    /// Access is allowed for team members only.
    TeamOnly,
    /// Access is allowed for the shared link's owner only.
    OwnerOnly,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkAccessFailureReason {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkAccessFailureReason;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkAccessFailureReason structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "login_required" => SharedLinkAccessFailureReason::LoginRequired,
                    "email_verify_required" => SharedLinkAccessFailureReason::EmailVerifyRequired,
                    "password_required" => SharedLinkAccessFailureReason::PasswordRequired,
                    "team_only" => SharedLinkAccessFailureReason::TeamOnly,
                    "owner_only" => SharedLinkAccessFailureReason::OwnerOnly,
                    _ => SharedLinkAccessFailureReason::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["login_required",
                                    "email_verify_required",
                                    "password_required",
                                    "team_only",
                                    "owner_only",
                                    "other"];
        deserializer.deserialize_struct("SharedLinkAccessFailureReason", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkAccessFailureReason {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkAccessFailureReason::LoginRequired => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkAccessFailureReason", 1)?;
                s.serialize_field(".tag", "login_required")?;
                s.end()
            }
            SharedLinkAccessFailureReason::EmailVerifyRequired => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkAccessFailureReason", 1)?;
                s.serialize_field(".tag", "email_verify_required")?;
                s.end()
            }
            SharedLinkAccessFailureReason::PasswordRequired => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkAccessFailureReason", 1)?;
                s.serialize_field(".tag", "password_required")?;
                s.end()
            }
            SharedLinkAccessFailureReason::TeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkAccessFailureReason", 1)?;
                s.serialize_field(".tag", "team_only")?;
                s.end()
            }
            SharedLinkAccessFailureReason::OwnerOnly => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkAccessFailureReason", 1)?;
                s.serialize_field(".tag", "owner_only")?;
                s.end()
            }
            SharedLinkAccessFailureReason::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkAlreadyExistsMetadata {
    /// Metadata of the shared link that already exists.
    Metadata(SharedLinkMetadata),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkAlreadyExistsMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkAlreadyExistsMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkAlreadyExistsMetadata structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "metadata" => {
                        match map.next_key()? {
                            Some("metadata") => SharedLinkAlreadyExistsMetadata::Metadata(map.next_value()?),
                            None => return Err(de::Error::missing_field("metadata")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => SharedLinkAlreadyExistsMetadata::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["metadata",
                                    "other"];
        deserializer.deserialize_struct("SharedLinkAlreadyExistsMetadata", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkAlreadyExistsMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkAlreadyExistsMetadata::Metadata(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("SharedLinkAlreadyExistsMetadata", 2)?;
                s.serialize_field(".tag", "metadata")?;
                s.serialize_field("metadata", x)?;
                s.end()
            }
            SharedLinkAlreadyExistsMetadata::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkError {
    /// The shared link wasn't found.
    SharedLinkNotFound,
    /// The caller is not allowed to access this shared link.
    SharedLinkAccessDenied,
    /// This type of link is not supported; use [`files::export()`](super::files::export) instead.
    UnsupportedLinkType,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "shared_link_not_found" => SharedLinkError::SharedLinkNotFound,
                    "shared_link_access_denied" => SharedLinkError::SharedLinkAccessDenied,
                    "unsupported_link_type" => SharedLinkError::UnsupportedLinkType,
                    _ => SharedLinkError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["shared_link_not_found",
                                    "shared_link_access_denied",
                                    "unsupported_link_type",
                                    "other"];
        deserializer.deserialize_struct("SharedLinkError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkError::SharedLinkNotFound => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkError", 1)?;
                s.serialize_field(".tag", "shared_link_not_found")?;
                s.end()
            }
            SharedLinkError::SharedLinkAccessDenied => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkError", 1)?;
                s.serialize_field(".tag", "shared_link_access_denied")?;
                s.end()
            }
            SharedLinkError::UnsupportedLinkType => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkError", 1)?;
                s.serialize_field(".tag", "unsupported_link_type")?;
                s.end()
            }
            SharedLinkError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharedLinkError {
}

impl ::std::fmt::Display for SharedLinkError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SharedLinkError::SharedLinkNotFound => f.write_str("The shared link wasn't found."),
            SharedLinkError::SharedLinkAccessDenied => f.write_str("The caller is not allowed to access this shared link."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// The metadata of a shared link.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkMetadata {
    File(FileLinkMetadata),
    Folder(FolderLinkMetadata),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkMetadata {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // polymorphic struct deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkMetadata;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkMetadata structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                match tag {
                    "file" => Ok(SharedLinkMetadata::File(FileLinkMetadata::internal_deserialize(map)?)),
                    "folder" => Ok(SharedLinkMetadata::Folder(FolderLinkMetadata::internal_deserialize(map)?)),
                    _ => {
                        crate::eat_json_fields(&mut map)?;
                        Ok(SharedLinkMetadata::Other)
                    }
                }
            }
        }
        const VARIANTS: &[&str] = &["file",
                                    "folder"];
        deserializer.deserialize_struct("SharedLinkMetadata", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkMetadata {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // polymorphic struct serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkMetadata::File(ref x) => {
                let mut s = serializer.serialize_struct("SharedLinkMetadata", 13)?;
                s.serialize_field(".tag", "file")?;
                s.serialize_field("url", &x.url)?;
                s.serialize_field("name", &x.name)?;
                s.serialize_field("link_permissions", &x.link_permissions)?;
                s.serialize_field("client_modified", &x.client_modified)?;
                s.serialize_field("server_modified", &x.server_modified)?;
                s.serialize_field("rev", &x.rev)?;
                s.serialize_field("size", &x.size)?;
                s.serialize_field("id", &x.id)?;
                s.serialize_field("expires", &x.expires)?;
                s.serialize_field("path_lower", &x.path_lower)?;
                s.serialize_field("team_member_info", &x.team_member_info)?;
                s.serialize_field("content_owner_team_info", &x.content_owner_team_info)?;
                s.end()
            }
            SharedLinkMetadata::Folder(ref x) => {
                let mut s = serializer.serialize_struct("SharedLinkMetadata", 9)?;
                s.serialize_field(".tag", "folder")?;
                s.serialize_field("url", &x.url)?;
                s.serialize_field("name", &x.name)?;
                s.serialize_field("link_permissions", &x.link_permissions)?;
                s.serialize_field("id", &x.id)?;
                s.serialize_field("expires", &x.expires)?;
                s.serialize_field("path_lower", &x.path_lower)?;
                s.serialize_field("team_member_info", &x.team_member_info)?;
                s.serialize_field("content_owner_team_info", &x.content_owner_team_info)?;
                s.end()
            }
            SharedLinkMetadata::Other => Err(::serde::ser::Error::custom("cannot serialize unknown variant"))
        }
    }
}

/// Who can view shared links in this folder.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharedLinkPolicy {
    /// Links can be shared with anyone.
    Anyone,
    /// Links can be shared with anyone on the same team as the owner.
    Team,
    /// Links can only be shared among members of the shared folder.
    Members,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "anyone" => SharedLinkPolicy::Anyone,
                    "team" => SharedLinkPolicy::Team,
                    "members" => SharedLinkPolicy::Members,
                    _ => SharedLinkPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["anyone",
                                    "team",
                                    "members",
                                    "other"];
        deserializer.deserialize_struct("SharedLinkPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkPolicy::Anyone => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkPolicy", 1)?;
                s.serialize_field(".tag", "anyone")?;
                s.end()
            }
            SharedLinkPolicy::Team => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkPolicy", 1)?;
                s.serialize_field(".tag", "team")?;
                s.end()
            }
            SharedLinkPolicy::Members => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkPolicy", 1)?;
                s.serialize_field(".tag", "members")?;
                s.end()
            }
            SharedLinkPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct SharedLinkSettings {
    /// The requested access for this shared link.
    pub requested_visibility: Option<RequestedVisibility>,
    /// If `requested_visibility` is
    /// [`RequestedVisibility::Password`](RequestedVisibility::Password) this is needed to specify
    /// the password to access the link.
    pub link_password: Option<String>,
    /// Expiration time of the shared link. By default the link won't expire.
    pub expires: Option<super::common::DropboxTimestamp>,
    /// The new audience who can benefit from the access level specified by the link's access level
    /// specified in the `link_access_level` field of `LinkPermissions`. This is used in conjunction
    /// with team policies and shared folder policies to determine the final effective audience type
    /// in the `effective_audience` field of `LinkPermissions.
    pub audience: Option<LinkAudience>,
    /// Requested access level you want the audience to gain from this link. Note, modifying access
    /// level for an existing link is not supported.
    pub access: Option<RequestedLinkAccessLevel>,
}

impl Default for SharedLinkSettings {
    fn default() -> Self {
        SharedLinkSettings {
            requested_visibility: None,
            link_password: None,
            expires: None,
            audience: None,
            access: None,
        }
    }
}

impl SharedLinkSettings {
    pub fn with_requested_visibility(mut self, value: RequestedVisibility) -> Self {
        self.requested_visibility = Some(value);
        self
    }

    pub fn with_link_password(mut self, value: String) -> Self {
        self.link_password = Some(value);
        self
    }

    pub fn with_expires(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.expires = Some(value);
        self
    }

    pub fn with_audience(mut self, value: LinkAudience) -> Self {
        self.audience = Some(value);
        self
    }

    pub fn with_access(mut self, value: RequestedLinkAccessLevel) -> Self {
        self.access = Some(value);
        self
    }
}

const SHARED_LINK_SETTINGS_FIELDS: &[&str] = &["requested_visibility",
                                               "link_password",
                                               "expires",
                                               "audience",
                                               "access"];
impl SharedLinkSettings {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<SharedLinkSettings, V::Error> {
        let mut field_requested_visibility = None;
        let mut field_link_password = None;
        let mut field_expires = None;
        let mut field_audience = None;
        let mut field_access = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "requested_visibility" => {
                    if field_requested_visibility.is_some() {
                        return Err(::serde::de::Error::duplicate_field("requested_visibility"));
                    }
                    field_requested_visibility = Some(map.next_value()?);
                }
                "link_password" => {
                    if field_link_password.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_password"));
                    }
                    field_link_password = Some(map.next_value()?);
                }
                "expires" => {
                    if field_expires.is_some() {
                        return Err(::serde::de::Error::duplicate_field("expires"));
                    }
                    field_expires = Some(map.next_value()?);
                }
                "audience" => {
                    if field_audience.is_some() {
                        return Err(::serde::de::Error::duplicate_field("audience"));
                    }
                    field_audience = Some(map.next_value()?);
                }
                "access" => {
                    if field_access.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access"));
                    }
                    field_access = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = SharedLinkSettings {
            requested_visibility: field_requested_visibility,
            link_password: field_link_password,
            expires: field_expires,
            audience: field_audience,
            access: field_access,
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("requested_visibility", &self.requested_visibility)?;
        s.serialize_field("link_password", &self.link_password)?;
        s.serialize_field("expires", &self.expires)?;
        s.serialize_field("audience", &self.audience)?;
        s.serialize_field("access", &self.access)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkSettings {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = SharedLinkSettings;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkSettings struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                SharedLinkSettings::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("SharedLinkSettings", SHARED_LINK_SETTINGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkSettings {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("SharedLinkSettings", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
pub enum SharedLinkSettingsError {
    /// The given settings are invalid (for example, all attributes of the
    /// [`SharedLinkSettings`](SharedLinkSettings) are empty, the requested visibility is
    /// [`RequestedVisibility::Password`](RequestedVisibility::Password) but the
    /// [`SharedLinkSettings::link_password`](SharedLinkSettings) is missing,
    /// [`SharedLinkSettings::expires`](SharedLinkSettings) is set to the past, etc.).
    InvalidSettings,
    /// User is not allowed to modify the settings of this link. Note that basic users can only set
    /// [`RequestedVisibility::Public`](RequestedVisibility::Public) as the
    /// [`SharedLinkSettings::requested_visibility`](SharedLinkSettings) and cannot set
    /// [`SharedLinkSettings::expires`](SharedLinkSettings).
    NotAuthorized,
}

impl<'de> ::serde::de::Deserialize<'de> for SharedLinkSettingsError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharedLinkSettingsError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharedLinkSettingsError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "invalid_settings" => SharedLinkSettingsError::InvalidSettings,
                    "not_authorized" => SharedLinkSettingsError::NotAuthorized,
                    _ => return Err(de::Error::unknown_variant(tag, VARIANTS))
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["invalid_settings",
                                    "not_authorized"];
        deserializer.deserialize_struct("SharedLinkSettingsError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharedLinkSettingsError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharedLinkSettingsError::InvalidSettings => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "invalid_settings")?;
                s.end()
            }
            SharedLinkSettingsError::NotAuthorized => {
                // unit
                let mut s = serializer.serialize_struct("SharedLinkSettingsError", 1)?;
                s.serialize_field(".tag", "not_authorized")?;
                s.end()
            }
        }
    }
}

impl ::std::error::Error for SharedLinkSettingsError {
}

impl ::std::fmt::Display for SharedLinkSettingsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// User could not access this file.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharingFileAccessError {
    /// Current user does not have sufficient privileges to perform the desired action.
    NoPermission,
    /// File specified was not found.
    InvalidFile,
    /// A folder can't be shared this way. Use folder sharing or a shared link instead.
    IsFolder,
    /// A file inside a public folder can't be shared this way. Use a public link instead.
    InsidePublicFolder,
    /// A Mac OS X package can't be shared this way. Use a shared link instead.
    InsideOsxPackage,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharingFileAccessError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharingFileAccessError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingFileAccessError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "no_permission" => SharingFileAccessError::NoPermission,
                    "invalid_file" => SharingFileAccessError::InvalidFile,
                    "is_folder" => SharingFileAccessError::IsFolder,
                    "inside_public_folder" => SharingFileAccessError::InsidePublicFolder,
                    "inside_osx_package" => SharingFileAccessError::InsideOsxPackage,
                    _ => SharingFileAccessError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["no_permission",
                                    "invalid_file",
                                    "is_folder",
                                    "inside_public_folder",
                                    "inside_osx_package",
                                    "other"];
        deserializer.deserialize_struct("SharingFileAccessError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharingFileAccessError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharingFileAccessError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("SharingFileAccessError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            SharingFileAccessError::InvalidFile => {
                // unit
                let mut s = serializer.serialize_struct("SharingFileAccessError", 1)?;
                s.serialize_field(".tag", "invalid_file")?;
                s.end()
            }
            SharingFileAccessError::IsFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharingFileAccessError", 1)?;
                s.serialize_field(".tag", "is_folder")?;
                s.end()
            }
            SharingFileAccessError::InsidePublicFolder => {
                // unit
                let mut s = serializer.serialize_struct("SharingFileAccessError", 1)?;
                s.serialize_field(".tag", "inside_public_folder")?;
                s.end()
            }
            SharingFileAccessError::InsideOsxPackage => {
                // unit
                let mut s = serializer.serialize_struct("SharingFileAccessError", 1)?;
                s.serialize_field(".tag", "inside_osx_package")?;
                s.end()
            }
            SharingFileAccessError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharingFileAccessError {
}

impl ::std::fmt::Display for SharingFileAccessError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            SharingFileAccessError::NoPermission => f.write_str("Current user does not have sufficient privileges to perform the desired action."),
            SharingFileAccessError::InvalidFile => f.write_str("File specified was not found."),
            SharingFileAccessError::IsFolder => f.write_str("A folder can't be shared this way. Use folder sharing or a shared link instead."),
            SharingFileAccessError::InsidePublicFolder => f.write_str("A file inside a public folder can't be shared this way. Use a public link instead."),
            SharingFileAccessError::InsideOsxPackage => f.write_str("A Mac OS X package can't be shared this way. Use a shared link instead."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// User account had a problem preventing this action.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum SharingUserError {
    /// This user's email address is not verified. This functionality is only available on accounts
    /// with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    EmailUnverified,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for SharingUserError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = SharingUserError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a SharingUserError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "email_unverified" => SharingUserError::EmailUnverified,
                    _ => SharingUserError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["email_unverified",
                                    "other"];
        deserializer.deserialize_struct("SharingUserError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for SharingUserError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            SharingUserError::EmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("SharingUserError", 1)?;
                s.serialize_field(".tag", "email_unverified")?;
                s.end()
            }
            SharingUserError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for SharingUserError {
}

impl ::std::fmt::Display for SharingUserError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "{:?}", *self)
    }
}

/// Information about a team member.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct TeamMemberInfo {
    /// Information about the member's team.
    pub team_info: TeamInfo,
    /// The display name of the user.
    pub display_name: String,
    /// ID of user as a member of a team. This field will only be present if the member is in the
    /// same team as current user.
    pub member_id: Option<String>,
}

impl TeamMemberInfo {
    pub fn new(team_info: TeamInfo, display_name: String) -> Self {
        TeamMemberInfo {
            team_info,
            display_name,
            member_id: None,
        }
    }

    pub fn with_member_id(mut self, value: String) -> Self {
        self.member_id = Some(value);
        self
    }
}

const TEAM_MEMBER_INFO_FIELDS: &[&str] = &["team_info",
                                           "display_name",
                                           "member_id"];
impl TeamMemberInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<TeamMemberInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<TeamMemberInfo>, V::Error> {
        let mut field_team_info = None;
        let mut field_display_name = None;
        let mut field_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "team_info" => {
                    if field_team_info.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_info"));
                    }
                    field_team_info = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                "member_id" => {
                    if field_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_id"));
                    }
                    field_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = TeamMemberInfo {
            team_info: field_team_info.ok_or_else(|| ::serde::de::Error::missing_field("team_info"))?,
            display_name: field_display_name.ok_or_else(|| ::serde::de::Error::missing_field("display_name"))?,
            member_id: field_member_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("team_info", &self.team_info)?;
        s.serialize_field("display_name", &self.display_name)?;
        s.serialize_field("member_id", &self.member_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for TeamMemberInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = TeamMemberInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TeamMemberInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                TeamMemberInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("TeamMemberInfo", TEAM_MEMBER_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for TeamMemberInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("TeamMemberInfo", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct TransferFolderArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// A account or team member ID to transfer ownership to.
    pub to_dropbox_id: DropboxId,
}

impl TransferFolderArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId, to_dropbox_id: DropboxId) -> Self {
        TransferFolderArg {
            shared_folder_id,
            to_dropbox_id,
        }
    }
}

const TRANSFER_FOLDER_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                              "to_dropbox_id"];
impl TransferFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<TransferFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<TransferFolderArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_to_dropbox_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "to_dropbox_id" => {
                    if field_to_dropbox_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("to_dropbox_id"));
                    }
                    field_to_dropbox_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = TransferFolderArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            to_dropbox_id: field_to_dropbox_id.ok_or_else(|| ::serde::de::Error::missing_field("to_dropbox_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("to_dropbox_id", &self.to_dropbox_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for TransferFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = TransferFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TransferFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                TransferFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("TransferFolderArg", TRANSFER_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for TransferFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("TransferFolderArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum TransferFolderError {
    AccessError(SharedFolderAccessError),
    /// [`TransferFolderArg::to_dropbox_id`](TransferFolderArg) is invalid.
    InvalidDropboxId,
    /// The new designated owner is not currently a member of the shared folder.
    NewOwnerNotAMember,
    /// The new designated owner has not added the folder to their Dropbox.
    NewOwnerUnmounted,
    /// The new designated owner's email address is not verified. This functionality is only
    /// available on accounts with a verified email address. Users can verify their email address
    /// [here](https://www.dropbox.com/help/317).
    NewOwnerEmailUnverified,
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for TransferFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = TransferFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a TransferFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => TransferFolderError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "invalid_dropbox_id" => TransferFolderError::InvalidDropboxId,
                    "new_owner_not_a_member" => TransferFolderError::NewOwnerNotAMember,
                    "new_owner_unmounted" => TransferFolderError::NewOwnerUnmounted,
                    "new_owner_email_unverified" => TransferFolderError::NewOwnerEmailUnverified,
                    "team_folder" => TransferFolderError::TeamFolder,
                    "no_permission" => TransferFolderError::NoPermission,
                    _ => TransferFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "invalid_dropbox_id",
                                    "new_owner_not_a_member",
                                    "new_owner_unmounted",
                                    "new_owner_email_unverified",
                                    "team_folder",
                                    "no_permission",
                                    "other"];
        deserializer.deserialize_struct("TransferFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for TransferFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            TransferFolderError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("TransferFolderError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            TransferFolderError::InvalidDropboxId => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "invalid_dropbox_id")?;
                s.end()
            }
            TransferFolderError::NewOwnerNotAMember => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "new_owner_not_a_member")?;
                s.end()
            }
            TransferFolderError::NewOwnerUnmounted => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "new_owner_unmounted")?;
                s.end()
            }
            TransferFolderError::NewOwnerEmailUnverified => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "new_owner_email_unverified")?;
                s.end()
            }
            TransferFolderError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            TransferFolderError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("TransferFolderError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            TransferFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for TransferFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            TransferFolderError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for TransferFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            TransferFolderError::AccessError(inner) => write!(f, "{}", inner),
            TransferFolderError::NewOwnerNotAMember => f.write_str("The new designated owner is not currently a member of the shared folder."),
            TransferFolderError::NewOwnerUnmounted => f.write_str("The new designated owner has not added the folder to their Dropbox."),
            TransferFolderError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            TransferFolderError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UnmountFolderArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
}

impl UnmountFolderArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        UnmountFolderArg {
            shared_folder_id,
        }
    }
}

const UNMOUNT_FOLDER_ARG_FIELDS: &[&str] = &["shared_folder_id"];
impl UnmountFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UnmountFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UnmountFolderArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UnmountFolderArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UnmountFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UnmountFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnmountFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UnmountFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UnmountFolderArg", UNMOUNT_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UnmountFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UnmountFolderArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UnmountFolderError {
    AccessError(SharedFolderAccessError),
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// The shared folder can't be unmounted. One example where this can occur is when the shared
    /// folder's parent folder is also a shared folder that resides in the current user's Dropbox.
    NotUnmountable,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UnmountFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UnmountFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnmountFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => UnmountFolderError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_permission" => UnmountFolderError::NoPermission,
                    "not_unmountable" => UnmountFolderError::NotUnmountable,
                    _ => UnmountFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "no_permission",
                                    "not_unmountable",
                                    "other"];
        deserializer.deserialize_struct("UnmountFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UnmountFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UnmountFolderError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UnmountFolderError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            UnmountFolderError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("UnmountFolderError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            UnmountFolderError::NotUnmountable => {
                // unit
                let mut s = serializer.serialize_struct("UnmountFolderError", 1)?;
                s.serialize_field(".tag", "not_unmountable")?;
                s.end()
            }
            UnmountFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UnmountFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UnmountFolderError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UnmountFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UnmountFolderError::AccessError(inner) => write!(f, "{}", inner),
            UnmountFolderError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            UnmountFolderError::NotUnmountable => f.write_str("The shared folder can't be unmounted. One example where this can occur is when the shared folder's parent folder is also a shared folder that resides in the current user's Dropbox."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Arguments for [`unshare_file()`](unshare_file).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UnshareFileArg {
    /// The file to unshare.
    pub file: PathOrId,
}

impl UnshareFileArg {
    pub fn new(file: PathOrId) -> Self {
        UnshareFileArg {
            file,
        }
    }
}

const UNSHARE_FILE_ARG_FIELDS: &[&str] = &["file"];
impl UnshareFileArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UnshareFileArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UnshareFileArg>, V::Error> {
        let mut field_file = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UnshareFileArg {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UnshareFileArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UnshareFileArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnshareFileArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UnshareFileArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UnshareFileArg", UNSHARE_FILE_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UnshareFileArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UnshareFileArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Error result for [`unshare_file()`](unshare_file).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UnshareFileError {
    UserError(SharingUserError),
    AccessError(SharingFileAccessError),
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UnshareFileError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UnshareFileError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnshareFileError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "user_error" => {
                        match map.next_key()? {
                            Some("user_error") => UnshareFileError::UserError(map.next_value()?),
                            None => return Err(de::Error::missing_field("user_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => UnshareFileError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    _ => UnshareFileError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["user_error",
                                    "access_error",
                                    "other"];
        deserializer.deserialize_struct("UnshareFileError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UnshareFileError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UnshareFileError::UserError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UnshareFileError", 2)?;
                s.serialize_field(".tag", "user_error")?;
                s.serialize_field("user_error", x)?;
                s.end()
            }
            UnshareFileError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UnshareFileError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            UnshareFileError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UnshareFileError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UnshareFileError::UserError(inner) => Some(inner),
            UnshareFileError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UnshareFileError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UnshareFileError::UserError(inner) => write!(f, "{}", inner),
            UnshareFileError::AccessError(inner) => write!(f, "{}", inner),
            _ => write!(f, "{:?}", *self),
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UnshareFolderArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// If true, members of this shared folder will get a copy of this folder after it's unshared.
    /// Otherwise, it will be removed from their Dropbox. The current user, who is an owner, will
    /// always retain their copy.
    pub leave_a_copy: bool,
}

impl UnshareFolderArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        UnshareFolderArg {
            shared_folder_id,
            leave_a_copy: false,
        }
    }

    pub fn with_leave_a_copy(mut self, value: bool) -> Self {
        self.leave_a_copy = value;
        self
    }
}

const UNSHARE_FOLDER_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                             "leave_a_copy"];
impl UnshareFolderArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UnshareFolderArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UnshareFolderArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_leave_a_copy = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "leave_a_copy" => {
                    if field_leave_a_copy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("leave_a_copy"));
                    }
                    field_leave_a_copy = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UnshareFolderArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            leave_a_copy: field_leave_a_copy.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("leave_a_copy", &self.leave_a_copy)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UnshareFolderArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UnshareFolderArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnshareFolderArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UnshareFolderArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UnshareFolderArg", UNSHARE_FOLDER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UnshareFolderArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UnshareFolderArg", 2)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UnshareFolderError {
    AccessError(SharedFolderAccessError),
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// This shared folder has too many files to be unshared.
    TooManyFiles,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UnshareFolderError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UnshareFolderError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UnshareFolderError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => UnshareFolderError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "team_folder" => UnshareFolderError::TeamFolder,
                    "no_permission" => UnshareFolderError::NoPermission,
                    "too_many_files" => UnshareFolderError::TooManyFiles,
                    _ => UnshareFolderError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "team_folder",
                                    "no_permission",
                                    "too_many_files",
                                    "other"];
        deserializer.deserialize_struct("UnshareFolderError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UnshareFolderError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UnshareFolderError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UnshareFolderError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            UnshareFolderError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("UnshareFolderError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            UnshareFolderError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("UnshareFolderError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            UnshareFolderError::TooManyFiles => {
                // unit
                let mut s = serializer.serialize_struct("UnshareFolderError", 1)?;
                s.serialize_field(".tag", "too_many_files")?;
                s.end()
            }
            UnshareFolderError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UnshareFolderError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UnshareFolderError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UnshareFolderError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UnshareFolderError::AccessError(inner) => write!(f, "{}", inner),
            UnshareFolderError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            UnshareFolderError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            UnshareFolderError::TooManyFiles => f.write_str("This shared folder has too many files to be unshared."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// Arguments for [`update_file_member()`](update_file_member).
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UpdateFileMemberArgs {
    /// File for which we are changing a member's access.
    pub file: PathOrId,
    /// The member whose access we are changing.
    pub member: MemberSelector,
    /// The new access level for the member.
    pub access_level: AccessLevel,
}

impl UpdateFileMemberArgs {
    pub fn new(file: PathOrId, member: MemberSelector, access_level: AccessLevel) -> Self {
        UpdateFileMemberArgs {
            file,
            member,
            access_level,
        }
    }
}

const UPDATE_FILE_MEMBER_ARGS_FIELDS: &[&str] = &["file",
                                                  "member",
                                                  "access_level"];
impl UpdateFileMemberArgs {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UpdateFileMemberArgs, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UpdateFileMemberArgs>, V::Error> {
        let mut field_file = None;
        let mut field_member = None;
        let mut field_access_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "file" => {
                    if field_file.is_some() {
                        return Err(::serde::de::Error::duplicate_field("file"));
                    }
                    field_file = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UpdateFileMemberArgs {
            file: field_file.ok_or_else(|| ::serde::de::Error::missing_field("file"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            access_level: field_access_level.ok_or_else(|| ::serde::de::Error::missing_field("access_level"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("file", &self.file)?;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("access_level", &self.access_level)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFileMemberArgs {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UpdateFileMemberArgs;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFileMemberArgs struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UpdateFileMemberArgs::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UpdateFileMemberArgs", UPDATE_FILE_MEMBER_ARGS_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFileMemberArgs {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UpdateFileMemberArgs", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UpdateFolderMemberArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// The member of the shared folder to update.  Only the
    /// [`MemberSelector::DropboxId`](MemberSelector::DropboxId) may be set at this time.
    pub member: MemberSelector,
    /// The new access level for `member`. [`AccessLevel::Owner`](AccessLevel::Owner) is disallowed.
    pub access_level: AccessLevel,
}

impl UpdateFolderMemberArg {
    pub fn new(
        shared_folder_id: super::common::SharedFolderId,
        member: MemberSelector,
        access_level: AccessLevel,
    ) -> Self {
        UpdateFolderMemberArg {
            shared_folder_id,
            member,
            access_level,
        }
    }
}

const UPDATE_FOLDER_MEMBER_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                   "member",
                                                   "access_level"];
impl UpdateFolderMemberArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UpdateFolderMemberArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UpdateFolderMemberArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_member = None;
        let mut field_access_level = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "member" => {
                    if field_member.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member"));
                    }
                    field_member = Some(map.next_value()?);
                }
                "access_level" => {
                    if field_access_level.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_level"));
                    }
                    field_access_level = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UpdateFolderMemberArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            member: field_member.ok_or_else(|| ::serde::de::Error::missing_field("member"))?,
            access_level: field_access_level.ok_or_else(|| ::serde::de::Error::missing_field("access_level"))?,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("member", &self.member)?;
        s.serialize_field("access_level", &self.access_level)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFolderMemberArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UpdateFolderMemberArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFolderMemberArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UpdateFolderMemberArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UpdateFolderMemberArg", UPDATE_FOLDER_MEMBER_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFolderMemberArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UpdateFolderMemberArg", 3)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UpdateFolderMemberError {
    AccessError(SharedFolderAccessError),
    MemberError(SharedFolderMemberError),
    /// If updating the access type required the member to be added to the shared folder and there
    /// was an error when adding the member.
    NoExplicitAccess(AddFolderMemberError),
    /// The current user's account doesn't support this action. An example of this is when
    /// downgrading a member from editor to viewer. This action can only be performed by users that
    /// have upgraded to a Pro or Business plan.
    InsufficientPlan,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFolderMemberError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UpdateFolderMemberError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFolderMemberError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => UpdateFolderMemberError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "member_error" => {
                        match map.next_key()? {
                            Some("member_error") => UpdateFolderMemberError::MemberError(map.next_value()?),
                            None => return Err(de::Error::missing_field("member_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "no_explicit_access" => {
                        match map.next_key()? {
                            Some("no_explicit_access") => UpdateFolderMemberError::NoExplicitAccess(map.next_value()?),
                            None => return Err(de::Error::missing_field("no_explicit_access")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "insufficient_plan" => UpdateFolderMemberError::InsufficientPlan,
                    "no_permission" => UpdateFolderMemberError::NoPermission,
                    _ => UpdateFolderMemberError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "member_error",
                                    "no_explicit_access",
                                    "insufficient_plan",
                                    "no_permission",
                                    "other"];
        deserializer.deserialize_struct("UpdateFolderMemberError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFolderMemberError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UpdateFolderMemberError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UpdateFolderMemberError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            UpdateFolderMemberError::MemberError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UpdateFolderMemberError", 2)?;
                s.serialize_field(".tag", "member_error")?;
                s.serialize_field("member_error", x)?;
                s.end()
            }
            UpdateFolderMemberError::NoExplicitAccess(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UpdateFolderMemberError", 2)?;
                s.serialize_field(".tag", "no_explicit_access")?;
                s.serialize_field("no_explicit_access", x)?;
                s.end()
            }
            UpdateFolderMemberError::InsufficientPlan => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderMemberError", 1)?;
                s.serialize_field(".tag", "insufficient_plan")?;
                s.end()
            }
            UpdateFolderMemberError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderMemberError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            UpdateFolderMemberError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UpdateFolderMemberError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UpdateFolderMemberError::AccessError(inner) => Some(inner),
            UpdateFolderMemberError::MemberError(inner) => Some(inner),
            UpdateFolderMemberError::NoExplicitAccess(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UpdateFolderMemberError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UpdateFolderMemberError::AccessError(inner) => write!(f, "{}", inner),
            UpdateFolderMemberError::MemberError(inner) => write!(f, "{}", inner),
            UpdateFolderMemberError::NoExplicitAccess(inner) => write!(f, "If updating the access type required the member to be added to the shared folder and there was an error when adding the member: {}", inner),
            UpdateFolderMemberError::InsufficientPlan => f.write_str("The current user's account doesn't support this action. An example of this is when downgrading a member from editor to viewer. This action can only be performed by users that have upgraded to a Pro or Business plan."),
            UpdateFolderMemberError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// If any of the policies are unset, then they retain their current setting.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UpdateFolderPolicyArg {
    /// The ID for the shared folder.
    pub shared_folder_id: super::common::SharedFolderId,
    /// Who can be a member of this shared folder. Only applicable if the current user is on a team.
    pub member_policy: Option<MemberPolicy>,
    /// Who can add and remove members of this shared folder.
    pub acl_update_policy: Option<AclUpdatePolicy>,
    /// Who can enable/disable viewer info for this shared folder.
    pub viewer_info_policy: Option<ViewerInfoPolicy>,
    /// The policy to apply to shared links created for content inside this shared folder. The
    /// current user must be on a team to set this policy to
    /// [`SharedLinkPolicy::Members`](SharedLinkPolicy::Members).
    pub shared_link_policy: Option<SharedLinkPolicy>,
    /// Settings on the link for this folder.
    pub link_settings: Option<LinkSettings>,
    /// A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the
    /// response's [`SharedFolderMetadata::permissions`](SharedFolderMetadata) field describing the
    /// actions the  authenticated user can perform on the folder.
    pub actions: Option<Vec<FolderAction>>,
}

impl UpdateFolderPolicyArg {
    pub fn new(shared_folder_id: super::common::SharedFolderId) -> Self {
        UpdateFolderPolicyArg {
            shared_folder_id,
            member_policy: None,
            acl_update_policy: None,
            viewer_info_policy: None,
            shared_link_policy: None,
            link_settings: None,
            actions: None,
        }
    }

    pub fn with_member_policy(mut self, value: MemberPolicy) -> Self {
        self.member_policy = Some(value);
        self
    }

    pub fn with_acl_update_policy(mut self, value: AclUpdatePolicy) -> Self {
        self.acl_update_policy = Some(value);
        self
    }

    pub fn with_viewer_info_policy(mut self, value: ViewerInfoPolicy) -> Self {
        self.viewer_info_policy = Some(value);
        self
    }

    pub fn with_shared_link_policy(mut self, value: SharedLinkPolicy) -> Self {
        self.shared_link_policy = Some(value);
        self
    }

    pub fn with_link_settings(mut self, value: LinkSettings) -> Self {
        self.link_settings = Some(value);
        self
    }

    pub fn with_actions(mut self, value: Vec<FolderAction>) -> Self {
        self.actions = Some(value);
        self
    }
}

const UPDATE_FOLDER_POLICY_ARG_FIELDS: &[&str] = &["shared_folder_id",
                                                   "member_policy",
                                                   "acl_update_policy",
                                                   "viewer_info_policy",
                                                   "shared_link_policy",
                                                   "link_settings",
                                                   "actions"];
impl UpdateFolderPolicyArg {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UpdateFolderPolicyArg, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UpdateFolderPolicyArg>, V::Error> {
        let mut field_shared_folder_id = None;
        let mut field_member_policy = None;
        let mut field_acl_update_policy = None;
        let mut field_viewer_info_policy = None;
        let mut field_shared_link_policy = None;
        let mut field_link_settings = None;
        let mut field_actions = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "shared_folder_id" => {
                    if field_shared_folder_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_folder_id"));
                    }
                    field_shared_folder_id = Some(map.next_value()?);
                }
                "member_policy" => {
                    if field_member_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("member_policy"));
                    }
                    field_member_policy = Some(map.next_value()?);
                }
                "acl_update_policy" => {
                    if field_acl_update_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("acl_update_policy"));
                    }
                    field_acl_update_policy = Some(map.next_value()?);
                }
                "viewer_info_policy" => {
                    if field_viewer_info_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("viewer_info_policy"));
                    }
                    field_viewer_info_policy = Some(map.next_value()?);
                }
                "shared_link_policy" => {
                    if field_shared_link_policy.is_some() {
                        return Err(::serde::de::Error::duplicate_field("shared_link_policy"));
                    }
                    field_shared_link_policy = Some(map.next_value()?);
                }
                "link_settings" => {
                    if field_link_settings.is_some() {
                        return Err(::serde::de::Error::duplicate_field("link_settings"));
                    }
                    field_link_settings = Some(map.next_value()?);
                }
                "actions" => {
                    if field_actions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("actions"));
                    }
                    field_actions = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UpdateFolderPolicyArg {
            shared_folder_id: field_shared_folder_id.ok_or_else(|| ::serde::de::Error::missing_field("shared_folder_id"))?,
            member_policy: field_member_policy,
            acl_update_policy: field_acl_update_policy,
            viewer_info_policy: field_viewer_info_policy,
            shared_link_policy: field_shared_link_policy,
            link_settings: field_link_settings,
            actions: field_actions,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("shared_folder_id", &self.shared_folder_id)?;
        s.serialize_field("member_policy", &self.member_policy)?;
        s.serialize_field("acl_update_policy", &self.acl_update_policy)?;
        s.serialize_field("viewer_info_policy", &self.viewer_info_policy)?;
        s.serialize_field("shared_link_policy", &self.shared_link_policy)?;
        s.serialize_field("link_settings", &self.link_settings)?;
        s.serialize_field("actions", &self.actions)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFolderPolicyArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UpdateFolderPolicyArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFolderPolicyArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UpdateFolderPolicyArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UpdateFolderPolicyArg", UPDATE_FOLDER_POLICY_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFolderPolicyArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UpdateFolderPolicyArg", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum UpdateFolderPolicyError {
    AccessError(SharedFolderAccessError),
    /// [`UpdateFolderPolicyArg::member_policy`](UpdateFolderPolicyArg) was set even though user is
    /// not on a team.
    NotOnTeam,
    /// Team policy is more restrictive than [`ShareFolderArg::member_policy`](ShareFolderArg).
    TeamPolicyDisallowsMemberPolicy,
    /// The current account is not allowed to select the specified
    /// [`ShareFolderArg::shared_link_policy`](ShareFolderArg).
    DisallowedSharedLinkPolicy,
    /// The current user does not have permission to perform this action.
    NoPermission,
    /// This action cannot be performed on a team shared folder.
    TeamFolder,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for UpdateFolderPolicyError {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = UpdateFolderPolicyError;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UpdateFolderPolicyError structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "access_error" => {
                        match map.next_key()? {
                            Some("access_error") => UpdateFolderPolicyError::AccessError(map.next_value()?),
                            None => return Err(de::Error::missing_field("access_error")),
                            _ => return Err(de::Error::unknown_field(tag, VARIANTS))
                        }
                    }
                    "not_on_team" => UpdateFolderPolicyError::NotOnTeam,
                    "team_policy_disallows_member_policy" => UpdateFolderPolicyError::TeamPolicyDisallowsMemberPolicy,
                    "disallowed_shared_link_policy" => UpdateFolderPolicyError::DisallowedSharedLinkPolicy,
                    "no_permission" => UpdateFolderPolicyError::NoPermission,
                    "team_folder" => UpdateFolderPolicyError::TeamFolder,
                    _ => UpdateFolderPolicyError::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["access_error",
                                    "not_on_team",
                                    "team_policy_disallows_member_policy",
                                    "disallowed_shared_link_policy",
                                    "no_permission",
                                    "team_folder",
                                    "other"];
        deserializer.deserialize_struct("UpdateFolderPolicyError", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for UpdateFolderPolicyError {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            UpdateFolderPolicyError::AccessError(ref x) => {
                // union or polymporphic struct
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 2)?;
                s.serialize_field(".tag", "access_error")?;
                s.serialize_field("access_error", x)?;
                s.end()
            }
            UpdateFolderPolicyError::NotOnTeam => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 1)?;
                s.serialize_field(".tag", "not_on_team")?;
                s.end()
            }
            UpdateFolderPolicyError::TeamPolicyDisallowsMemberPolicy => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 1)?;
                s.serialize_field(".tag", "team_policy_disallows_member_policy")?;
                s.end()
            }
            UpdateFolderPolicyError::DisallowedSharedLinkPolicy => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 1)?;
                s.serialize_field(".tag", "disallowed_shared_link_policy")?;
                s.end()
            }
            UpdateFolderPolicyError::NoPermission => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 1)?;
                s.serialize_field(".tag", "no_permission")?;
                s.end()
            }
            UpdateFolderPolicyError::TeamFolder => {
                // unit
                let mut s = serializer.serialize_struct("UpdateFolderPolicyError", 1)?;
                s.serialize_field(".tag", "team_folder")?;
                s.end()
            }
            UpdateFolderPolicyError::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

impl ::std::error::Error for UpdateFolderPolicyError {
    fn source(&self) -> Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            UpdateFolderPolicyError::AccessError(inner) => Some(inner),
            _ => None,
        }
    }
}

impl ::std::fmt::Display for UpdateFolderPolicyError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            UpdateFolderPolicyError::AccessError(inner) => write!(f, "{}", inner),
            UpdateFolderPolicyError::NoPermission => f.write_str("The current user does not have permission to perform this action."),
            UpdateFolderPolicyError::TeamFolder => f.write_str("This action cannot be performed on a team shared folder."),
            _ => write!(f, "{:?}", *self),
        }
    }
}

/// The information about a user member of the shared content with an appended last seen timestamp.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserFileMembershipInfo {
    /// The access type for this member. It contains inherited access type from parent folder, and
    /// acquired access type from this folder.
    pub access_type: AccessLevel,
    /// The account information for the membership user.
    pub user: UserInfo,
    /// The permissions that requesting user has on this member. The set of permissions corresponds
    /// to the MemberActions in the request.
    pub permissions: Option<Vec<MemberPermission>>,
    /// Never set.
    pub initials: Option<String>,
    /// True if the member has access from a parent folder.
    pub is_inherited: bool,
    /// The UTC timestamp of when the user has last seen the content, if they have.
    pub time_last_seen: Option<super::common::DropboxTimestamp>,
    /// The platform on which the user has last seen the content, or unknown.
    pub platform_type: Option<super::seen_state::PlatformType>,
}

impl UserFileMembershipInfo {
    pub fn new(access_type: AccessLevel, user: UserInfo) -> Self {
        UserFileMembershipInfo {
            access_type,
            user,
            permissions: None,
            initials: None,
            is_inherited: false,
            time_last_seen: None,
            platform_type: None,
        }
    }

    pub fn with_permissions(mut self, value: Vec<MemberPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_initials(mut self, value: String) -> Self {
        self.initials = Some(value);
        self
    }

    pub fn with_is_inherited(mut self, value: bool) -> Self {
        self.is_inherited = value;
        self
    }

    pub fn with_time_last_seen(mut self, value: super::common::DropboxTimestamp) -> Self {
        self.time_last_seen = Some(value);
        self
    }

    pub fn with_platform_type(mut self, value: super::seen_state::PlatformType) -> Self {
        self.platform_type = Some(value);
        self
    }
}

const USER_FILE_MEMBERSHIP_INFO_FIELDS: &[&str] = &["access_type",
                                                    "user",
                                                    "permissions",
                                                    "initials",
                                                    "is_inherited",
                                                    "time_last_seen",
                                                    "platform_type"];
impl UserFileMembershipInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserFileMembershipInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserFileMembershipInfo>, V::Error> {
        let mut field_access_type = None;
        let mut field_user = None;
        let mut field_permissions = None;
        let mut field_initials = None;
        let mut field_is_inherited = None;
        let mut field_time_last_seen = None;
        let mut field_platform_type = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "initials" => {
                    if field_initials.is_some() {
                        return Err(::serde::de::Error::duplicate_field("initials"));
                    }
                    field_initials = Some(map.next_value()?);
                }
                "is_inherited" => {
                    if field_is_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inherited"));
                    }
                    field_is_inherited = Some(map.next_value()?);
                }
                "time_last_seen" => {
                    if field_time_last_seen.is_some() {
                        return Err(::serde::de::Error::duplicate_field("time_last_seen"));
                    }
                    field_time_last_seen = Some(map.next_value()?);
                }
                "platform_type" => {
                    if field_platform_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("platform_type"));
                    }
                    field_platform_type = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserFileMembershipInfo {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            permissions: field_permissions,
            initials: field_initials,
            is_inherited: field_is_inherited.unwrap_or(false),
            time_last_seen: field_time_last_seen,
            platform_type: field_platform_type,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("initials", &self.initials)?;
        s.serialize_field("is_inherited", &self.is_inherited)?;
        s.serialize_field("time_last_seen", &self.time_last_seen)?;
        s.serialize_field("platform_type", &self.platform_type)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserFileMembershipInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserFileMembershipInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserFileMembershipInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserFileMembershipInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserFileMembershipInfo", USER_FILE_MEMBERSHIP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserFileMembershipInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserFileMembershipInfo", 7)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// Basic information about a user. Use [`users::get_account()`](super::users::get_account) and
/// [`users::get_account_batch()`](super::users::get_account_batch) to obtain more detailed
/// information.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserInfo {
    /// The account ID of the user.
    pub account_id: super::users_common::AccountId,
    /// Email address of user.
    pub email: String,
    /// The display name of the user.
    pub display_name: String,
    /// If the user is in the same team as current user.
    pub same_team: bool,
    /// The team member ID of the shared folder member. Only present if `same_team` is true.
    pub team_member_id: Option<String>,
}

impl UserInfo {
    pub fn new(
        account_id: super::users_common::AccountId,
        email: String,
        display_name: String,
        same_team: bool,
    ) -> Self {
        UserInfo {
            account_id,
            email,
            display_name,
            same_team,
            team_member_id: None,
        }
    }

    pub fn with_team_member_id(mut self, value: String) -> Self {
        self.team_member_id = Some(value);
        self
    }
}

const USER_INFO_FIELDS: &[&str] = &["account_id",
                                    "email",
                                    "display_name",
                                    "same_team",
                                    "team_member_id"];
impl UserInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserInfo>, V::Error> {
        let mut field_account_id = None;
        let mut field_email = None;
        let mut field_display_name = None;
        let mut field_same_team = None;
        let mut field_team_member_id = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "account_id" => {
                    if field_account_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("account_id"));
                    }
                    field_account_id = Some(map.next_value()?);
                }
                "email" => {
                    if field_email.is_some() {
                        return Err(::serde::de::Error::duplicate_field("email"));
                    }
                    field_email = Some(map.next_value()?);
                }
                "display_name" => {
                    if field_display_name.is_some() {
                        return Err(::serde::de::Error::duplicate_field("display_name"));
                    }
                    field_display_name = Some(map.next_value()?);
                }
                "same_team" => {
                    if field_same_team.is_some() {
                        return Err(::serde::de::Error::duplicate_field("same_team"));
                    }
                    field_same_team = Some(map.next_value()?);
                }
                "team_member_id" => {
                    if field_team_member_id.is_some() {
                        return Err(::serde::de::Error::duplicate_field("team_member_id"));
                    }
                    field_team_member_id = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserInfo {
            account_id: field_account_id.ok_or_else(|| ::serde::de::Error::missing_field("account_id"))?,
            email: field_email.ok_or_else(|| ::serde::de::Error::missing_field("email"))?,
            display_name: field_display_name.ok_or_else(|| ::serde::de::Error::missing_field("display_name"))?,
            same_team: field_same_team.ok_or_else(|| ::serde::de::Error::missing_field("same_team"))?,
            team_member_id: field_team_member_id,
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("account_id", &self.account_id)?;
        s.serialize_field("email", &self.email)?;
        s.serialize_field("display_name", &self.display_name)?;
        s.serialize_field("same_team", &self.same_team)?;
        s.serialize_field("team_member_id", &self.team_member_id)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserInfo", USER_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserInfo", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// The information about a user member of the shared content.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct UserMembershipInfo {
    /// The access type for this member. It contains inherited access type from parent folder, and
    /// acquired access type from this folder.
    pub access_type: AccessLevel,
    /// The account information for the membership user.
    pub user: UserInfo,
    /// The permissions that requesting user has on this member. The set of permissions corresponds
    /// to the MemberActions in the request.
    pub permissions: Option<Vec<MemberPermission>>,
    /// Never set.
    pub initials: Option<String>,
    /// True if the member has access from a parent folder.
    pub is_inherited: bool,
}

impl UserMembershipInfo {
    pub fn new(access_type: AccessLevel, user: UserInfo) -> Self {
        UserMembershipInfo {
            access_type,
            user,
            permissions: None,
            initials: None,
            is_inherited: false,
        }
    }

    pub fn with_permissions(mut self, value: Vec<MemberPermission>) -> Self {
        self.permissions = Some(value);
        self
    }

    pub fn with_initials(mut self, value: String) -> Self {
        self.initials = Some(value);
        self
    }

    pub fn with_is_inherited(mut self, value: bool) -> Self {
        self.is_inherited = value;
        self
    }
}

const USER_MEMBERSHIP_INFO_FIELDS: &[&str] = &["access_type",
                                               "user",
                                               "permissions",
                                               "initials",
                                               "is_inherited"];
impl UserMembershipInfo {
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        map: V,
    ) -> Result<UserMembershipInfo, V::Error> {
        Self::internal_deserialize_opt(map, false).map(Option::unwrap)
    }

    pub(crate) fn internal_deserialize_opt<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
        optional: bool,
    ) -> Result<Option<UserMembershipInfo>, V::Error> {
        let mut field_access_type = None;
        let mut field_user = None;
        let mut field_permissions = None;
        let mut field_initials = None;
        let mut field_is_inherited = None;
        let mut nothing = true;
        while let Some(key) = map.next_key::<&str>()? {
            nothing = false;
            match key {
                "access_type" => {
                    if field_access_type.is_some() {
                        return Err(::serde::de::Error::duplicate_field("access_type"));
                    }
                    field_access_type = Some(map.next_value()?);
                }
                "user" => {
                    if field_user.is_some() {
                        return Err(::serde::de::Error::duplicate_field("user"));
                    }
                    field_user = Some(map.next_value()?);
                }
                "permissions" => {
                    if field_permissions.is_some() {
                        return Err(::serde::de::Error::duplicate_field("permissions"));
                    }
                    field_permissions = Some(map.next_value()?);
                }
                "initials" => {
                    if field_initials.is_some() {
                        return Err(::serde::de::Error::duplicate_field("initials"));
                    }
                    field_initials = Some(map.next_value()?);
                }
                "is_inherited" => {
                    if field_is_inherited.is_some() {
                        return Err(::serde::de::Error::duplicate_field("is_inherited"));
                    }
                    field_is_inherited = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        if optional && nothing {
            return Ok(None);
        }
        let result = UserMembershipInfo {
            access_type: field_access_type.ok_or_else(|| ::serde::de::Error::missing_field("access_type"))?,
            user: field_user.ok_or_else(|| ::serde::de::Error::missing_field("user"))?,
            permissions: field_permissions,
            initials: field_initials,
            is_inherited: field_is_inherited.unwrap_or(false),
        };
        Ok(Some(result))
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("access_type", &self.access_type)?;
        s.serialize_field("user", &self.user)?;
        s.serialize_field("permissions", &self.permissions)?;
        s.serialize_field("initials", &self.initials)?;
        s.serialize_field("is_inherited", &self.is_inherited)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for UserMembershipInfo {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = UserMembershipInfo;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a UserMembershipInfo struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                UserMembershipInfo::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("UserMembershipInfo", USER_MEMBERSHIP_INFO_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for UserMembershipInfo {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("UserMembershipInfo", 5)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum ViewerInfoPolicy {
    /// Viewer information is available on this file.
    Enabled,
    /// Viewer information is disabled on this file.
    Disabled,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for ViewerInfoPolicy {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = ViewerInfoPolicy;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a ViewerInfoPolicy structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "enabled" => ViewerInfoPolicy::Enabled,
                    "disabled" => ViewerInfoPolicy::Disabled,
                    _ => ViewerInfoPolicy::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["enabled",
                                    "disabled",
                                    "other"];
        deserializer.deserialize_struct("ViewerInfoPolicy", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for ViewerInfoPolicy {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            ViewerInfoPolicy::Enabled => {
                // unit
                let mut s = serializer.serialize_struct("ViewerInfoPolicy", 1)?;
                s.serialize_field(".tag", "enabled")?;
                s.end()
            }
            ViewerInfoPolicy::Disabled => {
                // unit
                let mut s = serializer.serialize_struct("ViewerInfoPolicy", 1)?;
                s.serialize_field(".tag", "disabled")?;
                s.end()
            }
            ViewerInfoPolicy::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

/// Who can access a shared link. The most open visibility is [`Public`](Visibility::Public). The
/// default depends on many aspects, such as team and user preferences and shared folder settings.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // variants may be added in the future
pub enum Visibility {
    /// Anyone who has received the link can access it. No login required.
    Public,
    /// Only members of the same team can access the link. Login is required.
    TeamOnly,
    /// A link-specific password is required to access the link. Login is not required.
    Password,
    /// Only members of the same team who have the link-specific password can access the link.
    TeamAndPassword,
    /// Only members of the shared folder containing the linked file can access the link. Login is
    /// required.
    SharedFolderOnly,
    /// Catch-all used for unrecognized values returned from the server. Encountering this value
    /// typically indicates that this SDK version is out of date.
    Other,
}

impl<'de> ::serde::de::Deserialize<'de> for Visibility {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // union deserializer
        use serde::de::{self, MapAccess, Visitor};
        struct EnumVisitor;
        impl<'de> Visitor<'de> for EnumVisitor {
            type Value = Visibility;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a Visibility structure")
            }
            fn visit_map<V: MapAccess<'de>>(self, mut map: V) -> Result<Self::Value, V::Error> {
                let tag: &str = match map.next_key()? {
                    Some(".tag") => map.next_value()?,
                    _ => return Err(de::Error::missing_field(".tag"))
                };
                let value = match tag {
                    "public" => Visibility::Public,
                    "team_only" => Visibility::TeamOnly,
                    "password" => Visibility::Password,
                    "team_and_password" => Visibility::TeamAndPassword,
                    "shared_folder_only" => Visibility::SharedFolderOnly,
                    _ => Visibility::Other,
                };
                crate::eat_json_fields(&mut map)?;
                Ok(value)
            }
        }
        const VARIANTS: &[&str] = &["public",
                                    "team_only",
                                    "password",
                                    "team_and_password",
                                    "shared_folder_only",
                                    "other"];
        deserializer.deserialize_struct("Visibility", VARIANTS, EnumVisitor)
    }
}

impl ::serde::ser::Serialize for Visibility {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // union serializer
        use serde::ser::SerializeStruct;
        match *self {
            Visibility::Public => {
                // unit
                let mut s = serializer.serialize_struct("Visibility", 1)?;
                s.serialize_field(".tag", "public")?;
                s.end()
            }
            Visibility::TeamOnly => {
                // unit
                let mut s = serializer.serialize_struct("Visibility", 1)?;
                s.serialize_field(".tag", "team_only")?;
                s.end()
            }
            Visibility::Password => {
                // unit
                let mut s = serializer.serialize_struct("Visibility", 1)?;
                s.serialize_field(".tag", "password")?;
                s.end()
            }
            Visibility::TeamAndPassword => {
                // unit
                let mut s = serializer.serialize_struct("Visibility", 1)?;
                s.serialize_field(".tag", "team_and_password")?;
                s.end()
            }
            Visibility::SharedFolderOnly => {
                // unit
                let mut s = serializer.serialize_struct("Visibility", 1)?;
                s.serialize_field(".tag", "shared_folder_only")?;
                s.end()
            }
            Visibility::Other => Err(::serde::ser::Error::custom("cannot serialize 'Other' variant"))
        }
    }
}

