// DO NOT EDIT
// This file was @generated by Stone

#![allow(
    clippy::too_many_arguments,
    clippy::large_enum_variant,
    clippy::doc_markdown,
)]

/// This endpoint performs App Authentication, validating the supplied app key and secret, and
/// returns the supplied string, to allow you to test your code and connection to the Dropbox API.
/// It has no other effect. If you receive an HTTP 200 response with the supplied query, it
/// indicates at least part of the Dropbox API infrastructure is working and that the app key and
/// secret valid.
pub fn app(
    client: &impl crate::client_trait::AppAuthClient,
    arg: &EchoArg,
) -> crate::Result<Result<EchoResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "check/app",
        arg,
        None)
}

/// This endpoint performs User Authentication, validating the supplied access token, and returns
/// the supplied string, to allow you to test your code and connection to the Dropbox API. It has no
/// other effect. If you receive an HTTP 200 response with the supplied query, it indicates at least
/// part of the Dropbox API infrastructure is working and that the access token is valid.
pub fn user(
    client: &impl crate::client_trait::UserAuthClient,
    arg: &EchoArg,
) -> crate::Result<Result<EchoResult, crate::NoError>> {
    crate::client_helpers::request(
        client,
        crate::client_trait::Endpoint::Api,
        crate::client_trait::Style::Rpc,
        "check/user",
        arg,
        None)
}

/// EchoArg contains the arguments to be sent to the Dropbox servers.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EchoArg {
    /// The string that you'd like to be echoed back to you.
    pub query: String,
}

impl Default for EchoArg {
    fn default() -> Self {
        EchoArg {
            query: String::new(),
        }
    }
}

impl EchoArg {
    pub fn with_query(mut self, value: String) -> Self {
        self.query = value;
        self
    }
}

const ECHO_ARG_FIELDS: &[&str] = &["query"];
impl EchoArg {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EchoArg, V::Error> {
        let mut field_query = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "query" => {
                    if field_query.is_some() {
                        return Err(::serde::de::Error::duplicate_field("query"));
                    }
                    field_query = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = EchoArg {
            query: field_query.unwrap_or_else(String::new),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("query", &self.query)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EchoArg {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EchoArg;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EchoArg struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EchoArg::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EchoArg", ECHO_ARG_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EchoArg {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EchoArg", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

/// EchoResult contains the result returned from the Dropbox servers.
#[derive(Debug, Clone, PartialEq)]
#[non_exhaustive] // structs may have more fields added in the future.
pub struct EchoResult {
    /// If everything worked correctly, this would be the same as query.
    pub result: String,
}

impl Default for EchoResult {
    fn default() -> Self {
        EchoResult {
            result: String::new(),
        }
    }
}

impl EchoResult {
    pub fn with_result(mut self, value: String) -> Self {
        self.result = value;
        self
    }
}

const ECHO_RESULT_FIELDS: &[&str] = &["result"];
impl EchoResult {
    // no _opt deserializer
    pub(crate) fn internal_deserialize<'de, V: ::serde::de::MapAccess<'de>>(
        mut map: V,
    ) -> Result<EchoResult, V::Error> {
        let mut field_result = None;
        while let Some(key) = map.next_key::<&str>()? {
            match key {
                "result" => {
                    if field_result.is_some() {
                        return Err(::serde::de::Error::duplicate_field("result"));
                    }
                    field_result = Some(map.next_value()?);
                }
                _ => {
                    // unknown field allowed and ignored
                    map.next_value::<::serde_json::Value>()?;
                }
            }
        }
        let result = EchoResult {
            result: field_result.unwrap_or_else(String::new),
        };
        Ok(result)
    }

    pub(crate) fn internal_serialize<S: ::serde::ser::Serializer>(
        &self,
        s: &mut S::SerializeStruct,
    ) -> Result<(), S::Error> {
        use serde::ser::SerializeStruct;
        s.serialize_field("result", &self.result)
    }
}

impl<'de> ::serde::de::Deserialize<'de> for EchoResult {
    fn deserialize<D: ::serde::de::Deserializer<'de>>(deserializer: D) -> Result<Self, D::Error> {
        // struct deserializer
        use serde::de::{MapAccess, Visitor};
        struct StructVisitor;
        impl<'de> Visitor<'de> for StructVisitor {
            type Value = EchoResult;
            fn expecting(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
                f.write_str("a EchoResult struct")
            }
            fn visit_map<V: MapAccess<'de>>(self, map: V) -> Result<Self::Value, V::Error> {
                EchoResult::internal_deserialize(map)
            }
        }
        deserializer.deserialize_struct("EchoResult", ECHO_RESULT_FIELDS, StructVisitor)
    }
}

impl ::serde::ser::Serialize for EchoResult {
    fn serialize<S: ::serde::ser::Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        // struct serializer
        use serde::ser::SerializeStruct;
        let mut s = serializer.serialize_struct("EchoResult", 1)?;
        self.internal_serialize::<S>(&mut s)?;
        s.end()
    }
}

