# drm-fourcc

[![Crates.io](https://img.shields.io/crates/v/drm-fourcc)](https://crates.io/crates/drm-fourcc)
![MIT Licensed](https://img.shields.io/crates/l/drm-fourcc)

Provides an enums representing every pixel format and format modifier supported
by DRM (as of kernel version 5.10.0).

A [fourcc][fourcc_wiki] is four bytes of ascii representing some data format. This enum contains
every fourcc representing a pixel format supported by [DRM][drm_wiki], the Linux Direct
Rendering Manager.

To get the bytes of the fourcc representing the format, cast to `u32`.

```rust
assert_eq!(DrmFourcc::Xrgb8888 as u32, 875713112);
```

To get the string form of the fourcc, use [`DrmFourcc::string_form`].

```rust
assert_eq!(DrmFourcc::Xrgb8888.string_form(), "XR24");
```

We also provide a type for representing a fourcc/modifier pair

```rust
let format = DrmFormat {
    code: DrmFourcc::Xrgb8888,
    modifier: DrmModifier::Linear,
};
```

The enums are autogenerated from the [canonical list][canonical] in the Linux source code.

## Contributors

- [Daniel Franklin](https://github.com/danielzfranklin)
- [Victor Brekenfeld](https://github.com/Drakulix)

[fourcc_wiki]: https://en.wikipedia.org/wiki/FourCC
[drm_wiki]: https://en.wikipedia.org/wiki/Direct_Rendering_Managerz
[canonical]: https://github.com/torvalds/linux/blame/master/include/uapi/drm/drm_fourcc.h
