pub mod lgt92;
pub mod decoder_1_6_7;

#[cfg(test)]
mod decode_tests {
    use bytes::Bytes;

    use crate::{lgt92::{Alarm, LGT92}, decoder_1_6_7 as decoder};

    #[test]
    fn decode() {
	static FIRST_EXAMPLE: [u8; 15] = [0xFE, 0x7B, 0xB0, 0x83,
					  0xFD, 0x10, 0x34, 0xD3,
					  0x0C, 0x06,
					  0x04,
					  0x23, 0x53,
					  0x01, 0x0];

	let b = Bytes::from(&FIRST_EXAMPLE[..]);
	let p: LGT92 = decoder::decode(&b);

	assert_eq!(p.latitude, -25.448317);
	assert_eq!(p.longitude, -49.269547);
	assert_eq!(p.alarm, Alarm::Off);
	assert_eq!(p.battery, 3.078);
	assert_eq!(p.roll, 90.43);
	assert_eq!(p.pitch, 2.56);
    }
}
